/* <xaballdef.h>
 *
 *	RMS allocation XAB definitions
 */
#ifndef _XABALLDEF_H
#define _XABALLDEF_H

#define XAB$C_ALL	20	/* xaball ID code */
#define XAB$V_HRD	0
#define XAB$V_ONC	1
#define XAB$V_CBT	5
#define XAB$V_CTG	7
#define XAB$M_HRD	(1<<XAB$V_HRD)		/* 0x01 */
#define XAB$M_ONC	(1<<XAB$V_ONC)		/* 0x02 */
#define XAB$M_CBT	(1<<XAB$V_CBT)		/* 0x20 */
#define XAB$M_CTG	(1<<XAB$V_CTG)		/* 0x80 */
#define XAB$C_ANY	0	/* any allocation o.k. */
#define XAB$C_CYL	1	/* cylinder boundary */
#define XAB$C_LBN	2	/* allocate at specified lbn */
#define XAB$C_VBN	3	/* allocate near specified vbn */
#define XAB$C_RFI	4	/* allocate near related file */
#define XAB$K_ALLLEN	32	/* length of xaball */
#define XAB$C_ALLLEN	32

struct XABALL {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned char  xab$b_aop;		/* allocation options */
    unsigned char  xab$b_aln;		/* alignment type */
    unsigned short xab$w_vol;		/* relative volume no. for allocation */
    unsigned long  xab$l_loc;		/* allocation location */
    unsigned long  xab$l_alq;		/* allocation quantity */
    unsigned short xab$w_deq;		/* default allocation quantity */
    unsigned char  xab$b_bkz;		/* bucket size for area */
    unsigned char  xab$b_aid;		/* area id number */
    unsigned short xab$w_rfi[3];	/* related file id */
	unsigned : 16;			/* (spare) */
};

struct xaballdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    union {
	unsigned char xab$b_aop;	/* allocation options */
	struct {
	    unsigned xab$v_hrd : 1;	/* fail if requested alignment impossible */
	    unsigned xab$v_onc : 1;	/* locate allocated space within a cylinder */
	    unsigned	       : 3;	/* (spares) */
	    unsigned xab$v_cbt : 1;	/* contiguous alllocation, best try */
	    unsigned	       : 1;	/* spare */
	    unsigned xab$v_ctg : 1;	/* contiguous allocation */
	} xab$r_aop_bits;
    } xab$r_aop_overlay;
    unsigned char xab$b_aln;		/* alignment type */
    unsigned short xab$w_vol;		/* relative volume no. for allocation	*/
					/* (not applicable if aln = vbn or rfi) */
    unsigned long xab$l_loc;		/* allocation location */
    unsigned long xab$l_alq;		/* allocation quantity */
    unsigned short xab$w_deq;		/* default allocation quantity */
    unsigned char xab$b_bkz;		/* bucket size for area */
    unsigned char xab$b_aid;		/* area id number */
    union {
	unsigned short xab$w_rfi[3];	/* related file id */
	struct {
	    unsigned short xab$w_rfi0;	/* file number */
	    unsigned short xab$w_rfi2;	/* seq number */
	    unsigned short xab$w_rfi4;	/* rev number */
	} xab$r_rfi_fields;
    } xab$r_rfi_overlay;
    unsigned	: 16;			/* short fill; (spare) */
};

/* declare initialized prototype data structure */
extern struct XABALL cc$rms_xaball __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xaball");
/* globalref struct XABALL cc$rms_xaball; */

#endif	/*_XABALLDEF_H*/
