/* <xabcxfdef.h>
 *
 *	RMS context XAB associated with FAB
 */
#ifndef _XABCXFDEF_H
#define _XABCXFDEF_H

#define XAB$C_CXF	32	/* xabcxf ID code */
#define XAB$V_CXFRST	0
#define XAB$M_CXFRST	(1<<XAB$V_CXFRST)	/* 0x01 */
#define XAB$K_CXFLEN	60	/* length of xab type CXF */
#define XAB$C_CXFLEN	60

struct XABCXF {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned long  xab$l_cxfsts;	/* status of last file operation */
    unsigned long  xab$l_cxfstv;	/* status value of last file operation */
    unsigned long  xab$l_cxfcop;	/* context options */
    unsigned long  xab$l_cxfbkp;	/* bookkeeping bits */
    unsigned short xab$w_cxfifi;	/* internal file identifier */
    unsigned char  xab$b_cxfver;	/* prologue version num */
	unsigned : 8;			/* spare to longword align commonality */
	unsigned : 32;			/* spare */
    unsigned short xab$w_cxfdeq;	/* default extention quantity */
    unsigned char  xab$b_cxffac;	/* file access */
    unsigned char  xab$b_cxfshr;	/* file sharing */
    unsigned short xab$w_cxfrte;	/* (not used) */
	unsigned : 8;			/* spare */
    unsigned char  xab$b_cxforg;	/* file organization */
    unsigned short xab$w_cxfgbc;	/* global buffer count */
    unsigned char  xab$b_cxfrtv;	/* retrieval window */
	unsigned : 8;
	unsigned : 32, : 32, : 32, : 32;	/*long[4]*/
};

struct xabcxfdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    unsigned long xab$l_cxfsts;		/* status of last file operation */
    unsigned long xab$l_cxfstv;		/* status value of last file operation */
/*
   Top four bits of the options longword are reserved for the XABCXR.  These
   bits describe the version of the key buffer.
 */
    union {
	unsigned long xab$l_cxfcop;	/* context options */
	struct {
	    unsigned xab$v_cxfrst : 1;	/* restore file state - use context blk as input */
	    unsigned		  : 7;
	} xab$r_cxfcop_bits;
    } xab$r_cxfcop_overlay;
    unsigned long xab$l_cxfbkp;		/* bookkeeping bits */
    unsigned short xab$w_cxfifi;	/* internal file identifier */
    unsigned char xab$b_cxfver;		/* prologue version num */
    unsigned	: 8;			/* char fill; spare for alignment */
    unsigned	: 32;			/* long fill; spare */
 /* the following fields correspond to those in the FAB or IFB */
    unsigned short xab$w_cxfdeq;	/* default extention quantity */
    unsigned char xab$b_cxffac;		/* file access */
    unsigned char xab$b_cxfshr;		/* file sharing */
    unsigned short xab$w_cxfrte;	/* (not used) */
    unsigned	: 8;			/* char fill; spare */
    unsigned char xab$b_cxforg;		/* file organization */
    unsigned short xab$w_cxfgbc;	/* global buffer count */
    unsigned char xab$b_cxfrtv;		/* retrieval window */
    unsigned	: 8;			/* char fill; */
    unsigned	: 32, : 32, : 32, : 32; /* long fill[4]; spares */
};

#if 0	/* there's no FAB context xab prototype available */
/* declare initialized prototype data structure */
extern struct XABCXF cc$rms_xabcxf __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabcxf");
/* globalref struct XABCXF cc$rms_xabcxf; */
#endif

#endif	/*_XABCXFDEF_H*/
