/* <xabcxrdef.h>
 *
 *	RMS context XAB associated with RAB
 */
#ifndef _XABCXRDEF_H
#define _XABCXRDEF_H

#define XAB$C_CXR	33	/* xabcxr ID code */
#define XAB$V_CXRRST	0
#define XAB$M_CXRRST	(1<<XAB$V_CXRRST)	/* 0x01 */
#define XAB$C_CXB_VER1	1
#define XAB$C_CXRBLEN	512	/* length of CXRBUF (bytes) */
#define XAB$K_CXRLEN	84	/* length of XAB type CXR */
#define XAB$C_CXRLEN	84

struct XABCXR {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned long  xab$l_cxrsts;	/* status of last record operation */
    unsigned long  xab$l_cxrstv;	/* status value of last record operation */
    unsigned long  xab$l_cxrcop;	/* context options */
    unsigned long  xab$l_cxrbkp;	/* bookkeeping bits */
    unsigned short xab$w_cxrisi;	/* internal record identifier */
    unsigned char  xab$b_cxrver;	/* prologue version num. */
	unsigned : 8;			/* spare to longword align commonality */
	unsigned : 32;			/* spare */
/* the following elements are stream dependent regardless of file org */
    unsigned char  xab$b_cxrmbf;	/* multibuffer count */
    unsigned char  xab$b_cxrmbc;	/* multiblock count */
    unsigned short xab$w_cxrbfz;	/* size in bytes of CXRBUF */
/* the following are for saving NRP context for Sequential and Relative files */
    unsigned long  xab$l_cxrvbn;	/* NRP VBN */
    unsigned short xab$w_cxroff;	/* NRP offset in VBN */
	unsigned : 16;			/* mbz - longword align */
/* the following are for saving NRP context for ISAM files */
    unsigned long  xab$l_cxrpos0;	/* primary positioning RFA */
    unsigned short xab$w_cxrpos4;
	unsigned : 16;			/* spare MBZ */
    unsigned long  xab$l_cxrcur0;	/* current positioning RFA */
    unsigned short xab$w_cxrcur4;
	unsigned : 16;			/* spare MBZ */
    unsigned long  xab$l_cxrsid0;	/* SIDR positioning RFA */
    unsigned short xab$w_cxrsid4;
	unsigned : 16;			/* spare MBZ */
    unsigned short xab$w_cxrcnt;	/* SIDR array count */
    unsigned char  xab$b_cxrkref;	/* cur key of reference */
    unsigned char  xab$b_cxrklen;	/* length of key */
    unsigned long xab$l_cxrbuf;		/* address of key buf */
	unsigned : 32, : 32;		/* spares */
};

struct xabcxrdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    unsigned long xab$l_cxrsts;		/* status of last record operation */
    unsigned long xab$l_cxrstv;		/* status value of last record operation */
    union {
	unsigned long xab$l_cxrcop;	/* context options */
	struct {
	    unsigned xab$v_cxrrst  : 1; /* restore file/record state - use context blk as input */
	    unsigned		   : 27;
	    unsigned xab$v_cxrbver : 4; /* version of key buffer */
	} xab$r_cxrcop_bits;
    } xab$r_cxrcop_overlay;
    unsigned long xab$l_cxrbkp;		/* bookkeeping bits */
    unsigned short xab$w_cxrisi;	/* internal record identifier */
    unsigned char xab$b_cxrver;		/* prologue version num. */
    unsigned	: 8;			/* char fill; alignment */
    unsigned	: 32;			/* long fill; spare */
/* the following elements are stream dependent regardless of file org */
    unsigned char xab$b_cxrmbf;		/* multibuffer count */
    unsigned char xab$b_cxrmbc;		/* multiblock count */
    unsigned short xab$w_cxrbfz;	/* size in bytes of CXRBUF */
/* the following are for saving NRP context for Sequential and Relative files */
    unsigned long xab$l_cxrvbn;		/* NRP VBN */
    unsigned short xab$w_cxroff;	/* NRP offset in VBN */
    unsigned	: 16;			/* short fill; mbz - longword align */
/* the following are for saving NRP context for ISAM files */
    unsigned long xab$l_cxrpos0;	/* primary positioning RFA */
    unsigned short xab$w_cxrpos4;
    unsigned	: 16;			/* short fill; spare MBZ */
    unsigned long xab$l_cxrcur0;	/* current positioning RFA */
    unsigned short xab$w_cxrcur4;
    unsigned	: 16;			/* short fill; spare MBZ */
    unsigned long xab$l_cxrsid0;	/* SIDR positioning RFA */
    unsigned short xab$w_cxrsid4;
    unsigned	: 16;			/* short fill; spare MBZ */
    unsigned short xab$w_cxrcnt;	/* SIDR array count */
    unsigned char xab$b_cxrkref;	/* cur key of reference */
    unsigned char xab$b_cxrklen;	/* length of key */
    unsigned long xab$l_cxrbuf;		/* address of key buf */
    unsigned	: 32, : 32;		/* long fill[2]; spares */
};

#if 0	/* there's no RAB context xab prototype available */
/* declare initialized prototype data structure */
extern struct XABCXR cc$rms_xabcxr __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabcxr");
/* globalref struct XABCXR cc$rms_xabcxr; */
#endif

#endif	/*_XABCXRDEF_H*/
