/* <xabdatdef.h>
 *
 *	RMS date/time XAB definitions
 */
#ifndef _XABDATDEF_H
#define _XABDATDEF_H

#define XAB$C_DAT	18	/* xabdat ID code */
#define XAB$K_DATLEN_V2 36	/* version 2 XABDAT length */
#define XAB$C_DATLEN_V2 36
#ifndef NO_VMS_V6
#define XAB$K_DATLEN_V54 44	/* version 5.4 XABDAT length */
#define XAB$C_DATLEN_V54 44
#define XAB$K_DATLEN_V60 60	/* version 6.0 XABDAT length */
#define XAB$C_DATLEN_V60 60
#endif
#define XAB$K_DATLEN	(sizeof (struct XABDAT))
#define XAB$C_DATLEN	XAB$K_DATLEN

#define __XABDAT_FIELDS		\
    unsigned char  xab$b_cod;		/* xab ID code */		\
    unsigned char  xab$b_bln;		/* block length */		\
	unsigned : 16;			/* (filler) */			\
    void	  *xab$l_nxt;		/* xab chain link */		\
    unsigned short xab$w_rvn;		/* revision number */		\
	unsigned : 16;			/* spare */			\
    unsigned long xab$q_rdt[2];		/* revision date & time */	\
    unsigned long xab$q_cdt[2];		/* creation date & time */	\
    unsigned long xab$q_edt[2];		/* expiration date & time */	\
 /*- end of v20 XABDAT -*/						\
    unsigned long xab$q_bdt[2];		/* backup date and time */	\
 /*- end of v54 XABDAT -*/

#define __XABDAT_XTRA_FIELDS	\
    unsigned long xab$q_rcd[2];		/* recorded date and time */	\
    unsigned long xab$q_eff[2];		/* effective date and time */	\
 /*- end of v60 XABDAT -*/

struct XABDAT {
__XABDAT_FIELDS
#ifdef ONLY_VMS_V6
__XABDAT_XTRA_FIELDS
#endif
};

#ifndef NO_VMS_V6
struct XABDAT_V54 {
__XABDAT_FIELDS
};

struct XABDAT_V60 {
__XABDAT_FIELDS
__XABDAT_XTRA_FIELDS
};
#endif	/*!NO_VMS_V6*/

#undef __XABDAT_FIELDS
#undef __XABDAT_XTRA_FIELDS

struct xabdatdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    unsigned short xab$w_rvn;		/* revision no. (common to $xabrdt) */
    unsigned	: 16;			/* short fill; spare */
    union {
	long xab$q_rdt[2];		/* revision date & time */
	struct {
	    unsigned long xab$l_rdt0;
	    long xab$l_rdt4;
	} xab$r_rdt_fields;
    } xab$r_rdt_overlay;
    union {
	long xab$q_cdt[2];		/* creation date & time */
	struct {
	    unsigned long xab$l_cdt0;
	    long xab$l_cdt4;
	} xab$r_cdt_fields;
    } xab$r_cdt_overlay;
    union {
	long xab$q_edt[2];		/* expiration date & time */
	struct {
	    unsigned long xab$l_edt0;
	    long xab$l_edt4;
	} xab$r_edt_fields;
    } xab$r_edt_overlay;
 /*- end of v20 XABDAT -*/
    union {
	long xab$q_bdt[2];		/* backup date and time */
	struct {
	    unsigned long xab$l_bdt0;
	    long xab$l_bdt4;
	} xab$r_bdt_fields;
    } xab$r_bdt_overlay;
 /*- end of v54 XABDAT -*/
#ifndef NO_VMS_V6
    union {
	long xab$q_rcd[2];		/* recorded date and time */
	struct {
	    unsigned long xab$l_rcd0;
	    long xab$l_rcd4;
	} xab$r_rcd_fields;
    } xab$r_rcd_overlay;
    union {
	long xab$q_eff[2];		/* effective date and time */
	struct {
	    unsigned long xab$l_eff0;
	    long xab$l_eff4;
	} xab$r_eff_fields;
    } xab$r_eff_overlay;
#endif	/*!NO_VMS_V6*/
};

/* declare initialized prototype data structure */
extern struct XABDAT cc$rms_xabdat __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabdat");
/* globalref struct XABDAT cc$rms_xabdat; */

#ifndef NO_VMS_V6
/*
***
   Note well!!!
***
   Normal use of cc$rms_xabdat has become very dangerous, because there's
   no way to tell whether the C run-time library has created it using the
   old definition of XABDAT or the new one without examining its length
   field, which isn't practical for use as a static initializer.  If it
   is created using the old definition, but here we tell the compiler that
   it has the size and shape of the new structure, then when using it as
   an initializer, 16 bytes of arbitrary garbage will be copied into the
   last two fields--assuming an access violation is not triggered, that is.
***
 */
#endif	/*!NO_VMS_V6*/

#endif	/*_XABDATDEF_H*/
