/* <xabdef.h>
 *
 *	RMS extended attribute block (XAB) definitions, common to all XABs
 */
#ifndef _XABDEF_H
#define _XABDEF_H

/* the first four fields are shared in common between all XABs */
struct XAB {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (spare) */
    void	  *xab$l_nxt;		/* xab chain link */
};

struct xabdef {
    unsigned char xab$b_cod;		/* xab ID code */
    unsigned char xab$b_bln;		/* block length */
    unsigned	: 16;			/* short fill; (spare) */
    void *xab$l_nxt;			/* xab chain link */

    unsigned short xab$w_rvn;
    unsigned	: 16;			/* short fill; */
    unsigned long xab$q_rdt[2];		/* common to DAT and RDT xabs */
};

struct xabdef1 {			/*(this is useless)*/
    char  xabdef$$_fill_3[8];

    char  xabdef$$_fill_4;
    char  xabdef$$_fill_5;
    short xabdef$$_fill_6;
    long  xabdef$$_fill_7;
    long  xabdef$$_fill_8;

    short xabdef$$_fill_9;
    unsigned char xab$b_bkz;		/* common to fhc and alq xabs */
    unsigned	: 8;			/* pad to sensible size */
};
#define XAB$C_CXT_VER1	1	/* RMS Context Extraction version 1 */

#endif	/*_XABDEF_H*/
