/* <xabfhcdef.h>
 *
 *	RMS file header characteristics xab definitions
 */
#ifndef _XABFHCDEF_H
#define _XABFHCDEF_H

#define XAB$C_FHC	29	/* xabfhc ID code */
#define XAB$V_FTN	0
#define XAB$V_CR	1
#define XAB$V_PRN	2
#define XAB$V_BLK	3
#define XAB$M_FTN	(1<<XAB$V_FTN)		/* 0x01 */
#define XAB$M_CR	(1<<XAB$V_CR)		/* 0x02 */
#define XAB$M_PRN	(1<<XAB$V_PRN)		/* 0x04 */
#define XAB$M_BLK	(1<<XAB$V_BLK)		/* 0x08 */
#define XAB$K_FHCLEN	44	/* length of xabfhc */
#define XAB$C_FHCLEN	44

struct XABFHC {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned char  xab$b_rfo;		/* record format and file org */
    unsigned char  xab$b_atr;		/* record attributes */
    unsigned short xab$w_lrl;		/* longest record's length */
    unsigned long  xab$l_hbk;		/* hi vbn allocated (n.b. reversed on disk!) */
    unsigned long  xab$l_ebk;		/* eof vbn (n.b. reversed on disk) */
    unsigned short xab$w_ffb;		/* first free byte in eof block */
    unsigned char  xab$b_bkz;		/* bucket size */
    unsigned char  xab$b_hsz;		/* header size for vfc */
    unsigned short xab$w_mrz;		/* max record size */
    unsigned short xab$w_dxq;		/* default extend quantity */
    unsigned short xab$w_gbc;		/* global buffer count */
	unsigned : 32, : 32;		/* spares (pad to last word) */
    unsigned short xab$w_verlimit;	/* version limit for file. */
 /*- end of old XABFHC -*/
    unsigned long  xab$l_sbn;		/* starting lbn if contiguous */
};

struct xabfhcdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    unsigned char xab$b_rfo;		/* record format and file org */
    union {
	unsigned char xab$b_atr;	/* record attributes */
	struct {
	    unsigned xab$v_ftn : 1;	/* fortran carriage-ctl */
	    unsigned xab$v_cr  : 1;	/* lf-record-cr carriage ctl */
	    unsigned xab$v_prn : 1;	/* print-file carriage ctl */
	    unsigned xab$v_blk : 1;	/* records don't cross block boundaries */
	    unsigned	       : 4;
	} xab$r_atr_bits;
    } xab$r_atr_overlay;
    unsigned short xab$w_lrl;		/* longest record's length */
    union {
	unsigned long xab$l_hbk;	/* hi vbn allocated (n.b. reversed on disk!) */
	struct {
	    unsigned short xab$w_hbk0;
	    unsigned short xab$w_hbk2;
	} xab$r_hbk_fields;
    } xab$r_hbk_overlay;
    union {
	unsigned long xab$l_ebk;	/* eof vbn (n.b. reversed on disk) */
	struct {
	    unsigned short xab$w_ebk0;
	    unsigned short xab$w_ebk2;
	} xab$r_ebk_fields;
    } xab$r_ebk_overlay;
    unsigned short xab$w_ffb;		/* first free byte in eof block */
    unsigned char xab$b_bkz;		/* bucket size for fhc (common to $xaball) */
    unsigned char xab$b_hsz;		/* header size for vfc */
    unsigned short xab$w_mrz;		/* max record size */
    unsigned short xab$w_dxq;		/* default extend quantity */
    unsigned short xab$w_gbc;		/* global buffer count */
    unsigned	: 8, : 8, : 8, : 8,	/* char fill[8]; spares (pad to last word) */
		: 8, : 8, : 8, : 8;
    unsigned short xab$w_verlimit;	/* version limit for file. */
 /*- end of old XABFHC -*/
    unsigned long xab$l_sbn;		/* starting lbn if contiguous */
};

/* declare initialized prototype data structure */
extern struct XABFHC cc$rms_xabfhc __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabfhc");
/* globalref struct XABFHC cc$rms_xabfhc; */

#endif	/*_XABFHCDEF_H*/
