/* <xabitmdef.h>
 *
 *	RMS itemlist XAB definitions
 */
#ifndef _XABITMDEF_H
#define _XABITMDEF_H

#define XAB$C_ITM	36	/* xabitm ID code */
/*
   The following set of flags exactly mimic the FCHDEF flags defined in
   STARLET.  They are here to provide an unsupported interface to the UCHAR
   longword maintained by the file system.
*/
#define XAB$V_WASCONTIG 0
#define XAB$V_NOBACKUP	1
#define XAB$V_WRITEBACK 2
#define XAB$V_READCHECK 3
#define XAB$V_WRITCHECK 4
#define XAB$V_CONTIGB	5
#define XAB$V_LOCKED	6
#define XAB$V_CONTIG	7
#define XAB$V_RESERVED1 8
#define XAB$V_RESERVED2 9
#define XAB$V_RESERVED3 10
#define XAB$V_BADACL	11
#define XAB$V_SPOOL	12
#define XAB$V_DIRECTORY 13
#define XAB$V_BADBLOCK	14
#define XAB$V_MARKDEL	15
#define XAB$V_NOCHARGE	16
#define XAB$V_ERASE	17
#ifndef NO_VMS_V6
#define XAB$V_RESERVED4     18
#define XAB$V_SHELVED	    19
#define XAB$V_RESERVED6     20
#define XAB$V_NOMOVE	    21
#define XAB$V_NOSHELVABLE   22
#define XAB$V_SCRATCH_FILE	XAB$V_RESERVED6
#endif
#define XAB$M_WASCONTIG (1<<XAB$V_WASCONTIG)	/* 0x01 */
#define XAB$M_NOBACKUP	(1<<XAB$V_NOBACKUP)	/* 0x02 */
#define XAB$M_WRITEBACK (1<<XAB$V_WRITEBACK)	/* 0x04 */
#define XAB$M_READCHECK (1<<XAB$V_READCHECK)	/* 0x08 */
#define XAB$M_WRITCHECK (1<<XAB$V_WRITCHECK)	/* 0x10 */
#define XAB$M_CONTIGB	(1<<XAB$V_CONTIGB)	/* 0x20 */
#define XAB$M_LOCKED	(1<<XAB$V_LOCKED)	/* 0x40 */
#define XAB$M_CONTIG	(1<<XAB$V_CONTIG)	/* 0x80 */
#define XAB$M_RESERVED1 (1<<XAB$V_RESERVED1)	/* 0x0100 */
#define XAB$M_RESERVED2 (1<<XAB$V_RESERVED2)	/* 0x0200 */
#define XAB$M_RESERVED3 (1<<XAB$V_RESERVED3)	/* 0x0400 */
#define XAB$M_BADACL	(1<<XAB$V_BADACL)	/* 0x0800 */
#define XAB$M_SPOOL	(1<<XAB$V_SPOOL)	/* 0x1000 */
#define XAB$M_DIRECTORY (1<<XAB$V_DIRECTORY)	/* 0x2000 */
#define XAB$M_BADBLOCK	(1<<XAB$V_BADBLOCK)	/* 0x4000 */
#define XAB$M_MARKDEL	(1<<XAB$V_MARKDEL)	/* 0x8000 */
#define XAB$M_NOCHARGE	(1<<XAB$V_NOCHARGE)	/* 0x010000 */
#define XAB$M_ERASE	(1<<XAB$V_ERASE)	/* 0x020000 */
#ifndef NO_VMS_V6
#define XAB$M_RESERVED4     (1<<XAB$V_RESERVED4)	/* 0x040000 */
#define XAB$M_SHELVED	    (1<<XAB$V_SHELVED)		/* 0x080000 */
#define XAB$M_RESERVED6     (1<<XAB$V_RESERVED6)	/* 0x100000 */
#define XAB$M_NOMOVE	    (1<<XAB$V_NOMOVE)		/* 0x200000 */
#define XAB$M_NOSHELVABLE   (1<<XAB$V_NOSHELVABLE)	/* 0x400000 */
 /* temporary file used for MOVEFILE and by ANALYZE/DISK_STRUCTURE/REPAIR */
#define XAB$M_SCRATCH_FILE	XAB$M_RESERVED6
#endif

struct xabitm_uchar_flags {		/* mimics $FCHDEF */
    unsigned xab$v_wascontig : 1;
    unsigned xab$v_nobackup  : 1;
    unsigned xab$v_writeback : 1;
    unsigned xab$v_readcheck : 1;
    unsigned xab$v_writcheck : 1;
    unsigned xab$v_contigb   : 1;
    unsigned xab$v_locked    : 1;
    unsigned xab$v_contig    : 1;
    unsigned xab$v_reserved1 : 1;
    unsigned xab$v_reserved2 : 1;
    unsigned xab$v_reserved3 : 1;
    unsigned xab$v_badacl    : 1;
    unsigned xab$v_spool     : 1;
    unsigned xab$v_directory : 1;
    unsigned xab$v_badblock  : 1;
    unsigned xab$v_markdel   : 1;
    unsigned xab$v_nocharge  : 1;
    unsigned xab$v_erase     : 1;
#ifndef NO_VMS_V6
    unsigned xab$v_reserved4 : 1;
    unsigned xab$v_shelved   : 1;
    unsigned xab$v_reserved6 : 1;
    unsigned xab$v_nomove    : 1;
    unsigned xab$v_noshelvable : 1;
    unsigned		     : 1;
#define xab$v_scratch_file xab$v_reserved6
#else
    unsigned		     : 6;
#endif
    unsigned		     : 8;	/* padding */
};

#define XAB$_NET_BUFFER_SIZE		1	/* (sense) negociated buffer size */
#define XAB$_NET_BLOCK_COUNT		2	/* (set,sense) requested block count */
#define XAB$_NET_REMOTE_SYSTEM		3	/* (sense) remote system type */
#define XAB$_NET_REMOTE_FILE_SYSTEM	4	/* (sense) remote file system type */
#define XAB$_NET_EXTPROT		5	/* (set,sense) actual extended protection */
#define XAB$_NET_SYSCAP_LOCAL		6	/* (sense) DAP SYSCAP of local system */
#define XAB$_NET_SYSCAP_REMOTE		7	/* (sense) DAP SYSCAP of remote system */
#define XAB$_NET_DAPVER_LOCAL		8	/* (sense) DAP version - local system */
#define XAB$_NET_DAPVER_REMOTE		9	/* (sense) DAP version - remote system */
#define XAB$_NET_LINK_TIMEOUT		10	/* (set,sense) logical link timeout (seconds) */
#define XAB$_NET_DATA_CRC_ENABLE	11	/* (set,sense) DAP level CRC */
#define XAB$_NET_LINK_CACHE_ENABLE	12	/* (set,sense) logical link cache enable */
/*	XAB$_NET_DATA_COMPRESSION		\* (set,sense)	do data compression (FUTURE) */
#define XAB$K_NET_MIN	1
#define XAB$K_NET_MAX	12

#define XAB$_STAT_ENABLE	64	/* (set,sense) read statistics enable */
#define XAB$K_STAT_MIN	64
#define XAB$K_STAT_MAX	64

#define XAB$_UCHAR		128	/* (sense) Read file characteristics (obsolete) */
#define XAB$_UCHAR_WASCONTIG	129	/* (sense) FCH$V_WASCONTIG */
#define XAB$_UCHAR_NOBACKUP	130	/* (set,sense) FCH$V_NOBACKUP */
#define XAB$_UCHAR_WRITEBACK	131	/* (sense) FCH$V_WRITEBACK */
#define XAB$_UCHAR_READCHECK	132	/* (set,sense) FCH$V_READCHECK */
#define XAB$_UCHAR_WRITECHECK	133	/* (set,sense) FCH$V_WRITECHECK */
#define XAB$_UCHAR_CONTIGB	134	/* (set,sense) FCH$V_CONTIGB */
#define XAB$_UCHAR_LOCKED	135	/* (set,sense) FCH$V_LOCKED */
#define XAB$_UCHAR_CONTIG	136	/* (sense) FCH$V_CONTIG */
#define XAB$_UCHAR_BADACL	137	/* (sense) FCH$V_BADACL */
#define XAB$_UCHAR_SPOOL	138	/* (sense) FCH$V_SPOOL */
#define XAB$_UCHAR_DIRECTORY	139	/* (sense) FCH$V_DIRECTORY */
#define XAB$_UCHAR_BADBLOCK	140	/* (sense) FCH$V_BADBLOCK */
#define XAB$_UCHAR_MARKDEL	141	/* (sense) FCH$V_BADBLOCK */
#define XAB$_UCHAR_NOCHARGE	142	/* (sense) FCH$V_NOCHARGE */
#define XAB$_UCHAR_ERASE	143	/* (set,sense) FCH$V_ERASE */
#ifndef NO_VMS_V6
#define XAB$_UCHAR_NOMOVE	144	/* (set,sense) FCH$V_NOMOVE */
#define XAB$_UCHAR_SHELVED	145	/* (sense) FCH$V_SHELVED */
#define XAB$_UCHAR_NOSHELVABLE	146	/* (set,sense) FCH$V_NOSHELVABLE */
#endif
#define XAB$K_UCHAR_MIN 128
#ifndef NO_VMS_V6
#define XAB$K_UCHAR_MAX 146
#else
#define XAB$K_UCHAR_MAX 143
#endif

#define XAB$_STORED_SEMANTICS	192	/* (set,sense) Stored semantics of the file */
#define XAB$_ACCESS_SEMANTICS	193	/* (set,sense) Access semantics of the file */
#define XAB$_RMS_EXTENSION	194	/* (set,sense) Required RMS processing extension */
#define XAB$K_XLATE_MIN 192
#define XAB$K_XLATE_MAX 194
#define XAB$C_SEMANTICS_MAX_LEN 64	/* max length for stored or access semantics */
#define XAB$K_SEMANTICS_MAX_LEN 64	/* max length for stored or access semantics */

#define XAB$_MULTIBUFFER_COUNT	256	/* (set-only) multibuffer count (not limited to 127) legal only on $CONNECT */
#define XAB$_NORECORD		257	/* (set-only) norecord suppresses update of the expiration d/t, passed in on $OPEN or $CLOSE */
#define XAB$_RECOVERY		258	/* used to indicate type of recovery in progress. */
#define XAB$_RUJVOLNAM		259	/* used to control RUJ placement */
#define XAB$K_MISC_MIN	256
#define XAB$K_MISC_MAX	259

#define XAB$_TID		320	/* (set/sense) TID */
#define XAB$K_TID_MIN	320
#define XAB$K_TID_MAX	320

#define XAB$K_SENSEMODE 1
#define XAB$K_SETMODE	2
#define XAB$K_ITMLEN	32	/* xabitm length */
#define XAB$C_ITMLEN	32

struct XABITM {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    void	  *xab$l_itemlist;	/* address of the item list */
    unsigned char  xab$b_mode;		/* must be either SETMODE or SENSEMODE */
	unsigned : 24;			/* reserved */
	unsigned : 32, : 32, : 32, : 32;	/*long[4]*/
};

struct xabitmdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    void *xab$l_itemlist;		/* address of the item list */
    unsigned char xab$b_mode;		/* must be either SETMODE or SENSEMODE */
    unsigned	: 8, : 8, : 8;		/* char fill[3]; reserved */
    unsigned	: 32, : 32, : 32, : 32; /* long fill[4]; reserved */
};

/* The following set of flags mimic the IFB$B_RECVRFLGS flags.	*/
/* They are here to provide an interface for RECOVER.		*/
#define XAB$V_RCF_RU	0
#define XAB$V_RCF_AI	1
#define XAB$V_RCF_BI	2
#define XAB$V_RCF_NOPAD 3
#define XAB$M_RCF_RU	(1<<XAB$V_RCF_RU)	/* 0x01 */
#define XAB$M_RCF_AI	(1<<XAB$V_RCF_AI)	/* 0x02 */
#define XAB$M_RCF_BI	(1<<XAB$V_RCF_BI)	/* 0x04 */
#define XAB$M_RCF_NOPAD (1<<XAB$V_RCF_NOPAD)	/* 0x08 */
struct xab_rcf_flags {
    unsigned xab$v_rcf_ru    : 1;
    unsigned xab$v_rcf_ai    : 1;
    unsigned xab$v_rcf_bi    : 1;
    unsigned xab$v_rcf_nopad : 1;
    unsigned		     : 4;
};

#define XAB$K_DISABLE	0
#define XAB$K_ENABLE	1
#define XAB$K_RT11	1
#define XAB$K_RSTS	2
#define XAB$K_RSX11S	3
#define XAB$K_RSX11M	4
#define XAB$K_RSX11D	5
#define XAB$K_IAS	6
#define XAB$K_VAXVMS	7
#define XAB$K_TOPS20	8
#define XAB$K_TOPS10	9
#define XAB$K_RTS8	10
#define XAB$K_OS8	11
#define XAB$K_RSX11MP	12
#define XAB$K_COPOS11	13
#define XAB$K_P_OS	14
#define XAB$K_VAXELN	15
#define XAB$K_CPM	16
#define XAB$K_MS_DOS	17
#define XAB$K_ULTRIX_32 18
#define XAB$K_ULTRIX_11 19
#define XAB$K_RMS11	1
#define XAB$K_RMS20	2
#define XAB$K_RMS32	3
#define XAB$K_FCS11	4
#define XAB$K_RT11FS	5
#define XAB$K_NO_FS	6
#define XAB$K_TOPS20FS	7
#define XAB$K_TOPS10FS	8
#define XAB$K_OS8FS	9
#define XAB$K_RMS32S	10
#define XAB$K_CPMFS	11
#define XAB$K_MS_DOSFS	12
#define XAB$K_ULTRIX32_FS 13
#define XAB$K_ULTRIX11_FS 14

#define XAB$V_NET_NOREAD	0
#define XAB$V_NET_NOWRITE	1
#define XAB$V_NET_NOEXECUTE	2
#define XAB$V_NET_NODELETE	3
#define XAB$V_NET_NOAPPEND	4
#define XAB$V_NET_NODIRECTORY	5
#define XAB$V_NET_NOUPDATE	6
#define XAB$V_NET_NOCHANGE	7
#define XAB$V_NET_NOEXTEND	8
#define XAB$M_NET_NOREAD	(1<<XAB$V_NET_NOREAD)		/* 0x01 */
#define XAB$M_NET_NOWRITE	(1<<XAB$V_NET_NOWRITE)		/* 0x02 */
#define XAB$M_NET_NOEXECUTE	(1<<XAB$V_NET_NOEXECUTE)	/* 0x04 */
#define XAB$M_NET_NODELETE	(1<<XAB$V_NET_NODELETE)		/* 0x08 */
#define XAB$M_NET_NOAPPEND	(1<<XAB$V_NET_NOAPPEND)		/* 0x10 */
#define XAB$M_NET_NODIRECTORY	(1<<XAB$V_NET_NODIRECTORY)	/* 0x20 */
#define XAB$M_NET_NOUPDATE	(1<<XAB$V_NET_NOUPDATE)		/* 0x40 */
#define XAB$M_NET_NOCHANGE	(1<<XAB$V_NET_NOCHANGE)		/* 0x80 */
#define XAB$M_NET_NOEXTEND	(1<<XAB$V_NET_NOEXTEND)		/* 0x0100 */
struct xabnetextprot {
    unsigned short xab$w_system_acc;
    unsigned short xab$w_owner_acc;
    unsigned short xab$w_group_acc;
    unsigned short xab$w_world_acc;
};

struct xabnetdapver {
    unsigned char xab$b_ver_dap;
    unsigned char xab$b_ver_eco;
    unsigned char xab$b_ver_cus;
    unsigned char xab$b_ver_dsv;
    unsigned char xab$b_ver_csv;
};

struct xabnetcapdef {
    unsigned xab$v_cap_filall	: 1;
    unsigned xab$v_cap_seqorg	: 1;
    unsigned xab$v_cap_relorg	: 1;
    unsigned			: 1;
    unsigned xab$v_cap_extend	: 1;
    unsigned xab$v_cap_seqfil	: 1;
    unsigned xab$v_cap_ranrrn	: 1;
    unsigned xab$v_cap_ranvbn	: 1;
    unsigned xab$v_cap_rankey	: 1;
    unsigned			: 1;
    unsigned xab$v_cap_ranrfa	: 1;
    unsigned xab$v_cap_idxorg	: 1;
    unsigned xab$v_cap_swmode	: 1;
    unsigned xab$v_cap_append	: 1;
    unsigned xab$v_cap_submit	: 1;
    unsigned			: 1;
    unsigned xab$v_cap_mds	: 1;
    unsigned xab$v_cap_display	: 1;
    unsigned xab$v_cap_msgblk	: 1;
    unsigned xab$v_cap_unrblk	: 1;
    unsigned xab$v_cap_bigblk	: 1;
    unsigned xab$v_cap_dapcrc	: 1;
    unsigned xab$v_cap_keyxab	: 1;
    unsigned xab$v_cap_allxab	: 1;
    unsigned xab$v_cap_sumxab	: 1;
    unsigned xab$v_cap_directory: 1;
    unsigned xab$v_cap_timxab	: 1;
    unsigned xab$v_cap_proxab	: 1;
    unsigned			: 1;
    unsigned xab$v_cap_fopspl	: 1;
    unsigned xab$v_cap_fopscf	: 1;
    unsigned xab$v_cap_fopdlt	: 1;
 /* */
    unsigned			: 1;
    unsigned xab$v_cap_seqrac	: 1;
    unsigned			: 1;
    unsigned xab$v_cap_bitopt	: 1;
    unsigned xab$v_cap_warning	: 1;
    unsigned xab$v_cap_rename	: 1;
    unsigned xab$v_cap_wildcard : 1;
    unsigned xab$v_cap_gngopt	: 1;
    unsigned xab$v_cap_nammsg	: 1;
    unsigned xab$v_cap_segmsg	: 1;
    unsigned xab$v_cap_chgattcls: 1;
    unsigned xab$v_cap_chgtimcls: 1;
    unsigned xab$v_cap_chgprocls: 1;
    unsigned xab$v_cap_chgnamcls: 1;
    unsigned xab$v_cap_modattcre: 1;
    unsigned xab$v_cap_nam3part : 1;
    unsigned xab$v_cap_chgattren: 1;
    unsigned xab$v_cap_chgtimren: 1;
    unsigned xab$v_cap_chgproren: 1;
    unsigned xab$v_cap_ctlblkcnt: 1;
    unsigned xab$v_cap_octalver : 1;
    unsigned			: 3;
    unsigned			: 8;	/* padding */
};
#define XAB$S_BUFFER_SIZE	4
#define XAB$S_NETWORK_BLOCK_COUNT 4
#define XAB$S_REMOTE_SYSTEM	4
#define XAB$S_REMOTE_FILE_SYSTEM 4
#define XAB$S_EXTPROT_LOCAL	8
#define XAB$S_EXTPROT_REMOTE	8
#define XAB$S_CAPABIL_LOCAL	8
#define XAB$S_CAPABIL_REMOTE	8
#define XAB$S_DAPVER_LOCAL	5
#define XAB$S_DAPVER_REMOTE	5
#define XAB$S_CACHE_TMO		4

#if 0	/* there's no item-list xab prototype available */
/* declare initialized prototype data structure */
extern struct XABITM cc$rms_xabitm __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabitm");
/* globalref struct XABITM cc$rms_xabitm; */
#endif

#endif	/*_XABITMDEF_H*/
