/* <xabjnldef.h>
 *
 *	RMS journal XAB definitions
 */
#ifndef _XABJNLDEF_H
#define _XABJNLDEF_H

#define XAB$C_JNL	34		/* xabjnl ID code */
#define XAB$C_JNL_TYPE_NONE	0
#define XAB$C_AI		1	/* AI journal */
#define XAB$C_BI		2	/* BI journal */
#define XAB$C_AT		3	/* AT journal */
#define XAB$C_RU_DEFAULT	4	/* default RU volume */
#define XAB$V_JOURNAL_DISABLED	0
#define XAB$V_BACKUP_DONE	1
#define XAB$M_JOURNAL_DISABLED	(1<<XAB$V_JOURNAL_DISABLED)	/* 0x01 */
#define XAB$M_BACKUP_DONE	(1<<XAB$V_BACKUP_DONE)		/* 0x02 */
#define XAB$K_JNLLEN	80		/* xabjnl length */
#define XAB$C_JNLLEN	80

struct XABJNL {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned char xab$b_xabjnl_type;	/* [sub]type of $XABJNL */
	unsigned : 8;
    unsigned short xab$w_jnl_flags;	/* journal flags (from ACE$W_RMSJNL_FLAGS) */
    void	  *xab$l_jnl_fab;	/* address of journal file FAB */
    char	  *xab$l_volnam_buf;	/* address of journal volume name buffer */
    unsigned short xab$w_volnam_siz;	/* size of journal volume name buffer */
    unsigned short xab$w_volnam_len;	/* return length of journal volume name */
    unsigned long  xab$q_jnl_verify_cdate[2]; /* journal file creation date (from ACE$Q_CDATE) */
					      /* (to match with journal file's creation date)  */
    unsigned long  xab$l_jnlidx;	/* journal stream index within journal file */
    unsigned long  xab$l_backup_seqno;	/* backup sequence number. */
    unsigned long  xab$q_jnl_mod_time[2]; /* timestamp of last backup or last journal entry recovered. */
    unsigned : 32, : 32, : 32, : 32, : 32, : 32, : 32, : 32;	/*long[8]*/
};

struct xabjnldef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    unsigned char xab$b_xabjnl_type;	/* [sub]type of $XABJNL */
    unsigned	: 8;			/* char fill; */
    union {
	unsigned short xab$w_jnl_flags; /* journal flags (from ACE$W_RMSJNL_FLAGS) */
	struct {
	    unsigned xab$v_journal_disabled : 1; /* journaling disabled by BACKUP (AI/BI/AT) */
	    unsigned xab$v_backup_done	: 1;	/* backup done since last $OPEN */
	    unsigned			: 6;
	} xab$r_jnl_flags_bits;
    } xab$r_jnl_flags_overlay;
    void *xab$l_jnl_fab;		/* address of journal file FAB */
    char *xab$l_volnam_buf;		/* address of journal volume name buffer */
    unsigned short xab$w_volnam_siz;	/* size of journal volume name buffer */
    unsigned short xab$w_volnam_len;	/* return length of journal volume name */
    unsigned long xab$q_jnl_verify_cdate[2]; /* journal file creation date (from ACE$Q_CDATE) */
					     /* (to match with journal file's creation date)  */
    unsigned long xab$l_jnlidx;		/* journal stream index within journal file */
    unsigned long xab$l_backup_seqno;	/* backup sequence number. */
    unsigned long xab$q_jnl_mod_time[2]; /* timestamp of last backup or last journal entry recovered. */
    unsigned	: 32, : 32, : 32, : 32, /* long fill1, fill2, ... */
		: 32, : 32, : 32, : 32;
};

#if 0	/* there's no journalling xab prototype available */
/* declare initialized prototype data structure */
extern struct XABJNL cc$rms_xabjnl __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabjnl");
/* globalref struct XABJNL cc$rms_xabjnl; */
#endif

#endif	/*_XABJNLDEF_H*/
