/* <xabkeydef.h>
 *
 *	RMS key XAB definitions
 */
#ifndef _XABKEYDEF_H
#define _XABKEYDEF_H

#define XAB$C_KEY	21	/* xabkey ID code */
/* key option flags (FLG) bit mask values) */
#define XAB$V_DUP	0
#define XAB$V_CHG	1
#define XAB$V_NUL	2
#define XAB$V_IDX_NCMPR 3
#define XAB$V_KEY_NCMPR 6
#define XAB$V_DAT_NCMPR 7
#define XAB$M_DUP	(1<<XAB$V_DUP)		/* 0x01 */
#define XAB$M_CHG	(1<<XAB$V_CHG)		/* 0x02 */
#define XAB$M_NUL	(1<<XAB$V_NUL)		/* 0x04 */
#define XAB$M_IDX_NCMPR (1<<XAB$V_IDX_NCMPR)	/* 0x08 */
#define XAB$M_KEY_NCMPR (1<<XAB$V_KEY_NCMPR)	/* 0x40 */
#define XAB$M_DAT_NCMPR (1<<XAB$V_DAT_NCMPR)	/* 0x80 */
/* key data type (DTP) constants */
#define XAB$C_STG	0	/* string */
#define XAB$C_IN2	1	/* signed 15 bit integer (2 bytes) */
#define XAB$C_BN2	2	/* 2 byte binary */
#define XAB$C_IN4	3	/* signed 31 bit integer (4 bytes) */
#define XAB$C_BN4	4	/* 4 byte binary */
#define XAB$C_PAC	5	/* packed decimal (1-16 bytes) */
#define XAB$C_IN8	6	/* signed 63 bit integer (4 bytes) */
#define XAB$C_BN8	7	/* 8 byte binary */
#define XAB$C_COL	8	/* collated */
#define XAB$C_MAX_ASCEND 8	/* maximum ascending type */
#define XAB$C_DSTG	32	/* descending	string */
#define XAB$C_DIN2	33	/*	"       signed word */
#define XAB$C_DBN2	34	/*	"       unsigned word */
#define XAB$C_DIN4	35	/*	"       signed longword */
#define XAB$C_DBN4	36	/*	"       unsigned longword */
#define XAB$C_DPAC	37	/*	"       packed decimal */
#define XAB$C_DIN8	38	/*	"       signed quadword */
#define XAB$C_DBN8	39	/*	"       unsigned quadword */
#define XAB$C_DCOL	40	/*	"       collated */
#define XAB$C_MAXDTP	40	/* max. legal data type */
/* miscellaneous constants */
#define XAB$C_PRG3	3	/* prologue version three */
#define XAB$C_PRG2	2	/* prologue version two */
#define XAB$C_PRG1	1	/* prologue version one */
#define XAB$K_KEYLEN_V2 64	/* old xabkey length */
#define XAB$C_KEYLEN_V2 64
#define XAB$K_KEYLEN_V4 76	/* xabkey length until V5 */
#define XAB$C_KEYLEN_V4 76
#define XAB$K_KEYLEN	100	/* xabkey length for V5 */
#define XAB$C_KEYLEN	100

struct XABKEY {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned char  xab$b_ian;		/* index level area number */
    unsigned char  xab$b_lan;		/* lowest index level area number */
    unsigned char  xab$b_dan;		/* data level area number */
    unsigned char  xab$b_lvl;		/* level of root bucket */
    unsigned char  xab$b_ibs;		/* size of index buckets in virtual blocks */
    unsigned char  xab$b_dbs;		/* size of data buckets in virtual blocks */
 /*(possible alignment problem here)*/
    unsigned long  xab$l_rvb;		/* root bucket start vbn */
    unsigned char  xab$b_flg;		/* key option flags */
    unsigned char  xab$b_dtp;		/* key field data type */
    unsigned char  xab$b_nsg;		/* number of key segments */
    unsigned char  xab$b_nul;		/* nul key character */
    unsigned char  xab$b_tks;		/* total key field size (bytes) */
    unsigned char  xab$b_ref;		/* key of reference (0=prim key, 1-254 = alternate keys) */
    unsigned short xab$w_mrl;		/* minimun record length to contain key field */
    unsigned short xab$w_ifl;		/* index bucket fill size (bytes) */
    unsigned short xab$w_dfl;		/* data bucket fil size (bytes) */
    unsigned short xab$w_pos[8];	/* key field record offset positions */
    unsigned char  xab$b_siz[8];	/* key field segment sizes */
	unsigned : 16;			/* spare */
    char	  *xab$l_knm;		/* pointer to 32 character key name buffer */
    unsigned long  xab$l_dvb;		/* first data bucket start vbn */
 /*- end of ancient XABKEY -*/
 /* Additions for prologue 3 files */
    unsigned char  xab$b_typ[8];	/* key field segment types */
    unsigned char  xab$b_prolog;	/* indicate prologue version desired (primary key only) */
	unsigned : 24;			/* spare */
 /*- end of old XABKEY -*/
    void	  *xab$l_coltbl;	/* address of collate table */
    unsigned long  xab$l_colsiz;	/* size of collate table */
    char	  *xab$l_colnam;	/* name of collate table */
	unsigned : 32, : 32, : 32;	/* spare */
};

struct xabkeydef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
/*
   The field layout of the key xab is such that it matchs as
   closely as possible the layout of a key decriptor in the
   index file prologue.  This is so the contents may be moved
   between the two structures as efficiently as possible.
 */
    unsigned char xab$b_ian;		/* index level area number */
    unsigned char xab$b_lan;		/* lowest index level area number */
    unsigned char xab$b_dan;		/* data level area number */
    unsigned char xab$b_lvl;		/* level of root bucket */
    unsigned char xab$b_ibs;		/* size of index buckets in virtual blocks */
    unsigned char xab$b_dbs;		/* size of data buckets in virtual blocks */
 /*(possible alignment problem here)*/
    unsigned long xab$l_rvb;		/* root bucket start vbn */
    union {
	unsigned char xab$b_flg;	/* key option flags */
	struct {
	    unsigned xab$v_dup	     : 1; /* duplicate key values allowed */
	    unsigned xab$v_chg	     : 1; /* alt key only--key field may change on update */
	    unsigned xab$v_nul	     : 1; /* alt key only--null key value enable */
	    unsigned xab$v_idx_ncmpr : 1; /* indicate index records for given key are not compressed */
	    unsigned		     : 2; /* spare */
	    unsigned xab$v_key_ncmpr : 1; /* indicates key is not compressed in data record */
	    unsigned xab$v_dat_ncmpr : 1; /* data record is not compressed */
	} xab$r_flg_bits;
    } xab$r_flg_overlay;
    unsigned char xab$b_dtp;		/* key field data type */
    unsigned char xab$b_nsg;		/* number of key segments */
    unsigned char xab$b_nul;		/* nul key character */
    unsigned char xab$b_tks;		/* total key field size (bytes) */
    unsigned char xab$b_ref;		/* key of reference (0=prim key, 1-254 = alternate keys) */
    unsigned short xab$w_mrl;		/* minimun record length to contain key field */
    unsigned short xab$w_ifl;		/* index bucket fill size (bytes) */
    unsigned short xab$w_dfl;		/* data bucket fil size (bytes) */
    union {
	unsigned short xab$w_pos[8];	/* key field record offset positions */
	struct {
	    unsigned short xab$w_pos0;	/* segment 0 */
	    unsigned short xab$w_pos1;	/* segment 1 */
	    unsigned short xab$w_pos2;	/* segment 2 */
	    unsigned short xab$w_pos3;	/* segment 3 */
	    unsigned short xab$w_pos4;	/* segment 4 */
	    unsigned short xab$w_pos5;	/* segment 5 */
	    unsigned short xab$w_pos6;	/* segment 6 */
	    unsigned short xab$w_pos7;	/* segment 7 */
	} xab$r_pos_fields;
    } xab$r_pos_overlay;
    union {
	unsigned char xab$b_siz[8];	/* key field segment sizes */
	struct {
	    unsigned char xab$b_siz0;	/* segment 0 */
	    unsigned char xab$b_siz1;	/* segment 1 */
	    unsigned char xab$b_siz2;	/* segment 2 */
	    unsigned char xab$b_siz3;	/* segment 3 */
	    unsigned char xab$b_siz4;	/* segment 4 */
	    unsigned char xab$b_siz5;	/* segment 5 */
	    unsigned char xab$b_siz6;	/* segment 6 */
	    unsigned char xab$b_siz7;	/* segment 7 */
	} xab$r_siz_fields;
    } xab$r_siz_overlay;
    unsigned	: 16;			/* short fill; spare */
/*
   The positions of the above fields are dictated by the key descriptor
   record layout in the index file prologue.
 */
    char *xab$l_knm;			/* pointer to 32 character key name buffer */
    unsigned long xab$l_dvb;		/* first data bucket start vbn */
/*- end of ancient XABKEY -*/
/* Additions for prologue 3 files */
    union {
	unsigned char xab$b_typ[8];	/* key field segment types */
	struct {
	    unsigned char xab$b_typ0;	/* segment 0 */
	    unsigned char xab$b_typ1;	/* segment 1 */
	    unsigned char xab$b_typ2;	/* segment 2 */
	    unsigned char xab$b_typ3;	/* segment 3 */
	    unsigned char xab$b_typ4;	/* segment 4 */
	    unsigned char xab$b_typ5;	/* segment 5 */
	    unsigned char xab$b_typ6;	/* segment 6 */
	    unsigned char xab$b_typ7;	/* segment 7 */
	} xab$r_typ_fields;
    } xab$r_typ_overlay;
    unsigned char xab$b_prolog;		/* indicate prologue version desired (primary key only) */
    unsigned	: 8;			/* char fill; spare */
    unsigned	: 16;			/* short fill; spare */
/*- end of old XABKEY -*/
    void *xab$l_coltbl;			/* address of collate table */
    unsigned long xab$l_colsiz;		/* size of collate table */
    char *xab$l_colnam;			/* name of collate table */
    unsigned	: 32, : 32, : 32;	/* long fill1, fill2, fill3; spare */
};

/* declare initialized prototype data structure */
extern struct XABKEY cc$rms_xabkey __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabkey");
/* globalref struct XABKEY cc$rms_xabkey; */

#endif	/*_XABKEYDEF_H*/
