/* <xabprodef.h>
 *
 *	RMS file protection XAB definitions
 */
#ifndef _XABPRODEF_H
#define _XABPRODEF_H

#define XAB$C_PRO	19	/* xabpro ID code */
/* protection bit mask values */
#define XAB$V_SYS	0	/* system */
#define XAB$S_SYS	4
#define XAB$M_SYS	0x000F
#define XAB$V_OWN	4	/* owner */
#define XAB$S_OWN	4
#define XAB$M_OWN	0x00F0
#define XAB$V_GRP	8	/* group */
#define XAB$S_GRP	4
#define XAB$M_GRP	0x0F00
#define XAB$V_WLD	12	/* world */
#define XAB$S_WLD	4
#define XAB$M_WLD	0xF000
#define XAB$V_NOREAD	0
#define XAB$V_NOWRITE	1
#define XAB$V_NOEXE	2
#define XAB$V_NODEL	3
#define XAB$M_NOREAD	(1<<XAB$V_NOREAD)	/* 0x01 */
#define XAB$M_NOWRITE	(1<<XAB$V_NOWRITE)	/* 0x02 */
#define XAB$M_NOEXE	(1<<XAB$V_NOEXE)	/* 0x04 */
#define XAB$M_NODEL	(1<<XAB$V_NODEL)	/* 0x08 */
/* protection options (PROT_OPT) bit mask values */
#define XAB$V_PROPAGATE 0
#define XAB$M_PROPAGATE (1<<XAB$V_PROPAGATE)	/* 0x01 */
/* miscellaneous constants */
#define XAB$K_PROLEN_V3 16	/* V3a xabpro length */
#define XAB$C_PROLEN_V3 16
#define XAB$K_PROLEN	88	/* xabpro length */
#define XAB$C_PROLEN	88

struct XABPRO {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned short xab$w_pro;		/* protection mask */
    unsigned char  xab$b_mtacc;		/* magtape access control char. */
    unsigned char  xab$b_prot_opt;	/* XABPRO options field */
    unsigned long  xab$l_uic;		/* uic code */
    unsigned long  xab$q_prot_mode[2];	/* protection mode */
    void	  *xab$l_aclbuf;	/* address of user's ACL buffer */
    unsigned short xab$w_aclsiz;	/* size of user's ACL buffer */
    unsigned short xab$w_acllen;	/* return length of entire ACL */
    unsigned long  xab$l_aclctx;	/* ACL context field */
    unsigned long  xab$l_aclsts;	/* ACL return err status */
	unsigned : 32, : 32, : 32, : 32, : 32, : 32,	/* spare */
		 : 32, : 32, : 32, : 32, : 32, : 32;	/*long[12]*/
};

struct xabprodef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    union {
	unsigned short xab$w_pro;	/* protection mask */
	struct {
	    unsigned xab$v_sys : 4;	/* system */
	    unsigned xab$v_own : 4;	/* owner */
	    unsigned xab$v_grp : 4;	/* group */
	    unsigned xab$v_wld : 4;	/* world */
	} xab$r_pro_bits;
    } xab$r_pro_overlay;
    unsigned char xab$b_mtacc;		/* magtape access control char. */
    union {
	unsigned char xab$b_prot_opt;	/* XABPRO options field */
	struct {
	    unsigned xab$v_propagate : 1; /* Propagate security attributes on $ENTER and $RENAME */
	    unsigned		     : 7;
	} xab$r_prot_opt_fields;
    } xab$r_prot_opt_overlay;
    union {
	unsigned long xab$l_uic;	/* uic code */
	struct {
	    unsigned short xab$w_mbm;	/* member code */
	    unsigned short xab$w_grp;	/* group code */
	} xab$r_uic_fields;
    } xab$r_uic_overlay;
    union {				/* RWED/mode protection for file */
	unsigned long xab$q_prot_mode[2]; /* eventually may be a quadword */
	struct {			  /* but currently only a byte	  */
	    unsigned char xab$b_prot_mode;
	} xab$r_prot_mode_fields;
    } xab$r_prot_mode_overlay;
    void *xab$l_aclbuf;			/* address of user's ACL buffer */
    unsigned short xab$w_aclsiz;	/* size of user's ACL buffer */
    unsigned short xab$w_acllen;	/* return length of entire ACL */
    unsigned long xab$l_aclctx;		/* ACL context field */
    unsigned long xab$l_aclsts;		/* ACL return err status */
    unsigned	: 32, : 32, : 32, : 32, /* long fill1, fill2, ...; spare */
		: 32, : 32, : 32, : 32,
		: 32, : 32, : 32, : 32;
};

/* declare initialized prototype data structure */
extern struct XABPRO cc$rms_xabpro __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabpro");
/* globalref struct XABPRO cc$rms_xabpro; */

#endif	/*_XABPRODEF_H*/
