/* <xabrdtdef.h>
 *
 *	RMS revision date/time XAB definitions
 */
#ifndef _XABRDTDEF_H
#define _XABRDTDEF_H

#define XAB$C_RDT	30	/* xabrdt ID code */
#define XAB$K_RDTLEN	20	/* length of rdt xab */
#define XAB$C_RDTLEN	20

struct XABRDT {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned short xab$w_rvn;		/* revision number */
	unsigned : 16;			/* spare */
    unsigned long  xab$q_rdt[2];	/* revision date & time */
};

struct xabrdtdef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    unsigned short xab$w_rvn;		/* revision no. (common to $xabdat) */
    unsigned	: 16;			/* short fill; spare */
    union {
	long xab$q_rdt[2];		/* revision date & time */
	struct {
	    unsigned long xab$l_rdt0;
	    long xab$l_rdt4;
	} xab$r_rdt_fields;
    } xab$r_rdt_overlay;
};

/* declare initialized prototype data structure */
extern struct XABRDT cc$rms_xabrdt __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabrdt");
/* globalref struct XABRDT cc$rms_xabrdt; */

#endif	/*_XABRDTDEF_H*/
