/* <xabrudef.h>
 *
 *	RMS recovery unit XAB definitions
 */
#ifndef _XABRUDEF_H
#define _XABRUDEF_H

#define XAB$C_RU	35	/* xabru ID code */
#define XAB$V_NOJOIN	0
#define XAB$M_NOJOIN	(1<<XAB$V_NOJOIN)	/* 0x01 */
#define XAB$K_RULEN	48	/* xabru length */
#define XAB$C_RULEN	48

struct XABRU {
    unsigned char  xab$b_cod;		/* xab ID code */
    unsigned char  xab$b_bln;		/* block length */
	unsigned : 16;			/* (filler) */
    void	  *xab$l_nxt;		/* xab chain link */
    unsigned short xab$w_ru_flags;	/* flags */
	unsigned : 16;
    unsigned long  xab$l_ru_handle;	/* RU handle to join (input field) */
    unsigned long  xab$l_ru_handle_joined; /* RU handle joined (output field) */
	unsigned : 32, : 32, : 32, : 32, : 32, :32, : 32;	/*long[7]*/
};

struct xabrudef {
    unsigned	: 8, : 8, : 16, : 32;	/* common of all xabs (see $XABDEF) */
    union {
	unsigned short xab$w_ru_flags;	/* flags */
	struct {
	    unsigned xab$v_nojoin : 1;	/* do not join any recovery unit */
	    unsigned		  : 7;
	    unsigned		  : 8;	/* padding */
	} xab$r_ru_flags_bits;
    } xab$r_ru_flags_overlay;
    unsigned	: 16;			/* short fill; */
    unsigned long xab$l_ru_handle;	/* RU handle to join (input field) */
    unsigned long xab$l_ru_handle_joined; /* RU handle joined (output field) */
    unsigned	: 32, :32, :32, : 32,	/* long fill1, fill2, ... */
		: 32, :32, :32;		/* long fill1, fill2, ... */
};

#if 0	/* there's no recovery unit xab prototype available */
/* declare initialized prototype data structure */
extern struct XABRU cc$rms_xabru __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_xabru");
/* globalref struct XABRU cc$rms_xabru; */
#endif

#endif	/*_XABRUDEF_H*/
