 /*  *			A R C H I V E  *)  * Archiver, roughly from software tools.  *  */O   /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...ARC 		}  */   #ifdef	DOCUMENTATION   title	arch	text file archiver  index		text file archiver    synopsis2 	arch [-options] [-z logfile] archive_name file[s]   description   < 	Arch manages archives (libraries) of source files, allowing9 	a large number of small files to be stored without using 7 	excessive system resources.  The following options may) 	be specified: 	.lm +8( 	.s.i -8;c	Force creation of new archive$ 	.s.i -8;d	Delete file from archive.! 	.s.i -8;i	Insert, same as update	) 	.s.i -8;p	Print files on standard outpute" 	.s.i -8;r	Replace, same as update, 	.s.i -8;l	List archive contents (directory)" 	.s.i -8;u	Update, same as replace 	.s.i -8;x	Extract named files 	.s.i -8;v	Verbose. 	.s.i -8;z	Write verbose log to indicated file	 	.s.lm -8 A 	The file name arguments may contain '*' and '?' wildcards, whereE 	'*' matches any string of characters, and '?' matches one character. @ 	('%' may be used as a synonym for '?'.)  There is a slight, but= 	suble difference in the way wild cards are processed for the  	various commands: 	.lm +8 ' 	.s.i -8;directory, delete, and extract  	.s - 	Match ('*' and '?') against the files in the	4 	archive, performing the operation on all files that1 	match.  Except for delete, "no argument" matchesd 	all files in the archive.$ 	.s.i -8;insert, replace, and update 	.s 1 	Expand the wild-card arguments against the files12 	stored on the operating system -- eliminating all. 	wild cards.  Then, match against the archived- 	files.  Those that match are replaced by the 2 	file on the operating system.  After replacement,2 	any additional files are appended to the archive.3 	Files in the archive that are not in the directoryG 	are unchanged.  	.sn6 	Currently, insert, replace, and update work the same.4 	If it seems reasonable, the program may be extended 	as follows: 	.lm +89" 	.s.i -8;insert	Add files new only 	.so, 	Adds new files (not present in the archive)' 	but does not modify files currently inn* 	the archive.  It would be an error to try% 	modifying a currently archived file.x+ 	.s.i -8;replace	Modify existing files only	 	.so, 	Modify files present in the archive, but do" 	not add new files to the archive.( 	.s.i -8;update	Modify existing, add new	 	.s.lm -8 2 	This is simple to do, but would seem to be a rich 	source of user error. 	.lm -8i   note  < 	Arch has been superseded for most uses by the much simpler,4 	but functionally similar, archc and archx programs.   archive file format	  @ 	Archive files are standard text files.  Each archive element is# 	preceeded by a line of the format:* 	.s.nf 	-h-	file.name	date	true_nameN 	.s.f @ 	Note that there is no line or byte count.  To prevent problems,B 	a '-' at the beginning of a record within a user file or embeddedE 	archive will be "quoted" by doubling it.  The date and true filenameo< 	fields are ignored.  On Dec operating systems, file.name is 	forced to lowercase.*   diagnosticst  / 	Diagnostic messages should be self-explanatorya   author  
 	Martin Minowe   bugs  : 	Arch used to be called ar.  The name was changed to avoid 	conflict with the Unix tool.e   #endif   #include	<stdio.h> #include	<ctype.h> #define EOS		0 #define	FALSE		0 #define	TRUE		1*
 #ifdef vms #include		<ssdef.h>  #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)d #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */  #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   /*.  * These two routines are faked on native Unix  */a2 extern	FILE		*fwild();	/* Wild card file lookup	*/5 extern	FILE		*fnext();	/* Open next wild card file	*/] #ifdef	unixi #define	FAKEFWILDE/ #define	strrchr	rindex			/* Wrong on 4.2bsd		*/t #endif   #ifdef	tolower #undef	tolower #endif   #define	TEMPNAME	"ar.tmp"	   /*(  * List chains together strings of text.  */i   typedef struct List {	1 	struct List	*l_next;	/* -> next list element		*/*- 	int		l_flag;		/* mark if found in archive	*/f- 	char		*l_arname;	/* archive name argument	*/f. 	char		*l_filename;	/* directory file name		*/ } LIST;    /*  * Global storageO  */C$ FILE		*arfd		= NULL;	/* Archive			*/) FILE		*newfd		= NULL;	/* New archive			*/ " FILE		*logfd;			/* Log output			*/: int		newarchive	= FALSE; /* True if create from scratch	*/5 int		logging		= FALSE; /* True if log file enabled	*/d& char		text[513];		/* Working text			*/4 char		arname[81];		/* Current archive member name	*/- char		filename[81];		/* Working file name		*/C/ char		arfilename[81];		/* Archive file name		*/k1 char		fullname[81];		/* Output for argetname()	*/e) char		*timetext;		/* Time of day text		*/	0 int		verbose		= FALSE; /* TRUE for verbosity		*/' int		delflag		= 0;	/* Delete files			*/:2 int		directory	= 0;	/* Table of contents if lit	*/, int		update		= 0;	/* Update files if lit		*// int		extract		= 0;	/* Get files from archive	*/	, int		print		= 0;	/* Write files to stdout	*/- int		errorflag	= 0;	/* Set on fatal error		*/ . LIST		*list		= NULL;	/* String list header		*/   main(argc, argv) int		argc;			/* Arg count			*/" char		*argv[];		/* Arg vector			*/ {*' 	register int		i;	/* Random counter		*/r- 	register char		*fn;	/* File name pointer		*/t* 	register char		*argp;	/* Arg pointer			*/ 	char			*ctime();	 	long			time();	 	long			timval;r  
 #ifdef vms" 	argc = getredirection(argc,argv); #endif   	/*E0 	 * Setup the time of day, erasing trailing '\n' 	 */ 	time(&timval);i 	timetext = ctime(&timval);  	logfd = stderr;$ 	argp = timetext + strlen(timetext);* 	while (argp > timetext && *--argp <= ' ') 		;f 	argp[1] = EOS;n   	for (i = 1; i < argc; i++) {c 		if ((argp = argv[i]) == NULL)	( 			continue;	/* From log file writer		*/ 		if (*argp == '-') {n 			/*e 			 * Process optionst 			 */1 			argv[i] = NULL;	/* Erase it from file stuff	*/l 			while (*++argp != EOS) {i 				switch (tolower(*argp)) {v
 				case 'c':r 					newarchive = TRUE;n 					break;[  ' 				case 'd':	/* Delete from archive	*/e 					delflag = 1;/ 					break;f  # 				case 'p':	/* Print on stdout	*/l 					print = 1;p 					break;   " 				case 'l':	/* List directory	*/ 					directory = 1;n 					break;	   				case 'i':	/* Insert		*/i 				case 'r':	/* Replace		*/# 				case 'u':	/* Update modified	*/i 					update = 1; 					break;v   				case 'v':	/* Verbose		*/ 					verbose = 1;* 					break;o  
 				case 'x':e 						/* Extract		*/ 					extract = 1;	 					break;D   				case 'z':	/* Log file		*/d( 					if ((logfd = fopen(argv[i+1], "w")) 							== NULL)l$ 						cant(argv[i+1], "create log"); 					if (verbose) {r 						fprintf(stderr,  							"writing log to %s\n",c 							argv[i+1]); 					} 					logging = TRUE; 					argv[i+1] = NULL; 					break;    				default: 					fprintf(stderr, 						"Illegal option '%c'\n",
 						*argp); 
 					usage();  				}		/* Switch		*/ 			}			/* While		*/ ( 			argv[i] = NULL;		/* Erase argument	*/ 		}				/* If "-foo"		*/;+ 		else if (arfd == NULL && newfd == NULL) {( 			/* $ 			 * First file is the archive name 			 */9 			if (newarchive || (arfd = fopen(argp, "r")) == NULL) {1- 				if ((newfd = fopen(argp, "w")) == NULL) {,+ 					cant(argp, "create new archive file");m 				}"
 				else { 					newarchive = TRUE;; 					if (verbose)  						fprintf(logfd,' 					  "Creating new archive \"%s\"\n",= 						argp); 				}  			}( 			argv[i] = NULL;		/* Erase argument	*/ 			strcpy(arfilename, argp); 		}* 	} 	if (errorflag)v0 		fatal("Previous error prevents continuation");! 	if (!newarchive && arfd == NULL)}% 		fatal("No archive file specified");r 	/*	 	 * Got all arguments. 	 */; 	if (!newarchive && (newfd = fopen(TEMPNAME, "w")) == NULL) - 		cant("ar.tmp", "create archive work file");*6 	if ((i = delflag+directory+extract+print+update) > 1)( 		fatal("Illogical option combination"); 	else if (i == 0) {( 		if (verbose)2 			fprintf(logfd, "Update selected by default\n");
 		update = 1;	 	} 	/*	 	 * Debugging verbosity. 	 */ 	if (verbose) {,' 		fprintf(logfd, "You have selected:");  		if (directory)  			fprintf(logfd, " directory"); 		if (delflag) 			fprintf(logfd, " delete");  		if (extract) 			fprintf(logfd, " extract"); 		if (print) 			fprintf(logfd, " print");
 		if (update)  			fprintf(logfd, " update");  		if (verbose)$ 			fprintf(logfd, " and verbosity");= 		fprintf(logfd, ".\nArchive file is \"%s\".\n", arfilename);e 	}& 	if (expandargs(argc, argv, update)) {? 		fprintf(stderr, "Warning, Errors found in arg. expansion\n");c 	} 	if (newarchive && !update) {r, 		fprintf(logfd, "Dummy archive created\n"); 		fclose(newfd); 	} 	else if (directory) 		dodirectory(); 	else if (delflag)
 		dodelete();h 	else if (extract || print). 		doextract(print);s 	else if (update)x
 		doupdate();f 	else {.- 		fprintf(stderr, "No command was provided"); 
 		usage(); 	} }.  
 dodirectory()  /*  * Write a table of contents  */w {c 	text[0] = EOS;' 	while (gethdr(arfd)) {a 		if (findarg(arname, NULL)) { 			printf(text); 		}u' 		arcopy(arfd, NULL);		/* Skip file		*/i 	} }t  
 dodelete() /*/  * Delete named files -- gotta have a name listv  */s {m 	register int		ecount;   	if (list == NULL) { 		fatal("Delete by name only");  	}) 	ecount = replace(arfd, newfd, FALSE, 0);r 	notfound(); 	fclose(arfd); 	fclose(newfd);E 	if (ecount == 0) { ! 		filemove(TEMPNAME, arfilename);h 	} 	else {.: 		fprintf(stderr, "Errors prevent deletion of archive\n"); 		if (logging): 			fprintf(logfd, "Errors prevent deletion of archive\n"); #ifdef	unixl 		unlink(TEMPNAME);  #else  		delete(TEMPNAME);  #endif 	} }c   doextract(printflag)5 int		printflag;	/* TRUE to print, FALSE to extract	*/y /*  * Extract or print named files   */v {  	register FILE		*outfd;t  % 	outfd = (printflag) ? stdout : NULL;d 	text[0] = EOS;t 	while (gethdr(arfd)) {u 		if (!findarg(arname, NULL)) {s 			if (verbose) {o0 				fprintf(logfd, "Skipping \"%s\"\n", arname); 			}# 			arcopy(arfd, NULL);		/* Skip		*/  		}i 		else { 			if (outfd != stdout) {t/ 				if ((outfd = fopen(arname, "w")) == NULL) {e 					perror(arname); 					fprintf(stderr, 						"Can't create \"%s\"\n", 						arname); 					if (logging)o 						fprintf(logfd, 						"Can't create \"%s\"\n", 						arname); 					arcopy(arfd, NULL); 					continue; 				}i 			} 			if (verbose) { 0 				fprintf(logfd, "Creating \"%s\"\n", arname); 			} 			arexport(arfd, outfd);- 			fclose(outfd);  			outfd = NULL; 		}  	} }e  
 doupdate() /*:  * Update existing files, add argv[1]..argv[argc-1] at end  */h {  	register int	ecount;e 	register LIST	*lp;e   	ecount = 0; 	if (!newarchive) {p) 		ecount = replace(arfd, newfd, TRUE, 0);  	}/ 	for (lp = list; lp != NULL; lp = lp->l_next) {e 		if (!lp->l_flag) {2 			ecount += addfile(lp->l_arname, lp->l_filename, 					newfd, ecount, "Added");e 			lp->l_flag = TRUE;w 		}e 	} 	if (newarchive) { 		fclose(newfd); 		if (ecount) {e9 			fprintf(stderr, "completed with %d errors\n", ecount);f 			if (logging) {*0 				fprintf(logfd, "completed with %d errors\n",
 					ecount);r 			} 		}r 	} 	else {i 		fclose(arfd);A 		fclose(newfd); 		if (ecount == 0) {" 			filemove(TEMPNAME, arfilename); 		}  		else { 			fprintf(stderr,5 				"Move of %s to %s supressed because of errors\n",A 				TEMPNAME, arfilename); 			if (logging)e 				fprintf(logfd,5 				"Move of %s to %s supressed because of errors\n",I 				TEMPNAME, arfilename); 		}A 	} }e   int*( replace(infd, outfd, updateflag, ecount), FILE		*infd;		/* Reading files from here		*/) FILE		*outfd;		/* Writing files here			*/ 6 int		updateflag;	/* TRUE to update, FALSE to remove	*/ int		ecount; /*A  * Replace or delete files from the archive.  The updated archive   * is written to outfd.L  */n {(4 	text[0] = EOS;			/* Signal gethdr initialization	*/ 	while (gethdr(infd)) {t 		/*$ 		 * We have a file, is it selected? 		 */i" 		if (findarg(arname, filename)) { 			if (updateflag) {' 				ecount += addfile(arname, filename,t! 						outfd, ecount, "Replaced");u 			} 			arcopy(infd, NULL); 		}* 		else { 			/*m6 			 * Not selected for update, copy to the new archive 			 */ 			fputs(text, outfd); 			arcopy(infd, outfd);* 		}e 	} 	return (ecount);  }e   int " expandargs(argc, argv, updateflag)' int		argc;		/* Number of arguments			*/ " char		*argv[];	/* Arg vector				*/3 int		updateflag;	/* TRUE to trigger file search		*/r /*9  * Process the argv[] vector, building the argument list.	B  * Note: argv[1] is the first argument -- argv[0] is untouched and&  * NULL entries in argv[] are ignored.  *A  * If updateflag is TRUE, arguments are expanded against the file*A  * directory (using fwild/fnext).  If FALSE, they are used as is.e  *"  * Return TRUE if errors occurred.  */t {t 	register int	in;y 	register int	eflag;   	eflag = 0;   	for (in = 1; in < argc; in++) { 		if (argv[in] != NULL) {* 			if (updateflag) {! 				eflag += findfiles(argv[in]);n 			}	 			else {*( 				eflag += savestring(argv[in], NULL); 			} 		}i 	} 	return (eflag != 0);p }t   int/ findfiles(fname)
 char		*fname;e /*M  * Archive element names, do fwild lookup to expand wildcards where possible.r  */  {a 	register int	i; 	register FILE	*fd;n  ( 	if ((fd = fwild(fname, "r")) == NULL) { 		fprintf(stderr,i4 			"Can't open directory or wildcard file \"%s\"\n",
 			fname); 		if (logging){  			fprintf(logfd, 4 			"Can't open directory or wildcard file \"%s\"\n",
 			fname); 		} 
 		return (1);g 	} 	/*d6 	 * Locate each file, then save archive and file names 	 */& 	for (i = 0; fnext(fd) != NULL; i++) {) 		argetname(fd, fname, arname, filename);g 		savestring(arname, filename);s 	} 	if (i == 0) {3 		fprintf(stderr, "Warning, no match for \"%s\"\n",[
 			fname); 		if (logging) {3 			fprintf(logfd, "Warning, no match for \"%s\"\n",c 				fname);r 		}g
 		return (1);/ 	} 	else if (verbose) {@ 		fprintf(logfd, "%d file%s in your directory match%s \"%s\"\n", 			i,o 			(i > 1)  ? "s"  : "", 			(i == 1) ? "es" : "",
 			fname);
 		return (0);  	} }e   int  savestring(datum, file) + char		*datum;		/* Archive element name			*/a1 char		*file;		/* May be NULL if not necessary		*/	 /*8  * Insert text into the list in sorted order (on datum).!  * Warn (and fail on) duplicates.r  */  {	 	register	LIST	*next;b 	register	LIST	**prev; 	register	LIST	*new; 	char			*ardatum;	 	char			*arfile; 	int			comp;   	arfile = NULL;t 	if (file != NULL) {: 		if ((arfile = (char *)malloc(strlen(file) + 1)) == NULL)( 			fatal("Out of memory in savestring"); 		strcpy(arfile, file);	 	}: 	if ((ardatum = (char *)malloc(strlen(datum) + 1)) == NULL; 	 || (new     = (LIST *)malloc(sizeof(LIST)     )) == NULL)]' 		fatal("Out of memory in savestring");	 	strcpy(ardatum, datum); 	new->l_flag = FALSE;" 	new->l_arname = ardatum;	 	new->l_filename = arfile; 	prev = &list;
 	next = list;kF 	while (next != NULL && (comp = compare(datum, next->l_arname)) > 0) { 		if (comp == 0) {9 			fprintf(stderr, "duplicate argument \"%s\"\n", datum);	 			if (arfile) { 				free(arfile);/ 			} 			free(ardatum);;
 			free(new);f 			return (TRUE);= 		}L 		prev = &next->l_next;  		next = *prev;v 	}
 	*prev = new;i 	new->l_next = next; 	return (FALSE); }	  
 dumplist() /*4  * Dump archive name list -- used for debugging only  */c {t 	register LIST	*lp;m   	if ((lp = list) == NULL)w% 		fprintf(stderr, "List is empty\n");	 	else while (lp != NULL) { 		fprintf(stderr, "%s, \"%s\"", , 			(lp->l_flag) ? "    found" : "not found", 			lp->l_arname);	 		if (lp->l_filename == NULL); 			fprintf(stderr, "\n");v 		else+ 			fprintf(stderr, "%s\n", lp->l_filename);i 		lp = lp->l_next; 	} }U   usage()a /*  * Fatal help messaged  */  {	/ 	fatal("Usage \"ar -dilpruvx archive files\"\n\& \td\tDelete named files\n\ \ti\tInsert named files\n\ \tl\tList archive directory\n\, \tp\tPrint named files on standard output\n\ \tr\tReplace named files\n\c% \tu\tUpdate -- replace named files\n\=* \tv\tVerbose -- give running commentary\n\8 \tx\tExtract -- copy named files to current directory\n\  i, r, and u, are identical.\n"); }v   cant(fname, why)
 char		*fname;a char		*why;) /*  * Can't open a file, fatal.  */  {i3 	fprintf(stderr, "Can't %s: \"%s\"\n", why, fname);e 	fatal("Can't continue");r }f   fatal(message) char		*message;  /*  * Fatal error  */" {  	fprintf(stderr, message); 	exit(IO_ERROR); }	  
 notfound() /*@  * Called from dodelete() to warn the user about files that were4  * to be deleted, but which were not in the archive.  */r {  	register LIST	*lp;(  / 	for (lp = list; lp != NULL; lp = lp->l_next) {a 		if (!lp->l_flag) {8 			fprintf(stderr, "Can't delete \"%s\" -- not found\n", 				lp->l_arname); 			if (logging) {" 				fprintf(logfd,) 				"Can't delete \"%s\" -- not found\n",( 				lp->l_arname); 			} 		}  	} }l   int 
 gethdr(fd)
 FILE		*fd; /*L  * If text is null, read a record, returning TRUE if text contains a header.   * Parse the header into arname.  */* {  	register char	*tp;  	register char	*np;v  > 	if (text[0] == EOS && fgets(text, sizeof text, fd) == NULL) { 		return (FALSE);) 	} 	if (text[0] != '-'& 	 || text[1] != 'h't 	 || text[2] != '-') 		return (FALSE);c. 	for (tp = &text[3]; *tp && *tp <= ' '; tp++);1 	for (np = &arname[0]; *tp > ' '; *np++ = *tp++);  	*np = EOS;| 	return	(TRUE);r }(   ints findarg(name, fname) char		*name;* char		*fname;			/* Gets full file name		*/ /*>  * If name is in the list, mark it as "found" and return TRUE.E  * If true, and fname is not NULL, fname will have the file argument.a  */f {i 	register LIST	*lp;{ 	register int	flag;	   	if ((lp = list) == NULL) {k 		if (fname != NULL) 			fname[0] = EOS; 		return (TRUE); 	} 	while (lp != NULL) {v" 		if (match(name, lp->l_arname)) { 			lp->l_flag = TRUE;  			if (fname != NULL) {n 				if (lp->l_filename == NULL)d 					fname[0] = EOS;
 				else {# 					strcpy(fname, lp->l_filename);i 				}n 			} 			return (TRUE);M 		}, 		lp = lp->l_next; 	} 	return (FALSE); }r   intr compare(string1, string2)v register char	*string1;	 register char	*string2;r /*+  * Compare strings (note: case insensitive)n  */T {N1 	while (tolower(*string1) == tolower(*string2)) {c 		if (*string1 == NULL)  			return (0); 		string1++; 		string2++; 	}; 	return ((tolower(*string1) > tolower(*string2)) ? 1 : -1);s }    into( addfile(name, fname, outfd, ecount, why)* char		*name;		/* Archive element name			*/( char		*fname;		/* Archive file name			*// FILE		*outfd;		/* Output file, already open		*/\1 int		ecount;		/* Current error count (updated)	*/*3 char		*why;		/* Why are we here -- for verbosity	*/t /*;  * Add file "fname" (archive element "name") to the archiver  */; {	 	register FILE		*infd;  * 	if ((infd = fopen(fname, "r")) == NULL) { 		perror(fname);9 		fprintf(stderr, "%s archive member \"%s\" not found\n",	 				why,( 				(fname == NULL) ? "{Null}" : fname); 		if (logging) { 			fprintf(logfd,	+ 				"%s archive member \"%s\" not found\n",  				why,( 				(fname == NULL) ? "{Null}" : fname); 		}o 		ecount++;  	} 	else {  #ifdef	unix  		strcpy(filename, fname); #elser 		fgetname(infd, filename);* #endif 		if (verbose) {4 			fprintf(logfd, "%s archive member \"%s\" (%s)\n", 				why, name, filename);a 		}f? 		fprintf(outfd, "-h- %s\t%s\t%s\n", name, timetext, filename);_" 		arimport(infd, outfd, filename); 		fclose(infd);l 	} 	return (ecount);n },  - argetname(fd, wildname, outname, outfilename) 
 FILE		*fd;/ char		*wildname;	/* Arg to fwild (for Unix)		*/(% char		*outname;	/* Archive name				*/e* char		*outfilename;	/* Full file name			*/ /*@  * Get file name, stripping off device:[directory] and ;version.@  * The archive name ("FILE.EXT" is written to outname, while theH  * full file name is written to outfilename.  On a dec operating system,"  * outname is forced to lowercase.  */  {r 	register char	*tp;r 	register char	*ip;  	char		bracket;i 	extern char	*strrchr();   #ifdef	unixv 	strcpy(outname, wildname);s 	/*e. 	 * outname is after all directory information 	 */* 	if ((tp = strrchr(outname, '/')) != NULL) 		strcpy(outname, tp + 1); 	strcpy(outfilename, outname); #else/ #ifdef	decus1 	wildname = wildname;			/* Prevent warning msg	*/A #endif 	fgetname(fd, outfilename);* 	strcpy(outname, outfilename);* 	if ((tp = strrchr(outname, ';')) != NULL) 		*tp = EOS;, 	while ((tp = strchr(outname, ':')) != NULL) 		strcpy(outname, tp + 1); 	switch (outname[0]) { 	case '[':	bracket = ']';s	 			break;	 	case '<':	bracket = '>'; 	 			break;{ 	case '(':	bracket = ')';		 			break;d 	default:	bracket = EOS;	 			break;, 	} 	if (bracket != EOS) {0 		if ((tp = strchr(outname, bracket)) == NULL) {2 			fprintf(stderr, "? Illegal file name \"%s\"\n", 				outfilename);s 		}, 		else { 			strcpy(outname, tp + 1);e 		}  	}% 	for (tp = outname; *tp != EOS; tp++)a 		*tp = tolower(*tp);  #endif }	   filemove(inname, outname)  char		*inname; char		*outname;/ /*+  * "Rename" inname to outname the hard way.	  */  {  	register FILE		*infd; 	register FILE		*outfd;n 	long int		nrecords;  
 	if (verbose) 8 		fprintf(logfd, "Copying %s to %s\n", inname, outname);) 	if ((infd = fopen(inname, "r")) == NULL) ! 		cant(inname, "open for input");t+ 	if ((outfd = fopen(outname, "w")) == NULL)  		cant(outname, "create");G 	for (nrecords = 0; fgets(text, sizeof text, infd) != NULL; nrecords++)y 		fputs(text, outfd);  #ifdef	unix  	fclose(infd); 	fclose(outfd);{ 	unlink(inname); #else  	fgetname(infd, text); 	fclose(infd); 	fclose(outfd);) 	delete(text); #endif
 	if (verbose)s6 		fprintf(logfd, "Archive %s contains %ld records.\n", 			outname, nrecords); }e   arcopy(infd, outfd)e register FILE	*infd; register FILE	*outfd;u /*1  * Copy (or skip if outfd == NULL) to next headers  */n {;1 	while (fgets(text, sizeof text, infd) != NULL) {r' 		if (text[0] == '-' && text[1] != '-')a
 			return; 		if (outfd != NULL) 			fputs(text, outfd); 	}$ 	text[0] = EOS;				/* EOF signal		*/ }a   arimport(infd, outfd, fname) register FILE	*infd; register FILE	*outfd;)& char		*fname;			/* Input file name		*/ /*3  * Import text, writing it in the secret ar format.)  */U {  	unsigned int	nrecords;n   	nrecords = 0;1 	while (fgets(text, sizeof text, infd) != NULL) {i 		if (text[0] == '-') {r! 			putc('-', outfd);		/* Quote	*/[ 		}f 		fputs(text, outfd);{
 		nrecords++;g 	} 	if (ferror(infd)) { 		perror(fname);3 		fprintf(stderr, "Error when importing a file\n");) 	} 	if (verbose) {" 		fprintf(stderr,i1 			"%u records read from %s\n", nrecords, fname);s 	} },   arexport(infd, outfd), register FILE	*infd; register FILE	*outfd;  /*>  * Read secret archive format, writing archived data to outfd.#  * Clean out extraneous <cr>,<lf>'so  */e {r 	register char	*tp;   1 	while (fgets(text, sizeof text, infd) != NULL) {r 		tp = &text[strlen(text)]; 8 		if (tp > &text[1] && *--tp == '\n' && *--tp == '\r') { 			*tp++ = '\n';
 			*tp = EOS;d 		}	 		if (text[0] == '-') {	 			if (text[1] != '-') 				return;  			fputs(text+1, outfd); 		}a 		else { 			fputs(text, outfd); 		}  	} 	text[0] = EOS;r }n   typedef struct filename {l 	char namepart[10];( 	char typepart[4]; } FILENAME;a   int1 match(name, pattern) register char	*name; register char	*pattern;L /*  * Pattern match between)  *	name	string argument (FILE.EXT format)n'  *	pattern	which may contain wildcards.d  *@  * Note: '*' matches all but '.' separator between file and ext.)  *	'?' matches one character, but not '.',  *  */a {m 	register int	i; 	FILENAME	namebuff;n 	FILENAME	patternbuff; 	eB 	if (breakout(name, &namebuff) || breakout(pattern, &patternbuff)) 		return (FALSE); 8 	return (match1(namebuff.namepart, patternbuff.namepart)8 	   &&	match1(namebuff.typepart, patternbuff.typepart)); }	   int  breakout(arg, buff)  char		*arg;  FILENAME	*buff;v /*-  * Parse arg ("foo.bar") into "foo" and "bar"r  * Return TRUE if trouble.  */l {) 	register char	*ap;( 	register char	*bp;y 	register int	dotseen; 	int		size;	   	dotseen = FALSE;\
 	ap = arg; 	bp = buff->namepart;u 	buff->typepart[0] = EOS;l$ 	size = (sizeof buff->namepart) - 1; 	while (*ap != EOS) {, 		if (*ap == '.') {f  			if (dotseen++)			/* 2 dots	*/ 				return (TRUE);	 			else { 	 				ap++;( 				*bp = EOS; 				bp = buff->typepart;& 				size = (sizeof buff->typepart) -1;
 				continue;D 			} 		}   		if (size-- <= 0)			/* 2 big	*/ 			return (TRUE);v 		*bp++ = *ap++; 	} 	*bp = EOS;l 	return (FALSE); }\   int\ match1(name, pattern)c. register char	*name;		/* What to look for			*/1 register char	*pattern;	/* May have wildcard			*/- /*7  * Recursive routine to match "name" against "pattern".N  * Returns TRUE if successful.  */l {a 	register char	pattbyte; 	char		namebyte;   	for (;;) {n 		/*A 		 * First check for pattern ending in '*' -- this has to succeedt 		 */ 8 		if ((pattbyte = *pattern++) == '*' && *pattern == EOS) 			return (TRUE);h 		/*? 	 	 * If not, then if both strings finish equally, it succeeds.U 	 	 */3 		if ((namebyte = *name) == EOS && pattbyte == EOS). 			return (TRUE);e 		/*# 		 * Not at end of the name string.t 		 */= 		switch (pattbyte) {z, 		case EOS:		/* End of pattern -> failure	*/ 			return (FALSE); 	&, 		case '*':		/* Wild card means "advance"	*/ 			do {( 				if (match1(name, pattern)) 					return (TRUE);+ 			} while (*name++ != EOS);' 			return (FALSE);	/* Did our best			*/r  
 		default:. 			if (tolower(namebyte) != tolower(pattbyte)) 				return (FALSE);G" 		case '?':		/* One byte joker		*/' 		case '%':		/* RT11 one byte joker		*/ # 			name++;		/* Matched this one		*/s 		}N 	} }a   #ifdef	FAKEFWILD  6 static int	fake_flag = 0;		/* Set if a file is open	*/ 					/*  0	nothing open		*/=$ 					/* +1	open, fnext not called	*/ 					/* +2	fnext called once	*/    FILE * fwild(fname, mode)
 char		*fname;  char		*mode; /*'  * "setup" to open a wildcard file nameU  */n {	 	register FILE	*fd;=   	if (fake_flag != 0) {. 		fprintf(stderr, "fwild/fnext out of sync."); 	} 	fake_flag = 0; ' 	if ((fd = fopen(fname, mode)) != NULL)x 		fake_flag++;
 	return (fd);  }r   FILE *	 fnext(fd)r
 FILE		*fd; {r 	switch (fake_flag) {t 	case 1:, 		fake_flag++;		/* First call after fwild	*/% 		return (fd);		/* File is "open"		*/( 	case 2:- 		fake_flag = 0;		/* Second call of fnext		*/L) 		fclose(fd);		/* Close existing file		*/++ 		return (NULL);		/* No more files left		*/(	 	default:?: 		fprintf(stderr, "fnext called without calling fwild\n"); 		return (NULL); 	} }c #endif   intm
 tolower(c) register int	c;h /*5  * Convert to lowercase -- Macro doesn't work on Unixo  */* { - 	return ((isupper(c)) ? c + ('a' - 'A') : c);* } 