 /*  *				b u i l d 4 . c   *+  * Process macro definitions and expansions   *&  * define(model, flag)		Define a macro,  * expand(arg, outfun, outarg)	Expand macros8  * expout(arg)			Expand macros, writing output to stdout  */    #include	<stdio.h> #include	"build.h"  ; static char	def_name[NAMESIZE];	/* Work area for define		*/   
 static char *  defname(string)  register char	*string; /*L  * String points to the first byte of a macro name (the byte after the '$').H  * Compile the name into static def_name, and return an updated argumentO  * pointer (which now points to the first byte after the name -- possibly EOS).   * Calling sequence:  *	arg = defname(arg);  *	sylookup(def_name);  */  { / 	register char	*np;		/* Name buffer pointer		*/ * 	register int	c;		/* Working character		*/1 	register int	closer;		/* Terminator if (...)		*/    	np = def_name;  	if ((c = *string) != EOS) {  	    if (c == '(' || c == '{') { 		/* 		 * $(FOO) or ${FOO}  		 */ " 		closer = (c == '(') ? ')' : '}';! 		++string;			/* Skip over '('	*/  		while (iswhite(*string))* 		    string++;			/* Leading whitespace	*/ 		while (!iswhite(*string)) 		 && *string != closer && *string != EOS % 		 && (np - def_name) < NAMESIZE - 1)  		    *np++ = *string++;- 		while (*string != closer && *string != EOS) + 		    string++;			/* Trailing whitespace	*/  		if (*string == closer)' 		    string++;			/* and closing ')'	*/  	    } 	    else {  		*np++ = c;			/* $X			*/ % 		string++;			/* update string ptr	*/  	    } 	} 	*np = EOS; 	return (string);  }				l 	 define(model, flag)N2 register char	*model;		/* Macro definition(s)			*/" int		flag;		/* Set in sy_flag			*/ /*5  * process model strings, building macro definitions.e0  * continues until an EOS is passed from nextch.  */  * Macro definitions have the following format:	  *	$X = Y   * where X may be   *	a single character   *	(TEXT) or {TEXT}   * and Y may be !  *	a string up to the next blank.   *	{ text }   *  */  {  	register int	c;/ 	register char	*tp;		/* Random text pointer		*/ 	char		*argument;   ( #define	skip	*(model = skipwhite(model))   	if (debug) 0 	    fprintf(stderr, "define(\"%s\")\n", model); 	argument = model; 	while ((c = skip) != EOS) {
 	    model++;  	    if (c == '#') { 		/*! 		 * Comment, skip to end of linet 		 */L 		while (c != EOS && c != '\n')E 		    c = *model++;D 		continue;r 	    } 	    if (c != '$') {2 		fprintf(stderr, "Expecting '$', got '%c'\n", c);? 		fprintf(stderr, " in \"%s\"\n at \"%s\"\n", argument, model); 		continue;  	    } 	    model = defname(model); 	    if ((c = skip) != '=') {e 		fprintf(stderr,o8 		    "definition of %s followed by '%c', '=' needed\n", 		    def_name, c);l 		continue;d 	    }
 	    model++;e 	    /*g' 	     * Copy the definition into work[]  	     */ 	    tp = work;  	    if ((c = skip) != '{') {_ 		/* 		 * Just a word 		 */r
 		model++;# 		while (c != EOS && !iswhite(c)) {"" 		    if (tp - work >= WORKSIZE-1)+ 			fatal("work overflow in define", model);A 		    *tp++ = c; 		    c = *model++;  		}i 	    } 	    else {o 		/*
 		 * { text }d 		 */r
 		model++; 		c = skip;t 		if (c != EOS) {o 		    model++;$ 		    while (c != EOS && c != '}') { 			if (tp - work >= WORKSIZE-1)1- 			    fatal("overflow in define {}", model);o
 			*tp++ = c;d 			c = *model++; 		    }k 		}l 		if (c != '}') {D? 		    fprintf(stderr, "definition of %s not followed by '}'\n", 
 			def_name);d 		    continue;h 		}  	    } 	    *tp = EOS;o" 	    sysave(def_name, work, flag); 	} }		    expout(arg)s char		*arg;Z /*,  * Call expand, writing the output to stdout  */	 {o 	expand(arg, out, stdout); }1   /*  * Macro expansion  */   / static int	ex_depth = 0;	/* Catch recursion		*/o   char * expand(arg, sfunc, sarg)+ register char	*arg;		/* What to expand			*/l* char		*(*sfunc)();	/* Output function			*/% char		*sarg;		/* Output argument			*/n /*I  * Output arg, expanding all macros.  Sfunc is called with each charactern  * as follows:  *	sarg = (*sfunc)(byte, sarg);y?  * Thus, to output text to a file, you could execute expand as:   *	FILE *myfile;  *	myfile = stdout;e  *	expand(arg, myfun, myfile);  * Where myfun is defined as:k	  *	FILE *N  *	myfun(byte, arg)   *	char		byte;  *	FILE		*arg;  *	{  *		if (byte != EOS)  *		    putc(byte, arg);  *		return(arg);  *0  * To output text to a buffer, do the following:  *	char *myarg;n  *	myarg = buffer;%  *	myarg = expand(arg, myfun, myarg); C  * On return, myarg will point to the EOS at the end of the string.G  * Myfun() is defined as:s	  *	char *y  *	myfun(byte, arg)	  *	char		byte;  *	char		*arg;  *	{%  *		if (arg - buffer > sizeof buffer)e*  *		    fatal("Overstuffed buffer", NULL);  *		*arg = byte;  *		if (byte != EOS)  *		    arg++;  *		return (arg);e  *	}  */e {y) 	register char	*np;		/* Name pointer			*/c2 	register SYMBOL	*sy;		/* Symbol table pointer		*/   	if (++ex_depth > 50) ) 	    fatal("Very recursive macro", NULL);L 	if (arg != NULL) {. 	    if (debug)  		printf("`%d'[", ex_depth); 	    while (*arg) {. 		if (*arg != '$') {$ 		    sarg = (*sfunc)(*arg++, sarg); 		}"* 		else if (*++arg == EOS || *arg == ' ') { 		    /* 		     * "$ " or "$<EOS>" 	 		     */e! 		    sarg = (*sfunc)('$', sarg);! 		}a 		else if (*arg == '$') {s 		    /* 		     * "$$" => "$"	 		     */l! 		    sarg = (*sfunc)('$', sarg);e 		    arg++; 		}y 		else { 		    arg = defname(arg);l% 		    sy = sylookup(def_name, FALSE);	/ 		    if (sy != NULL && sy->sy_value != NULL) {e
 			if (debug)g" 			    printf("](%s)<", def_name);, 			sarg = expand(sy->sy_value, sfunc, sarg);
 			if (debug)F 			    printf(">["); 			sy->sy_flag |= USED;  		    }  		}			/* if macro found		*/N 	    }				/* arg while loop		*/b 	}				/* if non-null arg		*/ 	sarg = (*sfunc)(EOS, sarg); 	--ex_depth; 	if (debug)	 	    printf("]");  	return (sarg);e }e  