 /*  * comm.  *  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...COM 		}C */   #ifdef	DOCUMENTATION% title	comm	Compare Files for Equality ! index		Compare Files for Equality    synopsis  ( 	comm [- [123]] file_1 file_2 [out_file]   description   > 	Comm prints lines which are common to two files.  Lines whichC 	are only in file 1 are printed in the leftmost column; those whichhB 	are only in file 2 are printed indented by one tab; those in both( 	files are printed indented by two tabs. 	.s : 	Specifying flags 1, 2, or 3 will suppress printing of the 	indicated column: 	.lm +16: 	.s.i -12;comm -12	prints only lines common to both files.: 	.s.i -12;comm -23	prints lines present in the first file, 	but not in the second.o! 	.s.i -12;comm -123	does nothing.
 	.s.lm -16> 	If the output file argument is not present, output is written 	to the standard output.   diagnostics    	.lm +8  	.s.i -8;No argument 	.s.i -8;Unknown flag  	.s.i -8;Two input files needed  	.s.i -8;Cannot open input file  	.lm -8    author
 	Martin Minow    bugs   #endif char	*documentation[] = { ( "comm prints lines common to two files",2 "        comm [- [123]] file_1 file_2 [out_file]", "", ; "Lines in file 1 only are printed in the leftmost column.", 9 "Lines in file 2 only are printed in the second column.",n7 "Lines in both files are printed in the third column.",n@ "Flags 1, 2, or 3 supress printing of the corresponding column",4 "	comm -12  prints only lines common to both files",@ "	comm -23  prints lines in the first file, but not the second", "	comm -123 does nothing", "", G "If the third file is not present, output goes to the standard output",u "",  0 };   #include <stdio.h>
 #ifdef vms #include		<ssdef.h>u #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG); #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */a #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif #define	LINESIZE	512  
 struct area { 
 	FILE	*fd; 	char	line[LINESIZE]; 
 } area[2];   FILE	*outfd;  ; char	*head[3]  = { "", "\t", "\t\t" };	/* Heading vector	*/ ! int	flag[3];				/* What's set		*/x       main(argc, argv)
 char *argv[];r {1   	register int		temp; 	register int		c; 1 	register FILE		*fdtemp;	/* Hide a DECUS C bug	*/s  
 #ifdef vms" 	argc = getredirection(argc,argv); #endif  
 	temp = 0; 	if (argc <= 1)t 		usage("No arguments");, 	if (argv[1][0] == '?' && argv[1][1] == 0) {	 		help();	 		exit(IO_ERROR);t 	}, 	if (argv[1][0] == '-' && argv[1][1] != 0) { 		while ((c = *++argv[1])) { 			switch (c) {f 			case '1': 			case '2': 			case '3':" 				c -= '1';	/* '1..3' => 0..2	*/ 				if (!flag[c]) {N 					flag[c]++;v 					temp++; 				}m
 				break; 			default:  				usage("Unknown flag"); 			} 		}[ 		head[2] = head[2 - temp];r	 		argc--;}	 		argv++;f 	} /*
  * Open filesF  */o 	if (argc < 3)" 		usage("Two input files needed");# 	for (temp = 0; temp < 2; temp++) { 2 		if ((fdtemp = fopen(argv[1+temp], "r")) == NULL) 			cant(argv[1+temp]); 		area[temp].fd = fdtemp;  	} 	if (argc > 3) {, 		if ((outfd = fopen(argv[3], "w")) == NULL) 			cant(argv[3]);( 	} 	else	outfd = stdout;2   /*"  * Fill both buffers and off we go  */i 	fillboth(); 	for (;;) {b. 		switch(equals(area[0].line, area[1].line)) {  # 		case 0:				/* File 1 == file 2	*/  			output(area[0].line, 2);m 			fillboth();	 			break;t  " 		case 1:				/* File 1 < file 2	*/ 			output(area[0].line, 0);f 			fill(0); 	 			break;t  " 		case 2:				/* File 1 > file 2	*/ 			output(area[1].line, 1);e 			fill(1);(	 			break;t 		}  	} }   
 fill(into)# int		into;		/* Fill this buffer		*/o /*)  * buffer filler.  Just does one of them.*  */R {  	if (input(into))f 		flushout(1 - into);* }   
 fillboth() /*  * Fill both buffers  */a {[ 	if (input(0)) { 		if (input(1))t! 			finis();		/* Both end filed	*/s 		else# 			flushout(1);		/* Just file 0		*/l 	} 	if (input(1)) 		flushout(0); }    input(into) ( int		into;		/* Read into this buffer		*/ /*0  * Read a line into this buffer, return 1 on eof  */o {	A 	return(fgets(area[into].line, LINESIZE, area[into].fd) == NULL);  }t   flushout(other)r# int		other;		/* Flush this one			*/	 {  	do {s" 		output(area[other].line, other); 	} while (input(other) == 0);r	 	finis();p }    output(text, which)-$ char		*text;		/* Line to output			*/) int		which;		/* Which side 1, 2, or 3		*/p {  	if (!flag[which]), 		fprintf(outfd, "%s%s", head[which], text); }l   equals(str1, str2) char		*str1;		/* Strings				*/! char		*str2;		/* to compare				*/  {a 	register char	*p1;  	register char	*p2;M   	p1 = str1 - 1;" 	p2 = str2 - 1;a 	while (*++p1 == *++p2) {  		if (*p1 == 0)*
 			return(0);  	} 	return((p1 < p2) ? 1 : 2);  }f   finis()c /*  * Exit from comm   */n {" 	fflush(outfd);  	fclose(outfd);* 	fclose(area[0].fd); 	fclose(area[1].fd); 	exit(IO_SUCCESS); }"   cant(s)  char *s; {1/ 	fprintf(stderr, "?COMM-E-input file %s\n", s);)! 	usage("cannot open input file");  }    help() /*  * Give good help   */  {  	register char	**dp;  $ 	for (dp = documentation; *dp; dp++) 		printf("%s\n", *dp); }    usage(s) char	*s; { $ 	fprintf(stderr, "?COMM-E-%s\n", s); 	fprintf(stderr,F 	  "Usage: comm [-[123]] file1 file2 [out-file].  comm ? for help\n"); 	exit(IO_ERROR); }   