 /*  *			G E T C M D  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...GTC 		}	 */   #ifdef	DOCUMENTATION  , title	getcmd	Build command files for Decus C& index		Build command files for Decus C   synopsis  * 	getcmd >result -options pattern file_list   description   ? 	Getcmd was written to aid in maintaining the Decus C compiler.? 	It is used to generate command files for building the run-time=> 	library, for example.  It is probably of limited use in other 	areas.e 	.s*# 	The following options are defined:  	.lm +166 	.s.i-16;-c		Macro command file, (for run-time library6 	build.  This prevents compiling RSX.MAC and RT11.MAC. 	.s.i-16;-d		Enable debug code.	; 	.s.i-16;-m model	"model" replaces '?' in a pattern string.M3 	.s.i-16;-r		For RT11, preface the output file with   	"R MACRO" and end it with "^C".	 	.s.lm-16 C 	If no pattern is present, patterns and wild-card descriptions will 7 	be read from the standard input.  The input format is: 	.s ! 		output_file pattern input_spec.  	.s < 	If the pattern begins with a blank, the current output_file; 	(or stdout) will be used.  If the pattern contains blanks,  	enclose it in quotes. 	.s F 	If no input_spec is present, the line is copied to the output with no6 	changes other than substitution for the model string. 	.s > 	Within a pattern, the following strings have special meaning: 	.lm +8r, 	.s.i -8;?	Replaced by the last model string1 	.s.i -8;*.*	Replaced by the filename + extensioni( 	.s.i -8;*	Replaced by the filename only	 	.s.lm -8 2 	Note that the disk and [UIC,PPN] is never output. 	.sl7 	Unflagged arguments are wild-card file specifications.S 	.s 
 	For example:s 	.sq7 	getcmd >rilbas.cmd -c OBJ:*,LST:*=SRC:RT11,SRC:* *.MAC+ 	.sOD 	The above command line builds the assembly command file for the I/O 	library in RT11 mode. 	.s)7 	getcmd >tov.cmd VAX::[C.OTSIO]*.*/VA=[5,5]*.* [5,5]*.*t 	.stH 	The above command generates an indirect command file for RSTS/E DECnet.   bugs  > 	getcmd was written to aid in maintaining the Decus C run-time 	library.  It is fairlyd< 	useless in other situations.  The build program may be more 	generally useful.   author  
 	Martin Minow.   #endif   /*  * Edit historyr  * 0.0 ??-???-??  MM	InventionD  * 0.1  5-May-81 JSL	If no filespec on a line, just copy the patternF  * 0.2  5-May-81 JSL	If no model, leave ? alone instead of deleting it.  * 0.3  4-Jun-81 MM	Changed iovtoa to fgetname  */    char	*documentation[] = {"L "Getcmd builds command files, writing them to the standard output.  Usage:",8 "	getcmd >result [flag] pattern wild_card_descriptions",& "The following switches are defined:",G "    -c		Macro command file, delete reference to RSX.MAC and RT11.MAC",' "    -d		Debug mode",i< "    -m	model	\"Model\" replaces '?' in the pattern string",@ "    -r		RT11 switch, preface output with R MACRO, end with ^C", "",vE "If no pattern is present, patterns and wild-card descriptions will",i9 "be read from the standard input.  The input format is:",.# "	output_file pattern input_spec.", J "If the pattern begins with a blank, the current output_file (or stdout)",G "will be used.  If the pattern contains blanks, enclose it in quotes.",  "", H "If no input_spec is present, the line is copied to the output with no",8 "changes other than substitution for the model string.", "", @ "Within a pattern, the following strings have special meaning:",' "	?	Replaced by the last model string", , "	*.*	Replaced by the filename + extension",# "	*	Replaced by the filename only", 3 "Note that the disk and [UIC,PPN] is never output",  "", 8 "Unflagged arguments are wild-card file specifications", "",  "For example:", I "  getcmd >[5,5]rilbas.cmd -c \"OBJ:*,LST:*=SRC:RT11,SRC:*\" [5,5]*.MAC", F "The above command line builds the assembly command file for the I/O", "library in RT11 mode.", "", H "  getcmd >iotovm.cmd \"RDVAX::DB0:[C.OTSIO]*.*/VA=[5,5]*.*\" [5,5]*.*",J " The above command generates an indirect command file for RSTS/E DECnet", 0 };   #include <stdio.h>
 #ifdef vms #include		<ssdef.h>  #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)d #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */	 #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif #define	FALSE		0 #define	TRUE		1V #define	EOS		0- #define	MAX_NAMES	500		/* Max. file names		*/f int		debug;g int		macroflag;g int		rt11flag;
 char		*model;s char		*pattern;g char		*wild_spec;g char		*out_spec; char		fullname[81];' char		filename[81];O( char		line[133];		/* Input text line		*/3 char		*text[MAX_NAMES];	/* store file names here	*/a0 char		**ttop = text;		/* Top of text pointer		*/   FILE		*infd;   main(argc, argv)
 int		argc; char		*argv[]; {b   	register int		c;' 	register int		i;+ 	register char		*ap;  . 	if (argv[1][0] == '?' && argv[1][1] == EOS) {	 		help();e 		exit(IO_ERROR);l 	}
 	model = "?";g 	for (i = 1; i < argc; i++) {	 		if (*(ap = argv[i]) == '-') {C( 			while ((c = tolower(*++ap)) != EOS) { 				switch (c) {
 				case 'd':;
 					debug++;  					break;   
 				case 'c':	 					macroflag++;L 					break;t  
 				case 'm':	 					if (++i >= argc)w 						usage("No arg after -m");e 					model = argv[i];> 					goto loop;E  
 				case 'r':  					rt11flag++; 					printf("R MACRO\n");o 					break;c   				default:$ 					bug("W", "Unknown switch", ap); 					break;1 				}  			} 		}C 		else { 			if (pattern == NULL) {  				pattern = argv[i];
 				continue;e 			} 			wild_spec = argv[i];p 			ttop = text;	 			if (process() > 0); 				doit();p 		}o loop:;	} 	/*lA 	 * pattern will be NULL if none was provided by the command line  	 */ 	if (pattern == NULL)r
 		getinput();  	if (rt11flag) 		printf("^C\n");s }c  
 getinput() /*1  * Read from stdin, process each line as it comess  */  {= 	register char	*lp;  	register int	c; 	register int	count; 	char		*skipbl();d 	char		*findbl();	
 	int		fspecs;   3 	while (fgetss(line, sizeof line, stdin) != NULL) {u 		/*0 		 * Skip over leading blanks and get file spec. 		 */c 		fspecs = count = 0;  		ttop = text; 		lp = line; 		if (*lp > ' ') {  			out_spec = lp = skipbl(line); 			lp = findbl(lp); 
 			if (debug) , 				fprintf(stderr, "new stdout = \"%s\"\n", 						out_spec);0 			if (freopen(out_spec, "w", stdout) == NULL) {1 				bug("E", "Can't open output file", out_spec);	 				error("Can't continue"); 			} 		}| 		/*% 		 * Skip over blanks and get patternc 		 */  		lp = findqbl(lp, &pattern);a 		lp = skipbl(lp); 		while (*lp != EOS) {  			lp = findqbl(lp, &wild_spec); 			count += process(); 			fspecs++; 		}			. 		if (fspecs == 0) {		/* No filespecs found */ 			strcpy(fullname,"*.*"); 			save(fullname); 		}u 		if (count > 0 || fspecs == 0)t
 			doit(); 	} }n 		  	 process()( /*  * Find files, return how many  */" {r) 	register int		count;		/* Count files		*/f   	if (debug)r: 		fprintf(stderr, "Wild card spec = \"%s\"\n", wild_spec);. 	if ((infd = fwild(wild_spec, "r")) == NULL) {$ 		bug("E", "Can't open", wild_spec); 		return(0); 	}0 	for (count = 0; fnext(infd) != NULL; count++) { 		setname(infd); 		if (debug)5 			fprintf(stderr, "Curr file = \"%s\"\n", fullname);e 		if (macroflag && 				(streq(fullname, "RSX.MAC")t$ 				|| streq(fullname, "RT11.MAC"))) 			continue; 		save(fullname);t 	} 	if (debug)e3 		fprintf(stderr, "%d files processed\n\n", count);  	if (count == 0)* 		bug("W", "No files matched", wild_spec); 	return(count);' }p   doit() { / 	register char		**textp;	/* Pointer to names	*/+ 	register char		*pp;		/* Pattern pointer	*/p* 	register int		c;		/* Current character	*/  , 	for (textp = text; textp < ttop; textp++) { 		/* 		 * Get file name part, too 		 */? 		strcpy(filename, *textp);r: 		for (pp = filename; (c = *pp) != EOS && c != '.'; pp++); 		*pp = EOS;+ 		for (pp = pattern; (c = *pp++) != EOS;) {* 			switch (c) {d   			case '*':% 				if (*pp == '.' && pp[1] == '*') {n 					printf(*textp);
 					pp += 2;m 				}o	 				else   					printf(filename);
 				break;   			case '?': 				printf(model);
 				break;   			default:T 				putchar(c);	 			} 		}G 		putchar('\n'); 		free(*textp);N 	} }l   setname(fd)c FILE 		*fd;f /*  * Build file name  */a {f 	register char		*wp; 	register int		c;r 	char			work[81];e   	fgetname(fd, work); 	/* = 	 * Skip backwards to the rightmost colon in the device name.r 	 */B 	for (wp = &work[strlen(work)]; wp > work && wp[-1] != ':'; wp--); 	/* ' 	 * Skip over [UIC] or [PPN] if presents 	 */  	if (*wp == '[' || *wp == '(') {5 		while ((c = *wp++) != EOS && c != ']' && c != ')');c 		if (c == 0) { 4 			fprintf(stderr, "?GETCMD-bad file name \"%s\"\n", 					work);. 			wp--; 		}- 	} 	strcpy(fullname, wp); 	/*- 	 * Don't include version' 	 */9 	for (wp = fullname; (c = *wp) != EOS && c != ';'; wp++);  	*wp = EOS;" }A   save() /*;  * Save fullname, add it to the text area (in sorted order)   */i {c 	register char	**textp;b 	register char	**insert; 	register int	i;  , 	for (textp = text; textp < ttop; textp++) {, 		if ((i = strcmp(*textp, fullname)) == 0) {4 			fprintf("?GETCMD-E-Duplicate file name \"%s\"\n", 				fullname);
 			return; 		}  		else if (i > 0)o	 			break;  	} 	insert = textp; 	textp = ttop;  	if (++ttop >= &text[MAX_NAMES])? 		error("?GETCMD-F-Too many file names, %d max.\n", MAX_NAMES);t   	while (textp >= insert) { 		textp[1] = *textp;
 		textp--; 	}6 	if ((*insert = malloc(strlen(fullname) + 1)) == NULL)4 		error("?GETCMD-F-No room for \"%s\"\n", fullname); 	strcpy(*insert, fullname);y }. 	m   findqbl(text_ptr, start) char		*text_ptr; char		**start; /*>  * Skip leading blanks, find text (handle quoted text strings)%  * return true start of text in start   */J {L 	register char	*lp;. 	register int	c; 	char		*skipbl();u 	char		*findbl();o    	*start = lp = skipbl(text_ptr); 	if ((c = *lp) == EOS)
 		return(lp);: 	else if (c == '"') {* 		lp++;t 		*start = lp;& 		while ((c = *lp) != EOS && c != '"') 			lp++; 		if (c == EOS) {u1 			bug("E", "Missing quote in pattern", pattern);  			return(lp); 		}b 		*lp++ = EOS; 	} 	else lp = findbl(lp); 	if (debug)b7 		fprintf(stderr, "unscanned (return) = \"%s\"\n", lp);  	return(lp); }    char * skipbl(text_ptr) char		*text_ptr; /*  * Skip over blanks   */- {J 	register char	*tp;a 	register int	c;  9 	for (tp = text_ptr; (c = *tp) != EOS && c <= ' '; tp++);n 	return(tp); }    char * findbl(text_ptr) char		*text_ptr; /*D  * Skip to the next blank, terminate the string and step the pointer  */  {m 	register char	*tp;u  & 	for (tp = text_ptr; *tp > ' '; tp++);	 	if (*tp)r 		*tp++ = EOS; 	return(tp); }s   help() /*  * Give good helpM  */c {a 	register char	**dp;  $ 	for (dp = documentation; *dp; dp++) 		fprintf(stderr, "%s\n", *dp);o }\   usage(s) char	*s; {t 	bug("E", s, NULL);	) 	fprintf(stderr, "For help, GETCMD ?\n");e 	exit(IO_ERROR); }I   bug(severity, mess, arg) char		*severity; char		*mess; char		*arg;  /*  * Error messagesi  */  {e" 	fprintf(stderr, "%cGETCMD-%s-%s",2 		(*severity == 'W') ? '%' : '?', severity, mess); 	if (arg != NULL)t# 		fprintf(stderr, ": \"%s\"", arg);u 	fprintf(stderr, "\n");a } 