 /*=  *	getrno -- Convert macro comments to .rno for documentation   */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...GTR 		}  */   #ifdef	DOCUMENTATION' title	getrno	Build Documentation Source / index		Convert Comments To Runoff Source Format    synopsis  2 	getrno [-options] -o output -h header input_files   description   C 	getrno reads a list of files, compiling comments to runoff source.  	Switches are: 	.lm +8   
  -d	Debugging   %  -b	Blank lines in C source become .s     -c	C source files (default)    -m	Macro source files  &  -r	RSTS/E title hack flag;  see below  0  -u	Usage -- output an abbreviated documentationC 	containing only the information between "Usage" and "Description". ' 	(Note: ignored if -c option selected.)e  0  -w	Wizard:  output package internal calls, too.  4  -o file	Write output to "file", rather than stdout.  C  -h file	Process "file" as a header file and prepend to the output.    	.lm -8 ; 	There is an error in the RSTS/E V7.0 runoff (RNO.TSK) such-= 	that title lines do not get correct page numbers.  If the -rS? 	flag is set, .t lines in the header program will be marked fort> 	the fixdoc.c program.  Note, for a title to be recognized, it 	must have the exact form:  ' 		.t Anything  (or .t ########Anything)	   	Getrno will change it to:   		.t [[Anything]]   5 	and fixdoc.c will look for same for post processing.i 	.tp 10s   C source file format  ) 	C source must have the following format:e   		#ifdef	DOCUMENTATION 		title	tool_name	header_text  		index	index text 		section_head 			text for the sectionS 		#endif  % 	Note that the comment leadin must be    		#ifdef<tab>DOCUMENTATION   	.tp 8B  	In order to define a uniform environment, getrno will insert the8 	following commands at the beginning of the output file:  ' 		.no autosubtitle .style headers 3,0,0d 		.pg.uc.ps 58,80.lm 8.rm 72 		.hd  		.hd mixed 
 		.head mixedo  F 	(Various flavors of runoff will flag one or more of these commands as 	errors, none of them fatal.)m  F 	Getrno inserts the following commands between the data from each pair 	of files scanned:   		.lm 8.rm 72.nhya  E 	Within the body of the documentation, lines are handled depending oneD 	what column their text starts in (i.e. where the first non-<space>,F 	non-<tab> character falls); a <tab> is always assumed to put the nextA 	character at column 8.  (And you thought card images were dead!)   ( 	An empty line becomes a .space command.  > 	Section heads begin in column 1.  They will be left-justifiedG 	and printed in upper case with a trailing ":".  The only section headsa= 	with any special meaning to getrno are "title", "index", andyA 	"internal"; they are recognized regardless of case.  "Title" andnD 	"index" must come first, as shown in the example.  "Internal" flagsE 	the beginning of data that is output only if the -w switch was used;aA 	the next section head ends the "wizards only" data.  However, if ? 	"internal" appears before any other section head (not counting1@ 	"index"), nothing at all will be output for this file unless -w	 	appears."  TF 	Normal text starts in column 8 with a character other than a <tab> orF 	<space>; it will be justified and filled, and will start in column 16A 	on the paper.  The <space>'s and <tab>'s that filled the first 7t 	columns are stripped.  G 	A line that has a <space> or <tab> in column 8 will be output with thetD 	<space>'s and <tab>'s that filled the first 7 columns stripped, and  	with runoff set to nofill mode.  F 	A line that starts with a <space> but has a non-blank before column 8C 	will have the leading <space>'s stripped and will be output with at@ 	leading ".i -8;".  Lines of this form are normally used between8 	".lm +8"/".lm -8" pairs, as shown in the example below.  G 	A line whose first character AFTER stripping leading blanks as defined G 	above is a "." has leading runoff commands.  It is your responsibility>F 	to maintain alignment and to quote runoff-specific characters on suchD 	lines; in all other cases, getrno will do it for you.  For example: 	.tp 9  
 		diagnostics8	 			.lm +8e! 			.s.i-8;bad file _& other stuff  			.s.i-8;something else	 			.lm -8- 			.si 		author	 			etc...n  F 	Avoid manipulating fill mode directly.  Getrno keeps track of whetherF 	it has set runoff to fill or nofill mode, and can get confused if youF 	shift modes on it.  Hence, the results may then not be as you expect.  ; 	Note that the above example can be more easily handled as:  	.tp 11s  
 		diagnostics 	 			.lm +8r   		 bad file & other stuff    		 something else.	 			.lm -8i   		author	 			etc...    Macro source file format  0 	The Macro input must have the following syntax:   		.title	name	Title line 	 ;m 	 ;+				(Start of commentary)  	 ;n+ 	 ; Index		Short description for kwik indext& 	 ; Index		(Another short description) 	 ;f' 	 ; Usage		(Start of usage information)u 	 ;a3 	 ;	Usage information, output, starting in column 1e1 	 ;	exactly as it is written (rno .nf mode).  The 4 	 ;	leading semicolon is not output, but the tab (or 	 ;	spaces) is.g 	 ;. 	 ; Description	 	 ;r0 	 ;	Description, output, starting in column 8 in4 	 ;	runoff .fill mode, except that any line starting1 	 ;	with ";<tab><TAB or SPACE>" will be output iny4 	 ;	.no fill mode.  The leading ";<tab>" will not be 	 ;	output.( 	 ;e1 	 ;	A line consisting of just ";" will generate aa, 	 ;	runoff .space while a line consisting of4 	 ;	";<SPACE>text" will generate ".indent -8 ;text". 	 ;n 	 ;-	(End of commentary)  = 	If the wizard flag (-w) is not given, a Macro source line ofs 	the format:   	; Internal   A 	may be used to signal the start of package-internal information.lB 	If "Internal" preceeds "Usage", no information will be output forC 	this file.  If it follows "Usage" or "Description", text followingo7 	(up to the next section initiator) will not be output.;   Header file format  7 	The header file is assumed to be in runoff format.  Itx 	should start as follows:8  % 		.comment Set top-of-form at 4 lines  		.comment below perforation.o, 		.ps 58,80	! 58 lines per page, 80 columns. 		.lm 8		! left margin at 8s 		.rm 72		! right margin at 72! 		.hd Mixed	! Mixed case headingsr  A 	Because the left margin is set to 8, titles and subtitles should  	be written as:s   		.t  ########Titlet 		.st ########Subtitle  @ 	The wizard flag may be used to select parts of the header file:   		.comment wizarde 			*** For wizards only ***o 		.comment elsel 			*** For non-wizards only ***t 		.comment mundane 			*** Exit wizard section ***  E 	A line indicating the date on which the documentation was built, anda7 	optionally some other information, can be inserted by:    		.comment date[ info]  > 	The optional info will be included on the date line, which isF 	centered.  A single <space> must appear after "date" if info appears;9 	it is not part of info.  The format of the date line is::  / 		Document compiled <today's date><space>[info]o  @ 	The date inserted is in the format returned by ctime() (so it's 	actually the date and time).n  F 	The format of all the comments is EXACTLY ".comment<space>argument" - 	one space only.   Workfile format:  > 	Each file builds one or more records (lines) in the workfile.> 	The first has the title line, (information following .title).: 	To allow building an index, this should be in the format:   		name<tab>Title information  9 	Following this are lines containing .rno text.  The lastt: 	line is followed by a record containing "!!" in the first 	two bytes.(  > 	Records with "!" in the first byte may be used to communicateA 	information between passes:  they are not written to the output..: 	This allows writing Usage information as a separate file.  F 	Note that there is a bug in the RSTS RNO (as distributed with VersionA 	7.0).  Consequently, if your runoff source has chapter headings,e; 	you should not have explicit titles, or have page numbers.r   bugs  @ 	Getrno was written to aid in documenting the Decus C libraries.A 	(I.e., getrno and the library documentation are interdependent.)fB 	An attempt has been made to make the C-style processing generally? 	useful; the Macro-style processing is more closely tied to thei@ 	library documentation and is probably of less general interest.D 	Further, the program, particularly in Macro mode, is very sensitive? 	to the exact format of the input; minor variations can produceiA 	unexpected results.  Some attempt has been made to avoid this ina8 	C-style processing; in Macro mode, you are on your own.  @ 	Due to the size of the files involved, the usage option (-u) is= 	no longer used in building library documentation, and is note, 	supported in C-mode.  Perhaps it should be.  D 	There should be a way to pass a "#" through to runoff within a line& 	that is otherwise processed normally.  A 	All files are processed in the same mode.  It might be useful tonA 	allow mixed-mode processing so that libraries consisting of bothb& 	Macro and C modules could be handled.   diagnosticsr  9 	A warning message is printed if a file does not have any  	documentation.g  ; 	There are many other messages, hopefully self-explanatory.t   author  
 	Martin Minowd   #endif   /*	Revision History.  *	0.0 ??-???-??  MM	Invention0  *	1.0 ??-???-??  MM	Added support for C source.*  *	1.1 24-Jun-82 JSL	Added ".comment date"?  *	2.0 28-Jun-82 JSL	Many minor cleanups.  Support 8-bit ascii.mB  *	2.1 30-Jun-82 JSL	Go by columns instead of leading <TAB>/space;(  *				added -m, made C mode the default.?  *	2.2 16-Jul-82 JSL	Indented lines have RUNOFF char's escaped.   */c   #include	<stdio.h> #ifndef	nomacarg #include	<ctype.h> #endif   #define	EOS		0 #define	FALSE		0 #define	TRUE		1R #define REALSHARP	'\001' #define	NENTRIES	200 #define	NAMESIZE	17M #define	WORKFILE	"getrno.tmp"* #define	LINESIZE	257   typedef struct {) 	char	e_name[NAMESIZE];	/* Entry name		*/S# 	long	e_place;		/* File position	*/2 } ITEM;y   ITEM	entries[NENTRIES];  ITEM	*free_entry = entries;   #define	ELAST	&entries[NENTRIES]   extern	long	ftell();  ( int		rstshack = 0;		/* If -r flag set	*/0 unsigned	linect = 0;		/* Needed for debugging	*/( int		debug = 0;		/* Set for debugging	*/( int		uflag = 0;		/* Set if -u flagged	*/) int		wizard = 0;		/* Set if -w flagged	*/E+ int		cflag = TRUE;		/* Set if -c flagged	*/f  0 int		fill_flag = TRUE;	/* If runoff will fill	*/   char		line[LINESIZE];* char		temptext[LINESIZE];  char		macfile[81];! char		*section;		/* For bug()		*/M. char		header[LINESIZE];	/* Header file name	*/  FILE		*infd;			/* Input file		*/$ FILE		*workfd;		/* Temporary file	*/" long		place;			/* For work file	*/2 char		name_text[NAMESIZE];	/* From title header	*/3 char		title_text[LINESIZE];	/* From title header	*/  extern char	*skipbl();   /*"  * Define  C documentation layout:,  *	.left margin	8	(16 in documentation body)  *	.right margin	72f?  * Note: various flavors of runoff give various error messages,r  * none fatal.  */	  8 char	*layout = ".no autosubtitle .style headers 3,0,0\n\; .pg.uc.ps 58,80.lm 8.rm 72\n.hd\n.hd mixed\n.head mixed\n";r  & char	*interfile = ".lm 8.rm 72.nhy\n";   o main(argc, argv)
 int		argc; char		*argv[]; {m 	register int	i; 	register char	*ap;S 	register char	c;    	for (i = 1; i < argc; i++) {; 		ap = argv[i];  		if (*ap == '-') {u  			switch (c = tolower(ap[1])) { 			case 'c': 					cflag = TRUE; 					break;v   			case 'd':	debug++;g 					break;r   			case 'm': 					cflag = FALSE;  					break;t   			case 'r':	rstshack++; 					break;\   			case 'u':	uflag++;r 					break;d   			case 'w':	wizard++; 					break;f   			default:  				switch (c) {  
 				case 'h':  					if (++i >= argc)[& 					    error("?No file after -h\n"); 					strcpy(header, argv[i]);f 					break;<  
 				case 'o':	 					if (++i >= argc)a& 					    error("?No file after -o\n");& 					if (freopen(argv[i], "w", stdout) 							== NULL)  						cant("output", argv[i]); 					break;s   				default:' 					error("?Illegal switch '%c'\n",c);: 				}c 				argv[i-1] = NULL;	 			}- 			argv[i] = NULL;		/* Erase this argument	*/z 		}; 	} 	/*e0 	 * Now open the work file and process all files 	 */- 	if ((workfd = fopen(WORKFILE, "w")) == NULL)i 		cant("work", WORKFILE);p   	for (i = 1; i < argc; i++) {< 		if ((ap = argv[i]) == NULL)i" 			continue;		/* 'Twas a switch	*/& 		if ((infd = fwild(ap, "r")) == NULL) 			cant("wild card input", ap);  		else {  			while (fnext(infd) != NULL) { 				filename(infd, macfile); 				if (debug)( 					fprintf(stderr, "* %s\n", macfile); 				linect = 0;[ 				process(); 			} 		}r 	} 	if (debug)  		fprintf(stderr, "* EOF\n");  	/*a/ 	 * All file information read, now write it outW 	 */ 	fclose(workfd); 	doheader(); 	if (debug)p* 		fprintf(stderr, "* Header processed\n");- 	if ((workfd = fopen(WORKFILE, "r")) == NULL)a% 		cant("work (reopening)", WORKFILE);) 	puts(interfile);(
 	output(); 	fgetname(workfd, line); 	fclose(workfd); 	delete(line); }i a filename(fd, outbuf)
 FILE		*fd; char		*outbuf; /*4  * Get the file name, account number, and extension.1  * Remove the device name and the version number.   */F {) 	register char	*tp;e 	register char	*op;w 	register int	c;   	fgetname(fd, temptext); 	/*; 	 * Skip over the device namer 	 *// 	for (tp = temptext; (c = *tp++) && c != ':';);L 	if (c == EOS) 		tp = temptext; 	/*n. 	 * Don't bother outputting the version number 	 */, 	for (op = tp; (c = *op) && c != ';'; op++); 	*op = EOS;i 	/* * 	 * Copy the file spec, forcing lowercase. 	 */# 	for (op = outbuf; (c = *tp++) ;) {b 		*op++ = tolower(c);R 	} 	*op = EOS;n }   
 doheader() /*  * Process the header file  */p {  	register int	inwizard;g 	register int	skipit;m 	register char	*lp;;   	if (*header == EOS)	 		return; + 	if ((infd = fopen(header, "r")) == NULL) {'! 		fprintf(stderr, "can't open ");t 		perror(header);'	 		return;t 	} 	strcpy(macfile, header);/ 	inwizard = FALSE; 	skipit = FALSE; 	linect = 0; 	while (getline(infd)) {' 		if (match(line, ".comment wizard")) {f 			if (inwizard)- 				bug("headfile: embedded .comment wizard",* 						NULL); 			inwizard = TRUE;  			skipit = !wizard; 		} * 		else if (match(line, ".comment else")) { 			if (!inwizard)g- 				bug("headfile: else, no .comment wizard",u 						NULL); 			elsen 				skipit = !skipit;  		}	- 		else if (match(line, ".comment mundane")) {e 			if (!inwizard)}0 				bug("headfile: mundane, no .comment wizard", 						NULL); 			inwizard = FALSE; 			skipit = FALSE; 		}f 		if (!skipit) { 			if (rstshackf 			 && line[0] == '.'	 			 && tolower(line[1]) == 't'. 			 && (isspace(line[2]) || line[2] == ';')) { 				lp = &line[2];( 				while ((*lp != EOS) && isspace(*lp))
 					lp++; 				if (*lp == ';')	
 					lp++; 				printf(".t [[%s]]\n", lp); 			}/ 			else if ((lp = match(line, ".comment date"))	+ 			      && (isspace(*lp) || *lp == EOS)) { * 				printf(".c ;Document compiled %s%s\n", 					ctime(0), lp);d 			} 			else; 				printf("%s\n", line);s 		}  	} 	fclose(infd); 	macfile[0] = EOS; }t c	 process()l /*1  * Process input text, saving it in the workfile.(  */c {i 	register int	flag;'  
 	if (cflag) {& 		if (docstuff()) 
 			return; 	} 	else {* 		section = "Title scan";l
 		title(); 		section = "Usage scan";[ 		if ((flag = usage()) == 2)
 			return; 		else if (flag && !uflag) { 			section = "Document scan";p
 			rest(); 		}	 	} 	fill_flag = TRUE;+ 	save("!!", FALSE);			/* Terminate entry	*/	 }s  
 docstuff() /*L  * Process C documentation.  Return FALSE if all OK, TRUE if output for this  * file should be discarded.  */t {  	register int		titlestate; 	register int		skipit;   	skipit = FALSE; 	while (getline(infd)) { 		if (match(line, "#ifdef")t- 		 && streq(skipbl(line+6), "DOCUMENTATION"))"	 			break;f 	} 	if (feof(infd)) {@ 		fprintf(stderr, "Warning: no documentation in %s\n", macfile); 		return (TRUE); 	} 	/*  	 * Do some documentation! 	 */+ 	titlestate = 0;				/* No title seen yet	*/u 	while (getline(infd)) { 		if (match(line, "title")) {l 			savetitle(skipbl(&line[5]));f( 			titlestate = 1;		/* Title, no real	*/ 						/* section heads yet	*/  		}s  		else if (match(line, "index")) 			continue; 		else { 			switch (titlestate) {
 			case 0: 				if (line[0] == EOS)A 					continue; 				section = "document scan";( 				bug("Need a title, using", macfile); 				strcpy(name_text, macfile);R 				strcpy(title_text, "");o 				/* 				 * Fall throught 				 */	
 			case 1: 				if (line[0] == EOS)l 					continue;+ 				if (!wizard && match(line, "internal"))i 					return (TRUE);t 				savename();* 				save(".lm +8", FALSE); 				if (wizard) {* 					concat(temptext,t 						".s.i -8;File name:\t",; 						macfile, NULL);t 					save(temptext, FALSE);	 					save(".s 2", FALSE);c 				}; 				concat(temptext," 					".s.i -8;NAME:\t", name_text, 					" -- ", title_text, NULL);_ 				save(temptext, FALSE); 				save(".s.f", FALSE); 				fill_flag = TRUE;  				titlestate = 2;  				/* 				 * Fall through	 				 */;' 			case 2:			/* Write the .rno stuff	*/l 				if (match(line, "#endif")) 					return(FALSE);e$ 				if (!wizard && isgraph(line[0]))& 					skipit = match(line, "internal"); 				if (!skipit) 					docline();L 			} 		}s 	} 	return (FALSE); }	 s	 docline()  /*#  * Process a line from a c document	  */s {- 	register char		*lp; 	register int		skip;   	switch(line[0]) {  
 	case EOS: 		save("",FALSE);f 		break;  
 	case ' ':" 		for (skip = 1; skip < 8; skip++) 			if (line[skip] == '\t') 				goto tabcase;: 			else	if (line[skip] != ' ') 					break;(	 		fill();i  G /* The following two save()'s are done in two calls so that they end	*/iE /* up on two lines; otherwise, runoff characters in the line won't	*/  /* get "escaped". 							*/	 		save(".i -8",FALSE); 		save(&line[skip],FALSE); 		break;   	case '\t':e 		skip = 0;  tabcase:0 		if (line[++skip] == ' ' || line[skip] == '\t') 			nofill(); 		else
 			fill(); 		save(&line[skip],FALSE); 		break;  	 	default:l 		/* 		 * sub-header	 		 */b# 		for (lp = line; *lp != EOS; lp++)) 			*lp = toupper(*lp); 		if (lp[-1] != ':') { 			*lp++ = ':';o
 			*lp = EOS;  		}a	 		fill();*) 		concat(temptext, ".i -8;", line, NULL);h 		save(temptext, FALSE); 		break; 	} }a " title()* /*  * First, skip to the titlee  */e {i 	register char		*lp; 	register char		*np;   	while (getline(infd)) { 		lp = skipbl(line); 		if (!match(lp, ".title")); 			continue; 		savetitle(skipbl(lp + 6)); 		break; 	} }  f
 savetitle(lp)	 register char		*lp;b /*:  * Save the title text, on entry lp -> just after "title "  */( {- 	register char		*np;   	place = ftell(workfd);	 	np = name_text;= 	while (*lp > ' ' && np < &name_text[sizeof name_text - 2]) {E 		*np++ = *lp;+ 		if (*lp++ == '_')	/* Needed for runoff	*/  		    *np++ = '_'; 	}* 	while (np < &name_text[sizeof name_text]) 		*np++ = EOS;  	strcpy(title_text, skipbl(lp)); }t l
 savename() /*7  * Save info. in name/place which were setup by title()   */f {a 	register ITEM	*ep;r 	register ITEM	*lastep;    	/*l 	 * Save in sorted order 	 */& 	if ((lastep = free_entry++) >= ELAST)1 		error("?Too many files, %d maximum", NENTRIES);w" 	for (ep = entries; ep < lastep &&- 			strcmp(ep->e_name, name_text) <= 0; ep++);(  	for (; lastep > ep; lastep--) {( 		lastep->e_place = (lastep-1)->e_place;5 		copy(lastep->e_name, (lastep-1)->e_name, NAMESIZE);( 	} 	ep->e_place = place;t' 	copy(ep->e_name, name_text, NAMESIZE);m 	/*c 	 * Save the title linel 	 */A 	save((title_text[0]) ? title_text : "!", TRUE);	/* Title line	*/  	fill_flag = TRUE; } 
 #ifdef	vms copy(out, in, count) char		*out;	
 char		*in; int		count;d /*&  * Copy a buffer -- not in vms library  */l {e 	while (--count >= 0) {e 		*out++ = *in++;e 	} }  #endif t inte usage()- /*:  * Skip to ";+" (ignored what preceeds), then to "; Usage"G  * and put out usage section.  Return 1 if ok, 0 if trouble, 2 to skip.(  */_ {e 	register char	*lp;) 	register int	usage_seen;e 	register int	skipit;t   	skipit = FALSE;  	for (;;) {				/* Skip to ;+		*/ 		if (!getline(infd)) { 8 			fprintf(stderr, "Warning, no documentation for %s\n",
 				macfile);d# 			return(0);		/* Ignore if none	*/l 		}y' 		if (line[0] == ';' && line[1] == '+')o	 			break;+ 	} 	usage_seen = 0; 	while (getline(infd)) { 		if (line[0] != ';') { # 			bug("Expecting ';', got", line);p
 			return(0);c 		}  		else if (line[1] == 0) { 			if (usage_seen && !skipit)s 				save(&line[1], 1); 			continue; 		}  		else if (line[1] == '-') {% 			bug("No Description, etc.", NULL); 
 			return(0);g 		}e 		else if (line[1] == ' ') {% 			if (match(&line[2], "internal")) { $ 				if (wizard) {		/* Do internal	*/ 					if (usage_seen) 						unjust();' 					continue; 				}  				else if (usage_seen) { 					skipit = TRUE;( 					continue; 				}  				else	return(2);x 			}" 			else if (usage_seen == FALSE) {! 				if (match(&line[2], "index"))  					continue;  				if (match(&line[2], "usage")& 				 || match(&line[2], "synopsis")) { 					savename(); 					usage_seen = TRUE;. 					save(".lm +8.nf", FALSE); 					if (wizard) { 						concat(line,! 						    ".s.i -8;File name:\t",	 						    macfile, NULL);a 						save(line, FALSE); 						save(".s 2", FALSE); 					}  					save(".i -8;Usage", FALSE); 					save("!b", FALSE);	 					fill_flag = FALSE;	 					continue; 				}  			} 			if (line[2] >= 'A') { 				if (usage_seen)n 					save("!e", FALSE);n 				return(1); 			}+ 			else if (usage_seen && line[2] == ' ') {s 				if (!skipit) { 					unjust(); 				}s
 				continue;	 			} 		}m 		else if (usage_seen) { 			if (line[1] == '\t') {n 				if (!skipit) 					save(&line[2], TRUE);
 				continue;L 			} 		}	% 		bug("Ununderstandable line", line);F 		return(0); 	}# 	bug("No ;- at end of file", NULL);s 	return(0);S }	 	 rest() /**  * Output the remainder of the commentary.+  * The line buffer contains "; Description"   */s {( 	register int	skipit;u   	skipit = 0; 	indent(&line[2]); 	while (getline(infd)) { 		if (line[0] != ';') {j. 			bug("Line doesn't start with a ';'", line); 			continue; 		}{ 		else if (line[1] == '-') { 			save(".lm -8.fill", FALSE); 			fill_flag = 1;o
 			return; 		}	 		else if (line[1] == EOS) { 			if (!skipit)e 				save(&line[1], 1); 		}e 		else if (line[1] == ' ') { 			if (line[2] < 'A') {  				if (!skipit) { 					unjust(); 				}  			}	 			else {r 				if (!wizard) {% 					if (match(&line[2], "internal"))u 						skipit++;  					else	skipit = 0;i 				}l 				if (!skipit) 					indent(&line[2]); 			} 			continue; 		}w 		else if (line[1] == '\t') {; 			if (skipit)
 				continue;- 			else if (line[2] <= ' ') {L
 				nofill();l 				save(&line[2], TRUE);  			}	 			else {] 				fill();	 				save(&line[2], TRUE);i 			} 			continue; 		}i 		else& 			bug("Ununderstandable line", line); 	}% 	bug("Unexpected end of file", NULL);  	save(".lm -8.fill", FALSE); })   unjust() /*  * Unjustify the lineu  */	 {k 	register char	*lp;k   	line[0] = REALSHARP;f! 	for (lp = line + 1; *lp == ' ';)  		*lp++ = REALSHARP; 	indent(line); }[ = save(text, dotflag)i char		*text;
 int		dotflag;  /*C  * Write the text to the work file.  If dotflag is set, initial '.' 
  * is quoted.	  */) {  	if (dotflag && *text == '.')} 		putc('_', workfd);5 	fprintf(workfd, "%s\n", (*text != 0) ? text : ".s");g }n e indent(text) char		*text; /*  * Save an indented text item   */u {)  % 	sprintf(temptext, ".i -8;%s", text);r 	save(temptext, FALSE);n }] R fill() /*  * Turn on fill mode  */  {; 	if (!fill_flag) { 		save(".fill", FALSE);  		fill_flag = TRUE;g 	} }r t nofill() /*  * Turn off fill modee  */  {t 	if (fill_flag) {o 		save(".nf", FALSE);. 		fill_flag = FALSE; 	} }    intl match(text, lookfor) register char	*text; register char	*lookfor;( /*J  * If the beginning of text matches lookfor (ignoring case), followed by aE  * no-alphanumeric, returns pointer to the first thing after lookfor;rA  * otherwise, returns NULL.  lookfor must always be in lowercase.e  */  {; 	while (*lookfor != EOS) {% 		if (tolower(*text++) != *lookfor++)g 			return(NULL); 	}& 	return(isalnum(*text) ? NULL : text); }  l output() /*  * Write out all records  */a {  	register int		namlen; 	register char		*tp;
 	int			stars;	 	register ITEM		*ep;  
 	if (cflag) {* 		puts(layout);  	}, 	for (ep = entries; ep < free_entry; ep++) {  		fseek(workfd, ep->e_place, 0); 		if (!getline(workfd)) {a" 			bug("Can't read record", NULL);0 			fprintf(stderr, "rfa = %08o\n", ep->e_place); 			continue; 		}o 		if (uflag) {+ 			printf(".tp 10.s 4.lm +8.nf\n.i -8 ;%s",t 				ep->e_name); 			if (line[0] != '!') 				printf("\t%s", line);t 		}* 		else {( 			printf(".st ########%s", ep->e_name); 			if (line[0] != '!') {* 				namlen = 8 - (strlen(ep->e_name) & 7); 				while (--namlen >= 0)y 					putchar('#'); 				printf("%s", line);r 			} 			printf("\n.pg\n.hl 1 ");l 			if (line[0] != '!') 				printf("^&%s\\&\n", line); 			else  				printf("#\n"); 			printf(".s 2\n.c ;"); 			namlen = 4;, 			for (tp = ep->e_name; *tp != EOS; tp++) {# 			    if (*tp == '_')		/* Hack		*/p	 				tp++;  			    namlen++; 			}& 			for (stars = namlen; --stars >= 0;) 				putchar('*');#. 			printf("\n.c ;* %s *\n.c ;", ep -> e_name);& 			for (stars = namlen; --stars >= 0;) 				putchar('*');- 		}e 		printf("\n.s 2\n");' 		if (uflag) { 			/*l 			 * Usage  			 */ 			while (getline(workfd) &&' 					line[0] != '!' && line[1] != 'b');i 			while (getline(workfd)) {) 				if (line[0] == '!' && (line[1] == 'e'  						|| line[1] == '!')); 					break;t 				writeout(line);p 			} 		}* 		else { 			/*p 			 * Not usagee 			 */ 			while (getline(workfd)) { 				if (line[0] == '!') {* 					if (line[1] == '!') { 						break; 					} 				}f% 				else if (cflag && line[0] == '.')	 					puts(line); 				else 					writeout(line); 			} 		}  		puts(interfile); 	} }/ 	 writeout(text) char	*text;	 /*B  * Write this line to the .rno output, watching out for weird .rnoE  * characters.  Note: to put a wierd .rno character out, flag it with	  * an initial underline.  */p {	 	register char	c;  	register char	*tp;g   	tp = text;w 	while ((c = *tp++) != 0) {	 		switch (c) { 		case REALSHARP:n 				putchar('#');	
 				break; 		case	'_': % 				if (tp - text == 1 && *tp == '.')  					goto ignore;	 		case	'%':w 		case	'&':; 		case	'\\': 		case	'^':i 		case	'#':  				putchar('_'); 
 		default: ignore:				putchar(c); 		}h 	} 	putchar('\n');n }u o getline(fd) 	 FILE	*fd;r /*=  * Read a line from fd into line[].  Return 0 at end of file.n  */  {e 	register char	*lp;g  , 	if (fgets(line, sizeof line, fd) == NULL) { 		if (debug)6 			fprintf(stderr, "* end of \"%s\" after %u lines\n", 				macfile, linect);	 		return(0); 	}
 	linect++; 	/*-: 	 * Erase trailing <Newline>, spaces, and tabs.  Note that& 	 * line[strlen(line)] is the newline. 	 */B 	for (lp = &line[strlen(line)]; lp > line && lp[-1] <= ' '; lp--);	 	*lp = 0;p 	if (debug > 1)u$ 		fprintf(stderr, "\"%s\"\n", line); 	return(1);f }  i char
 *skipbl(text)  register char	*text; /*?  * Skip blanks, return -> first non blank (or -> trailing null)L  */  {f 	register char	c;f    	while ((c = *text) && c <= ' ')	 		text++;	 	return(text); }	 	 bug(mess, arg) char		*mess; char		*arg;  {i6 	fprintf(stderr, "?GETRNO-E-Confused at %s", section); 	if (macfile[0])1 		fprintf(stderr, " at line %u in file \"%s\"\n",p 			linect, macfile); 	fprintf(stderr, "%s", mess);b 	if (arg != NULL)(# 		fprintf(stderr, ": \"%s\"", arg);) 	fprintf(stderr, "\n");( }t   cant(what, who)t char		*what; char		*who;e /*  * Can't open the file, diea  */  {l: 	error("?Can't open %s file \"%s\", fatal.\n", what, who); } 