 /*  * grep.  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...GRE 		}  */   #ifdef	DOCUMENTATION  + title	grep	Get Regular Expression and Print ' index		Get Regular Expression and Print    synopsis  . 	grep [options] regular_expression [ file ...]   description   C 	Grep searches each specified file (if none are specified, it readsD 	stdin) for lines matching the given pattern.  Grep allows wild-cardD 	file names in the file list.  The following options are recognized: 	.lm +8 1 	.s.i -4;-c	Only print a count of matching lines. . 	.s.i -4;-f	Print file name option, see below.2 	.s.i -4;-n 	Preceed each line by its line number.% 	.s.i -4;-v	Print non-matching lines.i	 	.s.lm -8 D 	The file name is normally printed if more than one file argument is@ 	given, or if a wild-card file name was specified. The "-f" flag< 	reverses this action (print name if one file, not if more). 	.s F 	The regular_expression defines the pattern to search for.  Upper- and* 	lower-case are not distinguished by grep.1 	Blank lines never match.  The regular_expression  	should be quoted. 	.s ? 	The regular_expression is built out of the following elements:  	.lm +8 > 	.s.i -6;x	An ordinary character (not mentioned below) matches 	that character.@ 	.s.i -6;'_\'	The backslash quotes any character.  "_\$" matches 	a dollar-sign.	D 	.s.i -6;'_^'	A circumflex at the beginning of an expression matches 	the beginning of a line.,> 	.s.i -6;'$'	A dollar-sign at the end of an expression matches 	the end of a line.n> 	.s.i -6;'.'	A period matches any character except "new-line".> 	.s.i -6;':a'	A colon matches a class of characters##described> 	.i   -6;':d'	by##the##following##character.##":a" matches any> 	.i   -6;':n'	alphabetic, ":d" matches##digits.##":n"##matches> 	.i   -6;':#'	alphanumerics, and ":#" matches spaces tabs, and 	.br+ 	other control characters, such as newline.;? 	.s.i -6;'*'	An expression followed by an asterisk matches zeroe@ 	or more occurrances of that expression: "fo*" matches "f", "fo" 	"foo", etc.> 	.s.i -6;'+'	An expression followed by a plus sign matches oneA 	or more occurrances of that expression: "fo+" matches "fo", etc.	> 	.s.i -6;'-'	An expression followed by a minus sign optionally 	matches the expression.> 	.s.i -6;'[]'	A string enclosed in square brackets matches anyH 	character in that string, but no others.  If the first character in the= 	string is a circumflex, the expression matches any character 4 	except "new-line" and the characters in the string. 	.s}H 	For example, "A[xyz]+B" matches "AxxB" and "AxyzzyB", while "A[^xyz]+B"< 	matches "AbcB" but not "AxB".  A range of characters may be9 	specified by two characters separated by "-".  Note that 6 	[a-z] matches alphabetics, while [z-a] never matches.	 	.s.lm -8 B 	The concatenation of regular expressions is a regular expression.   diagnostics	   	.lm +8* 	.s.i -8;No argumentsn 	.s.i -8;Unknown flage 	.s.i -8;No pattern " 	.s.i -8;"file__name": cannot open( 	.s.i -8;Illegal occurrence operator ... 	.seG 	An operator was found in an illegal context.  For example, the patterni? 	"*foo" is illegal as the '*' operator must modify a previouslyp 	specified pattern element.n 	.s.i -8;No : type 	.s)- 	A colon was followed by an unknown modifier.o 	.s.i -8;Class terminates badly= 	.s)D 	A character class "[...]" was incorrectly terminated.  For example, 	"[A-]" is incorrect.o 	.s.i -8;Unterminated class= 	.s - 	Character classes must be terminated by ']'.' 	.s.i -8;Class too large 	.ss 	An internal buffer filled.	 	.s.i -8;Empty class 	.so= 	A character class must designate something: "[]" is illegal.	 	.s.i -8;Pattern too complex 	.s	 	An internal buffer filled.e 	.lm -8)   author   	David Conroy, Martin Minow.   bugs   #endif   char	*documentation[] = {c8 "grep searches a file for a given pattern.  Execute by",4 "        grep [flags] regular_expression file_list", "", 0 "Flags are single characters preceeded by '-':",7 "   -c      Only a count of matching lines is printed",oB "   -f      Print file name for matching lines switch, see below",7 "   -n      Each line is preceeded by its line number", + "   -v      Only print non-matching lines",s "",	9 "On RSX, RT11, RSTS, input or output may be redirected:",/& "        grep ... <file.in >file.out",L "The file_list is a list of files (wildcards are acceptable on RSX modes).",P "If no files are given, input comes from the terminal.  There is no prompting.",> "The file name is normally printed if there is a file given.",F "The -f flag reverses this action (print name no file, not if more).", "",oH "The regular_expression defines the pattern to search for.  Upper- and",K "lower-case are always ignored.  Blank lines never match.  The expression",u5 "should be quoted to prevent file-name translation.",(H "x	An ordinary character (not mentioned below) matches that character.",K "'\\'	The backslash quotes any character.  \"\\$\" matches a dollar-sign.",pA "'^'	A circumflex at the beginning of an expression matches the",i "	  beginning of a line.",C "'$'	A dollar-sign at the end of an expression matches the end of", 
 "	  a line.",e: "'.'	A period matches any character except \"new-line\".",H "':a'	A colon matches a class of characters described by the following",K "':d'	  character.  \":a\" matches any alphabetic, \":d\" matches digits,", H "':n'	  \":n\" matches alphanumerics, \": \" matches spaces, tabs, and",5 "': '	  other control characters, such as new-line.", A "'*'	An expression followed by an asterisk matches zero or more",hC "	  occurrances of that expression: \"fo*\" matches \"f\", \"fo\"",  "	  \"foo\", etc.",	@ "'+'	An expression followed by a plus sign matches one or more",B "	  occurrances of that expression: \"fo+\" matches \"fo\", etc.",@ "'-'	An expression followed by a minus sign optionally matches", "	  the expression.", E "'[]'	A string enclosed in square brackets matches any character in",p@ "	  that string, but no others.  If the first character in the",B "	  string is a circumflex, the expression matches any character",@ "	  except \"new-line\" and the characters in the string.  For",E "	  example, \"[xyz]\" matches \"xx\" and \"zyx\", while \"[^xyz]\"",nD "	  matches \"abc\" but not \"axb\".  A range of characters may be",A "	  specified by two characters seperated by \"-\".  Note that,",); "	  [a-z] matches alphabetics, while [z-a] never matches.",r "",)D "The concatenation of regular expressions is a regular expression.", "",: 0 };   #include <stdio.h>
 #ifdef vms #include		<ssdef.h>a #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)e #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */= #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   #define	LMAX	512 #define PMAX	256   #define CHAR	1
 #define BOL	2i
 #define EOL	3 
 #define	ANY	4	 #define CLASS	5) #define	NCLASS	6 #define STAR	7 #define	PLUS	8 #define	MINUS	9= #define	ALPHA	10 #define	DIGIT	11 #define	NALPHA	12  #define	PUNCT	13 #define RANGE	14 #define	ENDPAT	15e  
 int	cflag;
 int	fflag;
 int	nflag;
 int	vflag;
 int	nfile;) int	debug	=	0;		/* Set for debug code		*/s	 char	*pp;	   char	file_name[81];c   char	lbuf[LMAX]; char	pbuf[PMAX];   main(argc, argv)
 char *argv[];) {= 	register char	*p; 	register int	c, i;h 	int		gotpattern;	
 	FILE		*f;
 	int		gotcha;	  
 #ifdef	vms# 	argc = getredirection(argc, argv);& #endif 	if (argc <= 1)	 		usage("No arguments");9 	if (argc == 2 && argv[1][0] == '?' && argv[1][1] == 0) {/	 		help();(	 		return;	 	} 	nfile = argc-1; 	gotpattern = 0; 	for (i=1; i < argc; ++i) {  		p = argv[i]; 		if (*p == '-') { 			++p;	 			while (c = *p++) {  				switch(lower(c)) {  
 				case '?':B 					help(); 					break;e  
 				case 'c':e
 					++cflag;  					break;r  
 				case 'd':
 					++debug;  					break;   
 				case 'f': 
 					++fflag;  					break;   
 				case 'n': 
 					++nflag;  					break;   
 				case 'v': 
 					++vflag;  					break;    				default: 					usage("Unknown flag");  				}  			} 			argv[i] = 0;  			--nfile;  		} else if (!gotpattern) {{ 			compile(p); 			argv[i] = 0;i 			++gotpattern; 			--nfile;p 		}R 	} 	if (!gotpattern)r 		usage("No pattern"); 	if (nfile == 0) 		grep(stdin, 0);  	else {t 		fflag = fflag ^ (nfile > 0); 		for (i=1; i < argc; ++i) { 			if ((p = argv[i]) != NULL) {n$ 				if ((f = fwild(p, "r")) == NULL)
 					cant(p);i
 				else { 					gotcha = 0; 					while (fnext(f) != NULL) {e 						fgetname(f, file_name);o 						grep(f, file_name);  						gotcha = 1;p
 				    	} 					if (!gotcha)  						cant(p); 				}e 			} 		}n 	} }e   file(s)  char *s; {d 	printf("File %s:\n", s);e }    cant(s)	 char *s; {c) 	fprintf(stderr, "%s: cannot open\n", s);  }m   help() /*  * Give good helpe  */m {  	register char	**dp;  $ 	for (dp = documentation; *dp; dp++) 		printf("%s\n", *dp); }o   usage(s) char	*s; {,$ 	fprintf(stderr, "?GREP-E-%s\n", s); 	fprintf(stderr,@ 		"Usage: grep [-cfnv] pattern [file ...].  grep ? for help\n"); 	exit(IO_ERROR); }k   s   compile(source)r) char		*source;	/* Pattern to compile			*/  /*)  * Compile the pattern into global pbuf[]o  */n {l/ 	register char		*s;	/* Source string pointer	*/t0 	register char		*lp;	/* Last pattern pointer		*/* 	register int		c;	/* Current character		*/ 	int			o;	/* Temp				*/a- 	char			*spp;	/* Save beginning of pattern	*/h- 	char		*cclass();	/* Compile class routine	*/n   	s = source; 	if (debug)'" 		printf("Pattern = \"%s\"\n", s); 	pp = pbuf;s 	while (c = *s++) {n 		/*& 		 * STAR, PLUS and MINUS are special. 		 */") 		if (c == '*' || c == '+' || c == '-') { ) 			if (pp == pbuf || (o=pp[-1]) == BOL ||d 					o == EOL || o == STAR ||. 					o == PLUS || o == MINUS)n0 				badpat("Illegal occurrance op.", source, s); 			store(ENDPAT);h 			store(ENDPAT); $ 			spp = pp;		/* Save pattern end	*/, 			while (--pp > lp)	/* Move pattern	down	*/! 				*pp = pp[-1];	/* one byte		*/  			*pp =	(c == '*') ? STAR : 				(c == '-') ? MINUS : PLUS;' 			pp = spp;		/* Restore pattern end	*/  			continue; 		}r 		/* 		 * All the rest. 		 */t! 		lp = pp;			/* Remember start	*/h
 		switch(c) {"   		case '^':o 			store(BOL);	 			break;x   		case '$':e 			store(EOL);	 			break;y   		case '.':e 			store(ANY);	 			break;    		case '[':  			s = cclass(source, s);a	 			break;t   		case ':':n 			if (*s) {
 				c = *s++;s 				switch(lower(c)) {  
 				case 'a':e 					store(ALPHA); 					break;r  
 				case 'd':n 					store(DIGIT); 					break;e  
 				case 'n':F 					store(NALPHA);" 					break;B  
 				case ' ':w 					store(PUNCT); 					break;    				default:) 					badpat("Unknown : type", source, s);    				}c
 				break; 			}' 			else	badpat("No : type", source, s);i   		case '\\':
 			if (*s)
 				c = *s++;   
 		default: 			store(CHAR);x 			store(lower(c));r 		}e 	} 	store(ENDPAT);	$ 	store(0);				/* Terminate string	*/
 	if (debug) {n 		for (lp = pbuf; lp < pp;) {." 			if ((c = (*lp++ & 0377)) < ' ') 				printf("\\%o ", c);  			else	printf("%c ", c);r 		  }s 		  printf("\n");l 	} }t   char * cclass(source, src)"4 char		*source;	/* Pattern start -- for error msg.	*/! char		*src;		/* Class start				*/t /*  * Compile a class (within [])  */s {l) 	register char	*s;		/* Source pointer		*/a) 	register char	*cp;		/* Pattern start		*/a* 	register int	c;		/* Current character		*/ 	int		o;		/* Temp				*/r  	 	s = src;  	o = CLASS;e 	if (*s == '^') {a 		++s;
 		o = NCLASS;t 	}
 	store(o);	 	cp = pp;8 	store(0);				/* Byte count		*/n 	while ((c = *s++) && c!=']') {y+ 		if (c == '\\') {		/* Store quoted char	*/t4 			if ((c = *s++) == '\0')	/* Gotta get something	*/0 				badpat("Class terminates badly", source, s); 			else	store(lower(c)); 		}M 		else if (c == '-' &&/ 				(pp - cp) > 1 && *s != ']' && *s != '\0') {h" 			c = pp[-1];		/* Range start		*/' 			pp[-1] = RANGE;		/* Range signal		*/x" 			store(c);		/* Re-store start	*/$ 			c = *s++;		/* Get end char and	*/# 			store(lower(c));	/* Store it		*/i 		}n 		else {+ 			store(lower(c));	/* Store normal char	*/i 		}n 	} 	if (c != ']')* 		badpat("Unterminated class", source, s); 	if ((c = (pp - cp)) >= 256)' 		badpat("Class too large", source, s);O 	if (c == 0)# 		badpat("Empty class", source, s);d	 	*cp = c;  	return(s);f }.  	 store(op), {T 	if (pp >= &pbuf[PMAX]) ! 		error("Pattern too complex\n");R 	*pp++ = op; }    lower(c) register int c;e {r 	if (c>='A' && c<='Z') 		c += 'a'-'A';, 	return(c);a }i   badpat(message, source, stop)f% char		*message;	/* Error message			*/s$ char		*source;	/* Pattern start			*/" char		*stop;		/* Pattern end				*/ {e 	register int	c;  D 	fprintf(stderr, "-GREP-E-%s, pattern is\"%s\"\n", message, source);6 	fprintf(stderr, "-GREP-E-Stopped at byte %d, '%c'\n", 			stop-source, stop[-1]);  	error("?GREP-E-Bad pattern\n"); }    o   grep(fp, fn)# FILE		*fp;		/* File to process			*/l, char		*fn;		/* File name (for -f option)		*/ /**  * Scan the file for the pattern in pbuf[]  */  {e 	register int lno, count, m;  	 	lno = 0;a 	count = 0;'( 	while (fgetss(lbuf, sizeof lbuf, fp)) { 		++lno; 		m = match();' 		if ((m && !vflag) || (!m && vflag)) {h 			++count;t 			if (!cflag) { 				if (fflag && fn) { 					file(fn); 					fn = 0; 				}f 				if (nflag) 					printf("%d\t", lno);h 				printf("%s\n", lbuf);a 			} 		}s 	}
 	if (cflag) {" 		if (fflag && fn) 			file(fn); 		printf("%d\n", count); 	} }      match()h /*;  * Match the current line (in lbuf[]), return 1 if it does.   */i {m( 	register char	*l;		/* Line pointer			*/ 	char *pmatch();   	for (l = lbuf; *l; l++) { 		if (pmatch(l, pbuf))
 			return(1);s 	} 	return(0);a }u   char * pmatch(line, pattern) , char		*line;		/* (partial) line to match		*/1 char		*pattern;	/* (partial) pattern to match		*/m {s/ 	register char	*l;		/* Current line pointer		*/ 1 	register char	*p;		/* Current pattern pointer	*/s+ 	register char	c;		/* Current character		*/ - 	char		*e;		/* End for STAR and PLUS match	*/t# 	int		op;		/* Pattern operation		*/m 	int		n;		/* Class counter		*/( 	char		*are;		/* Start of STAR match		*/  
 	l = line; 	if (debug > 1)[# 		printf("pmatch(\"%s\")\n", line);i
 	p = pattern;n  	while ((op = *p++) != ENDPAT) { 		if (debug > 1)- 			printf("byte[%d] = 0%o, '%c', op = 0%o\n",t 					l-line, *l, *l, op);t 		switch(op) {   		case CHAR: 			if (lower(*l++) != *p++)m 				return(0);	 			break;a   		case BOL:u 			if (l != lbuf)a 				return(0);	 			break;:   		case EOL:u 			if (*l != '\0') 				return(0);	 			break;    		case ANY:e 			if (*l++ == '\0') 				return(0);	 			break;B  
 		case DIGIT:O% 			if ((c = *l++) < '0' || (c > '9'))I 				return(0);	 			break;d  
 		case ALPHA:u 			c = lower(*l++);= 			if (c < 'a' || c > 'z') 				return(0);	 			break;n   		case NALPHA: 			c = lower(*l++);f 			if (c >= 'a' && c <= 'z')
 				break; 			else if (c < '0' || c > '9')d 				return(0);	 			break;	  
 		case PUNCT:) 			c = *l++; 			if (c == 0 || c > ' ')n 				return(0);	 			break;   
 		case CLASS:  		case NCLASS: 			c = lower(*l++);  			n = *p++ & 0377;f 			do {	 				if (*p == RANGE) { 					p += 3; 					n -= 2;" 					if (c >= p[-2] && c <= p[-1]) 						break; 				}f 				else if (c == *p++)* 					break;f 			} while (--n > 1);l! 			if ((op == CLASS) == (n <= 1))n 				return(0); 			if (op == CLASS)g 				p += n - 2;r	 			break;	  
 		case MINUS:p+ 			e = pmatch(l, p);	/* Look for a match	*/f2 			while (*p++ != ENDPAT);	/* Skip over pattern	*/ 			if (e)			/* Got a match?		*/u$ 				l = e;		/* Yes, update string	*/! 			break;			/* Always succeeds	*/e  $ 		case PLUS:			/* One or more ...	*/ 			if ((l = pmatch(l, p)) == 0)<' 				return(0);	/* Gotta have a match	*/=% 		case STAR:			/* Zero or more ...	*/ & 			are = l;		/* Remember line start	*/# 			while (*l && (e = pmatch(l, p)))	# 				l = e;		/* Get longest match	*/e2 			while (*p++ != ENDPAT);	/* Skip over pattern	*/- 			while (l >= are) {	/* Try to match rest	*/  				if (e = pmatch(l, p))n 					return(e);k! 				--l;		/* Nope, try earlier	*/  			}( 			return(0);		/* Nothing else worked	*/  
 		default:" 			printf("Bad op code %d\n", op);% 			error("Cannot happen -- match\n");  		}m 	} 	return(l);[ }=  