 /*=  * Header file for all lz compression/decompression routines.   *;  * Machine/Operating system/compiler selection: (#ifdef'ed)   * vax				Vax/Unix or Vax/VMS #  * pdp11			makes a small compressor    * M_XENIX			"large-model" Z8000*  * interdata			Signed long compare is slow'  * unix				Defined on true Unix systems   * decus			Decus C (no signal)3  * vms				Vax/VMS (VMS_V4 may be set automatically) B  * #define readonly		If the compiler doesn't support it correctly.  *  #  * Compiler configuration (#if'ed):HK  * #define vax_asm   TRUE/FALSE	TRUE on Vax (4bsd) if the compiler supportse4  *				the asm() operator.  Check the generated code!G  * #define UCHAR     TRUE/FALSE	TRUE if compiler supports unsigned charXB  * #define DEBUG     TRUE/FALSE	TRUE to compile in debug printouts  *  * Algorithm Tuning parameters:m6  * #define USERMEM   <n>	Memory available to compress.2  *				If large enough, a faster algorithm is used.8  * #define SACREDMEM <n>	Don't use this part of USERMEM.5  * #define BITS      <n>	Maximum number of code bits. F  * #define MAXIO     <n>	Output buffer size (squeeze memory if needed)  */r   #include <stdio.h> #include <ctype.h> #include <setjmp.h>S
 #ifndef decusl # include <signal.h> /*  * Arguments to signal():/  */	3 extern int	abort();		/* Debugging interrupt trap	*/T; extern int	interrupt();		/* Non-debugging interrupt trap	*/ 6 extern int	address_error();	/* "Segment" violation		*/ #endif   #ifndef	TRUE # define FALSE		0e # define TRUE		1 #endif #ifndef	EOS  # define EOS		'\0' #endif+ #define	streq(a, b)	(strcmp((a), (b)) == 0)u) #define min(a,b)	((a) > (b)) ? (b) : (a))    /*F  * Set USERMEM to the maximum amount of physical user memory availableL  * in bytes.  USERMEM is used to determine the maximum BITS that can be used  * for compression.e  *H  * SACREDMEM is the amount of physical memory saved for others; compress  * will hog the rest.r  */*   #ifndef SACREDMEM	 # define SACREDMEM	0 #endif   /*"  * Set machine-specific parameters  */n  
 #ifdef vax # ifdef unix7 #  define vax_asm	TRUE		/* If asm() supported on vax	*/d # endif( #endif #ifndef	vax_asm( # define vax_asm	FALSE #endif   #ifdef pdp118 # define BITS	12	/* max bits/code for 16-bit machine		*/0 # define USERMEM 0	/* Force no user memory				*/B # define UCHAR	FALSE	/* TRUE if compiler supports unsigned char	*/< # define MAXIO 512	/* Buffer size for PDP-11 I/O buffers		*/ #endif   /**  * Set default values for some parameters.  */   
 #ifndef DEBUGe # define DEBUG	FALSE #endif   #ifdef interdata! # define SIGNED_COMPARE_SLOW TRUE( #endif #ifndef SIGNED_COMPARE_SLOWd" # define SIGNED_COMPARE_SLOW FALSE #endif   #ifndef USERMEMp4 # define USERMEM 750000	/* default user memory				*/ #endif  
 #ifndef	UCHARM: # define UCHAR	TRUE	/* Compiler supports unsigned char		*/ #endif  
 #ifndef MAXIOn, # define MAXIO	2048	/* I/O buffer size				*/ #endif   /*!  * Set derived tuning parameters.S  */f   #ifndef USERMEMe # define USERMEM	 0  #endif% #if USERMEM >=			(433484 + SACREDMEM)  # define PBITS		16 #elseS& # if USERMEM >=			(229600 + SACREDMEM) #  define PBITS		15d # else& #  if USERMEM >=		(127536 + SACREDMEM) #   define PBITS	14e #   else( #    if USERMEM >=		( 73464 + SACREDMEM) #     define PBITS	13 # #    else			/* Smaller systems			*/r #     define PBITS	12e
 #    endif	 #   endif  # endifM #endif   #ifndef BITS # define BITS PBITS  #endif   #ifdef M_XENIX # if BITS >= 16f= #  define XENIX_16		/* Enable special vector access macros	*/  # else #  if BITS > 13  #   undef BITS= #   define BITS 13		/* Code only handles BITS = 12, 13, 16	*/  #  endif # endif  #endif   /*<  * HSIZE is the size of the hash lookup table.  It is set to:  * 1 << BITS + fudge factor, rounded up to a prime number.;  * If it is too big, the "clear the hash" routine will takee>  * too long.  The same numbers are replicated in the getsize()  * routine's data table.  */d   #if BITS == 16+ # define HSIZE	69001		/* 95% occupancy			*/c #endif #if BITS == 15+ # define HSIZE	35023		/* 94% occupancy			*/S #endif #if BITS == 14+ # define HSIZE	18013		/* 91% occupancy			*/e #endif #if BITS == 13+ # define HSIZE	 9001		/* 91% occupancy			*/  #endif #if BITS <= 12+ # define HSIZE	 5003		/* 80% occupancy			*/i #endif   /**  * typedef's -- somewhat machine specific.  */l   /*J  * a code_int must be able to hold 2**BITS values of type int, and also -1  */t
 #if BITS > 15  typedef long int	code_int; #else0 typedef int		code_int; #endif   /*=  * A count_int must hold ((2**BITS)-1) + (255<<BITS)) and -1.d  *"  * count_int's also hold counters.  *8  * count_short's hold small counters (for the interdata)  *J  * Some implementations don't support unsigned char (Decus C, for example)A  * Decus C is also brain damaged with regards to unsigned shorts.c  */s #if SIGNED_COMPARE_SLOWa$ typedef unsigned long int count_int;' typedef unsigned short int count_short;i #else> typedef long int	count_int;n #endif  	 #if UCHARn  typedef	unsigned char	char_type; #elset typedef char		char_type; #endif   #ifdef decus typedef unsigned	U_short;d4 #define	readonly			/* Dummy out readonly modifier	*/ #else  typedef unsigned short	U_short;a #endif   #ifdef unixi #define	readonly #endif  5 typedef short		flag;		/* Boolean flag or parameter	*/u g /*1  * The following define the "magic cookie" headern  */d #define	HEAD1_MAGIC	0x1F #define HEAD2_MAGIC	0x9D= #define	VMS_HEAD2_MAGIC	0x9E		/* vms-private output format	*/    /*#  * Defines for third byte of headere  */ 3 #define BIT_MASK	0x1F		/* Gets NBITS in the code	*/e7 #define BLOCK_MASK	0x80		/* Gets block_compress flag	*/e /*H  * Masks 0x40 and 0x20 are free.  I think 0x20 should mean that there is(  * a fourth header byte (for expansion).  */r   /*K  * This is for backwards compatibilty with an old version of Unix compress.g  */o0 #ifdef COMPATIBLE			/* Compatible, but wrong!	*/, # define MAXCODE(n_bits)	(1 << (n_bits) - 1) #else*. # define MAXCODE(n_bits)	((1 << (n_bits)) - 1) #endif  7 #define INIT_BITS 9			/* initial number of bits/code */I   /*A  * One code could conceivably represent (1<<BITS) characters, but*A  * to get a code of length N requires an input string of at leastt@  * N*(N-1)/2 characters.  With 5000 chars in the stack, an inputB  * file would have to contain a 25Mb string of a single character.  * This seems unlikely.C  */I; #define MAXSTACK    8000		/* size of lzdcmp output stack	*/(   #ifndef CHECK_GAPe6 # define CHECK_GAP 	10000		/* ratio check interval		*/ #endif   #ifndef __LINE__ # define NO__LINE__f #endif #ifndef __FILE__ # define NO__LINE__a #endif	 #if DEBUGI # define VERBOSE_DEFAULT    1  # ifndef NO__LINE__q #  define FAIL(why)					\ . 	fprintf(stderr, "\nfatal: %s (%s at %d)\n",	\# 	    why, __FILE__, __LINE__); 			\l 	longjmp(failure, 1);b # else #  define FAIL(why)					\T+ 	fprintf(stderr, "\nfatal: %s\n", why); 		\  	longjmp(failure, 1);m # endifs #else( # define VERBOSE_DEFAULT    0e' # define FAIL(why)	longjmp(failure, 1);l #endif   /*0  * Note -- for compatibility with Unix compress,(  * NBR_CHAR and LZ_CLEAR must equal 256.<  * Also, (1 << (MIN_BITS - 1) should equal or exceed NBR_CHR  */_6 #define	NBR_CHAR      256		/* Number of input codes	*/1 #define MIN_BITS	9		/* Smallest code is 9 bits	*/_1 #if ((1 << BITS) < NBR_CHAR) || (BITS < MIN_BITS) I     << Can't compile: not enough bits for the input character set size >>i #endif. #define	LZ_CLEAR	(NBR_CHAR)	/* Clear code			*/: #define	LZ_SOH		(LZ_CLEAR + 1)	/* Start of header block	*/9 #define	LZ_STX		(LZ_SOH   + 1)	/* Start of text block		*/C8 #define	LZ_EOR		(LZ_STX   + 1)	/* End of text record		*/= #define	LZ_ETX		(LZ_EOR   + 1)	/* End of header/text block	*/ < #define	LZ_FIRST	(LZ_ETX   + 1)	/* First user (data) code	*/  
 #ifdef	vms #include		errno( #include		ssdefC #include		stsdef1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)  #define	IO_ERROR	(SS$_ABORT)7 #define VMS_V4		L_cuserid >= 16		/* Enable new stuff	*// #elsen+ #define VMS_V4		0			/* Disable new stuff	*/l extern int		errno; #ifdef decus #define	errno		$$ferrl #endif #endif   /*  * Define exit() codes.   */x   #ifndef	IO_SUCCESS) #define	IO_SUCCESS	0			/* Normal exit		*/t& #define	IO_ERROR	1			/* Error exit		*/ #endif t /*?  * All I/O is done by way of "streams".  To establish a stream,CB  * set the parameters appropriately and off you go.  The following  * functions are provided:/  *	lz_fill(stream)		fills the buffer from stdinn/  *	lz_flush(stream)	writes the buffer to stdoutb5  *	lz_eof(stream)		returns EOF (for fill from memory)f2  *	lz_fail(stream)		abort (for writing to memory).0  *	lz_dummy(stream)	throw an output stream away.A  * Note: if VMS_V4 is enabled and the private (non-export) format ?  * chosen, lz_fill and lz_flush access the files appropriately. .  * Stream elements are initialized as follows:!  *	Input:	bp = NULL;	bend = NULL;f.  *	Output:	bp = bstart;	bend = bstart + bsize;  */a   typedef struct STREAM {t4     char_type	*bp;		/* Next character to get/put		*/4     char_type	*bend;		/* -> end of stream buffer		*/4     char_type	*bstart;	/* Start of stream buffer		*/,     short	bsize;		/* Stream buffer size			*/7     int		(*func)();	/* Read/write a buffer function		*/e	 } STREAM;a   /*I  * Note also that the compress routine uses putbuf(buf, count, outstream)lL  * and the decompress routine uses getbuf(buf, count, instream) to (quickly)  * transfer multiple bytes.r  */s	 #if UCHAR  #define	GET(s)		\R> 	(((s)->bp < (s)->bend) ? *(s)->bp++        : (*(s)->func)(s)) #elset #define	GET(s)		\n> 	(((s)->bp < (s)->bend) ? *(s)->bp++ & 0xFF : (*(s)->func)(s)) #endif #define	PUT(c, s)	\;C 	((((s)->bp >= (s)->bend) ? (*(s)->func)(s) : 0), *(s)->bp++ = (c))f   extern int lz_fill();M extern int lz_flush(); extern int lz_eof(); extern int lz_fail();n extern int lz_dummy();  	 #if DEBUG 8 extern readonly char *lz_names[];		/* "LZ_CLEAR" etc.	*/ #endif   /*  * Options and globals.C  */ 
 #if VMS_V4" #define	ATT_NAME	"vms$attributes ", #define	ATT_SIZE	15			/* strlen(ATT_NAME)	*/9 extern int	fdl_status;	/* Error code from fdl library		*/F #endif  9 extern flag	binary;		/* -b Readable text file if FALSE	*/)8 extern flag	noheader;	/* -x3 No magic header if TRUE		*/= extern flag	export;		/* -x  (non-zero) Supress vms private	*/;) extern flag	block_compress;	/* -x2					*/m9 extern flag	verbose;	/* -v  (non-zero) Verbose logging	*/LJ extern readonly flag is_compress; /* TRUE if compress, FALSE if decomp.	*/4 extern char	*infilename;	/* For error printouts			*/9 extern char	*outfilename;	/* For more error printouts		*/ @ extern short	n_bits;		/* Current # of bits in compressed file	*/5 extern int	firstcode;	/* First value past signals		*/*4 extern jmp_buf	failure;	/* For longjmp() return			*/  