 /*(  *		lzdcmp [-options] [infile [outfile]]  */  #ifdef	DOCUMENTATION   title	lzdcmp	File Decompression  index		File decompression    synopsis 	.s.nf% 	lzdcmp [-options] [infile [outfile]]  	.s.f  description   5 	lzdcmp decompresses files compressed by lzcomp.  The 2 	documentation for lzcomp describes the process in 	greater detail.  % 	Options may be given in either case.  	.lm +8  	.p -80 	-B	Output file is "binary", not text.  (Ignored 	in VMS private mode.) 	.p -85 	-X 3	To read files compressed by an old Unix version & 	that doesn't generate header records. 	.p -84 	-V val	Verbose (print status messages and debugging: 	information).  The value selects the amount of verbosity.   Author  3 	This version by Martin Minow.  See lzcomp for more 	 	details.    #endif   /*,  * Compatible with compress.c, v3.0 84/11/27  */    /*)BUILD 		$(PROGRAM) = lzdcmp  		$(INCLUDE) = lz.h  		$(CPP) = 1: 		$(FILES) = { lzdcm1.c lzdcm2.c lzdcm3.c lzio.c lzvio.c } */   #include	"lz.h"    /*=  * These global parameters are read from the compressed file.   * The decompressor needs them.   */ 6 short		maxbits = BITS;		/* settable max # bits/code	*/  code_int	maxmaxcode = 1 << BITS;   /*B  * Note, if export is zero or 1, the "true" value will be set from8  * the file header.  If it is 2, no header will be read.  */ 
 #if VMS_V4, flag		export = 0;		/* Assume VMS private		*/ #else / flag		export = 1;		/* Assume Unix compatible	*/  #endif0 flag		binary = FALSE;		/* Read text if false		*/8 flag		block_compress = TRUE;	/* TRUE if CLEAR enabled	*/5 flag		noheader = FALSE;	/* No magic header if TRUE	*/C@ flag		verbose = VERBOSE_DEFAULT; /* Non-zero for status/debug	*/7 flag		background = FALSE;	/* TRUE (Unix) if detached	*/N0 flag		is_compress = FALSE;	/* For lzio.c (?)		*/4 char		*infilename = NULL;	/* For error printouts		*/: char		*outfilename = NULL;	/* For openoutput and errors	*/1 int		firstcode;		/* First code after internals	*/ 8 static long	start_time;		/* Time we started (in msec)	*/: extern long	cputime();		/* Returns process time in msec	*/ jmp_buf		failure;  STREAM		instream;  STREAM		outstream; char_type	inbuffer[MAXIO]; char_type	outbuffer[MAXIO];  static STREAM	mem_stream; 
 #if VMS_V4 #include <descrip.h> #ifndef FDLSTUFF #define FDLSTUFF charw #endif FDLSTUFF	*fdl_input; FDLSTUFF	*fdl_output;n, static struct dsc$descriptor fdl_descriptor; #endif   main(argc, argv)
 int		argc; char		*argv[]; /*  * Decompress mainline  */  { 
 	int		result;   
 #ifndef	decus  	/*dE 	 * background is TRUE if running detached from the command terminal.s 	 */B 	background = (signal(SIGINT, SIG_IGN) == SIG_IGN) ? TRUE : FALSE; 	if (!background)r* 	    background = !isatty(fileno(stderr)); 	if (!background) {  	    if (verbose > 0)  		signal(SIGINT, abort); 	    else {  		signal(SIGINT, interrupt);! 		signal(SIGSEGV, address_error);i 	    } 	} #endif 	if (setjmp(failure) == 0) { 	    setup(argc, argv);i 	    openinput();g2 	    get_magic_header();			/* Sets export, etc.	*/ 	    openoutput(); 	    if (verbose > 0)e 		start_time = cputime();p 	    init_decompress();r% 	    result = decompress(&outstream);g 	    if (!export 	     && result != LZ_ETX"* 	     && getcode() != (code_int) LZ_ETX) {; 		fprintf(stderr, "Decompress didn't finish correctly.\n");2 		goto fail; 	    } 	    lz_flush(&outstream);	 #if DEBUGH 	    if ((verbose & 04) != 0)c 		dump_tab(stdout);1 #endif 	    if (verbose > 0) { & 		start_time = cputime() - start_time; 		fprintf(stderr,H> 		    "%ld.%02ld seconds (process time) for decompression.\n",6 		    start_time / 1000L, (start_time % 1000L) / 10L); 	    } 	    exit(IO_SUCCESS); 	} 	else {	H fail:	    fprintf(stderr, "Error when decompressing \"%s\" to \"%s\"\n", 		(infilename  == NULL) ? * 		    "<input file unknown>" : infilename, 		(outfilename == NULL) ? ( 		    "<no output file>" : outfilename); 	    if (errno != 0) 		perror("lzdcmp fatal error");D 	    exit(IO_ERROR); 	} }  i static get_magic_header() {! 	int		head1; 	int		head2; 	int		head3;   	head2 = 0;d 	if (export != 2) {y3 	    if ((head1 = GET(&instream)) != HEAD1_MAGIC) {e7 		fprintf(stderr, "Incorrect first header byte 0x%X\n",e
 		    head1);l 		FAIL("can't get header");  	    } 	    head2 = GET(&instream); 	    head3 = GET(&instream); 	    switch (head2) {B 	    case HEAD2_MAGIC:
 		export = 1;R 		break;   	    case VMS_HEAD2_MAGIC:
 		export = 0;? 		break;  
 	    default:e8 		fprintf(stderr, "Incorrect second header byte 0x%X\n",
 		    head2);2 		FAIL("can't get header");  	    }  	    maxbits = head3 & BIT_MASK;A 	    block_compress = ((head3 & BLOCK_MASK) != 0) ? TRUE : FALSE;		 #if DEBUGt 	    if (verbose > 1) {t1 		fprintf(stderr, "%s: compressed with %d bits,",y 		   infilename, maxbits);- 		fprintf(stderr, " block compression %s.\n",T6 		    (block_compress != 0) ? "enabled" : "disabled"); 	    } #endif 	} 	if (maxbits > BITS) {4 	    fprintf(stderr, "%s: compressed with %d bits,", 		infilename, maxbits);s@ 	    fprintf(stderr, " lzdcmp can only handle %d bits\n", BITS); 	    FAIL("too many bits");l 	} 	maxmaxcode = 1 << maxbits;a 	if (export == 0)kC 	    firstcode = GET(&instream) + 0x100;	/* From compressed file	*/i 	else if (block_compress)E. 	    firstcode = LZ_CLEAR + 1;		/* Default		*/ 	else!2 	    firstcode = 256;			/* Backwards compatible	*/
 #if VMS_V4 	if (!export) {k 	    register code_int	code; 	    char		text[256];H 	    /*e! 	     * Get the attribute record.t 	     */( 	    if ((code = getcode()) != LZ_SOH) {8 		fprintf(stderr, "Expected header, read 0x%X\n", code);% 		FAIL("can't get header (private)");a 	    } 	    init_decompress();E. 	    code = mem_decompress(text, sizeof text); 	    text[code] = EOS;2 	    if (strncmp(text, ATT_NAME, ATT_SIZE) != 0) {5 		fprintf(stderr, "Expected \"%s\", read \"%.*s\"\n",= 		    ATT_NAME, code, text);+ 		FAIL("can't get attribute block header");' 	    }" 	    code = atoi(text + ATT_SIZE);1 	    fdl_descriptor.dsc$a_pointer = malloc(code);s( 	    fdl_descriptor.dsc$w_length = code;D 	    if ((code = mem_decompress(fdl_descriptor.dsc$a_pointer, code))' 		    != fdl_descriptor.dsc$w_length) {e; 		fprintf(stderr, "\nError reading fdl attributes block,");S8 		fprintf(stderr, " expected %d bytes, read %d bytes\n",) 		    fdl_descriptor.dsc$w_length, code); ) 		FAIL("can't get attribute block data");  	    } 	    if (verbose > 1) { 9 		fprintf(stderr, "\nFDL information read from \"%s\"\n",  		    infilename);$ 		fdl_dump(&fdl_descriptor, stderr); 	    }( 	    if ((code = getcode()) != LZ_STX) {A 		fprintf(stderr, "\nExpecting start of text, got 0x%X\n", code);T 		FAIL("no start of text");F 	    } 	} #endif }O I int  mem_decompress(buffer, size) char_type	*buffer;
 int		size; /*>  * Decompress up to size bytes to buffer.  Return actual size.  */  {C
 	int		result;N  , 	mem_stream.bp = mem_stream.bstart = buffer;! 	mem_stream.bend = buffer + size;  	mem_stream.bsize = size;  	mem_stream.func = lz_fail;*1 	if ((result = decompress(&mem_stream)) == LZ_EOR* 	 || result == LZ_ETX)% 	    return (mem_stream.bp - buffer);  	else { 7 	    fprintf(stderr, "Decompress to memory failed.\n"); ( 	    FAIL("can't decompress to memory"); 	}$ 	return (-1);				/* Can't happen		*/ }   $ static readonly char *helptext[] = {$ 	"The following options are valid:",; 	"-B\tBinary file (important on VMS/RSX, ignored on Unix)", G 	"-M val\tSet the maximum number of code bits (unless header present)", 7 	"-V val\tPrint status information or debugging data.", , 	"-X val\tSet export (compatibility) mode:", 	"-X 0\tVMS private mode",* 	"-X 1\tCompatibility with Unix compress",? 	"-X 2\tDo not read a header, disable \"block-compress\" mode", E 	"\t(If a header is present, lzdcmp will properly configure itself,", / 	"\toverriding the -X, -B and -M flag values.",  	NULL, };   static setup(argc, argv) 
 int		argc; char		*argv[]; /*:  * Get parameters and open files.  Exit fatally on errors.  */  {  	register char	*ap;  	register int	c; 	char		**hp; 	auto int	i; 	int		j;  
 #ifdef	vms# 	argc = getredirection(argc, argv);  #endif! 	for (i = j = 1; i < argc; i++) {  	    ap = argv[i];5 	    if (*ap++ != '-' || *ap == EOS)	/* Filename?		*/ + 		argv[j++] = argv[i];		/* Just copy it		*/  	    else {  		while ((c = *ap++) != EOS) { 		    if (islower(c))  			c = toupper(c); 		    switch (c) { 		    case 'B':  			binary = TRUE; 	 			break;    		    case 'M': $ 			maxbits = getvalue(ap, &i, argv); 			if (maxbits < MIN_BITS) {- 			    fprintf(stderr, "Illegal -M value\n");  			    goto usage; 			}	 			break;    		    case 'V': $ 			verbose = getvalue(ap, &i, argv);	 			break;    		    case 'X': # 			export = getvalue(ap, &i, argv); " 			if (export < 0 || export > 3) {9 			    fprintf(stderr, "Illegal -X value: %d\n", export);  			    goto usage; 			}! 			block_compress = (export < 2);  			noheader = (export == 3);	 			break;    		    default:5 			fprintf(stderr, "Unknown option '%c' in \"%s\"\n",  				*ap, argv[i]);/ usage:			for (hp = helptext; *hp != NULL; hp++) $ 			    fprintf(stderr, "%s\n", *hp); 			FAIL("unknown option");" 		    }				/* Switch on options	*/  		}				/* Everything for -xxx	*/ 	    }					/* If -option		*/ 	}					/* For all argc's	*/ 5 	/*  infilename = NULL; */		/* Set "stdin"  signal	*/ 5 	/* outfilename = NULL; */		/* Set "stdout" signal	*/ * 	switch (j) {				/* Any file arguments?	*/# 	case 3:					/* both files given	*/ 8 	    if (!streq(argv[2], "-"))		/* But - means stdout	*/ 		outfilename = argv[2];# 	case 2:					/* Input file given	*/   	    if (!streq(argv[1], "-")) { 		infilename = argv[1];o 	    } 	    break;f   	case 0:					/* None!		*/p$ 	case 1:					/* No file arguments	*/ 	    break;   	 	default:.2 	    fprintf(stderr, "Too many file arguments\n"); 	    FAIL("too many files"); 	} }f s
 static int getvalue(ap, ip, argv) register char		*ap;e
 int			*ip; char			*argv[];t /*H  * Compile a "value".  We are currently scanning *ap, part of argv[*ip].  * The following are possible:7  *	-x123		return (123) and set *ap to EOS so the caller $  *	ap^		cycles to the next argument.  *6  *	-x 123		*ap == EOS and argv[*ip + 1][0] is a digit.3  *			return (123) and increment *i to skip over thea  *			next argument.e  *1  *	-xy or -x y	return(1), don't touch *ap or *ip.   *D  * Note that the default for "flag option without value" is 1.  This@  * can only cause a problem for the -M option where the value is@  * mandatory.  However, the result of 1 is illegal as it is less  * than INIT_BITS.  */. {z 	register int	result;i 	register int	i;  
 	i = *ip + 1;a 	if (isdigit(*ap)) { 	    result = atoi(ap);  	    *ap = EOS;s 	} 	else if (*ap == EOS 	      && argv[i] != NULLt  	      && isdigit(argv[i][0])) { 	    result = atoi(argv[i]);
 	    *ip = i;x 	} 	else {o 	    result = 1; 	} 	return (result);* }e l openinput()  {i #ifdef	decus 	if (infilename == NULL) { 	    infilename = malloc(257);! 	    fgetname(stdin, infilename);x> 	    infilename = realloc(infilename, strlen(infilename) + 1); 	}0 	if (freopen(infilename, "rn", stdin) == NULL) { 	    perror(infilename);) 	    FAIL("can't open compressed input");  	} #else 
 #ifdef vms
 #if VMS_V4 	if (!export) {  	    if (infilename == NULL) { 		infilename = malloc(256 + 1);  		fgetname(stdin, infilename);; 		infilename = realloc(infilename, strlen(infilename) + 1);  	    }< 	    if ((fdl_input = fdl_open(infilename, NULL)) == NULL) {  		fdl_message(NULL, infilename);4 		FAIL("can't open compressed input (vms private)"); 	    } 	} 	else  #endif 	{ 	    if (infilename == NULL) { 		infilename = malloc(256 + 1);  		fgetname(stdin, infilename);; 		infilename = realloc(infilename, strlen(infilename) + 1);  	    } 	    else { 0 		if (freopen(infilename, "r", stdin) == NULL) { 		    perror(infilename); 3 		    FAIL("can't open compressed input (export)");  		}  	    } 	} #else  	if (infilename == NULL) 	    infilename = "<stdin>"; 	else { 3 	    if (freopen(infilename, "r", stdin) == NULL) {  		perror(infilename);  		FAIL("can't open input");  	    } 	} #endif #endif$ 	instream.bp = instream.bend = NULL; 	instream.bstart = inbuffer;" 	instream.bsize = sizeof inbuffer; 	instream.func = lz_fill;  }    openoutput() { 
 #ifdef vms
 #if VMS_V4 	if (!export) {  	    fclose(stdout); 	    stdout = NULL;  	    if ((fdl_output =: 		    fdl_create(&fdl_descriptor, outfilename)) == NULL) {0 		fprintf(stderr, "Can't create output file\n"); 		if ((fdl_status & 01) == 0) % 		    fdl_message(NULL, outfilename); , 		FAIL("can't create output (vms private)"); 	    } 	    if (outfilename == NULL) {   		outfilename = malloc(256 + 1);' 		fdl_getname(fdl_output, outfilename); > 		outfilename = realloc(outfilename, strlen(outfilename) + 1); 	    } 	} 	else  #endif 	{ 	    /* * 	     * Not VMS Version 4, or export mode. 	     */ 	    if (outfilename == NULL) {   		outfilename = malloc(256 + 1);  		fgetname(stdout, outfilename);> 		outfilename = realloc(outfilename, strlen(outfilename) + 1); 		if (!binary) 		    goto do_reopen;  	    } 	    else {  		if (binary) { 6 		    if (freopen(outfilename, "w", stdout) == NULL) { 			perror(outfilename); ( 			FAIL("can't create output (binary)"); 		    }  		}  		else {
 		    int		i; 
 do_reopen:@ 		    if ((i = creat(outfilename, 0, "rat=cr", "rfm=var")) == -1* 		     || dup2(i, fileno(stdout)) == -1) { 			perror(outfilename); & 			FAIL("can't create output (text)"); 		    }  		}  	    } 	} #else  #ifdef decus 	if (outfilename == NULL) { # 	    outfilename = malloc(256 + 1); # 	    fgetname(stdout, outfilename); A 	    outfilename = realloc(outfilename, strlen(outfilename) + 1);  	    if (binary) {3 		if (freopen(outfilename, "wn", stdout) == NULL) {  		    perror(outfilename);$ 		    FAIL("can't create (binary)"); 		}  	    } 	} 	else { G 	    if (freopen(outfilename, (binary) ? "wn" : "w", stdout) == NULL) {  		perror(outfilename); 		FAIL("can't create");  	    } 	} #else  	if (outfilename == NULL)  	    outfilename = "<stdout>"; 	else { 5 	    if (freopen(outfilename, "w", stdout) == NULL) {  		perror(outfilename); 		FAIL("can't create");  	    } 	} #endif #endif- 	outstream.bp = outstream.bstart = outbuffer; / 	outstream.bend = outbuffer + sizeof outbuffer; $ 	outstream.bsize = sizeof outbuffer; 	outstream.func = lz_flush;  } 