 /*
  * 			m c . c   *  * Multi-column filter  *  */    /*)BUILD 	$(TKBOPTIONS) = { 		TASK	=	...MCX  		UNITS	=	10
 		ACTFIL	=	10  	} */   #ifdef	DOCUMENTATION  9 title	mc	Convert One or More Files To Multi-column Format , index		Convert a file to multi-column format+ index		Combine files in multi-column format    Synopsis  8 	mc [-t] [-c columns] [-h height] [-g gutter] [-w width] 		[filespec | aliasspec]...+   Description   F 	mc reads one or more files and converts them to a single multi-column, 	file that it writes to the standard output.  D 	Each line of each input file will occupy one row-column position in? 	the output file.  If an item is too wide for its column, it is F 	truncated with no message.  The items from any one file are placed inF 	order going down a column, and then across columns.  Thus, consider a 	simple case first:    	.tp 11  		mc a -c 2 -h 10   2 	produces a file whose first page looks like this:  	 		a1		a11 	 		a2		a12 		:		: 		:		:
 		a10		a20  D 	("-c 2" requests two columns; "-h 10" requests ten lines per page).   File Specifications   B 	The mc command line may contain more than one file specification;4 	however, the specifications may not be wild-carded.  C 	When there are multiple files, each column will come from a singleg 	file:   	.tp 9 		mc a b -c 2 -h 10i  
 	produces:   		a1	b1	 		a2	b2t 		:	:o 		:	:t	 		a10	b10	  < 	Columns are filled by consecutive files, in rotating order:   	.tp 9 		mc a b -c 4 -h 10t  
 	produces:   		a1	b1	a11	b11n 		a2	b2	a12	b12e	 		:	:	:	:i	 		:	:	:	:  		a10	b10	a20	b20s  C 	If there is more than one file, and the number of columns does notnG 	evenly divide the number of files, successive pages will be different.   F 	If a file reaches EOF while there is still data to be read from otherB 	files, the ended file's columns will be blank from that point on.  D 	The use of "-" as a file specification causes the standard input toC 	be read.  If mc is invoked with no file arguments at all, it readsw 	the standard input file once.   Alias Specifications  D 	Alias specifications provide a method for controlling the placementE 	of file data.  An alias specification is a reference to another file=G 	(or alias) specification.  File and alias specifications are numbered,	C 	starting at one for the left-most such specification; switches andeF 	their arguments do not affect the numbering.  The alias specificationD 	#n indicates that the n'th specification is to be repeated.  Such aF 	specification is legal only if it refers to an earlier specification;A 	i.e. #n is only legal as the n+1'st, n+2'nd, etc. specification.( 	Thus:   	.tp 9 		mc a #1 b #3 -c 4 -h 10h  
 	produces:   		a1	a11	b1	b11p 		a2	a12	b2	b12s	 		:	:	:	:g	 		:	:	:	:f 		a10	a20	b10	b20e   	This should be compared with:   		mc a a b b -c 4 -h 10-  D 	which opens each of a and b twice and reads the copies in parallel,- 	placing two copies of each item on the page.t   Last-page Handling  B 	mc will attempt to make the columns on the last page of output asE 	close in length as possible, rather than simply filling some columnsoB 	all the way to the bottom and leaving others empty.  This special@ 	handling is enabled only when mc is given no more than one file 	specification./   Switches  & 	The following switches are available: 	.lm +8;  *  -c	Next argument is the number of columns4  -h	Next argument is the height, in lines, of a pageA  -g	Next argument is the gutter width (the space between columns)t8  -w	Next argument is the width, in characters, of a pageJ  -t	Terminal mode; sets default height to 23, default width to 80, and, if0 	stdout is your terminal, pauses after each page'  -d	Debug (conditionally-compiled code)*   	.lm -8;   Defaults  G 	Height 58, width 132, no terminal mode; note that -t alters all three.g9 	Gutter 1, max(number-of-file-and-alias-specs,2) columns.a   Control Character Handling  D 	mc is designed to operate on text files, not binary files.  It setsB 	columns up based on how they will look when displayed.  Hence, itD 	processes control characters (anything that isprint() returns FALSE 	to) as follows:   	.lm +8)? 	<TAB> ("\t") is expanded into the equivalent number of spaces.<= 	mc always assumes that there are tab stops every 8 character  	positions.t  < 	<BS> ("\b") subtracts one from the current cursor position.: 	Any printable characters received when the current cursor: 	position is over a previously read character is ignored -= 	i.e. overstruck combinations retain only the first characterv= 	read.  However, if the character being overstruck is a spacem< 	or an underscore ("_"), the overstriking character replaces 	the current character.   8 	<BS> when the current cursor position is over the first" 	character in the line is ignored.  < 	<CR> ("\r") resets the current cursor position to the first 	character of the line.t  ) 	<LF> ("\n") ends the current input item.	  , 	All other control characters are discarded. 	.lm -8h   File Limits	  A 	Different systems impose different limits on the number of files ! 	mc may simultaneously have open.)  E 	On RT-based systems, this limit is totally dynamic; opening too manytC 	files is most likely to cause an error due to insufficient memory,+( 	rather than a file system error per se.  D 	On RSX-based systems, the absolute limit is set at task-build time.A 	The distributed source, when built with BUILD, will allow for 10aA 	open files.  Note that this total includes at least one file foroB 	stdin and stdout (two if either is redirected).  Of course, it is? 	possible to run into memory limitations even under this limit.s  = 	Aliases do not count against this limit, since they refer to(B 	already-opened files.  Similarly, a "-" argument, implying stdin,@ 	does not count, as it is simply a reference to the already-open? 	standard input.  If you are right at the limit, be sure to use:? 	the standard input as one of your files; you are paying for it[& 	to be open whether you use it or not.  E 	mc itself imposes another limit, which does include aliases.  In the	D 	distributed code, this limit is set to a total of 20 file and alias 	arguments.O   Other Limits  = 	No column can contain more than 256 characters (compile-timea 	constant).a   Diagnostics	   	Insufficient memory - sorry  " 	Too many file and alias arguments   	.tp 2" 	Unreasonable -c/-g/-w combination 		-- for example, c > w1   	.tp 2" 	<value>: Bad <what> specification( 		-- Invalid value for something like -h   	<filespec>: Can't open: <why>   Suggested Improvements  C 	Anyone interested in improving this program might want to considertC 	the following suggestions.  Be warned that they are not as easy tos 	implement as they look!  G 	Make the last-page cleanup algorithm work for the multiple-files case.s  C 	Add the ability to fold long items to the next entry for this filebD 	(probably indented) rather than just chopping them off.  (This onlyB 	gets hard when you consider both overstrike handling and multiple 	files!)  D 	Allow the automatic printing of the file name above the appropriate! 	columns at the top of each page.l  > 	The techniques used are wasteful of space; in particular, the9 	gutters should not be taking up space in the data array!    Bugs   Author  @ 	Original author unknown; extensively modified by Jerry Leichter   #endif   /*
 )EDITLEVEL=40r  * Edit history%F  * 0.0 ??-???-?? ???	Original implementation distributed with DECUS C.I  * 1.0 19-May-81 JSL	Extensive reorganization; added -t option, balancinga8  *			of columns on final page.  Bugfix:  Don't put out a  *			blank initial item.1  * 2.0 20-Jul-82 JSL	Converted to tool standards.s%  * 2.1 23-Jul-82 JSL	Added -g switch.	2  * 2.2 27-Jul-82 JSL	Added multiple-file handling.I  * 2.3  1-Aug-82 JSL	Redid overstrike handling; much more extensive errorm5  *			and bounds checks; debug conditionally compiled.o5  * 2.4 ??-Aug-82  MM	Change default page height to 60>8  * 2.5 23-Sep-82 JSL	Added conditional code for VAX-11 C  */e   char	*documentation[] = {	; "	mc [-t] [-c columns] [-h height] [-g gutter] [-w width]",  "		[filespec | aliasspec]...", "",)M "mc reads one or more files and converts them to a single multi-column file",$* "that it writes to the standard output.	", "", M "The mc command line may contain more than one file specification; however,",F- "the specifications may not be wild-carded.",f "",oQ "Each line of each input file will occupy one row-column position in the output",mQ "file.  If an item is too wide for its column, it is truncated with no message.",+ "",eP "The items from any one file are placed in order going down a column, and then",O "across columns.  Columns are filled by consecutive files, in rotating order.",  "",oQ "The use of \"-\" as a file specification causes the standard input to be read.", N "If mc is invoked with no file arguments at all, it reads the standard input",
 "file once.",g "",dN "Alias specifications provide a method for controlling the placement of file",J "data.  An alias specification is a reference to another file (or alias)",N "specification.  File and alias specifications are numbered, starting at one",L "for the left-most such specification; switches and their arguments do not",L "affect the numbering.  The alias specification #n indicates that the n'th",M "specification is to be repeated.  Such a specification is legal only if it",sK "refers to an earlier specification; i.e. #n is only legal as the n+1'st,",i "n+2'nd, etc. specification.", "", M "mc will attempt to make the columns on the last page of output as close in",tM "length as possible, rather than simply filling some columns all the way to",	N "the bottom and leaving others empty.  This special handling is enabled only",8 "when mc is given no more than one file specification.", "",i( "The following switches are available:", "	",- " -c	Next argument is the number of columns",e7 " -h	Next argument is the height, in lines, of a page", D " -g	Next argument is the gutter width (the space between columns)",; " -w	Next argument is the width, in characters, of a page", E " -t	Terminal mode; sets default height to 23, default width to 80,",r; "	and, if stdout is your terminal, pauses after each page",a "",  "The default values are:", "",tJ "	Height 58, width 132, no terminal mode; note that -t alters all three.",< "	Gutter 1, max(number-of-file-and-alias-specs,2) columns.", 0 };   u
 #ifdef vax11ct #include ctype.h #include stdio.h
 #ifdef vms #include		<ssdef.h>r #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)i #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */p #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif #define FALSE		0 #define TRUE		1p #define EOS		0 #else	 #include <stdio.h> #endif   /*$  * Turn on to include debugging code  */h /* #define DEBUG */:  7 #define	LINEMAX	256			/* Maximum line length handled	*/b' 					/*  (also maximum column width)	*/ 2 #define	NFILES	20			/* Maximum files (including	*/ 					/*  aliased files)		*/a1 #define	ALIAS	'#'			/* Marks an alias argument	*/u 					/*  (Can't be "-")		*/s #ifdef DEBUG int	debug	= 0; #endif1 int	columns	= -1;			/* All these will be given	*/h5 int	gutter	= -1;			/*  default values later unless	*/n2 int	height	= -1;			/*  the user sets them first	*// int	width	= -1;			/*  (to a positive value!)	*/a  3 int	pause	= FALSE;		/* Pause-at-end of page flag	*/l1 int	first	= TRUE;			/* First-time-through flag	*/ 0 int	cwidth;				/* Total (column+gutter) width	*/* int	pagesize;			/* Total bytes in page		*/- int	nf;				/* Number of file & alias specs	*/m1 int	files	= 0;			/* Number of files still open	*/ . int	aliases	= 0;			/* Number of alias specs	*/  7 FILE	*file[NFILES];			/* File pointers for our files	*/ . char	line[LINEMAX];			/* Input line buffer		*// int	linelen;			/* Length of a line in line[]	*/g0 int	lineend;			/* Last usable line[] position	*/, char	*page;				/* -> page paste-up matrix	*/   main(argc,argv)e	 int argc;t
 char *argv[];a {	register char *p;c 	register int c,i; 	int n;i
 	FILE *fp;  
 #ifdef	vms# 	argc = getredirection(argc, argv);r #endif< 	if (argc == 2 && argv[1][0] == '?' && strlen(argv[1]) == 1)
 	{	help();	 		return;n 	}   	nf = argc - 1;  	for (i = 1; i < argc; i++) {a 		p = argv[i]; 		if (*p == '-') {* 			if (p[1] == '\0')	/* stdin as a file	*/! 				continue;	/* skip this one	*/s   			argv[i] = 0;p 			--nf; 			for (++p; c = *p++;)h 				switch(tolower(c)) 				{o #ifdef DEBUG
 				case 'd':e
 					debug++;  					break;u #endif
 				case 'c':o 					if (++i >= argc)v 						usage(); 					columns = atoi(argv[i]);t 					if (columns <= 0) 						bad(argv[i],"columns");k 					argv[i] = 0;c
 					--nf; 					break;r  
 				case 'g':t 					if (++i >= argc)i 						usage(); 					gutter = atoi(argv[i]); 					if (gutter <= 0)r 						bad(argv[i],"gutter"); 					argv[i] = 0;t
 					--nf; 					break;t  
 				case 'h':e 					if (++i >= argc)t 						usage(); 					height = atoi(argv[i]); 					if (height <= 0)e 						bad(argv[i],"height"); 					argv[i] = 0;i
 					--nf; 					break;e  
 				case 't':t 					if (height<0) 						height = 23; 					if (width<0)  						width = 80;e 					if (ftty(stdout)) 						pause++; 					break;o  
 				case 'w':i 					if (++i >= argc)h 						usage(); 					width = atoi(argv[i]);e 					if (width <= 0) 						bad(argv[i],"width");t 					argv[i] = 0;t
 					--nf; 					break;h   				default:
 					usage();e 					break;e 				}h 		}t 	}   	if (nf > NFILES)f- 		error("Too many file and alias arguments");e  
 	if (nf == 0)u# 	{	nf = 1;				/* Run as a filter	*/o 		file[files++] = stdin; 	} 	elses 		for (i = 1; i < argc; i++) 			if (p = argv[i])  				switch (*p)a 				{o# 				case '-':	/* stdin as a file	*/n 					file[files++] = stdin;  					break;i   				case ALIAS:e 					n = atoi(&p[1]) - 1;d 					if (n < 0 || n >= files)  						error(6 		"\"%s\": bad alias specification - no such file\n",p 						); 					file[files++] = file[n];e 					aliases++;o 					break;e   				default:% 					if ((fp = fopen(p,"r")) == NULL)I 					{	perror(p);d 						exit(IO_ERROR);t 					} 					file[files++] = fp; 					break;  				}   . 	files -= aliases;			/* Aliases aren't open	*/   /*<  * Establish defaults for any parameters the user didn't set  */o 	if (width < 0)o 		width = 132; 	if (gutter < 0)
 		gutter = 1;o 	if (height < 0) 		height = 58; 	if (columns < 0) 
 		if (nf > 1)u 			columns = nf; 		else 			columns = 2;v   /*J  * The last column isn't followed by a gutter, but dealing with this makesM  * the computation too complex; so we simply pretend the page is wider, whichtM  * is ok since the code trims the trailing spaces that would go there anyway.aN  * This is, of course, quite wasteful of space, but then so is the whole algo-@  * rithm; we shouldn't be storing ANY of the gutters explicitly.  */h 	width += gutter;y 	cwidth = width/columns;  5 	if (cwidth <= gutter || (cwidth - gutter) > LINEMAX)s/ 		error("Unreasonable -c/-g/-w combination\n");s  $ 	lineend = line + (cwidth - gutter);  * 	page = malloc(pagesize = height * width); 	if (page == NULL)) 		error("Insufficient memory - sorry\n");f   #ifdef DEBUG 	if (debug)gA 	{	fprintf(stderr,"width %d, height %d, columns %d, cwidth %d\n",   			width,height,columns,cwidth); 		fprintf(stderr,i7 			"\tgutter %d, pause %d, pagesize %d, page at 0%o\n",E 			gutter,pause,pagesize,page);?4 		fprintf(stderr,"%d files(%d real + %d aliases)\n", 			nf,files,aliases);n 	} #endif   	process();- 	free(page); }n   /*  * Process all the datag  */u	 process()t/ {	register int	offset;			/* Offset into page	*/u/ 	register int	items;			/* Counts items added	*/-1 	register int	maxitems;		/* Room for this many	*/A$ 	int curfile;				/* Current file		*/   	maxitems = columns * height;d	 	blank();m 	curfile = items = offset = 0; 	while (get(file[curfile]))a 	{	if (items >= maxitems)u 		{	output(items); 			blank();h 			items = offset = 0; 		}L #ifdef DEBUG 		if (debug > 3)9 			fprintf(stderr,"Inserting %s at offset %d, file %d\n",u 				line,offset,curfile);] #endif! 		copy(page+offset,line,linelen);.
 		items++;5 		if ((items % height) == 0)	/* Bottom of a column	*/ ! 		{	curfile = (curfile + 1) % nf;e #ifdef DEBUG 			if (debug > 1) 2 				fprintf(stderr,"Switching to file %d of %d\n", 					curfile,files); #endif 		}s 		offset += cwidth;  	} 	output(items);" }    /*G  * Print out the buffered page, which has been filled with items items."  */f
 output(items)m. int items;				/* # of items the caller used	*/ {	int nrows; 	register int i,col,row;   #ifdef DEBUG 	if (debug)d' 		fprintf(stderr,"output(%d)\n",items);e #endif  ' 	if (items <= 0)			/* Nothin' to do		*/u	 		return;r   /*G  * Get number of rows we'll need.  This is the basis of the "last page"nK  * optimization - we don't use all the rows, just enough to hold everythinghL  * (items/columns, rounded up).  If there's more than are one file, just use  * the whole page.  */e
 	if (nf == 1)p, 		nrows = (items + (columns - 1)) / columns; 	elsee 		nrows = height;    #ifdef DEBUG 	if (debug > 1)f5 		fprintf(stderr,"items %d, nrows %d\n",items,nrows);  	if (debug > 2)  	{	page[pagesize] = 0;- 		fprintf(stderr,"Dump of page:\n%s\n",page);T 	} #endif   	if (first)p 		first = FALSE; 	elsea
 	{	if (pause)bL 		{	printf("\t\t\t      Type CTRL/Z to exit, any other key to continue..."); 			fflush(stdout); 			i = kbin(); 			putchar('\n');n 			if (i == 26)		/* CTRL/Z		*/ 				exit(IO_SUCCESS);e 		}d 		putchar('\f'); 	}   /*M  * Scan through page[] row-wise, after having filled it column-wise.  (Page[]p&  * is laid out column-wise in memory.)  */ " 	for (row = 0; row < nrows; row++)& 	{	for (col = 0; col < columns; col++)' 			putitem(page+(row+col*nrows)*cwidth,f 				(col == columns - 1)); 		putchar('\n'); 	} }i   /*6  * Put out one item, possibly trimming trailing spaces  */f putitem(base,trim)/ register char *base;				/* First char to put	*/"( int trim;					/* Trim trailing spaces	*/* {	register char *end;			/* End of item		*/   	end = &base[cwidth - 1];i
 	if (trim) 		while (*end == ' ')h	 			--end;i   	while (base <= end) 		putchar(*base++);t }    /*  * Blank out page[]T  */p blank()d {	register int n;y   	for (n = 0; n < pagesize;)h 		page[n++] = ' '; }o   /*N  * Fill line[]; return FALSE when all files have reached EOF, TRUE until then.  */r get(fp)n	 FILE *fp;N, {	register char *p;			/* Current char pos	*/1 	register char *high;			/* Char pos high water	*/p$ 	register int c;				/* Character		*/   	if (feof(fp))* 	{	linelen = 0;			/* Pretend we read ""	*/ 		return(TRUE);t 	}   	high = p = line;d+ 	while ((c = getc(fp)) != EOF && c != '\n')a 		switch(c)e 		{h 		case '\b': 			if (p > line) 				--p;	 			break;e   		case '\r': 			p = line;	 			break;e   		case '\t': 			if (((p - line) & 07) != 07)b 				ungetc(c,fp);s 			c = ' ';u 		/* 		 * Fall through... 		 */ 
 		default: 			if (isprint(c)) 			{	if ((p < lineend). 				 && (p == high || *p == '_' || *p == ' '))
 				{	*p = c;M 					if (p == high)i
 						high++;R 				}A 				p++; 				} 	 			break;_ 		}S   	linelen = high - line;i    	if (c != EOF).  		return(TRUE);  	else  		return((--files != 0)); }e   bad(v,s) char *v; char *s;0 {	error("\"%s\": bad %s specification\n",v,s);	}   usage()n {O> 	fprintf(stderr,"Usage:\n mc [-t] [-c columns] [-g gutter] ");< 		fprintf(stderr,"[-h height] [-w width] [file | #n]...\n"); 	error("mc ? for help"); }e   help() /*  * Give good helpm  */m {	register char	**dp;f  $ 	for (dp = documentation; *dp; dp++) 		printf("%s\n",*dp);d }l