 /*=  * MP -- Macro and conditional compilation preprocessor for C   */    /*)BUILD	$(PROGRAM)	= mp$ 		$(INCLUDE)	= { mpdefs.h mpextr.h }' 		$(FILES)	= { mp mpexpr mpsym mputil }  		$(STACK)	= 10000 		$(TKBOPTIONS)	= {  			STACK	= 1024  			TASK	= ...MPC 			ACTFIL	= 14
 			UNITS	= 14  		}  */   #ifdef	DOCUMENTATION   title	mp	Macro Pre-processor) index		Macro Pre-processor for C programs    synopsis   	mp [files]    description   F 	Mp is a general pre-processor for C programs.  It implements the full 	C pre-processor syntax: 	.lm +16? 	.s.i-16;_#line		Ignored (needed for communication with program  	generators such as lex.' 	.s.i-16;_#if		Conditional compilation. * 	.s.i-16;_#ifdef		Conditional compilation.) 	.s.i-16;_#else		Conditional compilation. * 	.s.i-16;_#endif		Conditional compilation.9 	.s.i-16;_#message	Writes a message on the user terminal. , 	.s.i-16;_#define		Define a symbol or macro.) 	.s.i-16;_#include	(nested) source files. 
 	.s.lm -16C 	See Kernighan and Ritchie for details of the C source file format.  	.s @ 	On Decus C, the compiler preprocessor phase may be supressed by, 	invoking the compiler with the "-m" switch: 	.s.nf 		MP file.c	(writes file.mpc)  		XCC file.mpc -m  	.s.f    diagnostics    	.lm +8 / 	.s.i -8;_... many, should be self-explanatory.  	.lm -8    author   	Robert W. Harper, Jr. 	.s . 	Mp was distributed via the Unix user's group.   bugs   #endif   /*G  *	Designed and written by Robert W. Harper, Jr. in fullfillment of the B  *	programming requirements for ICSS-580 Systems Programming takenA  *	during Winter quarter 1978/79, with invaluable assistance from @  *	Mike Lutz, my project advisor, who helped me with some sticky?  *	design issues and originally wrote the expression evaluator.   *  *	Version 1.10 - 4/18/79   *>  *	Edit log -- document all source changes here (and increment  *		the edit level!)     *	   First release: 4/4/79 RWH D  *	   Fixed conditional compilation bugs and changed #include paths:  *		4/7/79 RWH  9  *	   Added support for character constants: 4/10/79 RWH  E  *	   Fixed bug re extraneous <SOH> in front of #include line itself:   *		4/10/79 RWH B  *	   Fixed incorrect support of character constants: 4/12/79 RWH ?  *	   Made alpha() and alphanum() macro's instead of functions:   *		4/12/79 RWH <  *	   Fixed #ifdef/#ifndef argument length bug: 4/12/79 RWH 6  *	   Rewrote concat() to make it faster: 4/12/79 RWH A  *	   Allowed white space between '#' and directive: 4/13/79 RWH  B  *	   Modified actual() to propagate actuals through nested calls:  *		4/13/79 RWH ,  *	   Added _FILENAME and _LINE: 4/18/79 RWH:  *	   Fixed pop_ala() so that works correctly: 4/18/79 RWH  *C  *	   Added code for decus and vms implementations, also for stdio.   *		05-Sep-80 MMF  *	   More Decus stuff ... provide same predefined symbols as provided@  *	    by the Decus compiler's preprocessor. Also made '-P' flagC  *	    default to 'on', supressing <SOH> stuff, for Decus compiler, 4  *	    which does not recognize this.  05-Dec-80 RBD  *
  *				N O T E 0  *		It is necessary to compile this preprocessor/  *		on the TARGET operating system for the pre- "  *		defined symbols to be correct.  *A  *	   Changed directory search list to look for 'lb:' on RSX, and %  *	    'sy:' on RT-11.  05-Dec-80 RBD   *D  *	   Eliminate leading whitespace in macro expansion. 06-Dec-80 RBD  *E  *	   Display filespec string on failing #include file opens, instead 9  *	     of useless, terse "File not found". 06-Dec-80 RBD   *@  *	   Supress call to 'free' on include file open fail for stdioC  *	     version. Fix search list so it looks at "LB:[1,1]" for RSX.   *	     Bob Denny  29-May-81  *F  *	   Added automatic insertions of #LINE <line#> p.<page#> <filename>@  *	     for RSX systems.  <SOH> code completely removed.  -P nowB  *	     defaults to off.  Introduced default file extensions of .C;  *	     and .MPC.  Made output file default to <input.MPC>.   *	     Scott Roth, 25-Aug-81   *B  *	   Merged into "normal" distribution.  #LINE (as defined above)C  *	     is now only available by #define'ing UNIMATION in mpdefs.h.   *	     Martin Minow, 28-Mar-82   *A  *	This implementation of the C macro and conditional compilation F  *	preprocessor is designed to bring the currently-distributed versionF  *	of the C compiler up to the standards defined in "The C Programming?  *	Language" by Kernighan and Ritchie (sine qua non).  The only A  *	preprocessor feature that remains unimplemented is the "#line" E  *	directive.  This version is implemented as an independent program, F  *	designed to be forked to by "cc", much like the other passes of theF  *	compiler, though it may be used independently of the C compiler for/  *	any similar purpose.  The callling syntax is   *$  *		"mp [-P] input_file output_file"  *C  *	where the "-P" switch causes suppression of the <SOH> convention D  *	used by the compiler to flag included files (usually all lines of?  *	source stemming from an include file are preceded by a <SOH> H  *	character so that the compiler's line numbers agree with the source).H  *	NOTE: the '-P' switch is turned on permanently for the Decus version.6  *	(and under the vax native compiler -- MM 28-Mar-82)  *G  *	All routines are documented with introductory comments preceding the F  *	definition of the function, describing the techniques used therein.H  *	Other terse comments appear within the source code to clarify certainG  *	sticky parts.  The overall design of the processor is line-oriented, E  *	in that it reads a line, processes as necessary and then writes it @  *	out.  Due to lack of clarity in the specification of constantC  *	expressions in the aforementioned text, this processor evaluates I  *	expressions by first running them through the macro expansion routine, 7  *	then calling the recursive-descent parser/evaluator.   *E  *	Note that recursion is used in two major areas of the design -- in ?  *	the expression evaluator and in the macro expansion routine. C  *	Inherent in using a recursive solution to a problem is a certain C  *	degree of difficulty that arises when an error condition occurs. I  *	In order to solve this, the processor uses two small assembly-language F  *	routines, envsave() and envreset(), to save the frame pointer priorH  *	to the call of either routine (expand() or expr()); upon encounteringG  *	an error, envreset() is called to restore the environment to that of D  *	the top-level caller and force a particular value to be returned.C  *	(envsave and envreset were changed to setjmp() and longjmp() for ,  *	compatiblity with other stdio libraries).  *G  *	The code has been fairly thoroughly tested, but inevitably bugs will I  *	appear and complaints about the design will crop up.  If you encounter H  *	any bugs or have any suggestions for enhancements, contact the author2  *	or Mike Lutz at RIT School of Computer Science.  */    /*B  * Include compile-time constant definitions, external references,  * and structures.  */    #ifdef	decus
 #define stdio  #define Digital  #endif  
 #ifdef	vms
 #define	stdio  #define	Digital  #endif   #ifdef	stdio #include <stdio.h> #else  #define	NULL	(0) #endif  
 #ifdef	vms /*.  * This creates files in vanilla RMS on VMS V2  */  extern FILE *fdopen();@ #define	CREATE(f, m) fdopen(creat(f, 0, "rat=cr", "rfm=var"), m) #else  #define	CREATE	fopen #endif   #include "mpdefs.h"  #include "mpextr.h"    /*  * Setjmp/longjmp stuff   */  #include	<setjmp.h>  jmp_buf		jump_env;   /*
  * Directives   */   . char *dir_tbl[] = { /* Directive name table */
 	"define", 	"include", 	 	"undef",  	"if",	 	"ifdef", 
 	"ifndef", 	"else",	 	"endif",  	"message",  	"line", 	NIL };9 int dir_type[] = {	/* Directive mnemonics for 'switch' */  	DEF,  	INCL, 	UNDEF,  	IF, 	IFD,  	IFN,  	ELSE, 	ENDIF,  	MSG,  	LINE, };  ' int err_cnt = 0;		/* Error counter			*/    #ifdef Digital; int nocomp = TRUE;		/* No <SOH> stuff for Decus compiler	*/ 
 #ifdef rsx: char syn_err[] = {"RSX version. Syntax: mpc ifile ofile"}; #else  #ifdef rt11 C char syn_err[] = {"RT-11 Version. Syntax: run mp \"ifile ofile\""};  #else 
 #ifdef	vms> char syn_err[] = { "Vax-11C version. Syntax: mp ifile ofile"}; #else D char syn_err[] = {"Decus compiler assumed. Syntax: mp ifile ofile"}; #endif #endif #endif #else  /*  * True Unix  */ 0 int nocomp = FALSE;		/* No-compilation flag			*/1 char syn_err[] = {"Syntax: mp [-P] ifile ofile"};  #endif   /*  * I/O-related stuff  */    #ifdef stdio: FILE	*curinfil	= NULL;	/* Pointer to current input file	*/3 FILE	*outfil		= NULL;	/* Pointer to output file		*/  #else D struct buf *curinfil	= NIL;	/* Pointer to file buffer for current	*/ 				/* input file				*/ B struct buf *outfil	= NIL;	/* Current output file buffer pointer	*/ #endif   /*  * #include   */    int inclpdl[INCDEPTH]; struct stack inclstk = {
 	INCDEPTH, 	0,  	inclpdl };/ int inclvl = 0;			/* #include nesting level		*/ A int inclflag = FALSE;		/* Ugly fix for extraneous <SOH> before	*/   				/* #include line itself			*/ char *srchlist[] = {" 	"",			/* This must be first!			*/: #ifdef Digital			/* Next, look on device 'C:', then ...	*/ 	"c:", 	"lb:",			/* RSTS/E, VMS				*/1 #ifdef rt11			/* On RT-11, system disk is SY:		*/  	"sy:@",			/* RSTS/E				*/ 	"sy:",  #else 
 #ifdef rsx 	"sy:@",			/* RSTS/E				*/8 	"lb:[1,1]",		/* On RSX, default task/library disk LB:*/ #endif #endif #else   	"/usr/include/",	/* UNIX					*/ #endif! 	NIL			/* This must be last!			*/  };   /*  * Conditional compilation  */    int ifpdl[IFDEPTH];  struct stack ifstack = {	 	IFDEPTH,  	0,  	ifpdl };7 int father = TRUE;		/* Previous level expansion flag	*/ 5 int self = TRUE;		/* Current level expansion flag		*/    /*0  * Input line processing related data structures  */    char	line[LINESZ]; int	lineno[INCDEPTH]; 1 int	in_com = FALSE;			/* TRUE if in a comment		*/ = char	fname[INCDEPTH][40] = { NULL};	/* Include file names		*/ 1 int	pageno[INCDEPTH];		/* Include page number		*/ 5 int	linefeeds = 1;			/* Count line feeds as output	*/   > struct sym *_line;		/* _LINE macro -- definition is current	*/ 				/* line number				*/! char *lp;			/* Line pointer				*/    /*1  * Macro definition and expansion data structures   */   " char def_ala[ALASIZE][MAXIDLEN+1]; 				/* Definition ala			*/? char *call_ala[ALASIZE];	/* Dynamically-allocatable call ala	*/  char *callpdl[DEFDEPTH];   struct stack callstk = {
 	DEFDEPTH, 	0,  	callpdl };- 				/* Call stack - used to process nested	*/  				/* macro calls				*/ struct sym *refpdl[DEFDEPTH];  struct stack refstack = { 
 	DEFDEPTH, 	0,  	refpdl  };' 				/* Stack for referenced symbols		*/    /*  * Main driver  */    main(argc, argv)
 char *argv[]; 	 int argc;  {  	register char *tp1, *tp2; 	register int i; 	char name[MAXIDLEN+1];  	char name_buf[50], *f;   	int tvec[2], dir_kind, filecnt;   	/*   	 * Initialize line number stack 	 */ 	lineno[0] = 0;  	pageno[0] = 1;   ( 	for (i = 1, filecnt = 0; i < argc; i++) 		if (*argv[i] == '-') 			switch (argv[i][1]) { 			case 'p': 			case 'P': 				nocomp = TRUE;
 				continue;  			default:  				puts(syn_err);
 				exits(2);  			} 		else 			if (filecnt > 2) {  				puts(syn_err);
 				exits(2);  			} 			else  				tvec[filecnt++] = i;   	if (filecnt == 0) { 		puts(syn_err); 		exits(2);  	}   #ifdef stdio% 	f = strcpy(name_buf, argv[tvec[0]]);  	while (*f != '.' && *f != EOS)  		f++; 	if (*f == EOS)  		strcpy(f, ".C");1 	if ((curinfil = fopen(name_buf, "r")) == NULL) {  		perror(argv[tvec[0]]); 		exits(2);  	} 	if (filecnt == 1)( 		*f = EOS;		/* f -> after file name		*/ 	else { & 		f = strcpy(name_buf, argv[tvec[1]]);  		while (*f != '.' && *f != EOS) 			f++;  	} 	if (*f == EOS)  		strcpy(f, ".MPC");0 	if ((outfil = CREATE(name_buf, "w")) == NULL) { 		perror(argv[tvec[1]]); 		exits(2);  	}( 	*f = EOS;			/* name_buf has out name	*/ #else & 	curinfil = get_mem(sizeof *curinfil);* 	if (fopen(argv[tvec[0]], curinfil) < 0) {  		puts("Can't open input file");
 		exit(1); 	}" 	outfil = get_mem(sizeof *outfil);) 	if (fcreat(argv[tvec[1]], outfil) < 0) { # 		puts("Can't create output file"); 
 		exit(1); 	}! 	strcpy(name_buf, argv[tvec[1]]); ! 	f = name_buf + strlen(name_buf);  #endif+ 	sym_init();		/* Initialize symbol table */    	i = strlen(argv[tvec[0]]); . 	sym_enter("_FILENAM", 0, tp1 = get_mem(i+3)); 	*tp1++ = '"'; 	strcpy(tp1, argv[tvec[0]]); 	*(tp1+i) = '"'; 	*(tp1+i+1) = EOS;  1 	_line = sym_enter("_LINE", 0, tp1 = get_mem(9));  	strcpy(tp1, "\"      \"");    #ifdef Digital #ifdef decusI 	sym_enter("decus",0,get_mem(0)); /* Do predefines like Decus compiler */  #ifdef	nofpu! 	sym_enter("nofpu",0,get_mem(0));  #endif! 	sym_enter("pdp11",0,get_mem(0));  #endif
 #ifdef vax 	sym_enter("vax",0,get_mem(0));  #endif
 #ifdef rsx 	sym_enter("rsx",0,get_mem(0));  #endif #ifdef rt11   	sym_enter("rt11",0,get_mem(0)); #endif #endif2 	time(&tvec[0]);		/* Get encoded time and date		*/6 	tp1 = ctime(&tvec[0]);	/* Convert to text string 		*/6 	*(tp1+24) = '"';	/* Replace ending '\n' with a '"'	*/; 	tp2 = get_mem(27);	/* Date-time string is 27 characters	*/  	sym_enter("_DATE", 0, tp2);/ 	*tp2++ = '"';		/* Emit initial double quote */  	strcpy(tp2, tp1);   	/* & 	 * Main driving loop of the processor 	 */   	while (readline() != EOF) { 		tp1 = skipblnk(lp); 2 		if (tp1[0] == '#' && tp1[1] != EOS && !in_com) { 			/*  			 * A non-null directive?  			 */ 			lp = skipblnk(&tp1[1]); 			lp = get_id(lp, name);  			lp = skipblnk(lp); , 			if ((dir_kind = dir_find(name)) == ERROR)" 				printerr("Illegal directive");	 			else { + 				if (father && self) non_cond(dir_kind);  				cond(dir_kind);  			} 		} 6 		if (*tp1 == '#' || !(father && self)) line[0] = EOS; 		writeline(line); 	}  5 	if (!empty(&ifstack))		/* Check for dangling if's	*/  		printerr("Unterminated #if");  #ifdef stdio 	fclose(outfil); #else 1 	fflush(outfil);			/* Flush output file buffer	*/ 1 	close(outfil->fildes);		/* Close output file		*/  #endif 	exits((err_cnt == 0) ? 1 : 0);  } /* end main() */   /*A  *	Process conditional compilation directives.  This procedure is D  *	always executed, regardless of whether or not we are flushing dueI  *	to a false conditional. The general technique used here is as follows. C  *	The variables 'self' and 'father' contain the truth value of the E  *	current if-else-endif clause and the immediately enclosing clause, B  *	respectively.  Whenever an if is encountered, both are stacked,<  *	father &= self (to propagate any false conditionals), and  *	self = eval(arg).    *G  *	Upon encountering an else, self = !self, to reverse the sense of the G  *	current condition.  An endif causes the condition stack to be popped A  *	into father and self, restoring our context to the immediately   *	enclosing level.   *  * Note:F  *	This is a bad algorithm, as it requires a stack (and thus a maximumI  *	nesting level).  A true/false counter arraingement is to be preferred.   *  */    cond(dir_kind) register int dir_kind; { 7 	char symbol[MAXIDLEN+1];	/* buffer for ifdef/ifndef	*/    	switch(dir_kind) { 	 	case IF: 
 	case IFD:
 	case IFN:' 		if ((push(father, &ifstack) == ERROR) ) 				|| (push(self, &ifstack) == ERROR)) { * 			printerr("Maximum #if depth exceeded");	 			break;  		}  		if (father &= self)  			switch (dir_kind) { 			case IF:  				self = (expr(lp) != 0); 
 				break; 			case IFD: 				lp = get_id(lp, symbol);# 				self = (lookup(symbol) != NIL); 
 				break; 			case IFN: 				lp = get_id(lp, symbol);# 				self = (lookup(symbol) == NIL); 
 				break; 			} 		else 			self = FALSE; 		break;   	case ELSE:  		if (*lp != EOS) , 			printerr("Extraneous argument to #else"); 		if (empty(&ifstack))! 			printerr("#else without #if");  		else 			self = !self; 		break;   	case ENDIF: 		if (*lp != EOS) # 			printerr("Extraneous argument");  		if (empty(&ifstack))" 			printerr("#endif without #if"); 		else { 			self = (int)pop(&ifstack);  			father = (int)pop(&ifstack);  		}  		break; 	} 	return; }    /*@  *	Non-conditional directive processing is performed here.  ThisD  *	procedure is executed only if we are not currently flushing.  TheH  *	message and undef directives are implemented in a very straightforwarF  *	manner.  The others are a little more complex.  Macro definition isA  *	accomplished in four steps.  First the name of the macro being=G  *	defined is picked up; second formal parameters are processed; third,IG  *	the actual definition is processed (and index marker substitution isoG  *	peformed), and finally, the symbol is entered into the symbol table. C  *	Include processing goes as follows.  First the path name and itsp?  *	delimiter are picked up, then we attempt to find the file by+E  *	prepending the paths specified in 'srchlist[]' to it.  If the filegG  *	is found, the current input file is stacked (without closing it) and6=  *	the included file is set up as the new current input file.l  */i   non_cond(dir_kind)
 int dir_kind;a {o 	register int i, t, argcnt;e2 	char *defptr, *fid, *tp, delim, name[MAXIDLEN+1]; 	extern char	*get_def(); #ifdef stdio 	FILE	*tbp;e #elsed 	struct buf *tbp;. #endif   	switch(dir_kind) {t 	case LINE:i% 		writeline(line);		/* Do nothing		*/  		break;
 	case MSG: 		printerr(lp);p 		break; 	case UNDEF: 		lp = get_id(lp, name); 		if (sym_del(name) == ERROR)	" 			printerr("Symbol not defined"); 		break;
 	case DEF: 		lp = get_id(lp, name); 		if (*name == EOS) {h 			printerr("No symbol given");-	 			break;r 		}R% 		if ((argcnt = formal()) == ERROR) {t% 			printerr("Illegal argument list");u	 			break;f 		}* 		defptr = get_def(lp, argcnt);r" 		sym_enter(name, argcnt, defptr); 		break; 	case INCL:q 		if (inclvl == (INCDEPTH-1)) {o/ 			printerr("Maximum #include depth exceeded"); 	 			break;a 		}s
 #ifndef stdio " 		tbp = get_mem(sizeof *curinfil); #endif 		delim = *lp;% 		if (delim != '<' && delim != '"') {r4 			printerr("Illegal file specification delimiter");	 			break;* 		}E% 		delim = (delim == '<') ? '>' : '"';h
 		fid = ++lp;e* 		while (*lp != delim && *lp != EOS) lp++; 		if (*lp == EOS) { * 			printerr("Illegal file specification");	 			break;d 		}h 		*lp = EOS;   		/*6 		 * At this point 'fid' points to the null-terminated6 		 * file specification.  If the file specification is2 		 * enclosed in '"' then the current directory is3 		 * first searched for the specified file; if this 2 		 * fails or if the file spec is delimited by '<'6 		 * and '>' then a standard list of paths is searched 		 * (see 'srchlist' array). 		 */   6 		for (i = (delim == '>') ? 1 : 0; srchlist[i]; i++) {! 			tp = concat(srchlist[i], fid);  #ifdef stdio& 			if ((tbp = fopen(tp, "r")) != NULL)
 				break; #elses! 			if ((t = fopen(tp, tbp)) >= 0) 
 				break; #endif 		}M #ifdef stdio 		if (tbp == NULL) { #elsel 		if (t < 0) { #endif 			printerr(" ");*5 			fprintf(stderr, "Failed to open '#include' file");l+ 			fprintf(stderr, "\"%s\" on SY:\n", fid);D 			for (i=1;;i++)i 			  {# 			  if (srchlist[i] == NIL) break; - 			  fprintf(stderr," and '%s'",srchlist[i]);e 			  } 			fputs(". Sorry.\n",stderr);
 #ifndef stdiou
 			free(tbp);o #endif	 			break;i 		}e) 		if (push(curinfil, &inclstk) == ERROR) *3 			screech("#include stack overflow (impossible)");p 		inclvl++;	 		strcpy(fid, fname[inclvl]);f 		lineno[inclvl] = 0;e 		pageno[inclvl] = 1;. 		curinfil = tbp;  		/*9 		 * Inhibit <SOH> in front of #include line at top level' 		 */1 		if (inclvl == 1) 			inclflag = TRUE;e 		break; 	} /* end switch */s 	return; } /* end non_cond() */   /*D  *	Read a line of input routine -- loads 'line[]' with the next lineE  *	from the current input file.  Line continuation is handled here -- E  *	any occurrence of backslash-newline is replaced by a blank and the -  *	next line is tacked on to the current one.   *C  *	Upon hitting end of file, the include stack is popped to restorenG  *	input to the previous level.  If the stack is empty, EOF is returned ,  *	(indicating end of file at the top level.  */c   int readline() {s! 	register int buf_indx, curch, i; / 	int ctn_cnt;			/* Continuation line counter */t   	buf_indx = 0, ctn_cnt = 0;e 	do {t, 		while ((curch = getc(curinfil)) != '\n') {3 			if (curch == EOF) {	/* Current file exhausted */I #ifdef stdio 				fclose(curinfil);M #else8 				close(curinfil->fildes);* 				free(curinfil);	/* Release I/O node */ #endif 				if (empty(&inclstk)) { 					/*t 					 * Don't lose xyz<EOF>i 					 */ 					if (buf_indx > 0) 						break; 					else	return(EOF); 				}L
 				else { 					curinfil =c #ifdef stdio 						(FILE *) #elsee 						(struct buf *) #endif 							pop(&inclstk);# 					inclvl--; 					if (!nocomp) {s 					   fprintf(outfil,n #ifdef UNIMATION
 #ifdef PREPRE % 						"#define pg #%d p.%d %s\npg\n",p #elsef 						"#%d p.%d %s\n", #endif 						lineno[inclvl]+1,  						pageno[inclvl],a 						fname[inclvl]);e #elsen 						"#d %s\n", 						lineno[inclvl]+1,u 						fname[inclvl]);e #endif 					    linefeeds = 1;o
 					    } 				}e
 				continue;  			} 			line[buf_indx++] = curch; 			if (buf_indx >= LINESZ) {/ 				printerr("Next line too long, truncated.");b) 				while (curch != '\n' && curch != EOF)e 					curch = getc(curinfil);
 				break; 			} 		}e 		if (line[0] == '\f') { 			if (buf_indx == 1) {  				curch = ' '; 				buf_indx = 0;e 			} #ifdef	UNIMATION 			lineno[inclvl] = 0; #elseu, 			lineno[inclvl]++;	/* <FF> == <Newline>	*/ #endif 			pageno[inclvl]++; 		}d 		else { 			lineno[inclvl]++; 			if (inclvl == 0)e 				charincr(_line->defptr, 6);e" 			if (line[buf_indx-1] == '\\') {# 				curch = line[buf_indx-1] = ' ';c) 				ctn_cnt++;	/* Count continuations 	*/d 			} 		}r< 	} while (curch != '\n');	/* Repeat till real end of line	*/ 	line[buf_indx] = EOS; 	lp = line;o 	for (i = 0; i < ctn_cnt; i++). 		writeline("");		/* Keep compiler in synch	*/ 	return(OK); }i   /*?  *	Write line routine -- calls expand() to process macro calls, C  *	emitting expanded text to the output file.  If we are processingiF  *	a line from an include file, a <SOH> character is emitted preceding&  *	the line as a flag to the compiler.  */I   writeline(lineptr) char *lineptr; {a #ifdef	UNIMATION& 	if (lineno[inclvl] == 1 && !nocomp) {
 #ifdef	PREPRE 0 		fprintf(outfil, "#define pg #1 p.%d %s\npg\n", #elses! 		fprintf(outfil, "#1 p.%d %s\n",  #endif" 			pageno[inclvl], fname[inclvl]); 		linefeeds = 1; 	} #else ( 	if (inclvl > 0 && !inclflag && !nocomp)0 		putc(SOH, outfil);	/* Flag a #include line		*/2 	inclflag = FALSE;		/* Reset #include line flag	*/ #endif 	/*p5 	 * Save our environment for expand() error recovery.e- 	 * Then, expand the line to the output file.t 	 */ 	if (setjmp(jump_env) == 0)i 		expand(lineptr, NIL, NIL, 0);. 	putch('\n', NIL, NIL);n }i   /*  * Find a directivei  */a   dir_find(cp) register char *cp; {s 	register int i;  $ 	for (i = 0; dir_tbl[i] != NIL; i++)1 		if (lexeq(dir_tbl[i], cp)) return(dir_type[i]);t 	return(ERROR);* }    /*B  *	Set up definition argument list array (def_ala) with the formal@  *	parameters of the macro currently being defined.  Returns theF  *	number of formals actually processed, or ERROR if any syntax errorsB  *	are encountered.  Nested parantheses are handled here to permit$  *	macro calls as formal parameters.  */(   int formal() {f 	register int cnt;   	if (*lp != '(') return(0);M& 	for (cnt = 0; cnt < ALASIZE; cnt++) { 		lp = skipblnk(++lp);  		lp = get_id(lp, def_ala[cnt]);$ 		if (def_ala[cnt][0] == EOS) break; 		lp = skipblnk(lp); 		if (*lp != ',') break; 	} 	if (*lp != ')') return(ERROR); " 	lp++;				/* Skip past the ')'		*/3 	return(cnt+1);			/* Make it origin 1 and return	*/  }    /*H  *	Set up call argument list array (call_ala) with the actual parametersE  *	of the macro currently being expanded.  Each entry of the call_ala;D  *	is dynamically allocated; the maximum length of any one actual isG  *	determined by the compile-time constant "MAXARGSZ".  All occurrences F  *	of formal parameters are replaced by their corresponding actuals atF  *	the next outer level of call, thereby propagating actual parametersG  *	through nested calls.  The updated source pointer is returned to the1@  *	call unless an error is encountered, in which case "ERROR" is  *	returned.  */d   char * actual(src, argcnt)- register char *src;m int argcnt;" {  	register int argno, parenlvl; 	char *dst, *actp; 	int dstmax; 	static char arg_buf[MAXARGSZ];f< 	static char *proto_ala[ALASIZE];	/* Call's prototype ala	*/   	if (argcnt == 0) return(src);   	if (*src != '(') {i+ 		printerr("Required argument(s) missing");s 		return(ERROR); 	}   	dstmax = arg_buf+MAXARGSZ-1;o  : 	for (argno = 0; argno < argcnt && *src != ')'; argno++) {  % 		dst = arg_buf, src++, parenlvl = 0;f 		for (;;) {" 			src = skipq(src, &dst, dstmax);5 			if ((*src == ')' || *src == ',') && parenlvl == 0)=
 				break; 			switch(*src) {f 			case '(': 				parenlvl++;*
 				break; 			case ')': 				parenlvl--; 
 				break; 			case EOS:+ 				printerr("Unterminated argument list");0 				rlse_ala(argno-1); 				return(ERROR); 			} 			if ((*src & 0200) == 0)  				putch(*src++, &dst, dstmax);	 			else {e# 				actp = call_ala[*src++ & 0177];" 				while (*actp != EOS)" 					putch(*actp++, &dst, dstmax); 			} 		}e* 		if (putch(EOS, &dst, dstmax) == ERROR) {7 			printerr("Actual parameter length exceeds maximum");  			arg_buf[0] = EOS; 		}S, 		proto_ala[argno] = get_mem(dst - arg_buf);$ 		strcpy(proto_ala[argno], arg_buf); 	}  ' 	if (*src++ != ')' || argno < argcnt) {f# 		printerr("Argument count error");* 		rlse_ala(argno); 		return(ERROR); 	} 	else {	* 		for (argno = 0; argno < argcnt; argno++)& 			call_ala[argno] = proto_ala[argno]; 		return(src); 	} }H   /*G  *	Get macro definition routine -- loads a dynamically-allocated buffer E  *	with the text of the macro definition.  A pointer to the resultinglC  *	definition block is passed back to the caller.  A pointer to thenC  *	start of the definition to be processed is passed in 'srcp'; the*;  *	number of arguments to the macro is passed in 'numargs'.	F  *	Index markers representing the index of the formal parameter in theF  *	ala are substituted for formals as the definition is copied.  IndexB  *	markers are encoded as (0200 | ala index).  Note that no bufferE  *	limit checking is performed, because in no case will the processeda+  *	text be larger than the original source.[  *2  *	Leading whitespace is discarded.  05-Dec-80 RBD  */I   char * get_def(src, numargs)a register char *src;l int numargs; {  	register char *p; 	register int ala_index; 	char *dst;	 	static char defbuf[LINESZ]; 	char idbuf[MAXIDLEN+1];  4 	src = skipblnk(src);		/* Junk leading whitespace */ 	dst = defbuf;   	for (;;) { * 		src = skipq(src, &dst, defbuf+LINESZ-1); 		if (c_alpha(*src)) { 			p = get_id(src, idbuf);8 			for (ala_index = 0; ala_index < numargs; ala_index++)+ 				if (lexeq(idbuf, def_ala[ala_index])) {M 					*dst++ = 0200 | ala_index; 
 					src = p;[ 					break;  				}; 			while (src < p) 				*dst++ = *src++; 		}/ 		else  			if ((*dst++ = *src++) == EOS)
 				break; 	} 	p = get_mem(dst - defbuf);( 	strcpy(p, defbuf);s 	return(p);] })   /*G  *	Macro expansion routine -- scans text pointed to by 'srcp' for macro E  *	calls and formal parameters (which are by now represented as index F  *	markers (see 'get_def()') ).  If a character is neither a part of aG  *	macro call nor an index marker, it is transmitted to the output fileiB  *	or buffer (see 'putch()').  Upon encountering a macro call, theG  *	current argument list array is pushed onto the stack, the new actualiC  *	parameters are loaded, and 'expand()' is called recursively.  On	F  *	return from this recursive call, the arguments are released and the>  *	ala stack is popped.  Upon encountering a formal parameter,I  *	'expand()' is simply called recursively to expand the actual parameter"E  *	corresponding to the formal.  Note that the buffer length check iscF  *	performed only upon encountering the end of the current definition;C  *	meanwhile excess characters are flushed.  Thus only one check is A  *	necessary and only one error is reported.  To prevent cyclical H  *	definitions, each symbol table entry has a flag which is set wheneverH  *	a call on this macro is encountered.  This flag is checked for a zeroD  *	value before expansion of a macro begins; if it is set, the errorD  *	return is taken.  This prevents circular definitions from causing  *	problems.  */L   int0  expand(src, dst, dstmax, argcnt) register char *src;g char **dst, *dstmax; int argcnt;t {i 	register char *p; 	register struct sym *sym; 	char idbuf[MAXIDLEN+1];   	for (;;) {"  		src = skipq(src, dst, dstmax); 		if (c_alpha(*src)) { 			p = get_id(src, idbuf);& 			if ((sym = lookup(idbuf)) == NIL) { 				while (src < p)0  					putch(*src++, dst, dstmax); 			}	 			else {m 				src = p; 				if (sym->ref != 0)+ 					exp_err("Illegal recursive expansion",s 							argcnt);g
 				else {' 					if (push(sym, &refstack) == ERROR)," 						exp_err("Exceeded def nest", 						argcnt); 					else sym->ref = 1;e 				}t 				push_ala(argcnt);*1 				if ((src = actual(src, sym->nargs)) == ERROR)R 					exp_err(NIL, 0); 1 				expand(sym->defptr, dst, dstmax, sym->nargs);s 				rlse_ala(sym->nargs-1);r 				pop_ala(argcnt); 			} 		}; 		else { 			if ((*src & 0200) != 0) {0 				expand(call_ala[*src++ & 0177], dst, dstmax,
 					argcnt);  			}	 			else {d 				if (*src == EOS) { 					if (!empty(&refstack))] 						((struct sym *)S# 						    pop(&refstack))->ref = 0;u 					return(OK); 				}	1 				else if (putch(*src++, dst, dstmax) == ERROR) ) 					exp_err("expansion length exceeded",= 							argcnt);= 			} 		}	 	} }e   /*H  *	Error routine for expand().  If 'msg' is non-NIL, the message pointedC  *	to by 'msg' is printed on the standard error output.  The second&H  *	argument specifies the number of currently-active entries in the callI  *	ala -- that is, the number of ala entries that must be freed up beforedI  *	aborting.  After the ala has been released, the ala stack is purged tor:  *	release the memory used by suspended calls to expand().  */    exp_err(msg, ala_cnt)  register char *msg;( int ala_cnt; {o   	if (msg != NIL) printerr(msg);i 	while (!empty(&refstack))+ 		((struct sym *) pop(&refstack))->ref = 0;t8 	rlse_ala(ala_cnt-1);		/* Release current ala entries	*/ 	while (!empty(&callstk))s* 		free(pop(&callstk));	/* Purge stack			*/ 	longjmp(jump_env, -1);l }o   /*?  * Routine to push the contents of the call ala onto the stack.l  */    push_ala(numargs)h register int numargs;e {, 	register int i;   	for (i=0; i<numargs; i++)+ 		if (push(call_ala[i], &callstk) == ERROR)v5 			exp_err("Maximum call nesting depth exceeded", i);e 	return; }e   /*>  * Routine to pop the contents of the call ala from the stack.  */a   pop_ala(numargs) register int numargs;r {o 	register int i;  ! 	for (i = numargs-1; i >= 0; i--)l 		call_ala[i] = pop(&callstk); 	return; }   
 #ifndef	decuss exits(v) int	v; /*  * Exit with status.  */r {f 	if (v <= 1)  		exit();		/* No parameters			*/ 	else + 		exit(v);	/* "error message" hopefully		*/  }c #endif