 /*A  *	Constant expression evaluator -- performs a standard recursivefB  *	descent parse to evaluate any legal C constant expression.  AllG  *	operators without side-effects are implemented (thus ++, --, and alle'  *	assignment operators are omitted).  r  *B  *	The macro expansion routine is called to process the expressionB  *	before it is evaluated.  All macros used in the expression mustF  *	ultimately evaluate to legal C constants.  This code was originallyG  *	written by Mike Lutz and was modified by Bob Harper to fit into thise2  *	program and to conform to C language standards.  */c   /*&  * Include global constant defintions.  */n   #include "mpdefs.h"e   /*  * Variables global to expr   */o  5 static char *nxtch = EOS;	/* Parser scan pointer			*/eA static char expbuf[EXPBUFSZ];	/* Buffer for expansion routine		*/N /*  * For longjmp  */e #include	<setjmp.h>F static jmp_buf	exp_jump;   expr(exptr)e char *exptr; {i 	char		*dst;   	setjmp(exp_jump); 	dst = expbuf; 	if (setjmp(exp_jump) != 0)  		return (FALSE);)8 	if (expand(exptr, &dst, expbuf+EXPBUFSZ-2, 0) == ERROR) 		return(FALSE); 	*dst = EOS; 	nxtch = expbuf; 	if (setjmp(exp_jump) != 0)  		return (FALSE);( 	return(eval()); }m  ( /*	<eval> ::= <query> <end-of-string>	*/   eval() {h 	register int rval;    	rval = query() ;  	if ( skipws() == EOS )a 		return( rval ) ;$ 	experr( "Ill-formed expression" ) ; }g  7 /*	<query> ::= <lor> | <lor> '?' <query> ':' <query>	*/    query()f {n) 	register int bool, true_val, false_val ;m   	bool = lor() ;x 	if ( skipws() != '?' ) {r
 		ungetch() ;t 		return( bool ) ; 	}   	true_val = query() ;e 	if ( skipws() != ':' )= 		experr( "Bad query" ) ;	   	false_val = query() ;( 	return( bool ? true_val : false_val ) ; }	  & /*	<lor> ::= <land> { '||' <land> }	*/   lor()- {	 	register int c, vl, vr ;!   	vl = land() ;4 	while ( (c = skipws()) == '|' && getch() == '|' ) { 		vr = land() ;o 		vl = vl || vr ;; 	}   	if ( c == '|' )
 		ungetch() ;t 	ungetch() ; 	return( vl ) ;f }   & /*	<land> ::= <bor> { '&&' <bor> }		*/   land() {o 	register int c, vl, vr ;   
 	vl = bor() ;*4 	while ( (c = skipws()) == '&' && getch() == '&' ) { 		vr = bor() ; 		vl = vl && vr ;i 	}   	if ( c == '&' )
 		ungetch() ;d 	ungetch() ; 	return( vl ) ;* }e  & /*	<bor> ::= <bxor> { '|' <bxor> }		*/   bor()= {' 	register int vl, vr, c ;)   	vl = bxor() ;4 	while ( (c = skipws()) == '|' && getch() != '|' ) {
 		ungetch() ;N 		vr = bxor() ;  		vl |= vr ; 	}   	if ( c == '|' )
 		ungetch() ;; 	ungetch() ; 	return( vl ) ;	 }(  & /*	<bxor> ::= <band> { '^' <band> }	*/   bxor() {t 	register int vl, vr ;   	vl = band() ; 	while ( skipws() == '^' ) { 		vr = band() ;" 		vl ^= vr ; 	}   	ungetch() ; 	return( vl ) ;  }   $ /*	<band> ::= <eql> { '&' <eql> }	*/   band() {, 	register int vl, vr, c ;   
 	vl = eql() ;"4 	while ( (c = skipws()) == '&' && getch() != '&' ) {
 		ungetch() ;k 		vr = eql() ; 		vl &= vr ; 	}   	if ( c == '&' )
 		ungetch() ;c 	ungetch() ; 	return( vl ) ;) }   + /*	<eql> ::= <relat> { <eqrel> <relat> }	*/    eql()i {v 	register int vl, vr, rel ;1   	vl = relat() ;p# 	while ( (rel = geteql()) != -1 ) {  		vr = relat() ;   		switch ( rel ) {   		case EQL:  			vl = (vl == vr) ;
 			break ; 		case NEQ:w 			vl = (vl != vr) ;
 			break ; 		}  	} 	return( vl ) ;i }o  + /*	<relat> ::= <shift> { <rel> <shift> }	*/    relat()o {h 	register int vl, vr, rel ;o   	vl = shift() ;e# 	while ( (rel = getrel()) != -1 ) {s   		vr = shift() ; 		switch ( rel ) {   		case LEQ:i 			vl = (vl <= vr) ;
 			break ; 		case LSS:o 			vl = (vl < vr) ;,
 			break ; 		case GTR:p 			vl = (vl > vr) ;p
 			break ; 		case GEQ:  			vl = (vl >= vr) ;
 			break ; 		}* 	} 	return( vl ) ;o }i  0 /*	<shift> ::= <primary> { <shop> <primary> }	*/   shift()  {_ 	register int vl, vr, c ;c   	vl = primary() ; B 	while ( ( (c = skipws()) == '<' || c == '>' ) && c == getch() ) { 		vr = primary() ;   		if ( c == '<' )  			vl <<= vr ; 		else 			vl >>= vr ; 	}   	if ( c == '<' || c == '>' )
 		ungetch() ;I 	ungetch() ; 	return( vl ) ;  }	  / /*	<primary> ::= <term> { <addop> <term> }		*/	  	 primary()c {k 	register int c, vl, vr ;'   	vl = term() ;. 	while ( (c = skipws()) == '+' || c == '-' ) { 		vr = term() ;E 		if ( c == '+' )l
 			vl += vr ;n 		else
 			vl -= vr ;	 	}   	ungetch() ; 	return( vl ) ;u })  + /*	<term> := <unary> { <mulop> <unary> }	*/;   term() {o 	register int c, vl, vr ;u   	vl = unary() ;A: 	while ( (c = skipws()) == '*' || c == '/' || c == '%' ) { 		vr = unary() ;   		switch ( c ) { 			case '*': 				vl *= vr ; 				break ;i 			case '/': 				vl /= vr ; 				break ;	 			case '%': 				vl %= vr ; 				break ;	 		}n 	} 	ungetch() ; 	return( vl ) ;n }e  + /*	<unary> ::= <factor> | <unop> <unary>	*/	   unary()[ {_ 	register int val, c ;  7 	if ( (c = skipws()) == '!' || c == '~' || c == '-' ) {r 		val = unary() ;h   		switch ( c ) { 		case '!':	return( ! val ) ;g 		case '~':	return( ~ val ) ;} 		case '-':	return( - val ) ;{ 		}i 	}   	ungetch() ; 	return( factor() ) ;	 }_  * /*	<factor> ::= <num> | '(' <query> ')'	*/   factor() {e 	register int val ;l   	if ( skipws() == '(' ) {  		val = query() ;n 		if ( skipws() != ')' ) 			experr( "Bad factor" ) ;i 		return( val ) ;h 	}   	ungetch() ; 	return( const() ) ; }n  " /*	<const> ::= <num> | '<char>'	*/   const()' {* /*-  * Note: const() handles multi-byte constants   */    	register int	i; 	register int	value; 	register char	c;  	int		v[sizeof (int)];   	if (skipws() != '\'') { 		ungetch(); 		return(num(0));; 	}$ 	for (i = 0; i < sizeof(int); i++) { 		if ((c = getch()) == '\'') {
 			ungetch();p	 			break;o 		}m 		if (c == '\\') { 			switch ( c = getch() ) {t 			case '0': 			case '1': 			case '2': 			case '3': 			case '4': 			case '5': 			case '6': 			case '7': 				ungetch(); 				c = num(1); 
 				break; 			case 'n': 				c = 012;
 				break; 			case 'r': 				c = 015;
 				break; 			case 't': 				c = 011;
 				break; 			case 'b': 				c = 010;
 				break; 			case 'f': 				c = 014;
 				break; 			} 		}  		v[i] = c;l 	} 	if (i == 0 || getch() != '\'');' 		experr("Illegal character constant");g 	for (value = 0; --i >= 0;) {l 		value <<= 8; 		value += v[i]; 	} 	return(value);R }t  ' /*	<num> ::= <digit> | <num> <digit>	*/a  	 num(flag)nB int	flag;	/* if flag is zero, the first byte selects conversion	*/ {t 	register int rval, c, base;
 	int ndig;   	c = skipws();- 	base = (flag || c == '0') ? OCTAL : DECIMAL;  	rval = 0 ;F 	ndig = 0 ;v9 	while ( c >= '0' && c <= (base == OCTAL ? '7' : '9') ) {  		rval *= base ; 		rval += (c - '0') ;  		c = getch() ;(
 		ndig++ ; 	}   	ungetch() ; 	if ( ndig ) 		return( rval ) ; 	experr( "Bad constant" ) ;n }i  $ /*	<eqlrel> ::= '=' | '==' | '!='	*/   geteql() {e 	register int c1, c2 ;   	c1 = skipws() ; c2 = getch() ;f   	switch ( c1 ) {  
 	case '=': 		if ( c2 != '=' ) 			ungetch() ; 		return( EQL ) ;a  
 	case '!': 		if ( c2 == '=' ) 			return( NEQ ) ; 		ungetch() ; ungetch() ;  		return( -1 ) ;  	 	default:  		ungetch() ; ungetch() ;t 		return( -1 ) ; 	} }c  ' /*	<rel> ::= '<' | '>' | '<=' | '>='	*/p   getrel() {i 	register int c1, c2;	   	c1 = skipws();  	c2 = getch() ;	   	switch ( c1 ) {  
 	case '<': 		if ( c2 == '=' ) 			return( LEQ ) ;
 		ungetch() ;; 		return( LSS ) ;e  
 	case '>': 		if ( c2 == '=' ) 			return( GEQ ) ;
 		ungetch() ;  		return( GTR ) ;a  	 	default:a 		ungetch() ; ungetch() ;t 		return( -1 ) ; 	} }   7 /*	return next character from the expression string.	*/,   getch()a {a 	return(*nxtch++); }m  + /*	Put back the last character examined.	*/y  	 ungetch()t {  	return( *--nxtch ) ;l }c  < /*	Skip over any white space and return terminating char.	*/   skipws() {  	register char c;e  * 	while ( (c = getch()) <= ' ' && c > EOS ) 		;e 	return( c ) ; }e   /* .A  * Error handler - resets environment to eval(), prints an error,   * and returns FALSE  */i   experr(msg) 
 char *msg; {. 	printerr(msg); ; 	longjmp(exp_jump, -1);		/* Force eval() to return FALSE	*/  }g