 /* G  *	Symbol table manipulation routines for mp.  The general symbol tablea?  *	organization is linked list representation with bucketing toxA  *	decrease search time.  The buckets are determined by the firstr<  *	character of the symbol (and thus 54 buckets are needed).  *G  *	If this implementation turns out to be a bottleneck, some other typeeI  *	of bucket mapping function may be defined to reduce crowding.  If thisrA  *	fails to be adequate, then a completely different symbol tableaE  *	mechanism could be tried (but remember that we need the ability to D  *	delete symbols, which makes a simple hasing technique untenable).  */a   /*&  * Include global constant definitions  */p   #include "mpdefs.h"s  4 struct sym *sym_bkts[54];	/* Symbol table buckets */   /*  * Symbol table lookup  */e   struct sym *lookup(symbol)     register char *symbol;     {d 	register struct sym *ptr;  D 	for (ptr = sym_bkts[bkt_map(*symbol)]; ptr != NIL; ptr = ptr->next) 		if (lexeq(symbol, ptr->name))t	 			break;x
 	return(ptr);;     }s   /*'  * Enter a symbol into the symbol tablet  */e  , struct sym *sym_enter(symbol, nargs, defptr) char *symbol, *defptr;
 int nargs; {t 	register int bucket;e 	register struct sym *p, *tp;x   	bucket = bkt_map(*symbol);e! 	if ((p = lookup(symbol)) != NIL))3 		free(p->defptr);	/* free old definition buffer	*/c 	else {i 		/*% 		 * Allocate a new symbol table nodel 		 */*# 		p = get_mem(sizeof *sym_bkts[0]);' 		p->next = NIL; 		if(sym_bkts[bucket] == NIL)  			sym_bkts[bucket] = p; 		else {/ 			for (tp = sym_bkts[bucket]; tp->next != NIL;c 					tp = tp->next); 			tp->next = p; 		}( 	}5 	strcpy(p->name, symbol);	/* Copy name into entry		*/ 2 	p->nargs = nargs;		/* Set number of parameters	*/7 	p->defptr = defptr;		/* Set ptr to definition block	*/	* 	p->ref = 0;			/* Clear reference flag		*/ 	return(p);d };   /*(  * Delete a symbol from the symbol table  */{   int sym_del(symbol)l
 char *symbol;  {  	register struct sym *p, *tp;  	register int bucket;r   	bucket = bkt_map(*symbol); : 	for (p = sym_bkts[bucket]; p != NIL; tp = p, p = p->next) 		if (lexeq(symbol, p->name)) {(- 			free(p->defptr);	/* Free old definition	*/	 			if (p == sym_bkts[bucket])i 				sym_bkts[bucket] = p->next;c 			else tp->next = p->next;(# 			free(p);		/* And release node	*/  			return(OK); 		}o 	return(ERROR);e }n   /*?  * Map an alphabetic character into a symbol table bucket indexc  */=   int bkt_map(c)     register char c;     {l 	if(!c_alpha(c))' 		screech("Invalid call to bkt_map()");) 	if (c == '_')
 		return(52);< 	else if (c == '$')'
 		return(53);  	else if (c >= 'A' && c <= 'Z'); 		return(c - 'A'); 	else return(c - ('a' - 26));	     }n  # /* Dump contents of symbol table */;   sym_print()  {  	register int i; 	register struct sym *p; 	register char *cp;e  , 	printf("\n\nSymbol table dump follows:\n"); 	for (i = 0; i < 54; i++)c0 		for (p = sym_bkts[i]; p != NIL; p = p->next) {3 			printf("%s<%d,%d>=", p->name, p->nargs, p->ref);u) 			for (cp = p->defptr; *cp != EOS; cp++)> 				if (*cp & 0200)>$ 					printf("#%c",(*cp & 0177)+'0'); 				else	printf("%c", *cp);  			printf("\n"); 		}e 	return; }   % /* Initialize symbol table buckets */(  
 sym_init() {e 	register int i;   	for (i = 0; i < 54; i++)e 		sym_bkts[i] = NIL; 	return; }e