 /*
  *				n m . c   */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...NMX 		}T */   /*  * nm [-1bcdfgruv] file   *  *		nm	file[.obj]   *  F  * This program reads through an object file or a TKB symbol table andI  * prints a list of all the symbols it finds. I have found that these are K  * a reasonable alternative to load maps, except for the fact that TKB doesr:  * not put the undefined symbols in the symbol table file.  *4  * Note:  modified 25-Apr-80 for the newer C format.K  * modified 21-Feb-85 JSL - add VAX C redirection call.  No guarantees this	0  *		produces a program that's good for anything!  * x&  * It has dozens of options. They are:  * "4  *	-1		Output names in 1 column, default is 4 column4  *	-b		Includes RSX control block symbols. These are1  *			symbols of the form x.xxxx x$xxxx xx.xxx and 2  *			xx$xxx. Normally these symbols are supressed.5  *	-c		Include C compiler internal symbols. These are .  *			symbols that begin with a "." and contain%  *			only digits. Normally supressed. 1  *	-d		Differences. The symbol table is sorted by -  *			address, each symbol is replaced by the  /  *			difference between it and the next symbol. 0  *			This is used to see how large your routines	  *			are. .  *	-f		Print symbols in file order. No sort is  *			performed.p0  *	-g		Print only global symbols. The default is$  *			to print globals and internals.+  *	-m		Map underscore to '_' for C symbols.e)  *	-r		Reverse the direction of the sort.t1  *	-u		Print undefined symbols. Undefined symbolst  *			are normally supressed.  *	-x		Cross reference list.2  *	-v		Sort by value, the default is sort by name.  * e  */    #ifdef	DOCUMENTATION  ) title	nm	Print Object Module Symbol Names ) index	nm	Print Object Module Symbol Namesa   synopsis   	nm [-options] file[.obj]C   descriptionr  E 	nm (NameList) reads through an object file or a TKB symbol table andF@ 	prints a list of all the symbols it finds. This is a reasonableB 	alternative to load maps and is useful in determining what global7 	symbols are defined or referenced by an object module.n 	.sd$ 	It has dozens of options. They are: 	.lm +8y? 	.s.i -8;-1	Output names in one column, default is four columns	
 	per line.@ 	.s.i -8;-b	Include RSX-11M control block symbols.  These are ofF 	the form "x.xxxx", "x$xxxx", "xx.xxx", and "xx$xxx".  Normally, these= 	are supressed by nm.  Note that -b is appropriate if you areY+ 	examining objects produced by C compilers.a= 	.s.i -8;-c	Include C compiler internal symbols.  These begin 9 	with a "." and contain only digits.  Normally supressed.;7 	.s.i -8;-d	Differences.  The symbol table is sorted by=F 	address and the symbol value printed is the difference between it andD 	the next symbol.  This may be used to see how large each module is.? 	.s.i -8;-f	Print symbols in file order.  No sort is performed.	? 	.s.i -8;-g	Print only global symbols.  The default is to print  	both globals and internals.9 	.s.i -8;-m	Map Radix-50 "." to underscore for C symbols.o. 	.s.i -8;-r	Reverse the direction of the sort.C 	.s.i -8;-u	Print undefined symbols.  These are normally supressed. 7 	.s.i -8;-v	Sort by value; the default is sort by name.n= 	.s.i -8;-x	Print an inter-module cross reference list of all+7 	symbols defined in all input files.  Forces -b and -g.o	 	.s.lm -8rD 	nm accepts multiple input file names.  Names may contain wildcards.@ 	Note that, if compiled under RT11, nm accepts only "RT11-style"> 	object modules, while, if compiled under RSX, nm accepts only? 	"RSX-style" object modules.  Vax native has never been tested;=3 	it might read RSX (compatiblity) modules, however./   diagnosticsn   	.lm +8 ! 	.s.i -8;"file name": cannot open& 	.s.i -8;"Usage: ..."p 	.s B 	This message is printed on illegal flags or other command errors.% 	.s.i -8;"file name": bad file formatr 	.stD 	The input file was not in the necessary object-module format.  This@ 	could mean that the program was compiled by the wrong operating 	system. 	.s.i -8;Too many symbolsr 	.s.i -8;Too many sections 	.s  	.lm -8  	All errors are fatal.   author   	David Conroy, Martin Minowg   bugs   #endif   #include <stdio.h>
 #ifdef vms #include		<ssdef.h>r #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)p #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */n #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   #define	NSY	500r #define	NPS	20 #define	AB0	0127400  #define AB1	0003243e #define AB2	0127401  #define AB3	0007624  #define RBMAX	128   
 #define	GSD	1  #define	G_CSN	1  #define	G_ISN	2  #define	G_GSN	4  #define	G_PSN	5  #define	G_DEF	010    #define	FALSE	0  #define	TRUE	1
 #define	EOS	0    typedef struct symbol {  	struct symbol	*s_next;  	char		*s_name; 1 	struct module	*s_defn;	/* Where it's defined		*/ 3 	struct refer	*s_refer;	/* Where it's referenced	*/ 	 } SYMBOL;    typedef struct module {  	struct module	*m_next;  	char		*m_name;  	int		m_index;	 } MODULE;    typedef struct refer { 	struct refer	*r_next; 	struct module	*r_module;a } REFERENCE;   extern char	*strsave();  extern char	*myalloc();y   typedef unsigned addr_t; typedef unsigned r50_t;   	 struct	rb	 {a
 	int	type; 	char	data[RBMAX]; };   struct	gsdeo {= 	r50_t	g_name[2];i
 	char	g_flag;>
 	char	g_type;{ 	addr_t	g_value; };  
 struct	sym {- 	char	s_name[6];
 	char	s_flag;r
 	char	s_type;(
 	int	s_ps; 	addr_t	s_value; };  
 struct	pst {o 	r50_t	p_name[2];  	addr_t	p_size;m };  
 struct	rb	rb;r struct	sym	sym[NSY]; struct	pst	pst[NPS];
 char	*rbe; int	nsy; int	nps; int	cps;	 char	*fn;)	 FILE	*fp;s
 int	oflag;
 int	bflag;
 int	cflag;
 int	dflag;
 int	fflag;
 int	gflag;
 int	mflag;
 int	rflag;
 int	uflag;
 int	vflag;
 int	xflag; char	filename[80];   SYMBOL		*sfirst		= NULL; MODULE		*mfirst		= NULL; REFERENCE	*rfirst		= NULL;   char		workingtext[133];  char		wildname[80];  #define		CROSS_MAX	30r! int		cross[CROSS_MAX][CROSS_MAX];" char		*mname[CROSS_MAX]; int		cmax		= -1; f main(argc, argv)
 char *argv[];i {( 	register int i, c;  	register char *p; 	MODULE		*mp, *newmodule();. 	int		multi, nwild, nfiles;  	extern char	*instr();  
 #ifdef vax 	/* ? 	 * Do redirection for VAX C.  Note that this program may stillt? 	 * not do anything useful when compiled this way, but at least;! 	 * it will "do it consistently"!i 	 */" 	argc = getredirection(argc,argv); #endif   	multi = 0;u 	fn = NULL;t 	for(i=1; i<argc; ++i) { 		p = argv[i]; 		if(*p == '-') {c 			++p;t 			while(c = *p++) { 				switch(tolower(c)) {  
 				case '1':S
 					++oflag;o 					break;l  
 				case 'b':r
 					++bflag;  					break;m  
 				case 'c':;
 					++cflag;  					break;   
 				case 'd':t
 					++dflag;o 					break;g  
 				case 'f': 
 					++fflag;s 					break;t  
 				case 'g':n
 					++gflag;m 					break;   
 				case 'm':&
 					++mflag;! 					break;n  
 				case 'r':y
 					++rflag;) 					break;u  
 				case 'u':,
 					++uflag;i 					break;   
 				case 'v': 
 					++vflag;/ 					break;_  
 				case 'x': 
 					++xflag;y 					++gflag;	/* Globals	*/n 					++bflag;	/* xx_xxx, too	*/> 					break;	   				default:
 					usage();u 				}  			} 			argv[i] = NULL; 		}s 		else { 			multi++;a" 			if (instr(argv[i], '*') != NULL# 			 || instr(argv[i], '?') != NULL)	 				multi++; 		}  	} 	if (multi == 0) {1 		fprintf(stderr, "Need a file name argument\n");  		exit(IO_ERROR);b 	} 	nwild = 0;E 	for (i = 1; i < argc; i++) {a 		if (argv[i] == NULL) 			continue; 		strcpy(wildname, argv[i]);# 		if (instr(wildname, '.') == NULL)  			strcat(wildname, ".obj");. 		if ((fp = fwild(wildname, "run")) == NULL) { 			perror(wildname); 			continue; 		}	1 		for (nfiles = 0; fnext(fp) != NULL; nfiles++) {n 			fgetname(fp, filename); 			if (xflag) {  				mp = newmodule();t 				readin(mp);  			}	 			else {e 				readin(NULL);u 				if (dflag) 					deltas(); 				if (!fflag)  					sort(vflag, rflag); 				if (multi > 1) { 					printf("%s%s\n\n",U 						((nfiles + nwild) > 0) ? 							"\f" : "",  						filename); 				} 
 				output();B 			} 		}{ 		if (nfiles == 0) {/ 			fprintf(stderr, "no files matched \"%s\"\n",m 				wildname); 		}*
 		nwild++; 	} 	if (nwild == 0) {( 		fprintf(stderr, "no files present\n"); 	} 	else if (xflag) { 		outref();  	} }f   /*  * Put out usage message.a
  * Just exit.   */a usage()x {t/ 	error("Usage: nm [-1bcdfgmruvx] file_list\n");f }d   /*  * Read through the object or*  * symbol table file.-  * Save all of the symbols in   * the big buffer.  * Just exit if the file formatl  * is wrong, or if a table
  * overflows.r  */a
 readin(mp)/ MODULE		*mp;		/* Module pointer if non-null		*/e {r 	register struct gsde *p;e 	register struct sym  *sp; 	register int t; 	char ab[6];  " 	if(!getrec() || rb.type != GSD) {5 		fprintf(stderr, "%s: bad file format\n", filename);.	 		return;h 	} 	do {  		if (rb.type != GSD)I 			continue;# 		for (p = rb.data; p < rbe; ++p) {	 			t = p->g_type; " 			if (t == G_CSN || t == G_PSN) { 				if (!xflag) {e 					cps = lookup(p);c 				}  			}' 			else if (t == G_GSN || t == G_ISN) {s 				if (gflag && t == G_ISN) 					continue;* 				if (uflag && (p->g_flag & G_DEF) != 0) 					continue; 				convert(ab, p->g_name);e 				if(!cflag && csym(ab)) 					continue; 				if(!bflag && bsym(ab)) 					continue; 				if (xflag) {1 				    newref(ab, (p->g_flag & G_DEF) != 0, mp);  				    continue;r 				}' 				if(nsy >= NSY)" 					error("Too many symbols!\n"); 				sp = &sym[nsy++];f 				copy(sp->s_name, ab, 6); 				sp->s_type = t;  				sp->s_flag = p->g_flag;r 				sp->s_ps = cps;r 				sp->s_value = p->g_value;  			} 		}* 	} while(getrec());C }N   /*6  * Read a record from the file into the record buffer."  * True return if the read was ok..  * Set up rbe to point just beyond the record.  *  * RT11 object module format:r"  *	(optional string of NULL bytes)  *	001 000		Header   *	low high	Size low, high bytes  *	(size-4 bytes)	Data recorda  *	byte		Checksum (ignored)u  */d inti getrec() {b #ifdef	rt11a 	register int	n; 	register char	*rbp; 	register int	c;   	while (!feof(fp)) {3 		if ((c = getc(fp)) != 0)	/* Skip leading nulls	*/o	 			break;l   	} 	if (feof(fp)) 		return(FALSE);# 	if (c != 1) {				/* Header ok?		*/b9 		fprintf(stderr, "Illegal rt11 .obj format in \"%s\"\n", 
 			filename);N 		return(FALSE); 	}$ 	getc(fp);				/* Should be a zero	*/+ 	c = getc(fp) & 0377;			/* Size low byte	*/e1 	n = (getc(fp) << 8) + c - 4;		/* Record size		*/i 	rbp = (char *)&rb;s 	while (--n >= 0) {  		*rbp++ = getc(fp); 	}& 	getc(fp);				/* Skip over checksum	*/ 	if (feof(fp)) {? 		fprintf(stderr, "Incomplete final record in %s\n", filename);e 		return (FALSE);  	} 	else {n 		rbe = rbp; 		return (TRUE); 	} #elser 	register int n;   	n = fget(&rb, sizeof(rb), fp); 
 	if(feof(fp))  		return(FALSE); 	rbe = (char *)&rb;g
 	rbe += n; 	return(TRUE); #endif }    /*   * Convert 6 radix 50 characters  * to ascii.!  * If -m, map `.' to `_' to agreeo  * with the (new) C format.e  */ 
 convert(a, r). register char *a;e	 r50_t *r;l {  	register int n;   	r50toa(a, r, 2);8 	n = 6;b 	do {; 		if (mflag && *a == '.')e 			*a = '_'; 		if (*a >= 'A' && *a <= 'Z')e 			*a += ('a' - 'A');s 		++a; 	} while(--n); }    /*  * Test if a 6 character symbol   * is a C internal symbol.   * These symbols are all numeric  * except for a leading dot.  */e csym(p)m register char *p;- {l 	register int c, n;w   	if(*p++ != '.') 		return(0); 	n = 5;y 	do {- 		c = *p++;   		if(c!=' ' && (c<'0' || c>'9'))
 			return(0);  	} while(--n); 	return(1);  }u   /*  * Test if a 6 character symbol+  * is an RSX control block
  * symbol.  * These symbols have the form/  * x.xxxx xx.xxx x_xxxx xx_xxx x$xxxx or xx$xxxc  */d bsym(p)  register char *p;" {a- 	if(p[1] == '.' || p[1] == '_' || p[1] == '$'n0 			|| p[2] == '.' || p[2] == '_' || p[2] == '$') 		return(1); 	return(0);c }i   /*  * Lookup a psection.s"  * Make new entry if new psection.  * In any casee return the  * psection number.e  */ 	 lookup(g)  register struct gsde *g; {r 	register struct pst *p; 	register int i;   	for(i=0; i<nps; ++i)u% 		if(match(pst[i].p_name, g->g_name))d
 			return(i);S 	if(nps >= NPS)S  		error("Too many sections!\n"); 	p = &pst[nps];  	p->p_name[0] = g->g_name[0];E 	p->p_name[1] = g->g_name[1];  	p->p_size = g->g_value; 	return(nps++);f }	   /*  * Compare psection names.  * Names are 2 words of (ugh)f  * radix 50.  */r match(a, b)	 register int *a, *b; {  	if(a[0]==b[0] && a[1]==b[1])B 		return(1); 	return(0);7 }    /*  * Run through the symbols,   * computing the first order"  * differencees for the -d option.  * The last symbol requires   * special handling.  * For unknown reasons, the   * last symbol sometimes getsr  * a funny size in spite of*  * this.  */c deltas() {e 	register struct sym *p;   	sort(1, 0);' 	for(p = &sym[0]; p < &sym[nsy-1]; ++p) + 		p->s_value = (p+1)->s_value - p->s_value;r/ 	p->s_value = pst[p->s_ps].p_size - p->s_value;n };   /*  * Sort symbols.  * v is 1 for sort on value.  * r is 1 for reverse sort.o  */a
 sort(v, r) {   	register struct sym *b, *m, *p; 	struct sym ts;y  ) 	for(b = &sym[0]; b < &sym[nsy-1]; ++b) {d 		m = b; 		for(p=b+1; p<&sym[nsy]; ++p) 			if(cmp(v, r, m, p))
 				m = p; 		if(m != b) { 			copy(&ts, m, sizeof(ts)); 			copy(m,   b, sizeof(ts)); 			copy(b, &ts, sizeof(ts)); 		}6 	} }a   /*  * Compare routine for  * sort.  */_ cmp(v, r, a, b)  register struct sym *a, *b;[ {  	register int n; 	int c;t   	c = 0;r 	if(v) { 		if(a->s_value > b->s_value)S	 			c = 1;b 	} elses 		for(n=0; n<6; ++n) {$ 			if(a->s_name[n] > b->s_name[n]) {
 				c = 1;
 				break; 			}" 			if(a->s_name[n] < b->s_name[n])
 				break; 		}n 	if(r)	 		c = !c;; 	return(c);  }r   /*  * Walk through the symbols, N  * formatting them and writing  * the result to the standardh
  * output.  * Undefined symbols get stars  * as a value.  */3 output() {s 	register struct sym *p; 	register r50_t *np; 	register int ntl;	 	int max;a0 	char ab[7];		/* newref() needs the 7'th byte	*/   	max = oflag ? 1 : 3;M	 	ntl = 0; ' 	for(p = &sym[0]; p < &sym[nsy]; ++p) {s 		if(ntl >= max) { 			putchar('\n');x 			ntl = 0;o 		} else if(p != &sym[0])t 			putchar(' '); 		printf("%.6s", p->s_name);3 		printf(" %c ", (p->s_type == G_GSN) ? 'g' : ' ');  		if((p->s_flag & G_DEF) != 0) 			printf("%06o", p->s_value); 		else 			printf("******"); 		np = pst[p->s_ps].p_name;<> 		if((np[0]==AB0 && np[1]==AB1) || (np[0]==AB2 && np[1]==AB3)) 			printf("         ");t 		else { 			convert(ab, np);' 			printf(" (%.6s)", ab);e 		}  		++ntl; 	} 	if(ntl) 		putchar('\n'); }m   char * instr(item, c) register char	*item; register char	c; /*8  * If 'c' is in item, return a pointer to it, else NULL.  */	 {b 	while (*item) { 		if (*item == c)g 			return (item); 	 		item++;' 	} 	return (NULL);	 }b   n /*(  * Stuff for the cross reference listing  */  newref(name, value, mp)l
 char	name[7];k
 int	value; MODULE	*mp;	 {v 	register SYMBOL	*sy;  	extern SYMBOL	*sylookup();y 	register char	*np;o   	/*n+ 	 * First, strip out trailing ' ' from namek 	 */ 	name[6] = EOS;	) 	if ((np = instr(&name[0], ' ')) != NULL); 		*np = EOS; 	sy = sylookup(&name[0]);s 	if (!value) {' 		addref(sy, mp);		/* Undefined here	*/U 	} 	else {				/* Defined here		*/ 		if (sy->s_defn != NULL) {r0 			printf("** symbol %s defined in %s and %s\n",% 				sy->s_name, (sy->s_defn)->m_name,< 				mp->m_name); 			if (!ftty(stdout)) {c 				fprintf(stderr,l+ 					"** symbol %s defined in %s and %s\n",=& 					sy->s_name, (sy->s_defn)->m_name, 					mp->m_name);i 			} 		}n 		else { 			sy->s_defn = mp;a 		}  	} }i   outref() {o 	register SYMBOL		*sy; 	register int		nsymb;  	register REFERENCE	*rp; 	int			i, j;  
 	mnames(); 	/*o% 	 * Pass 1 for "library" symbols onlys 	 */, 	printf("The following are not defined:\n"); 	nsymb = 0;(1 	for (sy = sfirst; sy != NULL; sy = sy->s_next) {  		if (sy->s_defn == NULL) {U 			printf("%c%s",n2 				((nsymb & 7) == 0) ? '\n' : '\t', sy->s_name); 			nsymb++;u 		}) 	} 	printf("\n\n"); 	/*s) 	 * Pass 2 for symbols not used elsewhereh 	 */A 	printf("The following are not used outside of their module:\n");  	nsymb = 0;e1 	for (sy = sfirst; sy != NULL; sy = sy->s_next) { 2 		if (sy->s_defn != NULL && sy->s_refer == NULL) { 			printf("%c%s\t%s",a% 				((nsymb & 3) == 0) ? '\n' : '\t',d' 					sy->s_name, (sy->s_defn)->m_name);a 			nsymb++;  		}t 	} 	/*s 	 * Pass 3 -- all the rest 	 */> 	printf("\n\nThe following are defined and used elsewhere\n");1 	for (sy = sfirst; sy != NULL; sy = sy->s_next) {s2 		if (sy->s_defn == NULL || sy->s_refer == NULL) { 			continue; 		}t 		i = (sy->s_defn)->m_index;8 		printf("\n%s\t%s:", sy->s_name, (sy->s_defn)->m_name); 		nsymb = 0;7 		for (rp = sy->s_refer; rp != NULL; rp = rp->r_next) {p 			printf("%s%s", + 				((++nsymb % 6) == 0) ? "\n\t\t" : "\t",s 				(rp->r_module)->m_name); 			j = (rp->r_module)->m_index;s 			cross[i][j]++;  		}e 	} 	printf("\n"); 	/*e 	 * Now for the map* 	 */ 	printf("\nmodule"); 	for (i = 0; i <= cmax; i++) { 		printf("\n%s\t", mname[i]);) 		for (j = 0; j < i; j++) {n0 			if ((nsymb = cross[i][j] + cross[j][i]) == 0) 				printf("    ");s 			else  				printf("%4d", nsymb);6 		}  		printf("   %s", mname[i]); 	} }	 i /*  * Manage symbol table  */n MODULE * newmodule()n /*)  * Make a new module entry for this file.i  */  {o 	register MODULE		*mp; 	register MODULE		**mplast;  	register MODULE		*new; 	 	int			i;	   	getfilename(fp, workingtext);  	new = myalloc(sizeof (MODULE));$ 	new->m_name = strsave(workingtext);G 	for (mplast = &mfirst; (mp = *mplast) != NULL; mplast = &mp->m_next) {)0 		if ((i = strcmp(workingtext, mp->m_name)) < 0)	 			break;! 		else if (i == 0) {4 			fprintf(stderr, "duplicate module name \"%s\"\n", 				workingtext);{ 			return(mp); 		}( 	} 	new->m_next = mp; 	*mplast = new;o 	cmax++; 	if (cmax >= CROSS_MAX)) 		error("too many modules");
 	return(new);= }y   addref(sy, mp) SYMBOL		*sy; MODULE		*mp; /*%  * The module references this symbol.g  */	 {p 	register REFERENCE	*rp;  	REFERENCE		**rplast; 	register REFERENCE	*new;) 	register int		i;a  # 	new = myalloc(sizeof (REFERENCE));d 	new->r_module = mp; 	for (rplast = &sy->s_refer; 			(rp = *rplast) != NULL; 			rplast = &rp->r_next) {> 		if ((i = strcmp(mp->m_name, (rp->r_module)->m_name)) == 0) {6 			fprintf(stderr, "\"%s\" references \"%s\" twice\n", 				sy->s_name, mp->m_name); 		}e 		else if (i < 0) {d	 			break;r 		}  	} 	new->r_next = rp; 	*rplast = new;s }    SYMBOL * sylookup(text) char		*text; /*/  * Return pointer to this symbol, insert if newg  */s {o 	register SYMBOL		*sy;  	SYMBOL			**sylast; 	register SYMBOL		*new;	 	register int		i;   G 	for (sylast = &sfirst; (sy = *sylast) != NULL; sylast = &sy->s_next) { , 		if ((i = strcmp(text, sy->s_name)) == 0) { 			return(sy); 		}t 		else if (i < 0) {z	 			break;* 		}n 	}  	new = myalloc(sizeof (SYMBOL)); 	new->s_name = strsave(text);s 	new->s_next = sy; 	*sylast = new;t 	return (new); }p   mnames() /*  * Build mname[] vector(  */{ {	 	register int		i;c 	register MODULE		*mp;   	i = 0;n6 	for (mp = mfirst; mp != NULL; mp = mp->m_next, i++) { 		mname[i] = mp->m_name; 		mp->m_index = i; 	} }= e /*  * Support routines   */e getfilename(filedes, buffer) FILE	*filedes;
 char	*buffer;  {t 	register char *tp;  	register char c;6   	fgetname(filedes, buffer);i 	/** 	 * Skip over device nameg 	 */7 	for (tp = buffer; (c = *tp) != EOS && c != ':'; tp++);t
 	if (c)	tp++;5 	else	tp = buffer; 	/*n 	 * Skip over [UIC] or 	 * or [PPN] if presentf 	 */  	if (*tp == '[' || *tp == '(') { 		while ((c = *tp++) 				&& c != ']'( 				&& c != ')');; 		if (c == 0) {  			error("Can't happen");a 			tp--; 		}  	} 	strcpy(buffer, tp); 	/*T 	 * Don't include versionc 	 */0 	for (tp = buffer; (c = *tp) && c != ';'; tp++);	 	*tp = 0;  	/*r 	 * Don't include .ext 	 */0 	for (tp = buffer; (c = *tp) && c != '.'; tp++);	 	*tp = 0;c 	/* " 	 * Now, buffer has the file name, 	 * tp - buffer, its length. 	 */ 	return(buffer); }c   char *
 strsave(text)n char		*text; /*  * Save this texte  */m {s 	register char	*p;  , 	if ((p = malloc(strlen(text) + 1)) == NULL)% 		error("No room for string alloc.");i 	strcpy(p, text);1 	return (p); }=   char *
 myalloc(size) 
 int		size; /*  * Allocate or die  */1 {  	register char	*p;  % 	if ((p = calloc(1, size)) == NULL) {n5 		fprintf(stderr, "Can't allocate %d bytes\n", size);e 		error("Fatal");  	} 	return (p); }r  