 /*  *		scat file...  *?  * Copy files to stdout.  Note: the program first looks for all >  * files, sorting the file names in ascending alphabetic order+  * The files are then output in that order.   *4  * In sorting the files, the information is ordered:  *  *	file_name	disk[directory]  *  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...CAT 		}G */   #ifdef	DOCUMENTATION   title	scat	Concatenate Files index		Concatenate Files   synopsis   	scat file_list
   description   D 	Scat performs a wild-card lookup on all files in the argument list.= 	It sorts these on ascending file name, copying them, in that  	order, to stdout.  A 	Scat removes trailing blanks, tabs, and other control characters	 	from the end of each line.p   diagnosticsp   	.lm +8  	.s.i -8;Unknown switch - ...  	.s.i -8;Illegal file name ... 	.s.i -8;Can't reopen file ... 	.s.i -8;Bad file name ...  	.s.i -8;Duplicate file name ... 	.s.i -8;Too many files ...  	.s8 	After wild-card expansion, the file name buffer filled. 	.s.i -8;No room 	.s 9 	The program ran out of memory for the file name strings.  	.lm -8    author  
 	Martin Minow    bugs  / 	All files must be on the current network node.    #endif   #include <stdio.h>
 #ifdef vms #include		<ssdef.h>  #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)c #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */  #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif #define	FALSE		0 #define	TRUE		1; #define	EOS		0- #define	MAX_NAMES	500		/* Max. file names		*/  static int	debug;p0 static char	filename[81];		/* Just file name		*/6 static char	fullname[81];		/* dev:[...] + filename		*// static char	dirname[81];		/* Just dev:[...]		*/i7 static char	work[81];		/* Work buffer for file names	*/g9 static char	record[512];		/* Work buffer for file copy	*/e5 static char	*wild_spec;		/* Current wild card spec	*/,9 static char	*text[MAX_NAMES];	/* store file names here	*/p6 static char	**ttop = text;		/* Top of text pointer		*/ static FILE	*infd; static int	isarg = FALSE;d   main(argc, argv)
 int		argc; char		*argv[]; {"   	register int		c;p 	register int		i;	 	register char		*ap;  
 #ifdef vms" 	argc = getredirection(argc,argv); #endif   	for (i = 1; i < argc; i++) {} 		if (*(ap = argv[i]) == '-') {}& 			while ((c = tolower(*++ap)) != 0) { 				switch (c) {
 				case 'd':e
 					debug++;s 					break;r   				default:$ 					bug("W", "Unknown switch", ap); 					break;- 				}s 			} 		}r 		else { 			wild_spec = argv[i];	 			ttop = text;d 			isarg = TRUE; 			getnames(); 		}  	}
 	if (isarg) {  		copyall(); 	} 	else {n 		copyfile(stdin); 	} }'  
 getnames() /*  * Find all files for wild_speca  */  { ) 	register int		count;		/* Count files		*/ ) 	register char		*wp;		/* -> wild_spec		*/h) 	register char		*dp;		/* -> dirname[]		*/    	wp = wild_spec; 	dp = dirname; 	do {i 		*dp++ = (count = *wp++);$ 	} while (count != 0 && count != ':'$ 			&& count != '[' && count != '('); 	if (count == 0) { 		dp = dirname;" 	}) 	else if (count == '[' || count == '(') {r 		do { 			*dp++ = (count = *wp++);n7 		} while (count != 0 && count != ']' && count != ')');r 	}	 	*dp = 0;a 	if (debug)%; 		fprintf(stderr, "wild spec = \"%s\", dirname = \"%s\"\n",i 				wild_spec, dirname);. 	if ((infd = fwild(wild_spec, "r")) == NULL) {$ 		bug("W", "Can't open", wild_spec); 		return(0); 	}0 	for (count = 0; fnext(infd) != NULL; count++) { 		setname(infd);	 		save();s 		if (debug)6 			fprintf(stderr, "Saved file = \"%s\"\n", fullname); 	} 	if (debug) 3 		fprintf(stderr, "%d files processed\n\n", count);h 	if (count == 0)* 		bug("W", "No files matched", wild_spec); 	return(count);d }c  	 copyall()	 /*  * Copy all filesp  */= {p' 	char			**textp;	/* Pointer to names	*/ - 	register char		*tp;		/* Pointer to a name	*/), 	register char		*np;		/* Filename pointer	*/* 	register int		c;		/* Current character	*/ 	extern char		*cpystr();  , 	for (textp = text; textp < ttop; textp++) { 		/* 		 * Get directory partL 		 */b4 		for (tp = *textp; (c = *tp++) != 0 && c != '\t';);
 		if (c == 0)(1 			error("Illegal file name \"%s\"\n", filename);	 		np = cpystr(fullname, tp); 		/* 		 * Copy in name part 		 */ 3 		for (tp = *textp; (c = *tp++) != 0 && c != '\t';) 
 			*np++ = c;g
 		*np = 0;, 		if ((infd = fopen(fullname, "r")) == NULL)  			bug("W", "Can't reopen", np); 		else { 			copyfile(infd); 			fclose(infd); 		}  	} }s   copyfile(fd) register FILE	*fd; /*  * Copy loop  */* {* 	register char		*rp;   	/*r8 	 * Note -- scat cleans up the end of the logical record 	 */3 	while (fgets(record, sizeof record, fd) != NULL) {,# 		rp = &record[strlen(record) - 1]; $ 		while (rp >= record && *rp <= ' ') 			rp--; 		rp[1] = EOS; 		fputss(record, stdout);r 	} }    setname(fd)= FILE 		*fd;= /*  * Build file name  */) {  	register char		*wp; 	register char		*np; 	register int		c;    	fgetname(fd, work); 	/* ! 	 * Skip over device name, if any  	 */+ 	for (wp = work; (c = *wp++) && c != ':';);t 	if (c == 0) 		wp = work; 	/*"' 	 * Skip over [UIC] or [PPN] if present  	 */  	if (*wp == '[' || *wp == '(') {- 		while ((c = *wp++) && c != ']' && c != ')')s
 		if (c == 0)<) 			error("Bad file name \"%s\"\n", work);l 	} 	/* 5 	 * Wp now points to the first byte of the file name.  	 */ 	if (debug)a7 		fprintf(stderr, "Setname, file name = \"%s\"\n", wp);o 	strcpy(fullname, wp); 	/*s7 	 * Don't include version in sort argument, then appendn 	 * directory name.  Result is: ! 	 *	foo.bar<TAB>db0:[10,20]<NULL>m 	 */2 	for (wp = fullname; (c = *wp) && c != ';'; wp++); 	*wp++ = '\t'; 	strcpy(wp, dirname);  }r   save() /*;  * Save fullname, add it to the text area (in sorted order)=  */; {i 	register char	**textp;M 	register char	**insert; 	register int	i;  , 	for (textp = text; textp < ttop; textp++) {, 		if ((i = strcmp(*textp, fullname)) == 0) {2 			fprintf("?SCAT-E-Duplicate file name \"%s\"\n", 				fullname);
 			return; 		}\ 		else if (i > 0);	 			break;i 	} 	insert = textp; 	textp = ttop;  	if (++ttop >= &text[MAX_NAMES])= 		error("?SCAT-F-Too many file names, %d max.\n", MAX_NAMES);t   	while (textp >= insert) { 		textp[1] = *textp;
 		textp--; 	}6 	if ((*insert = malloc(strlen(fullname) + 1)) == NULL)2 		error("?SCAT-F-No room for \"%s\"\n", fullname); 	strcpy(*insert, fullname);* }e 	y     usage(s) char	*s; {C 	bug("E", s, NULL);  	exit(IO_ERROR); }s   bug(severity, mess, arg) char		*severity; char		*mess; char		*arg;r /*  * Error messages   */e {o0 	fprintf(stderr, "?SCAT-%s-%s", severity, mess); 	if (arg != NULL) # 		fprintf(stderr, ": \"%s\"", arg);0 	fprintf(stderr, "\n");2 	if (*severity != 'W')" 		error("?SCAT-F-Can't continue"); }2   char * cpystr(s1, s2) register char *s1, *s2;c /*2  * Copy string s2 to s1.  s1 must be large enough..  * return a pointer to the trailing null in s2  */0   {2 	while ((*s1 = *s2++) != '\0')
 	    s1++; 	return(s1); }h