 # /*
  *				T 7 . C)  *	  *	char *e  *	rxgrep(string, pattern)+  *	char		*string;	-- Where to search for ite(  *	char		*pattern;	-- What to search for  *E  * Apply the regular expression (pattern[]) to the argument string[].mH  * Return 0 if it fails.  If successful, return a pointer to the string.>  * that matched.  Regular expressions are defined in rxcomp().  *9  * Globals unique to this routine are preceeded by "re_".o  */s   #include	<stdio.h>
 #ifdef	vms #include	<ctype.h> #define	FALSE	0n #define	TRUE	1 #endif #include	"t.h"   /*/  * The following must be identical in rxcomp().*  */T   #define CHAR	1
 #define BOL	2.
 #define EOL	3a
 #define	ANY	4  #define CLASS	5e #define	NCLASS	6 #define STAR	7 #define	PLUS	8 #define	MINUS	9f #define	ALPHA	10 #define	DIGIT	11 #define	NALPHA	12i #define	PUNCT	132 #define	CDIGIT	14		/* Not used in this version		*/ #define RANGE	15 #define	ENDPAT	16   3 static char	*re_string;		/* Remember start loc.		*/l   char * rxgrep(string, pattern)m, char		*string;		/* The string to look for	*/, char		*pattern;		/* Where to look for it		*/ /*,  * Match the string, return TRUE if it does.  */e { ( 	register char	*l;		/* Line pointer			*/ 	char *re_pmatch();k   	re_string = string; 	for (l = string; *l; l++) {$ 		if (re_pmatch(l, string, pattern))
 			return(l);  	} 	return(NULL); }l  
 static char *i re_pmatch(line, start, pattern)u, char		*line;		/* (partial) line to match		*/+ char		*start;		/* Invariant line start			*/n1 char		*pattern;	/* (partial) pattern to match		*/  /*E  * Do the actual work of matching (recursively).  Line is the current	H  * piece of information to match.  Start is the entire line -- as passed2  * to t_rxgrep().  This is needed for the :c scan.  */* { / 	register char	*l;		/* Current line pointer		*/g1 	register char	*p;		/* Current pattern pointer	*/x+ 	register char	c;		/* Current character		*/o- 	char		*e;		/* End for STAR and PLUS match	*/p# 	int		op;		/* Pattern operation		*/y 	int		n;		/* Class counter		*/( 	char		*are;		/* Start of STAR match		*/3 	char		*commapos;	/* Comma position for :c match	*/i  
 	l = line;
 	p = pattern;  	commapos = 0; <  	while ((op = *p++) != ENDPAT) { 		switch(op) {   		case CHAR: 			if (tolower(*l++) != *p++)" 				return(0);	 			break;h   		case BOL:r 			if (l != re_string) 				return(0);	 			break;c   		case EOL:a 			if (*l != '\0') 				return(0);	 			break;O   		case ANY:O 			if (*l++ == '\0') 				return(0);	 			break;C  
 		case DIGIT:T% 			if ((c = *l++) < '0' || (c > '9'))  				return(0);	 			break;I  
 		case ALPHA:A 			c = tolower(*l++);	 			if (c < 'a' || c > 'z') 				return(0);	 			break;	   		case NALPHA: 			c = tolower(*l++);_ 			if (c >= 'a' && c <= 'z')
 				break; 			else if (c < '0' || c > '9')e 				return(0);	 			break;t  
 		case PUNCT:t 			c = *l++; 			if (c == 0 || c > ' ')C 				return(0);	 			break;   
 		case CLASS:r 		case NCLASS: 			c = tolower(*l++);g 			n = *p++ & 0377;a 			do {n 				if (*p == RANGE) { 					p += 3; 					n -= 2;" 					if (c >= p[-2] && c <= p[-1]) 						break; 				}i 				else if (c == *p++)a 					break;( 			} while (--n > 1);t! 			if ((op == CLASS) == (n <= 1))r 				return(0); 			if (op == CLASS)* 				p += n - 2; 	 			break;r  
 		case MINUS:* 			e = re_pmatch(l, start, p);2 			while (*p++ != ENDPAT);	/* Skip over pattern	*/ 			if (e)			/* Got a match?		*/|$ 				l = e;		/* Yes, update string	*/! 			break;			/* Always succeeds	*/l  $ 		case PLUS:			/* One or more ...	*/) 			if ((l = re_pmatch(l, start, p)) == 0)a' 				return(0);	/* Gotta have a match	*/ % 		case STAR:			/* Zero or more ...	*/i& 			are = l;		/* Remember line start	*/- 			while (*l && (e = re_pmatch(l, start, p)))=# 				l = e;		/* Get longest match	*/p2 			while (*p++ != ENDPAT);	/* Skip over pattern	*/- 			while (l >= are) {	/* Try to match rest	*/	# 				if (e = re_pmatch(l, start, p))  					return(e);	! 				--l;		/* Nope, try earlier	*/a 			}( 			return(0);		/* Nothing else worked	*/  
 		default:" 			abort();		/* Illegal op code	*/ 		}  	} 	return(l);c }s