 /*
  * 			t r . c   *$  * Character transliterator program.  *K  * tr is based on the RATFOR version distributed by Berkeley as part of the K  * Virtual Operating System toolkit.  That tr is, in turn, derived from the H  * program translit described in Kernighan and Plauger's Software Tools,K  * which derives from tr in C on UNIX.  Thus, this version is a translation ,  * back to C of C code translated to RATFOR!  *
 )EDITLEVEL=08   */    /*)BUILD 	$(TKBOPTIONS) = { 		TASK	=	...TRX  	} */   #ifdef	DOCUMENTATION  ) title	tr	Character Transliterator Program ' index		Character transliterator program    Synopsis   	tr from-chars to-chars    Description   F 	tr copies the standard input to the standard output with substitution< 	or deletion of selected characters.  It is used as follows:   	.lm +8  	tr FROM TO  	.lm -8   A 	where FROM and TO are strings of characters.  The effect of this 3 	command depends on the lengths of the two strings.   F 	If FROM and TO have the same length, characters in TO are substituted 	for characters in FROM.  Thus,    	.lm +8  	tr "abcd" "wxyz"  	.lm -8   E 	changes all a's to w's, b's to x's, and so on.  Note that the quotes F 	are needed to ensure that tr receives lower-case characters.  tr DOESE 	distinguish letters by case; the above command has no effect on A's,  	B's, C's, or D's.  A 	If TO is left out or explicitly null, any characters in FROM are 	 	deleted.   G 	If TO is non-null but shorter than FROM, all characters in FROM beyond @ 	the last one to match up with one in TO translate into the last= 	character in TO; BUT any stream of consecutive characters soB= 	translated is reduced to just one occurence of the resultingf 	character.  Thus,   	.lm +8e 	tr "abcde12345" "ABCDE-"o 	.lm -8n  9 	changes "aAbB1234cCdD5678eEfF" into "AABB-CCDD-678EEfF".   < 	If a character appears more than once in FROM, the leftmostA 	equivalence prevails.  Thus, to change all strings of *'s into a  	single *, use tr "**" "*".  ; 	In addition to simple characters, FROM and TO may include:  	.lm +8     Escapes 	.br: 	\x is x except that \b is a backspace, \f is a form feed,7 	\n is a newline, \r is a return, \t is a tab, and \ddd < 	is the character whose OCTAL value is ddd.  (Only 8 bits of; 	ddd are retained, and it is ok for there to be only one orrC 	two valid octal digits present.  Using \0 will cause unpredictableM= 	results.).  The letters b, f and so on must be lower case tot 	be recognized.2    Ranges  	.brF 	a-e is the same as abcde, etc.  Note that the range e-a, while legal,
 	is empty.    Classes 	.br6 	A number of built-in character classes are available:   		:a 	is the same as a-zA-Z  		:d 	is the same as 0-9 		:n 	is the same as a-zA-Z0-9$ 		:	(:<SPACE>)  is  the  range  from# 			CTRL/A to <SPACE>  in increasingn 			numerical order% 		:.	is the range including all ASCIIl" 			characters other than NUL (\0). 			Thus,   				tr ":a:." "A-ZA-Z "l  # 			translates all letters to upper-c# 			case and  reduces all streams of ! 			non-letters to a single space.I  0 	Class characters a, d and n must be lower case.  	  Negation  	.br6 	If the first character of FROM is "^", any characters< 	not in FROM match.  In this case, TO must be null or only a 	single character.   	.lm -81B 	"\" and ":" lose their special meaning if they appear as the lastF 	character of FROM or TO; "-" loses it if it is the first or last; "^"F 	loses it if it is not the first character of FROM; and all characters; 	lose their special meaning if preceded by an escape ("\").t   	.tp 4 I/O Peculiarities   F 	The C I/O system terminates records read with a single newline; henceD 	the \r character will never be found for replacement.  Also, in RSXG 	modes, output files must be broken into records; removing newlines cana6 	produce huge records that cannot be processed by RMS.   Diagnostics. 	.lm +8O    ?TR-F-Not enough memory  %  ?TR-F-Unknown class type <character>  	.brA 	<character> appeared after a ":", but is not a known class type.l   	.lm -8C   Bugs   Author  ? 	Jerry Leichter, based on the RATFOR version in Software Tools.y   #endif   /*  * Edit historymI  * 0.0	23-Apr-81 JSL	Original implementation, based on the RATFOR version   *			in Software Tools.E?  * 1.0	 1-May-81 JSL	Conversion to use the new Utility Library.nB  * 1.1	 4-May-81 JSL	Cleanups; use 'u' mode to leave <CR>'s alone.H  * 1.2	20-May-81 JSL	'u' mode was a bad idea; now a compile-time option.G  * 1.3	 4-Jun-81 JSL	Bad bug - negation caused an infinite loop on EOF!E  *			(Too much optimization.)V<  * 1.4	29-Jun-81 JSL	Track change of "blocks" to "vstrings".H  * 2.0	30-Jan-83 JSL	Converted to new standard tool format.  index() ==>3  *			inchr(), which is now in the standard library.LI  * 2.0d	31-Jan-83 JSL	Included text for need CU functions.  This avoids an;  *			bug in BUILD with $(LIBS) and, more important, is con-c9  *			sistent with the current system build command files,N8  *			which build the tools before they build the Utility6  *			Library.  This should eventually be changed back.B  * 2.1  22-Jun-83 MM	Replaced inchr() by strchr() for portability.&  *			Added redirection for vax native.K  * 2.2	15-Feb-85 JSL	Use getredirection() rather than doing re-direction in    *			an ad hoc (and wrong!) way.  */E   char	*documentation[] = {eK "tr copies the standard input to the standard output with substitution or","; "deletion of selected characters.  It is used as follows:",E "",a "	tr FROM TO <input >output",i "",yK "where FROM and TO are strings of characters.  The effect of this command", - "depends on the lengths of the two strings.",  "",rL "If FROM and TO have the same length, characters in TO are substituted for", "characters in FROM.  Thus,",y "",  "	tr \"abcd\" \"wxyz\"", "",iK "changes all a's to w's, b's to x's, and so on.  Note that the quotes are",uP "needed to ensure that tr receives lower-case characters.  tr DOES distinguish",M "letters by case; the above command has no effect on A's, B's, C's, or D's.",U "",VL "If TO is left out or explicitly null, any characters in FROM are deleted.",M "If TO is non-null but shorter than FROM, all characters in FROM beyond the",aO "last one to match up with one in TO translate into the last character in TO;",rP "BUT any stream of consecutive characters so translated is reduced to just one",/ "occurence of the resulting character.  Thus,",  "",   "	tr \"abcde12345\" \"ABCDE-\"", "", ? "changes \"aAbB1234cCdD5678eEfF\" into \"AABB-CCDD-678EEfF\".",  "", J "If a character appears more than once in FROM, the leftmost equivalence",N "prevails.  Thus, to change all strings of *'s into a single *, use tr ** *.", "",H= "In addition to simple characters, FROM and TO may include:",O "", J "	Escapes   \\x is x except that \\b is a backspace, \\f is a form feed,",A "		  \\n is a newline, \\r is a return, \\t is a tab, and \\ddd",PB "		  is the character whose OCTAL value is ddd.  (Only 8 bits of",A "		  ddd are retained, and it is ok for there to be only one or", C "		  two valid octal digits present.  Using \\0 will cause random", C "		  results.).  The letters b, f and so on must be lower case to",  "		  be recognized.", E "	Ranges    a-e is the same as abcde, etc.  Note that e-a is empty.", C "	Classes   A number of built-in character classes are available:",  "			:a  is the same as a-zA-Z",  "			:d  is the same as 0-9"," "			:n  is the same as a-zA-Z0-9",8 "			:   (:<SPACE>) is the range from CTRL/A to <SPACE>",) "			      in increasing numerical order", ; "			:.  is the range including all ASCII characters other",  "			      than NUL.  Thus,", "",  "				tr \":a:.\" \"A-ZA-Z \"", "", ; "			      translates all letters to uppercase and reduces", 9 "			      all streams of non-letters to a single space.", 6 "		  Class characters a, d and n must be lower case.",E "	Negation  If the first character of FROM is \"^\", any characters", B "		  not in FROM match.  In this case, TO must be null or only a", "		  single character.", "", I "\"\\\" and \":\" lose their special meaning if they appear as the last", J "character; \"-\" loses it if it is the first or last; \"^\" loses it if",P "it is not the first of FROM; and all characters lose their special meaning if"," "preceded by an escape (\"\\\").", "", O "Note:  The C I/O system terminates records read with a single newline; hence", N "the \\r character will never be found for replacement.  Also, in RSX modes,",O "output files must be broken into records; removing newlines can produce huge", + "records that cannot be processed by RMS.",  0 };   #include <stdio.h>
 #ifdef vms #include		<ssdef.h>  #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)  #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */  #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   /* #include <vstrin.h> */  /*  *			v s t r i n g . h  */    #ifdef	DOCUMENTATION  ' title	vstring		Header file for vstrings + index		Header file for using using vstrings    synopsis   	 #ifdef vms 	 #include "c:vstrin.h"  	 #else  	 #include <vstrin.h>  	 #endif   description   D 	This header file is used to allow programs to access vstrings.  See" 	vstring.c for additional details.  > 	This file defines the structure of a vstring. The fields are: 	.lm+8  
  char *vsdata   F 	Pointer to the actual data.  This will always be the first field, so C 	that a vstring can be considered to be of type char ** if you only G 	want to read it.  vsdata will be NULL if the vstring has been damaged.  	   unsigned vslen   ) 	Number of bytes stored in the vstring.  *    unsigned vsdime  ) 	Total number of bytes there is room for.F    unsigned vsextt  G 	Allocation quantum - the amount the vstring is to grow by if it fills.t& 	If vsext==0, the vstring cannot grow.   	.lm-8G 	The only fields generally directly accessed by programs are vsdata andsG 	vslen. Note that vsdata may change over time as items are added to andC 	removed from the vstring.  B 	The only field you should normally change is vsext, the extensionE 	quantum.  The value current the next time the vstring must grow willi  	determine how much it grows by.  F 	vstring.h also includes external declarations of the appropriate type  	for the functions in vstring.c.   bugs  D 	A vstring is really just a special case of a flex with item size 1.@ 	It has been retained as a separate datatype because the type ofG 	operations done on strings are not always generalizable.  For example,m) 	there is no obvious use for an fxadds().n   author 	Jerry Leichtere   #endif   /*
 )EDITLEVEL=16   *  * Edit historyf  * 0.0 30-Apr-81 JSL	Invention*  * 0.1  4-May-81 JSL	Better error handlingF  * 0.2 12-May-81 JSL	Decided to keep blocks after all; balloc() is now
  *			block().e#  * 0.3 13-May-81 JSL	Added _BLOCKS_r@  * 0.4 18-May-81 JSL	Fix up documentation so GETRNO can find it.J  * 1.0 26-Jun-81 JSL	Changed name to vstring, which makes much more sense.C  * 1.1 29-Jun-81 JSL	More name changes, get consistent with flexes.l.  * 1.2 14-Jul-82 JSL	Fixed some ancient typos.  */   , #ifndef _VSTRING_		/* Don't do this twice */ #define _VSTRING_    typedef struct vheader 	{ char *vsdata; 	  unsigned vslen; 	  unsigned vsdim; 	  unsigned vsext; 	} VSTRING;   0 extern VSTRING *vstring(), *vsaddc(), *vsadds();   #endif   #  #define EOS	'\0'* #define ESCAPE	'\\'	/* escape character *// #define NOT	'^'	/* match complement of class */ * #define PCLASS	':'	/* pre-defined class */' #define RANGE	'-'	/* range specifier */   7 extern char esc();	/* Utility library escape handler */   ? extern VSTRING *makttb();	/* get makttb to be the right type */    static char filename[80]; 9 			/* space for a filename for reopening stdin, stdout */  main(argc, argv)' int	argc;		/* Number of arguments				*/ & char	*argv[];	/* Argument vector				*/ {  	register char	c;  	register int	i; 	register char	*arg; 	char		*froms; 	char		*tos; 	VSTRING		*from, *to;  	int		allbut, collapse, lastto;   
 #ifdef	vms" 	argc = getredirection(argc,argv); #endif 	froms = tos = NULL; 	for (i = 1; i < argc; i++) {  	    if (froms == NULL)  		froms = argv[i]; 	    else if (tos == NULL) 		tos = argv[i]; 	    else { # 		usage("More than two arguments");  	    } 	} 	if (froms == NULL) {  	    usage("No arguments");  	}. 	if (tos == NULL && strcmp(froms, "?") == 0) { 	    help(); 	    return; 	} 	if (*froms == NOT)  	{	allbut = TRUE; 
 		froms++; 	} 	else  		allbut = FALSE; 1 	from = makttb(froms, vstring(strlen(froms), 4));  	to = vstring(16,2); 	if (tos == NULL)  		to = vsaddc(to, EOS);  	else 	to = makttb(tos, to);  	if (from == NULL || to == NULL)% 		error("?TR-F-Not enough memory\n");  	tos = to->vsdata; 	froms = from->vsdata; 	lastto = strlen(tos) - 1;0 	if (strlen(froms)-1 > lastto || allbut == TRUE) 		collapse = TRUE; 	else	collapse = FALSE;    #ifdef DEBUGF 	printf("collapse %d, allbut %d, lastto %d\n",collapse,allbut,lastto); 	printf("to array: %s\n",tos);" 	printf("from array: %s\n",froms); #endif   #ifdef USE_U_MODE  #ifdef rt11  	/* 			R T - 1 1  A 	   Re-open our input and output files in non-stream mode so that 0 	   things like carriage returns get left alone.   	 */   	fgetname(stdin, filename); * 	if (freopen(filename,"rn",stdin) == NULL)0 		error("?TR-F-Can't reopen \"%s\"\n",filename); 	fgetname(stdout, filename);+ 	if (freopen(filename,"wn",stdout) == NULL) 0 		error("?TR-F-Can't reopen \"%s\"\n",filename); #endif #endif   	while ((c=getchar()) != EOF) % 	{	i = xindex(froms,c,allbut,lastto); 8 		if (collapse && i>=lastto && lastto>=0)	/* collapse */ 		{	putchar(tos[lastto]);  			do { * 				i = xindex(froms,c = getchar(),allbut,
 					lastto); % 			} while (c != EOF && i >= lastto);  		} * 		if (i>=0 && lastto>=0)			/* translate */ 			putchar(tos[i]);  		else if (i < 0)				/* copy */  			putchar(c); 						/* else    delete */ 	} }   	 VSTRING *  makttb(array,ttb) 
 char array[]; 
 VSTRING *ttb; N /* makttb - make a ttb (translation table) from the expansion of array in ttb;  * return ttb or NULL on error.   */  {  	filttb(EOS,array,ttb);  	return(vsaddc(ttb,EOS));  }    xindex(array,c,allbut,lastto)  char array[],c;  int allbut,lastto; /*<  * Return -1 if the character isn't in array, else the index5  * invert condition returned by strchr() if necessary   */  {  	extern char	*strchr();  	register char	*index;  = 	index = strchr(array, c);	/* index -> character (or NULL)	*/  	if (allbut == FALSE) { 1 		return((index == NULL) ? -1 : (index - array));  	} 	else if (index != NULL)
 		return(-1);  	else	return(lastto+1);  }		    /*	Utility routines */   filttb(delim,array,ttb)  char delim,array[]; 
 VSTRING *ttb; I /* filttb - expand the characters in array into ttb, stopping at delim */  { 7 	char *a;		/* NOT register - Lvalue needed for esc() */   / 	for (a = array; *a != delim && *a != EOS; a++)  	{ 		if (*a == ESCAPE)  			vsaddc(ttb,esc(&a)); ) 		else if (*a == PCLASS && *(a+1) != EOS)  			switch(*++a)  			{ 			case 'a': 			case 'n': 				insrange('a','z',ttb); 				insrange('A','Z',ttb); 				if (*a == 'a') 					break;  			case 'd': 				insrange('0','9',ttb);
 				break; 			case ' ': 				insrange('\001',' ',ttb); 
 				break; 			case '.':  				insrange('\001','\177',ttb);
 				break; 			default: 2 				error("?TR-F-Unknown class type \"%c\"\n",*a); 			}: 		else if (*a == RANGE && ttb->vslen > 0 && *(a+1) != EOS) 				dorange(&a,ttb); 		else	vsaddc(ttb,*a); 	} 	return; }    dorange(ps,ttb) 
 char **ps;
 VSTRING *ttb; D /* dorange - expand the range from the last character in ttb throughB    the next character in *ps (which may be "escaped") into ttb. */ { & 	(*ps)++;				/* skip the RANGE char */1 	insrange(ttb->vsdata[--ttb->vslen],esc(ps),ttb);  	return; }    insrange(lo,hi,ttb) 
 VSTRING *ttb; 
 int lo,hi;G /* insrange - insert the characters from lo to hi inclusive into ttb */  {  	register int c,hif; 	lo = lo & 0377; 	hif = hi & 0377;  	for (c = lo; c <= hif; c++) 		vsaddc(ttb,c); 	return; }    help() /*  * Give good help   */  {  	register char	**dp;  $ 	for (dp = documentation; *dp; dp++) 		printf("%s\n", *dp); }    usage(s) char	*s; { " 	fprintf(stderr, "?TR-E-%s\n", s); 	fprintf(stderr,* 		"Usage: tr from to.  tr ? for help.\n"); 	exit(IO_ERROR); }    /*H  * The following are exact copies of text from the Utility Library.  SeeI  * the revision history (for version 2.0d) for an explanation of why it's   * here.  */    /*  *				e s c . c   */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  $ title	esc	Process Escaped Characters! index		Process escaped characters    synopsis   	 char esc(ppc) 
 	 char **ppc;    	 int esc_msk;   description   G 	esc(ppc) recognizes and processes the escaped characters recognized by G 	the C compiler.  If *ppc points to any character other than '\', esc() > 	just returns that character.  Otherwise, it examines the next= 	character.  If it finds a member of the set {b,f,n,r,t}, the G 	appropriate character is returned, e.g., a <TAB> for '\t'. Also, \ddd, E 	ddd being up to three octal digits, returns the character with value E 	ddd.  Only the bottom 8 bits are retained, so the result is always a @ 	"proper" character.  This can be changed by changing the globalE 	esc_msk to contain whatever mask you prefer.  (The default is 0377.)   D 	The special characters b, f, and so on are recognized in lower case 	only.  ; 	If '\' is the last character in s, '\' itself is returned.   C 	If '\' is followed by any other character x, x itself is returned.   E 	In all cases, *ppc is left pointing at the last character that esc() C 	has "eaten", e.g., at the 't' if it is returning a <TAB> for '\t'.    bugs   author   	Jerry Leichtert   #endif   /*  * )EDITLEVEL=17  * Edit historyh  * 0.0  1-May-81 JSL	Invention9  * 0.1 28-May-81 JSL	Conversion to new comment conventionT'  * 0.2 23-Jun-81 JSL	escmsk ==> esc_msk-$  * 0.3 29-Dec-81 MM	Redone for vax cE  * 0.4 13-Jul-82 JSL	Change esc_msk default to 0377 to support XASCIIa  */e   #define ESCAPE '\\'  #define EOS '\0'   int esc_msk = 0377;l   char esc(ppc) char **ppc;l {, 	register char c,c1; 	register char	*pc;e   	pc = *ppc;O+ 	if ((c = pc[0]) != ESCAPE || pc[1] == EOS)  		return(c); 	elsee 		c = *++pc; 		*ppc = pc; 		switch(c)e 	{
 	case 'b': 		return('\b'); 
 	case 'f': 		return('\f');g
 	case 'n': 		return('\n');x
 	case 'r': 		return('\r');.
 	case 't': 		return('\t');g
 	case '0':
 	case '1':
 	case '2':
 	case '3':
 	case '4':
 	case '5':
 	case '6':
 	case '7': 		c -= '0';s( 		if ((c1 = pc[1]) >= '0' && c1 <= '7' ) 		{	c = (c << 3) | (c1 - '0'); 			pc++;) 			if ((c1 = pc[1]) >= '0' && c1 <= '7' )  			{	c = (c << 3) | (c1 - '0');t	 				pc++;m 			} 		}l 		*ppc = pc; 		return(c & esc_msk);	 	default:h 		return(c); 	} }a   /*  *				v s t r i n g . ct  */e  
 /*)LIBRARY */   #ifdef	DOCUMENTATION  . title	vstring	Functions to Manipulate Vstrings index		Create a new vstringa# index		Add a character to a vstringe  index		Add a string to a vstring index		Free a vstring    synopsis   	 #ifdef vms 	 #include "c:vstrin.h"v 	 #elsef 	 #include <vstrin.h>h 	 #endif   	 VSTRING *e 	 vstring(dim,ext) 	 unsigned dim;i 	 unsigned ext;0   	 VSTRING *I 	 vsaddc(pv,c) 	 VSTRING *pv;	 	 char c;    	 VSTRING *2 	 vsadds(pv,s) 	 VSTRING *pv;
 	 char *s;   	 vsfree(pv) 	 VSTRING *pv;   description-  F 	Vstrings are dynamically expandable strings.  They have room for someC 	fixed number of characters, but can grow, obtaining memory throughc 	malloc(), if necessary.  F 	vstring(dim,ext) returns a pointer to a new vstring, or NULL if thereD 	is no space for one.  The vstring initially has room for dim bytes,( 	and will grow by ext bytes if it fills.  ( 	vsaddc() adds a character to a vstring.  D 	vsadds() adds a string to a vstring.  It merely calls vsaddc() in a& 	loop. The trailing EOS is NOT added.	  E 	Both vsaddc() and vsadds() return NULL if the vstring would have had	E 	to grow but couldn't due to lack of memory or a zero growth quantum. E 	In this case, the data in the vstring is lost and the vstring itselfeD 	is marked damaged and cannot be used again; further attempts always
 	return NULL.V  ? 	If all went well, the vstring's address as passed is returned.c  F 	It is occassionally necessary to recover the information in a damagedD 	vstring (in most cases, there is no reasonable way to continue onceD 	the program runs out of memory).  This can be done by making use ofC 	realloc()'s ability to reallocate the most recently freed block of	E 	core.  Before making the potentially damaging call, save the currenteE 	values of the vsdata and vsused elements of the vstring.  Should the<D 	vstring become damaged, the vsdata value can be passed to realloc()A 	safely.  Note that this recovers the data, but not the vstring'shE 	header; you still cannot apply any of the vstring-handling functionso 	to it.s  E 	vsfree() frees a vstring.  Attempting to free something that was not G 	created with vstring() will cause trouble.  However, NULL or a vstring 9 	that was filled and marked damaged may be safely passed.t   bugs  D 	A vstring is a special case of a flex which always has an item sizeD 	of 1 byte.  It is convenient to maintain it as a separate data typeF 	because the kinds of operations done on the two differ.  For example,A 	fxadd() takes the address of the item to add; vsaddc() takes thesD 	character itself, which is often more convenient.  The basic set ofE 	functions provided for vstrings is more limited; perhaps more purelyaG 	string-oriented functions that work on vstrings will be defined later."   author   	Jerry LeichterE   #endif   /*  *)EDITLEVEL=10T  * Edit historyo  * 0.0 28-Apr-81 JSL	Invention*  * 0.1  4-May-81 JSL	Better error handlingI  * 0.2 12-May-81 JSL	Decided to keep blocks around after all; changed thei1  *			name of balloc() to block() to match flex().?E  * 0.3 23-Jun-81 JSL	Conversion to the new documentation conventions.iF  * 1.0 26-Jun-81 JSL	Changed block to vstring, which makes more sense.C  * 1.1 29-Jun-81 JSL	More name changes; get consistent with flexes.   */i  
 #ifdef	vms /* #include "c:vstrin.h" */o #else& /* #include <vstrin.h> */* #endif #define NULL 0  " extern char *malloc(), *realloc();  	 VSTRING *= vstring(dim,ext)2 unsigned dim;		/* initial size for this vstring */# unsigned ext;		/* growth quantum */	 {	register VSTRING *pv;h7 	if ((pv = (VSTRING *)malloc(sizeof(VSTRING))) == NULL)r 		return(NULL);s( 	if ((pv->vsdata = malloc(dim)) == NULL) 	{	free(pv); 		return(NULL);  	} 	pv->vsdim = dim;t 	pv->vsext = ext;n 	pv->vslen = 0;o 	return(pv); }	  	 VSTRING *; vsaddc(pv,c) register VSTRING *pv;* char c;f {t 	if (pv != NULL) 	{	if (pv->vsdim <= pv->vslen) 		{	pv->vsdim += pv->vsext;t 			if (pv->vsdim <= pv->vslenb 			|| pv->vsdata == NULL2 			|| (pv->vsdata = realloc(pv->vsdata,pv->vsdim)) 				== NULL) 			{	pv->vsdim = 0;c 				return(pv->vsdata = NULL); 			} 		}*  		(pv->vsdata)[pv->vslen++] = c; 	} 	return(pv); }r  	 VSTRING *n vsadds(pv,s) register VSTRING *pv;a register char *s;  {	while (*s) 		pv = vsaddc(pv,*s++);- 	return(pv); }e  
 vsfree(pv) register VSTRING *pv;  {	if (pv != NULL)t 	{	if (pv->vsdata != NULL) 			free(pv->vsdata); 		free(pv);b 	} }r