 /*  *			U N I Q . C  *5  * Read a file, writing unique (or non-unique) lines.O  *  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...UNI 		}  */   #ifdef	DOCUMENTATION  ' title	uniq	Print Unique Lines in a File # index		Print Unique Lines in a File    synopsis  > 	uniq [-options] [-fields] [+letters] [limit] [input [output]]   description   : 	Uniq reads a sorted input file, writing each unique line.# 	The following options are defined:  	.lm +8 = 	.s.i -8;-a	Print all copies of duplicated lines; implies -d. $ 	.s.i -8;-u	Only print unique lines.' 	.s.i -8;-d	Only print duplicate lines. C 	.s.i -8;-c	Print the number of times each line occurred along with 
 	the line.7 	.s.i -8;-N	Skip over the first N words before checking  	for uniqueness.C 	.s.i -8;+N	Skip over the first N letters (in the indicated field). - 	Note that fields are skipped before letters. " 	.s.i -8;N	Compare only N letters.	 	.s.lm -8 F 	A word is defined as "optional spaces or tabs" followed by text up to& 	the first space, tab, or end of line. 	.s E 	If the output file is not specified, uniq will write to the standard E 	output.  If the input file is not specified, uniq will read from the  	standard input. 	.s G 	For an on-line help message (written to the standard output), execute:  	.s  		uniq ?   diagnostics    	.lm +8 % 	.s.i -8;Can't open input file "name" & 	.s.i -8;Can't open output file "name" 	.lm -8    author  
 	Martin Minow    bugs  > 	Because of the way the syntax of the command line is defined,? 	you can't use an input file whose first character is a digit - 2 	the code will attempt to interpret it as a limit.   #endif /*  * Edit history   * 0.0	??-???-?? MM	CreationB  * 1.0	24-May-85 JSL	Added VMS redirection code, -a switch, simple2  *			usage message.  Bugfix:  If there are no args2  *			nor switches, don't signal an error - just do!  *			a uniq from stdin to stdout!   */    char	*documentation[]  = {6 "Uniq reads an input file, writing each unique line.",L "Usage:	uniq [-Mode] [-N_fields] [+N_letters] [N_limit] [infile [outfile]]", "", 	 "Where:",  "", 8 " -a	Print all copies of duplicated lines; implies -d.", " -u	Only print unique lines.", " " -d	Only print duplicate lines.",H " -c	Print the number of times each line occurred along with the line.",6 " -z	Print the count (as in -c) with leading zero's.",A " -N	Skip over the first N words before checking for uniqueness", = " +N	Skip over the first N letters (in the indicated field)", , "  N	Compare only N letters after skipping", "", J "A word is defined as \"optional spaces or tabs\" followed by text up to",( "the first space, tab, or end of line.", "", E "If no file names are given, input and output are stdin and stdout.",  "",  0 };   #include <stdio.h> #include <ctype.h>
 #ifdef vms #include		<ssdef.h>0 #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)  #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */_ #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif #define	EOS		0 #define	FALSE		0 #define	TRUE		1=4 #define	BUFSIZE		1024		/* Buffer size (max. line)	*/4 int	skip_fields = 0;		/* Number of fields to skip	*/6 int	skip_letters = 0;		/* Number of letters to skip	*/7 int	check_letters = 0;		/* Number of letters to test	*/u, int	linecount;			/* How many repetitions		*/* int	countmode = 0;			/* Counted output		*/( int	mode = 0;			/* Mode byte, if any		*/2 int	allmode = 0;			/* Display all lines as read	*/+ int	line1[BUFSIZE];			/* Input buffer 1		*/t+ int	line2[BUFSIZE];			/* Input buffer 2		*/o  ! FILE	*infd;				/* Input file			*/	# FILE	*outfd;				/* Output file			*/r   		 main(argc, argv)' int	argc;		/* Number of arguments				*/o- char	*argv[];	/* Argument buffer pointer			*/  {a. 	register char	*argp;		/* Argument pointer		*/( 	register char	c;		/* Temp character		*// 	register char	*lp;		/* Line buffer pointer		*/	 	char		*getline(); 	char		*check();  
 #ifdef vms" 	argc = getredirection(argc,argv); #endif- 	infd = stdin;			/* Assume no in/out files	*/i 	outfd = stdout;  % 	if (argc > 1 && argv[1][0] == '?') {)	 		help();s 		exit(IO_ERROR);z 	}   	while (argc > 1A 	  && (c = *(argp = argv[1])) == '-' || c == '+' || isdigit(c)) {		 		++argp;o 		switch (c) {  & 		case '+':	skip_letters = atoi(argp);
 				break;  / 		case '-':	if ((c = *argp) >= '0' && c <= '9')  					skip_fields = atoi(argp);
 				else { 					switch (c = tolower(c)) { 					case 'c': 					case 'z': 						countmode = c; 						break; 					case 'u': 						allmode = 0; 						/* 						 * Fall through...	 						 */1 					case 'd': 						mode = c;? 						break; 					case 'a': 						allmode++; 						mode = 'd';r 						break;
 					default:a 						usage(); 						exit(IO_ERROR);] 					} 				})
 				break;  + 		default:	check_letters = atoi(&argp[-1]); 
 				break; 		}		 		argc--;/	 		argv++;e 	} 	if (argc > 1) {- 		if ((infd = fopen(argv[1], "r")) == NULL) {  			perror(argv[1]);	6 			printf("?Can't open input file \"%s\"\n", argv[1]); 			exit(IO_ERROR); 		} 	 		argc--;k	 		argv++;e 	} 	if (argc > 1) {. 		if ((outfd = fopen(argv[1], "w")) == NULL) { 			perror(argv[1]); 7 			printf("?Can't open output file \"%s\"\n", argv[1]);s 			exit(IO_ERROR); 		}d 	}   	/*  	 * Here we go 	 */7 	if ((lp = getline(line2)) == 0) {	/* Prime the pump	*/t 		fclose(infd);  		fclose(outfd); 		exit(IO_SUCCESS);  	}   	for (;;) {	 		lp = check(line1, line2, lp);a 		lp = check(line2, line1, lp);  	} }(   char *check(new, old, oldpos)i' char	*new;		/* New line read here				*/l) char	*old;		/* Old line resides here			*/	0 char	*oldpos;	/* Start of field in old line			*/ /*F  * Read lines as long as new == old.  Return a pointer to the field to1  * test in new.  Exit the program on end of file.   */e { / 	register char	*lp;		/* Random line pointer		*/; 	char		*getline();   	linecount = 0;* 	for (;;) {  		if (allmode) 		{	if (linecount == 1)  				output(old); 			if (linecount++ >= 1) 				output(new); 		}r 		else	linecount++;i  ! 		if ((lp = getline(new)) == 0) {	 			if (!allmode) 				output(old); 			fclose(infd); 			fclose(outfd);o 			exit(IO_SUCCESS); 		}0 		if (!equals(oldpos, lp))	 			break;, 	} 	if (!allmode) 		output(old); 	return(lp); }t   equals(old, new)' char	*old;		/* Compare this field				*/ ' char	*new;		/* Against this field				*/  /*:  * Return zero if they don't match.  If they do, return 1.  */  {	 	if (check_letters) {  #ifdef	unixe0 		return(strcmpn(old, new, check_letters) == 0); #elsef0 		return(strncmp(old, new, check_letters) == 0); #endif 	}$ 	else	return(strcmp(old, new) == 0); }*   output(line)$ char	*line;		/* What to output				*/ /*  * Output this line.  */n {o 	switch (mode) { 	case 'u':	if (linecount > 1)p 				return; 	 			break;o  ( 	case 'd':	if (linecount > 1 || allmode)
 				break;
 			return; 	} 	if (countmode == 'c')% 		fprintf(outfd, "%7d\t", linecount);N 	else if (countmode == 'z')e& 		fprintf(outfd, "%07d\t", linecount); 	fprintf(outfd, "%s", line); }    char *getline(line)	) char	*line;		/* Buffer to read into				*/	 /*D  * Read a line. return 0 on end of file.  If not end of file, return5  * a pointer to the first byte of the field to check.;  */  {t 	register int	count; 	register char	c;p 	register char	*lp;   ( 	if (fgets(line, BUFSIZE, infd) == NULL) 		return(0); 	lp = line;<* 	for (count = 0; count++ < skip_fields;) {- 		while ((c = *lp) == ' ' || c == '\t') lp++;e) 		while ((c = *lp) != ' ' && c != '\t') {d 			if (c == 0) 				return(lp); 
 			else	lp++;  		}  	}0 	for (count = 0; count++ < skip_letters; lp++) { 		if (*lp == 0) break; 	} 	return(lp); }    usage()  /*  * Give simple-minded help  */  {  	fprintf(stderr,M  "Usage:  uniq [-audc] [-<fields>] [+<letters>] [<limit>] [input [output]]\n"  		); }    help() /*  * Give good help   */  {  	register char	**dp;  $ 	for (dp = documentation; *dp; dp++) 		printf("%s\n", *dp); } 