 /*  *					x r f  *  * Cross reference  */    /*)BUILD	$(PROGRAM)	= xrfC 		$(INCLUDE)	= xrf.h. 		$(FILES)	= { xrf0 xrf1 xrf2 xrf3 xrfi xrfd } 		$(TKBOPTIONS)	= {  			TASK = ...XRF 			STACK = 1500  		} 
 		$(ODL)		= {  		;  		; OVERLAY DESCRIPTION FOR XRF  		; BOB DENNY	29-MAY-81  		; , 			.ROOT	XRF0-XRF2-XRFD-$(RXLIB)-*(X1,X2,X3) 		;  		X1:	.FCTR	XRFI-X1L1-X1L2-X1L3 # 		X1L1:	.FCTR	$(RXLIB):CONCAT:FWILD 7 		; Note: CTIME requires several other library modules: < 		X1L2:	.FCTR	$(RXLIB):TIME:CTIME:LOCALT:$$$$RTIME:$$$$UTIME4 		X1L3:	.FCTR	$(RXLIB):CALLOC:MUL$$L:$$$$DIV2:EIS$$I 		;  		X2:	.FCTR	XRF1-X2L 		X2L:	.FCTR	$(RXLIB):EIS$$I 		;  		X3:	.FCTR	XRF3-X3L 		X3L:	.FCTR	$(RXLIB):SPRINT 			.END  		} 
 		$(OVR)		= { $ 			XRF0,XRF2,XRFD,$(SUPORT),$(RTLIB) 			XRFI,$(RTLIB)/O:1 			XRF1,$(RTLIB)/O:1 			XRF3,$(RTLIB)/O:1 		}  */   /*  *              ***************   *              * X R F 0 . C *   *              ***************   *F  * This is the mainline program for the C cross referencer and lister."  * It handles the following tasks:  *   *      - Scans the command line%  *      - Opens the appropriate files -  *      - Calls some initialization functions )  *      - Invokes line by line processing *  *      - Prints the cross-reference index/  *      - Finishes up processing as appropriate   *  *	  * Usage:   *'  *	xrf [-s] [-n] [-o out_file] in_files   *	  *	Flags: 3  *		-s	Spool out_file to printer (RSX11M only (??))   *7  *		-n	Narrow (80 column) output, normal is 132 column.  *=  *		-o file	Write output to the indicated file.  If -o is not 3  *			specified, output will be to the first in_fileG"  *			with the filetype set to ".x"  *  * Written By:  *              Bob Dennys*  *              Creative System Design Co.6  *              3452 E. Foothill Blvd. << Suite 601 >>$  *              Pasadena, Ca.  91107  *              (213) 355-6836  *9  * Experimental Version         X1.0             5-May-80 9  * Split off initialization     X1.1             7-May-80 9  * Prototype.                   Y1.2             9-May-80 9  * Release.                     V1.3             9-May-80 9  * Chg. for DECUS OTS. & Cmplr. V1.4             1-Jul-80 9  * Add support for RT-11        V1.5             3-Jul-80 0  * Conditionalized spool call	V1.6 MM		 9-Jul-801  * Added narrow, outfile, etc.	V1.7 MM		10-Jul-80e,  * Added multiple infiles	V1.8 MM		22-Jul-80/  * Fspool now in the library	V1.9 MM		 2-Aug-80L-  * Add VMS I/O redirection	V2.0 JSL	29-May-85   *  (useless but consistent)  *N  *****************************************************************************  */e   #ifdef	DOCUMENTATION  / title	xrf	Cross-Reference Lister for C Programs , index		Cross-Reference Lister for C Programs   synopsis  ' 	xrf [-options] [-o outfile] [file ...]c   descriptione  C 	xrf prepares a cross-reference listing for C source programs.  Thei 	following options are defined:t 	.lm +8k; 	.s.i -8;-n	Narrow output (80 columns).  The default is 132;	 	columns.y5 	.s.i -8;-s	Spool output to the default line printer.=D 	.s.i -8;-o file	Write output to the named file.  The default is theB 	first input file encountered with a filetype (extension) of ".x".	 	.s.lm -8r" 	xrf accepts wild-card file input.   diagnosticsA   	.lm +8A  	.s.i -8;Trying to get too much. 	.so 	Internal error, get help.! 	.s.i -8;Not enough memory space.E 	.sD" 	xrf ran out of main memory space. 	.s.i -8;Cannot open "file" ( 	.s.i -8;Cannot open listing file "file" 	.s.i -8;Usage ... 	.lm -8a   author   	Robert B. Denny   bugs   #endif  L #include <stdio.h>                              /* RSX-11M Std. I/O Def's */H #include "xrf.h"                                /* Global definitions */  N int pageno;                                     /* Current listing page no. */ l   main ( argc, argv ) 
 char *argv[];rJ    {                                            /* Start the main prog. */?    register int i;                              /* Arg count */tK    register int c;                              /* Switch character code */nF    register char *p;                            /* Fast arg pointer */M    char *in_file;                               /* Source file name string */ 1    char *out_file;				/* Cref file name string */eE    int splflg;                                  /* Spool file flag */c+    int nofiles;					/* Flag "got a file" */y  
 #ifdef vms$    argc = getredirection(argc,argv); #endif  /    out_file = NULL;				/* No output file yet */lF    splflg = 0;                                  /* Default no spool */D    for( i=1; i<argc; ++i )                      /* For each token */       {:J       p = argv[i];                              /* p --> i'th arg token */L       if( *p++ == '-' )                         /* if it's a switch token */
          {K          while( c = *p++ )                      /* Each char is a switch */rA             switch(tolower(c))                  /* Process 'em */n                {% 	       case 'o':			/* Output file */T 		  argv[i] = 0; 		  if (++i >= argc) 			useage(); 		  out_file = argv[i];N 		  argv[i] = 0; 		  goto nextarg;y  ' 	       case 'n':			/* Narrow output */i4 		  rperline = (80 - 16)/RSIZE;	/* Set references */
 		  break;  C                case 's':                        /* Spool listing */e                   splflg++;!                   break;  K                default :                        /* Bad switch, give help */I                   useage();H                }% 	 argv[i] = 0;				/* Drop this one */"
          }	 nextarg:;eJ       }                                         /* Done with cmd string */      nofiles = 1;I    for( i = 1; i < argc; i++)i       {l#       if ((in_file = argv[i]) == 0)k 	 continue;"       initinfile(in_file);       while (nextinfile()) 	 {y          if (nofiles)! 	   {   	   initoutfile(out_file);l            nofiles = 0;w 	   } G          pageno = 0;                            /* Init. page number */ ( 	 lineno = 0;				/* Init. line number */& 	 myfree();				/* Clear out storage */A          root = NULL;                           /* No tree yet */FF          newpage();                             /* Start first page */M          while(fgets(scanbf, LWIDTH, src) != NULL) /* Get a line of source */ 
             {RK             ++lineno;                           /* Increment line number */ H             scanp = scanbf;                     /* Reset scan pointer */J             while(getid())                      /* scanp --> id or NULL */H                root = search(idbuf, root);      /* Process identifier */N                                                 /* Till done with this line */D             lstline();                          /* List this line */M             }                                   /* Till end of source file */ M          newpage();                             /* Start index on new page */NE          prtree(root);                          /* Print the index */M
          }       }	    if (nofiles)        useage(); 
 #ifdef rsxH    if(splflg)                                   /* If we're to spool, */I       fspool(lst);                              /* Cross your fingers. */  #endifH    exit(IO_SUCCESS);                            /* Exit closing files */F    }                                            /***** END MAIN *****/     /*  *9  * Listing control routines. Newpage also used by prtree.   *  */   D newpage()                                       /* Start new page */    {K    ++pageno;                                    /* Increment page number */ N    linpg = 0;                                   /* Reset line-in-page count */I    fprintf(lst,"%s%d\n\n", pghead, pageno);     /* Output page heading */     }  L lstline()                                       /* Write listing line out */    {    if(++linpg > MAXLIN)        newpage();,    fprintf(lst, "%4d:\t%s", lineno, scanbf);    }  