 /*'  *                      ****************'  *                      * X R F 1 . C *L'  *                      ***************f  *@  * Lexical processing for C xref'er. Sifts through C source code?  * and pulls out the identifiers. Recognizes reserved words andR@  * disregards them. Returns non-zero integer (true) if an id was?  * successfully moved into 'idbuf', zero (false) if end-of-lineF@  * was reached. I took care to test the C compiler's reaction toA  * Formfeeds with respect to line numbers, and made sure the lineI(  * numbers assigned by xrf act the same.  *!  * Version V1.3          9-May-80FA  * Version V1.4		10-Jul-80 MM	Allow $ in identifiers, bummed codeX:  * Version V1.5		21-Jul-80 MM	Dropped newline from ctime()7  * Version V1.6		22-Jul-80 MM	'.' is not an alpha char.F  */T   #include <stdio.h> #include "xrf.h"  - #define A 1             /* Alpha character */*7 #define C 2             /* Start of comment possibly */ / #define L 3             /* Literal delimiter */n/ #define N 4             /* Numeric character */ + #define Z 5             /* End of string */   . #define NRW 28          /* # reserved words */  ) static int cmtflg = 0;	/* Comment flag */l  = static char ctype[] = {         /* Character action lookup */*8                         Z,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8                         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8                         0,0,L,0,A,0,0,L,0,0,0,0,0,0,0,C,8                         N,N,N,N,N,N,N,N,N,N,0,0,0,0,0,0,8                         0,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,8                         A,A,A,A,A,A,A,A,A,A,A,0,0,0,0,A,8                         0,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,7                         A,A,A,A,A,A,A,A,A,A,A,0,0,0,0,0B                       };   static char *reswrd[NRW] = {8                         "auto", "break", "case", "char",>                         "continue", "default", "do", "double",;                         "else", "entry", "extern", "float",03                         "for", "goto", "if", "int", >                         "long", "register", "return", "short",?                         "sizeof", "static", "struct", "switch", ?                         "typedef", "union", "unsigned", "while"                          }; r   /*;  * Scan off a non reserved identifier. Put it into 'idbuf'.c:  * Returns +1 if successful, 0 if end-of-line was reached.  *  */l  B getid()                         /* Get an identifier into idbuf */      {?    register char *p ;                   /* Fast scan pointer */*A    register char *i ;                   /* Fast id buf pointer */I;    register int c;                      /* Dispatch code */	  @    p = scanp;                           /* Init fast pointers */
    i = idbuf;[  E    while ((c = *p) != 0)                /* Scan till end of string */        {p  :       if(c == '\014')                   /* If formfeed, */
          {G          c = *p = ' ';                  /* Convert to harmless blank */p<          newpage();                     /* Force new page */
          }  C       if (cmtflg)                       /* If comment flag is on */h
          {E          while(*p && *p++ != '*');	/* Scan to '*' or end of string */ H          if(*p == '/')                  /* If we found end of comment */C             cmtflg = 0;                 /* Turn off comment flag */n9          continue;                      /* and recycle */.
          }  3       switch(ctype[c])			/* Dispatch on the type */r
          {D          case A:                        /* Start of an identifier */I             i = idbuf;                  /* Reset the id buffer pointer */              do=                if( i < &idbuf[NCPS] )   /* Copy into idbuf */                    *i++ = *p++;A                else                     /* Unless it gets full */                    p++;K             while( (c=ctype[*p]) == A || c == N ); /* While alphanumeric */   B             while( i < &idbuf[NCPS] )   /* Pad idbuf with nulls */                *i++ = '\0'; I             if(nonres(idbuf))           /* If it's not a reserved word */e                {E                scanp = p;               /* Update the scan pointer */cA                return (1);              /* Return with success */                 }J             break;                      /* End of identifier processing */  E          case N:                        /* Scan by a number string */ :             do p++; while( (c=ctype[*p]) == N || c == A );             break;  ?          case L:                        /* Scan by a literal */vB 	    while (*++p != c && *p) {	/* Scan to the matching trailing */= 		if (*p == '\\') p++;	/* Quote, ignoring backslash quoted */o. 	    }				/* Characters.  If not at the end */7 	    if (*p) p++;		/* Of the line, skip to the char. */ 7             break;			/* Following the trailing quote */.            case C:=             if(*++p == '*')             /* Start a comment */fE               cmtflg = 1;               /* by setting comment flag */;             break;  H          default:                       /* Otherwise just scan it off */             p++;             break;E          }                              /* End of switch statement */   C       }                         /* If we exit here, end-of line. */dD    return(0);                   /* Return with failure indication */    }   s   /*B  * Search for reserved word. Return true (1) if NOT reserved word.  * Uses binary search.  */   ? nonres( bufp )                  /* Test if not reserved word */  char *bufp;n      {7    register int low ;           /* Low pointer index */a-    register int mid ;           /* Mid ... */i-    register int hi  ;           /* hi ...  */   ;    int cond;                    /* Condition from strcmp */       low = 0;0    hi  = NRW-1;       while (low <= hi)       {        mid = (low + hi) / 2;*0       if((cond = strcmp(bufp, reswrd[mid])) < 0)          hi = mid - 1;       else if (cond > 0)          low = mid + 1; 
       else;          return(0);             /* False, it IS reserved */        }t=    return(1);                   /* True, it's NOT reserved */L    }  