   /*'  *                      *************** '  *                      * X R F 2 . C * '  *                      ***************   *G  * This file contains the identifier tree and reference list management D  * things. It uses a simple binary tree to store the identifiers forC  * lookup and later sorted printing. Each node in the id tree has a E  * pointer to the id string, left and right links and pointers to thekC  * beginning and end of the linked list of reference nodes for that D  * id. Only the root of the tree is global, it is used by the sorted$  * index printing function 'prtree'.  *!  * Version V1.3          9-May-80-)  * Version V1.4		10-Jul-80 MM	Bummed code 0  * Version V1.5		23-Jul-80 MM	Redid storage code5  * Version V1.6		23-Dec-80 RBD	Fixed bug in myalloc()   */    #include <stdio.h> #include "xrf.h"     /*@  * Tree search and insertion. This function returns a pointer toA  * the new node if created. This may require some head scratchingD  * (I had to!). Look particularly at the significance of the pointerB  * that is returned and how it is used by the recursive caller. If@  * you want more, read "Algorithms + Data Structures = Programs"A  * by Niklaus Wirth (Prentice Hall ISBN 0-13-022418-9) Chapter 4.   *E  * It searches through the tree for a match to the supplied id (*kp). C  * If it is found, a new reference node is linked into the list for D  * that id. If no match is found, a new is node is inserted into theB  * tree and appropriately initialized, including a first reference  * node.  *  */   ? struct idt *search(kp, link)            /* Function "search" */ H struct idt *link;                       /* Pointer to id node in tree */C char *kp;                               /* Pointer to key string */     {?    register struct idt *l;              /* Fast tree pointer */r?    register struct ref *r;              /* Fast list pointer */,C    register int cond;                   /* Condition from strcmp */ 7    struct ref *newref();		/* Make reference function */   E    l = link;                            /* Copy link into register */ K    if(l == NULL)                        /* Not found, insert new id node */f       {"B       l = myalloc(sizeof(struct idt));	/* Make a new ident node */=       l->keyp = myalloc(strlen(kp)+1);	/* Get string space */rD                                         /* Fill in pointer to ... */D       strcpy(l->keyp, kp);              /* ... stashed key string */9       l->left = l->right = NULL;        /* No children */rF       l->first = l->last = newref();    /* Attach it to the id node */       }sA    else if((cond = strcmp(kp, l->keyp)) == 0) /* Match if true */p       { /       r = newref();			/* Get a new ref. node */=;       l->last->next = r;		/* Hook new node into the list */i       l->last = r;       }p7    else if(cond < 0)                    /* Look left */d$       l->left = search(kp, l->left);8    else                                 /* Look right */&       l->right = search(kp, l->right);
    return(l);/    }     /*$  * Initialize a line number referece  */*   static struct ref ** newref() {{    register struct ref *r;  ?    r = myalloc(sizeof(struct ref));	/* Make a reference node */)F    r->lno = lineno;                     /* Fill in line no. of ref. */E    r->next = NULL;                      /* This is the end for now */ 1    return(r);				/* Return pointer to the node */  }    /*  * Storage allocation:  *-  * my_free		Free byte pointer in local buffer 0  * my_left		Number of bytes left in local buffer6  * my_link		Link of free space buffers (from malloc())  *E  * If space can be gotten locally, get it.  If not, request a "large" /  * chunk of memory and update my_free, my_left.*  *C  * My_link links chunks from monitor, myfree() returns them (called   * at a new input file).  */    struct my_alloc {p 	struct my_alloc	*my_next; };  ' static struct my_alloc	*my_link	= NULL;d static char		*my_free	= NULL;  static int		my_left		= 0;+   myalloc(amount)  int		amount; /*  * Allocate amount bytes.t  */s {e 	register char	*new; 	register int	needed;s 	char		*malloc();   A 	needed = (amount + 1) & 0177776;  /* Round up to a word bound */  	if (needed > my_left) { 		/* 		 * Gotta get storage 		 */ & 		if ((my_free = malloc(512)) == NULL)
 			quit();- 		my_left = 512 - (sizeof (struct my_alloc)); 2 		((struct my_alloc *)my_free)->my_next = my_link;' 		my_link = (struct my_alloc *)my_free; & 		my_free += sizeof (struct my_alloc); 	} 	my_left -= needed;  	if (my_left < 0)l0 		error("Trying to get too much: %d\n", needed); 	new = my_free;n 	my_free += needed;'
 	return(new);, }n   myfree() /*!  * Return all storage to the pool.  */n {a  	register struct my_alloc	*link;  	register struct my_alloc	*next;   	next = my_link;  	while ((link = next) != NULL) { 		next = link->my_next;:
 		free(link);f 	} 	my_link = NULL; 	my_free = NULL;
 	my_left = 0;  }      /*I  * 'quit' handles dynamic memory deficit. (Sounds like U.S. Government!). I  * It issues a polite message to the user, marks the list file for delete   * and exits to RSX.  *  */;   quit()    {    char workbuf[40];  -    puts("Not enough memory space, sorry.\n");     fgetname(lst, workbuf);    fclose(lst);f    delete(workbuf);(    exit(IO_ERROR);    }