      SUBROUTINE QS_INT(IA,N)
      INTEGER*4 N,IA(*)
C
C     Global variables
      INTEGER*4 QS_MAXDEP
      PARAMETER (QS_MAXDEP=32)
      INTEGER*4 L(QS_MAXDEP),R(QS_MAXDEP),
     +          FIRST(QS_MAXDEP),LAST(QS_MAXDEP),
     +          LBL(QS_MAXDEP)
      COMMON/QS_VAR/L,R,FIRST,LAST,LBL
C
C     Local variables
      INTEGER*4 IPIVOT,TMP,K,LK,RK,JUMP
C
C     Sort
      FIRST(1)=1
      LAST(1)=N
      K=1
100   LK=FIRST(K)     
      RK=LAST(K)
      IPIVOT=IA((LK+RK)/2)
200   IF(IA(RK).LE.IPIVOT) GOTO 300
      RK=RK-1
      GOTO 200
300   IF(IA(LK).GE.IPIVOT) GOTO 400
      LK=LK+1
      GOTO 300
400   IF(LK.LE.RK) THEN
        TMP=IA(LK)
        IA(LK)=IA(RK)
        IA(RK)=TMP
        LK=LK+1
        RK=RK-1
        IF(LK.LE.RK) GOTO 200
      ENDIF
      L(K)=LK
      R(K)=RK
      IF(R(K).GT.FIRST(K)) THEN
        FIRST(K+1)=FIRST(K)
        LAST(K+1)=R(K)
        K=K+1
        ASSIGN 500 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
500   IF(L(K).LT.LAST(K)) THEN
        FIRST(K+1)=L(K)
        LAST(K+1)=LAST(K)
        K=K+1
        ASSIGN 600 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
600   IF(K.GT.1) THEN
        JUMP=LBL(K)
        K=K-1
        GOTO JUMP
      ENDIF
C
      RETURN
      END
C*******************
      SUBROUTINE QS_INT_IX(IA,N,IX)
      INTEGER*4 N,IA(*),IX(*)
C
C     Global variables
      INTEGER*4 QS_MAXDEP
      PARAMETER (QS_MAXDEP=32)
      INTEGER*4 L(QS_MAXDEP),R(QS_MAXDEP),
     +          FIRST(QS_MAXDEP),LAST(QS_MAXDEP),
     +          LBL(QS_MAXDEP)
      COMMON/QS_VAR/L,R,FIRST,LAST,LBL
C
C     Local variables
      INTEGER*4 IPIVOT,TMP,K,LK,RK,JUMP
C
C     Initialise index
      DO 50 K=1,N
        IX(K)=K
50    CONTINUE
C
C     Sort
      FIRST(1)=1
      LAST(1)=N
      K=1
100   LK=FIRST(K)     
      RK=LAST(K)
      IPIVOT=IA(IX((LK+RK)/2))
200   IF(IA(IX(RK)).LE.IPIVOT) GOTO 300
      RK=RK-1
      GOTO 200
300   IF(IA(IX(LK)).GE.IPIVOT) GOTO 400
      LK=LK+1
      GOTO 300
400   IF(LK.LE.RK) THEN
        TMP=IX(LK)
        IX(LK)=IX(RK)
        IX(RK)=TMP
        LK=LK+1
        RK=RK-1
        IF(LK.LE.RK) GOTO 200
      ENDIF
      L(K)=LK
      R(K)=RK
      IF(R(K).GT.FIRST(K)) THEN
        FIRST(K+1)=FIRST(K)
        LAST(K+1)=R(K)
        K=K+1
        ASSIGN 500 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
500   IF(L(K).LT.LAST(K)) THEN
        FIRST(K+1)=L(K)
        LAST(K+1)=LAST(K)
        K=K+1
        ASSIGN 600 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
600   IF(K.GT.1) THEN
        JUMP=LBL(K)
        K=K-1
        GOTO JUMP
      ENDIF
C
      RETURN
      END
C*******************
      SUBROUTINE QS_REAL(XA,N)
      INTEGER*4 N
      REAL*8 XA(*)
C
C     Global variables
      INTEGER*4 QS_MAXDEP
      PARAMETER (QS_MAXDEP=32)
      INTEGER*4 L(QS_MAXDEP),R(QS_MAXDEP),
     +          FIRST(QS_MAXDEP),LAST(QS_MAXDEP),
     +          LBL(QS_MAXDEP)
      COMMON/QS_VAR/L,R,FIRST,LAST,LBL
C
C     Local variables
      INTEGER*4 K,LK,RK,JUMP
      REAL*8 XPIVOT,TMP
C
C     Sort
      FIRST(1)=1
      LAST(1)=N
      K=1
100   LK=FIRST(K)     
      RK=LAST(K)
      XPIVOT=XA((LK+RK)/2)
200   IF(XA(RK).LE.XPIVOT) GOTO 300
      RK=RK-1
      GOTO 200
300   IF(XA(LK).GE.XPIVOT) GOTO 400
      LK=LK+1
      GOTO 300
400   IF(LK.LE.RK) THEN
        TMP=XA(LK)
        XA(LK)=XA(RK)
        XA(RK)=TMP
        LK=LK+1
        RK=RK-1
        IF(LK.LE.RK) GOTO 200
      ENDIF
      L(K)=LK
      R(K)=RK
      IF(R(K).GT.FIRST(K)) THEN
        FIRST(K+1)=FIRST(K)
        LAST(K+1)=R(K)
        K=K+1
        ASSIGN 500 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
500   IF(L(K).LT.LAST(K)) THEN
        FIRST(K+1)=L(K)
        LAST(K+1)=LAST(K)
        K=K+1
        ASSIGN 600 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
600   IF(K.GT.1) THEN
        JUMP=LBL(K)
        K=K-1
        GOTO JUMP
      ENDIF
C
      RETURN
      END
C*******************
      SUBROUTINE QS_REAL_IX(XA,N,IX)
      INTEGER*4 N,IX(*)
      REAL*8 XA(*)
C
C     Global variables
      INTEGER*4 QS_MAXDEP
      PARAMETER (QS_MAXDEP=32)
      INTEGER*4 L(QS_MAXDEP),R(QS_MAXDEP),
     +          FIRST(QS_MAXDEP),LAST(QS_MAXDEP),
     +          LBL(QS_MAXDEP)
      COMMON/QS_VAR/L,R,FIRST,LAST,LBL
C
C     Local variables
      INTEGER*4 K,LK,RK,JUMP,TMP
      REAL*8 XPIVOT
C
C     Initialise index
      DO 50 K=1,N
        IX(K)=K
50    CONTINUE
C
C     Sort
      FIRST(1)=1
      LAST(1)=N
      K=1
100   LK=FIRST(K)     
      RK=LAST(K)
      XPIVOT=XA(IX((LK+RK)/2))
200   IF(XA(IX(RK)).LE.XPIVOT) GOTO 300
      RK=RK-1
      GOTO 200
300   IF(XA(IX(LK)).GE.XPIVOT) GOTO 400
      LK=LK+1
      GOTO 300
400   IF(LK.LE.RK) THEN
        TMP=IX(LK)
        IX(LK)=IX(RK)
        IX(RK)=TMP
        LK=LK+1
        RK=RK-1
        IF(LK.LE.RK) GOTO 200
      ENDIF
      L(K)=LK
      R(K)=RK
      IF(R(K).GT.FIRST(K)) THEN
        FIRST(K+1)=FIRST(K)
        LAST(K+1)=R(K)
        K=K+1
        ASSIGN 500 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
500   IF(L(K).LT.LAST(K)) THEN
        FIRST(K+1)=L(K)
        LAST(K+1)=LAST(K)
        K=K+1
        ASSIGN 600 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
600   IF(K.GT.1) THEN
        JUMP=LBL(K)
        K=K-1
        GOTO JUMP
      ENDIF
C
      RETURN
      END
C*******************
      SUBROUTINE QS_STR(SA,N)
      INTEGER*4 N
      CHARACTER*(*) SA(*)
C
C     Global variables
      INTEGER*4 QS_MAXDEP
      PARAMETER (QS_MAXDEP=32)
      INTEGER*4 L(QS_MAXDEP),R(QS_MAXDEP),
     +          FIRST(QS_MAXDEP),LAST(QS_MAXDEP),
     +          LBL(QS_MAXDEP)
      COMMON/QS_VAR/L,R,FIRST,LAST,LBL
C
C     Local variables
      INTEGER*4 K,LK,RK,SL,JUMP
      CHARACTER*512 SPIVOT,TMP
C
C     Sort
      SL=LEN(SA(1))
      FIRST(1)=1
      LAST(1)=N
      K=1
100   LK=FIRST(K)     
      RK=LAST(K)
      SPIVOT(1:SL)=SA((LK+RK)/2)
200   IF(SA(RK).LE.SPIVOT(1:SL)) GOTO 300
      RK=RK-1
      GOTO 200
300   IF(SA(LK).GE.SPIVOT(1:SL)) GOTO 400
      LK=LK+1
      GOTO 300
400   IF(LK.LE.RK) THEN
        TMP(1:SL)=SA(LK)
        SA(LK)=SA(RK)
        SA(RK)=TMP(1:SL)
        LK=LK+1
        RK=RK-1
        IF(LK.LE.RK) GOTO 200
      ENDIF
      L(K)=LK
      R(K)=RK
      IF(R(K).GT.FIRST(K)) THEN
        FIRST(K+1)=FIRST(K)
        LAST(K+1)=R(K)
        K=K+1
        ASSIGN 500 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
500   IF(L(K).LT.LAST(K)) THEN
        FIRST(K+1)=L(K)
        LAST(K+1)=LAST(K)
        K=K+1
        ASSIGN 600 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
600   IF(K.GT.1) THEN
        JUMP=LBL(K)
        K=K-1
        GOTO JUMP
      ENDIF
C
      RETURN
      END
C*******************
      SUBROUTINE QS_STR_IX(SA,N,IX)
      INTEGER*4 N,IX(*)
      CHARACTER*(*) SA(*)
C
C     Global variables
      INTEGER*4 QS_MAXDEP
      PARAMETER (QS_MAXDEP=32)
      INTEGER*4 L(QS_MAXDEP),R(QS_MAXDEP),
     +          FIRST(QS_MAXDEP),LAST(QS_MAXDEP),
     +          LBL(QS_MAXDEP)
      COMMON/QS_VAR/L,R,FIRST,LAST,LBL
C
C     Local variables
      INTEGER*4 K,LK,RK,SL,JUMP,TMP
      CHARACTER*512 SPIVOT
C
C     Initialise index
      DO 50 K=1,N
        IX(K)=K
50    CONTINUE
C
C     Sort
      SL=LEN(SA(1))
      FIRST(1)=1
      LAST(1)=N
      K=1
100   LK=FIRST(K)     
      RK=LAST(K)
      SPIVOT(1:SL)=SA(IX((LK+RK)/2))
200   IF(SA(IX(RK)).LE.SPIVOT(1:SL)) GOTO 300
      RK=RK-1
      GOTO 200
300   IF(SA(IX(LK)).GE.SPIVOT(1:SL)) GOTO 400
      LK=LK+1
      GOTO 300
400   IF(LK.LE.RK) THEN
        TMP=IX(LK)
        IX(LK)=IX(RK)
        IX(RK)=TMP
        LK=LK+1
        RK=RK-1
        IF(LK.LE.RK) GOTO 200
      ENDIF
      L(K)=LK
      R(K)=RK
      IF(R(K).GT.FIRST(K)) THEN
        FIRST(K+1)=FIRST(K)
        LAST(K+1)=R(K)
        K=K+1
        ASSIGN 500 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
500   IF(L(K).LT.LAST(K)) THEN
        FIRST(K+1)=L(K)
        LAST(K+1)=LAST(K)
        K=K+1
        ASSIGN 600 TO JUMP
        LBL(K)=JUMP
        GOTO 100
      ENDIF
600   IF(K.GT.1) THEN
        JUMP=LBL(K)
        K=K-1
        GOTO JUMP
      ENDIF
C
      RETURN
      END
