	subroutine B$YE_
c	****************
c
	implicit none
c
c	Description
c	===========
c
c	Implements EXIT/QUIT command, leaving DBAG system properly:
c
c		- closes all open bases
c
c		- releases all temporary channels
c
c		- exits from system if interactive
c
c	IF ERROR, issues error message and goes ahead...
c
c	This procedures can be called as well by non-interactive program
c	to make sure everything is beeing closed...
c
c	var
c	===
c
	include 'own:DBAG0.OWN'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*12 txt
	integer base,level,lim,erro,sg,m,d,y,s,width,wi
	logical broad
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('B$YE')
c
	call ttwdth_(width)		!current terminal width
c
c	Close all open bases
c	--------------------
c
	do 1001 base = 1, d$b
	   if (d$base(base).ne.0) then
	      call close_(base,erro)
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'?')	!get error message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	      endif
	   endif
1001	continue
c
c	Release @ channels
c	------------------
c
	do 1002 level = 1, at$lvl
	   call i$atup_(erro)
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'?')	!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	   endif
1002	continue
c
c	Release ALTERNATE channel
c	-------------------------
c
	if (d$alte.gt.0) then
	   close(unit=d$alte)
	   call freec_(d$alte)
	   d$alte=0			!just in case...
	endif
c
c	Channels not (yet) released explicitly:
c
c	* error messages file (allocated at first call to ERRMSG procedure)
c	* help file           (same for H$ELP procedure)
c
	if (d$itrv.eq.1) then		!interactive
c
c	   Interactive, some more stuff before exit
c	   ========================================
c
	   s$set(s$talk)=.true.			!force talking to the terminal
	   call vset2_(1)			!clean screen from line 1
	   call time(txt)
	   read(txt(1:),'(6x,i2)')sg
	   call idate(m,d,y)
	   y=1900+y
	   call iweek_(d,m,y,s,txt,1,erro)
	   call date(today)
	   write (mssg,10001) d$name(1:istrip_(d$name)),
     1                        d$vers(1:istrip_(d$vers)),
     1                        today(1:istrip_(today)),
     1                        txt(1:istrip_(txt))	!byebye
	   lim=istrip_(mssg)
	   if (s.eq.6.and.(sg.gt.10.and.sg.lt.50)) then
	      mssg(lim+1:)=' thank God...'
	   endif
	   call vtext_(mssg(1:width),1,1,2)	!be nice...
	   mssg(1:)=' '
	   call vtext_(mssg(1:width),2,1,0)	!be nice...
	   call byebye_(mssg,erro)
	   call vtext_(mssg(1:width),4,1,0)	!be nice...
	   call vset1_(10,1)			!cursor
	   call vset3_(1,24)			!full screen scrolling
c
	   call tty_echo_(.true.)		!echo may have been suppressed
c
	endif
c
c	Was user broadcast ?
c
	if (tt$brd) then
	   broad=.true.			!restore it
	   wi=-1			!don't set terminal width
	   call i$tset_(wi,broad,erro)!set terminal (spawn a sub-process)
	   if (erro.ne.0) erro=0	!ignore error
	endif
c
	if (d$itrv.ne.0) then
	   call exit
	else
	   return
	endif
c
c	Formats
c	-------
c
	include 'fmt:bye.fmt'
c
	end
c
c
c
c
