	subroutine aexp$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1                   mark,interr,erro)
c	******************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mssg
c
c	Description
c	===========
c
c	It implements <arith expression> figure, see above in FORSYN.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer ierr,oper,resul
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	if (type.eq.12.or.type.eq.13) then		! "+" or "-" optional
	   if (type.eq.13) then
	      call push_(1,ierr)		! - unary
	   else
	      call push_(0,ierr)		! + unary
	   endif
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	   if (interr.ne.0) goto 90001
	else
	   call push_(0,ierr)			! nikles unary
	endif
c
	call term$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	   mark,interr,erro)
	if (erro.ne.0) goto 90002
c
	call pop_(oper,ierr)
	call apply$_(oper,resul,ierr)
	if (ierr.ne.0) goto 90002
	call apush_(resul,ierr)
c
cwhile	do while (type.eq.12.or.type.eq.13)		! "+" or "-" mandatory
1098	continue
	   if (.not.(type.eq.12.or.type.eq.13)) goto 1099
c
	   call push_(type,ierr)
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	   if (interr.ne.0) goto 90001
	   call term$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   call pop_(oper,ierr)
	   call apply$_(oper,resul,ierr)
	   if (ierr.ne.0) goto 90002
	   call apush_(resul,ierr)
c
	   goto 1098
1099	continue
cwhile	enddo
c
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in arithm expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c
	end
c
c
c
c
	subroutine term$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1                   mark,interr,erro)
c	******************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mssg
c
c	Description
c	===========
c
c	It implements <term> figure, see above in FORSYN.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer ierr,oper,resul
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	call fact$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	   mark,interr,erro)
	if (erro.ne.0) goto 90002
cwhile	do while (type.eq.10.or.type.eq.11)	! "*" or "/"
1098	continue
	   if (.not.(type.eq.10.or.type.eq.11)) goto 1099
c
	   call push_(type,ierr)
	   call inwht_(type,val,dec,rval,
     1                buf,lim,p1,p2,mssg,interr)
	   if (interr.ne.0) goto 90001
	   call fact$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   call pop_(oper,ierr)
	   call apply$_(oper,resul,ierr)
	   if (ierr.ne.0) goto 90002
	   call apush_(resul,ierr)
c
	   goto 1098
1099	continue
cwhile	enddo
c
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in term expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c
	end
c
c
c
c
	subroutine fact$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1                   mark,interr,erro)
c	******************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mssg
c
c	Description
c	===========
c
c	It implements <fact> figure, see above in FORSYN.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer ierr,oper,resul
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	if (type.eq.6) then			! "("
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	   if (interr.ne.0) goto 90001
	   call aexp$_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   if (type.eq.7) then			! ")"
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	      if (interr.ne.0) goto 90001
	   else
	      goto 90003		!syntax error
	   endif
	elseif (type.eq.2.or.type.eq.3) then	! NUMBER or DECIMAL
	   call apush_(val,ierr)
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	   if (interr.ne.0) goto 90001
cx	elseif (type.eq.1) then			! IDENTIFIER
cx	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
cx	   if (interr.ne.0) goto 90001
	else
	   goto 90003			!syntax error
	endif
c
	if (type.eq.20) then		! ^ or ** ( optional )
	   oper=20
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	   if (interr.ne.0) goto 90001
	   if (type.eq.2) then		! NUMBER
	      call apush_(val,ierr)
	      call apply$_(oper,resul,ierr)
	      if (ierr.ne.0) goto 90002
	      call apush_(resul,ierr)
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mssg,interr)
	      if (interr.ne.0) goto 90001
	   else
	      goto 90003		!syntax error
	   endif
	endif
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in fact expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c	fact expression syntax error
90003	continue
	erro=1
	mark=p1
	goto 99000			!set error
c
c	Set error
c
99000	continue
	call errset_('FACT$',erro)
	return
c
c
	end
c
c
c
c
	subroutine apply$_(oper,resul,erro)
c	**********************************
c
	implicit none
c
	integer oper,resul,erro
c
c	Description
c	===========
c
c	It applies OPER to the one/two top element(s) of ASTACK,
c	giving  RESUL. It  supports "+","-" (perhaps unary),"*",
c	"/","^".
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer item1,item2
c
c	begin
c	=====
c
	erro=0
c
	if (oper.eq.1.or.oper.eq.0) then	! + - unary
	   call apop_(item1,erro)
	else					! binary
	   call apop_(item1,erro)
	   call apop_(item2,erro)
	endif
c
	if (oper.eq.12) then		! +
	   resul=item1+item2
	elseif (oper.eq.13) then	! -
	   resul=item2-item1
	elseif (oper.eq.10) then	! *
	   resul=item1*item2
	elseif (oper.eq.11) then	! /
	   if (item1.ne.0) then
	      resul=item2/item1
	   else
	      resul=0
	      erro=1
	   endif
	elseif (oper.eq.1)  then	! - unary
	   resul=-item1
	elseif (oper.eq.20) then	! ^
	   resul=item2**item1
	else
	   resul=item1			! + unary
	endif
c
c
	return
c
c
	end
c
c
c
c
