	PROGRAM DBAG
c	************
c
	implicit none
c
c	Description
c	===========
c
c	Interactive module for the  relational   DBAG  data   system.
c	This is the main "eternal loop" program that waits for users
c	commands and dispatches for corresponding action.
c
c	EXIT/QUIT command never returns (exit is performed by B$YE
c	procedure), unless a syntactical error is found.
c
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*1 buf*(d$cmds)
	integer k,p,lim,erro,interr,type,val,dec,p1,p2,quit,l,l1,l2,width
	character*12 txt
	integer d,m,y,s,sg,answr,size
	real rval
	integer mark, baglin, ttlen, cmdtru
	logical primo/.true./, ohyes
c
c
c	begin
c	=====
c
c	set error status
c
	call errclr_('DBAG')
c
c	Initialize my own stuff
c	-----------------------
c
	d$itrv=1			!interactive usage
	d$edit=0			!no editing (yet...)
	mark=0				!no mark
	d$updo=0			!no UP/RECALL command (yet...)
	d$cmdp=0			!no command in command buffer
	baglin=10			!prompt and command edit/redisplay line
c
c	Initialize DBAG usage
c	---------------------
c
	call init_(erro)
	if (erro.ne.0) goto 95000		!fatal error
c
c	Announce yourself
c	-----------------
c
	call vset2_(1)			!clean screen from line 1
	call time(txt)
	read(txt(1:),'(6x,i2)')sg
	call idate(m,d,y)
	y=1900+y
	call iweek_(d,m,y,s,txt,1,erro)
	call date(today)
	write (mssg,10001) d$name(1:istrip_(d$name)),
     1                     d$vers(1:istrip_(d$vers)),
     1                     today(1:istrip_(today)),
     1                     txt(1:istrip_(txt))		!hello
	lim=istrip_(mssg)
	if (s.eq.6.and.(sg.gt.10.and.sg.lt.20)) then
	   mssg(lim+1:)=' thank God...'
	endif
	call vtext_(mssg(1:80),1,1,2)		!be nice...
	mssg(1:)=' '
	call helhel_(mssg,erro)			!get welcome message...
	call vtext_(mssg(1:80),3,1,0)		!be nice...
	write (mssg,10003)			!HELP for help...
	call vtext_(mssg(1:80),5,1,0)		!be nice...
	call vset1_(baglin-1,1)			!cursor (first prompting)
c
c	Execute "autoexec.bat/cmd" if any
c	---------------------------------
c
	inquire ( file='autoexec.bat',exist=ohyes)
	if (ohyes) then
	   buf(1:)=' '
	   buf(1:)='@autoexec.bat'		!default command file
	else
	   inquire ( file='autoexec.cmd',exist=ohyes)
	   if (ohyes) then
	      buf(1:)=' '
	      buf(1:)='@autoexec.cmd'		!alias
	   endif
	endif
c
	if (ohyes) then
	   write (mssg,10002) d$prmt(1:d$prsz)	!do "prompting"
	   mssg(istrip_(mssg)+1:)=buf(1:)	!..............
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   mark=0				!clear mark
	   goto 5				!submit as normal command
	endif
c
c	Here goes the eternal loop ( label 1)
c	-------------------------------------
c
1	continue
c
	call vset3_(2,24)		!normal scrolling
	if (d$erro.ne.0) then		!fatal error ?
	   call errmsg_(d$rsub,d$erro,mssg,'?')		!get message
	   if (mssg(14:24).eq.'No more i/o') then
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 95000	!fatal error
	      write (mssg,10007)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 95000	!fatal error
	      goto 11			!and proceed
	   else
	      goto 95000		!fatal error
	   endif
	endif
	if (d$edit.eq.1) then		!edit mode set
	   d$edit=0			!clear edit mode for next time
	   goto 94000			!go ask user about editing
					!come back to prompting
					!or to re-submit command line
	endif
c
c	Clear mark, reset scrolling and prompt for command
c	--------------------------------------------------
c
11	continue
c
	mark=0					!clear mark
c
	call vset3_(2,24)			!normal scrolling
c
	write (mssg,10002) d$prmt(1:d$prsz)	!do prompting
	call i$mess_(0,d$cmdo,1,mssg,0,erro)	!....
	if (erro.ne.0) goto 95000		!fatal error
c
c	Get command line
c	----------------
c
	erro=0					!only local messages, please...
	call inline_(d$cmdi,buf,size,cmcont,cmdtru,erro)!get command line
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   call errclr_('DBAG')			!clear error
	   erro=0
	   goto 1				!loop back to DBAG
	endif
c
c	Send command properly
c	---------------------
c
	call ttwdth_(width)		!current tt: width
	l=0
	l1=1
	mssg(1:1)=' '
124	continue
	   l=l+1
	   if (l.eq.1) then		!show prompt
	      l2=d$prsz+2		!prompt size + 2
	   else
	      l2=2			!next lines, no prompt
	   endif
	   mssg(2:width-l2+1)=buf(l1:)	!command line
	   call i$mess_(0,0,-1,mssg(1:width-l2+2),-1,erro)
	   if (erro.ne.0) goto 95000	!fatal error
	   l1=l1+width-l2
	   if (l1.le.size) goto 124	!go back for the rest if not done
c
	if (cmdtru) then
	   write (mssg,10006)			!command has been truncated
	   call i$mess_(0,d$cmdo,-1,mssg,1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	endif
c
	if     (size.eq.0) then
	   goto 1				!eol, do nothing
	elseif (size.eq.-1) then
	   goto 9902				!^Z or eof
	elseif (size.eq.-2) then
	   goto 1				!comment line, do nothing
	endif
c
c	Re(submit) command line for execution
c	-------------------------------------
c
5	continue
c
c	If @file level and not batch and PAUSE is set ON,
c	pause prior to execution
c
	if (at$lvl.gt.0.and.
     1      .not.us$bat.and.
     1      s$set(s$paus)  ) then
	   mssg(1:)=' '				!blank line
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   call p$ause_(buf,mark)		!pause
	   if (at$lvl.le.0) goto 1		!user aborted @file execution
	endif
c
	call vset3_(2,24)			!normal scrolling
c
c	Execute command
c	---------------
c
	call x$comm_(buf,mark,mssg,erro)
c
	if (erro.ne.0) then
c
	   if (erro.lt.0) then			!fatal error
	      erro=-erro
	      goto 95001
	   else					!show error
	      call errmsg_(d$rsub,erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 95000		!fatal error
	      call errclr_('DBAG')		!clear error
	      erro=0
	   endif
c
	endif
c
	goto 1
c
c	^Z found or end-of-@file
c	------------------------
c
9902	continue			!^Z or end-of-file
	if (at$lvl.gt.0) then
	   call i$atup_(erro)		!@ file active, go up
	   if (erro.ne.0) goto 95000	!error, exit
	   d$edit=0			!unset edit mode
	endif	
	goto 1				!loop back
c
c	Here if edit mode set by some of the command execution routines
c	---------------------------------------------------------------
c
94000	continue
c
	if (at$lvl.gt.0.or.
     1      us$bat        ) then
	   goto 11			!@file active or batch,
					!don't enter edit mode
	endif
c
c	Edit mode here
c	--------------
c
	if (d$updo.eq.1) goto 94001	!from UP/RECALL commnand, edit/submit
c
	write (mssg,10004)		!retry command line ?
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) goto 95000	!fatal error
c
	call i$yn_(answr,erro)		!accept y/n
	if (erro.ne.0) goto 95000	!fatal error
c
	if (answr.eq.5) goto 11		!'??????', loop back to DBAG
	if (answr.eq.4) goto 11		!comment line, loop back
	if (answr.eq.3) goto 11		!^Z, loop back
	if (answr.eq.2) goto 11		!'N', back to DBAG loop
c
					!'Y', EDIT command
94001	continue
c
	d$updo=0				!clear UP/RECALL command flag
	p=d$cmde				!current editor command pointer
c
	if (p.lt.1.or.
     1      p.gt.d$cmmd) goto 90001		!error, can't get command
c
	buf(1:)=' '				!get command from buffer
	buf(1:)=cmdbuf(p)			!...
c
	lim=istrip_(buf)	
	if (lim.le.0) then
	   d$edit=0				!don't edit command twice
	   goto 11				!no command yet, back to DBAG
	endif
c
94002	continue
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 95000		!fatal error
c
	call vcmmd_(buf,cmcont,baglin,mark,quit,cmdtru,erro)	!edit command
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   call errclr_('DBAG')			!clear error
	   erro=0
	   goto 11				!loop back to DBAG
	endif
c
	if     (quit.eq.0) then		!^Z QUIT
c
	   call vset2_(3)			!clean screen from line 3
	   call vset1_(baglin-1,1)		!cursor to prompt line
	   goto 11				!just loop back to DBAG
c
	elseif (quit.gt.0.or.
     1          quit.eq.-1   ) then	!^Z EXIT or <ret>
c
	   call vset2_(3)			!clean screen from line 3
	   call vset1_(baglin-1,1)		!cursor to prompt line
c
	   size=istrip_(buf)			!command line size
	   if (size.le.0) then
	      mssg(1:1)=' '			!be nice
	      call i$mess_(0,d$cmdo,-1,mssg(1:1),-1,erro)
	      if (erro.ne.0) goto 95000		!fatal error
	      goto 11				!just loop back to DBAG
	   else
c
	      if (cmdtru) then
	         write (mssg,10006)		!command has been truncated
	         call i$mess_(0,d$cmdo,-1,mssg,1,erro)
	        if (erro.ne.0) goto 95000	!fatal error
	      endif
c
	      call ttwdth_(width)		!current tt: width
	      l1=1
	      l=0
123	      continue
	         l=l+1
	         if (l.eq.1) then
	            write (mssg,10005) d$prmt(1:d$prsz)	!prompt
	            l2=d$prsz+2		!prompt size + 2
	         else
	            mssg(1:)=' '
	            l2=2			!next lines, no prompt
	         endif
	         mssg(l2:width+1)=buf(l1:)	!+ command line
	         call i$mess_(0,d$cmdo,-1,mssg(1:width+1),-1,erro)
	         if (erro.ne.0) goto 95000	!fatal error
	         l1=l1+width-l2+2
	         if (l1.le.size) goto 123	!go back for the rest
	      goto 5				!(re)submit it
	   endif
c
	elseif (quit.eq.-2) then	!UP_ARROW
	   d$edit=0				!don't edit command twice
	   p=p-1				!command pointer
	   if (p.lt.1) goto 11			!no more, loop back to DBAG
	   buf(1:)=' '				!get command
	   buf(1:)=cmdbuf(p)			!...
	   goto 94002				!back to editor
c
	else				!DOWN-ARROW
	   d$edit=0				!don't edit command twice
	   p=p+1				!command pointer
	   if (p.gt.d$cmmd.or.			!nothing in command line or end
     1         istrip_(cmdbuf(p)).le.0) then
	      call vset1_(baglin-1,1)		!cursor to prompt line
	      goto 11				!loop back to DBAG
	   endif
	   buf(1:)=' '				!get command
	   buf(1:)=cmdbuf(p)			!...
	   goto 94002				!back to editor
c
	endif
c
c	Errors
c	------
c
c	can't get command from buffer
90001	continue
	erro=1						!set error code
	goto 99000					!display message
c
c	Display error message
c	---------------------
c
99000	continue
	call errmsg_('DBAG',erro,mssg,'%')		!get message
	call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)	!display it
	if (erro.ne.0) goto 95000			!fatal error
	d$edit=1					!set edit mode
	goto 1						!loop back
c
c	Fatal error found during execution of some command or myself
c	------------------------------------------------------------
95000	continue
	call errmsg_(d$rsub,d$erro,mssg,'?')		!get message
95001	call errdpl_(mssg,d$cmdo)			!system message
	if (d$alte.ne.0.and.s$set(s$alte)) then
	   call errdpl_(mssg,d$alte)			!alt file also
	endif
	call exit					!just exit from DBAG
c
c	Formats
c	=======
c
	include 'fmt:dbag.fmt'
c
c
	end
c
c
c
c
