c	DBAG0.FOR
c	*********
c
c	Basic primitives for handling the DBAG data base system
c
c
c	Written and conducted by Luis Arriaga da Cunha, Antonio Mota 1984
c	=================================================================
c
c	Summary of public procedure calls:
c
c	opnbas	opens a data base (ie, relation) by name
c	opnfls	opens all fields of a data base
c	opncrt	opens all creatures (properties, series, ...) of a data base
c	clsbas	closes a data base
c	more    adds a new record to a data base
c	more2	as MORE, but enables index/noindex and use/don't-use killed list
c	append 	adds a new record to a data base
c	append2	as APPEND, but enables index/noind and use/don't-use killed list
c	rnext	gives next record number usable in a data base
c	find 	finds a record by number
c	lookup 	finds a record by number
c	fnext   goes thru records, in sequence
c	next   	goes thru records, in sequence
c	modify  changes the field values of a record
c	modify2	as MODIFY, but enables index/noindex
c	edit   	changes the field values of a record
c	edit2	as EDIT, but enables index/noindex
c	kill   	deletes forever a record
c	kill2	as KILL, but enables index/noindex
c	title  	gets the description of the data base
c	newttl	changes the description of the data base
c
c	Internal procedures:
c
c	lckbas	(base, error)
c	ulkbas	(base, error)
c	newbas 	(base, bname, inuse)
c	frebas 	(base)
c	opdbf	(kanal,base,  fspec, update, error)
c	getppn	(base,fspec,error)
c
c
c
c
c
	subroutine opnbas_(base, name, update, mode, error)
c	***************************************************
c
	implicit none
c
	integer base, update, mode, error
	character*(*) name
c
c	Description
c	===========
c
c	A base with file  name  NAME is opened. A new base channel
c	BASE  is given back by  the system. If update is  zero  no
c	updates  will  be  done,  if  one  some writing can happen,
c	if -1 current UPDATE mode, if already open, is not changed.
c
c	N.B.  	MODE is  normally zero.
c	===     If = -1  a  very special open that leaves the .ROO
c		open  will  be  performed  (what for !?). I'm  not
c		telling you, but normally one  should NOT use this
c		"facility".
c
c	If BASE already in memory:
c	      -	OPNBAS  may change base UPDATE  if same owner or if
c		different owner but base already open for retrieval,
c		or if no owner.
c	      -	Base UPDATE will not be changed if caller specifies
c		UPDATE=-1.
c
c	If BASE not in memory, UPDATE=-1 will be changed to UPDATE=0.
c
c	Structure of ROOT file:
c	-----------------------
c
c	Rec=1	#fields, signature, description_of_base,
c		date/time_of_creation,data base version (e.g. 'version 1.0')
c
c	Rec=2,3,4,5...  refer to fields 1,2,3,4... respectively :
c
c		mnemonic, description_of_field, name_of_other_D.B.
c
c	Structure of management records in DBF file:
c	--------------------------------------------
c
c	1	#fields
c	2	signature (same as in .roo)
c	3	last used "physical" record
c	4	last record in killed list (tail)
c	5	offset for "logical" records (physical=logical+offset)
c	6	# of killed records
c	7	owner base if property, series, memo ...
c	8	#opens for read only
c	9	#opens for update
c	10	date of last update
c	11	time of last update
c	12	protection on/off
c	13	spy on/off
c	14	kgb on/off
c	15	statistics on/off
c	16	is base hashed
c	17	basic template, eg ...!!!..!!!!!!!!!.....!!
c	18	type of fields
c	19	minimum values
c	20	maximum values
c	21	default values
c	22	is field indexed
c	23	protection for owner
c	24	protection for world
c	25	which fields tell the owner
c	26	verify (fields) on/off
c	27	field to see in other D.B.
c	28	decimal places
c	29	current owner
c	30	machine
c	31	template with real field numbers in basic template (rec 17)
c	32	creature signature (same as in ... default values template !
c				    of corresponding "field" in owner base!!!)
c	33	0 base is cripted, 1 is NOT cripted
c	34	first record in killed list (head)
c	35	1 - killed list is frozen
c	36	creature (base, series, etc)
c	37	master field in other D.B.
c	38	size, decimals, dimension of creature
c	39-40	free... ( in DBAG0.OWN you'll find d$unus=40 )
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	external istrip_
	integer istrip_
	integer i,n,j,k,l,kanal,sz,fl,moi,lui,pos,pos1,pos2,dbvers
	integer dwho,dprfl,nfld,signat,long,limit,rdir,kgb,mast
	integer siz,sign,type,size,idx,deci,oprt,wprt,ownr,oblg,see,min,max
	character*12 monnom, pong*1, loc_name
	logical basopn,itdoes,inuse,updt,full,flderr
c
	integer ego,kkk
	integer me
	integer sysid
c
	integer sys$getsyi
	integer*2 w1,w2
	integer*4 l1,l2
c
	common/sysego/ w1,w2,l1,l2
c
	data w1/4/
	data w2/'00000201'x/
c
	character*120 inidir,fspec
c
	character*4	txtmin,txtmax
	equivalence (min,txtmin)
	equivalence (max,txtmax)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('OPNBAS')
	error=0				!clear error
c
	loc_name=name
	if (istrip_(loc_name).le.0)goto 90016!empty name ?!?
c
c	name in upper case
c
	call uc_(loc_name)
c
c	Make sure not using previous values ...
c
	rdir=0				!inidir size
	inidir(1:)=' '
	kanal=0				!i/o channel
c
	fspec(1:)=' '			!hum!!
	fspec=loc_name			!user data base name
c
c	find date/time of this run
c	--------------------------
c
	call date(today)
	call time(hour)
c
c	who am I ?
c	----------
c
	call getpid_(moi)	!get my PID
	call myself_(monnom)	!my user name as a string
c
c	Get a new base channel now, or the old one if base already in memory
c	--------------------------------------------------------------------
c
	call newbas_(base, loc_name, inuse)
	if (base.eq.0) goto 90001		!no more room for database
	d$unam(base)(1:)=' '
	d$unam(base)(1:)=loc_name		!remember user name
c
c	INI BLOCK HERE
c	==============
c
c	If base already in memory, INI block already done; otherwise, see if
c	INI file exists and process it.
c
	if (inuse) goto 101				!INI file already done
c
	call givext_(fspec,'.INI')
	inquire(file=fspec,exist=itdoes,recl=long)
	if (itdoes) then
	   call newc_(kanal)				!ask for i/o channel
	   if (kanal.le.0) goto 90002			!no more i/o channels
	   open(unit=kanal, file=fspec, status='old',
     1     organization='sequential',access='sequential',
     1     shared, form='formatted', readonly, err=100)
	   d$xbuf(1:)=' '
	   read(kanal, '(a)',err=100) d$xbuf(1:long)
	   call uc_(d$xbuf(1:long))
	   rdir=index(d$xbuf, ']')			!remember
	   if (rdir.le.0) rdir=index(d$xbuf, ':')
	   if (rdir.gt.0) inidir(1:rdir)=d$xbuf(1:rdir)	!store inidir
	   limit=istrip_(d$xbuf)
	   if (limit.gt.rdir) then
	      fspec(1:)=' '				!hum!!
	      fspec(1:limit)=d$xbuf(1:limit)
	   else
	      if (rdir.gt.0) then
	         call givdir_(fspec,inidir)
	      endif
	   endif
	   if (kanal.gt.0) close(unit=kanal)
	endif
c
100	continue
c
	call freec_(kanal)			!free INI i/o channel
	kanal=0					!just in case...
c
101	continue
c
c	END OF INI BLOCK
c	================
c
	if (rdir.gt.0) then			!rdir from call index above...
	   d$bdir (base)=inidir(1:rdir)		!directory into context
	endif
c
c
c	UPDATE CHANGES AND LOCKS CHECKING BLOCK HERE
c	============================================
c
c	Check UPDATE=-1
c	---------------
c
	if (update.lt.0) then			!UPDATE=-1
	   if (inuse) then			!base already in memory,
	      if (d$pid(base).le.0) then	!recover previous UPDATE
	         update=0
	      else
	         update=1
	      endif
	   else
	      update=0				!base not in memory, open/read
	   endif
	endif
c
c	Check update changings/locks/...
c	--------------------------------
c
	if (inuse)then				!base already in memory
	   if (d$pid(base).eq.0) then
	      if (update.eq.0) then
	         goto 900			!no owner and update=0, return
	      else
	         rdir=istrip_(d$bdir(base))	!recover previous INI...
	         if (rdir.gt.0) then
	            inidir(1:)=d$bdir(base) (1:rdir)
	         endif
	         fspec(1:)=' '			!hum!!
		 fspec=d$bfil(base)
	         call clsbas_(base,error)	!no owner and update=1,close it
	         if (error.ne.0) then
	            goto 90011			!clsbas errors
	         else
	            inuse=.false.		!remember not inuse anymore
	            goto 200			!ok, force re-open
	         endif
	      endif
	   else
	      if (moi.eq.d$pid(base)) then
	         if (update.eq.0) then
	            rdir=istrip_(d$bdir(base))	!don't loose previous INI...
	            if (rdir.gt.0) then		!...........................
	               inidir(1:)=d$bdir(base)	!...........................
     1                                  (1:rdir)!.......(secret code).......
	            endif			!...........................
	            fspec(1:)=' '		!hum!!......................
		    fspec=d$bfil(base)		!...........................
	            call clsbas_(base,error)	!same owner & update=0!,close
	            if (error.ne.0) then	!base left open (^Y ?)
	               goto 90011		!clsbas errors
	            else
	               inuse=.false.		!remember not inuse anymore
	               goto 200			!ok, re-open base
	            endif
	         else
                    goto 900			!same owner and update=1,return
	         endif
	      else
	         call givext_(fspec,'.DBF')
cx	         inquire(file=fspec,opened=basopn)
	         call inqr_(fspec,basopn)	!inquire's substitute
	         if (basopn) then
	            goto 90009			!base already opened by other
	         else
	            call clsbas_(base,error)	!no owner and update=1!,close
	            if (error.ne.0) goto 90011	!base left open (^Y ?)
	            inuse=.false.		!remember not inuse anymore
	            goto 200			!re-open base, just in case ...
	         endif
	      endif
	   endif
	endif
c
c	END OF UPDATE/LOCKS CHECKING BLOCK
c	==================================
c
c	if (inuse) goto	300		!if base already in use, skip this
c
c	OPEN ROOT FILE AND LOAD CONTEXT
c	===============================
c
c	This will be done only if data base not inuse
c	---------------------------------------------
c
200	continue
c
	call givext_(fspec,'.ROO')
	inquire(file=fspec,recl=long,exist=itdoes)
	if (.not.itdoes) goto 90003		!database doesn't exist
	call newc_(kanal)			!ask for i/o channel
	if (kanal.le.0) goto 90002		!no more i/o channels
c
	open(unit=kanal, file=fspec, status='old', access='direct',
     1       form='formatted', organization='relative', shared,
     1       readonly, recl=long, err=90005)
c
c	from first record (rec=1)
c
	read(kanal, rec=1, fmt='(a)', err=90006)d$xbuf(1:long)
	call uncript_(d$xbuf,long)
c
	call rdivar_(d$xbuf(ro$s1:ro$s1+ro$l1-1),nfld,ro$l1,error)!# fields
	if (error.ne.0) goto 90006			!read error
	d$nfld(base)=nfld
c
	if (d$nfld(base).gt.d$f) goto 90017		!?too many fields
c
	call rdivar_(d$xbuf(ro$s2:ro$s2+ro$l2-1),sign,ro$l2,error)!signatur
	if (error.ne.0) goto 90006			!read error
	d$sign(base)=sign
c
	d$bdes(base)(1:)=' '
	read(d$xbuf(ro$s3:ro$s3+ro$l3-1),'(a)',err=90006) d$bdes(base)
c
	d$date(base)(1:)=' '
	read(d$xbuf(ro$s4:ro$s4+ro$l4-1),'(a)',err=90006) d$date(base)
c
	pos1=ro$s5+7					!'version 1.0'
	pos2=index(d$xbuf(ro$s5+7:ro$s5+ro$l5-1),'.')
	if (pos2.le.0) then
	   d$nver(base)=0
	else
	   pos2=ro$s5+7 + pos2 - 2
	   call rdivar_(d$xbuf(pos1:pos2),dbvers,pos2-pos1+1,error)!version
	   if (error.ne.0) goto 90006			!read error
	   d$nver(base)=dbvers
	endif
c
c	from other records (rec=2 thru d$nfld(base)+1)
c
	do 1001 k=1,d$nfld(base)
	   d$xbuf(1:)=' '
	   read(kanal, rec=k+1, fmt='(a)', err=90006)d$xbuf(1:long)
	   call uncript_(d$xbuf,long)
	   d$fmne(k,base)(1:)=' '
	   read(d$xbuf(cm$s1:cm$s1+cm$l1-1),'(a)',err=90006) d$fmne(k,base)
	   d$fdes(k,base)(1:)=' '
	   read(d$xbuf(cm$s2:cm$s2+cm$l2-1),'(a)',err=90006) d$fdes(k,base)
	   d$fnam(k,base)(1:)=' '
	   read(d$xbuf(cm$s3:cm$s3+cm$l3-1),'(a)',err=90006) d$fnam(k,base)
1001	continue
c
	if (mode.eq.-1) then		!if MODE = -1, don't close root
	   d$rio(base)=kanal		!and save i/o channel
	else
	   if (kanal.gt.0) then
	      close(unit=kanal)		!just in case...
	      call freec_(kanal)
	   endif
	   d$rio(base)=0		!clean context anyway...
	endif
c
c	OPEN BASE FILE AND LOAD MAIN CONTEXT
c	====================================
c
	call newc_(kanal)				!ask for channel
	if (kanal.le.0) goto 90013			!none left!
	call givext_(fspec,'.DBF')
	call opdbf_ (kanal,base,moi,fspec,long,update,error)
	if (error.ne.0) goto 90012			!OPDBF error
	d$recl(base)=long
c
	if (d$recl(base).gt.x$rec) goto 90019	!?? record too big
c
c	load context from base file
c	---------------------------
c
c	what follows is not template-like (rec=1 thru 16 and 30)
c	--------------------------------------------------------
c
	read(kanal,rec=1,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) nfld		!#fields
c
	if (nfld.gt.d$f) goto 90017		!?too many fields
c
	d$nfld(base)=nfld
c
	read(kanal,rec=2,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) signat	!signat in .DBF
	if (signat.ne.d$sign(base)) goto 90004	!horror !!!
c
	read(kanal,rec=3,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$last(base) !last used record
c
	read(kanal,rec=4,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$tail(base) !LAST freed record
c
	read(kanal,rec=5,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$offs(base) !offset for records
c
	read(kanal,rec=6,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$kill(base) !#killed records
c
	read(kanal,rec=7,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	d$ownb(base)(1:)=' '				!owner base
	d$ownb(base)=d$xbuf(1:long)
c
	read(kanal,rec=8,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$opr(base) 	!#opens for read only
c
	read(kanal,rec=9,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$opw(base) 	!#opens for update
c
	d$upd(base)(1:)=' '
	d$xbuf(1:)=' '
	read(kanal,rec=10,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	d$upd(base)(1:)=d$xbuf			!date last update
	d$xbuf(1:)=' '
	read(kanal,rec=11,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	d$upd(base)(10:)=d$xbuf			!time last update
c
	read(kanal,rec=12,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$prt(base) 	!protection on/off
c
	read(kanal,rec=13,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$spy(base) 	!spy on/off
c
	read(kanal,rec=14,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) kgb		 !kgb on/off
	if (kgb.eq.1) d$kgb=1
c
	read(kanal,rec=15,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$stat(base) !statistics on/off
c
	read(kanal,rec=16,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$hash(base) !is base hashed ?
c
	read(kanal,rec=30,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) me		!cpu number
c
	read(kanal,rec=34,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$head(base) !FIRST freed record
c
	read(kanal,rec=35,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$froz(base) !1=killed list frozen
c
	read(kanal,rec=36,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)',err=90007) d$race(base) !race of "thing"
c
	if (d$race(base).eq.r$b0.or.			!regular old base or
	1   d$race(base).eq.r$b    ) then		!regular new base
	   d$csig(base)=0
	else						!creatures
	   read(kanal,rec=32,fmt='(a)',err=90007) d$xbuf(1:long)
	   if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	   read(d$xbuf,fmt='(i10)',err=90007) d$csig(base)!creature signature
	endif
c
	read(kanal,rec=38,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i6,i2,i2)',err=90007) 
	1       d$psiz(base),d$pdec(base),d$pdim(base) !dimensions of "thing"
c
c	see if machine is alright
c	-------------------------
c
	l1=%loc(ego)
	l2=%loc(kkk)
c
cx	i=sys$getsyi(,,,w1,,,)
c
cx	if (ego.eq.me) then
c	   ok
cx	else
cx	   goto 90015
cx	endif
c
c	an image of the fields template follows (rec=17)
c	------------------------------------------------
c
	d$xbuf(1:)=' '
	read(kanal,rec=17,fmt='(a)',err=90007) d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	pong=d$xbuf(2:2)	!ignore 1st character
	sz=0
	fl=1
	d$pos(1,base)=2
	limit=istrip_(d$xbuf)
	do 1002 k=2,limit
	   if (d$xbuf(k:k).ne.pong) then
	      d$siz(fl,base)=sz
	      if (d$siz(fl,base).gt.x$fld) goto 90018	!?? field too big
	      fl=fl+1
	      d$pos(fl,base)=k
	      sz=1
	      pong=d$xbuf(k:k)
	   else
	      sz=sz+1
	   endif
1002	continue
	d$siz(fl,base)=sz
	if (d$siz(fl,base).gt.x$fld) goto 90018		!?? field too big
c
c	what follows are templates, ie, field indexed (rec=18 thru 28)
c	--------------------------------------------------------------
c
	read(kanal,rec=18,fmt='(a)',err=90007) d$xbuf(1:long) !type of fields
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1003 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),type,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$type(k,base)=type
1003	continue
c
	read(kanal,rec=19,fmt='(a)',err=90007) d$xbuf(1:long) !minimum value
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1004 k=1,d$nfld(base)
	   if (d$type(k,base).ne.db$) then
	      pos1=d$pos(k,base)
	      pos2=pos1+d$siz(k,base)-1
	      siz=d$siz(k,base)
	      if     (d$type(k,base).eq.r$) then
	         txtmin=d$xbuf(pos1:pos2)
	         d$min(k,base)=min
	      elseif (d$type(k,base).eq.r8$) then
	         d$min(k,base)=0		!no minimum value
	      else
	         call rdivar_(d$xbuf(pos1:pos2),min,siz,error)
	         if (error.ne.0) goto 90007			!read error
	         d$min(k,base)=min
	      endif
	   else
	      d$min(k,base)=0	!old bases may have spurious db$ limits...
	   endif
1004	continue
c
	read(kanal,rec=20,fmt='(a)',err=90007) d$xbuf(1:long) !maximum value
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1005 k=1,d$nfld(base)
	   if (d$type(k,base).ne.db$) then
	      pos1=d$pos(k,base)
	      pos2=pos1+d$siz(k,base)-1
	      siz=d$siz(k,base)
	      if     (d$type(k,base).eq.r$) then
	         txtmax=d$xbuf(pos1:pos2)
	         d$max(k,base)=max
	      elseif (d$type(k,base).eq.r8$) then
	         d$max(k,base)=0		!no maximum value
	      else
	         call rdivar_(d$xbuf(pos1:pos2),max,siz,error)
	         if (error.ne.0) goto 90007			!read error
	         d$max(k,base)=max
	      endif
	   else
	      d$max(k,base)=0	!old bases may have spurious db$ limits...
	   endif
1005	continue
c
	d$xbuf(1:)=' '
	read(kanal,rec=21,fmt='(a)',err=90007) d$dflt(base)(1:long)!def. val.
	if (d$crpt(base).eq.0) call uncript_(d$dflt(base),long)
c
	read(kanal,rec=22,fmt='(a)',err=90007) d$xbuf(1:long)  !index
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1006 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),idx,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$idx(k,base)=idx
	   if (d$race(base).eq.r$b0.or.			!regular old base or
	1      d$race(base).eq.r$b    ) then		!regular new base
c	      ok
	   else
	      if (d$type(k,base).le.ftusr$) then	!if user field
	         d$idx(k,base)=0			!sorry, no indices
							!(just in case...)
	      endif
	   endif
1006	continue
c
	read(kanal,rec=23,fmt='(a)',err=90007) d$xbuf(1:long) !protection owner
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1007 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),oprt,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$oprt(k,base)=oprt
1007	continue
c
	read(kanal,rec=24,fmt='(a)',err=90007) d$xbuf(1:long) !protection world
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1008 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),wprt,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$wprt(k,base)=wprt
1008	continue
c
	read(kanal,rec=25,fmt='(a)',err=90007) d$xbuf(1:long) !owner profile
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1009 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),ownr,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$ownr(k,base)=ownr
1009	continue
c
	read(kanal,rec=26,fmt='(a)',err=90007) d$xbuf(1:long) !mandatory
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1010 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),oblg,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$oblg(k,base)=oblg
1010	continue
c
	read(kanal,rec=27,fmt='(a)',err=90007) d$xbuf(1:long) !see field
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1011 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),see,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$see(k,base)=see
1011	continue
c
	read(kanal,rec=28,fmt='(a)',err=90007) d$xbuf(1:long) !decimal places
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1012 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),deci,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$deci(k,base)=deci
1012	continue
c
	read(kanal,rec=37,fmt='(a)',err=90007) d$xbuf(1:long) !master field
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
	do 1013 k=1,d$nfld(base)
	   pos1=d$pos(k,base)
	   pos2=pos1+d$siz(k,base)-1
	   siz=d$siz(k,base)
	   call rdivar_(d$xbuf(pos1:pos2),mast,siz,error)
	   if (error.ne.0) goto 90007			!read error
	   d$mast(k,base)=mast
1013	continue
c
c	rec=39 thru 40 are free for the moment...
c
c	make sure some items in the context are clean or set (here because
c	base may be closed-reopened if update chnages!!!!!!!!!!!!!!!!!!!!)
c
	d$base(base)= 1			!base "normally" opened in channel base
c
c	full file spec into context
c	---------------------------
c
	call givext_(fspec,'.INI')	!programers are MAD!!!
	j=index(fspec,']')		!get rid of .INI
	if (j.le.0) j=index(fspec,':')
	if (j.le.0) j=1
	l=index(fspec(j:),'.INI')+j-2
c
	d$bfil(base)(1:)=' '		!full file spec into context
	if (index(fspec(1:l),']').le.0.and.
     1      index(fspec(1:l),':').le.0     ) then
	   d$bfil(base)(1:3)='[ ]'	!pretty
	   d$bfil(base)(4:)=fspec(1:l)
	else
	   d$bfil(base)(1:)=fspec(1:l)
	endif
c
	d$unam(base)=loc_name		!user supllied name too
	d$bio(base)=kanal		!save base i/o channel
	unlock(unit=kanal,err=321)	!unlock base file
321	continue
c
c	END OF OPEN BASE FILE AND LOAD CONTEXT BLOCK
c	============================================
c
300	continue
c
c	Last, but not the least: see if version is ok
c	---------------------------------------------
c
	if (d$nver(base).eq.0) then
	   if (update.eq.1.and.
	1      d$kill(base).gt.0.and.
	1      (d$head(base).le.0.or.
	1       d$tail(base).le.0    ) ) goto 90021	!gosh, not compatible
	endif
c
c	PPN FILE BLOCK
c	==============
c
c	see if a .PPN file exists and if yes read user's profile
c	--------------------------------------------------------
c
	if (d$prt(base).gt.0) then		!only if prot is ON
	   call getppn_(base,fspec,error)
	   if (error.ne.0) then			!profile in d$prfl(base)
	      goto 90010			!error...
	   endif
	   do k = 1, d$nfld(base)
	      if (d$prfl(k,base).ne.prtno) then
	         goto 310			!at least one field...
	      endif
	   enddo
	   goto 90022				!all fields protected !
310	   continue
	endif
c
c	END OF PPN FILE BLOCK
c	=====================
c
c	register in SPY file if requested
c	=================================
c
	if (d$spy(base).gt.0) then
	   call dospy_('OPNBAS',base,error)
	   if (error.ne.0) goto 90014		!my own error, please
	endif
c
c	Set first and number of user data fields
c	=======================================
c
	d$u1st(base)=0
	d$udnf(base)=0
c
	do k = 1, d$nfld(base)
	   if (d$type(k,base).le.ftusr$) then
	      if (d$u1st(base).le.0) d$u1st(base)=k
	      d$udnf(base)=d$udnf(base)+1
	   endif
	enddo
c
c	Everybody returns here !
c	========================
c
900	continue
c
	return
c
c	errors
c	======
c
c	no more base channels available
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	error=1
	goto 99000
c	no more i/o channels
90002	continue
	error=2
	goto 99000
c	database doesn't exist
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=3
	goto 99000
c	horrid unconsistency with signatures or #fields!
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=4
	goto 99000
c	error opening root file
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=5
	goto 99000
c	read error (root file)
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=6
	goto 99000
c	read error (.DBF file)
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=7
	goto 99000
c	*** obsolete ***
90008	continue
	error=8
	goto 99000
c	base currently locked by another user
90009	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	error=9
	goto 99000
c	error detected by GETPPN
90010	continue
	call frebas_(base)
	goto 99001			!carry error
c	error detected by CLSBAS
90011	continue
	call frebas_(base)
	goto 99001			!carry error
c	error detected by OPDBF
90012	continue
	if (error.eq.2) then		!base locked by another fellow
	   d$rinf(1:)=' '
	   d$rinf(1:5)='base '
	   d$rinf(6:)=loc_name			!tell him which base
	   error=9
	   call errset_('OPNBAS',error)	!my own error code, if you don't mind
	endif
	goto 99001			!carry error
c	no more free channels for mode=1
90013	continue
	call frebas_(base)
	error=10
	goto 99000
c	can't access/use SPY file
90014	continue
	error=11
	goto 99000
c	machine is not right
90015	continue
	error=12
	goto 99000
c	empty base name (you stupid...)
90016	continue
	error=13
	goto 99000
c	?? too many fields (parameter d$f, dbag0.own, exceeded)
90017	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=14
	goto 99000
c	?? field too big (parameter x$fld, dbag0.own, exceeded)
90018	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=15
	goto 99000
c	?? .DBF record too big (parameter x$rec, dbag0.own, exceeded)
90019	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	call frebas_(base)
	error=16
	goto 99000
c	*** obsolete ***
90020	continue
	error=17
	goto 99000
c	? Version 0 with killed records opened for update ...
c	=== don't free i/o channel ===
90021	continue
ccxx	call frebas_(base)		!dont free it !!!!!!!!!!
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	error=18
	goto 99000
c	all fields protected
90022	continue
	call frebas_(base)
	d$rinf(1:5)='base '
	d$rinf(6:)=loc_name			!tell him which base
	error=19
	goto 99000
c	read/write error
90023	continue
	error=20
	goto 99000
c
99000	continue
	call errset_('OPNBAS',error)
99001	continue
c
	if (error.ne.18) then
	   if (kanal.gt.0) then
	      close(unit=kanal)		!close (and unlock...) base i/o channel
	      call freec_(kanal)
	      kanal=0			!just in case...
	   endif
	endif
c
	return
c
c	formats
c	=======
c
	include 'fmt:opnbas.fmt'
c
	end
c
c
c
c
	subroutine opnfls_(base,error)
c	******************************
c
	implicit none
c
	integer base,error
c
c	Description
c	===========
c
c	Opens all data base fields.
c	ERROR not =0 if base not open or illegal base number.
c	If non-interactive usage, ERROR not =0 also if problems accessing
c	other data base(s).
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer k
	logical flderr
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('OPNFLS')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	Open other data base fields if not yet
c	--------------------------------------
c
	flderr=.false.
	do k = 1, d$nfld(base)
	   if (d$prfl(k,base).ne.prtno) then	!field is available
	      if (d$dbio(k,base).le.0) then
	         call fldopn_(base,k,error)
	         if (error.ne.0) then
	            flderr=.true.		!remember that
	            if (d$itrv.eq.1) then	!interactive, show error
	               call errmsg_(d$rsub,error,mssg,'%')!get message
	               call i$mess_(0,d$cmdo,-1,mssg,-1,error)
	               if (error.ne.0) return	!fatal error, carry
	            endif	         
	         endif
	      endif
	   endif
	enddo
c
	if (flderr) then
	   if (d$itrv.ne.1) goto 90003			!non-interactive
	endif
c
	return						!return
c
c	errors
c	======
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	problems accessing at least one "o.d.b" field
90003	continue
	error=3
	goto 99000
c
99000	continue
	call errset_('OPNFLS',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine opncrt_(base,update,defprop,defseries,defmemo,error)
c	***************************************************************
c
	implicit none
c
	integer base,update,error
	logical defprop,defseries,defmemo
c
c	Description
c	===========
c
c	Opens all data base creatures (properties, series, memos...)
c	ERROR not =0 if base not open or illegal base number.
c	If non-interactive usage, ERROR not =0 also if problems accessing
c	other data base(s).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer dtype,k,prop
	logical flderr
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('OPNCRT')
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	Open other data base fields if not yet
c	--------------------------------------
c
	defprop=.false.
	defseries=.false.
	defmemo=.false.
c
	flderr=.false.
	do k = 1, d$nfld(base)
	   if (d$prfl(k,base).ne.prtno) then	!field is available
	      dtype=d$type(k,base)
	      if (d$dbio(k,base).gt.0.and.	!already opened as structure
	1         pp$fat(base).gt.0       ) then!and as creature
	         if     (dtype.eq.p$) then
	            defprop=.true.
	         elseif (dtype.eq.mm$) then
	            defmemo=.true.
	         elseif (dtype.eq.s$) then
	            defseries=.true.
	         endif
	      else
	         if (dtype.eq.p$.or.
	1            dtype.eq.s$.or.
	1            dtype.eq.mm$   ) then
	            call opnaln_(prop,d$fnam(k,base),update,error)
	            if (error.ne.0) then
	               if (d$itrv.eq.1) then		!interactive
	                  call errmsg_(d$rsub,error,mssg,'%')
	                  call i$mess_(0,d$cmdo,-1,mssg,-1,error)
	                  if (error.ne.0) return	!error, carry
	                  call errclr_('OPNCRT')	!clear error
	                  error=0
	               else
	                  flderr=.true.
	               endif
	               d$dbio(k,base)=0
	            else
	               if     (dtype.eq.p$) then
	                  defprop=.true.
	               elseif (dtype.eq.mm$) then
	                  defmemo=.true.
	               elseif (dtype.eq.s$) then
	                  defseries=.true.
	               endif
	            endif
	         endif
	      endif
	   endif
	enddo
c
	if (flderr) then
	   if (d$itrv.ne.1) goto 90003			!non-interactive
	endif
c
	return						!return
c
c	errors
c	======
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	problems accessing at least one creature
90003	continue
	error=3
	goto 99000
c
99000	continue
	call errset_('OPNCRT',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine clsbas_(base,error)
c	******************************
c
	implicit none
c
	integer base, error
c
c	Description
c	===========
c
c	The base with channel BASE is closed and its context freed.
c	If d$rio(base) .ne. 0, root file is open with that channel
c
c	error	= 0	ok, base was closed
c		> 0	error found
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer io,k,long,b2,mast
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('CLSBAS')
	error=0
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) then
	   goto 90001
	endif
c
	if (d$base(base).eq.0) then
	   goto 90002			!go set error
	endif
c
c	clean cache
c
	do 1001 k=1,x$cach
	   if (base.eq.d$bsch(k)) then
	      d$bsch(k)=0
	      d$cdch(k)=0
	      d$cach(k)(1:)=' '
	   endif
1001	continue
c
c	close index files and o.d.b. fields if any
c
	do 1002 k=1,d$nfld(base)
	   b2=d$dbio(k,base)
	   mast=d$mast(k,base)
	   if (b2.gt.0.and.mast.gt.0) then!o.d.b. field
	      call fldcls_(base,k,error)
	      if (error.ne.0) then	!ignore error
	         call errclr_('CLSBAS')
	         error=0
	      endif
	   endif
	   if (d$idx(k,base).ne.0) then	!indexed field
	      call clsx_(base,k,error)
	      if (error.ne.0) then	!ignore error
	         call errclr_('CLSBAS')
	         error=0
	      endif
	   endif
1002	continue
c
c	clean context, free base and close it
c
	io=d$rio(base)
	if (io.gt.0) then
	   close(unit=io)		!close root
	   call freec_(io)
	endif
c
	io=d$bio(base)			!close dbf
	if (io.gt.0) then
	   if (d$pid(base).gt.0) then
	      d$xbuf(1:)=' '
	      d$pid(base)=0
	      write (d$xbuf,fmt='(i10)',err=90003) d$pid(base)	!and in file
	      long=d$recl(base)		!record size
	      if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	      write (io,rec=29,fmt='(a)',err=90003) d$xbuf(1:long)
	   endif
	   close(unit=io)
	   call freec_(io)
	endif
c
c	register in SPY file if requested
c
	if (d$spy(base).gt.0) then
	   call dospy_('CLSBAS',base,error)
	   if (error.ne.0) goto 90004		!my own error, please
	endif
c
	call frebas_(base)
c
	return				!good return
c
c	errors
c	======
c
c	invalid base number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	goto 99000
c	error writing to dbf file
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=3
	goto 99000
c	Can't access/use SPY file
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=4
	goto 99000
99000	continue
	call frebas_(base)		!free context in any case...
	call errset_('CLSBAS',error)	!set error
	return
c
c	here inherited errors
95000	continue
	return				!and return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine more_(base, xcode, image, error)
c	*******************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) image
c
c	Description
c	===========
c
c	This  procedure  appends  a new record to the BASE. The various
c	fields  come  in  via  IMAGE,  all  fields flatened. A new code
c	is  GIVEN BACK BY THE DBAG SYSTEM in  XCODE!!!. It is therefore
c	an output variable against what normally happens. As everywhere
c	ERROR  zero means okness. Normally a new physical position will
c	be used ; however,  if  some  records were killed before, their
c	position is used instead.
c
c	Top  secret ! If  ERROR  comes in as -16381744 no validation is
c	performed upon the user's data.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
	include 'OWN:DBUG.OWN'
c
	external istrip_
	integer istrip_
	integer code,recor,io,long,head,next,tail,lim,val,l1,l2,k,onenmb
	integer ocode
	logical faites,vampire,eox,odb,inipos
	character*12 crap
	integer iprot
c
c	begin
c	=====
c
c	not commenting this (see below to understand this...)
c
	faites=.true.
	if (error.eq.-16381744) faites=.false.
c
c	init error handling
c
	call errclr_('MORE')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90001
c
c	and open for update
c
	if (d$pid(base).le.0) goto 90006
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
c	see protection
c
	if (d$prt(base).eq.0) then
c	   no protection
	else
	   do 10 iprot=1,d$nfld(base)
	      if (d$prfl(iprot,base).ne.prtrw) goto 90007
10	   continue
	endif
c
	dbuf(1:)=image(1:)			!use a copy
c
c	validate user's data
c
	if (faites) then
	   call valida_(base,dbuf,error)
	   if (error.ne.0) goto 95000
	endif
c
c	validate any KEY field
c	make sure index files can be used in any case
c
	do 1003 k=1,d$nfld(base)
	   if (s$set(s$inde)) then
	      if (d$idx(k,base).ne.0) then
	         call opnx_(base,k,error)
	         if (error.ne.0) goto 95000
	      endif
	   endif
	   if (d$idx(k,base).eq.2) then
	      l1=d$pos(k,base)
	      l2=l1+d$siz(k,base)-1
	      val=0
	      call fix_ (base,k,val,DBUF(l1:l2),ocode,eox,error)
	      if (error.ne.0) goto 95000
cccc	      call clsx_(base,k,error)
cccc	      if (error.ne.0) then		!ignore error
cccc	         call errclr_('MORE')
cccc	         error=0
cccc	      endif
	      if (.not.eox) goto 90008	!key already exists
	   endif
1003	continue
c
c	any list of dead records and not frozen ? (brrrr)
c
	long=d$recl(base)
	if (d$head(base).eq.0.or.
	1   d$froz(base).ne.0) then
	   vampire=.false.
	   recor=d$last(base) + 1	!no, use new position
	else
	   vampire=.true.
	   tail=d$tail(base)		!yes, re-use it and re-link
	   head=d$head(base)
	   recor=head			!use head record
	   if (tail.eq.head) then	!list becomes empty ?
	      d$tail(base)=0		!yes
	      d$head(base)=0
	      crap(1:)=' '
	      write(crap,fmt='(i10)',err=90004)0
	      if (d$crpt(base).eq.0) call cript_(crap,10)
	      write(io,rec=4,fmt='(a)',err=90004) crap(1:10)	!tail
	      write(io,rec=34,fmt='(a)',err=90004) crap(1:10)	!head
	   else				!no
	      read( io,rec=head,fmt='(a)',err=90005) crap(1:10)
	      if (d$crpt(base).eq.0) call uncript_(crap,10)
	      read(crap,fmt='(1x,i9)',err=90005) next
	      crap(1:)=' '
	      write(crap,fmt='(''?'',i9)',err=90005) next
	      if (d$crpt(base).eq.0) call cript_(crap,10)
	      write(io,rec=tail,fmt='(a)',err=90005) crap(1:10)
	      d$head(base)=next
	      crap(1:)=' '
	      write(crap,fmt='(i10)',err=90004)next
	      if (d$crpt(base).eq.0) call cript_(crap,10)
	      write(io,rec=34,fmt='(a)',err=90004) crap(1:10)	!head
	   endif
	   d$kill(base)=d$kill(base)-1
	   crap(1:)=' '
	   write(crap,fmt='(i10)',err=90004) d$kill(base)
	   if (d$crpt(base).eq.0) call cript_(crap,10)
	   write(io,rec=6,fmt='(a)',err=90004) crap(1:10)
	endif
c
	code=recor-d$offs(base)
c
c	ok, go ahead
c
	if (d$crpt(base).eq.0) call cript_(DBUF,long)
	write( io,rec=recor,fmt='(a)',err=90002 )DBUF(1:long)
c
c	If re-using killed record #, update cache if there
c
	if (vampire) then
	   do 1002 k=1,x$cach
	      if (code.eq.d$cdch(k).and.base.eq.d$bsch(k)) then
	         d$cach(k)(1:long)=DBUF(1:long)
	         goto 100	!break now !!!
	      endif
1002	   continue
100	   continue
	endif
c
	if (.not.vampire) then
	   DBUF2(1:)=' '
	   write (DBUF2,fmt='(i10)',err=90003) recor
	   if (d$crpt(base).eq.0) call cript_(DBUF2,long)
	   write( io,rec=3,fmt='(a)',err=90003) DBUF2(1:long)
	endif
c
	unlock(unit=io,err=321)
321	continue
c
c	update context
c
	if (.not.vampire) then
	   d$last(base)=recor
	endif
c
c	insert in index files if any and indexes are SET ON
c
	if (s$set(s$inde)) then
	   do 1001 k=1,d$nfld(base)
	      if (d$idx(k,base).ne.0) then
	         l1=d$pos(k,base)
	         l2=l1+d$siz(k,base)-1
cx just opened	         call opnx_(base,k,error)
cx just opened	         if (error.ne.0) goto 95000
	         val=0
	         call insx_(base,k,val,DBUF(l1:l2),code,error)
	         if (error.ne.0) goto 95000
	         call clsx_(base,k,error)
	         if (error.ne.0) then	!ignore error
	            call errclr_('MORE')
	            error=0
	         endif
	      endif
1001	   continue
	endif
c
c	see if check digit
c
	call in3ex_(base,code,xcode,error)
	if (error.ne.0) return			!error, carry
c
	return
c
c	errors
c	======
c
c	invalid base number
90001	continue
	error=1
	goto 99000
c	problems writing new record in .DBF file
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	goto 99000
c	problems writing record #3 in .DBF file
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=3
	goto 99000
c	problems writing DBF record #4 or #6
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=4
	goto 99000
c	problems reading record in .DBF file
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=5
	goto 99000
c	base not open for update
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=6
	goto 99000
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=7				!R/O or No Access Field
	goto 99000
c	key already exists
90008	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90088) k
90088	error=8
	goto 99000
99000	continue
	call errset_('MORE',error)
c
	unlock(unit=io,err=3211)
3211	continue
c
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine append_(base, xcode, window, error)
c	**********************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) window(*)
c
c	Description
c	===========
c
c	This  procedure  appends  a new record to the BASE. The various
c	fields  come  in  via  WINDOW,  one fields per line. A new code
c	is   GIVEN BACK BY THE DBAG SYSTEM   in  XCODE. It is therefore
c	an output variable against what normally happens. As everywhere
c	ERROR  zero means okness. Normally a new physical position will
c	be used ; however,  if  some  records were killed before, their
c	position is used instead.
c
c	Top  secret ! If  ERROR  comes in as -16381744 no validation is
c	performed upon the user's data.
c
c	APPEND actually asks MORE to perform the work.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer tmperr
c
c	begin
c	=====
c
c	init error handling
c
	call errclr_('APPEND')
	tmperr=error			!remember it for more
	error=0				!clear error
c
	call flat_(base,window,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	error=tmperr
	call more_ (base, xcode, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	return
c
c	errors
c	======
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine more2_(base, xcode, image, indexit, freeze, error)
c	*************************************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) image
	logical indexit,freeze
c
c	Description
c	===========
c
c	This procedure appends a new record to the BASE.
c
c	It calls MORE to do it, but enables temporary use/no-use of indexes
c	and/or killed records.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
c
	integer oldfrz
	logical oldidx
c
c	begin
c	=====
c
c	Save current global status
c
	oldfrz=d$froz(base)
	oldidx=s$set(s$inde)
c
	if (freeze) then
	   d$froz(base)=1
	else
	   d$froz(base)=0
	endif
c
	if (indexit) then
	   s$set(s$inde)=.true.
	else
	   s$set(s$inde)=.false.
	endif
c
	call more_(base, xcode, image, error)
c
c	Restore status
c
	d$froz(base)=oldfrz
	s$set(s$inde)=oldidx
c
	return
c
	end
c
c
c
c
	subroutine append2_(base, xcode, window, indexit, freeze, error)
c	****************************************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) window(*)
	logical indexit,freeze
c
c	Description
c	===========
c
c	This procedure appends a new record to the BASE.
c
c	It calls APPEND to do it, but enables temporary use/no-use of indexes
c	and/or killed records.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
c
	integer oldfrz
	logical oldidx
c
c	begin
c	=====
c
c	Save current global status
c
	oldfrz=d$froz(base)
	oldidx=s$set(s$inde)
c
	if (freeze) then
	   d$froz(base)=1
	else
	   d$froz(base)=0
	endif
c
	if (indexit) then
	   s$set(s$inde)=.true.
	else
	   s$set(s$inde)=.false.
	endif
c
	call append_(base, xcode, window, error)
c
c	Restore status
c
	d$froz(base)=oldfrz
	s$set(s$inde)=oldidx
c
	return
c
	end
c
c
c
c
	subroutine find_(base, xcode, alive, image, error)
c	**************************************************
c
	implicit none
c
	integer base, xcode, alive, error
	character*(*) image
c
c
c	Description
c	===========
c
c	For BASE it reads record with XCODE giving the fields in IMAGE.
c	IMAGE is  the  exact  image  of  is  in  disk,  ie , flattened.
c	ALIVE isn't used anymore.
c	If  something wrong ERROR will not be zero and IMAGE will be
c	filled with '*'.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBUG.OWN'
c
	external istrip_
	integer istrip_
	integer code, io, m1, m2, long, recor, k, lim
	logical incach
	integer iprot
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FIND')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90001
c
c	see if code is valid
c
	call ex3in_(base,xcode,code,error)
	if (error.ne.0) goto 90008
	m1=d$unus-d$offs(base)+1
	m2=d$last(base)-d$offs(base)
	if (code.lt.m1.or.code.gt.m2) goto 90002
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
c	ok, go ahead
c
	long=d$recl(base)
	recor=code+d$offs(base)
c
c	see if already in cache, if not read from disk and update cache
c
	incach=.false.
	do 1001 k=1,x$cach
	   if (code.eq.d$cdch(k).and.base.eq.d$bsch(k)) then
	      incach=.true.
	      DBUF(1:long)=d$cach(k)(1:long)
	      goto 100		!break now !!!
	   endif
1001	continue
	read( io,rec=recor,fmt='(a)',err=90006)DBUF(1:long)
	unlock(unit=io,err=321)
321	continue
c
c	update cache if not there
c
	if (.not.incach) then
	   d$cnch=d$cnch+1
	   if (d$cnch.gt.x$cach) d$cnch=1
	   d$bsch(d$cnch)=base
	   d$cdch(d$cnch)=code
	   d$cach(d$cnch)(1:long)=DBUF(1:long)
	endif
c
100	continue
c
	if (d$crpt(base).eq.0) call uncript_(DBUF,long)
c
c	see if alive or killed
c
	if (DBUF(1:1).eq.' ') then
c	   ok				!alive record
	elseif (DBUF(1:1).eq.'?') then
	   goto 90005			!killed record
	else
	   goto 90007
	endif
c
	image(1:)=DBUF(1:long)
c
c	see protection
c
	if (d$prt(base).eq.0) then
c	   no protection
	else
	   do 10 iprot=1,d$nfld(base)
	     if (d$prfl(iprot,base).eq.prtno)
	1      image(d$pos(iprot,base):
	1            d$pos(iprot,base)+d$siz(iprot,base)-1)=' '
10	   continue
	endif
c
	return
c
c	errors
c	======
c
c	invalid base number
90001	continue
	error=1
	goto 99000
c
c	invalid code number ("out of bounds")
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90092) xcode
90092	continue
	error=2
	goto 99000
c
c	*** obsolete *** invalid code number (alive, unwanted)
cc90003	continue
c	*** obsolete *** invalid code number (deleted, unwanted)
cc90004	continue
c
c	accessing killed record
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90055) xcode
90055	continue
	error=5
	goto 99000
c
c	problems reading DBF record
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90096) xcode
90096	continue
	error=6
	goto 99000
c
c	gross internal error, can't understand mark in record
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90097) xcode
90097	continue
	error=7
	goto 99000
c
c	invalid code number (wrong check digit)
90008	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90088) xcode
90088	continue
	error=8
	goto 99000
c
99000	continue
c
	do k = 2, long
	   image(k:k)='*'
	enddo
c
	call errset_('FIND',error)
c
	unlock(unit=io,err=3211)
3211	continue
c
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine lookup_(base, xcode, alive, window, error)
c	*****************************************************
c
	implicit none
c
	integer base, xcode, alive, error
	character*(*) window(*)
c
c
c	Description
c	===========
c
c	For BASE it reads record with XCODE giving the fields in WINDOW.
c	If  something wrong ERROR will not be  zero.
c	ALIVE isn't used anymore.
c    	It  actually  asks  FIND to performed the reading of the record.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer io, m1, m2, long, recor, k
	logical incach
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('LOOKUP')
	error=0				!clear error
c
	call find_ (base, xcode, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	call unflat_(base,window,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	return
c
c	errors
c	======
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine modify_(base, xcode, image, error)
c	*********************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) image
c
c	Description
c	===========
c
c	Given  a  perhaps  modified record in IMAGE the new version
c	is re-written into BASE under XCODE, of course.
c
c	Top secret ! If ERROR comes in as -16381744 no validation is
c	performed upon the user's data.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
	include 'OWN:DBUG.OWN'
c
	external istrip_
	integer istrip_
	integer code,io,lim,long,recor,k,onenmb,ocode
	integer val,m1,m2,l1,l2
	logical faites,actual,eox,odb,inipos
	integer iprot
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
c	not commenting this (see below to understand this...)
c
	faites=.true.
	if (error.eq.-16381744) faites=.false.
c
	call errclr_('MODIFY')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90001
c
c	and open for update
c
	if (d$pid(base).le.0) goto 90005
c
c	see if code is valid
c
	call ex3in_(base,xcode,code,error)
	if (error.ne.0) goto 90004
	m1=d$unus-d$offs(base)+1
	m2=d$last(base)-d$offs(base)
	if (code.lt.m1.or.code.gt.m2) goto 90003
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
	dbuf(1:)=image(1:)			!use a copy
c
c	validate user's data
c
	if (faites) then
	   call valida_(base,dbuf,error)
	   if (error.ne.0) goto 95000
	endif
c
c	validate any KEY field
c	make sure index files can be used in any case
c
	do 1003 k=1,d$nfld(base)
	   if (s$set(s$inde)) then
	      if (d$idx(k,base).ne.0) then
	         call opnx_(base,k,error)
	         if (error.ne.0) goto 95000
	      endif
	   endif
	   if (d$idx(k,base).eq.2) then
	      l1=d$pos(k,base)
	      l2=l1+d$siz(k,base)-1
	      val=0
	      call fix_ (base,k,val,DBUF(l1:l2),ocode,eox,error)
	      if (error.ne.0) goto 95000
cccc	      call clsx_(base,k,error)
cccc	      if (error.ne.0) then	!ignore error
cccc	         call errclr_('MODIFY')
cccc	         error=0
cccc	      endif
	      if (.not.eox.and.			!key already exists
	1         ocode.ne.xcode) goto 90006	!and not the same record
	   endif
1003	continue
c
c	ok, go ahead
c
	long=d$recl(base)
	recor=code+d$offs(base)
c
c	see protection
c
	if (d$prt(base).eq.0) then
	   DBUF2(1:)=dbuf(1:)			!No protection
	else
	   read (io,rec=recor,fmt='(a)',err=90002)DBUF2(1:long)
	   do 10 iprot=1,d$nfld(base)
	      if (d$prfl(iprot,base).eq.prtrw) 
     1		  DBUF2(d$pos(iprot,base):
     1                  d$pos(iprot,base)+d$siz(iprot,base)-1)=
     1		  dbuf(d$pos(iprot,base):d$pos(iprot,base)+d$siz(iprot,base)-1)
10	   continue
	endif
c
c	cript and update
c
	if (d$crpt(base).eq.0) call cript_(DBUF2,long)
	write( io,rec=recor,fmt='(a)',err=90002 )DBUF2(1:long)
	unlock(unit=io,err=321)
321	continue
c
c	update cache if record is there
c
	do 1001 k=1,x$cach
	   if (code.eq.d$cdch(k).and.base.eq.d$bsch(k)) then
	      d$cach(k)(1:long)=DBUF(1:long)
	      goto 100		!break now !!!
	   endif
1001	continue
100	continue
c
c	update index files if any and indexes are set ON
c
	if (s$set(s$inde)) then
	   do 1002 k=1,d$nfld(base)
	      if (d$idx(k,base).ne.0) then
	         l1=d$pos(k,base)
	         l2=l1+d$siz(k,base)-1
cx just opened	         call opnx_(base,k,error)
cx just opened	         if (error.ne.0) goto 95000
	         val=0
	         call updx_(base,k,val,DBUF2(l1:l2),code,error)
	         if (error.ne.0) goto 95000
	         call clsx_(base,k,error)
	         if (error.ne.0) then	!ignore error
	            call errclr_('MODIFY')
	            error=0
	         endif
	      endif
1002	   continue
	endif
c
	return
c
c	errors
c	======
c
c	invalid base number
90001	continue
	error=1
	goto 99000
c
c	problems writing DBF file
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	goto 99000
c
c	invalid code number ("out of bounds")
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90033) xcode
90033	continue
	error=3
	goto 99000
c
c	invalid code number (wrong check digit)
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90044) xcode
90044	continue
	error=4
	goto 99000
c	base not open for update
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=5
	goto 99000
c	key already exists
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90066) k
90066	continue
	error=6
	goto 99000
c
99000	continue
	call errset_('MODIFY',error)
c
	unlock(unit=io,err=3211)
3211	continue
c
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine modify2_(base, xcode, image, indexit, error)
c	*******************************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) image
	logical indexit
c
c	Description
c	===========
c
c	Given  a  perhaps  modified record in IMAGE the new version
c	is re-written into BASE under XCODE, of course.
c
c	Top secret ! If ERROR comes in as -16381744 no validation is
c	performed upon the user's data.
c
c	It calls MODIFY to do it, but enables temporary use/no-use of indexes
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
c
	logical oldidx
c
c	begin
c	=====
c
c	Save current global status
c
	oldidx=s$set(s$inde)
c
	if (indexit) then
	   s$set(s$inde)=.true.
	else
	   s$set(s$inde)=.false.
	endif
c
	call modify_(base, xcode, image, error)
c
c	Restore status
c
	s$set(s$inde)=oldidx
c
	return
c
	end
c
c
c
c
	subroutine edit_(base, xcode, window, error)
c	********************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) window(*)
c
c	Description
c	===========
c
c	Given  a  perhaps  modified record in WINDOW the new version
c	is re-written into BASE under XCODE, of course.
c
c	Top secret ! If ERROR comes in as -16381744 no validation is
c	performed upon the user's data.
c
c	EDIT actually asks MODIFY to perform its task.
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer tmperr
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('EDIT')
	tmperr=error			!remember it for modify
	error=0				!clear error
c
	call flat_(base,window,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	error=tmperr
	call modify_ (base, xcode, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	return
c
c	errors
c	======
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine edit2_(base, xcode, window, indexit, error)
c	******************************************************
c
	implicit none
c
	integer base, xcode, error
	character*(*) window(*)
	logical indexit
c
c	Description
c	===========
c
c	Given  a  perhaps  modified record in WINDOW the new version
c	is re-written into BASE under XCODE, of course.
c
c	Top secret ! If ERROR comes in as -16381744 no validation is
c	performed upon the user's data.
c
c	It calls EDIT to do it, but enables temporary use/no-use of indexes
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
c
	logical oldidx
c
c	begin
c	=====
c
c	Save current global status
c
	oldidx=s$set(s$inde)
c
	if (indexit) then
	   s$set(s$inde)=.true.
	else
	   s$set(s$inde)=.false.
	endif
c
	call edit_(base, xcode, window, error)
c
c	Restore status
c
	s$set(s$inde)=oldidx
c
	return
c
	end
c
c
c
c
	subroutine fnext_(base, xcode, alive, image, eos, error)
c	********************************************************
c
	implicit none
c
	integer base, xcode, alive, error
	logical eos
	character*(*) image
c
c	Description
c	===========
c
c	Gives next record in sequence in data BASE. XCODE is therefore
c	an  output variable.But if XCODE comes in as zero one wants to
c	reset, ie ,  start  from  the first valid record. When no more
c	records are available  EOS  will  become  true, of  course.
c	ALIVE isn't used anymore.
c	The  fields are gievn back flattened in IMAGE.
c	If something wrong ERROR will not be zero.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBUG.OWN'
c
	integer code, io, m, k, recor, long, iprot
	logical incach
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FNEXT')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90001
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
c	see if we must re-start or carry on with next record
c
	eos=.false.
c
	if (xcode.eq.0) then
	   recor=d$unus
	else
	   recor=d$next(base)
	endif
c
c	loop until a suitable record is found
c
1	continue
	recor=recor+1
c
c	see if finished
c
	m=d$last(base)
	if (recor.gt.m) then
	   eos=.true.
	   xcode=0
	   return
	else
	   d$next(base)=recor
	endif
c
c	ok, go ahead
c
	long=d$recl(base)
c
	read( io,rec=recor,fmt='(a)',err=90002 )DBUF(1:long)
	if (d$crpt(base).eq.0) call uncript_(DBUF,long)
	unlock(unit=io,err=321)
321	continue
c
c	see if alive killed.
c
	if (DBUF(1:1).eq.' ') then
c	   ok				!alive record returned
	elseif (DBUF(1:1).eq.'?') then
	   goto 1
	else
	   goto 90003
	endif
c
	image(1:)=DBUF(1:)
	code=recor-d$offs(base)
	call in3ex_(base,code,xcode,error)
	if (error.ne.0) return		!error, carry
c
c	update cache if not there
c
	incach=.false.
	do 1001 k=1,x$cach
	   if (code.eq.d$cdch(k).and.base.eq.d$bsch(k)) then
	      incach=.true.
	      DBUF(1:long)=d$cach(k)(1:long)
	      if (d$crpt(base).eq.0) call uncript_(DBUF,long)
	      goto 100		!break now !!!
	   endif
1001	continue
c
	if (.not.incach) then
	   d$cnch=d$cnch+1
	   if (d$cnch.gt.x$cach) d$cnch=1
	   d$bsch(d$cnch)=base
	   d$cdch(d$cnch)=code
	   d$cach(d$cnch)(1:long)=DBUF(1:long)
	   if (d$crpt(base).eq.0) call cript_(d$cach(d$cnch),long)
	endif
100	continue
c
c	see protection
c
	if (d$prt(base).eq.0) then
c	   no protection
	else
	   do 10 iprot=1,d$nfld(base)
	     if (d$prfl(iprot,base).eq.prtno)
	1      image(d$pos(iprot,base):
	1            d$pos(iprot,base)+d$siz(iprot,base)-1)=' '
10	   continue
	endif
c
	return
c
c	errors
c	======
c
c	invalid base number
90001	continue
	error=1
	goto 99000
c
c	problems reading DBF record
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	goto 99000
c
c	gross internal error, can't understand mark in record
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=3
	goto 99000
c
99000	continue
	call errset_('FNEXT',error)
c
	unlock(unit=io,err=3211)
3211	continue
c
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fastnx_(base, xcode, image, eos, error)
c	**************************************************
c
	implicit none
c
	integer base, xcode, alive, error, iprot
	logical eos
	character*(*) image
c
c	Description
c	===========
c
c	Gives next record in sequence in data BASE. XCODE is therefore
c	an  output variable.But if XCODE comes in as zero one wants to
c	reset, ie ,  start  from  the first valid record. When no more
c	records are available  EOS  will  become  true, of  course.
c	This procedure returns any data base record, alive or killed,
c	as fast as possible (doesn't update the cache). Usually used
c	by unload procedures.
c	The  fields are gievn back flattened in IMAGE.
c	If something wrong ERROR will not be zero.
c
c	If unrecoverable record (read error), first position will hold "\".
c	Otherwise, " " if alive record, "?" if killed record.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer code, io, m, k, recor, long
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FASTNX')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90001
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
c	see if we must re-start or carry on with next record
c
	eos=.false.
c
	if (xcode.eq.0) then
	   recor=d$unus
	else
	   recor=d$next(base)
	endif
c
	recor=recor+1
c
c	see if finished
c
	m=d$last(base)
	if (recor.gt.m) then
	   eos=.true.
	   xcode=0
	   return
	else
	   d$next(base)=recor
	endif
c
	long=d$recl(base)
c
	if (long.gt.len(image)) goto 90002	!doesn't fit
c
	read( io,rec=recor,fmt='(a)',err=66)image(1:long)
	if (d$crpt(base).eq.0) call uncript_(image,long)
	unlock(unit=io,err=321)
321	continue
c
c	see if alive or killed
c
	if (image(1:1).eq.' '.or.
	1   image(1:1).eq.'?'   ) then
c	   ok
	else
	   goto 77
	endif
c
	goto 100			!everything ok
c
66	continue
c
	image(1:)=' '
c
77	continue
c
	image(1:1)='\'			!unrecoverable data
c
100	continue
c
	code=recor-d$offs(base)
	call in3ex_(base,code,xcode,error)
	if (error.ne.0) return		!error, carry
c
c	see protection
c
	if (d$prt(base).eq.0) then
c	   no protection
	else
	   do 10 iprot=1,d$nfld(base)
	     if (d$prfl(iprot,base).eq.prtno)
	1      image(d$pos(iprot,base):
	1            d$pos(iprot,base)+d$siz(iprot,base)-1)=' '
10	   continue
	endif
c
	return
c
c	errors
c	======
c	invalid base number
90001	continue
	error=1
	goto 99000
c	wrong argument, record doesn't fit
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	goto 99000
c
99000	continue
	call errset_('FASTNX',error)
c
	unlock(unit=io,err=3211)
3211	continue
c
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine next_(base, xcode, alive, window, eos, error)
c	********************************************************
c
	implicit none
c
	integer base, xcode, alive, error
	logical eos
	character*(*) window(*)
c
c	Description
c	===========
c
c	Exactly as FNEXT but giving the fields unflattened.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('NEXT')
	error=0				!clear error
c
c	call FNEXT for actual work
c
	call fnext_ (base, xcode, alive, d$xbuf, eos, error)
	if (error.ne.0) goto 95000
c
	call unflat_(base,window,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	return
c
c	errors
c	======
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine kill_(base, xcode, error)
c	************************************
c
	implicit none
c
	integer base, xcode, error
c
c	Description
c	===========
c
c	Record XCODE is removed from BASE, ie, ceases to exist.
c	Therefore it is NOT recoverable !!! Its  position will
c	be used at a later append.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
c
	external istrip_
	integer istrip_
	integer code,io,m1,m2,recor,long,reclnk,head,tail,next,lim
	integer val,l1,l2,k,iprot
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('KILL')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90001
c
c	and open for update
c
	if (d$pid(base).le.0) goto 90009
c
c	see if code is valid
c
	call ex3in_(base,xcode,code,error)
	if (error.ne.0) goto 90006
	m1=d$unus-d$offs(base)+1
	m2=d$last(base)-d$offs(base)
	if (code.lt.m1.or.code.gt.m2) goto 90002
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
c	see protection
c
	if (d$prt(base).eq.0) then
c	   no protection
	else
	   do 10 iprot=1,d$nfld(base)
	      if (d$prfl(iprot,base).ne.prtrw) goto 90010
10	   continue
	endif
c
c	ok, go ahead
c
	long=d$recl(base)
c
	recor=code+d$offs(base)
	read( io,rec=recor,fmt='(a)',err=90003)d$xbuf(1:long)
	if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
c
c	must be alive to be killed
c
	if (d$xbuf(1:1).eq.'?') then
	   goto 90004
	elseif (d$xbuf(1:1).ne.' '.and.d$xbuf(1:1).ne.'*') then
	   goto 90005
	endif
c
c	clean thoroughly
c
	d$xbuf(1:)=' '
c
c	link list of dead records at the tail
c
	head=d$head(base)
	tail=d$tail(base)
c
	if (head.eq.0) then
	   head=recor
	   tail=head
	   d$xbuf(1:long)=' '				!the head of the list
	   write(d$xbuf,fmt='(i10)',err=90007) head
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	   write(io,rec=34,fmt='(a)',err=90007) d$xbuf(1:long)
	else						!previous last record
	   d$xbuf(1:long)=' '
	   write(d$xbuf,fmt='(''?'',i9)',err=90008) recor
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	   write( io,rec=tail,fmt='(a)',err=90008)d$xbuf(1:long)
	endif
c
	d$xbuf(1:long)=' '				!tail of the list
	write(d$xbuf,fmt='(i10)',err=90007) recor
	if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	write(io,rec=4,fmt='(a)',err=90007) d$xbuf(1:long)
c
	d$xbuf(1:long)=' '				!the record itself
	write(d$xbuf,fmt='(''?'',i9)',err=90008) head
	if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	write( io,rec=recor,fmt='(a)',err=90008)d$xbuf(1:long)
c
	d$head(base)=head
	d$tail(base)=recor
c
	unlock(unit=io,err=321)
321	continue
c
c	clean from cache if record is there
c
	do 1001 k=1,x$cach
	   if (code.eq.d$cdch(k).and.base.eq.d$bsch(k)) then
	      d$bsch(k)=0
	      d$cdch(k)=0
	      d$cach(k)(1:)=' '
	      goto 100		!break now !!!
	   endif
1001	continue
100	continue
c
c	update context in memory and disk
c
	d$kill(base)=d$kill(base)+1
	d$xbuf(1:)=' '
	write(d$xbuf,fmt='(i10)',err=90007) d$kill(base) 	!#killed
	if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	write(io,rec=6,fmt='(a)',err=90007) d$xbuf(1:long)
c
c	delete from index files if any and indexes are set ON
c
	if (s$set(s$inde)) then
	   do 1002 k=1,d$nfld(base)
	      if (d$idx(k,base).ne.0) then
	         call opnx_(base,k,error)
	         if (error.ne.0) goto 95000
	         call delx_(base,k,val,d$xbuf(1:),code,error)
	         if (error.ne.0) goto 95000
	         call clsx_(base,k,error)
	         if (error.ne.0) then	!ignore error
	            call errclr_('KILL')
	            error=0
	         endif
	      endif
1002	   continue
	endif
c
	return
c
c	errors
c	======
c
c	invalid base number
90001	continue
	error=1
	goto 99000
c	invalid code number ("out of bounds")
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90022) xcode
90022	continue
	error=2
	goto 99000
c	problems reading DBF record
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=3
	goto 99000
c	record already killed
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90044) xcode
90044	continue
	error=4
	goto 99000
c	gross internal error, can't understand mark in record
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=5
	goto 99000
c	invalid code number (wrong check digit)
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90066) xcode
90066	continue
	error=6
	goto 99000
c	problems writing DBF record #4 or #6
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=7
	goto 99000
c	problems writing .DBF record
90008	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=8
	goto 99000
c	base not open for update
90009	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=9
	goto 99000
c	protected fields, can't kill record
90010	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=10
	goto 99000
99000	continue
	call errset_('KILL',error)
c
	unlock(unit=io,err=3211)
3211	continue
c
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine kill2_(base, xcode, indexit, error)
c	**********************************************
c
	implicit none
c
	integer base, xcode, error
	logical indexit
c
c	Description
c	===========
c
c	Record XCODE is removed from BASE, ie, ceases to exist.
c	Therefore it is NOT recoverable !!! Its  position will
c	be used at a later append.
c
c	It calls KILL to do it, but enables temporary use/no-use of indexes
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
	include 'OWN:DBAGB.OWN'
c
c	begin
c	=====
c
	logical oldidx
c
c	Save current global status
c
	oldidx=s$set(s$inde)
c
	if (indexit) then
	   s$set(s$inde)=.true.
	else
	   s$set(s$inde)=.false.
	endif
c
	call kill_(base, xcode, error)
c
c	Restore status
c
	s$set(s$inde)=oldidx
c
	return
c
	end
c
c
c
c
	subroutine title_ (base, text, error)
c	************************************
c
	implicit none
c
	integer base, error
	character*(*) text
c
c	Description
c	===========
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer io
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('TITLE')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90000
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
	return
c
c	errors
c	======
c
c	invalid base number
c
90000	continue
	error=1
	goto 99000
c
99000	continue
	call errset_('TITLE',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine newttl_(base, text, error)
c	*************************************
c
	implicit none
c
	integer base, error
	character*(*) text
c
c	Description
c	===========
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer io
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('NEWTTL')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90000
c
c	recover .DBF io channel
c
	io=d$bio(base)
c
	return
c
c	errors
c	======
c
c	invalid base number
c
90000	continue
	error=1
	goto 99000
c
c
99000	continue
	call errset_('NEWTTL',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine lckbas_(base, error)
c	*******************************
c
	implicit none
c
	integer base, error
c
c	Description
c	===========
c
c	The base with channel BASE is re-opened, if needed, in UPDATE
c	mode. No-op if already opened in update mode.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer io
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('LCKBAS')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90000
c
c	if already opened for update do nothing
c
c	if (d$base(base).eq.0) return
c
c	recover .DBF channel
c
	io=d$bio(base)
c
	return
c
c	errors
c	======
c
c	invalid base number
c
90000	continue
	error=1
	goto 99000
c
99000	continue
	call errset_('LCKBAS',error)
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine ulkbas_(base, error)
c	*******************************
c
	implicit none
c
	integer base, error
c
c	Description
c	===========
c
c	The base with channel BASE is re-opened, if needed, in NOUPDATE
c	mode. No-op if already opened in noupdate mode.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	integer io
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ULKBAS')
	error=0				!clear error
c
c	see if base is valid
c
	if (base.le.0.or.base.gt.d$b) goto 90000
c
c	if already opened for noupdate do nothing
c
c	if (d$base(base).eq.0) return
c
c	recover .DBF channel
c
	io=d$bio(base)
c
	return
c
c	errors
c	======
c
c	invalid base number
c
90000	continue
	error=1
	goto 99000
c
c	Own errors
c
99000	continue
	call errset_('ULKBAS',error)
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine newbas_(base, bname, inuse)
c	**************************************
c
	implicit none
c
	integer base
	character*(*) bname
	logical inuse
c
c	Description
c	===========
c
c	Gives back a  new "base" channel BASE for base BNAME.
c	If the  base  is  already  associated with a channel
c	the channel in use is given back and INUSE is set to
c	true.  INUSE false  means  that  a  free  channel is
c	available but the base BNAME wasn't  associated with
c	any channel. BASE = 0 means that BNAME was not found
c	in  memory  but there is no more room for a new base.
c
c	Note that  BNAME  is an user supplied data base name.
c	( NOT the perhaps modified name by INI file ).
c
c	This  procedure is normally  used via call to opnbas.
c	However, it  may be used to check if some base is or
c	is  not in  memory  context.  If the base is  NOT in
c	memory context, the procedure FREBAS SHOULD be called
c	in order to clean context !!!.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	external istrip_
	integer istrip_
	integer maybe, k, where, lim1, lim2
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('NEWBAS')
c
	maybe=0
	lim2=istrip_(bname)				!name size
	do 1001 k = 1, d$b
	   where=k
	   if (d$base(k).eq.0) then
	      maybe=k
	   else
	      lim1=istrip_(d$unam(k))			!existing name size
	      if (lim1.eq.lim2) then
	         if (d$unam(k)(1:lim1).eq.bname(1:lim2)) goto 10
	      endif
	   endif
1001	continue
c
c	name not found in memory
c	------------------------
c
	if (maybe.eq.0) then
	   base=0				!no more room
	else
	   base=maybe				!new base channel
	   d$base(base)=1			!allocated to someone
	   d$unam(base)(1:)=' '			!just in case...
	endif
c
	inuse=.false.				!not in use, anyway
c
	goto 20					!return
c
c	base name already exists in memory
c	----------------------------------
c
10	continue
	base=where				!old base channel
	inuse=.true.				!in use
	goto 20					!return
c
20	continue
c
	return
c
c	errors
c	======
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine frebas_(base)
c	************************
c
	implicit none
c
	integer base
c
c	Description
c	===========
c
c	Frees the "base"  channel BASE. If BASE has a
c	silly value BASE is given back as zero.
c	It is normally used via OPNBAS/CLSBAS only
c	(exceptions: DELETE database; STREDT; ZXLIM; JOIN)
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbaga2.own'
	include 'own:dbagsr.own'
c
	integer k
c
c	begin
c	=====
c
c	don't! init error handling
c	--------------------------
c
cxxxx	call errclr_('FREBAS')
c
c	N.B. FREBAS is frequently used after error return from other
c	     procedures, and error codes should be preserved!.
c
	if (base.gt.0.and.base.le.d$b) then
c
c	   regular bases stuff
c
	   if (base.eq.c$base) then
	      call i$scur_(0,0,0)	!not current anymore
	   endif
	   d$rio(base)=0
	   d$bio(base)=0
	   d$base(base)=0
	   d$unam(base)(1:)=' '
	   d$pid(base)=0
	   d$kill(base)=0
	   d$head(base)=0
	   d$tail(base)=0
	   d$race(base)=0
	   d$csig(base)=0
	   do k = 1, d$nfld(base)
	      d$dbio(k,base)=0
	      d$mast(k,base)=0
	      d$idx(k,base)=0
	      d$ixio(k,base)=0
	   enddo
	   d$u1st(base)=0		!first user data field
	   d$udnf(base)=0		!number of user data fields
	   ds$def(base)=0
	   ds$fmt(base)=0
c
c	   other creatures now
c
	   pp$fat(base)=0		!father position
	   pp$nxt(base)=0		!next position
	   pp$lst(base)=0		!last position
c
	   d$ownb(base)=' '		!owner base
	   d$pdim(base)=0		!dimension
	   d$psiz(base)=0		!size of elements
	   d$pdec(base)=0		!decimal places
c
	endif
c
	return
c
c	errors
c	======
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine opdbf_(kanal,base,moi,fspec,long,update,error)
c	*********************************************************
c
	implicit none
c
	character*(*) fspec
	integer kanal, base, moi, long, update, error
c
c	Description
c	===========
c
c	Opens file in  FSPEC, using  channel  KANAL, "share" if UPDATE=1 and
c	"share",  "readonly"  if UPDATE=0. Opdbf also tries to lock the file
c	if UPDATE=1 (locking never  fails if base file not opened) . BASE is
c	needed  to  update,  eventually, the current owner in memory context.
c	MOI is my pid. In LONG the record length is given back.
c
c	Error = 0	ok
c	      > 0	opdbf error
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	external istrip_
	integer istrip_
	integer lui
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('OPDBF')
	error=0						!clear error
c
	inquire (file=fspec,recl=long)
c
	if (update.eq.1) then				!update mode
c							!-----------
	   open(unit=kanal, file=fspec, status='old',
     1     organization='relative', access='direct', form='formatted',
     1     shared,
     1     recl=long, err=90001)
c
c	   see if base is cripted (rec=33)
c
	   read(kanal,rec=33,fmt='(a)',err=90003) d$xbuf(1:long)
	   call uncript_(d$xbuf,long)
	   read(d$xbuf,fmt='(i10)',err=90003) d$crpt(base)
c							!try to lock the base
	   read(kanal,rec=29,fmt='(a)',err=90003) d$xbuf(1:long)
	   if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	   read(d$xbuf,fmt='(i10)',err=90003) lui	!get current owner
c
	   if (lui.eq.0) then
	      d$xbuf(1:)=' '
	      write (d$xbuf,fmt='(i10)',err=90003) moi
	      if (d$crpt(base).eq.0) call cript_(d$xbuf,long)
	      write(kanal,rec=29,fmt='(a)',err=90003) d$xbuf(1:long)
	      read (kanal,rec=29,fmt='(a)',err=90003) d$xbuf(1:long)
	      if (d$crpt(base).eq.0) call uncript_(d$xbuf,long)
	      read (d$xbuf,fmt='(i10)',err=90003) lui
	      if (moi.ne.lui) then
	         goto 90002
	      endif
	   else
	      if (moi.ne.lui) goto 90002		!locked by another guy
	   endif
c
	   d$pid(base)=moi				!set memory context
c
	else						!non-update mode
c							!---------------
	   open(unit=kanal, file=fspec, status='old',
     1     organization='relative', access='direct', form='formatted',
     1     shared, readonly,
     1     recl=long, err=90001)
c
c	   see if base is cripted (rec=33)
c
	   read(kanal,rec=33,fmt='(a)',err=90003) d$xbuf(1:long)
	   call uncript_(d$xbuf,long)
	   read(d$xbuf,fmt='(i10)',err=90003) d$crpt(base)
c
	endif
c
	return
c
c	Errors
c	======
c
c	error opening dbf file
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=1
	goto 99000
c
c	base currently locked by another user
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	goto 99000
c
c	error reading dbf file
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=3
	goto 99000
c
99000	continue
	call frebas_(base)		!clear context anyway...
	call errset_('OPDBF',error)	!set error
	return
c
c	formats
c	=======
c
	include 'fmt:opdbf.fmt'
c
	end
c
c
c
c
	subroutine getppn_(base,fspec,error)
c	************************************
c
c	Written by Paulo Alexandre Gonalves 7/01/88
c
	implicit none
c
	integer base,error
	character*(*) fspec
c
c	Description
c	===========
c
c	Tries to find a  .PPN  file.  If  none exists ERROR=1.
c	Otherwise it tries to load USER's profile into d$prfl,
c	and  type  of  user into WHO (remember 0 is GOD, 1 is
c	owner of BASE, 2 is owner of records). If USER  can't
c	be found ERROR=2 , if all ok ERROR=0.
c
c	var
c	===
c
	include 'OWN:DBAG0.OWN'
c
	external istrip_
	integer istrip_
	integer k, l, drama, lim
	logical itdoes
	character*12 nowname,user
	integer i,long
	integer dprfl(d$f),dwho
c
c	begin
c	=====
c
c	init error handling
c
	call errclr_('GETPPN')
	error=0				!clear error
c
c	do real work
c
	call myself_(user)
	call givext_(fspec, '.PPN')
	inquire(file=fspec,recl=long,exist=itdoes)
	if (itdoes) then
	   call newc_(k)
	   if (k.le.0) goto 90003
	   open(unit=k,file=fspec,status='old',	
     1     organization='indexed', access='keyed',
     1     form='unformatted', key=(1:12:character),
     1	   readonly,shared,err=90002)
	   call uc_ (user)
	   call cript_(user,12)
	   read(unit=k,keyeq=user,err=90002)nowname,dwho,
     1          (dprfl(i),i=1,d$nfld(base))
	   do 10,i= 1, d$nfld(base)
	      d$prfl(i,base)=dprfl(i)
10	   continue
	   d$who(base)=dwho
	else
	   goto 90001
	endif
c
c	chap found
c
12	continue
	close(unit=k)
	call freec_(k)
	k=0				!just in case...
	return
c
c	errors
c	======
c
c	.PPN file not found
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=1
	goto 99000
c
c	user not in .PPN file
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	error=2
	close(unit=k)
	call freec_(k)
	k=0				!just in case...
	goto 99000
c
c	no more i/o channels for .PPN file
90003	continue
	error=3
cxxx	close(unit=k)
cxxx	call freec_(k)
cxxx	k=0				!just in case...
	goto 99000
c
99000	continue
	call errset_('GETPPN',error)
	return
c
	end
c
c
c
c
