c	DBAG1.FOR
c	*********
c
c	Context questioning primitives for the DBAG system
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	Summary of procedure calls:
c
c	zrace	race and dimension of "creature"
c
c	znfld	number of user fields
c	zfield	nearly everything you want to know about a field
c
c	zfirst	first available record number
c	zlast	last  available record number
c	zstart	first possible record number
c	zend	last  possible record number
c	zrec	number of alive records
c	zrec2	number of alive and killed records
c	znext	next possible logical record number
c
c	zkind	type of field
c	zmast	master field, 0 if none specified (if o.d.b field type)
c	zsee	field to see, 0 if none specified (if o.d.b field type)
c	zidx	whether field is indexed or not
c	zdeci	number of decimal places for decimal fields
c	zprot1	protection of field for owner
c	zprot2	protection of field for world
c	zfnam	description of field
c	zmne	mnemonic for field
c	znum	converts field mnemonic into field number
c	zxlim	limits for field
c	zxlim2	limits for field, but explicit protection failure argument
c	zsize	size for field
c	zmndt	1 if field is mandatory
c	zxdef	numeric default value for field
c	zcdef	text default value for field
c
c	zfile	complete file specification for data base files
c	zname	user supllied data base name
c	zbnum	given the user supllied base name tells the number
c	ztitl	description of data base
c	zfroz	0 if killed records available when appendfing, 1 if not
c	zerr	tells in detail where an error occurred
c	zerr2	tells error mesage where an error occurred
c	zchkd	tells whether record numbers have check digit
c	zsear	current search for base
c
c
c
	subroutine zrace_(base,race,irace,idim,isize,ideci,error)
c	*********************************************************
c
	implicit none
c
	integer base, irace, idim, isize, ideci, error
	character*(*) race
c
c	Description
c	===========
c
c	Returns RACE (index IRACE) as "creature" race of BASE, as well
c	as its dimesion, size and decimal places.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	integer lim1
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZRACE')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	irace=d$race(base)
	idim=d$pdim(base)
	isize=d$psiz(base)
	ideci=d$pdec(base)
c
	if (irace.eq.0) then
	   irace=1				!don't confuse anybody
	endif
c
	if (idim.eq.0) then
	   idim=1				!don't confuse anybody
	endif
c
	race(1:)=' '
	if (irace.le.0.or.
	1   irace.gt.r$top) then
	   race='? UNKNOWN CREATURE ( ET ? )'
	else
	   race=d$crea(irace)
	   lim1=istrip_(race)
	   if (irace.eq.r$si.or.
	1      irace.eq.r$sr.or.
	1      irace.eq.r$sr8.or.
	1      irace.eq.r$sd.or.
	1      irace.eq.r$sl.or.
	1      irace.eq.r$sc    ) then
	      if (lim1+8.le.len(race)) then	!if SERIES, add dimension
	         race(lim1+2:lim1+2)='('
	         if     (idim.eq.1) then
	            race(lim1+3:lim1+3)='*'
	            race(lim1+4:lim1+4)=')'
	         elseif (idim.eq.2) then
	            race(lim1+3:lim1+5)='*,*'
	            race(lim1+6:lim1+6)=')'
                 elseif (idim.eq.3) then
	            race(lim1+3:lim1+7)='*,*,*'
	            race(lim1+8:lim1+8)=')'
	         endif
	      endif
	   endif
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZRACE',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine znfld_(base,x,error)
c	*******************************
c
	implicit none
c
	integer base, x, error
c
c	Description
c	===========
c
c	Returns X as number of fields of base BASE.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZNFLD')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	x=d$nfld(base)				!store value
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZNFLD',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zfield_(base,field,xtype,xsize,xdec,xver,xdef,xoblg,
     1                      xkey,error)
c	**************************************************************
c
	implicit none
c
	integer base,field,xtype,xsize,xdec,xver,xdef,xoblg,xkey,error
c
c	Description
c	===========
c
c	Returns XTYPE, XSIZE and XDEC as type, size and (if decimal) decimal
c	places of field FIELD in base BASE. XVER=1 if upper-lower limits
c	are defined for FIELD, otherwise =0. XDEF=1 if default value was
c	defined for FIELD, otherwise xdef=0. XOBLG=1 if field is mandatory,
c	otherwise =0. XKEY=1 if field is KEY, otherwise =0.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer ix,l,lim,b2,mast,b,f,pos1,pos2
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZFIELD')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	b=base
	f=field
	b2=d$dbio(f,base)
	mast=d$mast(f,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
c
	call zkind_(b,f,xtype,error)
	if (error.ne.0) return		!error, carry
	call zsize_(b,f,xsize,error)
	if (error.ne.0) return		!error, carry
	if (xtype.eq.n$.or.xtype.eq.x$) then
	   xsize=xsize-1			!fix size if integer or decimal
	endif
	if (xtype.eq.x$) then
	   call zdeci_(b,f,xdec,error)
	   if (error.ne.0) return		!error, carry
	else
	   xdec=0
	endif
	call zmndt_(b,f,xoblg,error)
	if (error.ne.0) return		!error, carry
	if (xtype.eq.n$.or.
     1      xtype.eq.db$.or.
     1      xtype.eq.x$.or.
     1      xtype.eq.d$.or.
     1      xtype.eq.r$    ) then
	   xver=1
	else
	   xver=0				!verify limits "bit"
	endif
	call zidx_(b,f,ix,error)
	if (error.ne.0) return		!error, carry
	if (ix.eq.2) then
	   xkey=1
	else
	   xkey=0				!field is KEY
	endif
	pos1=d$pos(f,b)
	pos2=pos1+d$siz(f,b)-1
	if (xtype.eq.r$) then
	   if (d$dflt(b)(pos1:pos2).eq.rnulltxt) then
	      xdef=0
	   else
	      xdef=1
	   endif
	elseif (xtype.eq.r8$) then
	   xdef=0
	else
	   l=istrip_(d$dflt(b)(pos1:pos2))
	   if (l.eq.0) then
	      xdef=0
	   else
	      xdef=1
	   endif
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) f
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZFIELD',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine zlast_(base,alive,xcode,error)
c	*****************************************
c
	implicit none
c
	integer base, alive, xcode, error
c
c	Description
c	===========
c
c	Returns XCODE = last logical record# of base BASE.
c	ALIVE isn't used anymore.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer x, xmax, xmin, k, io, long, recor
	logical done
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZLAST')
c
	error=0					!clear error
c
	alive=0
	xcode=0					!flag no record found
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	First and last records of base
c
	call zend_(base,x,error)			!last record of base
	if (error.ne.0) return			!error, carry
	if (x.le.0) then
	   return				!base is empty
	endif
c
	call ex3in_(base,x,xmax,error)
	if (error.ne.0) return			!error, carry
c
	call zstart_(base,x,error)		!first record of base
	if (error.ne.0) return			!error, carry
c
	call ex3in_(base,x,xmin,error)
	if (error.ne.0) return			!error, carry
c
	io=d$bio(base)				!recover .DBF i/o channel
	long=d$recl(base)			!and record size
c
c	Loop until acceptable record (0 if none) found
c
	do 1001 k = xmax , xmin , -1
	   recor=k+d$offs(base)
	   read( io,rec=recor,fmt='(a)',err=90003)d$xbuf(1:long)
	   unlock(unit=io,err=321)
321	   continue
	   if (d$crpt(base).eq.0) call uncript_(d$xbuf,1)
	   if ((d$xbuf(1:1).eq.' ')) then	!record is alive
	      x=k
	      goto 100
	   endif
1001	continue
c
	return					!none found, return
c
100	continue
c
c	"redo" check digit if it's the case
c
	call in3ex_(base,x,xcode,error)
	if (error.ne.0) return			!error, carry
c
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	error reading .dbf file
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	error=3
	goto 99000
99000	continue
	call errset_('ZLAST',error)		!my own error, now...
c
	unlock(unit=io,err=3211)
3211	continue
c
	return					!return
c
c	formats
c	=======
c
 	end
c
c
c
c
	subroutine zfirst_(base,alive,xcode,error)
c	******************************************
c
	implicit none
c
	integer base, alive, xcode, error
c
c	Description
c	===========
c
c	Returns XCODE = first logical record# of base BASE.
c	ALIVE isn't used anymore.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer x, xmax, xmin, k, io, long, recor, lim
	logical done
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZFIRST')
c
	error=0					!clear error
c
	alive=0
	xcode=0					!flag no record found
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	First and last records of base
c
	call zend_(base,x,error)		!last record of base
	if (error.ne.0) return			!error, carry
	if (x.le.0) return			!base is empty
c
	call ex3in_(base,x,xmax,error)
	if (error.ne.0) return			!error, carry
c
	call zstart_(base,x,error)		!first record of base
	if (error.ne.0) return			!error, carry
c
	call ex3in_(base,x,xmin,error)
	if (error.ne.0) return			!error, carry
c
	io=d$bio(base)				!recover .DBF i/o channel
	long=d$recl(base)			!and record size
c
c	Loop until acceptable record (0 if none) found
c
	do 1002 k = xmin, xmax, 1
	   recor=k+d$offs(base)
	   read( io,rec=recor,fmt='(a)',err=90003)d$xbuf(1:long)
	   unlock(unit=io,err=321)
321	   continue
	   if (d$crpt(base).eq.0) call uncript_(d$xbuf,1)
	   if ((d$xbuf(1:1).eq.' ')) then	!record is alive
	      x=k
	      goto 100
	   endif
1002	continue
c
	return					!none found
c
100	continue
c
c	"redo" check digit if it's the case
c
	call in3ex_(base,x,xcode,error)
	if (error.ne.0) return			!error, carry
c
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	error reading .dbf file
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	error=3
	goto 99000
99000	continue
	call errset_('ZFIRST',error)		!my own error, now...
	unlock(unit=io,err=3211)
3211	continue
c
	return					!return
c
c	formats
c	=======
c
 	end
c
c
c
c
	subroutine zend_(base,xcode,error)
c	**********************************
c
	implicit none
c
	integer base, xcode, error
c
c	Description
c	===========
c
c	Returns XCODE = last "physically available" record# of base BASE
c	or = 0 if none.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer x
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZEND')
c
	error=0					!clear error
c
	xcode=0					!flag no record found
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	logical record =  physical record - offset
c
	if (d$last(base).eq.d$unus) return	!empty base, return
c
	x=d$last(base) - d$offs(base)		!last record
c
c	see if check digit
c
	call in3ex_(base,x,xcode,error)
	if (error.ne.0) return			!error, carry
c
	return					!return last record
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZEND',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
 	end
c
c
c
c
	subroutine zstart_(base,xcode,error)
c	************************************
c
	implicit none
c
	integer base, xcode, error
c
c	Description
c	===========
c
c	Returns XCODE = first "physically available" record# of base BASE
c	or = 0 if none.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer x
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZSTART')
c
	error=0					!clear error
c
	xcode=0					!flag no record found
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	logical record = physical record - offset
c
	if (d$last(base).eq.d$unus) return	!empty base, return
c
	x=d$unus - d$offs(base) + 1		!first record
c
c	see if check digit
c
	call in3ex_(base,x,xcode,error)
	if (error.ne.0) return
c
	return					!return first record
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZSTART',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zrec_(base,okrec,mkrec,error)
c	****************************************
c
	implicit none
c
	integer base, okrec, mkrec, error
c
c	Description
c	===========
c
c	Returns in OKREC # of alive records.
c	MKREC isn't used anymore.
c	ERROR not =0 if base not open or illegal base number,
c	etc...
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	VAR
c	===
c
	integer whole
c
c	init error handling
c	-------------------
c
	call errclr_('ZREC')
c
	error=0					!clear error
c
	mkrec=0
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	if (d$last(base).eq.d$unus) then
	   okrec=0				!empty base, return 0
	   return
	endif
c
	whole = d$last(base) - d$unus		!the whole world
	okrec = whole - d$kill(base)		!alive records
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZREC',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zrec2_(base,okrec,klrec,error)
c	*****************************************
c
	implicit none
c
	integer base, okrec, klrec, error
c
c	Description
c	===========
c
c	Returns in OKREC # of alive records, in KLREC # of killed records.
c	ERROR not =0 if base not open or illegal base number,
c	etc...
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	VAR
c	===
c
	integer whole
c
c	init error handling
c	-------------------
c
	call errclr_('ZREC2')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	okrec=0					!assume base is "empty"
	klrec=d$kill(base)			!killed records
c
	if (d$last(base).ne.d$unus) then
	   whole = d$last(base) - d$unus	!the whole world
	   okrec = whole - klrec		!alive records
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZREC2',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine znext_(base,xcode,error)
c	***********************************
c
	implicit none
c
	integer base, xcode, error
c
c	Description
c	===========
c
c	Returns  in  XCODE  next available logical record # of BASE.
c	ERROR not =0 if base not open or illegal base number,
c	etc...
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer x,io,tail
	character*10 crap
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZNEXT')
c
	error=0					!clear error
c
	xcode=0					!flag no record found
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	any list of killed records and available ? (brrrr)
c
	if (d$head(base).eq.0.or.
	1   d$froz(base).ne.0   ) then
	   x=d$last(base) + 1			!no, give new position
	else
	   x=d$head(base)			!yes, re-use 1st. in killed list
	endif
c
	x = x - d$offs(base)	!make logical #
c
c	see if check digit
c
	call in3ex_(base,x,xcode,error)
	if (error.ne.0) return
c
	if (xcode.gt.intmax) goto 90004
c
	return					!return next record
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	probblems reading .DBF file
90003	continue
	error=3
	goto 99000
c	record# too big ...
90004	continue
	error=4
	goto 99000
99000	continue
	call errset_('ZNEXT',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zkind_(base,field,x,error)
c	*************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns X as the type of FIELD of BASE.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,b,f,b2,mast
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZKIND')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection if not "field" 0
c
	if (field.gt.0) then
	   if (d$prt(base).ne.0) then		!protection ON
	      if (d$prfl(field,base).eq.prtno) then
	         goto 90003			!protected field
	      endif
	   endif
	endif
c
	if (field.eq.0) then
	   x=1
	else
	   b=base
	   f=field
	   b2=d$dbio(f,base)
	   mast=d$mast(f,base)
	   if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	      b=b2
	      f=mast
	   endif
	   x=d$type(f,b)
	endif
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZKIND',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zmast_(base,field,x,error)
c	*************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns X as the type of FIELD of BASE.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer kind,lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZMAST')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	call zkind_(base,field,kind,error)
	if (kind.ne.db$) then
	   if (d$dbio(field,base).le.0)  goto 90004	!field not o.d.b.
	endif
c
	x=d$mast(field,base)
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	field is not o.d.b.
90004	continue
	error=4
	goto 99000
99000	continue
	call errset_('ZMAST',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zsee_(base,field,x,error)
c	************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns X as the type of FIELD of BASE.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer kind,lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZSEE')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	call zkind_(base,field,kind,error)
	if (kind.ne.db$) then
	   if (d$dbio(field,base).le.0)  goto 90004	!field not o.d.b.
	endif
c
	x=d$see(field,base)
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	field is not o.d.b.
90004	continue
	error=4
	goto 99000
99000	continue
	call errset_('ZSEE',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zidx_(base,field,x,error)
c	************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns X = d$idx(base): 1 if FIELD of BASE is INDEX, 2 if KEY
c	4 if KWIC, 0 if NOT indexed at all.
c	CAUTION: if indexes are SET OFF or not a regular base, returns 
c	always 0!!!.
c	ERROR  not =0 if base not open or illegal base# or illegal
c	field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer lim,b,f,b2,mast
	character*10 race
	integer irace,idim,isize,ideci
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZIDX')
c
	error=0					!clear error
c
	x=0
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
	call zrace_(base,race,irace,idim,isize,ideci,error)
	if (error.ne.0) return			!error, carry
c
	if (irace.ne.r$b) return		!not a regular base
c
c	see protection if not "field" 0
c
	if (field.gt.0) then
	   if (d$prt(base).ne.0) then		!protection ON
	      if (d$prfl(field,base).eq.prtno) then
	         goto 90003			!protected field
	      endif
	   endif
	endif
c
	if (.not.s$set(s$inde)) return		!indexes are SET OFF
c
	if (field.eq.0) then
	   x=0		!make "search for # = " work ... (FORSEM, call zidx...)
	else
	   b=base
	   f=field
	   b2=d$dbio(f,base)
	   mast=d$mast(f,base)
	   if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	      b=b2
	      f=mast
	   endif
	   x=d$idx(f,b)
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZIDX',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zdeci_(base,field,x,error)
c	*************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns, for decimal fields, the number of standard decimal
c	places.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,b,f,b2,mast
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZDECI')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	b=base
	f=field
	b2=d$dbio(f,base)
	mast=d$mast(f,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
c
	x=d$deci(f,b)
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZDECI',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zprot1_(base,field,x,error)
c	**************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns X as owner protection of field FIELD of base BASE.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZPROT1')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	x=d$oprt(field,base)
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZPROT1',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zprot2_(base,field,x,error)
c	**************************************
c
	implicit none
c
	integer base, field, x, error
c
c	Description
c	===========
c
c	Returns X as world protection of field FIELD of base BASE.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZPROT2')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	x=d$wprt(field,base)
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZPROT2',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zfnam_(base,field,xtext,error)
c	*****************************************
c
	implicit none
c
	integer base, field, error
	character*(*) xtext
c
c	Description
c	===========
c
c	Returns X as extended name of field FIELD of base BASE.
c	ERROR not =0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,b,f,b2,mast
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZFNAM')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	b=base
	f=field
	b2=d$dbio(f,base)
	mast=d$mast(f,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
c
	xtext(1:)=d$fdes(f,b)			!store field name
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZFNAM',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zmne_(base,field,xtext,error)
c	****************************************
c
	implicit none
c
	integer base, field, error
	character*(*) xtext
c
c	Description
c	===========
c
c	Returns  XTEXT  as  mnemonic  of field FIELD of base BASE.
c	ERROR not =0 if base not open or illegal base# or illegal
c	field# or protected field.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,b2,mast
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZMNE')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	if (b2.gt.0.and.mast.gt.0) then
	   xtext(1:)=d$fmne(mast,b2)		!store mnemonic
	else
	   xtext(1:)=d$fmne(field,base)		!store mnemonic
	endif
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZMNE',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine znum_(base,field,xtext,error)
c	****************************************
c
	implicit none
c
	integer base, field, error
	character*(*) xtext
c
c	Description
c	===========
c
c	Given XTEXT as a mnemonic, the corresponding FIELD of base BASE
c	is found if it exists and not protected, or FIELD=-1 is given back.
c	ERROR not =0 if base not open or illegal base#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer k,i1,i2
	character*10 mymnem1,mymnem2
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZNUM')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	mymnem1(1:)=' '				!use a copy
	mymnem1=xtext
	call uc8to7_(mymnem1)
	i1=istrip_(mymnem1)
c
c	# id record number, ie, "field" zero
c
	if (mymnem1(1:1).eq.'#'.and.i1.eq.1) then
	   field=0
	   return
	endif
c
	do 1001 k=1,d$nfld(base)
	   field=k
	   mymnem2(1:)=' '			!use a copy
	   mymnem2=d$fmne(k,base)
	   call uc8to7_(mymnem2)
	   i2=istrip_(mymnem2)
	   if (i1.eq.i2) then
	      if (mymnem1(1:i1).eq.mymnem2(1:i1)) goto 13
	   endif
1001	continue
c
c	not found
c
	field=-1
	return
c
c	found, check protection
c
13	continue
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      field=-1				!no access
	   endif
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZNUM',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zfile_(base,xtext,error)
c	***********************************
c
	implicit none
c
	integer base, error
	character*(*) xtext
c
c	Description
c	===========
c
c	Returns XTEXT as full file spec of database BASE.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZFILE')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	xtext(1:)=d$bfil(base)			!database file name
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZFILE',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zname_(base,xtext,error)
c	***********************************
c
	implicit none
c
	integer base, error
	character*(*) xtext
c
c	Description
c	===========
c
c	Returns XTEXT as user supplied name of database BASE.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZNAME')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	xtext(1:)=d$unam(base)			!database file name
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZNAME',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zsear_(base,bname,keys,nkey,error)
c	*********************************************
c
	implicit none
c
	integer base,keys(*),nkey,error
	character*(*) bname
c
c	Description
c	===========
c
c	Given BNAME as the user supllied base name, the
c	corresponding current search is returned as an
c	integer array KEYS with NKEY record numbers.
c	BASE = 0 if no such BASE.
c	KEY = -1 if no current search for BASE.
c
c	CAUTION: In input, NKEY holds current KEYS dimension. If
c	         current search does't fit, the appropriate error
c	         code is returned along with NKEY correctly set !!!.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer io,recnum,irec,mxkey
	logical eobm,sort,fit
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZSEAR')
c
	error=0					!clear error
c
	call zbnum_(base,bname,error)
	if (error.ne.0) goto 990		!error, carry
	if (base.le.0) return			!no such base
c
	mxkey=nkey
	nkey=0
	fit=.true.
c
c	return search bit map as an integer array
c
c	Loop in bit map or sorted bit map
c	---------------------------------
c
	call outk_(%val(bitpnt(base)),3,io)	!hard to read, bitmap...
c
	if (io.gt.0) then
	   sort=.true.				!permanent sort
	else
	   sort=.false.				!no sort at all
	endif
c
	recnum=0				!reset map
	irec=0
	eobm=.false.				!...
	if (sort) then
	   call ordnxt_(%val(bitpnt(base)),irec,eobm,error)!first selected rec.
	   if (error.ne.0) then
	      sort=.false.			!try sequential (no sort file ?)
	      call errclr_('ZSEAR')		!clear error
	   endif
	endif
	if (.not.sort) then
	   call bitnxt_(%val(bitpnt(base)),irec,eobm,error)!first selected rec.
	   if (error.ne.0) goto 990		!error, carry
	endif
c
cwhile	do while (.not.eobm)
1001	continue
	   if (eobm) goto 1002
c
	   call in3ex_(base,irec,recnum,error)!external form
	   if (error.ne.0) goto 990		!error, carry
	   nkey=nkey+1
	   if (nkey.gt.mxkey) then
	      fit=.false.			!doesn't fit, remember
	   else
	      keys(nkey)=recnum
	   endif
c
	   if (sort) then
	      call ordnxt_(%val(bitpnt(base)),irec,eobm,error)
	   else
	      call bitnxt_(%val(bitpnt(base)),irec,eobm,error)
	   endif
	   if (error.ne.0) goto 990		!error, carry
c
	   goto 1001
1002	continue
cwhile	enddo
c
	if (.not.fit) goto 90001
c
	return
c
c	Error, carry
c
990	continue
c
	nkey=0
	return
c
c	errors
c	======
c
c	current search doesn't fit
90001	continue
	error=1
	goto 99000
99000	continue
	call errset_('ZSEAR',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zbnum_(base,bname,error)
c	***********************************
c
	implicit none
c
	integer base, error
	character*(*) bname
c
c	Description
c	===========
c
c	Given BNAME as the user supllied base name, the
c	corresponding base number is found if it exists,
c	and given in BASE or 0 if not found.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer b,k,i1,i2
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZBNUM')
c
	error=0					!clear error
c
	base=0
	call uc_(bname)
	i1=istrip_(bname)
	if (i1.le.0) return
	do 1001 k=1,d$b
	   if (d$base(k).ne.0) then
	      b=k
	      call uc_(d$unam(k))
	      i2=istrip_(d$unam(k))
	      if (i1.eq.i2) then
	         if (bname(1:i1).eq.d$unam(k)(1:i1)) goto 13
	      endif
	   endif
1001	continue
c
c	not found
c
	return
c
c	found
c
13	continue
	base=b
	return					!return
c
c	errors
c	======
c
99000	continue
	call errset_('ZBNUM',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine ztitl_(base,xtext,error)
c	***********************************
c
	implicit none
c
	integer base, error
	character*(*) xtext
c
c	Description
c	===========
c
c	Returns XTEXT as extended description of base BASE.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZTITL')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	xtext(1:)=d$bdes(base)			!database description
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZTITL',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zfroz_(base,x,error)
c	*******************************
c
	implicit none
c
	integer base, x, error
c
c	Description
c	===========
c
c	Returns X=d$froz(base): 0 if killed records are available, 1 if frozen.
c	ERROR not =0 if base not open or illegal base number.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZFROZ')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	x=d$froz(base)				!database description
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZFROZ',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zxlim_(base,field,xmin,xmax,error)
c	*********************************************
c
	implicit none
c
	integer base, field, xmin, xmax, error
c
c	Description
c	===========
c
c	Returns  XMIN,  XMAX  and  as   minimum,   maximum values
c	of  field  FIELD  of  base  BASE.  FIELD  must be integer,
c	or  other  D.B., or  decimal, or  date. If  not appliable,
c	XMIN=XMAX=0.
c	ERROR not = 0 if base not open or illegal base# or illegal
c	field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer type,l,pos1,pos2,lim,f,b,b2,mast
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZXLIM')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	b=base
	f=field
	b2=d$dbio(f,base)
	mast=d$mast(f,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
c
	call zkind_(b,f,type,error)
	if (error.ne.0) return		!error, carry
c
c	must be integer, other D.B., decimal, date, db$ or real
c
	if ( type.eq.n$.or.type.eq.x$.or.type.eq.d$.or.
	1    type.eq.db$.or.type.eq.r$) then
	   xmin=d$min(f,b)
	   xmax=d$max(f,b)
	else
	   xmin=0
	   xmax=0
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	*** obsolete *** can't open other data base (too many bases opened ?)
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90044) field
90044	continue
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+3)=' : '
	d$rinf(lim+4:)=d$fnam(field,base)
	error=4
	goto 99000
99000	continue
	call errset_('ZXLIM',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zxlim2_(base,field,xmin,xmax,protfail,error)
c	*******************************************************
c
	implicit none
c
	integer base, field, xmin, xmax, error
	logical protfail
c
c	Description
c	===========
c
c	Returns  XMIN,  XMAX  and  as   minimum,   maximum values
c	of  field  FIELD  of  base  BASE.  FIELD  must be integer,
c	or  other  D.B., or  decimal, or  date. If  not appliable,
c	XMIN=XMAX=0.
c	ERROR not = 0 if base not open or illegal base# or illegal
c	field#.
c
c	If any field protected, returns PROTFAIL=.true.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZXLIM2')
c
	error=0				!clear error
	protfail=.false.
c
	call zxlim_(base,field,xmin,xmax,error)
c
	if (error.eq.3.and.
	1   d$rsub.eq.'ZXLIM') then	!field out of bounds or protected
	   if (field.ge.1.and.
	1      field.le.d$nfld(base)) then
	      protfail=.true.		!tell him
	      call errclr_('ZXLIM2')
	   endif
	endif
c
	return				!return
c
c	errors
c	======
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zsize_(base,field,size,error)
c	****************************************
c
	implicit none
c
	integer base, field, size, error
c
c	Description
c	===========
c
c	For number-like FIELD of BASE it gives the field size
c	in XDEF. ERROR not = 0 if base not open or illegal base#
c	or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer type,l,pos1,pos2,b2,mast,b,f,lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZSIZE')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
c	must be number-like
c
	b=base
	f=field
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
	size=d$siz(f,b)
c
	return					!return
c
c	errors
c	======
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZSIZE',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zmndt_(base,field,mndt,error)
c	****************************************
c
	implicit none
c
	integer base, field, mndt, error
c
c	Description
c	===========
c
c	For FIELD of BASE it returns MNDT = 1 if mandatory field, 0 otherwise.
c	ERROR not = 0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZMNDT')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	mndt=d$oblg(field,base)
c
	return					!return
c
c	errors
c	======
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZMNDT',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zxdef_(base,field,xdef,error)
c	****************************************
c
	implicit none
c
	integer base, field, xdef, error
c
c	Description
c	===========
c
c	For number-like FIELD of BASE it gives the default value
c	in XDEF. ERROR not = 0 if base not open or illegal base#
c	or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer type,l,pos1,pos2,b2,mast,b,f,lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZXDEF')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
	b=base
	f=field
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
	type=d$type(f,b)
	pos1=d$pos(f,b)			!start position
	pos2=pos1+d$siz(f,b)-1		!end position
	if (type.eq.r$.or.
	1   type.eq.r8$   ) then
	   xdef=0
	else
	   l=istrip_(d$dflt(b)(pos1:pos2))	!size
	   if (type.eq.c$.or.type.eq.l$.or.l.eq.0) then
	      xdef=0
	   else
	      call rdivar_(d$dflt(b)(pos1:pos2),xdef,pos2-pos1+1,error)
	      if (error.ne.0) goto 90004		!read error
	   endif
	endif
c
	return					!return
c
c	errors
c	======
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	internal error (read/write error)
90004	continue
	error=4
	goto 99000
99000	continue
	call errset_('ZXDEF',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zcdef_(base,field,text,error)
c	****************************************
c
	implicit none
c
	integer base, field, error
	character*(*) text
c
c	Description
c	===========
c
c	Returns  TEXT  as  default  value  of field  FIELD of base BASE.
c	FIELD  must  be  string  type. If  not  appliable,  TEXT=spaces.
c	ERROR not=0 if base not open or illegal base# or illegal field#.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer type,pos1,pos2,b2,mast,f,b,lim
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZCDEF')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
c	see protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!protected field
	   endif
	endif
c
c	must be string-like (logical or string proper)
c
	b=base
	f=field
	b=base
	f=field
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	   b=b2
	   f=mast
	endif
	type=d$type(f,b)
	pos1=d$pos(f,b)			!start position
	pos2=pos1+d$siz(f,b)-1		!end position
	if (type.eq.c$.or.type.eq.l$) then
	   text(1:)=d$dflt(b)(pos1:pos2)
	else
	   text(1:)=' '
	endif
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
99000	continue
	call errset_('ZCDEF',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine zerr_(base,bname,rec,field,xtext,error)
c	**************************************************
c
	implicit none
c
	integer base, rec, field, error
	character*(*) bname,xtext
c
c	Description
c	===========
c
c	OBSOLETE !!!
c
c	Returns BNAME, REC and FIELD where an error ocurred,
c	with  corresponding  error message in xtext. Probably the
c	only  procedure  that  doesn't clear or set global errors.
c	Error always =0.
c
c	=====> This procedure is obsolete, you should call ZERR2 instead.
c
c		DBAG doesn't kepp BNAME, REC and FIELD
c
c	=================================================================
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	bname(1:)=' '
	rec  =0
	field=0
c
	call errmsg_(d$rsub,d$erro,xtext,' ')	!error message
c
	return					!return
c
c	errors
c	======
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine zerr2_(xtext,error)
c	******************************
c
	implicit none
c
	integer error
	character*(*) xtext
c
c	Description
c	===========
c
c	Returns XTEXT with  corresponding  error message when an error
c	ocurred.
c	Probably the only  procedure  that  doesn't clear or set global
c	errors.
c	Error always =0.
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errmsg_(d$rsub,d$erro,xtext,' ')	!not hard
c
	return					!return
c
c	errors
c	======
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine zchkd_(base,x,error)
c	*******************************
c
	implicit none
c
	integer base, x, error
c
c	Description
c	===========
c
c	Returns  X. If X = 0  base has no check digit in its
c	record numbers, if 1 it does have.
c	ERROR not =0 if base not open or illegal base number.
c
c	This feature isn't used anymore, returns x=0.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ZCHKD')
c
	error=0					!clear error
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	x=0
c
	return					!return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('ZCHKD',error)		!my own error, now...
	return					!return
c
c	formats
c	=======
c
	end
c
c
c
c
