c	DBAG2.FOR
c	*********
c
c	Field handling primitives for the DBAG system
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984, 1985
c	=========================================================
c
c	Synopsis of procedures :
c
c	fldopn		"opens" a field; meaningful for other D.B.,
c	fldcls		"closes" a field, see above...
c	fldnum		for a field gets its integer numerical "value"
c	fldtxt		for a field gets its text "value"
c	flddec		for a field gets its floating point numerical "value"
c	fldrl4		for a field gets its real*4 numerical "value"
c	fldrl8		for a field gets its real*8 numerical "value"
c	fldall		gets the numerical and string "values" for ALL fields
c	fldlim		gets the minimum and maximum value for a field
c
c	flddb		gets the record# value for other D.B. field
c
c	semi-internal :
c
c	flat		from array of lines to record image
c	unflat		from record image to array of lines
c	cflt		one field from argument to record image
c	cunflt		one field from record image to argument
c	dbnum		o.d.b. field as numerical "value"
c	dbtxt		o.d.b. field as text "value"
c	dbdec		o.d.b. field as decimal "value"
c	xflat		as flat, but in external format
c	xunfla		as unflat, "  "   "        "
c
c
c
c
	subroutine fldopn_(base,field,error)
c	************************************
c
	implicit none
c
	integer base, field, error
c
c
c	Description
c	===========
c
c	FIELD of BASE is open. Only for other D.B. or KEY fields of regular
c	bases or properties is this operation meaningful.  Otherwise it's a
c	noop, no error though.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer b2,b3,upd2,mod2,bmsize,lim,mast,k,xmin,xmax,ix,dbcode
	integer xtype,irace,pdim,psize,pdeci,pos1,pos2,okrec,klrec
	logical inuse,user,eox,outopn
	character*10 race
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDOPN')
	error=0				!clear error
c
c	validate arguments
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
	call zrace_(base,race,irace,pdim,psize,pdeci,error)
	if (error.ne.0) return
c
	if (irace.ne.r$b.and.			!not a regular base
	1   irace.ne.r$pp    ) return		!nor property
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
c	work
c
	call zkind_(base,field,k,error)
	if (error.ne.0) goto 95000
c
	if (k.eq.db$) then		!other D.B.
c
c	   make sure the o.d.b. remains in context (DELETE, CLOSE ...) !!!!!!!
c
	   call newbas_(b3,d$fnam(field,base),inuse)
c
	   if (inuse) then
	      b2=b3
	   else
	      call frebas_(b3)		!it was just to check ...
	      upd2=-1			!don't change update
	      mod2=0
	      call open_(b2,d$fnam(field,base),upd2,mod2,outopn,error)
	      if (error.ne.0) then
	         d$dbio(field,base)=0		!forget the o.d.base
	         goto 90004
	      endif
	   endif
c
	   xmin=d$min(field,base)
	   xmax=d$max(field,base)
	   if (xmin.le.0.or.xmax.le.0) then	!set current field limits
	      call zstart_(b2,xmin,error)
	      if (error.ne.0) then
	         d$dbio(field,base)=0		!forget the o.d.base
	         goto 90004
	      endif
	      call zend_(b2,xmax,error)
	      if (error.ne.0) then
	         d$dbio(field,base)=0		!forget the o.d.base
	         goto 90004
	      endif
	      d$min(field,base)=xmin
	      d$max(field,base)=xmax
	   endif
c
	   d$dbio(field,base)=b2			!db i/o in context
c
cmota	   call opnx_ (base,field,error)		!open index
cmota	   if (error.ne.0) then
cmota	      goto 90007				!can't open indexes
cmota	   endif
c
c	   Open o.d.b. field if that's the case
c
	   mast=d$mast(field,base)			!master field ?
	   if (mast.gt.0) then				!yes, open o.d.b. field
c
	      if (d$type(mast,b2).eq.db$) then
	         d$dbio(field,base)=0			!forget the o.d.base
	         goto 90006				!can't be db$
	      endif
c
	      call zidx_(b2,mast,ix,error)
	      if (ix.ne.2) then				!KEY ?
	         d$dbio(field,base)=0			!forget the o.d.base
	         goto 90008				!not key
	      endif
c
	      call zrec2_(b2,okrec,klrec,error)
	      if (error.ne.0) return			!error, carry
	      if (okrec.gt.0) then			!alive records, check
	         if (.not.s$set(s$inde)) then
	            d$dbio(field,base)=0		!forget the o.d.base
	            goto 90011				!index are SET OFF
	         else
	            call opnx_ (b2,mast,error)		!open index
	            if (error.ne.0) then
	               d$dbio(field,base)=0		!forget the o.d.base
	               goto 90005			!can't open indexes
	            endif
	         endif
	      endif
c
c	      load proper default values
c
	      pos1=d$pos(mast,b2)
	      pos2=pos1+d$siz(mast,b2)
	      xtype=d$type(mast,b2)
	      if (istrip_(d$dflt(b2)(pos1:pos2)).gt.0.or.
	1         xtype.eq.r$.or.
	1         xtype.eq.r8$                           ) then
	         user=.false.				!internal format
	         d$cbuf(1:)=' '
	         d$cbuf=d$dflt(b2)(pos1:pos2)
	         call txtdb_(b2,d$cbuf,dbcode,mast,user,eox,error)!to record#
	         if (error.ne.0.or.
	1            eox           ) then		!not found
	            pos1=d$pos(field,base)
	            pos2=pos1+d$siz(field,base)
	            d$dflt(base)(pos1:pos2)=' '
	         else
	            pos1=d$pos(field,base)
	            pos2=pos1+d$siz(field,base)
	            write (d$dflt(base)(pos1:pos2),'(i10)',err=111) dbcode
	            goto 222
111	            continue
	            d$dflt(base)(pos1:pos2)=' '
222	            continue
	         endif
	      endif
c
	      call clsx_ (b2,mast,error)		!close index
	      if (error.ne.0) then
	         call errclr_('FLDOPN')			!ignore error
	         error=0
	      endif
c
	   endif
c
cmota	   call clsx_ (base,field,error)		!close index
cmota	   if (error.ne.0) then
cmota	      call errclr_('FLDOPN')			!ignore error
cmota	      error=0
cmota	   endif
c
	endif
c
	ix=d$idx(field,base)
	if (ix.eq.2) then				!KEY field
	   call zrec2_(base,okrec,klrec,error)
	   if (error.ne.0) return			!error, carry
	   if (okrec.gt.0) then				!alive records, check
	      if (.not.s$set(s$inde)) then
	         goto 90010				!indexes are SET OFF
	      else
	         call opnx_ (base,field,error)		!open index
	         if (error.ne.0) then
	            goto 90009				!can't open indexes
	         endif
	         call clsx_ (base,field,error)		!close index
	         if (error.ne.0) then
	            call errclr_('FLDOPN')		!ignore error
	            error=0
	         endif
	      endif
	   endif
	endif
c
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	can't open o.d.b.
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$fnam(field,base)		!tell him witch base
	error=4
	goto 99000
c	problems opening o.d.b field (not indexed ?)
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$fnam(field,base)		!tell him witch base
	if (mast.gt.0) then
	   lim=istrip_(d$rinf)
	   d$rinf(lim+1:lim+6)=', fld#'
	   write (d$rinf(lim+7:),fmt='(i3)',err=90055) mast
	endif
90055	continue
	error=5
	goto 99000
c	o.d.b field is also db$
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$fnam(field,base)		!tell him witch base
	if (mast.gt.0) then
	   lim=istrip_(d$rinf)
	   d$rinf(lim+1:lim+6)=', fld#'
	   write (d$rinf(lim+7:),fmt='(i3)',err=90066) mast
	endif
90066	continue
	error=6
	goto 99000
c	db$ field is not indexed
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)			!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90077) field
90077	continue
	error=7
	goto 99000
c	o.d.b field is not KEY
90008	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$fnam(field,base)		!tell him witch base
	if (mast.gt.0) then
	   lim=istrip_(d$rinf)
	   d$rinf(lim+1:lim+6)=', fld#'
	   write (d$rinf(lim+7:),fmt='(i3)',err=90088) mast
	endif
90088	continue
	error=8
	goto 99000
c	KEY field, can't open indexes
90009	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)			!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90099) field
90099	continue
	error=9
	goto 99000
c	KEY field, indexes are SET OFF
90010	continue
	error=10
	goto 99000
c	problems opening o.d.b field - indexes are SET OFF
90011	continue
	error=11
	goto 99000
c
99000	continue
	call errset_('FLDOPN',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldcls_ (base,field,error)
c	*************************************
c
	implicit none
c
	integer base, field, error
c
c
c	Description
c	===========
c
c	Close FIELD of BASE. Meaningful for other D.B. fields of regular
c	bases only.
c	Noop for other types, no error.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer irace,pdim,psize,pdeci,k,b2,lim,xmin,xmax
	character*10 race
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDCLS')
	error=0				!clear error
c
c	validate arguments
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.le.0.or.
     1   	field.gt.d$nfld(base)) then
	   goto 90003				!field out of bounds
	endif
c
	call zrace_(base,race,irace,pdim,psize,pdeci,error)
	if (error.ne.0) return
c
	if (irace.ne.r$b) return		!not a regular base, no-op
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
	d$dbio(field,base)=0			!forget the other base if any
c
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c
c	can't close other data base field
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90044) field
90044	continue
	error=4
	goto 99000
c
99000	continue
	call errset_('FLDCLS',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldnum_ (base,code,alive,field,value,empty,error)
c	************************************************************
c
	implicit none
c
	integer value
c	-------------
	integer base, code, alive, field, error
	logical empty
c
c
c	Description
c	===========
c
c	For  BASE  it  obtains   the  integer  VALUE   (not the  string
c	TEXT values) for  FIELD  of  record  with  CODE. This procedure
c	does the "lookup" of the record itself, doesn't need a previous
c	call   to  LOOKUP  or  FIND.The  user  must make  sure  integer
c	values have meaning for FIELD.
c	ALIVE isn't used anymore.
c	If field is EMPTY (= spaces), EMPTY is returned true; otherwise,
c	it is returned false.
c
c	The VALUE(s) are :
c
c	integer		direct value
c	string		-
c	other d.b.	direct value
c	decimal		integerized value
c	date		841223
c	logical		0 or 1
c	real number	?
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer b2,dbcode,see,k,lim,first,last
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDNUM')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.first.or.
     1   	field.gt.last) then
	   goto 90003				!field out of bounds
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	value=0
	call cunflt_(base,d$cbuf,value,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
c	See if d.b. and other field
c
	b2=d$dbio(field,base)
	see=d$see(field,base)
	if (b2.gt.0.and.		!o.d.b. field
	1   value.gt.0.and.		!record#
	1   see.gt.0       ) then	!and see a field
	   dbcode=value
	   call dbnum_(b2,value,dbcode,see,error)
	   if (error.ne.0) goto 95000
	endif
c
	empty=.false.
	if (istrip_(d$cbuf).le.0) then
	   value=0
	   empty=.true.		!empty field
	   goto 900			!return
	endif
c
900	continue
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c
99000	continue
	call errset_('FLDNUM',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldtxt_ (base,code,alive,field,text,empty,error)
c	***********************************************************
c
	implicit none
c
	character*(*) text
c	------------------
	integer base, code, alive, field, error
	logical empty
c
c
c	Description
c	===========
c
c	For BASE it  obtains   the  string TEXT values (not the integer
c	values ) for  FIELD  of   record   with  CODE.  This  procedure
c	does the "lookup" of the record itself, doesn't need a previous
c	call to  LOOKUP or  FIND.The user must make  sure string values
c	have meaning for FIELD.
c	ALIVE isn't used anymore.
c	For  fields  that  are  other  D.B . the text has the following
c	meaning :  if the  <>  see field  is  non zero, the text is
c	the  text  version  for  that  field  in the other D.B.; if the
c	is  zero, the first string field in other D.B. is looked for.If
c	found  that's  it,  if  not  the  record  number is  given back.
c	(you  didn't  get  it  did you ? Neither did I, try and see the
c	code...).
c	If field is EMPTY (= spaces), EMPTY is returned true; otherwise,
c	it is returned false.
c
c
c	The TEXT   values are :
c
c	integer		itself in I9 format
c	string		itself
c	other D.B.	text value of see field of other D.B.
c	decimal		value with "."
c	date		23-Dec-1984
c	logical		t or f
c	real number	?
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	integer b2,see,value,m,lim
	integer dbcode,onenmb,first,last
	logical user
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDTXT')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.first.or.
     1   	field.gt.last) then
	   goto 90003				!field out of bounds
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	text(1:)=' '
	call cunflt_(base,text,value,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
c	See if d.b. and other field
c
	see=d$see(field,base)
	b2=d$dbio(field,base)
c
	if (b2.gt.0.and.		!o.d.b. field
	1   value.gt.0.and.			!record#
	1   see.gt.0) then			!and see a field
	   dbcode=value
	   user=.true.				!external format
	   call dbtxt_(b2,text,onenmb,dbcode,see,user,error)
	   if (error.ne.0) goto 95000
	endif
c
	empty=.false.
	if (istrip_(text).le.0) then
	   empty=.true.				!empty field
	   goto 900				!return
	endif
c
900	continue
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	*** obsolete ***
90004	continue
	error=4
	goto 99000
c	*** obsolete ***
90005	continue
	error=5
	goto 99000
c	*** obsolete ***
90006	continue
	error=6
	goto 99000
c
99000	continue
	call errset_('FLDTXT',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine flddec_ (base,code,alive,field,value,empty,error)
c	************************************************************
c
	implicit none
c
	real value
c	----------
	integer base, code, alive, field, error
	logical empty
c
c
c	Description
c	===========
c
c	For  BASE  it  obtains   the  real, ie, floating VALUE (not the
c	string  or  integer value ) for  FIELD  of  record  with   CODE.
c	Of course FIELD must be of decimal or real (?) type.
c	This procedure 	does the "lookup" of the record itself, doesn't
c	need a previous call to LOOKUP or FIND.The user must make  sure
c	integer values have meaning for FIELD.
c	ALIVE isn't used anymore.
c	If field is EMPTY (= spaces), EMPTY is returned true; otherwise,
c	it is returned false.
c
c	The VALUE(s) are :
c
c	integer		integer converted to floating point
c	string		-
c	other d.b.	reference converted to floating point (what for ?)
c	decimal		floating point value
c	date		-
c	logical		0.0 or 1.0
c	real number	direct floating point value
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer dec,k,pivot,lim,b2,see,dbcode,first,last
	real x,y
c
	real rvalue
	character*4 rtxt
	equivalence (rvalue,rtxt)
	double precision ddvalue
	character*8 ddtxt
	equivalence (ddvalue,ddtxt)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDDEC')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.first.or.
     1   	field.gt.last) then
	   goto 90003				!field out of bounds
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	pivot=0
	call cunflt_(base,d$cbuf,pivot,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	empty=.false.
	if (istrip_(d$cbuf).le.0) then
	   value=0.0
	   empty=.true.		!empty field
	   goto 900			!return
	endif
c
	call zkind_(base,field,k,error)
	if (error.ne.0) goto 95000
c
	value=pivot
	see=d$see(field,base)
	b2=d$dbio(field,base)
	if     (b2.gt.0.and.		!other d.b.
	1       value.gt.0.and.		!record#
	1       see.gt.0) then		!and see a field
	   dbcode=pivot
	   call dbdec_(b2,value,dbcode,see,error)
	   if (error.ne.0) goto 95000
	elseif (k.eq.x$) then		!decimal
	   x=pivot
	   call zdeci_(base,field,dec,error)
	   if (error.ne.0) goto 95000
	   y=10.0**dec
	   value=x/y
	elseif (k.eq.r$) then		!real
	   rtxt=d$cbuf
	   value=rvalue	   
	   goto 100
	elseif (k.eq.r8$) then		!double precision
	   ddtxt=d$cbuf
	   value=ddvalue
	   goto 100
	endif
c
100	continue
	goto 900			!return
c
900	continue
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c
99000	continue
	call errset_('FLDDEC',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldrl4_ (base,code,alive,field,value,empty,error)
c	************************************************************
c
	implicit none
c
	real value
c	----------
	integer base, code, alive, field, error
	logical empty
c
c
c	Description
c	===========
c
c	Very much like FLDDEC. So read the latter's description.
c	The name stands for real*4.
c
c	The VALUE(s) are :
c
c	integer		integer converted to real*4
c	string		-
c	other d.b.	reference converted to real*4 (what for ?)
c	decimal		real*4 value
c	date		-
c	logical		0.0 or 1.0
c	real number	direct real*4 value
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer dec,k,pivot,lim,first,last
	real x,y
c
	real rvalue
	character*4 rtxt
	equivalence (rvalue,rtxt)
	double precision ddvalue
	character*8 ddtxt
	equivalence (ddvalue,ddtxt)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDRL4')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.first.or.
     1   	field.gt.last) then
	   goto 90003				!field out of bounds
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	pivot=0
	call cunflt_(base,d$cbuf,pivot,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	empty=.false.
	if (istrip_(d$cbuf).le.0) then
	   value=0.0
	   empty=.true.			!empty field
	   goto 900			!return
	endif
c
	call zkind_(base,field,k,error)
	if (error.ne.0) goto 95000
c
	if     (k.eq.x$) then		!decimal
	   x=pivot
	   call zdeci_(base,field,dec,error)
	   if (error.ne.0) goto 95000
	   y=10.0**dec
	   value=x/y
	elseif (k.eq.r$) then		!real
	   rtxt=d$cbuf
	   value=rvalue
	   goto 100
	elseif (k.eq.r8$) then		!double precision
	   ddtxt=d$cbuf
	   value=ddvalue
	   goto 100
	else				!others
	   value=pivot
	endif
c
100	continue
	goto 900			!return
c
900	continue
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c
99000	continue
	call errset_('FLDRL4',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldrl8_ (base,code,alive,field,value,empty,error)
c	************************************************************
c
	implicit none
c
	real*8 value
c	------------
	integer base, code, alive, field, error
	logical empty
c
c
c	Description
c	===========
c
c	Very much like FLDDEC. So read the latter's description.
c	The name stands for real*8.
c
c	The VALUE(s) are :
c
c	integer		integer converted to real*8
c	string		-
c	other d.b.	reference converted to real*8 (what for ?)
c	decimal		real*8 value
c	date		-
c	logical		0.0 or 1.0
c	real number	real*8 value
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer dec,k,pivot,lim,first,last
	real*8 x,y
c
	real rvalue
	character*4 rtxt
	equivalence (rvalue,rtxt)
	double precision ddvalue
	character*8 ddtxt
	equivalence (ddvalue,ddtxt)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDRL8')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.first.or.
     1   	field.gt.last) then
	   goto 90003				!field out of bounds
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	pivot=0
	call cunflt_(base,d$cbuf,pivot,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	empty=.false.
	if (istrip_(d$cbuf).le.0) then
	   value=0.0
	   empty=.true.			!empty field
	   goto 900			!return
	endif
c
	call zkind_(base,field,k,error)
	if (error.ne.0) goto 95000
c
	if     (k.eq.x$) then		!decimal
	   x=pivot
	   call zdeci_(base,field,dec,error)
	   if (error.ne.0) goto 95000
	   y=10.0**dec
	   value=x/y
	elseif (k.eq.r$) then		!real
	   rtxt=d$cbuf
	   value=rvalue
	   goto 100
	elseif (k.eq.r8$) then		!double precision
	   ddtxt=d$cbuf
	   value=ddvalue
	   goto 100
	else				!others
	   value=pivot
	endif
c
100	continue
	goto 900			!return
c
900	continue
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c
99000	continue
	call errset_('FLDNUM',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldall_ (base,code,alive,text,value,rvalue,error)
c	************************************************************
c
	implicit none
c
	integer base, code, alive, value(*), error
	real rvalue(*)
	character*(*) text(*)
c
c
c	Description
c	===========
c
c	For  BASE it  obtains  the string TEXT(s) value(s)  the integer
c	VALUE(s)   and   the   real RVALUE(s)  for  record   with  CODE.
c	This procedure does the  "lookup" of the record itself, doesn't
c	need a previous call  to LOOKUP or  FIND.
c	ALIVE isn't used anymore.
c
c	The TEXT, VALUE, RVALUE values are :
c
c	integer		-, direct value, floating equivalent
c	string		itself, -, -
c	other d.b.	-, direct value, floating equivalent
c	decimal		value with ".", integerized value,floating equivalent
c	date		23-Dec-1984, 841223, -
c	logical		t, 1, 1.0  or f, 0, 0.0
c	real number	value with ".", ?, floating point value
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	integer dec,k,t,dbcode,b2,see,onenmb,first,last
	real x,y
	logical user
c
	real rv
	character*4 rtxt
	equivalence (rv,rtxt)
	double precision ddv
	character*8 ddtxt
	equivalence (ddv,ddtxt)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDALL')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	do 1001 k=first,last
	   if (d$prt(base).ne.0.and.		!protection ON
	1      d$prfl(k,base).eq.prtno) then	!and no access
	      text(k)(1:)=' '
	      value(k)=0
	      rvalue(k)=0.0
	   else
	      call cunflt_(base,text(k),value(k),k,d$xbuf,error)
	      if (error.ne.0) goto 95000
	      call zkind_(base,k,t,error)
	      if (error.ne.0) goto 95000
	      see=d$see(k,base)
	      b2=d$dbio(k,base)
	      if     (b2.gt.0.and.			!o.d.b. field
	1             value(k).gt.0.and.		!record#
	1             see.gt.0          ) then		!and see a field
	         dbcode=value(k)
	         call dbnum_(b2,value(k),dbcode,see,error)
	         if (error.ne.0) goto 95000
	         user=.true.				!external format
	         call dbtxt_(b2,text(k),onenmb,dbcode,see,user,error)
	         if (error.ne.0) goto 95000
	         call dbdec_(b2,rvalue(k),dbcode,see,error)
	         if (error.ne.0) goto 95000
	      elseif (t.eq.x$) then		!decimal
	         x=value(k)
	         call zdeci_(base,k,dec,error)
	         if (error.ne.0) goto 95000
	         y=10.0**dec
	         rvalue(k)=x/y
	      elseif (k.eq.r$) then		!real
	         rtxt=d$cbuf
	         if (istrip_(rtxt).le.0) then
	            rvalue(k)=0.0
	            goto 900			!return
	         else
	            rvalue(k)=rv
	            goto 100
	         endif
	      elseif (k.eq.r8$) then		!double precision
	         ddtxt=d$cbuf
	         if (istrip_(ddtxt).le.0) then
	            rvalue(k)=0.0
	            goto 900			!return
	         else
	            rvalue(k)=ddv
	            goto 100
	         endif
	      endif
	   endif
1001	continue
c
100	continue
	goto 900
c
900	continue
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	error=1
	goto 99000
c
c	base not open
90002	continue
	error=2
	goto 99000
c
99000	continue
	call errset_('FLDALL',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine flddb_ (base,code,alive,field,dbcode,empty,error)
c	************************************************************
c
	implicit none
c
	integer dbcode
c	--------------
	integer base, code, alive, field, error
	logical empty
c
c
c	Description
c	===========
c
c	For BASE and o.d.b FIELD it obtains the record# DBCODE.
c	ALIVE isn't used anymore.
c	If field is EMPTY (= spaces), EMPTY is returned true; otherwise,
c	it is returned false.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,kind,first,last
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDDB')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	elseif (field.lt.first.or.
     1   	field.gt.last) then
	   goto 90003				!field out of bounds
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   if (d$prfl(field,base).eq.prtno) then
	      goto 90003			!no access
	   endif
	endif
c
	kind=d$type(field,base)
	if (kind.ne.db$) goto 90004		!other D.B. only
c
c	work
c
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) goto 95000
c
	dbcode=0
	call cunflt_(base,d$cbuf,dbcode,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	empty=.false.
	if (istrip_(d$cbuf).le.0) then
	   dbcode=0
	   empty=.true.			!empty field
	endif
c
	return
c
c	errors
c	======
c	illegal database number
90001	continue
	error=1
	goto 99000
c	base not open
90002	continue
	error=2
	goto 99000
c	field out of bounds or protected
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) field
90033	continue
	error=3
	goto 99000
c	field isn't o.d.b.
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90044) field
90044	continue
	error=4
	goto 99000
c
99000	continue
	call errset_('FLDDB',error)
	return
c
c	here inherited errors
c
95000	continue
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	subroutine fldlim_ (base,field,min,max,error)
c	*********************************************
c
	implicit none
c
	integer base, field, min, max, error
c
c
c	Description
c	===========
c
c	Gets the minimum and maximum values for FIELD of BASE.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer k,first,last
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('FLDMIN')
	error=0				!clear error
c
c	validate arguments
c
	first=d$u1st(base)			!first user data field
	last=first+d$udnf(base)-1		!and last
c
	call zxlim_(base,field,min,max,error)	!easy, wasn't it ?
	if (error.ne.0) goto 99000
c
	return
c
c	errors
c	======
c
99000	continue
	call errset_('FLDLIM',error)
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
c
	subroutine flat_(base,window,ground,error)
c	******************************************
c
c
	implicit none
c
	integer base,error
	character*(*) window(*),ground
c
c	Description
c	===========
c
c	Given in  WINDOW  the various fields of data BASE,  one per line,
c	a FLATened version is produced in string GROUND according to the
c	size of the fields, ready to be written in disk. Notice that the
c	fields ARE SUPPOSED TO BE CORRECT. If in doubt see the procedure
c	VALIDA !!!
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	integer k,p,first,last
c
c	begin
c	=====
c
	call errclr_('FLAT')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	ground(1:)=' '
c
c	cycle in fields
c
	do 1001 k=first,last
	   p=0
	   call cflt_(base,window(k),p,k,ground,error)
	   if (error.ne.0) goto 95000		!error, carry
1001	continue
c
	return
c
c	errors
c	======
c
c	inherited errors
95000	continue
	return
c
c
	end
c
c
c
c
	subroutine unflat_(base,window,ground,error)
c	********************************************
c
c
	implicit none
c
	integer base,error
	character*(*) window(*),ground
c
c	Description
c	===========
c
c	Given in GROUND a image of a record in disk, from BASE, the
c	various  fields are  UNFLATened into  WINDOW,  one per line,
c	ready to be given, for instance, to the editor.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer dec,lim
	integer k,p,m,field,b,f,b2,mast,dbcode,onenmb,first,last
	logical errdon,unferr,user
c
c	begin
c	=====
c
	call errclr_('UNFLAT')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
c	cycle in fields
c
	errdon=.false.		!keep trace only of 1st. ofending field
	unferr=.false.		!unflat error
c
	do 1001 k=first,last
	   b=base
	   f=k
	   call cunflt_(b,window(k),m,f,ground,error)
	   if (error.ne.0) then
	      if (.not.errdon) then
	         errdon=.true.
	         field=f		!1st. offending field
	      endif
	      unferr=.true.		!don't forget
	      call errclr_('UNFLAT')	!try to do as many fields as you can
	      error=0
	   endif
c
	   if (.not.unferr) then
	      b2=d$dbio(k,base)
	      mast=d$mast(k,base)
	      if (b2.gt.0.and.mast.gt.0) then	!o.d.b. field
	         read (window(k),'(i10)',err=101) dbcode
	         user=.true.			!external format
	         call dbtxt_(b2,window(k),onenmb,dbcode,mast,user,error)
	         goto 102
101	         continue
	         error=1			!fake error
102	         continue
	         if (error.ne.0) then
	            if (.not.errdon) then
	               errdon=.true.
	               field=f		!1st. offending field
	            endif
	            unferr=.true.	!don't forget
	            call errclr_('UNFLAT')!try to do as many fields as you can
	            error=0
	          endif
	      endif
	   endif
1001	continue
c
	if (unferr) goto 90001		!say him (or her)
c
	return
c
c	errors
c	======
c	couldn't get at least one field
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90011) field
90011	continue
c
	error=1
	goto 99000
c
99000	continue
	call errset_('UNFLAT',error)
	return
c
c	inherited errors
95000	continue
	return
c
	end
c
c
c
c
	subroutine cflt_(base,onetxt,onenmb,field,ground,error)
c	*******************************************************
c
c
	implicit none
c
	integer base,onenmb,field,error
	character*(*) onetxt,ground
c
c	Description
c	===========
c
c	Given in  ONETXT  one  field  of  a  data  BASE, the corresponding
c	sub string   is  produced  in   string  GROUND  according  to  the
c	size  of  the fields, ready to be written in disk. Notice that the
c	field   IS  SUPPOSED  TO BE CORRECT. If in doubt see the procedure
c	VALIDA !!!  ONETXT is a string version of the field value. However,
c	if  meaningful, the  value  can come in ONENMB in integerized form;
c	in  this  case  ONETXT  must come with # sign ( onetxt(1:1)='#'...),
c	( shuuuushsh...! ).
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer b2,dbcode,mast,lim
	integer k,p
	logical odb,inipos,user,eox
c
c	begin
c	=====
c
	call errclr_('CFLT')
	error=0
c
c	see if o.d.b. field
c
	odb=.false.
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	if (b2.gt.0.and.			!o.d.b. field
	1   mast.gt.0   ) then			!and master field
	   if (istrip_(onetxt).gt.0) then
	      user=.true.			!external format
	      call txtdb_(b2,onetxt,dbcode,mast,user,
	1                 eox,error)		!convert to record#
	      if (error.ne.0) return		!error, carry
	      if (eox) goto 90005			!not found
	      write (onetxt,'(i10)',err=90005) dbcode
	      odb=.true.
	   endif
	endif
c
c	go for field assuming it is in onetxt
c
	inipos=.false.				!usual flatenning
	call cf_(base,onetxt,onenmb,field,ground,
	1        odb,inipos,error)
	if (error.ne.0) return			!error, carry
c
	return
c
c	errors
c	======
c
c	*** obsolete ***
90001	continue
	error=1
	goto 99000
c	*** obsolete ***
90002	continue
	error=2
	goto 99000
c	*** obsolete ***
90003	continue
	error=3
	goto 99000
c	*** obsolete ***
90004	continue
	error=4
	goto 99000
c	wrong o.d.b. field contents
90005	continue
	error=5
	goto 99000
c
99000	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90099) field
90099	continue
	call errset_('CFLT',error)
	return
c
c
	end
c
c
c
c
	subroutine cf_(base,onetxt,onenmb,field,ground,odb,inipos,error)
c	****************************************************************
c
c
	implicit none
c
	integer base,onenmb,field,error
	character*(*) onetxt,ground
	logical odb
	logical inipos
c
c	Description
c	===========
c
c	Given in  ONETXT  one  field  of  a  data  BASE, the corresponding
c	sub string   is  produced  in   string  GROUND  according  to  the
c	size  of  the fields, ready to be written in disk. Notice that the
c	field   IS  SUPPOSED  TO BE CORRECT. If in doubt see the procedure
c	VALIDA !!!  ONETXT is a string version of the field value. However,
c	if  meaningful, the  value  can come in ONENMB in integerized form;
c	in  this  case  ONETXT  must come with # sign ( onetxt(1:1)='#'...),
c	( shuuuushsh...! ).
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer b2,dbcode,mast,lim
	integer kind,top,form
	integer k,p,l1,l2,pivot,outsiz,ir
	real r,rvalue
	double precision dd
	character*1 m
	logical notnmb
c
	real rv
	character*4 rtxt
	equivalence (rv,rtxt)
	double precision ddv
	character*8 ddtxt
	equivalence (ddv,ddtxt)
c
c	begin
c	=====
c
	call errclr_('CF')
	error=0
c
	ir=d$race(base)
	if (ir.eq.r$si.or.			!if series
	1   ir.eq.r$sx.or.
	1   ir.eq.r$sr.or.
	1   ir.eq.r$sr8.or.
	1   ir.eq.r$sd.or.
	1   ir.eq.r$sl.or.
	1   ir.eq.r$sc     ) then
	   goto 90004			!can't, use proper procedures
	else
c	   ok (regular bases and properties)
	endif
c
	notnmb=.true.
	call zkind_(base,field,kind,error)
	if (error.ne.0) return				!error, carry
	outsiz=d$siz(field,base)
	if (odb) then
	   kind=db$
	   outsiz=10
	endif
	if (outsiz.gt.len(onetxt)) goto 90003		!not big enough
	if (kind.ne.c$.and.onetxt(1:1).eq.'#') then	!field is in onenmb...
	   notnmb=.false.
	   call wrivar_(onetxt,onenmb,outsiz,error)
	   if (error.ne.0) goto 90001			!wrong value
	   lim=istrip_(onetxt)
	endif
	lim=istrip_(onetxt)
	if (lim.le.0) then
	   if (kind.eq.r$.or.
	1      kind.eq.r8$  ) then
c	      ok, proceed
	   else
	      goto 100		!do nothing
	   endif
	endif
	if (lim.lt.outsiz) then
	   onetxt(lim+1:outsiz)=' '
	endif
	if (inipos) then
	   l1=1
	else
	   l1=d$pos(field,base)
	endif
	l2=l1+outsiz-1
	goto (11,12,13,14,15,16,17,18) kind
11	continue		!integer
13	continue		!other D.B.
	if (inipos) ground(1:)=' '
	ground(l1:l2)=onetxt(1:outsiz)
	goto 100
12	continue		!string
	if (inipos) ground(1:)=' '
	ground(l1:l2)=onetxt(1:outsiz)
	goto 100
14	continue		!decimal
	if (inipos) ground(1:)=' '
	if (notnmb) then
  	   p=index(onetxt,'.')
	   ground(l1:l2)    =onetxt(1:p-1)
	   ground(l1+p-1:l2)=onetxt(p+1:)
	else
	   ground(l1:l2)=onetxt(1:outsiz)
	endif
	goto 100
15	continue		!date
	if (inipos) ground(1:)=' '
	if (notnmb) then
	   call numdat_(pivot,onetxt,top,form,error)
	   if (error.ne.0) goto 90002
	else
	   pivot=onenmb
	endif
	write (ground(l1:l2),'(i8)') pivot
	goto 100
16	continue		!logical
	if (inipos) ground(1:)=' '
	if (notnmb) then
	   write (ground(l1:l2),'(a)') onetxt(1:1+outsiz-1)
	else
	   if (onenmb.eq.0) then
	      write (ground(l1:l2),'(''f'')')
	   else
	      write (ground(l1:l2),'(''t'')')
	   endif
	endif
	goto 100
17	continue		!real
	if (inipos) ground(1:)=' '
	lim=istrip_(onetxt)
	if (lim.le.0) then
	   ground(l1:l2)=rnulltxt
	else
	   read (onetxt,*,err=90001) rv
	   ground(l1:l2)=rtxt
	endif
	goto 100
c
18	continue		!real
	lim=istrip_(onetxt)
	if (lim.le.0) then
	   ground(l1:l2)=ddnulltxt
	else
	   read (onetxt,*,err=90001) ddv
	   ground(l1:l2)=ddtxt
	endif
	goto 100
c
100	continue
c
	return
c
c	errors
c	======
c
c	wrong value
90001	continue
	error=1
	goto 99000
c	wrong date
90002	continue
	error=2
	goto 99000
c	no room
90003	continue
	error=3
	goto 99000
c	can't flat a field of a series !!!
90004	continue
	error=4
	goto 99000
c
99000	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90099) field
90099	continue
	call errset_('CF',error)
	return
c
c
	end
c
c
c
c
	subroutine cunflt_(base,onetxt,onenmb,field,ground,error)
c	*********************************************************
c
c
	implicit none
c
	integer base,onenmb,field,error
	character*(*) onetxt,ground
c
c	Description
c	===========
c
c	Given in GROUND an image of a record in disk, from BASE, the
c	specific  FIELD  is  UNFLATened  into  ONETXT, ready  to  be
c	given,for instance, to the editor. If meaningful the integer
c	counterpart is given back in ONENMB.
c
c	If any error, ONETXT is filled with "*" !.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer kind,dec,lim
	integer p,l1,l2,size,outsiz,b2,mast,k
c
c	begin
c	=====
c
	call errclr_('CUNFLT')
	error=0
c
c	get at field
c
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	onenmb=0
	onetxt(1:)=' '
	call zkind_(base,field,kind,error)
	if (error.ne.0) return		!error, return
	call zsize_(base,field,size,error)
	if (error.ne.0) return		!error, return
	call zdeci_(base,field,dec,error)
	if (error.ne.0) return		!error, return
c
	if (b2.gt.0.and.			!o.d.b. field
	1   mast.gt.0   ) then			!and master field
	   kind=db$
	   size=10
	   dec=0
	endif
c
	call cunf_(base,onetxt,onenmb,field,kind,size,dec,ground,error)
	if (error.ne.0) return			!error, carry
c
	return
c
c	errors
c	======
c
	end
c
c
c
c
	subroutine cunf_(base,onetxt,onenmb,field,kind,size,dec,
	1                ground,error)
c	***************************************************************
c
c
	implicit none
c
	integer base,onenmb,field,kind,size,dec,error
	character*(*) onetxt,ground
c
c	Description
c	===========
c
c	Given in GROUND an image of a record in disk, from BASE, the
c	specific  FIELD  is  UNFLATened  into  ONETXT, ready  to  be
c	given,for instance, to the editor. If meaningful the integer
c	counterpart is given back in ONENMB.
c
c	If any error, ONETXT is filled with "*" !.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,l1,l2,p,outsiz,k
c
	real rvalue
	character*4 rtxt
	equivalence (rvalue,rtxt)
	double precision ddvalue
	character*8 ddtxt
	equivalence (ddvalue,ddtxt)
c
	double precision dd
c
c	begin
c	=====
c
	call errclr_('CUNF')
	error=0
c
	onenmb=0
	onetxt(1:)=' '
c
	if (size.gt.len(onetxt)) then
	   outsiz=len(onetxt)
	   goto 90003		!not big enough
	else
	   outsiz=size
	endif
	l1=d$pos(field,base)
	l2=l1+size-1
	lim=istrip_(ground(l1:l2))
	goto (11,12,13,14,15,16,17,18) kind
11	continue		!integer
13	continue		!other D.B.
	if (lim.le.0) goto 100
	read (ground(l1:l2),'(a)') onetxt(1:size)
	call rdivar_(ground(l1:l2),onenmb,size,error)
	if (error.ne.0) goto 90002		!wrong value
	goto 100
12	continue		!string
	if (lim.le.0) goto 100
	read (ground(l1:l2),'(a)') onetxt(1:size)
	onenmb=0
	goto 100
14	continue		!decimal
	if (lim.le.0) goto 100
	p=size-dec+1
	onetxt(p:p)='.'
	onetxt(1:p-1)=ground(l1:l2)
	onetxt(p+1:)=ground(l1+p-1:l2)
	call rdivar_(ground(l1:l2),onenmb,size,error)
	if (error.ne.0) goto 90002		!wrong value
	goto 100
15	continue		!date
	if (lim.le.0) goto 100
	read (ground(l1:l2),'(i8)',err=151) onenmb
151	continue
	call txtdat_(onenmb,onetxt(1:),error)
	if (error.ne.0) goto 90001
	goto 100
16	continue		!logical
	if (lim.le.0) goto 100
	read (ground(l1:l2),'(a)') onetxt(1:1+size-1)
	if (onetxt(1:1).eq.'f'.or.onetxt(1:1).eq.'F') then
	   onenmb=0
	else
	   onenmb=1
	endif
	goto 100
17	continue		!real
	rtxt=ground(l1:l2)
	if (rtxt.eq.rnulltxt) then
	   onetxt(1:)=' '	!empty
	else
	   write (onetxt,*,err=90002) rvalue
	   if (len(onetxt).ge.15) then
	      call rjust_(onetxt(1:15))
	   endif
	endif
	goto 100
c
18	continue		!double precision
	ddtxt=ground(l1:l2)
	if (ddtxt.eq.ddnulltxt) then
	   onetxt(1:)=' '	!empty
	else
	   write (onetxt,*,err=90002) ddvalue
	   if (len(onetxt).ge.24) then
	      call rjust_(onetxt(1:24))
	   endif
	endif
	goto 100
c
100	continue
c
	return
c
c	errors
c	======
c
c	wrong date
90001	continue
	error=1
	goto 99000
c	wrong value
90002	continue
	error=2
	goto 99000
c	not enough room
90003	continue
	error=3
	goto 99000
c
99000	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90099) field
90099	continue
	call errset_('CUNF',error)
	do k = 1, outsiz
	   onetxt(k:k)='*'
	enddo
c
	return
c
	end
c
c
c
c
	subroutine dbtxt_(base,text,onenmb,code,field,user,error)
c	*********************************************************
c
c
	implicit none
c
	integer base,onenmb,code,field,error
	character*(*) text
c
c	Description
c	===========
c
c	Return FIELD of BASE as a TEXT. Usually used by FLDTXT itself, to
c	get the "other data base" field value (not recursive...).
c	If USER = .true., TEXT will be returned in external (user) format,
c	otherwise internal (disk) format will be assumed.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer alive,lim,k,l,kind,size,dec,p1,first,last
	logical user
c
c	begin
c	=====
c
	call errclr_('DBTXT')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	text(1:)=' '
	onenmb=0
c
	if (code.le.0) return			!all done !!!
c
	if (d$prt(base).ne.0.and.		!protection ON
	1   d$prfl(field,base).eq.prtno) then	!and no access
	   goto 90001				!protected
	endif
	if (field.lt.first.or.field.gt.last) goto 90001!field out of bounds
	call find_ (base, code, alive, xbuf2, error)
	if (error.ne.0) then
	   if (d$rsub.eq.'FIND'.and.
	1      d$erro.eq.5          ) then
	      goto 90002				!killed record found
	   endif
	   goto 95000
	endif
c
	if (user) then				!user format
	   call zkind_(base,field,kind,error)
	   if (error.ne.0) goto 95000	!error, return
	   call zsize_(base,field,size,error)
	   if (error.ne.0) goto 95000	!error, return
	   call zdeci_(base,field,dec,error)
	   if (error.ne.0) goto 95000	!error, return
	   call cunf_(base,text,onenmb,field,kind,size,dec,xbuf2,error)
	else					!internal format
	   p1=d$pos(field,base)
	   call zsize_(base,field,size,error)
	   if (error.ne.0) goto 95000	!error, return
	   text(1:)=' '
	   text=xbuf2(p1:p1+size-1)
	   l=istrip_(text(1:size))
	   call zkind_(base,field,kind,error)
	   if (error.ne.0) goto 95000	!error, return
c
	   if (kind.eq.l$) then		!THE exception
	      if (l.gt.0) then
	         if (text(1:1).eq. 'T'.or.text(1:1).eq.'t') then
	            onenmb=1
	         else
	            onenmb=0
	         endif
	      endif
	   else
	      if (d$type(field,base).ne.c$) then
	         call rdivar_(text,onenmb,size,error)
	         if (error.ne.0) return
	      endif
	   endif
	endif
c
	return
c
c
c	errors
c	======
c	field out of bounds or protected
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90019) field
90019	error=1
	goto 99000
c	killed record found
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90029) code
90029	error=2
	goto 99000
c
99000	continue
	call errset_('DBTXT',error)
	return
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine dbnum_(base,value,code,field,error)
c	*********************************************
c
c
	implicit none
c
	integer base,value,code,field,error
c
c	Description
c	===========
c
c	Return FIELD of BASE as an integer VALUE. Usually used by FLDNUM
c	itself, to get the "other data base" field value (not recursive...).
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer alive,lim,first,last
c
c	begin
c	=====
c
	call errclr_('DBNUM')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	if (d$prt(base).ne.0.and.		!protection ON
	1   d$prfl(field,base).eq.prtno) then	!and no access
	   goto 90001				!protected
	endif
	if (field.lt.first.or.field.gt.last) goto 90001!field out of bounds
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) then
	   if (d$rsub.eq.'FIND'.and.
	1      d$erro.eq.5          ) then
	      goto 90002				!killed record found
	   endif
	   goto 95000
	endif
	value=0
	call cunflt_(base,d$cbuf,value,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	return
c
c
c	errors
c	======
c
c	field out of bounds or protected
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90019) field
90019	error=1
	goto 99000
c	killed record found
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90029) code
90029	error=2
	goto 99000
c
99000	continue
	call errset_('DBNUM',error)
	return
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine dbdec_(base,value,code,field,error)
c	**********************************************
c
c
	implicit none
c
	real value
	integer base,code,field,error
c
c	Description
c	===========
c
c	Return FIELD of BASE as a real VALUE. Usually used by FLDDEC itself,
c	to get the "other data base" field value (not recursive...).
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer dec,k,pivot,alive,lim,first,last
	real x,y
c
	real rv
	character*4 rtxt
	equivalence (rv,rtxt)
	double precision ddv
	character*8 ddtxt
	equivalence (ddv,ddtxt)
c
c	begin
c	=====
c
	call errclr_('DBDEC')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	if (d$prt(base).ne.0.and.		!protection ON
	1   d$prfl(field,base).eq.prtno) then	!and no access
	   goto 90001				!protected
	endif
	if (field.lt.first.or.field.gt.last) goto 90001!field out of bounds
	call find_ (base, code, alive, d$xbuf, error)
	if (error.ne.0) then
	   if (d$rsub.eq.'FIND'.and.
	1      d$erro.eq.5          ) then
	      goto 90002				!killed record found
	   endif
	   goto 95000
	endif
	pivot=0
	call cunflt_(base,d$cbuf,pivot,field,d$xbuf,error)
	if (error.ne.0) goto 95000
c
	call zkind_(base,field,k,error)
	if (error.ne.0) goto 95000
	if     (k.eq.x$) then		!decimal
	   x=pivot
	   call zdeci_(base,field,dec,error)
	   if (error.ne.0) goto 95000
	   y=10.0**dec
	   value=x/y
	elseif (k.eq.r$) then		!real
	   rtxt=d$cbuf
	   if (istrip_(rtxt).le.0) then
	      value=0
	   else
	      value=rv
	   endif
	   goto 100
	elseif (k.eq.r8$) then		!double precision
	   ddtxt=d$cbuf
	   if (istrip_().le.0) then
	      value =0
	   else
	      value=ddv
	   endif
	   goto 100
	else				!others
	   value=pivot
	endif
c
100	continue
c
	return
c
c
c	errors
c	======
c
c	field out of bounds or protected
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90019) field
90019	error=1
	goto 99000
c	killed record found
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', rec#'
	write (d$rinf(lim+7:),fmt='(i10)',err=90029) code
90029	error=2
	goto 99000
c
99000	continue
	call errset_('DBDEC',error)
	return
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine txtdb_(base,text,code,field,user,eox,error)
c	******************************************************
c
c
	implicit none
c
	integer base,code,field,error
	character*(*) text
	logical user,eox
c
c	Description
c	===========
c
c	Return CODE of BASE corresponding to TEXT as a value of FIELD.
c	If USER =.true., TEXT is supposed to come in external (user)
c	format, otherwise internal (disk) format is assumed.
c	If no record found or protection failure, returns CODE = 0.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer xtype,alive,lim,val,onenmb,first,last
	logical odb,inipos
c
c	begin
c	=====
c
	call errclr_('TXTDB')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	code=0
c
	if (d$prt(base).ne.0.and.		!protection ON
	1   d$prfl(field,base).eq.prtno) then	!and no access
	   goto 50				!protected
	endif
	if (field.lt.first.or.field.gt.last) goto 90001!field out of bounds
c
	call opnx_ (base,field,error)		!open index
	if (error.ne.0) then
	   goto 50				!can't open indexes
	endif
c
	xtype=d$type(field,base)
	if (xtype.ne.r$.and.
	1   xtype.ne.r8$    ) then
	   if (istrip_(text).le.0) goto 50
	endif
c
	if (user) then			!external format
	   odb=.false.
	   inipos=.true.			!at the beginning
	   xbuf1(1:)=' '			!!!!!!!!!!!!!!!!!
	   call cf_(base,text,onenmb,field,xbuf1,odb,inipos,error)
	   if (error.ne.0) goto 50
	   val=0
	   call fix_ (base,field,val,xbuf1,code,eox,error)
	   if (error.ne.0) goto 50
	else				!internal format
	   val=0
	   call fix_ (base,field,val,text,code,eox,error)
	   if (error.ne.0) goto 50
	endif
c
	if (eox) goto 100
c
	return
c
c	error, just return eox=.true.
50	continue
	call errclr_('TXTDB')
	error=0
	eox=.true.
	goto 100
c
100	continue
	code=0
	return
c
c	errors
c	======
c	field out of bounds or protected
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90019) field
90019	error=1
	goto 99000
c
99000	continue
	call errset_('TXTDB',error)
	return
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine xflat_(base,window,ground,error)
c	*******************************************
c
c
	implicit none
c
	integer base,error
	character*(*) window(*),ground
c
c	Description
c	===========
c
c	Given in  WINDOW  the various fields of data BASE,  one per line,
c	a FLATened, but EXTERNAL version is produced in string GROUND
c	according to the size of the fields.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	integer k,kind,xsiz,grsize,pos1,pos2,first,last
c
c	begin
c	=====
c
	call errclr_('XFLAT')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	ground(1:)=' '
	grsize=len(ground)
c
c	cycle in fields
c
	pos1=1
	do 1001 k=first,last
	   xsiz=d$siz(k,base)			!external size
	   kind=d$type(k,base)			!field type
	   if     (kind.eq.d$) then
	      xsiz=11				!DATE size
	   elseif (kind.eq.x$) then		!decimals, extra room for "."
	      xsiz=xsiz+1
	   elseif (kind.eq.r$) then		!reals have fixed format
	      xsiz=15
	   elseif (kind.eq.r8$) then		!double precision too
	      xsiz=24
	   endif
	   pos2=pos1+xsiz-1			!last pos
	   if (pos2.gt.grsize) goto 90001	!doesn't fit
	   ground(pos1:pos2)=window(k)
	   pos1=pos2+1				!next start pos
1001	continue
c
	return
c
c	errors
c	======
c	not enough room to handle field
90001	continue
	error=1
	goto 99000
c
99000	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	call errset_('XFLAT',error)
c
	return
c
c
	end
c
c
c
c
	subroutine xunfla_(base,window,ground,error)
c	********************************************
c
c
	implicit none
c
	integer base,error
	character*(*) window(*),ground
c
c	Description
c	===========
c
c	Given in GROUND a FLATened, but EXTERNAL version of the various fields
c	of data BASE, a one per line version is produced in WINDOW, according
c	to the size of the fields.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	integer k,kind,xsiz,grsize,pos1,pos2,first,last
c
c	begin
c	=====
c
	call errclr_('XUNFLA')
	error=0
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	grsize=len(ground)
c
c	cycle in fields
c
	pos1=1
	do 1001 k=first,last
	   xsiz=d$siz(k,base)			!external size
	   kind=d$type(k,base)			!field type
	   if     (kind.eq.d$) then
	      xsiz=11				!DATE size
	   elseif (kind.eq.x$) then		!decimals, extra room for "."
	      xsiz=xsiz+1
	   elseif (kind.eq.r$) then		!reals have fixed format
	      xsiz=15
	   elseif (kind.eq.r8$) then		!double precision too
	      xsiz=24
	   endif
	   pos2=pos1+xsiz-1			!last pos
	   if (pos2.gt.grsize) goto 90001	!doesn't fit
	   window(k)(1:)=' '
	   window(k)=ground(pos1:pos2)
	   pos1=pos2+1				!next start pos
1001	continue
c
	return
c
c	errors
c	======
c	not enough room to handle field
90001	continue
	error=1
	goto 99000
c
99000	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	call errset_('XUNFLA',error)
c
	return
c
c
	end
c
c
c
c
