c	DBAG8.FOR
c	*********
c
c	Bitmap primitives for the DBAG data base system
c
c
c	Written by Luis Arriaga da Cunha 1985, 1986
c	===========================================
c
c	General remarks
c	===============
c
c	The  "normal" BITMAP  is  an array of integers supplied by
c	the user. The  first  seven (7) positions  in a bitmap are
c	reserved for:
c
c	1 - size of bitmap in words
c	2 - offset to add to the record numbers
c	3 - if 0 normal bitmap, if >1 sorted bitmap (hem?)
c	4 - first word in use overall
c	5 - last  word in use overall
c	6 - current word for BITNXT/BITPRV
c	7 - current position within word for BITNXT/BITPRV
c
c	The  user  always  speaks  in  terms  of  records,  hence
c	the  need  for  an offset. By the way, to the user offset
c	means the first record number in  the base !
c	To handle X records a bitmap must have X/word_size (32 in
c	a VAX ) + 7 words. So  to  register 100000  records, 3133
c	words are enough (clever aint it ?)
c
c	Summary of procedures :
c
c	bitinq		inquire about size necessary to register
c			records between x:y
c	bitini		inits a bitmap with size, offset, etc...
c
c	bitput		select a record (mark as one)
c	bitzer		de-select a record (mark as zero)
c	bitget		is record selected ?
c	bitupt		is record selected ? Anyway gives number of
c			one's ( ie, selected records) UP To this one
c	bitpos		which record is the nth selected ?
c
c	bitnxt		get next record selected. Can also reset to first.
c	bitprv		get previous record selected. Can also reset to last.
c
c	bitand		.and. two bitmaps
c	bitor		.or. two bitmaps
c	bitcpy		copy from one bitmap to another
c
c	bitscp		impose scope in bimap
c	bitblk		select all records in block between two values
c	bitclr		de-select all records in bit map
c
c	bitcnt 		how many records selected in bitmap ?
c	bitlim		gives 1st and last records bitmap can register
c	bitmax		what is the current overall size of bitmap ?
c
c
c
c
c	The  BITMAP can be sorted. That information is kept in an additional
c	structure  also  supplied  by  the  user. It is an array of integers.
c	The  first  seven (7)  positions  in this structure are reserved for:
c
c	1 - overall size of structure in words
c	2 - number of blocks
c	3 - dimension of each block
c	4 - future use
c	5 - future use
c	6 - future use
c	7 - future use
c
c	Summary of procedures :
c
c	btoinq		inquire about what size is necessary for aditional
c			structure to register the ordering of a bitmap
c	btoini		init aditional structure for "ordered" bitmap
c	btordr		order bitmap, ie, make record x the ith
c	btonxt		get next record selected in order. Can also reset
c			to first.
c	btoprv		get previous record selected in order. Can also
c			reset to last.
c
c
c
c
	subroutine bitini_ (bitmap,max,first,last,erro)
c	***********************************************
c
	implicit none
c
	integer bitmap(*),max,first,last,erro
c
c	Description
c	===========
c
c	Given  the first record number to be used  FIRST, the
c	bitmap register it so that all references made by the
c	user are in terms of record numbers (pampered hem...)
c	Also  the  top of the bitmap, MAX (given by the user),
c	is  remembered. LAST  is  given  back  as the highest
c	record number the bitmap can handle.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer k
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITINI')
	erro=0				!clear error
c
	if (max.le.7) goto 90001	!empty bitmap ?!
	bitmap(1)=max			!size in words
	bitmap(2)=word_s*7-first+1	!dont try to understand...
	bitmap(3)=0			!normal bitmap
	bitmap(4)=7+1			!1st 7 words are reserved
	bitmap(5)=max			!last word used
	bitmap(6)=7+1			!start at the beginning
	bitmap(7)=0			!  "   "   "      "
	last=(max-7)*word_s+first-1	!last possible record
c
	do 1001 k=7+1,max
	   bitmap(k)=0			!no one selected to start with
1001	continue
c
	return
c
c	errors
c	======
c
c	empty bitmap, probably forgot the seven reserved words...
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BITINI',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitput_ (bitmap,rec,erro)
c	************************************
c
	implicit none
c
	integer bitmap(*),rec,erro
c
c	Description
c	===========
c
c	The record number REC is selected ( put to one ).
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer max,wrd,pos,pivot
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITPUT')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
	pivot=rec+bitmap(2)		!correct with offset
	wrd=pivot/word_s		!find word,
	pos=mod(pivot,word_s)
	if (pos.ne.0) then
	   wrd=wrd+1
	else
	   pos=word_s
	endif
	if (wrd.gt.max) goto 90001	!over the top !
	if (wrd.lt.7+1)   goto 90002	!underflow
	bitmap(wrd)=bitmap(wrd).or.mask_(pos)
c
	return
c
c	errors
c	======
c
c	record number too big
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITPUT',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitzer_ (bitmap,rec,erro)
c	************************************
c
	implicit none
c
	integer bitmap(*),rec,erro
c
c	Description
c	===========
c
c	The record number REC is de-selected ( put to zero ).
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer max,wrd,pos,pivot
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITZER')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
	pivot=rec+bitmap(2)		!correct with offset
	wrd=pivot/word_s		!find word,
	pos=mod(pivot,word_s)
	if (pos.ne.0) then
	   wrd=wrd+1
	else
	   pos=word_s
	endif
	if (wrd.gt.max) goto 90001	!over the top !
	if (wrd.lt.7+1)   goto 90002	!underflow
	bitmap(wrd)=bitmap(wrd).and.zmask_(pos)
c
	return
c
c	errors
c	======
c
c	record number too big
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITZER',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitget_ (bitmap,rec,what,erro)
c	*****************************************
c
	implicit none
c
	integer bitmap(*),rec,what,erro
c
c	Description
c	===========
c
c	Tells in WHAT wether the record number REC is select(1)
c	or de-selected (0).
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer max,wrd,pos,pivot,l
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITGET')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
	pivot=rec+bitmap(2)		!correct with offset
	wrd=pivot/word_s		!find word,
	pos=mod(pivot,word_s)
	if (pos.ne.0) then
	   wrd=wrd+1
	else
	   pos=word_s
	endif
	if (wrd.gt.max) goto 90001	!over the top !
	if (wrd.lt.7+1)   goto 90002	!underflow
	l=bitmap(wrd).and.mask_(pos)
	if (l.eq.0) then
	   what=0
	else
	   what=1
	endif
c
	return
c
c	errors
c	======
c
c	record number too big
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITGET',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitnxt_ (bitmap,rec,eobm,erro)
c	*****************************************
c
	implicit none
c
	integer bitmap(*),rec,erro
	logical eobm
c
c	Description
c	===========
c
c	Gives the  next selected record REC in the bitmap.
c	It  should  be  called again and again until EOBM
c	becomes true. To reset from the beginning call it
c	with REC = 0. To reset from a certain REC call it
c	with REC = -REC (tricky...).
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer myrec,kurr,wrd,pos,pivot,max,k,l
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITNXT')
	erro=0				!clear error
c
c	preliminaries, a reset wanted ?
c	-------------------------------
c
	eobm=.false.
	max=bitmap(1)
	if (rec.eq.0) then
	   bitmap(6)=bitmap(4)		!first word used overall
	   bitmap(7)=0
	elseif (rec.lt.0) then
c
c	   just to check it ...
c
	   myrec=-rec
	   pivot=myrec+bitmap(2)	!correct with offset
	   if (pivot.lt.(7*word_s)) goto 90002	!underflow
	   wrd=pivot/word_s		!find word
	   pos=mod(pivot,word_s)
	   if (pos.ne.0) wrd=wrd+1
	   if (wrd.gt.max) goto 90001	!over the top !
c
c	   ok, make it work
c
	   rec=-rec-1
	   pivot=rec+bitmap(2)		!correct with offset
cmota	   if (pivot.lt.(7*word_s)) goto 90002	!underflow
	   wrd=pivot/word_s		!find word,
	   pos=mod(pivot,word_s)
	   if (pos.ne.0) then
	      wrd=wrd+1
	   else
	      pos=32
	   endif
cmota	   if (wrd.gt.max) goto 90001	!over the top !
	   bitmap(6)=wrd
	   bitmap(7)=pos
	endif
c
c	try the current word/position plus one
c	--------------------------------------
c
	wrd=bitmap(6)			!current word
	pos=bitmap(7)			!current position within word
20	continue			!to retry if in word ahead
	if (pos.eq.word_s) then
	   pos=1			!next word
	   wrd=wrd+1
	   if (wrd.gt.max) goto 30	!end of bit map
	else
	   pos=pos+1			!same word, next position
	endif
	kurr=bitmap(wrd)
	do 1002 k=pos,word_s
	   l=kurr.and.mask_(k)
	   if (l.ne.0) then
	      pos=k
	      goto 10			!success within the word !!!
	   endif
1002	continue
c
c	try next words as wholes
c	------------------------
c
	wrd=wrd+1
	do 1003 k=wrd,max
	   kurr=bitmap(k)
	   if (kurr.ne.0) then
	      wrd=k
	      pos=0
	      goto 20			!success in some other word !!!
	   endif
1003	continue
c
c	here end of bitmap
c	------------------
c
30	continue
	bitmap(6)=7+1
	bitmap(7)=0
	eobm=.true.
	return
c
c	here a selected record found
c	----------------------------
c
10	continue
	rec=word_s*(wrd-1)-bitmap(2)+pos
	bitmap(6)=wrd
	bitmap(7)=pos
	return
c
c	errors
c	======
c
c	over the top!!!!!
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITNXT',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitprv_ (bitmap,rec,bobm,erro)
c	*****************************************
c
	implicit none
c
	integer bitmap(*),rec,erro
	logical bobm
c
c	Description
c	===========
c
c	Gives the previous  selected record REC in the
c	bitmap.  It  should be  called again and again
c	until BOBM becomes true. To reset from the end
c	call it with REC = 0.  To reset from a certain
c	REC call it with REC = -REC (tricky...).
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer myrec,kurr,wrd,pos,pivot,max,k,l
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITPRV')
	erro=0				!clear error
c
c	preliminaries, a reset wanted ?
c	-------------------------------
c
	bobm=.false.
	max=bitmap(1)
	if (rec.eq.0) then
	   bitmap(6)=bitmap(1)		!last word
	   bitmap(7)=word_s+1		!and position (+ 1 ...)
	elseif (rec.lt.0) then
c
c	   just to check it ...
c
	   myrec=-rec
	   pivot=myrec+bitmap(2)	!correct with offset
	   if (pivot.lt.(7*word_s)) goto 90002	!underflow
	   wrd=pivot/word_s		!find word
	   pos=mod(pivot,word_s)
	   if (pos.ne.0) wrd=wrd+1
	   if (wrd.gt.max) goto 90001	!over the top !
c
c	   ok, make it work now
c
	   rec=-rec+1			!rec + 1 ...
	   pivot=rec+bitmap(2)		!correct with offset
	   wrd=pivot/word_s		!find word
	   pos=mod(pivot,word_s)
	   if (pos.ne.0) then
	      wrd=wrd+1
	   else
	      pos=word_s
	   endif
	   bitmap(6)=wrd
	   bitmap(7)=pos
	endif
c
c	try the current word/position minus one
c	---------------------------------------
c
	wrd=bitmap(6)			!current word
	pos=bitmap(7)			!current position within word
20	continue			!to retry if in word ahead
	if (pos.eq.1) then
	   pos=word_s			!previous word
	   wrd=wrd-1
	   if (wrd.lt.7+1) goto 30	!"begin" of bit map
	else
	   pos=pos-1			!same word, previous position
	endif
	kurr=bitmap(wrd)
	do 1004 k=pos,1,-1
	   l=kurr.and.mask_(k)
	   if (l.ne.0) then
	      pos=k
	      goto 10			!success within the word !!!
	   endif
1004	continue
c
c	try next previous as wholes
c	---------------------------
c
	wrd=wrd-1
	do 1005 k=wrd,7+1,-1
	   kurr=bitmap(k)
	   if (kurr.ne.0) then
	      wrd=k
	      pos=word_s+1		!+ 1 ...
	      goto 20			!success in some other word !!!
	   endif
1005	continue
c
c	here "begin" of bitmap
c	----------------------
c
30	continue
	bitmap(6)=7+1
	bitmap(7)=0
	bobm=.true.
	return
c
c	here a selected record found
c	----------------------------
c
10	continue
	rec=word_s*(wrd-1)-bitmap(2)+pos
	bitmap(6)=wrd
	bitmap(7)=pos
	return
c
c	errors
c	======
c
c	over the top!!!!!
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITPRV',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitcnt_ (bitmap,rec,cnt,erro)
c	****************************************
c
	implicit none
c
	integer bitmap(*),rec,cnt,erro
c
c	Description
c	===========
c
c	Very  much  like  BITNXT but counts the number of
c	selected  records  without   need   for  calls in
c	succession. If REC=0 reset, REC=-rec reset at REC,
c	if REC ok. By the way result is given back in CNT.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer kurr,wrd,pos,pivot,max,k,l
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITCNT')
	erro=0				!clear error
c
c	preliminaries, a reset wanted ?
c	-------------------------------
c
	cnt=0
	max=bitmap(1)
	if (rec.lt.0) rec=-rec
	if (rec.eq.0) then
	   bitmap(6)=bitmap(4)		!first word used overall
	   bitmap(7)=0
	else
	   rec=rec-1
	   pivot=rec+bitmap(2)		!correct with offset
	   if (pivot.lt.(7*word_s)) goto 90002	!underflow
	   wrd=pivot/word_s		!find word,
	   pos=mod(pivot,word_s)
	   if (pos.ne.0) then
	      wrd=wrd+1
	   else
	      pos=32
	   endif
	   if (wrd.gt.max) goto 90001	!over the top !
	   bitmap(6)=wrd
	   bitmap(7)=pos
	endif
c
c	try the current word/position plus one
c	--------------------------------------
c
	wrd=bitmap(6)			!current word
	pos=bitmap(7)			!current position within word
20	continue			!to retry if in word ahead
	if (pos.eq.word_s) then
	   pos=1			!next word
	   wrd=wrd+1
	   if (wrd.gt.max) goto 30	!end of bit map
	else
	   pos=pos+1			!same word, next position
	endif
	kurr=bitmap(wrd)
	do 1006 k=pos,word_s
	   l=kurr.and.mask_(k)
	   if (l.ne.0) then
	      pos=k
	      goto 10			!success within the word !!!
	   endif
1006	continue
c
c	try next words as wholes
c	------------------------
c
	wrd=wrd+1
	do 1007 k=wrd,max
	   kurr=bitmap(k)
	   if (kurr.ne.0) then
	      wrd=k
	      pos=0
	      goto 20			!success in some other word !!!
	   endif
1007	continue
c
c	here end of bitmap
c	------------------
c
30	continue
	bitmap(6)=7+1
	bitmap(7)=0
	return
c
c	here a selected record found
c	----------------------------
c
10	continue
	bitmap(6)=wrd
	bitmap(7)=pos
	cnt=cnt+1
	goto 20
c
c	errors
c	======
c
c	over the top!!!!!
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITCNT',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitupt_ (bitmap,rec,what,cnt,erro)
c	*********************************************
c
	implicit none
c
	integer bitmap(*),rec,what,cnt,erro
c
c	Description
c	===========
c
c	Tells in WHAT wether the record number REC is select(1)
c	or  de-selected (0). In  CNT  it  gives  the  number of
c	selected records  up  the the  wanted_record's position,
c	ie  the  number  of  one's  found  up  to this position
c	exclusive of this latter.
c
c	var
c	===
c
	include 'own:dbag8.own'
	include 'own:dbag8a.own'
c
	integer max,wrd,pos,p1,p2,p3,p4,l,pivot,kurr,k,pp
c
	character*4 four
	equivalence (kurr,four)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITUPT')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
	pivot=rec+bitmap(2)		!correct with offset
	wrd=pivot/word_s		!find word,
	pos=mod(pivot,word_s)
	if (pos.ne.0) then
	   wrd=wrd+1
	else
	   pos=word_s
	endif
	if (wrd.gt.max) goto 90001	!over the top !
	if (wrd.lt.7+1)   goto 90002	!underflow
c
	kurr=bitmap(wrd)
c
c	selected ?
c
	l=kurr.and.mask_(pos)
	if (l.eq.0) then
	   what=0
	else
	   what=1
	endif
c
c	how many in current word
c
	cnt=0
	do 1001 k=1,pos-1
	   l=kurr.and.mask_(k)
	   if (l.ne.0) then
	      cnt=cnt+1
	   endif
1001	continue
c
c	how many up to now
c
	do 1002 k=bitmap(4),wrd-1
	   kurr=bitmap(k)
	   if (kurr.eq.-1) then		!word is full
	      cnt=cnt+32
	   else				!word is not full
	      p1=ichar(four(1:1))
	      p2=ichar(four(2:2))
	      p3=ichar(four(3:3))
	      p4=ichar(four(4:4))
	      cnt=cnt+nbits(p1)+nbits(p2)+nbits(p3)+nbits(p4)
	   endif
1002	continue
c
	return
c
c	errors
c	======
c
c	record number too big
90001	continue
	erro=1
	goto 99000
c
c	record number too small
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITUPT',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitpos_ (bitmap,pos,rec,erro)
c	****************************************
c
	implicit none
c
	integer bitmap(*),pos,rec,erro
c
c	Description
c	===========
c
c	One  wants  the  nth  selected record in BITMAP. This nth
c	is given in POS (position in terms of selected records !).
c	The  record  is given back in  REC  (brilliant remark...).
c
c	var
c	===
c
	include 'own:dbag8.own'
	include 'own:dbag8a.own'
c
	integer max,wrd,p1,p2,p3,p4,l,kk,kurr,k,pp,cnt,oldcnt
c
	character*4 four
	equivalence (kurr,four)
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITPOS')
	erro=0				!clear error
c
	if (pos.lt.1) goto 90001
c
	max=bitmap(1)			!size of bitmap
c
c	count thru words
c
	cnt=0
	kk=0
	do 1001 k=bitmap(4),max
	   oldcnt=cnt
	   wrd=k
	   kurr=bitmap(k)
	   p1=ichar(four(1:1))
	   p2=ichar(four(2:2))
	   p3=ichar(four(3:3))
	   p4=ichar(four(4:4))
	   cnt=cnt+nbits(p1)+nbits(p2)+nbits(p3)+nbits(p4)
	   if (cnt.ge.pos) then
	      cnt=oldcnt
	      goto 11			!somewhere in this word
	   endif
1001	continue
	goto 90002			!not found
c
c	thru current word
c
11	continue
	kurr=bitmap(wrd)
	do 1002 k=1,word_s
	   kk=k
	   l=kurr.and.mask_(k)
	   if (l.ne.0) then
	      cnt=cnt+1
	      if (cnt.ge.pos) then
	         goto 10		!found
	      endif
	   endif
1002	continue
c
10	continue
	rec=(wrd-1)*word_s+kk
	rec=rec-bitmap(2)		!correct with offset
	return
c
c	errors
c	======
c
c	position too small
90001	continue
	erro=1
	goto 99000
c
c	position too big
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('BITPOS',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitand_ (bitm1,bitm2,erro)
c	*************************************
c
	implicit none
c
	integer bitm1(*),bitm2(*),erro
c
c	Description
c	===========
c
c	Given bimaps BITM1 and BITM2 the .and. of the two
c	is calculated into BITM1 .
c
c	If different offsets, the .and. is executed but and error condition
c	is returned.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer k
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITAND')
	erro=0				!clear error
c
	do 1001 k=7+1,bitm1(1)
	   bitm1(k)=bitm1(k).and.bitm2(k)
1001	continue
c
	if (bitm1(2).ne.bitm2(2)) then
	   goto 90001
	else
	   return
	endif
c
c	errors
c	======
c
c	different offsets
90001	continue
c
	erro=1
	goto 99000
c
99000	continue
	call errset_('BITAND',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitor_ (bitm1,bitm2,erro)
c	************************************
c
	implicit none
c
	integer bitm1(*),bitm2(*),erro
c
c	Description
c	===========
c
c	Given bimaps BITM1 and BITM2 the .or. of the two
c	is calculated into BITM1 .
c
c	If different offsets, the .or. is executed but and error condition
c	is returned.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer k
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITOR')
	erro=0				!clear error
c
	do 1001 k=7+1,bitm1(1)
	   bitm1(k)=bitm1(k).or.bitm2(k)
1001	continue
c
	if (bitm1(2).ne.bitm2(2)) then
	   goto 90001
	else
	   return
	endif
c
c	errors
c	======
c
c	different offsets
90001	continue
c
	erro=1
	goto 99000
c
99000	continue
	call errset_('BITOR',erro)
	return
c
c
	end
c
c
c
c
c
	subroutine bitcpy_ (bitm1,bitm2,erro)
c	*************************************
c
	implicit none
c
	integer bitm1(*),bitm2(*),erro
c
c	Description
c	===========
c
c	Copies from bitm1 to bitm2.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer k
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITCPY')
	erro=0				!clear error
c
	do 1001 k=1,bitm1(1)
	   bitm2(k)=bitm1(k)
1001	continue
	return
c
c	errors
c	======
c
99000	continue
	call errset_('BITCPY',erro)
	return
c
c
	end
c
c
c
c
c
	subroutine bitscp_ (bitmap,inf,sup,erro)
c	****************************************
c
	implicit none
c
	integer bitmap(*),inf,sup,erro
c
c	Description
c	===========
c
c	A whole block between INF and SUP is selected. The
c	rest  of  the  bitmap IS NOT TOUCHED !!! Hence the
c	diference from procedure BITBLK.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer max,wrd,wrd0,wrd1,k,pivot,pos0,pos1
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITSCP')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
c
c	check limits
c
	if (inf.gt.sup) goto 90003	!imbecil
c
c	lower limit
c
	pivot=inf+bitmap(2)		!correct with offset
	wrd0=pivot/word_s		!find word,
	pos0=mod(pivot,word_s)
	if (pos0.ne.0) then
	   wrd0=wrd0+1
	else
	   pos0=32
	endif
	if (wrd0.gt.max) goto 90001	!inf over the top !
	if (wrd0.lt.7+1) then
	   wrd0=7+1			!inf underflow
	   pos0=1
	endif
c
c	upper limit
c
	pivot=sup+bitmap(2)		!correct with offset
	wrd1=pivot/word_s		!find word,
	pos1=mod(pivot,word_s)
	if (pos1.ne.0) then
	   wrd1=wrd1+1
	else
	   pos1=32
	endif
	if (wrd1.gt.max) then
	   wrd1=max			!sup over the top !
	   pos1=32
	endif
	if (wrd1.lt.7+1)   goto 90002	!sup underflow
c
c	do select the scope
c
	if (wrd0.eq.wrd1) then
	   do 1001 k=pos0,pos1
	      bitmap(wrd0)=bitmap(wrd0).or.mask_(k)
1001	   continue
	else
c
c	   first word
c
	   do 1002 k=pos0,word_s
	      bitmap(wrd0)=bitmap(wrd0).or.mask_(k)
1002	   continue
	   wrd0=wrd0+1
c
c	   last word
c
	   do 1003 k=1,pos1
	      bitmap(wrd1)=bitmap(wrd1).or.mask_(k)
1003	   continue
	   wrd1=wrd1-1
c
c	   words in between
c
	   do 1004 k=wrd0,wrd1
	      bitmap(k)=-1
1004	   continue
c
	endif
c
	return
c
c	errors
c	======
c
c	limits over the top
90001	continue
	erro=1
	goto 99000
c
c	limits too small
90002	continue
	erro=2
	goto 99000
c
c	wrong limits
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('BITSCP',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitblk_ (bitmap,inf,sup,erro)
c	****************************************
c
	implicit none
c
	integer bitmap(*),inf,sup,erro
c
c	Description
c	===========
c
c	A whole block between INF and SUP is selected. The
c	rest  of   the   bitmap  IS  ZEROED !!! Hence  the
c	diference from procedure BITSCP.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer max,wrd,wrd0,wrd1,k,pivot,pos0,pos1,pos
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITBLK')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
c
c	check limits
c
	if (inf.gt.sup) goto 90003	!imbecil
c
c	lower limit
c
	pivot=inf+bitmap(2)		!correct with offset
	wrd0=pivot/word_s		!find word,
	pos0=mod(pivot,word_s)
	if (pos0.ne.0) then
	   wrd0=wrd0+1
	else
	   pos0=32
	endif
	if (wrd0.gt.max) goto 90001	!inf over the top !
	if (wrd0.lt.7+1) then
	   wrd0=7+1			!inf underflow
	   pos0=1
	endif
c
c	upper limit
c
	pivot=sup+bitmap(2)		!correct with offset
	wrd1=pivot/word_s		!find word,
	pos1=mod(pivot,word_s)
	if (pos1.ne.0) then
	   wrd1=wrd1+1
	else
	   pos1=32
	endif
	if (wrd1.gt.max) then
	   wrd1=max			!sup over the top !
	   pos1=32
	endif
	if (wrd1.lt.7+1)   goto 90002	!sup underflow
c
c	clean bitmap
c
	do 1001 k=7+1,max
	   bitmap(k)=0
1001	continue
c
c	do select the block
c
	if (wrd0.eq.wrd1) then
	   do 1002 k=pos0,pos1
	      bitmap(wrd0)=bitmap(wrd0).or.mask_(k)
1002	   continue
	else
c
c	   first word
c
	   do 1003 k=pos0,word_s
	      bitmap(wrd0)=bitmap(wrd0).or.mask_(k)
1003	   continue
	   wrd0=wrd0+1
c
c	   last word
c
	   do 1004 k=1,pos1
	      bitmap(wrd1)=bitmap(wrd1).or.mask_(k)
1004	   continue
	   wrd1=wrd1-1
c
c	   words in between
c
	   do 1005 k=wrd0,wrd1
	      bitmap(k)=-1
1005	   continue
c
	endif
c
	return
c
c	errors
c	======
c
c	limits over the top
90001	continue
	erro=1
	goto 99000
c
c	limits too small
90002	continue
	erro=2
	goto 99000
c
c	wrong limits
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('BITBLK',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitclr_ (bitmap,erro)
c	********************************
c
	implicit none
c
	integer bitmap(*),erro
c
c	Description
c	===========
c
c	The bit map is completely cleared.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer max,wrd,wrd0,wrd1,k,pivot,pos0,pos1,pos
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITCLR')
	erro=0				!clear error
c
	max=bitmap(1)			!size of bitmap
c
	do 1001 k=7+1,max
	   bitmap(k)=0
1001	continue
c
	return
c
c	errors
c	======
c
99000	continue
	call errset_('BITCLR',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitlim_ (bitmap,linf,lsup,erro)
c	******************************************
c
	implicit none
c
	integer bitmap(*),linf,lsup,erro
c
c	Description
c	===========
c
c	Gives the limits the BITMAP can hold. The limits
c	are  in  LINF, LSUP  don't ask me which is which.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer kurr,wrd,pos,pivot,max,k,l
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITLIM')
	erro=0				!clear error
c
	max=bitmap(1)
	linf=word_s*7+1-bitmap(2)	!lower limit
	lsup=(max-7)*word_s+linf-1	!upper limit
c
	return
c
c	errors
c	======
c
99000	continue
	call errset_('BITLIM',erro)
	return
c
c
	end
c
c
c
c
	subroutine bitmax_ (bitmap,size,erro)
c	*************************************
c
	implicit none
c
	integer bitmap(*),size,erro
c
c	Description
c	===========
c
c	The actual overall SIZE of the bitmap is given back.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITMAX')
	erro=0				!clear error
c
	size=bitmap(1)			!size of bitmap
c
	return
c
c	errors
c	======
c
	end
c
c
c
c
	subroutine bitinq_ (first,last,size,erro)
c	*****************************************
c
	implicit none
c
	integer first,last,size,erro
c
c	Description
c	===========
c
c	Given  the first record number to be used  FIRST, and
c	the LAST to be used the SIZE  of the array to contain
c	the bitmap is given back.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer k
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BITINQ')
	erro=0				!clear error
c
	if (last.lt.first) goto 90001	!he's mad...
	k=last-first+1
	size=k/word_s
	k=mod(k,word_s)
	if (k.ne.0) size=size+1
	size=7+size
c
	return
c
c	errors
c	======
c
c	wrong records limits
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BITINQ',erro)
	return
c
c
	end
c
c
c
c
	subroutine btoinq_ (bitmap,size,erro)
c	*************************************
c
	implicit none
c
	integer bitmap(*),first,last,size,erro
c
c	Description
c	===========
c
c	Given  a  BITMAP  with  certain records selected, the  size
c	of "parallel" bitmaps, to implement their sorting, is given
c	back in SIZE.
c
c	var
c	===
c
	include 'own:dbag8.own'
c
	integer k,many,lots
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BTOINQ')
	erro=0				!clear error
c
c	how many records selected ?
c
	call bitcnt_ (bitmap,0,many,erro)
	if (erro.ne.0) goto 90001
c
c	find how many (lots) parallel bitmaps are needed
c
	lots=0
1	continue
	   k=2**lots
	   if (many.le.k) goto 2
	   lots=lots+1
	goto 1
2	continue
c
c	find size (size)
c
	size=many/word_s
	k=mod(many,word_s)
	if (k.ne.0) size=size+1
	size=size*lots
	size=size+7		!7 extra words for management
c
	return
c
c	errors
c	======
c
c	error calling BITCNT
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BTOINQ',erro)
	return
c
c
	end
c
c
c
c
	subroutine btoini_ (bitmap,size,erro)
c	*************************************
c
	implicit none
c
	integer bitmap(*),size,erro
c
c	Description
c	===========
c
c	===
c
	include 'own:dbag8.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BTOINI')
	erro=0				!clear error
c
c
	return
c
c	errors
c	======
c
c	error calling BITCNT
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BTOINI',erro)
	return
c
c
	end
c
c
c
c
	subroutine btordr_ (bitmap,size,erro)
c	*************************************
c
	implicit none
c
	integer bitmap(*),size,erro
c
c	Description
c	===========
c
c	var
c	===
c
	include 'own:dbag8.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BTORDR')
	erro=0				!clear error
c
	return
c
c	errors
c	======
c
c	error calling BITCNT
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BTORDR',erro)
	return
c
c
	end
c
c
c
c
	subroutine btonxt_ (bitmap,size,erro)
c	*************************************
c
	implicit none
c
	integer bitmap(*),size,erro
c
c	Description
c	===========
c
c	var
c	===
c
	include 'own:dbag8.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BTONXT')
	erro=0				!clear error
c
c
	return
c
c	errors
c	======
c
c	error calling BITCNT
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BTONXT',erro)
	return
c
c
	end
c
c
c
c
	subroutine btoprv_ (bitmap,size,erro)
c	*************************************
c
	implicit none
c
	integer bitmap(*),size,erro
c
c	Description
c	===========
c
c	var
c	===
c
	include 'own:dbag8.own'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BTOPRV')
	erro=0				!clear error
c
c
	return
c
c	errors
c	======
c
c	error calling BITCNT
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('BTOPRV',erro)
	return
c
c
	end
c
c
c
c
