c	DBAG8A.FOR
c	**********
c
c
c	Overall view
c	============
c
c	DBAG8.FOR   complementary   primitives.  They   implement
c	a  weird  concept  which  could  be  named  as   "ordered
c	bit map". More down to earth given a bitmap and a sorting
c	criteria   for   a   data   base,  these  primitives will
c	produce  a   data   structure  where the records selected
c	in  the  bitmap  are  ordered  according to  the criteria
c	supplied (huf...).
c
c
c	Written by Luis Arriaga da Cunha 1985
c	=====================================
c
c	General remarks
c	===============
c
c
c	Summary of procedures :
c
c	ordini		creates a structure
c	ordkey		actually does the sorting
c	ordnxt		gives the next record in sequence. Can also reset
c	ordclr		clears the structure
c
c
c
c
	subroutine ordini_(base,bitmap,erro)
c	************************************
c
	implicit none
c
	integer base,bitmap(*),erro
c
c	Description
c	===========
c
c	Creates, for  BASE  and  BITMAP, a structure to hold the
c	sorting  of  the  selected  records. For  the moment the
c	structure is  simply a sequential file in disk where the
c	record codes are written . Open to future sophistication.
c
c	var
c	===
c
	integer chan
	character*60 fname
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ORDINI')
	erro=0				!clear error
c
c	create data structure
c	---------------------
c
	call newfil_(fname)
	call newc_(chan)
	if (chan.le.0) goto 90001	!no more i/o channels
	open(unit=chan,file=fname,status='unknown',
     1       carriagecontrol='list',err=90002)
c
	bitmap(3)=chan			!non zero -> ordered bitmap
c
	return
c
c	errors
c	======
c
c	no more i/o channels
90001	continue
	erro=1
	goto 99000
c	can't open sort file
90002	continue
	erro=2
	goto 99000
 
c
99000	continue
	call errset_('ORDINI',erro)
	return
c
c
	end
c
c
c
c
	subroutine ordkey_(base,bitmap,alive,swmap,shmap,ns,
	1                  nrec,nkilled,erro)
c	***************************************************
c
	implicit none
c
	integer base,ns,bitmap(*),alive,swmap(ns),shmap(ns),
	1       nrec,nkilled,erro
c
c	Description
c	===========
c
c	For BASE and BITMAP a sorting is performed as told in
c	SWMAP ( which fields) and SHMAP ( how, ie ascending or
c	descending order).
c	Returns NREC = # of records sorted, NKILLED = # of records ignored
c	(killed).
c
c	cons
c	====
c
	integer long
	parameter ( long = 81 )	!why the hell eighty ONE ?!
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external dsc$k_dtype_t,dsc$k_dtype_nl,	!(sort: text, left signed str.
	1	 dsc$k_dtype_f,dsc$k_dtype_d	!       real, double precision
c
	character*132 text
	character*60 fname
	integer type,val,chan
	integer*2 key32(long)
	integer code,icode,loc,lim1,fld,siz,pos,fin,k,key2,keycount,b2,see
	integer dbcode
	logical card,eobm
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ORDKEY')
	erro=0				!clear error
c
	nrec=0
	nkilled=0
c
c	Open fields to be sorted and build key for SORT32
c	-------------------------------------------------
c
	card=.false.				!assume no rec# specified
c
	pos=9+1					!room for rec#
c
	key2=2
	keycount=1
	do 1001 k = 1, ns
	   if (key2+3.gt.long) goto 90001	!too many keys !!!
	   fld=swmap(k)
	   if (fld.gt.0) then
c
	      call zsize_(base,fld,siz,erro)
	      if (erro.ne.0) goto 95000
	      call zkind_(base,fld,type,erro)
	      if (erro.ne.0) goto 95000
	      if     (type.eq.n$.or.		!integer
     1            type.eq.x$    ) then		!or decimal
	         key32(key2)=%loc(dsc$k_dtype_nl)!left signed string
	      elseif (type.eq.r$) then
	         key32(key2)=%loc(dsc$k_dtype_f)!real
	      elseif (type.eq.r8$) then
	         key32(key2)=%loc(dsc$k_dtype_d)!double precision
	      else
	         key32(key2)=%loc(dsc$k_dtype_t)!text
	      endif
	   else
	      card=.true.			!rec#, remeber that
	      key32(key2)=%loc(dsc$k_dtype_t)	!text (always > 0)
	      siz=9				!rec# size
	   endif
c
	   key32(key2+1)=0			!ascending
	   if (shmap(k).eq.2) key32(key2+1)=1	!nops, descending
	   key32(key2+2)=pos-1			!0 = first byte!
	   key32(key2+3)=siz			!size
	   key2=key2+4
	   keycount=keycount+1
	   pos=pos+siz
1001	continue
c
c	use rec# itself as last criteria unless specified by caller
c
	if (.not.card) then
	   key32(key2)=%loc(dsc$k_dtype_t)	!text (always > 0)
	   key32(key2+1)=0			!ascending
	   key32(key2+2)=0			!0 = first byte!
	   key32(key2+3)=9			!rec# size
	else
	   keycount=keycount-1			!"fix" count
	endif
c
	key32(1)=keycount
	chan=bitmap(3)				!i/o channel
	if (chan.le.0) goto 90003		!none!
c
c	go thru selected records and pick up the fields to sort
c	-------------------------------------------------------
c
	code=0					!reset bitmap
	icode=0
	eobm=.false.
	call bitnxt_(bitmap,icode,eobm,erro)
	if (erro.ne.0) goto 95000
	call in3ex_(base,icode,code,erro)
	if (erro.ne.0) goto 95000
c
cwhile	do while (.not.eobm)			!loop in bitmap
1098	continue
	   if (eobm) goto 1099
c
	   call find_(base,code,alive,d$xbuf,erro)
	   if (erro.ne.0) then
	      if (d$rsub.eq.'FIND'.and.
	1         d$erro.eq.5          ) then
	         call bitzer_ (bitmap,icode,erro)!killed record, ignore
	         if (erro.ne.0) goto 95000
	         nkilled=nkilled+1		!account killed record
	         goto 50			!next record
	      endif
	      goto 95000
	   endif
c
c	   record number in 1st 9 positions
c
	   call wrivar_(text,code,9,erro)
	   if (erro.ne.0) goto 90002		!write error
	   loc=9+1
c
	   do 1002 k = 1, ns
	      fld=swmap(k)
	      if (fld.eq.0) then
	         siz=9						!rec# size
	         call wrivar_(text(loc:),code,siz,erro)		!rec#
	         if (erro.ne.0) goto 90002			!write error
	      else
	         call zsize_(base,fld,siz,erro)
	         if (erro.ne.0) goto 95000
	         call zkind_(base,fld,type,erro)
	         if (erro.ne.0) goto 95000
	         pos=d$pos(fld,base)
c
c	         If o.d.b. and other field, get actual data
c
	         if (d$type(fld,base).eq.db$) then
	            dbcode=0
	            call cunflt_(base,d$cbuf,dbcode,fld,d$xbuf,erro)
	            if (erro.ne.0) goto 95000
	            b2=d$dbio(fld,base)
	            see=d$see(fld,base)
	            if (b2.gt.0.and.			!o.d.b. field
	1               dbcode.gt.0.and.		!record#
	1               see.gt.0) then			!and see a field
	               call find_(b2,dbcode,alive,d$xbuf,erro)
	               if (erro.ne.0) then
	                  if (d$rsub.eq.'FIND'.and.
	1                     d$erro.eq.5          ) then
c
	                  endif
	                  goto 95000
	               endif
	               pos=d$pos(see,b2)		!"fix" pos
	               type=d$type(see,b2)		!and type
	            endif
c
	         endif
c
	         fin=pos+siz-1
	         if (type.eq.n$.or.				!integer
     1               type.eq.x$    ) then			!or decimal
c
	            call rdivar_(d$xbuf(pos:fin),val,siz,erro)
	            if (erro.ne.0) goto 90002			!read error
c
	            call wrivar2_(text(loc:),val,siz,siz-1,erro)
	            if (erro.ne.0) goto 90002			!read error
	         else
	            if (type.eq.c$) then
	               mssg(1:siz)=d$xbuf(pos:fin)
	               call uc8to7_(mssg(1:siz))	!multinational...
	               write(text(loc:),'(a)')mssg(1:siz)
	            else
	               write(text(loc:),'(a)')d$xbuf(pos:fin)
	            endif
	         endif
	      endif
c
	      loc=loc+siz
1002	   continue
c
	   write(chan,'(a)')text(1:loc-1)
c
	   nrec=nrec+1				!account record sorted
c
c	   Next record from bitmap
c
50	   continue
	   call bitnxt_(bitmap,icode,eobm,erro)	!next record in bitmap
	   if (erro.ne.0) goto 95000
	   call in3ex_(base,icode,code,erro)
	   if (erro.ne.0) goto 95000
c
	   goto 1098
1099	continue
cwhile	enddo		!loop in bitmap
c	-------------------------------
c
c	give the file to SORT32 and re-open file
c	----------------------------------------
c
	inquire(chan,name=text)
	close(unit=chan)
	lim1=index(text,';')-1			!get rid of version #
	if (lim1.le.0) lim1=1			!never happens...
	call newfil_(fname)
	call nsort_(text(1:lim1),fname,key32)
c
	open(unit=chan,file=text(1:lim1),
     1       status='old',carriagecontrol='list',err=1122)
	close(unit=chan,dispose='delete')
1122	continue
c
	open(unit=chan,file=fname,
     1       status='old',carriagecontrol='list')
c
	return
c
c	errors
c	======
c
c	too many sorting keys
90001	continue
	erro=1
	goto 99000
c	internal error: read/write error
90002	continue
	erro=2
	goto 99000
c	internal error: bitmap has no i/o ch.
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('ORDKEY',erro)
	return
c
c	inherited errors
95000	continue
	return
c
c
c
	end
c
c
c
c
	subroutine ordnxt_(bitmap,rec,eobm,erro)
c	****************************************
c
	implicit none
c
	integer bitmap(*),rec,erro
	logical eobm
c
c	Description
c	===========
c
c	Gives  the next  selected  record REC in the ordered
c	bitmap.	It  should  be  called again and again until
c	EOBM  becomes true. To reset from the beginning call
c	it with REC = 0. To reset from a certain REC call it
c	with REC = -REC (tricky...).
c
c	var
c	===
c
cx	integer chan,what,irec,icode
	integer chan,what
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ORDNXT')
	erro=0				!clear error
c
c	preliminaries, a reset wanted ?
c	-------------------------------
c
	eobm=.false.
	chan=bitmap(3)
c
	if (rec.eq.0) then
	   rewind(chan)
	endif
c
c	try to find a record
c	--------------------
c
9	continue
	read(chan,'(i9)',err=90001,end=30)rec
	call bitget_(bitmap,rec,what,erro)
	if (erro.ne.0) goto 90001
	if (what.eq.0) goto 9		!try next...
10	continue
	return
c
c	here end of structure
c	---------------------
c
30	continue
	rec=0
	eobm=.true.
	return
c
c	errors
c	======
c
c	error reading bitmap
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('ORDNXT',erro)
	return
c
c
	end
c
c
c
c
	subroutine ordclr_(bitmap,erro)
c	*******************************
c
	implicit none
c
	integer bitmap(*),erro
c
c	Description
c	===========
c
c	Clears the ordered structure so that the sorting
c	is canceled.
c
c	var
c	===
c
	integer chan
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('ORDCLR')
	erro=0				!clear error
c
c	close data structure and mark bitmap as non ordered
c	---------------------------------------------------
c
	chan=bitmap(3)
	if (chan.gt.0) then
	   close(unit=chan,dispose='delete',err=100)
100	   continue
	   call freec_(chan)
	   bitmap(3)=0
	endif
c
	return
c
c	errors
c	======
c
99000	continue
	call errset_('ORDCLR',erro)
	return
c
c
	end
c
c
c
c
