c	DBAGA.FOR
c	*********
c
c	Internal procedures that  implement  DBAG  commands.
c	- for "junk" commands, procedures names are junk$?.
c	- for special commands, procedures names are  SPC$??.
c	- for usual commands, procedures names are X$PTO (up to 6 characters)
c	  for command XPTO.
c	Interactive i/o channels are d$cmdi/d$cmdo
c
c	Summary of procedure calls:
c
c	JUNK$R				[record#]
c
c	SPC$AT				[@file]
c
c	A$PPEN, B$ROWS, C$HANG, C$ONTI, C$OPY,  C$OUNT, C$REAT, D$ELET, D$ISPL,
c	E$DIT,  E$XIT,  F$IND,  G$OTO,  H$ELP,  I$NDEX, U$NLOA, J$OIN,  L$IST,
c	H$OST,  M$ODIF, P$ACK,  R$EAD,  R$ENAM, R$EPLA, R$EPOR, S$ELEC, K$ILL,
c	S$ET,   S$UM,   R$ELOA,  S$ORT,  T$OTAL, U$P,    U$PDAT, U$SE,   V$MS,
c	E$DT,   T$PU,   N$EWS,  M$ENU,  S$EARC, C$LOSE, C$ANCE, D$EFIN, R$ESTO,
c	S$AVE,  Z$ERO,  N$OIND, P$AUSE, R$EIND
c
c
c
	subroutine JUNK$R_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements "digit" command, that means record# to set as current one.
c	This "command" is an implicit GOTO RECORD nnn command.
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer type,val,dec,lim,p1,p2,erro,update,mode,base
	real rval
	character*12 bname
c
	call errclr_('JUNK$R')			!clear error
c
	erro=0
	call rstok_(buf,1,erro)
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0.or.type.ne.2) goto 90001	!shoudn't happen!!!
c
	if (val.lt.1) goto 90002		!can't be zero
c
c	>>>>>> Execute <n> "command"
c	============================
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90003		!eol expected
c
	update=-1					!don't change update
	mode=0						!usual mode
	call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	if (erro.ne.0) return				!error, carry
	if (base.eq.0) return				!no base, return
	call i$goto_(val,erro)			!>>>>>>> Execute GOTO command
	if (erro.ne.0) then
	   if (d$rsub.eq.'I$GOTO'.and.			!"acceptable" errors
     1         (erro.eq.1.or.				!empty base
     1          erro.eq.2   )      ) then		!or out of TOP-BOTTOM
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_(d$rsub,erro,mssg,'%')	!get error message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	         if (erro.ne.0) return			!error, carry
	         call errclr_('JUNK$R')			!clear error
	         d$edit=1				!set edit mode
	      endif
	      return					!return
	   else
	      return					!error, carry
	   endif
	endif
c
	return
c
c	Errors
c	======
c
c	intok unexpected error or record# "lost"
90001	continue
	erro=1
	goto 99000
c	record# can't be zero
90002	continue
	erro=2
	mark=p1
	goto 99000				!display error
c	eol expected
90003	continue
	erro=3
	mark=p1
	goto 99000				!display error
c	Give error message (?...) and return
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('JUNK$R',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('JUNK$R',erro)
	endif
	return					!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine SPC$AT_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements @ command:
c
c	@ <cmdfile.ext>			= implemented =
c	Changes current input command channel to file cmdfile (default
c	extension AT$EXT1 or AT$EXT2).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	character*60 fname
	character*12 fext
	integer what,size
	integer type,val,dec,lim,p1,p2,erro
	real rval
	character*132 mymssg
	logical msg1,msg2
c
c	begin
c	=====
c
	call errclr_('SPC$AT')			!clear errors
c
c	Look for filespec
c
	fname(1:)=' '
	call infspc_(type,what,fname,fext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90002		!file spec expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	if (what.ne.3) then
	   call givext_(fname,fext)		!add extension
	   call uc_(fext)
	   if (fext.ne.at$ext1.and.
	1      fext.ne.at$ext2     ) then
	      call chkext_(fname,erro)		!check extension if not default
	      if (erro.ne.0) then
	         if (d$itrv.eq.1) then		!interactive
	            call errmsg_('CHKEXT',erro,mssg,'%')
	            call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) return	!error, carry
	            call errclr_('SPC$AT')	!clear error
	            d$edit=1			!set edit mode
	            mark=0			!...
	         endif
	         return				!and return
	      endif
	   endif
	endif
c
c	>>>>>>>> execute command @ <cmdfile>
c	====================================
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90003		!eol expected
c
c	Try both at$ext1 and at$ext2 extensions if not specified by user
c
	msg1=.false.
	msg2=.false.
c
	if (what.eq.3) call givext_(fname,at$ext1)!default extension
	call i$atdw_(fname(1:),erro)		!go down one level
	if (erro.ne.0) then
	   if (erro.eq.1) then
	      msg1=.true.
	      call errmsg_(d$rsub,erro,mymssg,'?')!get message
	      if (what.eq.3) then
	         call givext_(fname,at$ext2)!alias
	         call i$atdw_(fname(1:),erro)	!go down one level
	         if (erro.ne.0) then
	            if (erro.eq.1.or.erro.eq.2) then
	               msg2=.true.
	               call errmsg_(d$rsub,erro,mssg,'?')!get message
	               goto 950			!"acceptable" errors
	            else
	               return			!error, carry
	            endif
	         endif
	      else
	         goto 950			!"acceptable" errors
	      endif
	   else
	      return				!error, carry
	   endif
	endif
c
	return					!return
c
c	Do nothing
c	----------
c
800	continue
	return
c
c	"Acceptable errors" (from I$ATDW)
c	---------------------------------
c
950	continue
c
	if (msg1) then
	   if (d$itrv.eq.1) then		!interactive
	      call i$mess_(0,d$cmdo,-1,mymssg,-1,erro)!display it
	      if (erro.ne.0) return		!error, carry
	   endif
	endif
c
	if (msg2) then
	   if (d$itrv.eq.1) then		!interactive
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!display it
	      if (erro.ne.0) return		!error, carry
	   endif
	endif
c
	call errclr_('SPC$AT')			!clear error
	d$edit=1				!and set edit mode
c
	return					!return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!give error message and return
c	file spec expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!give error message and return
c	eol expected
90003	continue
	mark=p1
	erro=3
	goto 99000			!give error message and return
c	Give error message (?...) and return
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('SPC$AT',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('SPC$AT',erro)
	endif
c
	return					!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine A$PPEN_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements APPEND command:
c
c	APPEND [SCOPE  <scope list>]
c	       [FOR    <cond. list>]
c	       [FIELDS <field list>]
c	       			     [BYFIELDNUMBER/BYNAME/BYLIST]
C				     FROM <database>
c				     [TO  <database/file.ext> [SDF/DBAG]
c							      [NEW/OLD]
c
c	appends data FROM a database to the database in use if [TO] phrase
c	is ommited, or to database or file in SDF or DBAG format.
c
c                 e.g., APPEND FROM MAILLIST FOR NAME = 'N'
c                       APPEND ALL FROM MAILLIST TO TEXT.ML DBAG
c
c	APPEND			     [BYFIELDNUMBER/BYNAME/BYLIST]
c				     FROM <file.ext> [SDF/DBAG]
c				     [NOCHECK]
c				     [TO  <database> ]
c
c	appends all records FROM a file in SDF or DBAG format to the
c	database use if [TO] phrase is ommited, or to specified database.
c	specified; if NOCHECK, input data will not be validated.
c
c                 e.g., APPEND FROM MAILLIST
c                       APPEND FROM MAILLIST TO TEXT
c
c	APPEND BLANK		[TO] <database/file.ext> [SDF/DBAG]
c
c	appends a blank, i.e. empty, record to database
c	or file in SDF or DBAG format.
c
c	APPEND 			[TO] <database/file.ext> [SDF/DBAG]
c
c	allows user to add a new record to database or file in SDF or
c	DBAG format.
c
c	If indexes in use, the index files are automatically updated.
c
c	If CARRY is SET ON, previous record, if any, is carried to current
c	record-to-append when appending data from terminal.
c
c	When appending to file, output file may be superseded (if NEW specified)
c	or appended (if OLD specified). Default is NEW.
c
c	Default FIELDS is all fields.
c
c	Default SCOPE when appending from a database is ALL records.
c
c	Default <file.ext> format is DBAG (file DBAGF.FOR for details).
c
c	When appending records from database or file to a database, fields may
c	be transferred from input to ouput in three ways:
c
c	a. BYFIELDNUMBER (default): only selected input fields that exist in
c	   output base (by its field number) will be transferred;
c
c	b. BYNAME: only fields with the same mnemonic will be transferred,
c	   regardless of its field numbers;
c
c	c. BYLIST: fileds will be transferred according to an interactively
c	   given list of (input,output) fields.
c
c	N.B.: If appending to database, this one becomes current database
c	      as well as last appended record, current search if any is
c	      cancelled and search bitmap is extended if nedded.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external istrip_,tty_putc_,tty_echo_,spfchl_
	integer istrip_,tty_putc_,tty_echo_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,what,recsiz,sz
	integer start,size,sizmax,topscr,margin,edtlin,status,tmp,pos1,pos2
	integer lx,cx,term,used,myused,ibase,ichan,obase,ochan,irec,recnum
	real rval
	integer nfor,nscope,nfield,nto,nfrom,nisdf,nidbf,nosdf,nodbf,nnochk
	integer nblank,nimpin,nimpou,line,bmsize,bitinf,bitsup,izf,izl,mast,
     1          zf,zl,topr,scpinf,scpsup,nmatch,filrec,ifsiz,ofsiz,noerr
	character*60 ifname,ofname
	character*12 mybuf,ifext,ofext
	character*10  lcmnem,www,cmmd,basenm,when,usrnam,where,mymnem
	character*3 newold
	character*1 bell
	character*30 race
	integer irace,idim,isize,ideci,hisrace
	integer interr,reccount,kcount,k,kval,kkk,l,
	1	quit,alive,lstrec,mnd,line1
	integer bm,bmsz,fm,fmsz,fwht,fwhtsz,fwho,fwhosz,fmdt,fmdtsz,nkill,ngarb
	integer pm,pmsz,sm,smsz,mm,mmsz
	integer dnfld,all,allsiz,who,cnt,rec,inpopn,outopn,ntrunc,nbad,b2
	logical new,twice,cursrc,eof,eobm,always,found,eow,blnk,trunc,killed
	logical answer,fsem,fall,prefix,badrec,garbage,errstp,askerr,topbot
	integer ftrans,nnew,nold,nbyfi,nbyna,nbyli,totnby,xmin,xmax,usrsiz,fff
	integer prop,propsz,pswi
	character*32 bywhat
	character*(vlong) lcpage(psiz),lcvmsg(psiz)
	integer vfield(psiz),vftype(psiz)
	character*1 hlpmsg(psiz)
	logical dohlp,fledt(d$f),fwrite,protfail,reset,
	1	oldprop,defprop,defseries,defmemo,dokill,doinsert
	logical norec,property,series,memo,switch
	integer function,nnorec,nproperty,nseries,nmemo,totelem,linelem
	character*10 owname,aliename
c
c	begin
c	=====
c
	call errclr_('A$PPEN')		!error init
c
	bell=char(7)
	bmsz=0			!temporary bit map (bm) space size
	fmsz=0			!temporary regular field map (fm) space size
	pmsz=0			!same for properties
	smsz=0			!same for series
	mmsz=0			!same for memos
	fwhtsz=0		!temporary WHAT (fwht) space size
	fwhosz=0		!temporary WHOWHO (fwho) space size
	fmdtsz=0		!temporary destination field map(fmdt)space size
	all=d$f+2			!.....size
	cursrc=.false.			!assume CURRENT SEARCH will not be used
	inpopn=.false.
	outopn=.false.
	fsem=.false.			!assume no need to call FORSEM
	fall=.false.			!same about FORALL
	reset=.true.			!reset field map
c
	nblank=0			!#[BLANK]
	nnochk=0			!#[NOCHECK]
	nfor=0				!#[FOR ...]
	nscope=0			!#[SCOPE ...]
	nfield=0			!#[FIELD ...]
	nfrom=0				!#[FROM]
	nto=0				!#[TO]
	nisdf=0				!#[FROM] [SDF]
	nimpin=0			!# implicit [FROM] <file.ext>
	nidbf=0				!#[FROM] [DBAG]
	nosdf=0				!#[TO]   [SDF]
	nodbf=0				!#[TO]   [DBAG]
	nimpou=0			!# implicit [TO] <file.ext>
	nnew=0				!#NEW
	nold=0				!#OLD
	nbyfi=0				!#BYFIELDNUMBER
	nbyna=0				!#BYNAME
	nbyli=0				!#BYLIST
	nnorec=0			!#NORECORDS
	nproperty=0			!#PROPERTY
	nseries=0			!#SERIES
	nmemo=0				!#MEMO
c
	nkill=0
	ngarb=0
c
	dohlp=.true.			!tell editor to do help
	norec=.false.			!edit data base records
	property=.false.		!don't edit properties
	series=.false.			!series
	memo=.false.			!memos
	switch=.false.			!no switch
c
	new=.true.			!Supersede if appending to file(default)
	errstp=s$set(s$erro)		!ERRORSTOP
	askerr=.true.			!Ask user about ERRORSTOP anyway
c
	ifname(1:)=' '			!input databse name/file name
	ifext(1:)=' '			!and extension
	ibase=0				!input base channel
	ichan=0				!input file.ext i/o channel
	ofname(1:)=' '			!output databse name/file name
	ofext(1:)=' '			!and extension
	obase=0				!output base channel
	ochan=0				!output file.ext i/o channel
c
c	Loop here to get next keyword or implicit scope
c	-----------------------------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1.and.
     1   	type.ne.2    ) then
	   goto 90002			!syntax error (neither identifier,
					!              integer, or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, go complete/execute APPEND com.
	elseif (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
c	Loop here if token is a keyword (from SCOPE, FOR, FIELDS, TO or FROM)
c	or an implicit scope
c	---------------------------------------------------------------------
c
2	continue
c
	if (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.scopky)  then
	   nscope=nscope+1		!count it
	   goto 100			!"eat" [SCOPE...]
	elseif (keypos.eq.forky)  then
	   nfor=nfor+1			!count it
	   goto 200			!"eat" [FOR <exp list>]
	elseif (keypos.eq.fielky) then
	   nfield=nfield+1		!count it
	   goto 300			!"eat" [FIELDS <field list>]
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 400			!"eat" [TO] phrase
	elseif (keypos.eq.noreky) then
	   nnorec=nnorec+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.propky) then
	   nproperty=nproperty+1	!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.seriky) then
	   nseries=nseries+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.memoky) then
	   nmemo=nmemo+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.fromky) then
	   nfrom=nfrom+1		!count it
	   goto 500			!"eat" [FROM] phrase
	elseif (keypos.eq.blanky) then
	   nblank=nblank+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.nochky) then
	   nnochk=nnochk+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.newky) then
	   nnew=nnew+1			!count it
	   new=.true.			!set it
	   goto 1			!and loop back for more
	elseif (keypos.eq.oldky) then
	   nold=nold+1			!count it
	   new=.false.			!set it
	   goto 1			!and loop back for more
	elseif (keypos.eq.byfiky) then
	   nbyfi=nbyfi+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.bynaky) then
	   nbyna=nbyna+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.byliky) then
	   nbyli=nbyli+1		!count it
	   goto 1			!and loop back for more
	else
	   nscope=nscope+1		!count it
	   goto 101			!other keyword, try SCOPE
	endif
c
c	Here to "eat" [SCOPE ...]
c	-------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
101	continue
c
c	Avoid loops due to implicit call to SCPSYN with non-scope keyword
c	-----------------------------------------------------------------
c
	if    (nscope.gt.1) goto 90008	!unexpected keyword
c
c	submit SCOPE syntactical analysis
c	---------------------------------
c
	erro=0				!only my own error messages
	call scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from SCOPE expression with next token
c	------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute APPEND command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FOR ...]
c	-----------------------
c
200	continue
c
c	submit FOR syntactical analysis
c	-------------------------------
c
	erro=0				!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from FOR expression with next token
c	----------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute APPEND command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FIELDS ...]
c	--------------------------
c
300	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	erro=0				!only my own error messages
	call fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
	reset=.false.			!don't reset anymore
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from FIELDS expression with next token
c	-------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute APPEND command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [TO] <database/file.ext> [SDF/DBAG]
c	------------------------------------------------------
c
400	continue
c
c	get <database/file.ext>
c	-----------------------
c
c	Look for filespec
c
	ofname(1:)=' '
	ofext(1:)=' '
	call infspc_(type,what,ofname,ofext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90011		!database/file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	if (what.eq.1.or.
     1      what.eq.2   ) then
	   nimpou=nimpou+1			!count implicit TO file.ext
	else
	   if (index(ofname,':').gt.0.or.	!file spec anyway
     1         index(ofname,'[').gt.0   ) then
	      nimpou=nimpou+1			!count implicit TO file.ext
	   endif
	endif
c
c	get keyword SDF or DBAG
c	----------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
	if (type.ne.0.and.
     1      type.ne.2.and.
     1      type.ne.1    ) goto 90006	!syntax error (not identifier,
					!integer or eol)
	if (type.eq.0) goto 600		!eol, go complete/execute APPEND com.
c
	if (type.eq.2) goto 2		!integer, go back
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.sdfky) then
	   nosdf=nosdf+1		!count it
	   goto 1			!loop back for more
	elseif (keypos.eq.dbagky) then
	   nodbf=nodbf+1		!count it
	   goto 1			!loop back for more
	else
	   goto 2			!keyword found
	endif
c
c	Here to "eat" [FROM] <database/file.ext> [SDF/DBAG]
c	--------------------------------------------------------
c
500	continue
c
c	get <database/file.ext>
c	-----------------------
c
c	Look for filespec
c
	ifname(1:)=' '
	ifext(1:)=' '
	call infspc_(type,what,ifname,ifext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90011		!database/file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	if (what.eq.1.or.
     1      what.eq.2   ) then
	   nimpin=nimpin+1			!count implicit FROM file.ext
	else
	   if (index(ifname,':').gt.0.or.	!file spec anyway
     1         index(ifname,'[').gt.0   ) then
	      nimpin=nimpin+1			!count implicit FROM file.ext
	   endif
	endif
c
c	get keyword SDF or DBAG
c	----------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
	if (type.ne.0.and.
     1      type.ne.2.and.
     1      type.ne.1    ) goto 90006	!syntax error (not identifier,
					!integer or eol)
	if (type.eq.0) goto 600		!eol, go complete/execute APPEND com.
c
	if (type.eq.2) goto 2		!integer, go back
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.sdfky) then
	   nisdf=nisdf+1		!count it
	   goto 1			!loop back for more
	elseif (keypos.eq.dbagky) then
	   nidbf=nidbf+1		!count it
	   goto 1			!loop back for more
	else
	   goto 2			!keyword found
	endif
c
c	>>>>>> Here to check/complete/execute APPEND command
c	====================================================
c
600	continue
c
c	Check APPEND command
c	--------------------
c
c	Indicators:
c
c	nblank			#[BLANK]
c	nfor			#[FOR ...]
c	nnochk			#[NOCHECK]
c	nscope			#[SCOPE ...]
c	nfield			#[FIELD ...]
c	nfrom			#[FROM]
c	nto			#[TO]
c	nisdf			#[FROM] [SDF]
c	nimpin			# implicit [FROM] <file.ext>
c	nidbf			#[FROM] [DBAG]
c	nosdf			#[TO]   [SDF]
c	nodbf			#[TO]   [DBAG]
c	nimpou			# implicit [TO] <file.ext>
c	nnew			#NEW
c	nold			#OLD
c	nbyfi			#BYFIELDNUMBER
c	nbyna			#BYNAME
c	nbyli			#BYLIST
c	nproperty		#PROPERTY
c	nseries			#SERIES
c	nmemo			#MEMO
c
c	Formats:
c
c	1. APPEND [BLANK] 			[TO database/file.ext]
c
c	2. APPEND SCOPE/FOR/FIELDS		FROM  database
c						[TO   database/file.ext]
c
c	4. APPEND				FROM  file.ext
c						[TO   database]
c
c	Implicit FROM/TO "file.ext" defaults to DBAG format
c	--------------------------------------------------------
c
	call uc_(ifname)			!upper case all names
	call uc_(ifext)			!...
	call uc_(ofname)			!...
	call uc_(ofext)			!...
c
	if (nimpin.gt.0.and.		!implicit FROM file.ext
     1      nisdf.eq.0.and.			!and no SDF found
     1      nidbf.eq.0     ) then		!and no DBAG found
	   nidbf=1				!"fake" DBAG found
	endif
c
	if (nimpou.gt.0.and.		!implicit TO file.ext
     1      nosdf.eq.0.and.			!and no SDF found
     1      nodbf.eq.0     ) then		!and no DBAG found
	   nodbf=1				!"fake" DBAG found
	endif
c
	if (nnorec.gt.0) norec=.true.
	if (nproperty.gt.0) property=.true.
	if (nseries.gt.0) series=.true.
	if (nmemo.gt.0) memo=.true.
c
c	Do checking now
c	---------------
c
	if (nblank.gt.1.or.
     1      nnochk.gt.1.or.
     1      nfor  .gt.1.or.
     1      nscope.gt.1.or.
     1      nfield.gt.1.or.
     1      nfrom .gt.1.or.
     1      nto   .gt.1.or.
     1      nisdf .gt.1.or.
     1      nimpin.gt.1.or.
     1      nidbf .gt.1.or.
     1      nosdf .gt.1.or.
     1      nodbf .gt.1.or.
     1      nnew  .gt.1.or.
     1      nold  .gt.1.or.
     1      nbyfi .gt.1.or.
     1      nbyna .gt.1.or.
     1      nbyli .gt.1.or.
     1      nnorec.gt.1.or.
     1      nproperty.gt.1.or.
     1      nseries.gt.1.or.
     1      nmemo.gt.1.or.
     1      nimpou.gt.1   ) then
	   goto 90013				!duplicate requests on command
	endif
c
	if ((nnew.gt.0.or.nold.gt.0).and.	!NEW or OLD
     1       nosdf.eq.0.and.			!and no TO SDF found
     1       nodbf.eq.0     ) then		!and no TO DBAG found
	   goto 90022
	endif
c
	if (nnochk.gt.0.and.			!NOCHECK
     1      nisdf.eq.0.and.			!and no FROM SDF found
     1      nidbf.eq.0       ) then		!and no FROM DBAG found
	   goto 90037
	endif
c
	if (nbyfi.gt.0.or.		!BYFIELDNUMBER seen
     1      nbyna.gt.0.or.		!or BYNUMBER
     1      nbyli.gt.0    ) then	!or BYLIST, and
c
	   if (nfrom.le.0.or.
     1         nto  .le.0    ) then
	      goto 90024		!no FROM or no TO
	   endif
c
	   if (nosdf.gt.0.or.
     1         nimpou.gt.0.or.
     1         nodbf.gt.0    ) then
	      goto 90025		!TO file.ext
	   endif
c
	   totnby=nbyfi+nbyna+nbyli	!count them
	   if (totnby.gt.1) then
	      goto 90026		!make up your mind...
	   endif
c
	endif
c
	if (nfield.gt.0.and.		!FIELDS seen
     1      (nbyna.gt.0.or.
     1       nbyli.gt.0   ) ) then
	   goto 90028				!and BYNAME or BYLIST
	endif
c
	if (nfor.gt.0) then		!FOR seen
	   if (nfrom.le.0  ) goto 90009		!and no FROM database
	endif
c
	if (nscope.gt.0.or.		!FIELD, SCOPE or FOR seen
     1      nfield.gt.0.or.
     1      nfor  .gt.0    ) then
	   if (nblank.gt.0 ) goto 90010		!and BLANK
	endif
c
	if (nblank.gt.0.and.		!BLANK seen
     1      nfrom.gt.0     ) goto 90012		!and FROM
c
	if ((nisdf.gt.0.or.
     1       nimpin.gt.0.or.
     1       nidbf.gt.0).and.		!FROM file.ext
     1      (nosdf.gt.0.or.
     1       nimpou.gt.0.or.
     1       nodbf.gt.0)    )goto 90014		!and TO file.ext
c
	if (nscope.gt.0.or.		!SCOPE or FOR seen
     1      nfor  .gt.0    ) then
	   if (nfrom.le.0 ) goto 90027		!FROM "nowhere"
	   if (nisdf .gt.0.or.
     1         nimpin.gt.0.or.
     1         nidbf .gt.0    ) goto 90027	!or FROM file.ext
	endif
c
	if (norec) then
	   if (.not.property.and.
	1      .not.series.and.
	1      .not.memo         ) goto 90042	!append to what ?
	endif
c
c	Complete APPEND command now and inform user
c	-------------------------------------------
c
c	Once completed:	ibase  - input  base channel (ifname - inp. base name)
c			obase  - output base channel (ofname - out. base name)
c			ifname - input base name or
c				 input file.ext with	nisdf > 0 if SDF format
c							nidbf > 0 if DBAG
c							ichan - i/o channel
c			ofname - output base name or
c				 output file.ext with	nosdf > 0 if SDF format
c							nodbf > 0 if DBAG
c							ochan - i/o channel
c			nblank - if > 0, append blank records from tt:
c
c
c	By field number, name or list
c
	if     (nbyfi.gt.0) then
	   bywhat(1:)='(field transfer by field NUMBER)'
	   ftrans=1
	elseif (nbyna.gt.0) then
	   bywhat(1:)='(field transfer by field NAME)'
	   ftrans=2
	elseif (nbyli.gt.0) then
	   bywhat(1:)='(field transfer by field LIST)'
	   ftrans=3
	else
	   bywhat(1:)='(field transfer by field NUMBER)'
	   ftrans=1
	endif
c
	if (nbyli.gt.0) goto 90035	!BYLIST not yet supported
c
	if (nisdf.gt.0) then		!from SDF file and
	   if (nbyli.gt.0.or.
	1      nbyna.gt.0    ) then	!bylist or byname
	      goto 90036		!can't do that
	   endif
	endif
c
	if (nproperty.gt.0) property=.true.
	if (nseries.gt.0) series=.true.
	if (nmemo.gt.0) memo=.true.
	if (nnorec.gt.0) norec=.true.
c
	if (nto.le.0.and.
     1      nosdf.le.0.and.
     1      nodbf.le.0    ) then
c
c	TO <database in use>
c	--------------------
c
	   update=1					!open/update
	   mode=0					!usual mode
	   call i$buse_(obase,update,mode,ofname,erro)	!ask for cur. out. base
	   if (erro.ne.0) goto 900			!fatal error, return
	   if (obase.le.0) goto 900			!no base, do nothing
	   call uc_(ofname)				!upper case name
c
c	   Append to creatures as well, so (re)open them all
c
	   call opncrt_(obase,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('A$PPEN')			!ignore errors
	      erro=0
	   endif
c
	endif
c
	if (nto.gt.0.and.
     1      nosdf.le.0.and.
     1      nodbf.le.0    ) then
c
c	TO <database>
c	-------------
c
	   size=istrip_(ofname)
	   if (size.gt.9) then
	      size=9
	      ofname(size+1:)=' '
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg,10031) ofname(1:size)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!truncated to ...
	         if (erro.ne.0) goto 900			!error, carry
	      endif
	   endif
c
	   update=1					!open/update
	   mode=0					!usual mode
	   call open_(obase,ofname,update,mode,outopn,erro)!open database
	   if (erro.ne.0) then
	      if     ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.3              ) then	!no such base
	         erro=16				!my own error
	         call errset_('A$PPEN',erro)	     	!set it
	         goto 90016
	      elseif ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.9              ) then	!base locked
	         erro=17				!my own error
	         call errset_('A$PPEN',erro)	     	!set it
	         goto 90017
	      else
	         goto 95000				!show error
	      endif
	   endif
c
c	   Append to creatures as well, so (re)open them all
c
	   call opncrt_(obase,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('A$PPEN')			!ignore errors
	      erro=0
	   endif
c
	endif
c
c	====================================================
c	TRIVIAL CASES:	Append from tt: to <database   xpto>
c		     	Append from tt: to <database in use>
c	====================================================
c
	if (nto.le.0.and.		!no TO phrase
     1      nfrom.le.0  ) then		!and no FROM phrase
c
	   if (d$itrv.eq.1) then		!interactive
	      if (outopn) then
	         call i$sopn_(obase,erro)	!be nice...
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	      write (mssg,10012) ofname(1:istrip_(ofname))!be nice...
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   if (nfield.lt.1) then		!no FIELDS,
	      dnfld=d$nfld(obase)
	      fwrite=.true.			!fields are to be updated
	      call i$fakf_(obase,'ALL',dnfld,fwrite,
	1                  protfail,erro)	!"fake" FLDSYN (ALL fields)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	   if (d$itrv.eq.1) then		!interactive
	      if (nblank.gt.0) then		!appending BLANK
	         write (mssg,10021)		!be nice...
	      else
	         if (nfield.lt.1) then
	            write (mssg,10010)		!be nice...
	         else
	            write (mssg,10011)		!be nice...
	         endif
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   goto 610				!append to database in use
c
	endif
c
	if (nto.gt.0.and.		!TO phrase
     1      nosdf.le.0.and.		!(but not to
     1      nodbf.le.0.and.		!file)
     1      nfrom.le.0    ) then	!and no FROM phrase
c
	   if (d$itrv.eq.1) then		!interactive
	      if (outopn) then
	         call i$sopn_(obase,erro)	!be nice...
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	      write (mssg,10012) ofname(1:istrip_(ofname))!be nice...
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   if (nfield.lt.1) then		!no FIELDS,
	      dnfld=d$nfld(obase)
	      fwrite=.true.			!fields are to be updated
	      call i$fakf_(obase,'ALL',dnfld,fwrite,
	1                  protfail,erro)	!"fake" FLDSYN (ALL fields)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	   if (d$itrv.eq.1) then		!interactive
	      if (nblank.gt.0) then		!appending BLANK
	         write (mssg,10021)		!be nice...
	      else
	         if (nfield.lt.1) then		!no FIELDS,
	            write (mssg,10010)		!be nice...
	         else
	            write (mssg,10011)		!be nice...
	         endif
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   goto 610				!append to database
c
	endif
c
c	Complete all other cases now (FROM, SCOPE, FOR, FIELDS, TO)
c	-----------------------------------------------------------
c
	if (nfrom.gt.0) then
	   if (nisdf.gt.0.or.
     1         nidbf.gt.0   ) then
c
c	FROM file.ext
c	-------------
c
	      if (istrip_(ifext).le.0) then		!no extension
	         if     (nisdf.gt.0) then		!and SDF format
	            ifext(1:)='.SDF'			!extension = .SDF
	         else					!DBAG format
	            ifext(1:)='.DBA'			!extension = .DBA
	         endif
	      endif
c
	      call givext_(ifname,ifext)			!add extension
c
	      if (d$itrv.eq.1) then			!interactive
	         if (outopn) then
	            call i$sopn_(obase,erro)		!be nice...
	            if (erro.ne.0) goto 900		!error, carry
	         endif
	         if (nisdf.gt.0) then
	            write (mssg,10005) ifname(1:istrip_(ifname))!be nice...
	         else
	            write (mssg,10014) ifname(1:istrip_(ifname))!be nice...
	         endif
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
	      if (nfield.lt.1) then		!no FIELDS,
	         dnfld=d$nfld(obase)
	         fwrite=.true.			!fields are to be updated
	         call i$fakf_(obase,'ALL',dnfld,fwrite,
	1                     protfail,erro)	!"fake" FLDSYN (ALL field)
	         if (erro.ne.0) goto 900	!error, carry
	         write (mssg,10010)		!be nice...
	      else
	         write (mssg,10011)		!be nice...
	      endif
	      if (d$itrv.eq.1) then		!interactive
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   else
c
c	FROM <database>
c	---------------
c
	      if (d$itrv.eq.1) then			!interactive
	         if (inpopn) then
	            call i$sopn_(ibase,erro)		!be nice...
	            if (erro.ne.0) goto 900		!error, carry
	         endif
	         if (outopn) then
	            call i$sopn_(obase,erro)		!be nice...
	            if (erro.ne.0) goto 900		!error, carry
	         endif
	         write (mssg,10004) ifname(1:istrip_(ifname))!be nice...
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
c
	      size=istrip_(ifname)
	      if (size.gt.9) then
	         size=9
	         ifname(size+1:)=' '
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10031) ifname(1:size)
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	            if (erro.ne.0) goto 900		!error, carry
	         endif
	      endif
c
	      update=-1					!open/read...
	      mode=0					!usual mode
	      call open_(ibase,ifname,update,mode,outopn,erro)!open database
	      if (erro.ne.0) then
	         if     ((d$rsub.eq.'OPNBAS').and.
     1                    erro.eq.3              ) then		!no such base
	            erro=18					!my own error
	            call errset_('A$PPEN',erro)	     	        !set it
	            goto 90018
	         elseif ((d$rsub.eq.'OPNBAS').and.
     1                    erro.eq.9              ) then		!base locked
	            erro=19					!my own error
	            call errset_('A$PPEN',erro)	     	        !set it
	            goto 90019
	         else
	            goto 95000					!show error
	         endif
	      endif
c
c	      Append from creatures as well, so (re)open them all
c
	      call opncrt_(ibase,update,defprop,defseries,defmemo,erro)
	      if (erro.ne.0) then
	         call errclr_('A$PPEN')		!ignore errors
	         erro=0
	      endif
c
c	      default SCOPE is: CURRENT SEARCH if any;
c			        ALL records if no CURRENT SEARCH.
c
	      if (nscope.le.0) then		!no SCOPE
	         if (bitcan(ibase).eq.1) then	!and no CURRENT SEARCH
	            cursrc=.false.		!remember CURR. SEARCH not used
	            call i$faks_('ALL',0,erro)	!"fake" SCPSYN (ALL records)
	            if (erro.ne.0) goto 900	!error, carry
	            if (d$itrv.eq.1) then	!interactive
	               if (nfor.le.0) then
	                  write (mssg,10008)	!be nice...
	               else
	                  write (mssg,10019)	!be nice...
	               endif
	               call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	               if (erro.ne.0) goto 900	!error, carry
	            endif
c
	         else				!use current search
	            cursrc=.true.		!remember CURRENT SEARCH used
c
c	            see if CURRENT SEARCH is empty
c
	            rec=0			!don't forget anybody...
	            call bitcnt_(%val(bitpnt(ibase)),rec,cnt,erro)
	            if (erro.ne.0) goto 900	!error, carry
	            if (cnt.le.0) goto 90032	!empty!
c
	            if (d$itrv.eq.1) then		!interactive
	               if (nfor.gt.0) then
	                  write (mssg,10016)		!be nice...
	               else
	                  write (mssg,10017)		!be nice...
	               endif
	               call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	               if (erro.ne.0) goto 900		!error, carry
	            endif
	         endif
c
	      else				!use SCOPE
	         cursrc=.false.			!remember CURR. SEARCH not used
	         if (d$itrv.eq.1) then		!interactive
	            if (nfor.gt.0) then
	               write (mssg,10009)	!be nice...
	            else
	               write (mssg,10018)	!be nice...
	            endif
	            call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
c
c	      Use always temporary BIT MAP; if CURRENT SEARCH used, both
c	      bits maps should have the same definition (BITOR ...)
c
	      if (cursrc) then
	         call bitlim_(%val(bitpnt(ibase)),izf,izl,erro)	!fake zf,zl
	         if (erro.ne.0) goto 900			!error, carry
	         call in3ex_(ibase,izf,zf,erro)
	         if (erro.ne.0) goto 900			!error, carry
	         call in3ex_(ibase,izl,zl,erro)
	         if (erro.ne.0) goto 900			!error, carry
	         call bitmax_(%val(bitpnt(ibase)),bmsz,erro)	!bitmap size
	         if (erro.ne.0) goto 900			!error, carry
	         call get_vm_(4*bmsz,bm,erro)			!ask for room
	         if (erro.ne.0) goto 90031			!no memory!
	         call bitini_(%val(bm),bmsz,izf,topr,erro)
	         if (erro.ne.0) goto 900			!error, carry
	         call bitor_(%val(bm),%val(bitpnt(ibase)),erro)
	         if (erro.ne.0) return				!error, carry
	      else
	         zf=d$unus-d$offs(ibase)+1			!first record#
	         izf=zf
	         call zend_(ibase,zl,erro)			!and last
	         if (erro.ne.0) goto 900			!error, carry
	         call ex3in_(ibase,zl,izl,erro)
	         if (erro.ne.0) goto 900			!error, carry
	         if (izl.le.0) then
	            bmsz=8
	         else
	            bmsz=(izl-izf+1)/32+8			!bit map size
	         endif
	         call get_vm_(4*bmsz,bm,erro)			!ask for room
	         if (erro.ne.0) goto 90031			!no memory!
	         call bitini_(%val(bm),bmsz,izf,topr,erro)
	         if (erro.ne.0) goto 900			!error, carry
	      endif
c
c	default FOR (no specific defaults)
c
c	default FIELDS
c
	      if (nfield.lt.1) then		!no FIELDS,
	         dnfld=d$nfld(ibase)
	         fwrite=.false.			!fields are not to be updated
	         call i$fakf_(ibase,'ALL',dnfld,fwrite,
	1                     protfail,erro)	!"fake" FLDSYN (ALL field)
	         if (erro.ne.0) goto 900	!error, carry
	         write (mssg,10010)		!be nice...
	      else
	         write (mssg,10011)		!be nice...
	      endif
	      if (d$itrv.eq.1) then		!interactive
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
c	      complete SCOPE if not CURRENT SEARCH
c
	      if (.not.cursrc) then
	         call scpchk_(ibase,%val(bm),
     1                       scpinf,scpsup,alive,topbot,erro)!check it
	         if (erro.ne.0) then
	            mark=0
	            goto 95000		!display others error, return any
					!memory space, set edit mode and return
	         endif
	         if (topbot) goto 90041	!TOP/BOTTOM adjustment
	         call scpsem_(%val(bm),erro)		!complete scope
	         if (erro.ne.0) then
	            mark=0
	            goto 95000		!display others error, return any
					!memory space, set edit mode and return
	         endif
	      endif
c
c	      validate SCOPE if
c			FOR not specified and CURRENT SEARCH not used
c
	      if (nfor.le.0.and.
     1            .not.cursrc   ) then
	         fall=.true.				!call FORALL later
	      endif
c
c	      Check/complete FOR
c
	      if (nfor.gt.0) then
c
c	         allocate temporary space
c
	         fwhtsz=all
	         fwhosz=all
	         call get_vm_(4*fwhtsz,fwht,erro)
	         if (erro.ne.0) goto 90031			!no memory!
	         call get_vm_(4*fwhosz,fwho,erro)
	         if (erro.ne.0) goto 90031			!no memory!
c
c	         Check FOR list validity against data base
c
	         call forchk_(ibase,all,%val(fwho),%val(fwht),allsiz,erro)
c
c	         if errors in fields, types, etc be nice and give full report
c
	         if (erro.ne.0) then
	            mark=0
	            if (erro.eq.1) then			!type conflict
	               call i$fker_(ibase,allsiz,%val(fwho),%val(fwht),erro)
	               if (erro.ne.0) goto 900		!error, carry
	               erro=1				!recover error paternity
	               call errset_('FORCHK',erro)	!...
	            endif
	            goto 95000				!everybody goes
	         endif
	      endif
c
c	      FOR semantic execution
c
	      if (nfor.gt.0) then
	         fsem=.true.				!call FORSEM later
	      endif
c
	   endif
c
	endif
c
	if (nto.gt.0) then
	   if (nosdf.gt.0.or.
     1         nodbf.gt.0   ) then
c
c	TO file.ext
c	-----------
c
	      if (istrip_(ofext).le.0) then	!no extension
	         if (nosdf.gt.0) then		!and SDF format
	            ofext(1:)='.SDF'			!extension = .SDF
	         else				!DBAG format
	            ofext(1:)='.DBA'			!extension = .DBA
	         endif
	      endif
c
	      call givext_(ofname,ofext)		!add extension
	      if ( (nosdf.gt.0.and.
     1   	    ofext.ne.'.SDF').or.
     1             (nodbf.gt.0.and.
     1              ofext.ne.'.DBA')   ) then
	         call chkext_(ofname,erro)	!check extension if appliable
	         if (erro.ne.0) then
	            if (d$itrv.eq.1) then	!interactive
	               call errmsg_('CHKEXT',erro,mssg,'%')
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	               if (erro.ne.0) goto 900	!error, carry
	               call errclr_('A$PPEN')	!clear error
	               d$edit=1			!set edit mode
	               mark=0			!...
	            endif
	            goto 900			!return properly
	         endif
	      endif
c
	      if (nfrom.le.0) then		!no FROM phrase, append "like"
						!current base
	         update=-1			!don't change
	         mode=0				!usual mode
	         call i$buse_(ibase,update,mode,ifname,erro)
	         if (erro.ne.0) goto 900	!fatal error, return
	         if (ibase.le.0) goto 900	!no base, just return properly
	         call uc_(ifname)		!upper case name
c
c	         Append to creatures as well, so (re)open them all
c
	         call opncrt_(ibase,update,defprop,defseries,defmemo,erro)
	         if (erro.ne.0) then
	            call errclr_('A$PPEN')	!ignore errors
	            erro=0
	         endif
c
c	default FIELDS
c
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10015) ifname(1:istrip_(ifname))!be nice...
	            call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	         if (nfield.lt.1) then		!no FIELDS,
	            dnfld=d$nfld(ibase)
	            fwrite=.false.		!fields are not to be updated
	            call i$fakf_(ibase,'ALL',dnfld,fwrite,
	1                        protfail,erro)	!"fake" FLDSYN (ALL f.)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	         if (d$itrv.eq.1) then		!interactive
	            if (nblank.gt.0) then	!appending BLANK
	               write (mssg,10021)	!be nice...
	            else
	               if (nfield.lt.1) then	!all fields (fake'd)
	                  write (mssg,10010)	!be nice...
	               else
	                  write (mssg,10011)	!be nice...
	               endif
	            endif
	            call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
c
	   else
c
c	TO <database>
c	-------------
c
c	      See if input spec = output spec
c
	      if (ifname.eq.ofname.and.
     1            ifext .eq.ofext     ) goto 90015	!input = output
c
	      if (d$itrv.eq.1) then			!interactive
	         write (mssg,10006) ofname(1:istrip_(ofname))	!be nice...
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
c
	   endif
c
	else
c
c	TO <database in use>
c	--------------------
c
	   if (d$itrv.eq.1) then			!interactive
	      write (mssg,10006) ofname(1:istrip_(ofname))	!be nice...
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
c
c	Call FORALL/FORSEM if needed
c	----------------------------
c
	if (norec) goto 1122		!skip owner base stuff
c
	if (fall) then
	   call forall_(ibase,alive,%val(bm),erro)!validate bmap
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	endif
c
	if (fsem) then
	   call forsem_(ibase,alive,%val(bm),bmsz,
     1                  lcpage,%val(fwht),erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!others error
	   endif
	endif
c
1122	continue
c
c	======================================================================
c	NON-TRIVIAL CASES:	Append to   <file.ext> ("like" database in use)
c				Append from <file.ext> to <database>
c				Append from <database> to <database>
c							  <file.ext>
c	=======================================================================
c
	if     (nfrom.le.0.and.		!no FROM phrase and
     1          (nosdf.gt.0.or.		!TO SDF phrase or
     1           nodbf.gt.0)  ) then	!TO DBAG phrase
c
	   goto 650			!go execute APP to <file.ext> comm.
c
	elseif (nfrom.gt.0.and.		!FROM SDF or DBAG <file.ext>
     1          (nisdf.gt.0.or.
     1           nidbf.gt.0)  ) then
	   goto 710			!goto execute APP from <file.ext> comm.
c
	elseif (nfrom.gt.0.and.		!FROM <database> phrase
     1          nisdf.le.0.and.
     1          nidbf.le.0     ) then
	   if (nosdf.le.0.and.
     1         nodbf.le.0      ) then		!TO <database>
	      goto 750			!APP FROM <database> TO <database>
	   else
	      goto 810			!APP FROM <database> TO SDF/DBAG
	   endif
	endif
c
	goto 90023			!forgot something...???!!!
c
c	>>>>>> APPEND or APPEND BLANK TO <database>
c	===========================================
c
610	continue
c
	if (us$bat) goto 90038			!not if a batch user
c
	if (d$prt(obase).ne.0) then		!protection ON
	   do k = 1, d$nfld(obase)		!see if protected fields
	      if (d$prfl(k,obase).ne.prtrw) then
	         goto 90039			!sorry, can't append
	      endif
	   enddo
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call i$wlin_(24,erro)		!wait at line 24
	   if (erro.lt.0) then			!command has been aborted
	      erro=0				!clear error
	      goto 900				!return properly
	   endif
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
 	reccount=0				!# of appended records
c
	call zrace_(obase,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
c
c	If not a regular base, switch to owner base
c
	if (irace.ne.r$b) then				!not a regular base
c
	   switch=.true.
	   pswi=obase
c
	   ofname(1:)=' '
	   ofname=d$ownb(obase)				!open owner base
	   update=1					!open/update
	   mode=0					!usual mode
	   call open_(obase,ofname,update,mode,outopn,erro)!open database
	   if (erro.ne.0) then
	      if     ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.3              ) then	!no such base
	         erro=16				!my own error
	         call errset_('A$PPEN',erro)	     	!set it
	         goto 90016
	      elseif ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.9              ) then	!base locked
	         erro=17				!my own error
	         call errset_('A$PPEN',erro)	     	!set it
	         goto 90017
	      else
	         goto 95000				!show error
	      endif
	   endif
c
c	   Append to creatures as well, so (re)open them all
c
	   call opncrt_(obase,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('A$PPEN')			!ignore errors
	      erro=0
	   endif
c
	   norec=.true.				!no owner records
c
	   if     (irace.eq.r$pp) then
	      property=.true.
	      series=.false.
	      memo=.false.
	   elseif (irace.eq.r$mm) then
	      property=.false.
	      series=.false.
	      memo=.true.
	   else
	      property=.false.
	      series=.true.
	      memo=.false.
	   endif
c
	endif
c
c	If no records, skip owner database stuff
c
	if (norec) goto 123
c
	call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)!lower/upper record#
	if (erro.ne.0) goto 900				!error, carry
c
c	complete FIELDS
c
	fmsz=all				!regular field map size
	call get_vm_(4*fmsz,fm,erro)		!ask for room
	if (erro.ne.0) goto 90031		!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90031
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90031
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90031
c
	fmdtsz=fmsz				!dest. field map size
	call get_vm_(4*fmdtsz,fmdt,erro)	!ask for room
	if (erro.ne.0) goto 90031		!no memory!
c
	fwrite=.true.				!fields are to be updated
	call fldsem_(obase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90030		!no # in append command
c
c	Use all/selected fields
c
	used=0
	do 1001 k = 1, c$fn
	   call outk_(%val(fm),k,kval)	!hard to read, the field map...
	   if (kval.gt.0) then		!ignore if 0 (record#)
	      used=used+1		!next field idx
	      vfield(used)=kval		!store it
	   endif
1001	continue
	myused=used			!don't loose it...
c
c	clean buffer, set blink, load limits and default values (first time)
c
	do 1002 k=1,myused
	   lcpage(k)(1:)=' '
	   blink(k)=vedbli
	   call zmndt_(obase,k,mnd,erro)
	   if (erro.ne.0) goto 900
	   if (mnd.eq.0) then
	      vftype(k)=vfrw$			!read/write
	   else
	      vftype(k)=vfrwm$			!read/write/mandatory
	   endif
1002	continue
c
	call vdeflt_(obase,myused,vfield,lcpage,erro)
	if (erro.ne.0 ) goto 900				!error, carry
	myused=used
c
c	All mandatory without default values in there ?
c
	ofsiz=c$fn
	call i$mndt_(obase,%val(fm),ofsiz,erro)
	if (erro.ne.0) goto 95000		!go display error
c
c	Flag all fields as non-specified by user
c
	do 1003 k = 1, d$nfld(obase)
	   fledt(k)=.false.			!no field edited by user
1003	continue
c
123	continue
c
c	Loop back here to append more records if creatures
c
6110	continue
c
c	If no records, skip owner database stuff
c
	if (norec) goto 234
c
	call vlimit_(obase,myused,vfield,vmssg,msiz,psiz,
     1              kind,mini,maxi,pics,erro)
	if (erro.eq.3.and.d$rsub.eq.'VLIMIT') then		!protected field
c	   ignore it, field isn't in field map!!
	else
	   if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	   if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	   if (erro.ne.0 ) goto 900				!error, carry
	endif
	myused=used
c
234	continue
c
c	Loop back here to append more records if no creatures
c
611	continue
c
c	Next free record# if append to data base
c
	if (.not.norec) then
	   call znext_(obase,recnum,erro)
	   if (d$rsub.eq.'ZNEXT'.and.		!record# too big 
	1      erro.eq.4) goto 95000
	   if (erro.ne.0) goto 900		!error, carry
c
c	   Set new current base/record
c
	   if (recnum.ne.c$rec.or.
     1         obase.ne.c$base    ) then
	      call i$sprv_(c$base,c$rec,c$fld)	!save current
	      call i$scur_(obase,recnum,0)	!set new current
	   endif
	endif
c
c	If no records, skip owner database stuff
c
	if (norec) goto 345
c
	call erase_page_(2,1)		!clean screen from line 2
c
c	if CARRY is SET OFF, clean buffer and load default values
c
	if (.not.s$set(s$carr)) then
	   do 1004 k=1,used
	      lcpage(k)(1:)=' '
1004	   continue
	   call vdeflt_(obase,myused,vfield,lcpage,erro)
	   if (erro.ne.0 ) goto 900				!error, carry
	   myused=used
	endif
c
	if (nblank.le.0) then	!not appending BLANKs
c
	   lx=1				!here we go with vedit if not blank
	   cx=1
	   mode=2			!<ret> enough to EXIT
	   start=1
	   size=start+myused-1
	   sizmax=size
	   topscr=-1
	   margin=-1
	   edtlin=24
	   db$rec=0			!no duplicate record# allowed
	   dokill=.false.		!no ^Z KILL
	   doinsert=.false.		!no ^Z INSERT
	   call vedits_(spfchl_,mode,start,size,topscr,margin,lx,cx,vmssg,msiz,
     1   	       lcpage,psiz,myused,mini,maxi,pics,kind,term,xpos,
     1                 ypos,blink,edtlin,dohlp,hlpmsg,sizmax,status,
     1                 vftype,dokill,doinsert,erro)
	   if (erro.ne.0) goto 900	!error, carry
c
	   if (.not.s$set(s$talk)) then	!sorry, no talk as before
	      call tty_echo_(.false.)
	   endif
c
	else
	   myused=used			!blanks, fake exit from editor
	   status=-1
	endif
c
345	continue
c
	if (norec) status=1		!make it work ...
c
c	And now, brave people, do append if that is the case
c
	if (status.gt.0.or.		!user EXITed with ^Z EX
     1      status.eq.-1  ) then	!user <ret>'urned at the bottom
c
c	If no records, skip owner database stuff
c
	   if (norec) goto 456
c
	   blnk=.true.			!assume all fields have spaces...
c
c	   Set PAGE correctly if not appending blanks
c
	   if (nblank.le.0) then
c
	      myused=used
	      if (nfield.le.0) then			!FIELDS not seen
	         do 10045 k = 1, d$nfld(obase)
	            page(k)(1:)=lcpage(k)(1:)		!copy all fields
	            fledt(k)=.true.			!remember edited
	            if (istrip_(lcpage(k)).gt.0) blnk=.false.
10045	         continue
	      else
	         do 1005 k = 1, d$nfld(obase)
	            page(k)(1:)=' '			!clear them all
1005	         continue
	         do 1006 k = 1, myused
	            fff=vfield(k)			!field#
	            page(fff)(1:)=lcpage(k)(1:)		!copy used fields
	            fledt(fff)=.true.			!remember edited
	            if (istrip_(lcpage(k)).gt.0) blnk=.false.
1006	         continue
c
	      endif
c
	   else
	      do 1007 k = 1, myused
	         blnk=.false.				!make it work...
	         fff=vfield(k)				!field#
	         page(fff)(1:)=' '			!append blank
	         fledt(fff)=.true.			!remember edited
1007	      continue
	   endif
c
	   if (.not.blnk) then
c
c	      Load default values for non-specified fields
c
	      do 1008 k = 1, d$nfld(obase)
	         if (.not.fledt(k)) then
	            b2=d$dbio(k,obase)
	            mast=d$mast(k,obase)
	            if (b2.gt.0.and.mast.gt.0) then
	               if (d$type(mast,b2).ne.r8$) then	!no def. for double pr.
	                  call cunflt_(b2,page(k),tmp,mast,d$dflt(b2),
	1                              erro)
	                  if (erro.ne.0) goto 900	!error, carry
	               else
	                  page(k)(1:)=' '
	               endif
	            else
	               if (d$type(k,obase).ne.r8$) then	!no def. for double pr.
	                  call cunflt_(obase,page(k),tmp,k,d$dflt(obase),
	1                              erro)
	                  if (erro.ne.0) goto 900	!error, carry
	               else
	                  page(k)(1:)=' '
	               endif
	            endif
	         endif
1008	      continue
c
	      erro=-16381744			!don't validate
	      call append_(obase,recnum,page,erro)
	      if (erro.ne.0) then
	         if (d$rsub.eq.'OPX'.and.
	1            erro.eq.5) goto 95000	!can't open index file
	         goto 900			!error, carry
	      endif
	      reccount=reccount+1		!account appended record
	      lstrec=recnum			!save last record
c
	      if (bitcan(obase).ne.1) then
	         call bitclr_(%val(bitpnt(obase)),erro)!clear search bitmap
	         if (erro.ne.0) goto 900	      !error, carry
	         bitcan(obase)=1		!current search = 'none'
	      endif
c
	      if (recnum.gt.bitsup) then	!doesn't fit in bitmap
	         call i$bclr_(obase,erro)	!get rid of it
c	         if (erro.ne.0) noerror
	         bmsize=0			!default size
	         call i$bini_(obase,bmsize,erro)!allocate a new and fresh bmap
                 if (erro.ne.0) goto 900	!error, carry
	         call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
456	      continue
c
c	      Append to properties if wanted
c
	      if (defprop.and.property) then
	         do k = 1, d$nfld(obase)
	            if (d$type(k,obase).eq.p$) then
	               prop=d$dbio(k,obase)
	               if (prop.gt.0) then
	                  if (.not.switch.or.
	1                     (switch.and.prop.eq.pswi)) then
	                     call erase_page_(2,1)	!clean screen from line2
	                     oldprop=.false.		!a new property
	                     function=2			!appending
	                     if (norec) then
	                        recnum=-1		!let I$EDPP ask for it
	                     endif
	                     line1=2			!use screen from line 2
	                     call i$edpp_(obase,prop,recnum,oldprop,
	1                                 function,line1,erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                  endif
	               endif
	            endif
	         enddo
	      endif
c
c	      Series
c
	      if (defseries.and.series) then

	      endif
c
c	      Memos
c
	      if (defmemo.and.memo) then

	      endif
c
	   endif
c
	   goto 613				!EXIT from editor
c
	else				!user QUITed
	   myused=used
	   goto 612				!QUIT from editor
	endif
c
c	QUIT, restore screen and previous current base/record
612	continue
c
	call vset2_(1)				!clean screen from line 1
	call vset3_(2,24)			!normal scrolling
	call i$scur_(c$pbas,c$prec,c$pfld)	!set previous curr.
	goto 618				!proceed
c
c	EXIT, restore screen and set new current base/record
613	continue
c
	if (nblank.le.0) then
	   call vset2_(1)			!clean screen from line 1
	   call vset3_(2,24)			!normal scrolling
	endif
	goto 614				!proceed
c
614	continue
c
	if (nblank.gt.0) goto 618		!appending blanks, all done
	if (blnk) then				!<ret> <ret>
	   call vset2_(1)			!clean screen from line 1
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$pbas,c$prec,c$pfld)	!set previous curr.
	   goto 618				!all done
	endif
c
	if (norec) then
	   call vset2_(1)			!clean screen from line 1
	   call vset3_(2,24)			!normal scrolling
	   if (recnum.le.0) recnum=0
	   call i$scur_(obase,recnum,0)		!set curr.
	   goto 618				!all done
	endif
c
	if (defprop.and.property.or.
	1   defseries.and.series.or.
	1   defmemo.and.memo        ) then
	   goto 6110				!append more records
	else
	   goto 611				!append more records
	endif
c
c	All done
c
618	continue
c
	if (d$itrv.eq.1) then			!interactive
c
	   if (.not.norec) then
	      if    (nblank.gt.0) then
	         write (mssg,10020)		!blank record appended
	      elseif (reccount.le.0) then
	         write (mssg,10022)		!no record appended
	      elseif (reccount.gt.1) then
	         write (mssg,10003) reccount
	      else
	         write (mssg,10002)
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, return
	   endif
c
	endif
c
	goto 900				!return anyway...
c
c	>>>>>> APPEND TO <FILE.EXT> ("like" database)
c	=============================================
c
650	continue
c
	call zrace_(ibase,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (irace.ne.r$b) goto 90043		!not a regular base
c
	if (us$bat) goto 90038			!not if a batch user
c
	if (nosdf.gt.0) then			!SDF format
	   if (d$prt(ibase).ne.0) then		!protection ON
	      do k = 1, d$nfld(ibase)		!see if protected fields
	         if (d$prfl(k,ibase).ne.prtrw) then
	            goto 90040			!sorry, can't use SDF
	         endif
	      enddo
	   endif
	endif
c
 	reccount=0				!# of appended records
	recnum=0
c
c	Open output <file.ext> and inform user
c
c	record size
c
	recsiz=x$rec+10				!max. buffers size
c
	call newc_(ochan)
	if (ochan.le.0) goto 90029		!no more i/o channels
	if (new) then
	   newold='NEW'
	else
	   newold='OLD'
	endif
c
	if (nosdf.gt.0) then
	   call f$ohdr_(ochan,ibase,ofname,newold,recsiz,'SDF',buf,
     1                 erro)			!SDF file (Ascii...)
	else
	   call f$ohdr_(ochan,ibase,ofname,newold,recsiz,'DBAG',buf,
     1                 erro)			!DBAG file (Ascii...)
	endif
	if (erro.ne.0) goto 95000		!go display error
c
	if (d$itrv.eq.1) then			!interactive
	   if (nosdf.gt.0) then
	      write (mssg,10007) ofname(1:istrip_(ofname)),newold!be nice...
	   else
	      write (mssg,10013) ofname(1:istrip_(ofname)),newold!be nice...
	   endif
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call i$wlin_(24,erro)		!wait at line 24
	   if (erro.lt.0) then			!command has been aborted
	      erro=0				!clear error
	      goto 900				!return properly
	   endif
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
c	complete FIELDS
c
	fmsz=all				!field map size
	call get_vm_(4*fmsz,fm,erro)		!ask for room
	if (erro.ne.0) goto 90031		!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90031
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90031
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90031
c
	fmdtsz=fmsz				!dest. field map size
	call get_vm_(4*fmdtsz,fmdt,erro)	!ask for room
	if (erro.ne.0) goto 90031		!no memory!
c
	fwrite=.false.				!fields are not to be updated
	call fldsem_(ibase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90030		!no # in append command
c
c	Use all/selected fields
c
	used=0
	do 1009 k = 1, c$fn
	   call outk_(%val(fm),k,kval)	!hard to read, the field map...
	   if (kval.gt.0) then		!ignore 0 (record#)
	      used=used+1		!next field idx
	      vfield(used)=kval		!store it
	   endif
1009	continue
	myused=used			!don't loose it...
c
c	clean buffer, set blink, load limits and default values (first time)
c
	do 1010 k=1,myused
	   lcpage(k)(1:)=' '
	   blink(k)=vedbli
	   call zmndt_(ibase,k,mnd,erro)
	   if (erro.ne.0) goto 900
	   if (mnd.eq.0) then
	      vftype(k)=vfrw$			!read/write
	   else
	      vftype(k)=vfrwm$			!read/write/mandatory
	   endif
1010	continue
c
	call vlimit_(ibase,myused,vfield,vmssg,msiz,psiz,
     1              kind,mini,maxi,pics,erro)
	if (erro.eq.3.and.d$rsub.eq.'VLIMIT') then		!protected field
c	   ignore it, field isn't in field map!!
	else
	   if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	   if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	   if (erro.ne.0 ) goto 900				!error, carry
	endif
	myused=used
c
	call vdeflt_(ibase,myused,vfield,lcpage,erro)
	if (erro.ne.0 ) goto 900				!error, carry
	myused=used
c
c	Loop back here to append more records
c
651	continue
c
	call erase_page_(2,1)		!clean screen from line 2
c
c	if CARRY is SET OFF, clean buffer and load default values
c
	if (.not.s$set(s$carr)) then
	   do 1011 k=1,used
	      lcpage(k)(1:)=' '
1011	   continue
	   call vdeflt_(ibase,myused,vfield,lcpage,erro)
	   if (erro.ne.0 ) goto 900				!error, carry
	   myused=used
	endif
c
	if (nblank.le.0) then			!not appending BLANKs
c
	   lx=1					!here we go vedit if not blank
	   cx=1
	   mode=2				!<ret> enough to EXIT
	   start=1
	   size=start+myused-1
	   sizmax=size
	   topscr=-1
	   margin=-1
	   edtlin=24
	   db$rec=0				!no duplicate record# allowed
	   dokill=.false.			!no ^Z KILL
	   doinsert=.false.			!no ^Z INSERT
	   call vedits_(spfchl_,mode,start,size,topscr,margin,lx,cx,vmssg,msiz,
     1   	       lcpage,psiz,myused,mini,maxi,pics,kind,term,xpos,
     1   	       ypos,blink,edtlin,dohlp,hlpmsg,sizmax,status,
     1                 vftype,dokill,doinsert,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
	   if (.not.s$set(s$talk)) then	!sorry, no talk as before
	      call tty_echo_(.false.)
	   endif
	else
	   myused=used				!blanks, fake exit from editor
	   status=-1
	   do 1012 k = 1, myused
	      lcpage(vfield(k))(1:)=' '		!append BLANK...
1012	   continue
	endif
c
c	and now do append to the file if that is the case
c
	if (status.gt.0.or.		!user EXITed with ^Z EX
     1      status.eq.-1  ) then	!user <ret>'urned at the bottom
c
	   if (nblank.le.0) then
	      blnk=.true.			!assume all fields have spaces
	      do 1022 k = 1, myused
	         if (istrip_(lcpage(k)).gt.0) blnk=.false.
1022	      continue
	   else
	      blnk=.false.			!make it work...
	   endif
c
	   if (.not.blnk) then
c
	      myused=used
	      recnum=recnum+1			!record...
	      if (nodbf.gt.0) then
	         call f$odbf_(ochan,ibase,recnum,myused,vfield,vmssg,
	1                     lcpage,erro)
	      else
	         call flat_(ibase,lcpage,xbuf1,erro)
	         if (erro.ne.0) goto 95000	!go display error
	         call i$usz_(ibase,usrsiz)	!record size
	         owname(1:)=' '			!no owner base
	         totelem=0			!no elem.
	         linelem=0			!...
	         call f$osdf_(ochan,recnum,xbuf1,usrsiz,
	1                     irace,owname,aliename,totelem,linelem,
	1                     erro)
	      endif
	      if (erro.ne.0) goto 95000		!go display error
	      reccount=reccount+1		!account appended record
	      lstrec=recnum			!save last appended record
	      goto 653				!EXIT from editor
c
	   else
	      myused=used
	      goto 652				!QUIT from editor
	   endif
c
	   if (status.gt.0) then		!user EXITed with ^Z EX
	      goto 658				!all done
	   endif
c
	else					!user QUITed
	   myused=used
	   goto 652				!QUIT from editor
	endif
c
c	QUIT, restore screen
652	continue
c
	goto 658				!proceed
c
c	EXIT, restore screen
653	continue
c
	goto 654				!proceed
c
654	continue
c
	if (nblank.gt.0) goto 658		!appending blanks, all done
c
655	continue
c
	goto 651					!no more questions
c
c	All done
c
658	continue
c
c	Inform user
c
	if (d$itrv.eq.1) then			!interactive
	   if (reccount.le.0) then
	      write (mssg,10022)		!be nice
	   elseif (reccount.gt.1) then
	      write (mssg,10003) reccount
	   else
	      write (mssg,10002)
	   endif
c
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, return
	endif
c
	goto 900				!return anyway...
c
c
c	>>>>>> APPEND FROM <file.ext> TO <database> command
c	===================================================
c
710	continue
c
	call zrace_(obase,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (irace.ne.r$b) goto 90043		!not a regular base
c
	if (d$prt(obase).ne.0) then		!protection ON
	   do k = 1, d$nfld(obase)		!see if protected fields
	      if (d$prfl(k,obase).ne.prtrw) then
	         goto 90039			!sorry, can't append
	      endif
	   enddo
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   mssg(1:)=' '
	   write (mssg(2:),'(a)') bywhat	!inform field transfer
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, return
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call i$wlin_(24,erro)		!wait at line 24
	   if (erro.lt.0) then			!command aborted
	      erro=0				!clear error
	      goto 900				!return properly
	   endif
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
	call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)!lower/upper record#
	if (erro.ne.0) goto 900				!error, carry
c
c	complete FIELDS
c
	fmsz=all					!field map size
	call get_vm_(4*fmsz,fm,erro)			!ask for room
	if (erro.ne.0) goto 90031			!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90031
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90031
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90031
c
	fmdtsz=fmsz					!dest. field map size
	call get_vm_(4*fmdtsz,fmdt,erro)		!ask for room
	if (erro.ne.0) goto 90031			!no memory!
c
	fwrite=.true.				!fields are to be updated
	call fldsem_(obase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90030		!no # in append command
c
c	Open input <file.ext>
c
	call newc_(ichan)
	if (ichan.le.0) goto 90029			!no more i/o channels
c
	if (nidbf.gt.0) then
	   www(1:)=' '
	   www='DBAG'
	   call f$ihdr_(ichan,ifname,www,cmmd,basenm,when,usrnam,where,
	1               erro)
	   if (erro.ne.0) goto 95000			!go display error
	   if (www(1:4).ne.'DBAG'.and.			!bad format
	1      www(1:9).ne.'DELIMITED') goto 90021	!make it COMPATIBLE!!!
	else
	   www(1:)=' '
	   www='SDF'
	   call f$ihdr_(ichan,ifname,www,cmmd,basenm,when,usrnam,where,
	1               erro)
	   if (erro.ne.0) goto 95000			!go display error
	   if (www(1:3).ne.'   ') goto 90021		!bad format
	endif
c
	eof=.false.
	reccount=0				!total # of records appended
	ntrunc=0				!# of records appended, trunc.
	nbad=0					!# of records rejected
c
45699	continue
c
	trunc=.false.
	if (nidbf.gt.0) then
	   call f$idbf_(ichan,ftrans,obase,recnum,myused,vfield,lcvmsg,
     1                  lcpage,eof,trunc,erro)
	else
	   call i$usz_(obase,usrsiz)			!record size
	   call f$isdf_(ichan,recnum,xbuf1,usrsiz,killed,garbage,eof,
	1               hisrace,owname,aliename,totelem,linelem,erro)
	   if (erro.ne.0) goto 95000			!display error
	   if     (killed) then
	      nkill=nkill+1
	      goto 45699				!killed, ignore
	   elseif (garbage) then
	      ngarb=ngarb+1
	      goto 45699				!unrecoverable, ignore
	   endif
c
	endif
c
	filrec=recnum
c
	if (erro.ne.0) goto 599				!f$idbf error
c
	if (nidbf.gt.0) then
c
c	    Set field tranfer as user requested (if field transfer not by NAME)
c
	   if (ftrans.ne.2) then
	      ibase=0					!no input base
	      ifsiz=c$fn
	      call i$sftr_(ibase,obase,%val(fm),ifsiz,%val(fmdt),ftrans,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      c$fn=ifsiz
	   endif
c
	endif
c
cwhile	do while (.not.eof)
1098	continue
	   if (eof) goto 1099
c
	   if (nidbf.gt.0) then
c
c	      ****** DBAG format ******
c
c	      Set PAGE correctly before calling APPEND procedure (FIELDS...)
c
	      do 1014 k = 1, d$nfld(obase)
	         page(k)(1:)=' '			!clear them all
	         fledt(k)=.false.			!no field in file
1014	      continue
c
	      nmatch=0				!# of matched field#'s/names
c
	      if (ftrans.ne.2) then		!*** field tr. not by NAME
c
	         do 1015 k = 1, myused
	            fff=vfield(k)			!field#
c
c	            see if wanted by user
c
	            do 1016 kkk = 1, c$fn
	               call outk_(%val(fm),kkk,kval)	!read the field map...
	               if (kval.gt.0) then		!ignore 0 (record#)
	                  if (kval.eq.fff) then
	                     nmatch=nmatch+1		!count match
	                     call outk_(%val(fmdt),kkk,kval)!read dest.field map
	                     page(kval)(1:)=lcpage(k)(1:)!copy used/wanted field
	                     fledt(kval)=.true.		!remember in file
	                     goto 720
	                  endif
	               endif
1016	            continue
720	            continue
c
1015	         continue
c
	      else				!*** field transfer by NAME
c
	         do 1017 k = 1, myused
	            if (vfield(k).gt.0) then		!if a good one
	               mymnem(1:)=' '
	               mymnem(1:)=lcvmsg(vfield(k))
	               call uc8to7_(mymnem)		!upper case mnemonic
	               eow=.false.
	               found=.false.
	               fff=1
cwhile	               do while (.not.eow.and..not.found)
1096	               continue
	                  if (eow.or.found) goto 1097
c
	                  if (fff.gt.d$nfld(obase)) then
	                     eow=.true.
	                  else
	                     call zmne_(obase,fff,lcmnem,erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                     call uc8to7_(lcmnem)	!upper case it too
	                     if (lcmnem.eq.mymnem) then
	                        found=.true.
	                     else
	                        fff=fff+1
	                     endif
	                  endif
c
	                  goto 1096

1097	                continue
cwhile	                enddo
c
	               if (found) then
	                  page(fff)(1:)=lcpage(k)(1:)	!copy used/matched names
	                  fledt(fff)=.true.		!remember in file
	                  nmatch=nmatch+1		!count match
	               endif
c
	            endif
c
1017	         continue
c
	      endif
c
c	      Append to data base if any match
c
	      if (nmatch.le.0) then
c
	         nbad=nbad+1				!account
	         call tty_putc_(bell)			!ring
	         write (mssg,10030) filrec		!tell append not done
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, return
c
	      else
c
c	         Load default values for non-specified fields and for
c	         specified but empty fields (e.g., blanks read from file)
c
	         do 1018 k = 1, d$nfld(obase)
	            if (.not.fledt(k).or.
	1               istrip_(page(k)).le.0) then
	               b2=d$dbio(k,obase)
	               mast=d$mast(k,obase)
	               if (b2.gt.0.and.mast.gt.0) then
	                  if (d$type(k,obase).ne.r8$) then!no def.for double pr.
	                     call cunflt_(b2,page(k),tmp,mast,d$dflt(b2),
	1                                 erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                  else
	                     page(k)(1:)=' '
	                  endif
	               else
	                  if (d$type(k,obase).ne.r8$) then!no def.for double pr.
	                     call cunflt_(obase,page(k),tmp,k,d$dflt(obase),
	1                                 erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                  else
	                     page(k)(1:)=' '
	                  endif
	               endif
	            endif
1018	         continue
c
	         if (nnochk.gt.0) then
	            erro=-16381744			!don't validate
	         else
	            erro=0				!VALIDATE input
	         endif
	         call append_(obase,recnum,page,erro)	!append record
	         if (erro.ne.0) then
                    if     (d$rsub.eq.'MORE'.or.	!KEY fields errors
     1                      d$rsub.eq.'CHKLIN'.or.	!CHKLIN errors
     1                      d$rsub.eq.'CFLT'.or.	!flat/unflat/flat/...
     1                      d$rsub.eq.'CF'.or.
     1                      d$rsub.eq.'CUNFLT'.or.
     1                      d$rsub.eq.'CUNF'      ) then
	               nbad=nbad+1			!account
	               call errmsg_(d$rsub,erro,mssg,'%')!get error message
	               call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	               if (erro.ne.0) goto 900		!error, return
	               call tty_putc_(bell)		!ring
	               write (mssg,10024) filrec	!tell append not done
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	               if (erro.ne.0) goto 900		!error, return
c
	               if (errstp.and.askerr) then
	                  askerr=.false.		!confirm only once
	                  call i$ster_(errstp,erro)	!really ?
	               endif
	               if (errstp) goto 900		!stop on errors
	               if (erro.ne.0) goto 900		!error, carry
c
	            elseif (d$rsub.eq.'OPX'.and.
	1                erro.eq.5         ) then
	               goto 95000			!can't open index file
	            else
	               goto 900				!error, carry
	            endif
	         else
	            reccount=reccount+1			!account appended record
	            lstrec=recnum			!save last record
	            if (trunc) then
	               ntrunc=ntrunc+1			!account
	               call tty_putc_(bell)		!ring
	               write (mssg,10025) filrec,lstrec	!tell user ok but trunc
	            else
	               write (mssg,10023) filrec,lstrec	!tell user ok
	            endif
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900		!error, return
	         endif
c
	         if (bitcan(obase).ne.1) then
	            call bitclr_(%val(bitpnt(obase)),erro)!clear search bitmap
	            if (erro.ne.0) goto 900		!error, carry
	            bitcan(obase)=1			!current search = 'none'
	         endif
c
	         if (recnum.gt.bitsup) then		!doesn't fit in bitmap
	            call i$bclr_(obase,erro)		!get rid of it
c	            if (erro.ne.0) noerror
	            bmsize=0				!default size
	            call i$bini_(obase,bmsize,erro)  	!get a new & fresh bmap
	            if (erro.ne.0) goto 900		!error, carry
	            call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)
	            if (erro.ne.0) goto 900		!error, carry
	         endif
c
	      endif
c
	   else
c
c	      *************** SDF file format ****************
c
c	      Load default values for non-specified fields and for
c	      specified but empty fields (e.g., blanks read from file)
c
c	      see fields wanted by user
c
	      do 1026 k = 1, d$nfld(obase)
	         fledt(k)=.false.
1026	      continue
c
	      do 1024 k = 1, d$nfld(obase)
	         fff=k					!field#
	         do 1025 kkk = 1, c$fn
	            call outk_(%val(fm),kkk,kval)	!read the field map...
	            if (kval.eq.fff) then
	               fledt(fff)=.true.		!remember in file
	               goto 725
	            endif
1025	         continue
725	         continue
1024	      continue
c
	      do 1023 k = 1, d$nfld(obase)
	         pos1=d$pos(k,obase)
	         pos2=pos1+d$siz(k,obase)-1
	         if (.not.fledt(k).or.
	1            istrip_(xbuf1(pos1:pos2)).le.0) then
	            xbuf1(pos1:pos2)=d$dflt(obase)(pos1:pos2)
	         endif
1023	      continue
c
	      if (nnochk.gt.0) then
	         erro=-16381744				!don't validate
	      else
	         erro=0					!VALIDATE input
	      endif
	      call more_ (obase,recnum,xbuf1,erro)
	      if (erro.ne.0) goto 599			!analyse error
c
	      reccount=reccount+1			!account appended record
	      lstrec=recnum				!save last record
	      write (mssg,10023) filrec,lstrec	!tell user ok
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, return
c
	      if (bitcan(obase).ne.1) then
	         call bitclr_(%val(bitpnt(obase)),erro)!clear search bitmap
	         if (erro.ne.0) goto 900		!error, carry
	         bitcan(obase)=1			!current search = 'none'
	      endif
c
	      if (recnum.gt.bitsup) then		!doesn't fit in bitmap
	         call i$bclr_(obase,erro)		!get rid of it
c	            if (erro.ne.0) noerror
	         bmsize=0				!default size
	         call i$bini_(obase,bmsize,erro)  	!get a new & fresh bmap
	         if (erro.ne.0) goto 900		!error, carry
	         call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
c
	   endif
c
669	   continue
c
	   trunc=.false.
	   if (nidbf.gt.0) then
	      call f$idbf_(ichan,ftrans,obase,recnum,myused,vfield,lcvmsg,
     1                     lcpage,eof,trunc,erro)
	   else
	      call i$usz_(obase,usrsiz)			!record size
	      call f$isdf_(ichan,recnum,xbuf1,usrsiz,killed,garbage,eof,
	1                  hisrace,owname,aliename,totelem,linelem,erro)
	      if (erro.ne.0) goto 95000			!display error
	      if     (killed) then
	         nkill=nkill+1
	         goto 669				!killed, ignore
	      elseif (garbage) then
	         ngarb=ngarb+1
	         goto 669				!garbage, ignore
	      endif
c
	      myused=d$nfld(obase)
	      do k = 1, myused
	         vfield(k)=k
	      enddo
c
	   endif
c
	   filrec=recnum
c
	   if (erro.ne.0) then
c
c	      Here if error
c
599	      continue
c
	      if (d$rsub.eq.'F$IDBF'.and.		!f$idbf terminal errors
	1         (erro.eq.1.or.
	1          erro.eq.2    )        ) then
	         goto 95000				!show error
	      endif
c
              if     (d$rsub.eq.'CHKLIN'.or.		!CHKLIN errors
	1             d$rsub.eq.'VALIDA'.or.
	1             d$rsub.eq.'CUNFLT'.or.
	1             d$rsub.eq.'CUNF'.or.
	1             d$rsub.eq.'F$IDBF'   ) then
	         nbad=nbad+1				!account
	         call errmsg_(d$rsub,erro,mssg,'%')!get error message
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, return
	         call tty_putc_(bell)		!ring
	         write (mssg,10024) filrec		!tell append not done
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, return
c
	         if (errstp.and.askerr) then
	            askerr=.false.			!confirm only once
	            call i$ster_(errstp,erro)		!really ?
	         endif
	         if (errstp) goto 900			!stop on errors
	         if (erro.ne.0) goto 900		!error, carry
c
	         goto 669				!read next record
c
	      elseif (d$rsub.eq.'OPX'.and.
	1             erro.eq.5         ) then
	         goto 95000				!can't open index file
	      else
	         goto 900				!error, carry
	      endif
c
	   endif
c
	   goto 1098
1099	continue
cwhile	enddo
c
c	Inform user and set new currents ...
c
	if (reccount.gt.0) then			!avoid calling i$scur twice
	   call i$scur_(obase,lstrec,0)		!set new current
	endif
c
	if (d$itrv.eq.1) then		!interactive
c
	   write (mssg,10026) reccount			!total appended
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900				!error, return
c
	   write (mssg,10027) ntrunc			!truncated
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900				!error, return
c
	   write (mssg,10028) nbad				!rejected
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900				!error, return
c
	endif
c
	goto 900					!return
c
c	>>>>>> APPEND FROM <database> TO <database>
c	===========================================
c
750	continue
c
	goto 90034					!not yet
c
c	>>>>>> APPEND FROM <database> TO SDF/DBAG file
c	==============================================
c
810	continue
c
	call zrace_(ibase,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (irace.ne.r$b) goto 90043			!not a regular base
c
	if (nosdf.gt.0) then			!SDF format
	   if (d$prt(ibase).ne.0) then		!protection ON
	      do k = 1, d$nfld(ibase)		!see if protected fields
	         if (d$prfl(k,ibase).ne.prtrw) then
	            goto 90040			!sorry, can't use SDF
	         endif
	      enddo
	   endif
	endif
c
c	Open output <file.ext> and inform user
c
c	record size
c
	recsiz=x$rec+10				!max. buffers size
c
	call newc_(ochan)
	if (ochan.le.0) goto 90029			!no more i/o channels
c
	if (new) then
	   newold='NEW'
	else
	   newold='OLD'
	endif
c
	if (nosdf.gt.0) then
	   call f$ohdr_(ochan,ibase,ofname,newold,recsiz,'SDF',buf,
     1                 erro)				!SDF file
	else
	   call f$ohdr_(ochan,ibase,ofname,newold,recsiz,'DBAG',buf,
     1                 erro)				!DBAG file
	endif
	if (erro.ne.0) goto 95000			!display error
c
	if (d$itrv.eq.1) then				!interactive
	   if (nosdf.gt.0) then
	      write (mssg,10007) ofname(1:istrip_(ofname)),newold!be nice...
	   else
	      write (mssg,10013) ofname(1:istrip_(ofname)),newold!be nice...
	   endif
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
c	Inform user
c
	if (irace.ne.r$b) then			!not a regular base, just wait
	   call i$wlin_(24,erro)		!wait at line 24
	else
	   always=.true.			!always...
	   answer=.true.				!wait for answer
	   call i$rsel_(%val(bm),always,answer,cnt,erro)
	endif
c
	if (erro.lt.0) then				!command aborted
	   erro=0					!clear error
	   goto 900					!return properly
	endif
	if (erro.ne.0) goto 900				!error, carry
c
c	complete FIELDS
c
	fmsz=all					!field map size
	call get_vm_(4*fmsz,fm,erro)			!ask for room
	if (erro.ne.0) goto 90031			!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90031
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90031
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90031
c
	fmdtsz=fmsz					!dest. field map
	call get_vm_(4*fmdtsz,fmdt,erro)		!ask for room
	if (erro.ne.0) goto 90031			!no memory!
c
	fwrite=.false.				!fields are not to be updated
	call fldsem_(ibase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90030		!no # in append command
c
c	Load limits (mnemonics) just once
c
	used=-1						!all fields, please...
	call vlimit_(ibase,used,vfield,lcvmsg,msiz,psiz,
     1               kind,mini,maxi,pics,erro)
	if (erro.eq.3.and.d$rsub.eq.'VLIMIT') then		!protected field
c	   ignore it, field isn't in field map!!
	else
	   if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	   if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	   if (erro.ne.0 ) goto 900				!error, carry
	endif
	myused=used
c
	reccount=0			!appended records
	kcount=0			!ignored (killed) records
	nbad=0				!# of records with problems
c
c	Loop on bit map
c	---------------
c
	recnum=0					!reset bitnxt
	irec=0
	eobm=.false.					!...
c
10941	continue
c
	badrec=.false.					!record is ok
c
	call bitnxt_(%val(bm),irec,eobm,erro)		!first selected rec.
	if (erro.ne.0) goto 900				!error, carry
	call in3ex_(ibase,irec,recnum,erro)
	if (erro.ne.0) goto 900				!error, carry
c
	if (.not.eobm) then
	   if (nodbf.gt.0) then
	      call lookup_(ibase,recnum,alive,lcpage,erro)
	   else
	      call find_(ibase,recnum,alive,xbuf1,erro)
	   endif
	   if (erro.ne.0) then
	      if (d$rsub.eq.'FIND'.and.
	1         erro.eq.5            ) then
	         kcount=kcount+1
	         goto 10941				!killed record, ignore
	      else
	         badrec=.true.
	      endif
	   endif
	endif
c
cwhile	do while (.not.eobm)
1094	continue
	   if (eobm) goto 1095
c
c	   only fields wanted by user
c
	   used=0					!index/counter
	   if (nodbf.gt.0) then
	      do 1019 kkk = 1, c$fn
	         call outk_(%val(fm),kkk,kval)		!hard to read, field map
	         if (kval.gt.0) then			!ignore 0 (record#)
	            used=used+1
	            page(used)(1:)=lcpage(kval)(1:)	!copy used/wanted fields
	            vmssg(used)(1:)=lcvmsg(kval)(1:)
	            vfield(used)=kval
	         endif
1019	      continue
c
	   else
c
	      do k = 1, d$nfld(ibase)
	         do kkk = 1, c$fn
	            call outk_(%val(fm),kkk,kval)	!hard to read, field map
	            if (kval.eq.k) then			!ok, wanted field
	               used=used+1
	               goto 222				!next field
	            endif
	         enddo
	         xbuf1(d$pos(k,ibase):			!clean field
	1              d$pos(k,ibase)+d$siz(k,ibase)-1)=' '
222	         continue
	      enddo
	   endif
c
	   myused=used
	   if (nodbf.gt.0) then
	      call f$odbf_(ochan,ibase,recnum,myused,vfield,
	1                  vmssg,page,erro)
	   else
	      call i$usz_(ibase,usrsiz)	!record size
	      owname(1:)=' '		!no owner base
	      totelem=0			!no elem.
	      linelem=0			!...
	      call f$osdf_(ochan,recnum,xbuf1,usrsiz,
	1                  irace,owname,aliename,totelem,linelem,
	1                  erro)
	   endif
	   if (erro.ne.0) goto 95000			!go display error
	   reccount=reccount+1				!account appended record
c
	   if (badrec) then
	      write (mssg,10034) recnum			!tell user problems ...
	   else
	      write (mssg,10029) recnum			!tell user ok
	   endif
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, return
c
	   if (badrec) then
	      nbad=nbad+1
	   endif
c
c	   next record
c
840	   continue
c
	   badrec=.false.				!record is ok
c
	   call bitnxt_(%val(bm),irec,eobm,erro)	!next sel. rec.
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(ibase,irec,recnum,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   if (.not.eobm) then
	      if (nodbf.gt.0) then
	         call lookup_(ibase,recnum,alive,lcpage,erro)
	      else
	         call find_(ibase,recnum,alive,xbuf1,erro)
	      endif
	      if (erro.ne.0) then
	         if (d$rsub.eq.'FIND'.and.
	1            erro.eq.5) then
	            kcount=kcount+1
	            goto 840				!killed record, ignore
	         else
	            badrec=.true.
	         endif
	      endif
	   endif
c
	   goto 1094				!*** loop back
1095	continue
cwhile	enddo
c
c	Inform user
c
	if (d$itrv.eq.1) then		!interactive
c
	   if (reccount.le.0) then
	      write (mssg,10022)				!be nice
	   elseif (reccount.gt.1) then
	      write (mssg,10003) reccount
	   else
	      write (mssg,10002)
	   endif
c
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900				!error, return
c
	   if (kcount.gt.0) then				!killed records
	      write (mssg,10032) kcount
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, return
	   endif
c
	   if (nbad.gt.0) then				!BAD RECORDS
	      write (mssg,10033) nbad
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, return
	   endif
c
	endif
c
	goto 900					!return
c
c
c
c	           R   E   T   U   R   N
c	=======================================================
c	Deallocate any memory space, free any allocated channel
c	and return to main loop
c	=======================================================
c
900	continue
c
c	Free temporary memory space
c
	call free_vm_(4*bmsz,bm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*fmdtsz,fmdt,noerr)
c
	if (ochan.gt.0) then
	   close (ochan)
	   call freec_(ochan)				!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier,integer, or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword, integer or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword or SCOPE called twice
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	FOR seen and no FROM phrase
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	SCOPE, FOR, or FIELDS and BLANK
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	Database or file.ext expected after FROM/TO
90011	continue
	mark=p1
	erro=11
	goto 99000			!display error and return properly
c	BLANK and FROM seen
90012	continue
	mark=0
	erro=12
	goto 99000			!display error and return properly
c	Duplicate requests on command
90013	continue
	mark=0
	erro=13
	goto 99000			!display error and return properly
c	Append FROM file.ext TO file.ext
90014	continue
	mark=0
	erro=14
	goto 99000			!display error and return properly
c	Input spec = output spec
90015	continue
	mark=0
	erro=15
	goto 99000			!display error and return properly
c	Output database doesn't exist
90016	continue
	mark=0
	erro=16
	goto 99000			!display error and return properly
c	Output database locked by another user
90017	continue
	mark=0
	erro=17
	goto 99000			!display error and return properly
c	Input database doesn't exist
90018	continue
	mark=0
	erro=18
	goto 99000			!display error and return properly
c	Input database locked by another user
90019	continue
	mark=0
	erro=19
	goto 99000			!display error and return properly
c	Found repeated reference to same field in FIELDS <list>
90020	continue
	mark=0
	erro=20
	goto 99000			!display error and return properly
c	Input file format isn't the standard (DBAG or SDF)
90021	continue
	mark=0
	erro=21
	goto 99000			!display error and return properly
c	NEW or OLD seen without TO <file.ext> option
90022	continue
	erro=22
	goto 99000			!display error and return properly
c	Should never happen!!!
90023	continue
	erro=23
	goto 99000			!display error and return properly
c	BYFIELDNUMBER, NAME or LIST seen without input base/file or output base
90024	continue
	erro=24
	goto 99000			!display error and return properly
c	BYFIELDNUMBER, NAME or LIST seen with output to file
90025	continue
	erro=25
	goto 99000			!display error and return properly
c	Field tranfer may be by number OR name OR list!!!!
90026	continue
	erro=26
	goto 99000			!display error and return properly
c	SCOPE or FOR found without FROM <database>
90027	continue
	erro=27
	goto 99000			!display error and return properly
c	FIELDS and BYNAME or BYLIST specified
90028	continue
	erro=28
	goto 99000			!display error and return properly
c	no more i/o channels
90029	continue
	erro=29
	goto 99000			!display error and return properly
c	# found in <field list>
90030	continue
	erro=30
	goto 99000			!display error and return properly
c	memory (get_vm_) failure
90031	continue
	erro=31
	goto 99000			!display error and return properly
c	Empty current search
90032	continue
	erro=32
	goto 99000			!display error and return properly
c	*** obsolete *** SDF file format not yet supported
90033	continue
	erro=33
	goto 99000			!display error and return properly
c	append from base to base not yet supported
90034	continue
	erro=34
	goto 99000			!display error and return properly
c	field transfer BYLIST not yet supported
90035	continue
	erro=35
	goto 99000			!display error and return properly
c	SDF file, only byfieldnumber
90036	continue
	erro=36
	goto 99000			!display error and return properly
c	NOCHECK only if appending from file
90037	continue
	erro=37
	goto 99000			!display error and return properly
c	Batch user, can't use editor
90038	continue
	erro=38
	goto 99000			!display error and return properly
c	Protected fields, can't append
90039	continue
	erro=39
	goto 99000			!display error and return properly
c	Protected fields, can't use SDF format
90040	continue
	erro=40
	goto 99000			!display error and return properly
c	TOP/BOTTOM adjustment
90041	continue
	erro=41
	goto 99000			!display error and return properly
c	NORECORDS, specify PROPERTY keyword
90042	continue
	erro=42
	goto 99000			!display error and return properly
c	Not a regular base, can't append
90043	continue
	erro=43
	goto 99000			!display error and return properly
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
	if (d$itrv.eq.1) then				!interactive
	   call errmsg_('A$PPEN',erro,mssg,'?')		!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1					!set edit mode
	else
	   call errset_('A$PPEN',erro)			!set global error
	endif
c
	call free_vm_(4*bmsz,bm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*fmdtsz,fmdt,noerr)
c
	if (ochan.gt.0) then
	   close (ochan)
	   call freec_(ochan)				!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
95000	continue
c
	call vset2_(1)				!clean screen from line 1
	call vset3_(2,24)			!normal scrolling
	call i$scur_(c$base,c$rec,c$fld)	!set curr.
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	call free_vm_(4*bmsz,bm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*fmdtsz,fmdt,noerr)
c
	if (ochan.gt.0) then
	   close (ochan)
	   call freec_(ochan)				!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:appen.fmt'
c
	end
c
c
c
c
	subroutine B$ROWS_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine C$HANG_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine C$ONTI_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine C$OPY_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements COPY command:
c
c	****** COPY STRUCTURE FROM <database> TO <database>
c
c	Creates a new, empty database with the same structure of the first one.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer update,mode,type,val,dec,lim,p1,p2,erro
	integer size,ibase,ichan,obase,ochan,long,bmsize
	real rval
	integer nstruc,nto,nfrom
	character*15 ibname,obname
	character*60 ifspec,ofspec
	integer f,k,me,zero/0/
	logical outopn
c
c	begin
c	=====
c
	call errclr_('C$OPY')		!error init
c
	nstruc=0			!#STRUCTURE
	nfrom=0				!#[FROM]
	nto=0				!#[TO]
c
	ibname(1:)=' '			!input database name
	ibase=0				!input database channel
	ichan=0				!input file.ext i/o channel
	obname(1:)=' '			!output databse name
	obase=0				!output database channel
	ochan=0				!output file.ext i/o channel
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error: neither identifier or eol
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute COPY com.
	endif
c
c	Check keyword
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!unknown keyword
	elseif (keypos.eq.-1) then
	   goto 90004			!ambiguous keyword
	elseif (keypos.eq.-2) then
	   goto 90005			!too few characters
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 100			!"eat" [TO] phrase
	elseif (keypos.eq.struky) then
	   nstruc=nstruc+1		!count it
	   goto 1			!loop for more
	elseif (keypos.eq.fromky) then
	   nfrom=nfrom+1		!count it
	   goto 200			!"eat" [FROM] phrase
	else
	   goto 90008			!unexpected keyword
	endif
c
c	Here to "eat" TO <database>
c	---------------------------
c
100	continue
c
c	get <database>
c	--------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90009			!database name expected
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10003) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
	obname(1:)=' '
	obname(1:)=buf(p1:p1+size-1)
c
	goto 1					!loop for more
c
c	Here to "eat" FROM <database>
c	-----------------------------
c
200	continue
c
c	get <database>
c	--------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24     ) then
	   goto 90009			!database name expected
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10002) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
	ibname(1:)=' '
	ibname(1:)=buf(p1:p1+size-1)
c
	goto 1					!loop for more
c
c	>>>>>> Here to check/complete/execute COPY command
c	==================================================
c
500	continue
c
c	Check COPY command
c	------------------
c
	call uc_(ibname)			!upper case all names
	call uc_(obname)			!...
c
c	Do checking now
c	---------------
c
	if (nfrom .gt.1.or.
     1      nto   .gt.1.or.
     1      nstruc.gt.1   ) then
	   goto 90010				!duplicate requests on command
	endif
c
	if (nfrom.le.0.or.
     1      nto  .le.0.or.
     1      nstruc.le.0   ) then
	   goto 90011				!command is incomplete
	endif
c
	if (ibname.eq.obname) goto 90014		!input=output
c
c	Check input database
c
	update=0
	mode=0
	call open_(ibase,ibname,update,mode,outopn,erro)!open database
	if (erro.ne.0) then
	   if (d$rsub.eq.'OPNBAS'.and.
     1             erro.eq.3             ) then		!no such base
	      goto 90012
	   else
	      goto 95000				!show error
	   endif
	endif
c
c	Check output database (opnbas should fail)
c
	update=0
	mode=0
	call open_(obase,obname,update,mode,outopn,erro)!open database
	if (erro.eq.0) then
	   goto 90013					!database already exists
	else
	   if (d$rsub.eq.'OPNBAS'.and.
     1             erro.eq.3              ) then	!no such base
	      call errclr_('C$OPY')			!ok, clear error
	   else
	      goto 95000				!show error
	   endif
	endif
c
	if (d$prt(ibase).ne.0) then			!protection ON
	   do k = 1, d$nfld(ibase)			!see if protected fields
	      if (d$prfl(k,ibase).ne.prtrw) then
	         goto 90017				!sorry, can't copy
	      endif
	   enddo
	endif
c
c	>>>>>> Execute COPY command
c	===========================
c
	today(1:)=' '
	hour(1:)=' '
	call date(today)			!today's date
	call time(hour)				!and time
	call pid_(me)				!signature for root & base files
c
c	Open root files
c
	ifspec(1:)=' '
	ifspec=d$bfil(ibase)			!input: full file spec
	call givext_(ifspec,'.ROO')		!add extension
	ofspec(1:)=obname
	call givext_(ofspec,'.ROO')		!output: just add extension
	call newc_(ichan)			!ask for i/o channel
	if (ichan.le.0) goto 90015		!no more i/o channels
	call newc_(ochan)			!ask for i/o channel
	if (ochan.le.0) goto 90015		!no more i/o channels
	inquire(file=ifspec,recl=long)		!ask len.
	open(unit=ichan, file=ifspec, status='old', access='direct',
     1       form='formatted',organization='relative', recl=long,
     1       err=90016)
c
	open(unit=ochan, file=ofspec, status='new', access='direct',
     1       form='formatted', organization='relative', recl=long,
     1       err=90016)
c
c	Copy root files
c
	read(ichan, rec=1, fmt='(a)', err=90016)d$xbuf(1:long)
	call uncript_(d$xbuf,long)
	call rdivar_(d$xbuf(ro$s1:ro$s1+ro$l1-1),f,ro$l1,erro)	!read # fields
	if (erro.ne.0) goto 90016				!read error
	call wrivar_(d$xbuf(ro$s2:ro$s2+ro$l2-1),me,ro$l2,erro) !write signatur
	if (erro.ne.0) goto 90016				!write error
	d$xbuf(ro$s4:ro$s4+8)=today(1:)				!creation date
	d$xbuf(ro$s4+9:ro$s4+9)=':'
	d$xbuf(ro$s4+10:ro$s4+19)=hour(1:)
	call cript_(d$xbuf,long)
	write(ochan, rec=1, fmt='(a)', err=90016)d$xbuf(1:long)
c
	do 1001 k = 2, f+1
	   read(ichan, rec=k, fmt='(a)', err=90016)d$xbuf(1:long)
	   write(ochan, rec=k, fmt='(a)', err=90016)d$xbuf(1:long)
1001	continue
c
c	Close root files and release channels
c
	if (ichan.gt.0) then
	   close (unit=ichan)
	   call freec_(ichan)
	   ichan=0
	endif
	if (ochan.gt.0) then
	   close (unit=ochan)
	   call freec_(ochan)
	   ochan=0
	endif
c
c	Open base files
c
	ifspec(1:)=' '
	ifspec=d$bfil(ibase)			!input: full file spec
	call givext_(ifspec,'.DBF')		!add extension
	ofspec(1:)=obname
	call givext_(ofspec,'.DBF')		!output: just add extension
	ichan=d$bio(ibase)			!use input base i/o channel
	call newc_(ochan)			!ask for output i/o channel
	if (ochan.le.0) goto 90015		!no more i/o channels
	inquire(file=ifspec,recl=long)		!ask len.
	open(unit=ichan, file=ifspec, status='old', access='direct',
     1       form='formatted',organization='relative', recl=long,
     1       err=90016)
c
	open(unit=ochan, file=ofspec, status='new', access='direct',
     1       form='formatted', organization='relative', recl=long,
     1       err=90016)
c
c	first of all, see if input base is cripted (rec=33)
c	---------------------------------------------------
c
	read(ichan,rec=33,fmt='(a)',err=90007) d$xbuf(1:long)
	call uncript_(d$xbuf,long)
	read(d$xbuf,fmt='(i10)') d$crpt(ibase)	!cripted ?
c
c	All records are identical, except:
c
c	rec =	 2	signature
c		 3	last "unused" record
c		 4	"tail" of killed list
c		 6	#active records
c		 7	*** unused ***
c		 8	#opens for retrieval
c		 9	#opens for update
c		10	last update date
c		11	and time
c		29	current owner
c		32	creature signature
c		34	"head" of killed list
c
	do 1002 k = 1, d$unus
	   read (ichan,rec=k,fmt='(a)',err=90016) d$xbuf(1:long)
c
	   if     (k.eq.2) then			!signature
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) me
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.3) then			!last record
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) d$unus
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.4) then			!"tail" of killed list
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) zero
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.6) then			!active
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) zero
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.7) then			!**** unused ***
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) zero
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.8) then			!open/read
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) zero
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.9) then			!open/rw
	      d$xbuf(1:)=' '
	      write(d$xbuf(1:),'(i10)',err=90016) zero
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.10) then		!last update date
	      d$xbuf(1:)=' '
	      d$xbuf(1:)=today(1:)
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.11) then		!last update time
	      d$xbuf(1:)=' '
	      d$xbuf(1:)=hour(1:)
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.29) then		!owner
	      d$xbuf(1:)=' '			!(none)
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.32) then		!creatute signature
	      d$xbuf(1:)=' '			!(none)
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   elseif (k.eq.34) then		!"head" of killed list
	      d$xbuf(1:)=' '			!(none)
	      if (d$crpt(ibase).eq.0) call cript_(d$xbuf,long)	!cript record
c
	   else
c	      ok
	   endif
c
	   write (ochan,rec=k,fmt='(a)',err=90016) d$xbuf(1:long)
1002	continue
c
c	Close input base if open and output file
c
	if (ochan.gt.0) then
	   close (unit=ochan)
	   call freec_(ochan)			!release channel
	   ochan=0
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   write (mssg(1:),10001,err=90016)
     1            obname(1:istrip_(obname))	!be nice
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
	goto 900				!return
c
c	Close/release input base and output file if no error
c
900	continue
c
	if (ochan.gt.0) then
	   close (unit=ochan)
	   call freec_(ochan)			!release channel
	   ochan=0
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	Database name expected after FROM/TO
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	Duplicate requests on command
90010	continue
	mark=0
	erro=10
	goto 99000			!display error and return properly
c	STRUCTURE, TO or FROM not specified in COPY command
90011	continue
	mark=0
	erro=11
	goto 99000			!display error and return properly
c	Input database doesn't exist
90012	continue
	mark=0
	erro=12
	goto 99000			!display error and return properly
c	Output database already exists
90013	continue
	mark=0
	erro=13
	goto 99000			!display error and return properly
c	Input database = output database
90014	continue
	mark=0
	erro=14
	goto 99000			!display error and return properly
c	No more i/o channels
90015	continue
	mark=0
	erro=15
	goto 99000			!display error and return properly
c	problems opening/reading/writing root/dbf files
90016	continue
	mark=0
	erro=16
	goto 99000			!display error and return properly
c	protected fields, can't copy structure
90017	continue
	mark=0
	erro=17
	goto 99000			!display error and return properly
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('C$OPY',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('C$OPY',erro)		!set global error
	endif
c
	if (ochan.gt.0) then
	   close (unit=ochan)			!close file
	   call freec_(ochan)			!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (unit=ichan)			!close file
	   call freec_(ichan)			!release channel
	   ichan=0
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
95000	continue
c
	if (d$itrv.eq.1) then				!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	if (ochan.gt.0) then
	   close (unit=ochan)			!close file
	   call freec_(ochan)			!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (unit=ichan)			!close file
	   call freec_(ichan)			!release channel
	   ichan=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:copy.fmt'
c
	end
c
c
c
c
	subroutine C$OUNT_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine C$REAT_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements CREATE command:
c
c	CREATE [<newfile>]			= Implemented =
c	initiates creation of database file.
c
c	CREATE command is implemented in either screen mode (calling procedure
c	STREDT) or line mode (calling procedure I$CREA).
c
c	If special DBAG creatures required (properties, series, ...), its
c	structure will be created calling CREDT/I$CRCR.
c
c	In any case, the data base files are created by a last call to
c	procedure STROUT.
c
c	Two files are created upon completion of CREATE command:
c
c	newfile.ROO	- root file
c	newfile.DBF	- data file
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*120 fspec
	character*20 newfil,propnam,ownam,mybuf,pppnam
	character*40 race
	character*1 space/' '/
	character*10 fmnem,mymnem
	integer base,irace,idim,isize,ideci,b,prop,ppp,bmsize,update,mode
	logical edit,new,full,inuse,edt,lintru,propseen,serseen,memoseen
c
	integer type,p1,p2,val,dec,lim,erro,l,fidx,ppnum,k,f,answr,kkk
	integer pos1
	real rval
	logical fexist,badfield,defprop,defserie,trunc,outopn
c
c	begin
c	=====
c
	call errclr_('C$REAT')			!clear errors
	edt=.false.
	newfil(1:)=' '
	propnam(1:)=' '
	propseen=.false.
	serseen=.false.
	memoseen=.false.
	base=0					!no base channel
	prop=0					!regular base
c
c	get <newfile> or PROPERTY <newfile> from command buffer
c	-------------------------------------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) then
	   goto 90000			!syntax error
	endif
c
	if (type.ne.0.and.
     1      type.ne.1.and.
     1      type.ne.24    ) then
	   goto 90002			!syntax error (neither identifier
					!              nor end-of-line)
	endif
c
	if (type.eq.0) then
	   goto 50			!eol, ask for <newfile>
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.propky.and.
	1       creatures            ) then
	   propseen=.true.
	elseif (keypos.eq.seriky.and.
	1       creatures            ) then
	   serseen=.true.
	elseif (keypos.eq.memoky.and.
	1       creatures            ) then
	   memoseen=.true.
	endif
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) then
c
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	   if (erro.ne.0) then
	      goto 90000			!syntax error
	   endif
c
	   if (type.ne.0.and.
     1         type.ne.1.and.
     1         type.ne.24    ) then
	      goto 90002		!syntax error (neither identifier
					!              nor end-of-line)
	   endif
c
	   if (type.eq.0) then
	      goto 50			!eol, ask for <newfile>
	   endif
c
	endif
c
	l=p2-p1+1			!#characters
	if (l.gt.9) then
	   l=9
	   write (mssg,10003) space,buf(p1:p1+l-1)	!truncation
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	endif
c
	newfil(1:)=' '			!just in case...
	newfil(1:l)=buf(p1:)		!store <newfile>
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90016
c
	goto 50				!go execute command
c
c	CREATE<cr> or CREATE PROPERTY <cr>, ask for <newfile> if line mode
c	------------------------------------------------------------------
c
50	continue
c
	propnam(1:)=' '
	ownam(1:)=' '
c
	if (istrip_(newfil).le.0) then
c
	   if     (propseen) then
	      write (mssg,11001)		!property name
	   elseif (serseen) then
	      write (mssg,12001)		!series name
	   elseif (memoseen) then
	      write (mssg,13001)		!memo name
	   else
	      write (mssg,10001)		!base name
	   endif
	   call i$mess_(0,d$cmdo,1,mssg,0,erro)	!prompt for file name
	   if (erro.ne.0) return		!just return on error
	   erro=0
	   call inline_(d$cmdi,newfil,lim,cmcont,lintru,erro)
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, return
	      call errclr_('C$REAT')		!clear error
	      newfil(1:)=' '
	      goto 50				!loop back
	   endif
	   call i$mess_(0,0,-1,newfil,-1,erro)
	   if (erro.ne.0) return		!error, carry on
c
	   if (lintru) then			!line too long, truncated
	      write (mssg,10005)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
c
	   if     (lim.eq.0) then
	      return				!eol, return
	   elseif (lim.eq.-1) then
	      goto 900				!^Z or end-of-@file
	   elseif (lim.eq.-2) then
	      newfil(1:)=' '
	      goto 50				!comment line, loop back
	  endif
c
	   erro=0
	   call rstok_(newfil,1,erro)
	   call intok_(type,val,dec,rval,newfil,lim,p1,p2,mssg,erro)
c
	   if     (erro.ne.0) then
	      goto 90000				!syntax error
	   elseif (type.ne.1.and.
     1             type.ne.24    ) then
	      erro=2
	      call errmsg_('C$REAT',erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, return
	      call errclr_('C$REAT')		!clear error
	      newfil(1:)=' '
	      goto 50				!loop back
	   endif
c
	   l=p2-p1+1				!#characters
	   if (l.gt.9) then
	      l=9
	      newfil(p1+l:)=' '
	      write (mssg,10003) space,newfil(p1:p1+l-1)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry on
	   endif
	endif
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) then
	   propnam(1:)=' '			!just in case
	   propnam=newfil
c
	   update=-1					!open/read...
	   mode=0					!usual mode
	   call open_(prop,propnam,update,mode,outopn,erro)!open database
	   if (erro.eq.0) then
	      erro=8
	      call errmsg_('C$REAT',erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, return
	      call errclr_('C$REAT')		!clear error
	      newfil(1:)=' '
	      propnam(1:)=' '
	      goto 50				!loop back
	   else
	      if ((d$rsub.eq.'OPNBAS').and.
     1             erro.eq.3              ) then	!no such base
c	         ok
	      else
	         goto 95000				!show error
	      endif
	   endif
c
	else
c
	   update=-1					!open/read...
	   mode=0					!usual mode
	   call open_(base,newfil,update,mode,outopn,erro)!open database
	   if (erro.eq.0) then
	      erro=8
	      call errmsg_('C$REAT',erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, return
	      call errclr_('C$REAT')		!clear error
	      newfil(1:)=' '
	      goto 50				!loop back
	   else
	      if ((d$rsub.eq.'OPNBAS').and.
     1             erro.eq.3              ) then	!no such base
c	         ok
	      else
	         goto 95000				!show error
	      endif
	   endif
c
	endif
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) then
c
51	   continue
c
	   write (mssg,14001)			!owner base
	   call i$mess_(0,d$cmdo,1,mssg,0,erro)	!prompt for file name
	   if (erro.ne.0) return			!just return on error
	   erro=0
	   call inline_(d$cmdi,ownam,lim,cmcont,lintru,erro)
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')	!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, return
	      call errclr_('C$REAT')		!clear error
	      goto 51				!loop back
	   endif
	   call i$mess_(0,0,-1,ownam,-1,erro)
	   if (erro.ne.0) return			!error, carry on
c
	   if (lintru) then			!line too long, truncated
	      write (mssg,10005)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
c
	   if     (lim.eq.0) then
	      return				!eol, return
	   elseif (lim.eq.-1) then
	      goto 900				!^Z or end-of-@file
	   elseif (lim.eq.-2) then
	      goto 51				!comment line, loop back
	   endif
c
	   erro=0
	   call rstok_(ownam,1,erro)
	   call intok_(type,val,dec,rval,ownam,lim,p1,p2,mssg,erro)
c
	   if     (erro.ne.0) then
	      goto 90000				!syntax error
	   elseif (type.ne.1.and.
     1             type.ne.24    ) then
	      erro=2
	      call errmsg_('C$REAT',erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, return
	      call errclr_('C$REAT')		!clear error
	      goto 51				!loop back
	   endif
c
	   l=p2-p1+1				!#characters
	   if (l.gt.9) then
	      l=9
	      ownam(p1+l:)=' '
	      write (mssg,10003) space,ownam(p1:p1+l-1)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry on
	   endif
c
	else
	   newfil(l+1:)=' '			!just in case
	   call uc_(newfil(1:l))		!upper case
	   goto 60				!check/execute command
						!CREATE <newfile>
	endif
c
c	>>>>>>>> check/execute command CREATE <newfile>
c	-----------------------------------------------
c
60	continue
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) then
c
	   update=-1					!open/read...
	   mode=0					!usual mode
	   call open_(base,ownam,update,mode,outopn,erro)!open owner base
	   if (erro.ne.0) then
	      if ((d$rsub.eq.'OPNBAS').and.
     1             erro.eq.3              ) then	!no such base
	         erro=12
	         call errmsg_('C$REAT',erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, return
	         call errclr_('C$REAT')		!clear error
	         goto 51			!loop back
	      else
	         goto 95000				!show error
	      endif
c
c	      See if owner is a regular base
c
	      call zrace_(base,race,irace,idim,isize,ideci,erro)
	      if (erro.ne.0) return		!error, carry
	      if (irace.ne.r$b) then
	         call i$sopn_(base,erro)	!be nice...
	         if (erro.ne.0) return		!error, carry
	         erro=13
	         call errmsg_('C$REAT',erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, return
	         call errclr_('C$REAT')		!clear error
	         goto 51			!loop back
	      endif
c
	   endif
c
c	   See if property exists
c
	   badfield=.false.
	   call chkmne_(propnam,base,-1,fidx,erro)
	   if (erro.ne.0) return		!error, carry
	   if (fidx.le.0) then
	      badfield=.true.
	   else
	      if (d$type(fidx,base).le.ftusr$) badfield=.true.
	   endif
	   if (badfield) goto 90014		!no such property/series/memo
c
	else
	   prop=0
	endif
c
	edit=.true.				!edit structure
	new=.true.				!new data base str.
	full=.true.				!allow full edition
c
c	See if data base already exists if line mode
c	--------------------------------------------
c
	call uc_(newfil)
c
	if (.not.s$set(s$scre)) then		!line mode
	   fspec(1:)=' '
	   fspec(1:)=newfil(1:)			!don't look at .ini yet...
c
	   call newbas_(b,fspec,inuse)		!for context in memory
	   if (inuse) goto 90008		!database already exists
	   if (b.le.0) goto 90011		!no more space
	   call givext_(fspec,'.roo')		!built fspec (root file)
c
	   inquire (file=fspec,exist=fexist)
	   if (fexist) then
	      call frebas_(b)			!clean base context
	      goto 90008			!database already exists
	   endif
c
	   if     (prop.le.0.or.		!regular base or
	1          propseen     ) then		!property, line mode
	      call i$crea_(b,prop,newfil,buf,erro)
	   elseif (serseen) then		!series, line mode
	      call i$crss_(b,prop,newfil,buf,erro)
	   else					!memo, line mode
cx	      call i$crmm_(b,prop,newfil,buf,erro)
	   endif
	   if (erro.ne.0) then
	      call frebas_(b)			!clean base context
	      goto 95000			!show error
	   endif
c
	else					!screen mode
c
	   if (propseen.or.
	1      serseen.or.
	1      memoseen    ) then
	      b=base
	      d$ownb(prop)=ownam		!owner base
	   endif
	   if     (prop.le.0.or.		!regular base or
	1          propseen     ) then		!property
	      call stredt_(b,prop,edit,
     1                     newfil,new,full,erro)
	   elseif (serseen) then		!series
cx	      call xxy
	   else					!memo
cx	      call xxy
	   endif
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.true.
	   if (erro.ne.0) then
	      if (propseen.or.
	1         serseen.or.
	1         memo seen   ) then
	         goto 95000			!show error
	      else
	         if (d$rsub.eq.'STREDT'.and.
	1            erro.eq.8              ) then	!no field specified
c	            ok, maybe only creatures
	         else
	            goto 95000			!show error
	         endif
	      endif
	   endif
c
	endif
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) then
c
	   if (d$nfld(prop).le.3) goto 90015	!no user field specified
c
	   b=prop
	   d$ownb(b)=ownam		!owner base
c
	else
c
	   b=base
	   d$race(b)=r$b			!regular base
	   d$ownb(b)=' '			!owner base
	   d$pdim(b)=1				!dimension = 1
	   d$psiz(b)=0				!size of elements
	   d$pdec(b)=0				!decimal places
c
c	   Special creatures now if that's the case
c
	   if (.not.creatures) goto 380		!no creature allowed
c
	   write (mssg,10006)			!extensions to basic structure
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
c
	   if (.not.s$set(s$scre)) then		!line mode
c
c	      properties
	      call i$crcr_(b,p$,newfil,buf,erro)
	      if (erro.ne.0) goto 95000		!show error
c
c	      series
	      call i$crcr_(b,s$,newfil,buf,erro)
	      if (erro.ne.0) goto 95000		!show error
c
c	      memos
	      call i$crcr_(b,mm$,newfil,buf,erro)
	      if (erro.ne.0) goto 95000		!show error
c
	   else					!screen mode
c
10	      continue
	      write (mssg,10007)			!define properties ?
	      call i$mess_(0,d$cmdo,1,mssg,0,erro)
	      if (erro.ne.0) return			!error, carry
	      call i$yn_(answr,erro)			!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return			!error, carry
	         call errclr_('C$REAT')			!clear error
	         erro=0
	         goto 10				!loop back
	      endif
c
	      if (answr.eq.3.or.answr.eq.4) goto 10	!^Z, comment line
c
	      if (answr.eq.1) then
c	         "Y"
c
c	         properties
	         call credt_(b,p$,edit,newfil,new,full,erro)
	         if (erro.ne.0) goto 95000		!show error
c
	      endif
c
20	      continue
	      write (mssg,10008)			!define series ?
	      call i$mess_(0,d$cmdo,1,mssg,0,erro)
	      if (erro.ne.0) return			!error, carry
	      call i$yn_(answr,erro)			!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return			!error, carry
	         call errclr_('C$REAT')			!clear error
	         erro=0
	         goto 20				!loop back
	      endif
c
	      if (answr.eq.3.or.answr.eq.4) goto 10	!^Z, comment line
c
	      if (answr.eq.1) then
c	         "Y"
c
c	         series
	         call credt_(b,s$,edit,newfil,new,full,erro)
	         if (erro.ne.0) goto 95000		!show error
c
	      endif
c
30	      continue
	      write (mssg,10009)			!define memos ?
	      call i$mess_(0,d$cmdo,1,mssg,0,erro)
	      if (erro.ne.0) return			!error, carry
	      call i$yn_(answr,erro)			!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return			!error, carry
	         call errclr_('C$REAT')			!clear error
	         erro=0
	         goto 30				!loop back
	      endif
c
	      if (answr.eq.3.or.answr.eq.4) goto 10	!^Z, comment line
c
	      if (answr.eq.1) then
c	         "Y"
c
c	         memos
	         call credt_(b,mm$,edit,newfil,new,full,erro)
	         if (erro.ne.0) goto 95000		!show error
c
	      endif
c
	   endif
c
	endif
c
380	continue
c
c	Create structure
c
	call strout_(b,newfil,new,full,erro)	!create basic structure
	if (erro.ne.0) goto 95000		!show error
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then				!interactive
c
	   update=1					!update
	   mode=0					!usual mode
	   call open_(b,newfil,update,mode,outopn,erro)!open database
	   if (erro.ne.0) then
	      goto 95000				!show error
	   endif
c
	   call i$scur_(b,0,0)				!set it current
c
	   call zrace_(b,race,irace,idim,isize,ideci,erro)
	   if (erro.ne.0) return			!error, carry
	   write (mssg,10004) race(1:istrip_(race)),
	1                     newfil(1:istrip_(newfil))	!be nice
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	endif
c
	goto 400					!back to main loop
c
c	Back to main loop
c	=================
c
400	continue
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	return
c
c	^Z or eof found
c	---------------
c
900	continue
	if (at$lvl.le.0) then
	   goto 90009			!^Z found
	else
	   call i$atup_(erro)		!@ file active, go up
	   goto 90009			!same in any case
	endif
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro.eq.1 = illegal char., 2 = too many digits)
90000	continue
	if (erro.eq.2) then
	   goto 90007
	else
	   goto 90001				!illegal character
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!give error message and return
c	illegal type of "token" (not identifier or eol)
90002	continue
	mark=p1
	erro=2
	goto 99000			!give error message and return
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!give error message and return
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!give error message and return
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!give error message and return
c	unexpected keyword
90006	continue
	mark=p1
	erro=6
	goto 99000			!give error message and return
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!give error message and return
c	<newfile.ROO> already exists
90008	continue
	erro=8
	goto 99000			!give error message and return
c	^Z, command execution aborted
90009	continue
	erro=9
	goto 99000			!give error message and return
c	*** obsolete *** create <new> from <old> not yet ...
90010	continue
	erro=10
	goto 99000			!give error message and return
c	mo memory space for data base
90011	continue
	erro=11
	goto 99000			!give error message and return
c	can't find owner base
90012	continue
	erro=12
	goto 99000			!give error message and return
c	owner base isn't a regular base
90013	continue
	erro=13
	goto 99000			!give error message and return
c	no such property/series/memo in owner base
90014	continue
	d$rinf=propnam
	erro=14
	goto 99000			!give error message and return
c	no field specified (only pointers...)
90015	continue
	erro=15
	goto 99000			!give error message and return
c	eol expected here
90016	continue
	mark=p1
	erro=16
	goto 99000			!give error message and return
c
c	Show other's error message and return
c	=====================================
c
95000	continue
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   call errclr_('C$REAT')		!clear error
	endif
c
	return					!return
c
c	Give error message (?...) and return
c	====================================
99000	continue
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('C$REAT',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('C$REAT',erro)		!set global error
	endif
c
	return					!return
c
c	Formats
c	=======
c
	include 'fmt:creat.fmt'
c
	end
c
c
c
c
	subroutine K$ILL_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements KILL command:
c
c	*****	KILL	[DATABASE <database>]
c                       [[SCOPE] <scope list>]
c			[FOR 	 <for   list>]
c
c		KILLs records of data base (eg KILL next 10 FOR phone =
c						 '415'):
c		- the [FOR] exp list is always evaluated within <scope>;
c
c	   <scope list>	routine scpsyn:	analyse scope list
c				scpchk: check/complete scope list against base
c				scpsem:	complete scope list
c	   <for   list>		forsyn:	analyse for list
c				forchk:	check for list against base
c				forsem:	complete for list
c
c	   If no scope is specified, default scope is CURRENT SEARCH, if any.
c
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,noerr
	integer interr,io
	real rval
	integer nfor,nscope,ndatab,alive,count,rec,answr,bmsize
	character*12 bname
	integer wrongs(100),whats(100),k,l,zl,zf,izf,izl,topr,what,who,dig
	logical for,cursrc,always,answer,topbot,outopn
	integer scpinf,scpsup,bmsz,bm,fwhtsz,fwht,fwhosz,fwho,all,allsiz
	character*60 myfile
c
c	begin
c	=====
c
	call errclr_('K$ILL')		!error init
c
	bmsz=0			!temporary bit map (bm) space size
	fwhtsz=0		!temporay WHAT (fwht) space size
	fwhosz=0		!temporay WHOWHO (fwho) space size
	all=d$f+2			!......size
	nfor=0				!#[FOR ...]
	nscope=0			!#[SCOPE ...]
	ndatab=0			!#[DATABASE ...]
c
c	Lopp here to get next keyword or implicit scope
c	-----------------------------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
	1	type.ne.1.and.
	1	type.ne.2    ) then
	   goto 90002			!syntax error (neither identifier,
					!              integer, "(" or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute KILL com.
	elseif (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
c	Loop here if token is a keyword (from SCOPE or FOR)
c	---------------------------------------------------
c
2	continue
c
	if (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.scopky)  then
	   nscope=nscope+1		!count it
	   goto 100			!"eat" [SCOPE...]
	elseif (keypos.eq.forky)  then
	   nfor=nfor+1			!count it
	   goto 200			!"eat" [FOR <exp list>]
	elseif (keypos.eq.dataky)  then
	   ndatab=ndatab+1		!count it
	   goto 300			!"eat" DATABASE <database>
					!(same code as FILES <database>
	else
	   nscope=nscope+1		!count it
	   goto 101			!other keyword, try SCOPE
	endif
c
c	Here to "eat" [SCOPE ...]
c	-------------------------
c
100	continue
c
c	an extra tokane, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
101	continue
c
c	Avoid loops due to implicit call to SCPSYN with non-scope keyword
c	-----------------------------------------------------------------
c
	if    (nscope.gt.1) goto 90009	!unexpected keyword
c
c	submit SCOPE syntactical analysis
c	---------------------------------
c
	erro=0				!only my own error messages
	call scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
	1	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error,
					!set edit mode and return
c
c	come from SCOPE expression with next token
c	------------------------------------------
c
	if     (type.ne.0.and.
	1       type.ne.2.and.
	1	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute KILL command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FOR ...]
c	-----------------------
c
200	continue
c
c	submit FOR syntactical analysis
c	-------------------------------
c
	erro=0				!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
	1	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error,
					!set edit mode and return
c
c	come from FOR expression with next token
c	----------------------------------------
c
	if     (type.ne.0.and.
	1       type.ne.2.and.
	1	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute KILL command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FILES ...] or [DATABASE ...]
c	-------------------------------------------
c
300	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
	1       type.ne.24    ) then
	   goto 90014			!syntax error (database name expected)
	else
	   bname(1:)=' '
	   bname(1:)=buf(p1:p2)		!store database name
	   call uc_(bname)		!upper case it
	   goto 1			!loop back for more (???)
	endif
c
c	Here to check/complete/execute KILL command
c	-------------------------------------------
c
500	continue
c
c	Check KILL command
c	------------------
c
c	check duplicate requests in command
c
	if (nscope.gt.1.or.
	1   ndatab.gt.1.or.
	1   nfor  .gt.1   ) then
	   goto 90008			!duplicate requests
	endif
c
c	>>>>>> KILL SCOPE... FOR...
c	===========================
c
c	Complete KILL command
c	---------------------
c
c	Ask for current base if needed and user didn't supply one
c	---------------------------------------------------------
c
	if (ndatab.gt.0) then		!user supplied database name
	   mode=0
	   update=1
	   call open_(base,bname,update,mode,outopn,erro)!open database
	   if (erro.ne.0) then
	      goto 95000			!show error
	   endif
	else
	   update=1					!don't change update
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	   if (erro.ne.0) return			!error, carry
	   if (base.eq.0) goto 900			!no base, return
	endif
c
c	check SCOPE or CURRENT SEARCH used
c
	if (nscope.le.0.and.
	1   bitcan(base).eq.1) then
	   goto 90013
	endif
c
	if (nscope.le.0) then			!no SCOPE
	   cursrc=.true.			!remember CURRENT SEARCH used
	else					!use SCOPE
	   cursrc=.false.			!remember CURR. SEARCH not used
	endif
c
c	See if CURRENT SEARCH and not empty
c
	if (cursrc) then
	   rec=0				!don't forget anybody...
	   call bitcnt_(%val(bitpnt(base)),rec,count,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   if (count.le.0) goto 90012		!empty!
	endif
c
c	Use always temporary BIT MAP; if CURRENT SEARCH used, both
c	bits maps should have the same definition (BITOR ...)
c
	if (cursrc) then
	   call bitlim_(%val(bitpnt(base)),izf,izl,erro)!fake zf,zl
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(base,izf,zf,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(base,izl,zl,erro)
	   if (erro.ne.0) goto 900
	   call bitmax_(%val(bitpnt(base)),bmsz,erro)	!bitmap size
	   if (erro.ne.0) goto 900			!error, carry
	   call get_vm_(4*bmsz,bm,erro)			!ask for room
	   if (erro.ne.0) goto 90010			!no memory!
	   call bitini_(%val(bm),bmsz,izf,topr,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call bitor_(%val(bm),%val(bitpnt(base)),erro)
	   if (erro.ne.0) return			!error, carry
	else
	   zf=d$unus-d$offs(base)+1			!first record#
	   izf=zf
	   call zend_(base,zl,erro)			!and last
	   if (erro.ne.0) goto 900			!error, carry
	   call ex3in_(base,zl,izl,erro)
	   if (erro.ne.0) goto 900
	   if (izl.le.0) then
	      bmsz=8
	   else
	      bmsz=(izl-izf+1)/32+8			!bit map size
	   endif
	   call get_vm_(4*bmsz,bm,erro)			!ask for room
	   if (erro.ne.0) goto 90010			!no memory!
	   call bitini_(%val(bm),bmsz,izf,topr,erro)!init bit map
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
c	Complete SCOPE if not CURRENT SEARCH
c	------------------------------------
c
	if (.not.cursrc) then
c
	   call scpchk_(base,%val(bm),scpinf,scpsup,alive,topbot,erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000			!display others error,
						!set edit mode and return
	   endif
	   if (topbot) goto 90017		!TOP/BOTTOM adjustment
	   call scpsem_(%val(bm),erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000			!display others error,
						!set edit mode and return
	   endif
c
	endif
c
c	Check/complete FOR
c
	if (nfor.gt.0) then
c
c	   allocate temporary space
c
	   fwhtsz=all
	   fwhosz=all
	   call get_vm_(4*fwhtsz,fwht,erro)
	   if (erro.ne.0) goto 90010			!no memory!
	   call get_vm_(4*fwhosz,fwho,erro)
	   if (erro.ne.0) goto 90010			!no memory!
c
c	   Check FOR list validity against data base
c
	   call forchk_(base,all,%val(fwho),%val(fwht),allsiz,erro)
c
c	   if errors in fields, types, etc be nice and give full report
c
	   if (erro.ne.0) then
	      mark=0
	      if (erro.eq.1) then			!type conflict
	         call i$fker_(base,allsiz,%val(fwho),%val(fwht),erro)
	         if (erro.ne.0) goto 900		!error, carry
	         erro=1					!recover error paternity
	         call errset_('FORCHK',erro)		!...
	      endif
	      goto 95000				!everybody goes
	   endif
	endif
c
c	FOR semantic execution
c
	if (nfor.gt.0) then
	   call forsem_(base,alive,%val(bm),bmsz,
	1                    page,%val(fwht),erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!others error
	   endif
	endif
c
c	Validate bitmap if FOR not specified and CURRENT SEARCH not used
c
	if (nfor.le.0.and.
	1   .not.cursrc   ) then
	   call forall_(base,alive,%val(bm),erro)	!validate bit map
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
	goto 600			!KILL [SCOPE... [FOR...
c
c	>>>>>> Execute command KILL [SCOPE] [FOR]
c	-----------------------------------------
c
c	Confirm
c
600	continue
c
	if (d$prt(base).ne.0) then		!protection ON
	   do k = 1, d$nfld(base)		!see if protected fields
	      if (d$prfl(k,base).ne.prtrw) then
	         goto 90016			!sorry, can't delete
	      endif
	   enddo
	endif
c
	rec=0				!don't forget anybody...
	call bitcnt_(%val(bm),rec,count,erro)
	if (erro.ne.0) goto 900		!error, carry
c
610	continue
c
	if (count.gt.0) then
c
	   if (s$set(s$conf)) then
c
	      if (nfor.gt.0) then
	         if (.not.s$set(s$case).or..not.s$set(s$perf)) then
	            write (mssg(1:),10004)	!warn user about CASE and MATCH!
	            call i$mess_(0,d$cmdo,1,mssg,0,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
c
	      write (mssg,10001)
	      dig=ndigi_(count)
	      lim=istrip_(mssg)+2
	      call wrivar_(mssg(lim:),count,dig,erro)
	      if (erro.ne.0) goto 90015			!write error
	      call i$mess_(0,d$cmdo,1,mssg,0,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
	      write (mssg(1:),10002)			!ok(y/n)
	      call i$mess_(0,d$cmdo,1,mssg,0,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
	      call i$yn_(answr,erro)			!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, return
	         call errclr_('K$ILL')			!clear error
	         goto 600				!loop back
	      endif
c
	   else						!blind guy
c
	      answr=1					!proceed ...
c
	   endif
c
	   if (answr.eq.5) goto 600	!'??????', loop back
	   if (answr.eq.4) goto 600	!comment line
	   if (answr.eq.2.or.
	1      answr.eq.3   ) then
	      goto 900			!'N' or ^Z, return
	   endif
c
c	   1 = "Y"
c
	   mode=0					!usual mode
	   call i$kilr_(base,%val(bm),mode,erro)	!kill records
	   if (erro.ne.0) then
	      if (d$rsub.eq.'OPX'.and.
	1         erro.eq.5) goto 95000		!can't open index file
	      goto 900					!error, carry
	   endif
c
	   if (cursrc) then
	      bitcan(base)=1				!SEARCH='none'
	      if (base.eq.c$base) then
	         call i$scur_(c$base,c$rec,c$fld)	!re-inform user
	      endif
	   endif
c
	else
c
	   write (mssg(1:),10003)			!no record selected!
	   call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	endif
c
	goto 900					!return properly
c
c
c	           R   E   T   U   R   N
c	======================================================
c	Deallocate any memory space
c	Return to main loop
c	======================================================
c
900	continue
c
c	Free temporary memory space
c
	call lib$free_vm(4*bmsz,bm)
	call lib$free_vm(4*fwhtsz,fwht)
	call lib$free_vm(4*fwhosz,fwho)
c
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier,integer or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword,integer or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	unexpected keyword or SCOPE called twice
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	memory (lib$get_vm) failure
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	no i/o channel available, close some base...
90011	continue
	erro=11
	goto 99000			!display error and return properly
c	curent search is empty
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	no current search and no SCOPE specified
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	data base name expected
90014	continue
	erro=14
	goto 99000			!display error and return properly
c	write error
90015	continue
	erro=15
	goto 99000			!display error and return properly
c	protected fields, can't kill
90016	continue
	erro=16
	goto 99000			!display error and return properly
c	TOP/BOTTOM adjustment
90017	continue
	erro=17
	goto 99000			!display error and return properly
c	Display error message (?...), deallocate any memory and return
c	==============================================================
99000	continue
c
	call lib$free_vm(4*bmsz,bm)
	call lib$free_vm(4*fwhtsz,fwht)
	call lib$free_vm(4*fwhosz,fwho)
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('K$ILL',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('K$ILL',erro)		!set error
	endif
	return
c
c	Display others error message (?...), deallocate any memory and return
c	=====================================================================
95000	continue
c
	call lib$free_vm(4*bmsz,bm)
	call lib$free_vm(4*fwhtsz,fwht)
	call lib$free_vm(4*fwhosz,fwho)
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:kill.fmt'
c
	end
c
c
c
c
	subroutine D$ELET_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements DELETE command:
c
c	*****	DELETE	FILES <database> or DELETE DATABASE <database>
c
c	Database files with logical name <database> are deleted.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,size
	integer io
	real rval
	integer nfiles,ndata,rec,answr
	character*12 bname
	integer k,l,okrec,klrec,delete,berr,ferr
	character*60 myfile
	logical refer,defprop,defseries,defmemo,aliens,outopn
	character*30 race
	integer	irace,idim,isize,ideci
c
c	begin
c	=====
c
	call errclr_('D$ELET')		!error init
c
	nfiles=0			!#[FILES ...]
	ndata=0				!#[DATABASE ...]
c
c	Lopp here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error(neither identifier or eol)
	endif
c
	if (type.eq.0) goto 200		!eol, go complete/execute DELETE com.
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.fileky)  then
	   nfiles=nfiles+1		!count it
	   goto 100			!"eat" FILES <database>
	elseif (keypos.eq.dataky)  then
	   ndata=ndata+1		!count it
	   goto 100			!"eat" DATABASE <database>
	else
	   goto 90008			!unexpected keyword
	endif
c
c	Here to "eat" [FILES/DATABASE ...]
c	----------------------------------
c
100	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90011			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   write (mssg,10006) buf(p1:p1+size-1)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	   if (erro.ne.0) goto 900		!error, carry
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!loop back for more (???)
c
c	Here to check/complete/execute DELETE command
c	----------------------------------------------
c
200	continue
c
c	Check DELETE command
c	---------------------
c
c	check duplicate requests in command
c
	if (nfiles.gt.1) goto 90007	!duplicate requests
	if (ndata.gt.1) goto 90007	!duplicate requests
	if (nfiles.gt.0.and.
	1   ndata.gt.0      ) goto 90007!duplicate requests
	if (nfiles.le.0.and.
	1   ndata .le.0     ) goto 90012!keyword FILES/DATABASE not seen
c
c	>>>>>> DELETE FILES <database>
c	==============================
c
	mode=0
	update=1
	call open_(base,bname,update,mode,outopn,erro)!open database
	if (erro.ne.0) then
	   if (d$rsub.eq.'OPNBAS'.and.
	1          erro.eq.18) then			!version 0 and update
c	      ok, let him delete the base
	   else
	      goto 95000				!show error
	   endif
	endif
c
c	Creatures ?
c
	update=-1				!don't change
	call opncrt_(base,update,defprop,defseries,defmemo,erro)
	if (erro.ne.0) goto 95000		!show error
c
	aliens=.false.				!assume no aliens
	if (defprop) then
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.p$) then	!property
	         if (d$dbio(k,base).gt.0) then	!and alive
	            aliens=.true.
	            write (mssg,10008) d$fnam(k,base)
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
	   enddo
	endif
c
	if (defseries) then
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.s$) then	!series
	         if (d$dbio(k,base).gt.0) then	!and alive
	            aliens=.true.
	            write (mssg,10009) d$fnam(k,base)
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
	   enddo
	endif
c
	if (defmemo) then
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.mm$) then	!memos
	         if (d$dbio(k,base).gt.0) then	!and alive
	            aliens=.true.
	            write (mssg,10010) d$fnam(k,base)
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
	   enddo
	endif
c
	if (aliens) goto 900			!return
c
c	Version 0 and killed records ?
c
	if (d$prt(base).ne.0) then		!protection ON
	   do k = 1, d$nfld(base)		!see if protected fields
	      if (d$prfl(k,base).ne.prtrw) then
	         goto 90013			!sorry, can't delete
	      endif
	   enddo
	endif
c
c	Used by someone ?
c
	call i$odb_(base,berr,ferr,refer,erro)	!is base used as o.d.b ?
	if (erro.ne.0) return			!error, carry
	if (refer) goto 90014			!can't close base
c
c	Confirm it, just in case...
c
710	continue
c
	if (s$set(s$conf)) then
c
	   call zrace_(base,race,irace,idim,isize,ideci,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   write (mssg(1:),10001)
     1                    race(1:istrip_(race)),
     1                    d$unam(base)(1:istrip_(d$unam(base))),
     1                    d$bfil(base)(1:istrip_(d$bfil(base)))
	   call i$mess_(0,d$cmdo,1,mssg,1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   lim=istrip_(d$bdes(base))
	   if (lim.le.0) then
	      lim=1
	      d$bdes(base)=' '
	   endif
	   write (mssg(1:),10002) d$bdes(base)(1:lim)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   if (irace.eq.r$b) then			!regular base
	      call zrec2_(base,okrec,klrec,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      write (mssg(1:),10005) okrec		!alive
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      write (mssg(1:),10007) klrec		!and killed records
	      call i$mess_(0,d$cmdo,-1,mssg,1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
	   write (mssg(1:),10003)			!ok(y/n)
	   call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   call i$yn_(answr,erro)			!accept y/n
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, return
	      call errclr_('D$ELET')			!clear error
	      goto 710					!loop back
	   endif
c
	else						!blind guy
c
	   answr=1					!proceed ...
c
	endif
c
	if (answr.eq.5) goto 710	!'??????', loop back
	if (answr.eq.4) goto 710	!comment line
	if (answr.eq.2.or.answr.eq.3) then!'N' or ^Z, close base and return
	   call close_(base,erro)
	   if (erro.ne.0) then
	      call errclr_('D$ELET')	!clear error
	   endif
	   goto 900
	endif
c
c	1 = 'Y', delete database files
c
c	   First, delete all files related to data base
c	   --------------------------------------------
c
	   delete=.true.				!base files will be del.
	   call i$delf_(base,delete,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
c	   Delete root and base files now
c	   ------------------------------
c
	   myfile(1:)=' '				!file spec
	   myfile=d$bfil(base)
c
	   io=d$rio(base)
	   if (io.le.0) then
	      call newc_(io)				!root is closed, open it
	      if (io.le.0) goto 90009			!no more i/o channels
	      call givext_(myfile,'.ROO')		!add extension
	      open(unit=io, file=myfile, status='old',
     1             access='direct', organization='relative',
     1             err=90010)
	   endif
	   close (unit=io,dispose='delete',err=90010)	!delete root
	   call freec_(io)
	   d$rio(base)=0				!clean context i/o ch.
c
	   io=d$bio(base)				!and base files, but...
	   if (io.gt.0) close (unit=io)			!just make sure !!!
	   call givext_(myfile,'.DBF')			!add extension
	   open(unit=io, file=myfile, status='old',
     1          err=90010)
	   close (unit=io,dispose='delete',err=90010)
	   call freec_(io)
	   io=0
	   d$bio(base)=0				!clean context i/o ch.
c
	   if (d$itrv.eq.1) then			!interactive
	      write (mssg(1:),10004) d$unam(base)(1:istrip_(d$unam(base))),
     1                       d$bfil(base)(1:istrip_(d$bfil(base)))
	      call i$mess_(0,d$cmdo,1,mssg,1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
	   call frebas_(base)				!out of context
c
	goto 900					!return in any case
c
c
c	R   E   T   U   R   N
c	=====================
c
900	continue
c
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90006
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	too many digits
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90007	continue
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	no i/o channel available, close some base...
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	problems deleting root/dbf files
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	data base name expected
90011	continue
	mark=p1
	erro=11
	goto 99000			!display error and return properly
c	FILES/DATABASE keyword not seen
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	Protected fields, can't delete
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	field used as o.d.b. by someone, can't delete base
90014	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(berr)			!tell him witch base
	erro=14
	goto 99000				!display error
c
c	Display error message (?...), deallocate any memory and return
c	==============================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('D$ELET',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('D$ELET',erro)		!set global error
	endif
c
	return
c
c	Display others error message (?...), deallocate any memory and return
c	=====================================================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:delete.fmt'
c
	end
c
c
c
c
	subroutine D$ISPL_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements DISPLAY command, by calling common procedure I$DL (LIST
c	command uses same procedure).
c
c	var
c	===
c
	integer who, erro
c
c	begin
c	=====
c
	call errclr_('D$ISPL')		!error init
c
	who=1				!DISPLAY calling you...
	call I$DL_ (buf,mark,who)	!execute DISPLAY command
c
	return				!return to main loop
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine E$DIT_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements EDIT command:
c
c	1) EDIT	[TO <database>]	[SCOPE  ...]
c				[FOR    ...]
c				[FIELDS ...]
c
c	2) EDIT	FROM <database>	[SCOPE  ...]
c				[FOR    ...]
c				[FIELDS ...]
c
c		TO <file.ext>	[SDF/DBAG]
c				[NEW/OLD]
c
c	3) EDIT	FROM <file.ext>	[SDF/DBAG]
c				[FIELDS ...]
c		[TO  <database>]
c
c	4) EDIT	FROM <database>	[SCOPE  ...]
c				[FOR    ...]
c				[FIELDS ...]
c		[TO  <database>]
c
c	If indexes in use, the index files are automatically updated.
c
c	When editing to file, output file may be superseded (if NEW specified)
c	or appended (if OLD specified). Default is NEW.
c
c	Default FIELDS is all fields.
c
c	Default SCOPE when editing from a database is ALL records.
c
c	Default <file.ext> format is DBAG (file DBAGF.FOR for details).
c
c	N.B.: If editing to database, this one becomes current database
c	      as well as last edited record, current search if any is
c	      cancelled and search bitmap is extended if nedded.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external istrip_
	integer istrip_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,what,recsiz,sz,
     1   	size,ibase,ichan,obase,ochan,irec,recnum,noerr
	integer nfor,nscop,nfiel,nto,nfrom,nisdf,nidbf,nosdf,nodbf,
     1   	nimpi,nimpo,line,bmsize,bitinf,bitsup,izf,izl,zf,zl,topr,
     1   	scpinf,scpsup,nproperty,nseries,nmemo,nnorec
	integer interr,count,rec,k,f,l,alive,
     1   	ibm,ibmsz,obm,obmsz,fm,fmsz,fwht,fwhtsz,fwho,fwhosz,
     1   	dnfld,all,allsiz,who,cnt,inpopn,outopn,
     1   	nbad,ftrans,nnew,nold,xmin,xmax
	integer pm,pmsz,sm,smsz,mm,mmsz
	integer irace,idim,isize,ideci
	character*30 race
	real rval
	character*60 bnam,fnam,ifnam,ofnam
	character*12 fext,ifext,ofext
	character*10 www,cmmd,basenm,when,usrnam,where
	character*3 newold
	character*(vlong) lcpage(psiz)
	logical new,twice,cursrc,eof,eobm,always,found,blnk,trunc,fsem,fall
	logical idbf,odbf,frtt,frfile,frbase,tobase,tobuse,tofile,opn,prefix
	logical edt,hisext,answer,fwrite,protfail,topbot,reset
	logical defprop,defseries,defmemo,property,series,memo,norec
	integer prop
c
c	begin
c	=====
c
	call errclr_('E$DIT')		!error init
c
	ibmsz=0			!temporary bit map (bm) space size (ibase)
	obmsz=0			!temporary bit map (bm) space size (obase)
	fmsz=0			!temporary field map (fm) space size
	pmsz=0			!same for properties
	smsz=0			!same for series
	mmsz=0			!same for memos
	fwhtsz=0		!temporary WHAT (fwht) space size
	fwhosz=0		!temporary WHOWHO (fwho) space size
	all=d$f+2			!.....size
	cursrc=.false.			!assume CURRENT SEARCH will not be used
	inpopn=.false.
	outopn=.false.
	fsem=.false.			!assume no need to call FORSEM
	fall=.false.			!same about FORALL
	idbf=.true.			!.true. se FROM DBAG file
	odbf=.true.			!.true. se TO DBAG file
	edt=.false.			!assume i$edit not called
	reset=.true.			!reset field map
c
	nfor=0				!#[FOR ...]
	nscop=0				!#[SCOPE ...]
	nfiel=0				!#[FIELD ...]
	nfrom=0				!#[FROM]
	nto=0				!#[TO]
	nisdf=0				!#[FROM] [SDF]
	nimpi=0				!# implicit [FROM] <file.ext>
	nidbf=0				!#[FROM] [DBAG]
	nosdf=0				!#[TO]   [SDF]
	nodbf=0				!#[TO]   [DBAG]
	nimpo=0				!# implicit [TO] <file.ext>
	nnew=0				!#NEW
	nold=0				!#OLD
	nproperty=0			!#[PROPERTY]
	nseries=0			!#[SERIES]
	nmemo=0				!#[MEMO]
	nnorec=0			!#[NORECORDS]
c
	new=.true.			!Supersede if appending to file(default)
	property=.false.
	series=.false.
	memo=.false.
	norec=.false.
	prop=0
c
	ifnam(1:)=' '			!input databse name/file name
	ifext(1:)=' '			!and extension
	ibase=0				!input base channel
	ichan=0				!input file.ext i/o channel
	ofnam(1:)=' '			!output databse name/file name
	ofext(1:)=' '			!and extension
	obase=0				!output base channel
	ochan=0				!output file.ext i/o channel
c
c	Loop here to get next keyword or implicit scope
c	-----------------------------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1.and.
     1   	type.ne.2    ) then
	   goto 90002			!syntax error (neither identifier,
					!              integer, or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, go complete/execute EDIT command
	elseif (type.eq.2) then
	   nscop=nscop+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
c	Loop here if token is a keyword (from SCOPE, FOR, FIELDS, TO or FROM)
c	or an implicit scope
c	---------------------------------------------------------------------
c
2	continue
c
	if (type.eq.2) then
	   nscop=nscop+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.scopky)  then
	   nscop=nscop+1		!count it
	   goto 100			!"eat" [SCOPE...]
	elseif (keypos.eq.forky)  then
	   nfor=nfor+1			!count it
	   goto 200			!"eat" [FOR <exp list>]
	elseif (keypos.eq.fielky) then
	   nfiel=nfiel+1		!count it
	   goto 300			!"eat" [FIELDS <field list>]
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 400			!"eat" [TO] phrase
	elseif (keypos.eq.propky) then
	   nproperty=nproperty+1	!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.seriky) then
	   nseries=nseries+1	!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.memoky) then
	   nmemo=nmemo+1	!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.noreky) then
	   nnorec=nnorec+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.fromky) then
	   nfrom=nfrom+1		!count it
	   goto 500			!"eat" [FROM] phrase
	elseif (keypos.eq.newky) then
	   nnew=nnew+1			!count it
	   new=.true.			!set it
	   goto 1			!and loop back for more
	elseif (keypos.eq.oldky) then
	   nold=nold+1			!count it
	   new=.false.			!set it
	   goto 1			!and loop back for more
	else
	   nscop=nscop+1		!count it
	   goto 101			!other keyword, try SCOPE
	endif
c
c	Here to "eat" [SCOPE ...]
c	-------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
101	continue
c
c	Avoid loops due to implicit call to SCPSYN with non-scope keyword
c	-----------------------------------------------------------------
c
	if    (nscop.gt.1) goto 90008	!unexpected keyword
c
c	submit SCOPE syntactical analysis
c	---------------------------------
c
	erro=0				!only my own error messages
	call scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from SCOPE expression with next token
c	------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute EDIT command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FOR ...]
c	-----------------------
c
200	continue
c
c	submit FOR syntactical analysis
c	-------------------------------
c
	erro=0				!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from FOR expression with next token
c	----------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute EDIT command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FIELDS ...]
c	--------------------------
c
300	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	erro=0				!only my own error messages
	call fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
	reset=.false.			!don't reset anymore
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from FIELDS expression with next token
c	-------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute EDIT command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [TO] <database/file.ext> [SDF/DBAG]
c	------------------------------------------------------
c
400	continue
c
c	get <database/file.ext>
c	-----------------------
c
c	Look for filespec
c
	ofnam(1:)=' '
	ofext(1:)=' '
	call infspc_(type,what,ofnam,ofext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90011		!database/file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	if (what.eq.1.or.
     1      what.eq.2   ) then
	   nimpo=nimpo+1			!count implicit TO file.ext
	else
	   if (index(ofnam,':').gt.0.or.	!file spec anyway
     1         index(ofnam,'[').gt.0    )then
	      nimpo=nimpo+1			!count implicit TO file.ext
	   endif
	endif
c
c	get keyword SDF or DBAG
c	----------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
	if (type.ne.0.and.
     1      type.ne.2.and.
     1      type.ne.1    ) goto 90006	!syntax error (not identifier,
					!integer or eol)
	if (type.eq.0) goto 600		!eol, go complete/execute EDIT command
c
	if (type.eq.2) goto 2		!integer, go back
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.sdfky) then
	   nosdf=nosdf+1		!count it
	   goto 1			!loop back for more
	elseif (keypos.eq.dbagky) then
	   nodbf=nodbf+1		!count it
	   goto 1			!loop back for more
	else
	   goto 2			!keyword found
	endif
c
c	Here to "eat" [FROM] <database/file.ext> [SDF/DBAG]
c	--------------------------------------------------------
c
500	continue
c
c	get <database/file.ext>
c	-----------------------
c
c	Look for filespec
c
	ifnam(1:)=' '
	ifext(1:)=' '
	call infspc_(type,what,ifnam,ifext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90011		!database/file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	if (what.eq.1.or.
     1      what.eq.2   ) then
	   nimpi=nimpi+1			!count implicit FROM file.ext
	else
	   if (index(ifnam,':').gt.0.or.	!file spec anyway
     1         index(ifnam,'[').gt.0    )then
	      nimpi=nimpi+1			!count implicit FROM file.ext
	   endif
	endif
c
c	get keyword SDF or DBAG
c	----------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
	if (type.ne.0.and.
     1      type.ne.2.and.
     1      type.ne.1    ) goto 90006	!syntax error (not identifier,
					!integer or eol)
	if (type.eq.0) goto 600		!eol, go complete/execute EDIT command
c
	if (type.eq.2) goto 2		!integer, go back
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.sdfky) then
	   nisdf=nisdf+1		!count it
	   goto 1			!loop back for more
	elseif (keypos.eq.dbagky) then
	   nidbf=nidbf+1		!count it
	   goto 1			!loop back for more
	else
	   goto 2			!keyword found
	endif
c
c	>>>>>> Here to check/complete/inform/execute EDIT command
c	=========================================================
c
600	continue
c
c	Check command
c	-------------
c
c	Indicators:
c
c	nfor			#[FOR ...]
c	nscop			#[SCOPE ...]
c	nfiel			#[FIELD ...]
c	nfrom			#[FROM]
c	nto			#[TO]
c	nisdf			#[FROM] [SDF]
c	nimpi			# implicit [FROM] <file.ext>
c	nidbf			#[FROM] [DBAG]
c	nosdf			#[TO]   [SDF]
c	nodbf			#[TO]   [DBAG]
c	nimpo			# implicit [TO] <file.ext>
c	nnew			#NEW
c	nold			#OLD
c	nproperty		#PROPERTY
c	nseries			#SERIES
c	nmemo			#MEMO
c	norec			#NORECORDS
c
c	Implicit FROM/TO "file.ext" defaults to DBAG format
c	--------------------------------------------------------
c
	if (nimpi.gt.0.and.		!implicit FROM file.ext
     1      nisdf.eq.0.and.			!and no SDF found
     1      nidbf.eq.0     ) then		!and no DBAG found
	   nidbf=1				!"fake" DBAG found
	endif
c
	if (nimpo.gt.0.and.		!implicit TO file.ext
     1      nosdf.eq.0.and.			!and no SDF found
     1      nodbf.eq.0     ) then		!and no DBAG found
	   nodbf=1				!"fake" DBAG found
	endif
c
	frtt=.false.			!FROM tt:
	frbase=.false.			!FROM base
	frfile=.false.			!FROM file
	tobase=.false.			!TO base
	tobuse=.false.			!TO database in use
	tofile=.false.			!TO file
c
	if (nto.le.0) then
	   tobuse=.true.
	else
	   if (nosdf.gt.0.or.
     1         nimpo.gt.0.or.
     1         nodbf.gt.0    ) then
	      tofile=.true.
	   else
	      tobase=.true.
	   endif
	endif
c
	if (nfrom.le.0) then
	   frtt=.true.
	else
	   if (nisdf.gt.0.or.
     1         nimpi.gt.0.or.
     1         nidbf.gt.0) then
	      frfile=.true.
	   else
	      frbase=.true.
	   endif
	endif
c
	call uc_(ifnam)			!upper case all names
	call uc_(ifext)			!...
	call uc_(ofnam)			!...
	call uc_(ofext)			!...
c
	if (nnorec.gt.0) norec=.true.
	if (nproperty.gt.0) property=.true.
	if (nseries.gt.0) series=.true.
	if (nmemo.gt.0) memo=.true.
c
c	Do checking now
c	---------------
c
	if (nfor .gt.1.or.
     1      nscop.gt.1.or.
     1      nfiel.gt.1.or.
     1      nfrom.gt.1.or.
     1      nto  .gt.1.or.
     1      nisdf.gt.1.or.
     1      nimpi.gt.1.or.
     1      nidbf.gt.1.or.
     1      nosdf.gt.1.or.
     1      nodbf.gt.1.or.
     1      nnew .gt.1.or.
     1      nold .gt.1.or.
     1      nproperty.gt.1.or.
     1      nseries.gt.1.or.
     1      nmemo.gt.1.or.
     1      nnorec.gt.1.or.
     1      nimpo.gt.1   ) then
	   goto 90013				!duplicate requests on command
	endif
c
	if ((nnew.gt.0.or.nold.gt.0).and.	!NEW or OLD
     1       nosdf.eq.0.and.			!and no TO SDF found
     1       nodbf.eq.0     ) then		!and no TO DBAG found
	   goto 90022
	endif
c
	if ((nfrom.le.0).and.		!no FROM seen
     1      tofile           ) then		!and TO file.ext
	   goto 90009
	endif
c
	if (frfile.and.tofile) goto 90014	!FROM file.ext TO file.ext
c
	if (nscop.gt.0.or.		!SCOPE or FOR seen
     1      nfor  .gt.0) then
	  if (frfile) goto 90012		!or FROM file.ext
	endif
c
	if (norec) then
	   if (.not.property.and.
	1      .not.series.and.
	1      .not.memo         ) goto 90031	!edit what ?
	endif
c
c	Complete command
c	----------------
c
c	Once completed:	ibase  - input  base channel (ifnam - inp. base name)
c			obase  - output base channel (ofnam - out. base name)
c			ifnam - input base name or
c				 input file.ext with	nisdf > 0 if SDF format
c							nidbf > 0 if DBAG
c							ichan - i/o channel
c			ofnam - output base name or
c				 output file.ext with	nosdf > 0 if SDF format
c							nodbf > 0 if DBAG
c							ochan - i/o channel
c
c
c	From base to base ?
c	-------------------
c
	if (frbase.and.(tobase.or.tobuse)) goto 90028
c
c	SDF format ?
c	------------
c
c	TO <database in use>
c	--------------------
c
	if (tobuse) then
c
	   update=1					!open/update
	   mode=0					!usual mode
	   call i$buse_(obase,update,mode,ofnam,erro)	!ask for cur. out. base
	   if (erro.ne.0) goto 900			!fatal error, carry
	   if (obase.le.0) goto 900			!no base, do nothing
	   call uc_(ofnam)				!upper case name
c
c	   edit from/to creatures as well, so (re)open them all
c
	   call opncrt_(obase,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('E$DIT')			!ignore errors
	      erro=0
	   endif
c
	endif
c
c	TO/FROM <database>
c	------------------
c
	if (tobase.or.tobuse.or.frbase) then
c
	   if (tobase.or.tobuse) then
	      base=obase
	      bnam(1:)=' '
	      bnam=ofnam
	      update=1
	   else
	      base=ibase
	      bnam(1:)=' '
	      bnam=ifnam
	      update=0
	   endif
c
c	   Open <database>
c
	   size=istrip_(bnam)
	   if (size.gt.9) then
	      size=9
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg,10018) bnam(1:size)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!truncated to ...
	         if (erro.ne.0) goto 900			!error, carry
	      endif
	   endif
c
	   mode=0					!usual mode
	   opn=.false.
	   call open_(base,bnam,update,mode,opn,erro)!open database
	   if (erro.ne.0) then
	      if ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.3              ) then	!no such base
	         erro=16				!my own error
	         call errset_('E$DIT',erro)	     	!set it
	         goto 90016
	      elseif ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.9              ) then	!base locked
	         erro=17				!my own error
	         call errset_('E$DIT',erro)	     	!set it
	         goto 90017
	      else
	         goto 95000				!show error
	      endif
	   endif
c
c	   edit from/to creatures as well, so (re)open them all
c
	   call opncrt_(base,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('E$DIT')			!ignore errors
	      erro=0
	   endif
c
	   call zrace_(base,race,irace,idim,isize,ideci,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
c	   If not regular base, switch to owner base
c
	   if (irace.ne.r$b) then			!not a regular base
c
	      prop=base
c
	      bnam=d$ownb(base)
	      mode=0					!usual mode
	      call open_(base,bnam,update,mode,opn,erro)!open database
	      if (erro.ne.0) then
	         if ((d$rsub.eq.'OPNBAS').and.
     1                erro.eq.3              ) then!no such base
	            erro=16				!my own error
	            call errset_('E$DIT',erro)	!set it
	            goto 90016
	         elseif ((d$rsub.eq.'OPNBAS').and.
     1                    erro.eq.9              ) then!base locked
	            erro=17				!my own error
	            call errset_('E$DIT',erro)	!set it
	            goto 90017
	         else
	            goto 95000			!show error
	         endif
	      endif
c
c	      edit from/to creatures as well, so (re)open them all
c
	      call opncrt_(base,update,defprop,defseries,defmemo,erro)
	      if (erro.ne.0) then
	         call errclr_('E$DIT')		!ignore errors
	         erro=0
	      endif
c
	      norec=.true.				!no owner records
c
	      if     (irace.eq.r$pp) then
	         property=.true.
	         series=.false.
	         memo=.false.
	      elseif (irace.eq.r$mm) then
	         property=.false.
	         series=.false.
	         memo=.true.
	      else
	         property=.false.
	         series=.true.
	         memo=.false.
	      endif
c
	      if (tobase.or.tobuse) then
	         ofnam=bnam
	      else
	         ifnam=bnam
	      endif
c
	   endif
c
	endif
c
	if (frbase) then
	   ibase=base
	   inpopn=opn
	else
	   obase=base
	   outopn=opn
	endif
c
c	TO/FROM file.ext
c	----------------
c
	if (tofile.or.frfile) then
c
	   hisext=.false.
	   if (tofile) then
	      if (istrip_(ofext).le.0) then		!no extension
	         if (nosdf.gt.0) then			!and SDF format
	            ofext(1:)='.SDF'			!extension = .SDF
	         else					!DBAG format
	            ofext(1:)='.DBA'			!extension = .DBA
	         endif
	      else
	         hisext=.true.
	      endif
	      call givext_(ofnam,ofext)			!add extension
	      call uc_(ofnam)
	      fnam(1:)=' '
	      fnam=ofnam
	   else
	      if (istrip_(ifext).le.0) then		!no extension
	         if (nisdf.gt.0) then			!and SDF format
	            ifext(1:)='.SDF'			!extension = .SDF
	         else					!DBAG format
	            ifext(1:)='.DBA'			!extension = .DBA
	         endif
	      else
	         hisext=.true.
	      endif
	      call givext_(ifnam,ifext)			!add extension
	      call uc_(ifnam)
	      fnam(1:)=' '
	      fnam=ifnam
	   endif
c
	   if (tofile) then
	      if (fext.ne.'.SDF'.and.
     1            fext.ne.'.DBA'.and.
     1            hisext             ) then
	         call chkext_(fnam,erro)			!check extension
	         if (erro.ne.0) then
	            if (d$itrv.eq.1) then			!interactive
	               call errmsg_('CHKEXT',erro,mssg,'%')
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	               if (erro.ne.0) goto 900		!fatal error, carry
	               call errclr_('E$DIT')		!clear error
	               d$edit=1				!set edit mode
	               mark=0				!...
	            endif
	            goto 900				!and return properly
	         endif
	      endif
	   endif
c
	endif
c
c	Default Fields ..., SCOPE ...
c
	if (frbase) then
	   ibase=base
	   inpopn=opn
	   ifnam(1:)=' '
	   ifnam=fnam
	else
	   obase=base
	   outopn=opn
	   ofnam(1:)=' '
	   ofnam=fnam
	endif
c
c	Fields
c
	if (nfiel.lt.1) then		!no FIELDS,
	   dnfld=d$nfld(base)
	   if (frbase) then
	      fwrite=.false.			!fields are not to be updated
	   else
	      fwrite=.true.			!fields are to be updated
	   endif
	   call i$fakf_(base,'ALL',dnfld,fwrite,
	1               protfail,erro)	!"fake" FLDSYN (ALL field)
	   if (erro.ne.0) goto 900	!error, carry
	endif
c
c	default SCOPE is: CURRENT SEARCH if any;
c			  CURRENT RECORD if any;
c			  ALL records if no otherwise.
c
	if (nscop.le.0) then		!no SCOPE
	   if (bitcan(base).eq.1) then	!and no CURRENT SEARCH
	      cursrc=.false.		!remember CURR. SEARCH not used
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	      if (c$base.eq.base.and.
     1            c$rec.gt.0) then
	         call i$faks_('CUR',0,erro)	!"fake" SCPSYN (CURRENT record)
	         if (erro.ne.0) goto 900	!error, carry
	      else
	         call i$faks_('ALL',0,erro)	!"fake" SCPSYN (ALL records)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
	   else				!use current search
	      cursrc=.true.		!remember CURRENT SEARCH used
	   endif
c
	else				!use SCOPE
	   cursrc=.false.			!remember CURR. SEARCH not used
	endif
c
c	Set base = used one
c
	if (tobase.or.tobuse) then
	   base=obase
	else
	   base=ibase
	endif
c
c	See if current search and not empty
c
	if (cursrc) then
	   rec=0				!don't forget anybody...
	   call bitcnt_(%val(bitpnt(base)),rec,count,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   if (count.le.0) goto 90026		!empty!
	endif
c
c	Use always temporary BIT MAP; if CURRENT SEARCH used, both
c	bits maps should have the same definition (BITOR ...)
c
	if (cursrc) then
	   call bitlim_(%val(bitpnt(base)),izf,izl,erro)!fake zf,zl
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(base,izf,zf,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(base,izl,zl,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (frbase) then
	      call bitmax_(%val(bitpnt(base)),ibmsz,erro)!bitmap size
	      if (erro.ne.0) goto 900			!error, carry
	      call get_vm_(4*ibmsz,ibm,erro)		!ask for room
	      if (erro.ne.0) goto 90025			!no memory!
	      call bitini_(%val(ibm),ibmsz,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call bitor_(%val(ibm),%val(bitpnt(ibase)),erro)
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      call bitmax_(%val(bitpnt(base)),obmsz,erro)!bitmap size
	      if (erro.ne.0) goto 900			!error, carry
	      call get_vm_(4*obmsz,obm,erro)		!ask for room
	      if (erro.ne.0) goto 90025			!no memory!
	      call bitini_(%val(obm),obmsz,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call bitor_(%val(obm),%val(bitpnt(obase)),erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	else
	   zf=d$unus-d$offs(base)+1			!first record#
	   izf=zf
	   call zend_(base,zl,erro)			!and last
	   if (erro.ne.0) goto 900			!error, carry
	   call ex3in_(base,zl,izl,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (frbase) then
	      if (izl.le.0) then
	         ibmsz=8
	      else
	         ibmsz=(izl-izf+1)/32+8			!bit map size
	      endif
	      call get_vm_(4*ibmsz,ibm,erro)		!ask for room
	      if (erro.ne.0) goto 90025			!no memory!
	      call bitini_(%val(ibm),ibmsz,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      if (izl.le.0) then
	         obmsz=8
	      else
	         obmsz=(izl-izf+1)/32+8			!bit map size
	      endif
	      call get_vm_(4*obmsz,obm,erro)		!ask for room
	      if (erro.ne.0) goto 90025			!no memory!
	      call bitini_(%val(obm),obmsz,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	endif
c
c	default FOR (no specific defaults)
c
c	default FIELDS
c
c	complete SCOPE if not CURRENT SEARCH
c
	if (.not.cursrc) then
	   if (frbase) then
	      call scpchk_(base,%val(ibm),
     1                    scpinf,scpsup,alive,topbot,erro)	!check it
	   else
	      call scpchk_(base,%val(obm),
     1                    scpinf,scpsup,alive,topbot,erro)	!check it
	   endif
	   if (topbot) goto 90030	!TOP/BOTTOM adjustment
	   if (erro.ne.0) then
	            mark=0
	            goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	   if (frbase) then
	      call scpsem_(%val(ibm),erro)		!complete scope
	   else
	      call scpsem_(%val(obm),erro)		!complete scope
	   endif
	   if (erro.ne.0) then
	            mark=0
	            goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	endif
c
c	validate SCOPE if FOR not specified and CURRENT SEARCH not used
c
	if (nfor.le.0.and.
     1      .not.cursrc   ) then
	   fall=.true.				!call FORALL later
	endif
c
c	Check/complete FOR
c
	if (nfor.gt.0) then
c
c	allocate temporary space
c
	   fwhtsz=all
	   fwhosz=all
	   call get_vm_(4*fwhtsz,fwht,erro)
	   if (erro.ne.0) goto 90025			!no memory!
	   call get_vm_(4*fwhosz,fwho,erro)
	   if (erro.ne.0) goto 90025			!no memory!
c
c	   Check FOR list validity against data base
c
	   call forchk_(base,all,%val(fwho),%val(fwht),allsiz,erro)
c
c	   if errors in fields, types, etc be nice and give full report
c
	   if (erro.ne.0) then
	      mark=0
	      if (erro.eq.1) then		!type conflict
	        call i$fker_(base,allsiz,%val(fwho),%val(fwht),erro)
	         if (erro.ne.0) goto 900	!error, carry
	         erro=1				!recover error paternity
	         call errset_('FORCHK',erro)	!...
	         mark=0
	         goto 95000			!everybody goes
	      endif
	   endif
	endif
c
c	FOR semantic execution
c
	if (nfor.gt.0) then
	   fsem=.true.				!call FORSEM later
	endif
c
c	Call FORALL/FORSEM if needed
c	----------------------------
c
	if (norec) goto 1122				!skip owner base stuff
c
	if (fall) then
	   if (frbase) then
	      call forall_(ibase,alive,%val(ibm),erro)	!validate bmap
	   else
	      call forall_(obase,alive,%val(obm),erro)	!validate bmap
	   endif
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	endif
c
	if (fsem) then
	   if (frbase) then
	      call forsem_(ibase,alive,%val(ibm),ibmsz,	!obase
     1                     lcpage,%val(fwht),erro)
	   else
	      call forsem_(obase,alive,%val(obm),obmsz,	!ibase
     1                     lcpage,%val(fwht),erro)
	   endif
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!others error
	   endif
	endif
c
1122	continue
c
c	Inform user if interactive
c	--------------------------
c
c	Base just open
c
	if (d$itrv.eq.1) then			!interactive
	   if (outopn) then
	      call i$sopn_(obase,erro)		!be nice...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   if (inpopn) then
	      call i$sopn_(ibase,erro)		!be nice...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
c	   From ... to ...
c
	   if     (frtt) then
c
	      write (mssg,10001) d$unam(obase)	!TO <database>
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	   elseif (frbase.and.
     1             tofile     ) then
c
	      write (mssg,10010) d$unam(ibase)	!FROM <database>
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	      if (new) then
	         newold='NEW'
	      else
	         newold='OLD'
	      endif
c
	      if (nosdf.gt.0) then
	         write (mssg,10014)		!TO SDF file
     1                  ofnam(1:istrip_(ofnam)),newold
	      else
	         write (mssg,10015) 		!TO DBAG file
     1                 ofnam(1:istrip_(ofnam)),newold
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	   elseif (frfile) then
c
	      if (nisdf.gt.0) then
	         write (mssg,10011)		!FROM SDF file
     1                  ifnam(1:istrip_(ifnam))
	      else
	         write (mssg,10012) 		!FROM DBAG file
     1                  ifnam(1:istrip_(ifnam))
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	      write (mssg,10013) d$unam(obase)	!TO <database>
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	   elseif (frbase.and.
     1   	   tobase     ) then		!from data base to data base
c
	      write (mssg,10010) d$unam(ibase)	!FROM <database>
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	      write (mssg,10013) d$unam(obase)	!TO <database>
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   else
	      goto 90023			!forgot something ???
	   endif
c
c	   SCOPE ..., FOR ..., FIELDS ...
c
	   if (frfile) then			!from file
	      if (nfiel.le.0) then
	         write (mssg,10006)		!all fields
	      else
	         write (mssg,10007)		!select. fields
	      endif
	   else
	      if (nscop.le.0.and.		!no SCOPE and
     1            bitcan(base).eq.1.and.	!and no CURRENT SEARCH
     1            nfor.le.0              ) then	!and no FOR ...
	         if (nfiel.le.0) then
	            write (mssg,10002)		!all records, all fields
	         else
	            write (mssg,10003)		!all records, select. fields
	         endif
	      else				!SCOPE or CURRENT SEARCH or FOR
	         if (nfiel.le.0) then
	            write (mssg,10004)		!select. records, all fields
	         else
	            write (mssg,10005)		!select. records, select. fields
	         endif
	      endif
	   endif
c
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
c	   show selected records or just display <waiting...> message
c
	   if     (frfile) then
c
	      call i$wlin_(24,erro)		!<waiting ...> at line 24
	      if (erro.lt.0) then		!command has been aborted
	         erro=0				!clear error
	         goto 900			!return properly
	      endif
	      if (erro.ne.0) goto 900		!error, carry
c
	   else
c
	      if (irace.ne.r$b) then		!not a regular base, just wait
	         call i$wlin_(24,erro)		!wait at line 24
	         cnt=1				!make it work
	      else
	         always=.true.			!always...
	         answer=.true.			!wait for answer
	         if (tobase.or.tobuse) then
	            call i$rsel_(%val(obm),always,answer,cnt,erro)
	         else
	            call i$rsel_(%val(ibm),always,answer,cnt,erro)
	         endif
	      endif
c
	      if (erro.lt.0) then			!command aborted
	         erro=0				!clear error
	         goto 900				!return properly
	      endif
	      if (erro.ne.0) goto 900		!error, carry
c
	      if (cnt.le.0) goto 900		!return if no record selected
c
	   endif
c
	endif
c
c	Execute comand
c	--------------
c
	if     (frtt) then			!to data base
	   goto 610
	elseif (frbase.and.
     1          tofile     ) then		!from data base to file.ext
c
	   if (nosdf.gt.0) then
	      if (d$prt(ibase).ne.0) then	!protection ON
	         do k = 1, d$nfld(ibase)	!see if protected fields
	            if (d$prfl(k,ibase).ne.prtrw) then
	               goto 90029		!sorry, can't use SDF format
	            endif
	         enddo
	      endif
	   endif
c
	   goto 810
c
	elseif (frfile) then			!from file.ext to data base
c
	   if (nisdf.gt.0) then
	      if (d$prt(obase).ne.0) then	!protection ON
	         do k = 1, d$nfld(obase)	!see if protected fields
	            if (d$prfl(k,obase).ne.prtrw) then
	               goto 90029		!sorry, can't use SDF format
	            endif
	         enddo
	      endif
	   endif
c
	   goto 710
c
	elseif (frbase.and.
     1   	tobase     ) then		!from data base to data base
	   goto 750
	else
	   goto 90023				!forgot something ???
	endif
c
c	>>>>>> 1) EDIT TO <database>
c	============================
c
610	continue
c
	call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)!lower/upper record#
	if (erro.ne.0) goto 900			!error, carry
c
c	complete FIELDS
c
	fmsz=all				!field map size
	call get_vm_(4*fmsz,fm,erro)		!ask for room
	if (erro.ne.0) goto 90025		!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90025
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90025
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90025
c
	fwrite=.true.				!fields are to be updated
	call fldsem_(obase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90024		!# ?
c
	idbf=.false.			!not TO file anyway ...
	odbf=.false.			!...
	edt=.true.			!i$edit called
	call i$edit_(frtt,ichan,idbf,ibase,ochan,odbf,obase,
     1               prop,norec,property,series,memo,
     1               %val(obm),%val(fm),count,erro)
	if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	if (erro.eq.5.and.d$rsub.eq.'OPX') goto 95000		!can't open
								!index file
	if (erro.ne.0.and.d$rsub.eq.'I$EDIT') goto 95000	!...
c
	if (erro.ne.0) goto 900		!error, carry
c
	goto 880			!all done
c
c	>>>>>> 2) EDIT FROM <database> TO SDF/DBAG file
c	====================================================
c
810	continue
c
c	Open output <file.ext>
c
c	record size
c
	recsiz=x$rec+10				!max. buffers size
c
	call newc_(ochan)
	if (ochan.le.0) goto 90010			!no more i/o channels
c
	if (nodbf.gt.0) then
	   call f$ohdr_(ochan,ibase,ofnam,newold,recsiz,'DBAG',buf,
     1                  erro)				!DBAG file
	else
	   call f$ohdr_(ochan,ibase,ofnam,newold,recsiz,'SDF',buf,
     1                  erro)				!SDF file
	endif
	if (erro.ne.0) then
	   mark=0
	   goto 95000				!display error
	endif
c
	fmsz=all					!field map size
	call get_vm_(4*fmsz,fm,erro)			!ask for room
	if (erro.ne.0) goto 90025			!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90025
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90025
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90025
c
	fwrite=.false.				!fields are not to be updated
	call fldsem_(ibase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90024		!# ?
c
c	Edit records
c
	if (nidbf.le.0) then
	   idbf=.false.
	else
	   idbf=.true.
	endif
c
	if (nodbf.le.0) then
	   odbf=.false.					!...
	else
	   odbf=.true.
	endif
c
	edt=.true.					!i$edit called
c
	call i$edit_(frtt,ichan,idbf,ibase,ochan,odbf,obase,
     1               prop,norec,property,series,memo,
     1               %val(ibm),%val(fm),count,erro)
	if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	if (erro.ne.0.and.
     1      (d$rsub.eq.'F$ODBF'.or.
     1       d$rsub.eq.'I$EDIT'.or.
     1       d$rsub.eq.'F$OSDF')  ) then
	   mark=0
	   goto 95000					!display error
	endif
c
	if (erro.ne.0) goto 900				!error, carry
c
	goto 880					!all done
c
c	>>>>>> 3) EDIT FROM <file.ext> TO <database> command
c	====================================================
c
710	continue
c
	call bitlim_(%val(bitpnt(obase)),bitinf,bitsup,erro)!lower/upper record#
	if (erro.ne.0) goto 900				!error, carry
c
c	complete FIELDS
c
	fmsz=all					!field map size
	call get_vm_(4*fmsz,fm,erro)			!ask for room
	if (erro.ne.0) goto 90025			!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90025
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90025
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90025
c
	fwrite=.true.				!fields are to be updated
	call fldsem_(obase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90020		!same field twice ???
	if (prefix) goto 90024		!# ?
c
c	Open input <file.ext>
c
	call newc_(ichan)
	if (ichan.le.0) goto 90010			!no more i/o channels
c
	if (nidbf.gt.0) then
	   www(1:)=' '
	   www='DBAG'
	   call f$ihdr_(ichan,ifnam,www,cmmd,basenm,when,usrnam,where,
	1               erro)
	   if (erro.ne.0) goto 95000			!go display error
	   if (www(1:4).ne.'DBAG'.and.			!bad format
	1      www(1:9).ne.'DELIMITED') goto 90021	!make it COMPATIBLE!!!
	else
	   www(1:)=' '
	   www='SDF'
	   call f$ihdr_(ichan,ifnam,www,cmmd,basenm,when,usrnam,where,
	1               erro)
	   if (erro.ne.0) goto 95000			!go display error
	   if (www(1:3).ne.'   ') goto 90021		!bad format
	endif
c
c	Edit records
c
	if (nidbf.le.0) then
	   idbf=.false.
	else
	   idbf=.true.
	endif
c
	if (nodbf.le.0) then
	   odbf=.false.
	else
	   odbf=.true.
	endif
c
	edt=.true.			!i$edit called
c
	call i$edit_(frtt,ichan,idbf,ibase,ochan,odbf,obase,
     1               prop,norec,property,series,memo,
     1               %val(ibm),%val(fm),count,erro)
	if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	if (erro.ne.0.and.
     1      (d$rsub.eq.'F$IDBF'.or.
     1       d$rsub.eq.'F$ISDF'.or.
     1       d$rsub.eq.'I$EDIT')   ) then
	   mark=0
	   goto 95000					!display error
	endif
c
	if (erro.ne.0) goto 900				!error, carry
c
	goto 880					!all done
c
c	>>>>>> 4) EDIT FROM <database> TO <database>
c	============================================
c
750	continue
c
	goto 90028
c
c	All done here
c	-------------
c
880	continue
c
	goto 900
c
c
c	           R   E   T   U   R   N
c	=======================================================
c	Deallocate any memory space, free any allocated channel
c	and return to main loop
c	=======================================================
c
900	continue
c
	if (edt) then				!i$edit called,
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	endif
c
c	Free temporary memory space
c
	call free_vm_(4*ibmsz,ibm,noerr)
	call free_vm_(4*obmsz,obm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
c
	if (ochan.gt.0) then
	   close (ochan)
	   call freec_(ochan)				!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier,integer, or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword, integer or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword or SCOPE called twice
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	TO file.ext seen and no FROM <database>
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	no more i/o channels
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	Database or file.ext expected after FROM/TO
90011	continue
	mark=p1
	erro=11
	goto 99000			!display error and return properly
c	SCOPE or FOR found, and FROM <file.ext>
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	Duplicate requests on command
90013	continue
	mark=0
	erro=13
	goto 99000			!display error and return properly
c	Edit FROM file.ext TO file.ext
90014	continue
	mark=0
	erro=14
	goto 99000			!display error and return properly
c	Input spec = output spec
90015	continue
	mark=0
	erro=15
	goto 99000			!display error and return properly
c	Database doesn't exist
90016	continue
	mark=0
	erro=16
	goto 99000			!display error and return properly
c	Database locked by another user
90017	continue
	mark=0
	erro=17
	goto 99000			!display error and return properly
c	*** obsolete *** Input database doesn't exist
90018	continue
	mark=0
	erro=18
	goto 99000			!display error and return properly
c	*** obsolete *** Input database locked by another user
90019	continue
	mark=0
	erro=19
	goto 99000			!display error and return properly
c	Found repeated reference to same field in FIELDS <list>
90020	continue
	mark=0
	erro=20
	goto 99000			!display error and return properly
c	Input file format isn't the standard (DBAG or SDF)
90021	continue
	mark=0
	erro=21
	goto 99000			!display error and return properly
c	NEW or OLD seen without TO <file.ext> option
90022	continue
	erro=22
	goto 99000			!display error and return properly
c	Should never happen!!!
90023	continue
	erro=23
	goto 99000			!display error and return properly
c	"#" if <fields list>
90024	continue
	erro=24
	goto 99000			!display error and return properly
c	memory (get_vm_) failure
90025	continue
	erro=25
	goto 99000			!display error and return properly
c	current search empty
90026	continue
	erro=26
	goto 99000			!display error and return properly
c	*** obsolete *** SDF file format not supported
90027	continue
	erro=27
	goto 99000			!display error and return properly
c	edit from base to base not supported
90028	continue
	erro=28
	goto 99000			!display error and return properly
c	protected fields, can't use SDF format
90029	continue
	erro=29
	goto 99000			!display error and return properly
c	TOP/BOTTOM adjustment
90030	continue
	erro=30
	goto 99000			!display error and return properly
c	NORECORDS, specify PROPERTY keyword
90031	continue
	erro=31
	goto 99000			!display error and return properly
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
c
	if (edt) then				!i$edit called,
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('E$DIT',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('E$DIT',erro)		!set global error
	endif
c
	call free_vm_(4*ibmsz,ibm,noerr)
	call free_vm_(4*obmsz,obm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
c
	if (ochan.gt.0) then
	   close (ochan)
	   call freec_(ochan)				!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
95000	continue
c
	if (edt) then				!i$edit called,
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	call free_vm_(4*ibmsz,ibm,noerr)
	call free_vm_(4*obmsz,obm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
c
	if (ochan.gt.0) then
	   close (ochan)
	   call freec_(ochan)				!release channel
	   ochan=0
	endif
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:edit.fmt'
c
	end
c
c
c
c
	subroutine E$XIT_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements EXIT/QUIT commands.
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer type,val,dec,lim,p1,p2,erro
	real rval
c
c	>>>>>> Execute command
c	======================
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90001		!eol expected
c
	call b$ye_				!not hard
c
	return
c
c	Warnings
c	========
c
c	eol expected
90001	continue
	erro=1
	mark=p1
	goto 99000
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('E$XIT',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('E$XIT',erro)		!set global error
	endif
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine F$IND_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine G$OTO_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements GO or GOTO command:
c
c	This command positions to a specific record or place in the database
c	in use.
c
c	GO or GOTO [RECORD <n>],
c		   [<n>]       ,
c		   [TOP/BOTTOM]
c
c	var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagB.OWN'
c
	character*12 mybuf
	integer irec,type,p1,p2,val,dec,lim,erro,
     1   	recnum,base,update,mode,alive
	real rval
	logical top
c
c	begin
c	=====
c
	call errclr_('G$OTO')			!clear errors
c
c	get 1rst token
c	--------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many digits)
	elseif (type.eq.0) then
	   return			!eol, return
	elseif (type.eq.1) then
	   goto 100			!identifier (RECORD, TOP or BOTTOM)
	elseif (type.eq.2) then
	   goto 500			!integer, <n>
	else
	   goto 90002			!syntax error (not integer or keyword)
	endif
c
c	got a keyword, check it
c	-----------------------
c
100	continue
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.recoky) then
	   goto 200			!GOTO RECORD
	elseif (keypos.eq.topky) then
	   top=.true.
	   goto 300			!GOTO TOP/BOTTOM
	elseif (keypos.eq.bottky) then
	   top=.false.
	   goto 300			!GOTO BOTTOM
	else
	   goto 90006			!syntax error (unexpected keyword)
	endif
c
c	GOTO RECORD
c	-----------
c
200	continue
c
c	get <n>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many digits)
	elseif (type.eq.0) then
	   return			!eol, return
	elseif (type.eq.2) then
	   goto 500			!integer, <n>
	else
	   goto 90002			!syntax error (not integer or keyword)
	endif
c
c	GOTO TOP/BOTTOM
c	---------------
c
300	continue
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90009		!eol expected
c
	update=-1				!don't change update
	mode=0					!usual mode
	call i$buse_(base,update,mode,mybuf,erro)	!ask for base in use
	if (erro.ne.0) return			!error, carry
	if (base.eq.0) return			!no base, return
	if (top) then
	   call zfirst_(base,alive,recnum,erro)	!top record#
	else
	   call zlast_(base,alive,recnum,erro)	!bottom record
	endif
	if (erro.ne.0) return			!error, carry
	goto 600				!go execute command GOTO
c
c	Here if <n> or RECORD <n>
c	-------------------------
c
500	continue
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90009		!eol expected
c
	recnum=val
c
	if (recnum.lt.1) return			!return if zero
c
	update=-1				!don't change update
	mode=0					!usual mode
	call i$buse_(base,update,mode,mybuf,erro)!ask for base in use
	if (erro.ne.0) return			!error, carry
	if (base.eq.0) return			!no base, return
c
	goto 600				!go execute GOTO command
c
c	>>>>>>> Check record# and execute command GOTO
c	==============================================
c
c	here with recnum = <record#>
c
600	continue
c
	call ex3in_(base,recnum,irec,erro)	!just check recnum
	if (erro.ne.0) then
	   goto 90008
	endif
c
	call i$goto_(recnum,erro)		!execute it
	if (erro.ne.0) then
	   if (d$rsub.eq.'I$GOTO'.and.			!"acceptable" errors
     1         (erro.eq.1.or.				!empty base
     1          erro.eq.2   )      ) then		!or out of TOP-BOTTOM
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_(d$rsub,erro,mssg,'%')	!get error message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	         if (erro.ne.0) return			!error, carry
	         call errclr_('G$OTO')			!clear error
	         d$edit=1				!set edit mode
	      endif
	      return					!return
	   else
	      return					!error, carry
	   endif
	endif
c
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Syntax errors ...
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!give error message and return
c	illegal type of "token" (not identifier or eol)
90002	continue
	mark=p1
	erro=2
	goto 99000			!give error message and return
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!give error message and return
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!give error message and return
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!give error message and return
c	unexpected keyword
90006	continue
	mark=p1
	erro=6
	goto 99000			!give error message and return
c	too many digits in rec#
90007	continue
	mark=p1
	erro=7
	goto 99000			!give error message and return
c	illegal record# (wrong check digit)
90008	continue
	mark=p1
	erro=8
	goto 99000			!give error message and return
c	eol expected
90009	continue
	mark=p1
	erro=9
	goto 99000			!give error message and return
c	Give error message (?...) and return
c	====================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('G$OTO',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('G$OTO',erro)
	endif
	return					!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine H$ELP_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Calls I$HELP to execute "HELP-LIKE" command.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	character*10 who
	character*60 fname
c
c	begin
c	=====
c
c	Init error
c
	call errclr_('H$ELP')
c
	who(1:)=' '
	who='HELP'		!caller
	fname(1:)=' '
	fname=hlpfil		!file to use
	call i$help_(buf,who,fname,mark)
c
	return
c
	end
c
c
c
c
	subroutine I$NDEX_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements (RE)INDEX command, by calling common procedure I$XNOX
c	(NOINDEX command uses same procedure).
c
c	var
c	===
c
	integer who, erro
c
c	begin
c	=====
c
	call errclr_('I$NDEX')		!error init
c
	who=1				!INDEX calling you...
	call I$XNOX_ (buf,mark,who)	!execute (RE)INDEX/NOINDEX command
c
	return				!return to main loop
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine R$EIND_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements REINDEX command, by calling common procedure I$XNOX
c	(INDEX and NOINDEX commands use same procedure).
c
c	var
c	===
c
	integer who, erro
c
c	begin
c	=====
c
	call errclr_('R$EIND')		!error init
c
	who=2				!INDEX calling you...
	call I$XNOX_ (buf,mark,who)	!execute (RE)INDEX/NOINDEX command
c
	return				!return to main loop
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine U$NLOA_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements UNLOAD command:
c
c	UNLOAD	[ DATABASE <database>]
c
c	        [ TO <file.ext> ]  [ SDF ]
c
c	<file.ext> format is SDF
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,what,recsiz,
     1		size,irec,recnum,noerr,nto,nsdf,ndata,nbase,chn
	integer lim1,nalive,nkill,nbad,ncreat,rec,k,f,l,bmsize,
	1	cnt,okrec,klrec,dig
	real rval
	character*60 bname,fname,ownam
	character*12 fext
	character*3 newold
	logical opn,eof,always,defprop,defmemo,defseries,hisext,answer
	integer irace,idim,isize,ideci,prop,answr,racesz
	character*30 race
c
c	begin
c	=====
c
	call errclr_('U$NLOA')		!error init
c
	nto=0				!#[TO]
	ndata=0				!#[DATABASE]
	nsdf=0				!#[SDF]
	nbase=0				!# data bae names
c
	base=0				!input base channel
	fname(1:)=' '			!output file name
	fext(1:)=' '			!and extension
c
	opn=.false.
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error (neither identifier
					!              or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, go complete/execute UNLOAD command
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   nbase=nbase+1		!try data base name
	   goto 310			!get it
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.dataky) then
	   ndata=ndata+1		!count it
	   nbase=nbase+1		!and base also
	   goto 300			!"eat" [DATABASE] phrase
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 400			!"eat" [TO] phrase
	elseif (keypos.eq.sdfky) then
	   nsdf=nsdf+1			!count it
	   goto 1			!go back
	else
	   goto 90007			!unexpected keyword
	endif
c
c	Here to "eat" [DATABASE ...]
c	----------------------------
c
300	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
	1       type.ne.24    ) then
	   goto 90013			!database name expected
	endif
c
310	continue
c
	bname(1:)=' '
	bname(1:)=buf(p1:p2)		!store database name
	call uc_(bname)			!upper case it
	goto 1				!loop back for more (???)
c
c	Here to "eat" [ TO <file.ext> [SDF]
c	-----------------------------------
c
400	continue
c
c	get <file.ext>
c	--------------
c
c	Look for filespec
c
	fname(1:)=' '
	fext(1:)=' '
	call infspc_(type,what,fname,fext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90009	!file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	goto 1				!go back for more
c
c	>>>>>> Here to check/complete/inform/execute UNLOAD command
c	===========================================================
c
600	continue
c
c	Check command
c	-------------
c
c	Indicators:
c
c	nto			#[TO]
c	nsdf			#[SDF]
c	ndata			#[DATABASE]
c	nbase			# data base names
c
	call uc_(fname)		!...
	call uc_(fext)		!...
c
c	Do checking now
c	---------------
c
	if (nto.gt.1.or.
	1   ndata.gt.1.or.
	1   nbase.gt.1.or.
	1   nsdf.gt.1  ) goto 90010		!duplicate requests
c
c	Complete command
c	----------------
c
c	Once completed:	base  - input  base name
c			fname -  output file.ext
c							chn - i/o channel
c
c	Open <database> if specified
c
	if (nbase.le.0) then
	   update=-1					!don't change update
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	   if (erro.ne.0) goto 900			!error, carry
	   if (base.eq.0) goto 900			!no base, return
	else
	   size=istrip_(bname)
	   if (size.gt.9) then
	      size=9
	      if (d$itrv.eq.1) then			!interactive
	         write (mssg,10004) bname(1:size)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!truncated to ...
	         if (erro.ne.0) goto 900		!error, carry
	      endif
	   endif
c
	   mode=0					!usual mode
	   update=0					!readonly
	   call open_(base,bname,update,mode,opn,erro)!open database
	   if (erro.ne.0) then
	      if ((d$rsub.eq.'OPNBAS').and.
     1                    erro.eq.3              ) then	!no such base
	         goto 90011
	      elseif ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.9              ) then	!base locked
	         goto 90012
	      else
	         goto 95000				!show error
	      endif
	   endif
c
c	   Unload creatures as well, so (re)open them all
c
	   call opncrt_(base,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('U$NLOA')			!ignore errors
	      erro=0
	   endif
c
	endif
c
	call zrec2_(base,okrec,klrec,erro)
	cnt=okrec+klrec
	if (cnt.le.0) goto 90003			!base is empty
c
c	Output file
c
	if (nto.le.0) then
	   fname(1:)=' '
	   fname=d$unam(base)				!default is base name
	endif
c
	hisext=.false.
	if (istrip_(fext).le.0) then			!no extension
	   fext(1:)='.SDF'				!extension = .SDF
	else
	   hisext=.true.
	endif
	call givext_(fname,fext)			!add extension
	call uc_(fname)
c
	if (fext.ne.'.SDF'.and.
     1      hisext             ) then
	   call chkext_(fname,erro)			!check extension
	   if (erro.ne.0) then
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_('CHKEXT',erro,mssg,'%')
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!fatal error, carry
	         call errclr_('U$NLOA')			!clear error
	         d$edit=1				!set edit mode
	         mark=0					!...
	      endif
	      goto 900					!and return properly
	   endif
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   do k = 1, d$nfld(base)		!see if protected fields
	      if (d$prfl(k,base).eq.prtno) then
	         goto 90015			!sorry, can't unload
	      endif
	   enddo
	endif
c
	call zrace_(base,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
	racesz=istrip_(race)
	if (racesz.le.0) racesz=1
c
c	All records
c
	if (irace.eq.r$b) then			!regular base
	   call i$faks_('ALL',0,erro)		!"fake" SCPSYN (ALL records)
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
	if (d$itrv.eq.1) then				!interactive
c
	   if (opn) then				!base just opened
	      call i$sopn_(base,erro)			!be nice...
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   From ... to ...
c
	   write (mssg,10002) race(1:racesz),d$unam(base)!FROM <database>
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   lim1=istrip_(fname)
	   if (lim1.le.0) lim1=1
	   write (mssg,10003) fname(1:lim1)		!TO SDF file
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   if (irace.eq.r$b) then			!regular base
	      write (mssg,10001)			!all records, all fields
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   Confirm
c
	   if (irace.ne.r$b) then		!not a regular base, just wait
	      call i$wlin_(24,erro)		!wait at line 24
	   else
	      dig=ndigi_(cnt)
	      call wrivar_(mssg(lim1:),cnt,dig,erro)
	      if (erro.ne.0) goto 90014			!write error
	      write (mssg(lim1+dig:),10005)
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!inform user
	      if (erro.ne.0) return			!error, carry
	      call i$wlin_(24,erro)			!wait at line 24
	   endif
	   if (erro.lt.0) goto 900			!aborted by user
	   if (erro.ne.0) return			!error, carry
c
	endif
c
c	>>>>>> Execute UNLOAD command
c	=============================
c
c	Open output <file.ext>
c
c	record size
c
	recsiz=x$rec+50				!max. buffers size
	newold='NEW'
c
	call newc_(chn)
	if (chn.le.0) goto 90008		!no more i/o channels
c
	call f$ohdr_(chn,base,fname,newold,recsiz,'SDF',buf,erro)!SDF file
	if (erro.ne.0) then
	   mark=0
	   goto 95000				!display error
	endif
c
c	Unload data
c
	if (irace.eq.r$b) then
c
c	   Regular base, unload records
c
	   call i$unlo_(base,chn,nalive,nkill,nbad,erro)
	   if (erro.ne.0) then				!display error
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_(d$rsub,erro,mssg,'?')	!get message
	         call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
	   endif
c
	   if (d$itrv.eq.1) then			!interactive
c
	      write (mssg,10006) nalive +		!total unloaded
	1                        nkill + nbad
	      call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	      write (mssg,10007) nalive		!alive
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	      write (mssg,10008) nkill		!killed
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	      write (mssg,10009) nbad		!with problems
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	   endif
c
c	   Unload creatures if there
c
	   if (defprop) then				!properties
	      do k = 1, d$nfld(base)
	         if (d$type(k,base).eq.p$) then
	            prop=d$dbio(k,base)
	            if (prop.gt.0) then
	               if (d$itrv.eq.1) then		!interactive
	                  lim1=istrip_(d$fnam(k,base))
	                  if (lim1.le.0) lim1=1
100	                  continue
	                  write (mssg,10010) d$fnam(k,base)(1:lim1)!unl. prop. ?
	                  call i$mess_(mark,d$cmdo,1,mssg,0,erro)
	                  if (erro.ne.0) goto 900		!error, carry
	                  call i$yn_(answr,erro)		!accept y/n
	                  if (erro.ne.0) then
	                     call errmsg_(d$rsub,erro,mssg,'%')!get message
	                     call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                     call errclr_('U$NLOA')	!clear error
	                     erro=0
	                     goto 100			!loop back
	                  endif
	               else
	                  answr=1			!"y"
	               endif
	               if (answr.eq.3.or.		!^Z, !
	1                  answr.eq.4    ) goto 100
	               if (answr.eq.2) then
c	                  "N", don't
	               else
	                  call i$uncr_(base,prop,chn,irace,ncreat,erro)
	                  if (erro.ne.0) then		!display error
	                     if (d$itrv.eq.1) then	!interactive
	                        call errmsg_(d$rsub,erro,mssg,'?')!get message
	                        call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	                        if (erro.ne.0) goto 900	!error, carry
	                     endif
	                  endif
	                  if (d$itrv.eq.1) then		!interactive
	                     write (mssg,10013) ncreat
	                     call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                  endif
	               endif
	            endif
	         endif
	      enddo
	   endif
c
	   if (defseries) then				!series
c

c
	   endif
c
	   if (defmemo) then				!memos
c

c
	   endif
c

c
	else
c
c	   Unload creature
c
	   update=-1					!open creature
	   mode=0
	   call opnaln_(prop,bname,update,erro)
	   if (erro.ne.0) goto 95000			!show error (???)
c
	   update=-1					!open owner base
	   mode=0					!usual mode
	   ownam=d$ownb(prop)
	   call open_(base,ownam,update,mode,opn,erro)	!open database
	   if (erro.ne.0) then
	      goto 90016				!no owner base
	   endif
c
	   call i$uncr_(base,prop,chn,irace,ncreat,erro)!unload creature now
	   if (erro.ne.0) then				!display error
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_(d$rsub,erro,mssg,'?')	!get message
	         call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      endif
	   endif
c
	endif
c
	goto 900				!return
c
c
c	           R   E   T   U   R   N
c	=======================================================
c	Deallocate any memory space, free any allocated channel
c	and return to main loop
c	=======================================================
c
900	continue
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)				!release channel
	   chn=0
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90006
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	Data base is empty
90003	continue
	mark=0
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	too many digits
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	unexpected keyword
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	no more i/o channels
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	File.ext expected
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	Duplicate requests on command
90010	continue
	mark=0
	erro=10
	goto 99000			!display error and return properly
c	Database doesn't exist
90011	continue
	mark=0
	erro=11
	goto 99000			!display error and return properly
c	Database locked by another user
90012	continue
	mark=0
	erro=12
	goto 99000			!display error and return properly
c	Data base name expected
90013	continue
	mark=p1
	erro=13
	goto 99000			!display error and return properly
c	?Write error
90014	continue
	mark=0
	erro=14
	goto 99000			!display error and return properly
c	Protected fields, can't unload
90015	continue
	mark=0
	erro=15
	goto 99000			!display error and return properly
c	Can't open owner base, can't unload
90016	continue
	mark=0
	erro=16
	goto 99000			!display error and return properly
c
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('U$NLOA',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('U$NLOA',erro)		!set global error
	endif
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)				!release channel
	   chn=0
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)				!release channel
	   chn=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:unload.fmt'
c
	end
c
c
c
c
	subroutine J$OIN_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	This procedure implements JOIN command:
c
c	JOIN		[DATABASE] <database1> SCOPE..., FOR..., FIELDS...
c
c		WITH	[DATABASE] <database2> SCOPE..., FOR..., FIELDS...
c
c		TO	[DATABASE] <database3> [JFOR... ]
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
	integer nwith,ndatab,nto,nscope,nfor,njfor,nfield,width,line
	integer base,baserr,b0,base1,base2,base3,tmpchn,cnt1,cnt2,rec,bmsize
	integer all,allsiz,bmsz1,bm1,bmsz2,bm2,bmsz3,bm3
	integer fmsz1,fm1,is1,fmsz2,fm2,is2
	integer pm1,pmsz1,sm1,smsz1,mm1,mmsz1
	integer pm2,pmsz2,sm2,smsz2,mm2,mmsz2
	integer fwosz1,fwho1,fwtsz1,fwht1,fwosz2,fwho2,fwtsz2,fwht2
	integer fwosz3,fwho3,fwtsz3,fwht3
	integer ibsz,ib,ifsz,if
	character*10 bname,bname1,bname2,bname3
	integer update,mode,erro,interr,type,lim,p1,p2,val,dec,noerr
	integer k,lim1,f1,nf1,f2,nf2,f3,dnfld,pos1,pos2,pos3,size,pp1,pp2
	integer answr,alive,zf,izf,zl,izl,topr,
     1          irec1,rec1,irec2,rec2,rec3,nrec,nrec2,k3,l,fmax,fidx
	real rval
	logical prefix,twice,cursr1,cursr2,scpinf,scpsup,inuse,eol,new,full
	logical tmpfil,eos1,eos2,allrec,outok,lintru,fwrite1,fwrite2,
	1	protfail1,protfail2,topbot,reset,outopn
	character*60 fname
	character*12 rectxt
	character*10 fmnem
c
c	begin
c	=====
c
	call errclr_('J$OIN')		!clear errors
	erro=0
c
	base=0
	base1=0
	base2=0
	base3=0
c
	all=d$f+2
	bmsz1=0
	bmsz2=0
	bmsz3=0
	fmsz1=0
	pmsz1=0
	smsz1=0
	mmsz1=0
	fmsz2=0
	pmsz2=0
	smsz2=0
	mmsz2=0
	fwtsz1=0
	fwtsz2=0
	fwtsz3=0
	fwosz1=0
	fwosz2=0
	fwosz3=0
c
	ndatab=0
	nwith=0
	nto=0
	nscope=0
	nfield=0
	nfor=0
	njfor=0
c
	outok=.false.			!output data base doesn't exist yet
	tmpfil=.false.			!no tmp file
	eol=.false.
c
	call ttwdth_(width)		!terminal width
	line=0
c
c	Allocate temporary space for field transfer arrays
c	--------------------------------------------------
c
	ibsz=all					!input base
	ifsz=all					!input field#
c
	call get_vm_(4*ibsz,ib,erro)
	if (erro.ne.0) goto 90018			!no memory!
	call get_vm_(4*ifsz,if,erro)
	if (erro.ne.0) goto 90018			!no memory!
c
c	Get first token
c	---------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1   	type.ne.24    ) then
	   goto 90003			!keyword or data base name expected
	endif
c
c	Loop here to process next [WITH/TO] [DATABASE] ...
c	--------------------------------------------------
c
1	continue
c
	if     (type.eq.0) then
	   eol=.true.
	   goto 3			!eol, complete/execute command
	elseif (type.eq.2) then
	   if (ndatab.ge.3) goto 90015	!not for output data base
	   nscope=nscope+1		!count it
	   if (nscope.gt.1) goto 90006	!duplicated keyword
	   goto 220			!integer, "eat" SCOPE
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.le.0) then
	   goto 200			!<database>
	elseif (keypos.eq.dataky) then
	   if (ndatab.gt.0) goto 90008	!missing TO or WITH keyword
	   goto 150			!DATABASE ...
	elseif (keypos.eq.withky) then
	   if (ndatab.ne.1) goto 90007	!unexpected TO or WITH
	   nwith=nwith+1		!count it
	   if (nwith.gt.1) goto 90006	!duplicated keyword
	   goto 100			!WITH/TO ...
	elseif (keypos.eq.toky) then
	   if (ndatab.ne.2) goto 90007	!unexpected TO or WITH
	   nto=nto+1			!count it
	   if (nto.gt.1) goto 90006	!duplicated keyword
	   goto 100			!WITH/TO ...
	elseif (keypos.eq.scopky)  then
	   if (ndatab.ge.3) goto 90015	!not for output data base
	   nscope=nscope+1		!count it
	   if (nscope.gt.1) goto 90006	!duplicated keyword
	   goto 210			!"eat" [SCOPE...]
	elseif (keypos.eq.forky)  then
	   if (ndatab.ge.3) goto 90015	!not for output data base
	   nfor=nfor+1			!count it
	   if (nfor.gt.1) goto 90006	!duplicated keyword
	   goto 230			!"eat" [FOR <exp list>]
	elseif (keypos.eq.fielky) then
	   if (ndatab.ge.3) goto 90015	!not for output data base
	   nfield=nfield+1		!count it
	   if (nfield.gt.1) goto 90006	!duplicated keyword
	   goto 240			!"eat" [FIELDS <field list>]
	elseif (keypos.eq.jforky) then
	   if (ndatab.ne.3) goto 90012	!not for input data base
	   njfor=njfor+1		!count it
	   if (njfor.gt.1) goto 90006	!duplicated keyword
	   goto 300			!"eat" [JFOR ...]
	else
	   nscope=nscope+1		!count it
	   goto 220			!other keyword, try SCOPE
	endif
c
c	WITH/TO ...
c	--------
c
100	continue
c
c	next token
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1   	type.ne.24    ) then
	   goto 90003			!keyword or data base name expected
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.le.0) then
	   goto 200			!<database>
	elseif (keypos.eq.dataky) then
	   goto 150			!DATABASE ...
	else
	   goto 90004			!unexpected keyword
	endif
c
c	DATABASE ...
c	------------
c
150	continue
c
c	next token
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1   	type.ne.24    ) then
	   goto 90003			!keyword or data base name expected
	else
	   goto 200			!<database>
	endif
c
c	<database> ...
c
200	continue
c
	ndatab=ndatab+1
	if (ndatab.gt.3) goto 90005	!too many data bases
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10012) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
c
	bname(1:)=' '
	bname=buf(p1:p1+size-1)			!store data base name
c
c	Check data base: first or second, should exist; third, shouldn't
c	----------------------------------------------------------------
c
	baserr=0			!for error message
	mode=0
	update=-1
	call open_(base,bname,update,mode,outopn,erro)!open database
c
	if (erro.eq.0) then			!base already exists
	   if (ndatab.eq.1.or.
     1         ndatab.eq.2    ) then
	      if (ndatab.eq.1) then
	         base1=base
	         bname1(1:)=' '
	         bname1=bname
	      else
	         base2=base
	         bname2(1:)=' '
	         bname2=bname
	      endif
c
	   else
	      goto 90009			!output data base already exists
	   endif
	else					!can't open base
	   if     ((ndatab.eq.1.or.
     1             ndatab.eq.2     ).and.
     1             (d$rsub.eq.'OPNBAS'.and.
     1             erro.eq.3             ) ) then
	      goto 90010			!input data base doesn't exist
	   elseif (ndatab.eq.3.and.
     1             d$rsub.eq.'OPNBAS'.and.
     1             erro.eq.3            ) then
	      call errclr_('J$OIN')		!ok, clear error
	      bname3(1:)=' '
	      bname3=bname
	   else
	      goto 95001			!show error
	   endif
	endif
c
c	Reserve base channel if third base
c	----------------------------------
c
	if (ndatab.eq.3) then
	   call newbas_(base3,bname,inuse)
	   if (inuse) goto 90013		!can't be in memory
	   if (base3.le.0) goto 90024		!no more space
	   d$unam(base3)(1:)=' '
	   d$unam(base3)=bname			!for error messages
	endif
c
c	next token
c	----------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if  (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	goto 3				!complete previuos <database>
c
c	SCOPE ...
c	---------
c
210	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
220	continue
c
c	Avoid loops due to implicit call to SCPSYN with non-scope keyword
c	-----------------------------------------------------------------
c
	if    (nscope.gt.1) goto 90014	!unexpected keyword
c
c	submit SCOPE syntactical analysis
c	---------------------------------
c
	baserr=base
	erro=0				!only my own error messages
	call scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95001	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from SCOPE expression with next token
c	------------------------------------------
c
	goto 1				!go back for more
c
c	FOR ...
c	-------
c
230	continue
c
c	submit FOR syntactical analysis
c	-------------------------------
c
	baserr=base			!for error message
	erro=0				!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95001	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from FOR expression with next token
c	----------------------------------------
c
	goto 1				!go back for more
c
c	FIELDS ...
c	----------
c
240	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	baserr=base			!for error message
	erro=0				!only my own error messages
	reset=.true.			!reset field map always
	call fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95001	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from FIELDS expression with next token
c	-------------------------------------------
c
	goto 1				!go back for more
c
c	JFOR ...
c	--------
c
300	continue
c
c	submit JFOR syntactical analysis (identical to FOR)
c	---------------------------------------------------
c
	erro=0	   			!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	        mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	      erro=interr
	      goto 90000
	endif
c
	if (erro.ne.0) goto 95001	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from JFOR expression with next token
c	-----------------------------------------
c
	if (type.ne.0) goto 90016	!end-of-line expected
	eol=.true.			!remember eol seen
c
c	check JFOR
c
c	allocate temporary space
c
c	check FOR list validity against data base
c
	call jfrchk_(base1,base2,all,%val(fwho1),%val(fwht1),allsiz,
     1               baserr,erro)
c
c	if errors in fields, types, etc be nice and give full report
c
	if (erro.ne.0) then
	   mark=0
	   if (erro.eq.1) then			!type conflicts
	      call i$fker_(baserr,allsiz,%val(fwho1),%val(fwht1),erro)
	      if (erro.ne.0) goto 900		!error, carry
	      erro=1				!recover error paternity
	      call errset_('FORCHK',erro)		!...
	      goto 95001		!display others error, return any
					!memory space, set edit mode and return
	   endif
	endif
c
	goto 3				!complete JOIN command
c
c	Complete command
c	================
c
3	continue
c
	if     (eol) then
	   goto 500			!execute JOIN command
c
	elseif (ndatab.eq.2) then	!======================================
c
c	   Base 1
c	   ======
c
c	   Default scope
c
c	   CURRENT SEARCH if any; if no curr. search, ALL records
c
	   baserr=base1				!for error message
	   if (nscope.le.0) then		!no SCOPE
	      if (bitcan(base1).eq.1) then	!and no CURRENT SEARCH
	         cursr1=.false.			!remember CURR. SEARCH not used
	         call i$faks_('ALL',0,erro)	!"fake" SCPSYN (ALL records)
	         if (erro.ne.0) goto 900	!error, carry
	      else				!use current search
	         cursr1=.true.			!remember CURRENT SEARCH used
	      endif
	   else					!use SCOPE
	      cursr1=.false.			!remember CURR. SEARCH not used
	   endif
c
c	   Use always temporary BIT MAP; if CURRENT SEARCH used, both
c	   bits maps should have the same definition.
c
	   if (cursr1) then
	      call bitlim_(%val(bitpnt(base1)),izf,izl,erro)!fake zf,zl
	      if (erro.ne.0) goto 900			!error, carry
	      call in3ex_(base1,izf,zf,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call in3ex_(base1,izl,zl,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call bitmax_(%val(bitpnt(base1)),bmsz1,erro)!bitmap size
	      if (erro.ne.0) goto 900			!error, carry
	      call get_vm_(4*bmsz1,bm1,erro)		!ask for room
	      if (erro.ne.0) goto 90018			!no memory!
	      call bitini_(%val(bm1),bmsz1,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call bitcpy_(%val(bitpnt(base1)),%val(bm1),erro)
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      zf=d$unus-d$offs(base1)+1			!first record#
	      izf=zf
	      call zend_(base1,zl,erro)			!and last
	      if (erro.ne.0) goto 900			!error, carry
	      call ex3in_(base1,zl,izl,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      if (izl.le.0) then
	         bmsz1=8
	      else
	         bmsz1=(izl-izf+1)/32+8			!bit map size
	      endif
	      call get_vm_(4*bmsz1,bm1,erro)		!ask for room
	      if (erro.ne.0) goto 90018			!no memory!
	      call bitini_(%val(bm1),bmsz1,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   default FIELDS
c
	   if (nfield.lt.1) then			!no FIELDS,
	      dnfld=d$nfld(base1)
	      fwrite1=.false.			!fields are not to be updated
	      call i$fakf_(base1,'ALL',dnfld,fwrite1,protfail1,
	1                  erro)			!"fake" FLDSYN
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   complete SCOPE if not CURRENT SEARCH
c
	   if (.not.cursr1) then
	      call scpchk_(base1,%val(bm1),
     1                    scpinf,scpsup,alive,topbot,erro)	!check it
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!display others error, return any
					!memory space, set edit mode and return
	      endif
	      if (topbot) goto 90025	!TOP/BOTTOM adjustment
	      call scpsem_(%val(bm1),erro)		!complete scope
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!display others error, return any
					!memory space, set edit mode and return
	      endif
	   endif
c
c	   complete FIELDS
c
	   fmsz1=all
	   call get_vm_(4*fmsz1,fm1,erro)		!ask for room
	   if (erro.ne.0) goto 90018			!no memory!
c
	   pmsz1=all				!properties
	   call get_vm_(4*pmsz1,pm1,erro)
	   if (erro.ne.0) goto 90018
c
	   smsz1=all				!series
	   call get_vm_(4*smsz1,sm1,erro)
	   if (erro.ne.0) goto 90018
c
	   mmsz1=all				!memos
	   call get_vm_(4*mmsz1,mm1,erro)
	   if (erro.ne.0) goto 90018
c
	   fwrite1=.false.			!fields are not to be updated
	   call fldsem_(base1,%val(fm1),%val(pm1),%val(sm1),%val(mm1),
	1               prefix,twice,fwrite1,protfail1,erro)!check/compl. fields
c
	   if (erro.ne.0) then
	      mark=0
	      goto 95001		!display others error, return any
					!memory space, set edit mode and return
	   endif
	   if (prefix) goto 90017	!# ?
c
	   is1=c$fn
c
c	   Set field transfer arrays for base 1
c
	   nf1=0
	   f3=0
c
c	   Fields from base 1
c
	   do 1001 k = 1, is1
c
	      call outk_(%val(fm1),k,f1)		!read field map
	      if (f1.gt.0) then				!ignore 0 (record#)
	         nf1=nf1+1				!count field
	         f3=f3+1				!...
	         call ink_(%val(ib),f3,base1)		!input base
	         call ink_(%val(if),f3,f1)		!input field
	      endif
c
1001	   continue
c
c	   check/complete FOR
c
c	   allocate temporary space
c
	   fwtsz1=all
	   fwosz1=all
	   call get_vm_(4*fwtsz1,fwht1,erro)
	   if (erro.ne.0) goto 90018			!no memory!
	   call get_vm_(4*fwosz1,fwho1,erro)
	   if (erro.ne.0) goto 90018			!no memory!
c
	   if (nfor.gt.0) then
c
c	      check FOR list validity against data base
c
	      call forchk_(base1,all,%val(fwho1),%val(fwht1),allsiz,erro)
c
c	      if errors in fields, types, etc be nice and give full report
c
	      if (erro.ne.0) then
	         mark=0
	         if (erro.eq.1) then			!type conflicts
	            call i$fker_(base1,allsiz,%val(fwho1),%val(fwht1),erro)
	            if (erro.ne.0) goto 900		!error, carry
	            erro=1				!recover error paternity
	            call errset_('FORCHK',erro)		!...
	            goto 95001		!display others error, return any
					!memory space, set edit mode and return
	         endif
	      endif
	   endif
c
c	   validate SCOPE if FOR not specified and CURRENT SEARCH not used
c
	   if (nfor.le.0.and.
     1         .not.cursr1  ) then
	      call forall_(base1,alive,%val(bm1),erro)	!validate bit map
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!display others error, return any
					!memory space, set edit mode and return
	      endif
	   endif
c
c	   FOR semantic execution
c
	   if (nfor.gt.0) then
	      call forsem_(base1,alive,%val(bm1),bmsz1,
     1                     page,%val(fwht1),erro)
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!others error
	      endif
	   endif
c
	elseif (ndatab.eq.3) then	!=======================================
c
c	   Base 2
c	   ======
c
c	   Default scope
c
c	   CURRENT SEARCH if any; if no curr. search, ALL records
c
	   baserr=base2				!for error message
	   if (nscope.le.0) then		!no SCOPE
	      if (bitcan(base2).eq.1) then	!and no CURRENT SEARCH
	         cursr2=.false.			!remember CURR. SEARCH not used
	         call i$faks_('ALL',0,erro)	!"fake" SCPSYN (ALL records)
	         if (erro.ne.0) goto 900	!error, carry
	      else				!use current search
	         cursr2=.true.			!remember CURRENT SEARCH used
	      endif
	   else					!use SCOPE
	      cursr2=.false.			!remember CURR. SEARCH not used
	   endif
c
c	   Use always temporary BIT MAP; if CURRENT SEARCH used, both
c	   bits maps should have the same definition.
c
	   if (cursr2) then
	      call bitlim_(%val(bitpnt(base2)),izf,izl,erro)!fake zf,zl
	      if (erro.ne.0) goto 900			!error, carry
	      call in3ex_(base2,izf,zf,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call in3ex_(base2,izl,zl,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call bitmax_(%val(bitpnt(base2)),bmsz2,erro)!bitmap size
	      if (erro.ne.0) goto 900			!error, carry
	      call get_vm_(4*bmsz2,bm2,erro)		!ask for room
	      if (erro.ne.0) goto 90018			!no memory!
	      call bitini_(%val(bm2),bmsz2,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      call bitcpy_(%val(bitpnt(base2)),%val(bm2),erro)
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      zf=d$unus-d$offs(base2)+1			!first record#
	      izf=zf
	      call zend_(base2,zl,erro)			!and last
	      if (erro.ne.0) goto 900			!error, carry
	      call ex3in_(base2,zl,izl,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      if (izl.le.0) then
	         bmsz2=8
	      else
	         bmsz2=(izl-izf+1)/32+8			!bit map size
	      endif
	      call get_vm_(4*bmsz2,bm2,erro)		!ask for room
	      if (erro.ne.0) goto 90018			!no memory!
	      call bitini_(%val(bm2),bmsz2,izf,topr,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   default FIELDS
c
	   if (nfield.lt.1) then			!no FIELDS,
	      dnfld=d$nfld(base2)
	      fwrite2=.false.			!fields are not to be updated
	      call i$fakf_(base2,'ALL',dnfld,fwrite2,protfail2,
	1                  erro)			!"fake" FLDSYN
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   complete SCOPE if not CURRENT SEARCH
c
	   if (.not.cursr2) then
	      call scpchk_(base2,%val(bm2),
     1                    scpinf,scpsup,alive,topbot,erro)	!check it
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!display others error, return any
					!memory space, set edit mode and return
	      endif
	      if (topbot) goto 90025	!TOP/BOTTOM adjustment
	      call scpsem_(%val(bm2),erro)		!complete scope
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!display others error, return any
					!memory space, set edit mode and return
	      endif
	   endif
c
c	   complete FIELDS
c
	   fmsz2=all
	   call get_vm_(4*fmsz2,fm2,erro)		!ask for room
	   if (erro.ne.0) goto 90018			!no memory!
c
	   pmsz2=all				!properties
	   call get_vm_(4*pmsz2,pm2,erro)
	   if (erro.ne.0) goto 90018
c
	   smsz2=all				!series
	   call get_vm_(4*smsz2,sm2,erro)
	   if (erro.ne.0) goto 90018
c
	   mmsz2=all				!memos
	   call get_vm_(4*mmsz2,mm2,erro)
	   if (erro.ne.0) goto 90018
c
	   fwrite2=.false.			!fields are not to be updated
	   call fldsem_(base2,%val(fm2),%val(pm2),%val(sm2),%val(mm2),
	1               prefix,twice,fwrite2,protfail2,erro)!check/compl. fields
c
	   if (erro.ne.0) then
	      mark=0
	      goto 95001		!display others error, return any
					!memory space, set edit mode and return
	   endif
	   if (prefix) goto 90017	!# ?
c
	   is2=c$fn
c
c	   Set field transfer arrays for base 2
c
	   do 1002 k = 1, is2
c
	      call outk_(%val(fm2),k,f2)		!read field map
	      if (f2.gt.0) then				!ignore 0 (record#)
	         nf2=nf2+1				!count field
	         f3=f3+1				!...
	         call ink_(%val(ib),f3,base2)		!input base
	         call ink_(%val(if),f3,f2)		!input field
	      endif
c
1002	   continue
c
c	   allocate temporary space
c
	   fwtsz2=all
	   fwosz2=all
	   call get_vm_(4*fwtsz2,fwht2,erro)
	   if (erro.ne.0) goto 90018			!no memory!
	   call get_vm_(4*fwosz2,fwho2,erro)
	   if (erro.ne.0) goto 90018			!no memory!
c
c	   check/complete FOR
c
	   if (nfor.gt.0) then
c
c	      check FOR list validity against data base
c
	      call forchk_(base2,all,%val(fwho2),%val(fwht2),allsiz,erro)
c
c	      if error give full report
c
	      if (erro.ne.0) then
	         mark=0
	         if (erro.eq.1) then			!type conflicts
	            call i$fker_(base2,allsiz,%val(fwho2),%val(fwht2),erro)
	            if (erro.ne.0) goto 900		!error, carry
	            erro=1				!recover error paternity
	            call errset_('FORCHK',erro)		!...
	            goto 95001		!display others error, return any
					!memory space, set edit mode and return
	         endif
	      endif
	   endif
c
c	   validate SCOPE if FOR not specified and CURRENT SEARCH not used
c
	   if (nfor.le.0.and.
     1         .not.cursr2  ) then
	      call forall_(base2,alive,%val(bm2),erro)	!validate bit map
	      if (erro.ne.0) then
	         mark=0
	         goto 95001		!display others error, return any
					!memory space, set edit mode and return
	      endif
	   endif
c
c	   FOR semantic execution
c
	   if (nfor.gt.0) then
	      call forsem_(base2,alive,%val(bm2),bmsz2,
     1                     page2,%val(fwht2),erro)
	      if (erro.ne.0) then
	         mark=0
	         goto 95001				!others error
	      endif
	   endif
c
	endif
c
	nscope=0			!clear counters
	nfor=0
	nfield=0
c
	goto 1				!go back for more
c
c	>>>>>> Execute JOIN command (eol seen)
c	======================================
c
500	continue
c
c	Last check: WITH and TO seen ?
c	------------------------------
c
	if (nwith.le.0.or.
     1      nto.le.0      ) goto 90008			!missing TO or WITH
c
c	Inform user about pre-selected records and fields
c	-------------------------------------------------
c
c	Base1
c
	rec=0						!don't forget anybody...
	call bitcnt_(%val(bm1),rec,cnt1,erro)		!count records
	if (erro.ne.0) goto 900				!error, carry
c
	nf1=0						!count fields
	do 1003 k = 1, is1
	   call outk_(%val(fm1),k,f1)			!read field map
	   if (f1.gt.0) then				!ignore 0 (record#)
	      nf1=nf1+1
	   endif
1003	continue
c
	mssg(1:)=' '
	if (cnt1.le.0) then
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10001) bname1(1:istrip_(bname1))
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!inform user
	      if (erro.ne.0) goto 900			!error, carry
	   else					!non-interactive
	      baserr=base1
	      goto 90023
	   endif
	   goto 900					!abort command anyway
	else
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10002) bname1,cnt1,nf1
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!inform user
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	endif
c
c	Base2
c
	rec=0						!don't forget anybody...
	call bitcnt_(%val(bm2),rec,cnt2,erro)		!count records
	if (erro.ne.0) goto 900				!error, carry
c
	nf2=0						!count fields
	do 1004 k = 1, is2
	   call outk_(%val(fm2),k,f2)			!read field map
	   if (f2.gt.0) then				!ignore 0 (record#)
	      nf2=nf2+1
	   endif
1004	continue
c
	mssg(1:)=' '
	if (cnt2.le.0) then
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10001) bname2(1:istrip_(bname2))!no record selected
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!inform user
	      if (erro.ne.0) goto 900			!error, carry
	   else					!non-interactive
	      baserr=base2
	      goto 90023
	   endif
	   goto 900					!abort command anyway
	else
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10002) bname2,cnt2,nf2
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!inform user
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	endif
c
c	If JFOR not specified, ask user to confirm (crossing all records
c	from both bases...)
c	----------------------------------------------------------------
c
	if (njfor.le.0) then
c
c	   please confirm...
c
	   nrec2=cnt1*cnt2				!# of new records
c
	   if (s$set(s$conf)) then
c
	      write (mssg(1:),10004)			!no JFOR specified
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      write (mssg(1:),10005)			!...
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      lim1=ndigi_(nrec2)
	      call wrivar_(rectxt,nrec2,lim1,erro)
	      if (erro.ne.0) goto 90022			!write error
	      write (mssg(1:),10006) rectxt(1:lim1)	!...
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
530	      continue
c
	      write (mssg(1:),10007)			!confirm (y/n)
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
	      call i$yn_(answr,erro)			!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         call errclr_('J$OIN')			!clear error
	         goto 530				!loop back
	      endif
c
	   else						!blind guy
c
	      answr=1					!proceed ...
c
	   endif
c
	   if (answr.eq.5) goto 530			!'??????', loop back
	   if (answr.eq.4) goto 530			!comm.
	   if (answr.eq.3) goto 530			!^Z
	   if (answr.eq.2) then
	      if (.not.outok) call frebas_(base3)
	      goto 900					!'N', return
	   endif
c
c	   1 = 'Y', ok
c
	   allrec=.true.			!all records
c
	else
c
	   allrec=.false.			!don't consider all records
c
c	   JFOR semantic execution
c	   -----------------------
c
c	   base1,base2	- input data base
c
	   tmpfil=.true.		!temp file will be created
	   baserr=base3			!for error messages
	   call jfrsem_(base1,alive,%val(bm1),bmsz1,page,
     1                  %val(fwht1),base2,alive,%val(bm2),
     1                  bmsz2,page2,%val(fwht2),nrec,fname,
     1                  erro)
c
	   if (erro.ne.0) then
	      mark=0
	      goto 95001				!others error
	   endif
c
c	   Any records joined ?
c	   --------------------
c
	   if (nrec.le.0.and.
     1         .not.allrec   ) goto 90019		!none
c
	endif
c
c	Inform user about new data base and confirm
c	-------------------------------------------
c
	if (.not.allrec) then
c
	   if (s$set(s$conf)) then
c
	      lim1=ndigi_(nrec)
	      rectxt(1:)=' '
	      call wrivar_(rectxt,nrec,lim1,erro)
	      if (erro.ne.0) goto 90022			!write error
	      write (mssg(1:),10008)
     1               bname3(1:istrip_(bname3)),
     1               rectxt(1:lim1)		!# of new data base rec./all
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
540	      continue
	      write (mssg(1:),10009)			!confirm (y/n)
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
	      call i$yn_(answr,erro)			!accept y/n
	      if (erro.ne.0) goto 900			!error, carry
c
	   else						!blind guy
c
	      answr=1					!proceed ...
c
	   endif
c
	   if (answr.eq.5) goto 540			!'??????', loop back
	   if (answr.eq.4) goto 540			!comment line
	   if (answr.eq.3) goto 540			!^Z
	   if (answr.eq.2) then
	      if (.not.outok) call frebas_(base3)
	      goto 900					!'N', return
	   endif
c
c	   1 = 'Y', ok
c
	endif
c
c	Set new data base memory context
c	--------------------------------
c
	rec1=1						!first rec#=1
	d$offs(base3)=d$unus-rec1+1			!offset
	d$bdes(base3)(1:)=' '				!designation
	d$bdes(base3)(1:)='[JOIN] '			![JOIN] base 1 + base2
	d$bdes(base3)(istrip_(d$bdes(base3))+1:)=d$unam(base1)
	d$bdes(base3)(istrip_(d$bdes(base3))+1:)=' + '
	d$bdes(base3)(istrip_(d$bdes(base3))+2:)=d$unam(base2)
c
	d$dflt(base3)(1:)=' '				!default values
c
	nf1=0
	nf2=0
	f3=0
	pp1=2
c
c	Fields from base 1
c
	do 1005 k = 1, is1
c
	   call outk_(%val(fm1),k,f1)			!read field map
	   if (f1.gt.0) then				!ignore 0 (record#)
	      nf1=nf1+1					!count field
	      f3=f3+1					!...
c
	      d$fmne(f3,base3)=' '
	      d$fmne(f3,base3)=d$fmne(f1,base1)		!field mnemonic
	      d$fdes(f3,base3)=' '
	      d$fdes(f3,base3)=d$fdes(f1,base1)		!field description
	      d$fnam(f3,base3)=' '
	      d$fnam(f3,base3)=d$fnam(f1,base1)		!other d.b. name
c
	      pos1=d$pos(f1,base1)
	      size=d$siz(f1,base1)
	      pos2=pos1+size-1
	      pp2=pp1+size-1
	      d$dflt(base3)(pp1:pp2)=d$dflt(base1)(pos1:pos2)!default value
	      d$pos(f3,base3)=pp1			!current pos
	      pos1=pos2+1				!next pos
	      pp1=pp2+1					!...
c
	      d$siz(f3,base3)=d$siz(f1,base1)
	      d$type(f3,base3)=d$type(f1,base1)
	      d$deci(f3,base3)=d$deci(f1,base1)
	      d$min(f3,base3)=d$min(f1,base1)
	      d$max(f3,base3)=d$max(f1,base1)
	      d$idx(f3,base3)=0				!NO indexed fields
	      d$oblg(f3,base3)=d$oblg(f1,base1)
	      d$see(f3,base3)=d$see(f1,base1)
	      d$mast(f3,base3)=d$mast(f1,base1)
	   endif
c
1005	continue
c
c	Fields from base 2
c
	do 1006 k = 1, is2
c
	   call outk_(%val(fm2),k,f2)			!read field map
	   if (f2.gt.0) then				!ignore 0 (record#)
	      nf2=nf2+1					!count field
	      f3=f3+1					!...
c
	      d$fmne(f3,base3)=' '
	      d$fmne(f3,base3)=d$fmne(f2,base2)		!field mnemonic
	      d$fdes(f3,base3)=' '
	      d$fdes(f3,base3)=d$fdes(f2,base2)		!field description
	      d$fnam(f3,base3)=' '
	      d$fnam(f3,base3)=d$fnam(f2,base2)		!other d.b. name
c
	      pos1=d$pos(f2,base2)
	      size=d$siz(f2,base2)
	      pos2=pos1+size-1
	      pp2=pp1+size-1
	      d$dflt(base3)(pp1:pp2)=d$dflt(base2)(pos1:pos2)!default value
	      d$pos(f3,base3)=pp1			!current pos
	      pos1=pos2+1				!next pos
	      pp1=pp2+1					!...
c
	      d$siz(f3,base3)=d$siz(f2,base2)
	      d$type(f3,base3)=d$type(f2,base2)
	      d$deci(f3,base3)=d$deci(f2,base2)
	      d$min(f3,base3)=d$min(f2,base2)
	      d$max(f3,base3)=d$max(f2,base2)
	      d$idx(f3,base3)=0				!NO indexed fields
	      d$oblg(f3,base3)=d$oblg(f2,base2)
	      d$see(f3,base3)=d$see(f2,base2)
	      d$mast(f3,base3)=d$mast(f2,base2)
	   endif
c
1006	continue
c
	d$nfld(base3)=f3
c
c	Check duplicate field mnemonics
c	-------------------------------
c
350	continue
c
	do k3 = 2, f3
	   fmnem=d$fmne(k3,base3)			!mnemonic
	   fmax=k3-1					!previous fields
	   call chkmne_(fmnem,base3,fmax,fidx,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (fidx.gt.0) then				!already exists
c
360	      continue
	      write (mssg,10015) k3,d$fmne(k3,base3)
	1                        (1:istrip_(d$fmne(k3,base3))),fidx
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      write (mssg,10016)
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)	!prompt for mnemonic
	      if (erro.ne.0) goto 900			!error, carry
	      read (d$cmdi,fmt='(a)',end=360) xbuf1
	      call i$mess_(0,0,-1,xbuf1,-1,erro)
c
	      call rstok_(xbuf1,1,erro)
	      erro=0
	      call intok_(type,val,dec,rval,xbuf1,lim,p1,p2,mssg,erro)
	      if  ((erro.ne.0).or.			!syntax error)
     1             (istrip_(xbuf1(p2+1:)).gt.0).or.	!line not clean
     1             (type.ne.1.and.
     1   	    type.ne.24    ) ) then		!bad mnemonic
	         write (mssg,10014)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         goto 360
	      endif
c
	      l=p2-p1+1
	      if (l.gt.10) then
	         l=10
	         write (mssg,10017) xbuf1(p1:p1+l-1)	!truncated to ...
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
c
	      d$fmne(k3,base3)=xbuf1(p1:p1+l-1)
c
	      goto 350					!start again ...
c
	   endif
	enddo
c
c	Create new data base structure
c	------------------------------
c
	new=.true.
	full=.true.
	call strout_(base3,bname3,new,full,erro)	!create structure
	if (erro.ne.0) goto 900				!error, carry
c
	outok=.true.				!output base created!
c
c	Open output base
c	----------------
c
	baserr=0
	mode=0
	update=1
	call open_(base3,bname3,update,mode,outopn,erro)!open database
	if (erro.ne.0) goto 95001		!show error
c
c	Pretty output
c	-------------
c
	if (d$itrv.eq.1) then			!interactive
	   call vset2_(2)			!clean screen from line 2
	   call vset1_(3,1)			!cursor
	   write (mssg,10010) bname1,
     1                        bname2,
     1                        bname3
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   write (mssg,'(<width+1>(''-''))')
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   call vset3_(6,20)			!set scroll
	endif
c
c	Write new data base records
c	---------------------------
c
c	base1,base2	- input data bases
c	base3		- output data base
c	ib,if		- input base, source field
c	allrec		- if .true., cross all records from both bases
c			- if .false.,cross records in file FNAME
c
	if (allrec) then			!all records from both bases
c
	   irec1=0				!start at the beginning
	   xbuf2(1:1)=' '			!clear mark
c
c	   Loop in all records from base 1
c	   -------------------------------
c
600	   continue
c
	   call bitnxt_(%val(bm1),irec1,eos1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   if (eos1) goto 699			!the end
	   call in3ex_(base1,irec1,rec1,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
	   call find_(base1,rec1,alive,xbuf1,erro)
	   if (erro.ne.0) then
	      if (d$rsub.eq.'FIND'.and.
	1         erro.eq.5 ) goto 600	!killed record, insist
	      goto 900				!error, carry
	   endif
c
c	   Copy fields from base 1
c	   -----------------------
c
	   do 1007 k = 1, f3
	      call outk_(%val(ib),k,b0)
	      if (b0.eq.base1) then
	         call outk_(%val(if),k,f1)
	         pos1=d$pos(f1,base1)
	         pos3=d$pos(k,base3)
	         xbuf2(pos3:)=xbuf1(pos1:pos1+d$siz(f1,base1)-1)
	      endif
1007	   continue
c
	   irec2=0				!start at the beginning
c
c	   Loop in all records from base 2
c	   -------------------------------
c
601	   continue
c
	   call bitnxt_(%val(bm2),irec2,eos2,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   if (eos2) goto 688			!the end
	   call in3ex_(base2,irec2,rec2,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
	   call find_(base2,rec2,alive,xbuf1,erro)
	   if (erro.ne.0) then
	      if (d$rsub.eq.'FIND'.and.
	1         erro.eq.5 ) goto 601	!killed record, insist
	      goto 900				!error, carry
	   endif
c
c	   Copy fields from base 2
c	   ----------------------
c
	   do 1008 k = 1, f3
	      call outk_(%val(ib),k,b0)
	      if (b0.eq.base2) then
	         call outk_(%val(if),k,f2)
	         pos2=d$pos(f2,base2)
	         pos3=d$pos(k,base3)
	         xbuf2(pos3:)=xbuf1(pos2:pos2+d$siz(f2,base2)-1)
	      endif
1008	   continue
c
c	   Append new record to output base
c	   --------------------------------
c
	   erro=-16381744			!don't validate
	   call more_(base3,rec3,xbuf2,erro)
	   if (erro.ne.0) then
	      if (d$rsub.eq.'OPX'.and.
	1         erro.eq.5) goto 95001	!can't open index file
	      goto 900				!error, carry
	   endif
c
c	   Tell him all about
c	   ------------------
c
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10011) rec1,rec2,rec3
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   goto 601
688	   continue				!end of loop in bitmap 1
c						!-----------------------
	   goto 600
699	   continue				!end of loop in bitmap 2
c						!-----------------------
	else
c						!join selected records
c
	   call newc_(tmpchn)			!ask for i/o channel
	   if (tmpchn.le.0) goto 90020		!no more i/o channels
c
	   open (tmpchn,file=fname,status='old',err=90021)
c
	   xbuf2(1:1)=' '			!clear mark
c
700	   continue
c
	      read (tmpchn,'(i10,i10)',end=710,err=90021) rec1,rec2
c
	      call find_(base1,rec1,alive,xbuf1,erro)
	      if (erro.ne.0) goto 900
c
c	      Fields from base 1
c	      ------------------
c
	      do 1009 k = 1, f3
	         call outk_(%val(ib),k,b0)
	         if (b0.eq.base1) then
	            call outk_(%val(if),k,f1)
	            pos1=d$pos(f1,base1)
	            pos3=d$pos(k,base3)
	            xbuf2(pos3:)=xbuf1(pos1:pos1+d$siz(f1,base1)-1)
	         endif
1009	      continue
c
	      call find_(base2,rec2,alive,xbuf1,erro)
	      if (erro.ne.0) goto 900
c
c	      Fields from base 2
c	      ------------------
c
	      do 1010 k = 1, f3
	         call outk_(%val(ib),k,b0)
	         if (b0.eq.base2) then
	            call outk_(%val(if),k,f2)
	            pos2=d$pos(f2,base2)
	            pos3=d$pos(k,base3)
	            xbuf2(pos3:)=xbuf1(pos2:pos2+d$siz(f2,base2)-1)
	         endif
1010	      continue
c
c	      Append new record to output base
c	      --------------------------------
c
	      erro=-16381744			!don't validate
	      call more_(base3,rec3,xbuf2,erro)
	      if (erro.ne.0) then
	         if (d$rsub.eq.'OPX'.and.
	1            erro.eq.5) goto 95001	!can't open index file
	         goto 900				!error, carry
	      endif
c
c	      Tell him all about
c	      ------------------
c
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg,10011) rec1,rec2,rec3
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
	      goto 700				!loop back for more
c
710	   continue
c
	   if (tmpchn.gt.0) then
	      close(unit=tmpchn)
	      call freec_(tmpchn)
	      tmpchn=0
	   endif
c
	endif
c
c	Make output base the current one
c	--------------------------------
c
	call i$scur_(base3,0,0)
c
c	The end
c	-------
c
	goto 900				!return to caller
c
c	Return
c	------
c
900	continue
c
c	Free temporary memory space
c
	call free_vm_(4*bmsz1,bm1,noerr)
	call free_vm_(4*fmsz1,fm1,noerr)
	call free_vm_(4*pmsz1,pm1,noerr)
	call free_vm_(4*smsz1,sm1,noerr)
	call free_vm_(4*mmsz1,mm1,noerr)
	call free_vm_(4*fwtsz1,fwht1,noerr)
	call free_vm_(4*fwosz1,fwho1,noerr)
c
	call free_vm_(4*bmsz2,bm2,noerr)
	call free_vm_(4*fmsz2,fm2,noerr)
	call free_vm_(4*pmsz2,pm2,noerr)
	call free_vm_(4*smsz2,sm2,noerr)
	call free_vm_(4*mmsz2,mm2,noerr)
	call free_vm_(4*fwtsz2,fwht2,noerr)
	call free_vm_(4*fwosz2,fwho2,noerr)
c
	call free_vm_(4*ibsz,ib,noerr)
	call free_vm_(4*ifsz,if,noerr)
c
c	If no output base and error, free base context
c
	if (.not.outok) then
	   if (erro.ne.0) call frebas_(base3)
	endif
c
	if (tmpfil) then
	   open (tmpchn,file=fname,status='old',err=901)
	   close (tmpchn,dispose='delete')
	   tmpchn=0
	endif
901	continue
c
	return
c
c
c	Error
c	=====
c
c	Warnings
c	--------
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90002
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	too many digits
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	keyword or data base name expected
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	unexpected keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too many databases
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	duplicated keyword
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	unexpected TO or WITH keyword
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	missing TO or WITH keyword
90008	continue
	mark=p2
	erro=8
	goto 99000			!display error and return properly
c	output data base already exists
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	input data base doesn't exist
90010	continue
	mark=p1
	erro=10
	goto 99000			!display error and return properly
c	unexpected end-of-line
90011	continue
	mark=p2
	erro=11
	goto 99000			!display error and return properly
c	JFOR specified for input data base
90012	continue
	mark=p1
	erro=12
	goto 99000			!display error and return properly
c	internal error (non-existent base in memory)
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	unexpected keyword (SCOPE called twice ?)
90014	continue
	mark=p1
	erro=14
	goto 99000			!display error and return properly
c	SCOPE, FOR or FIELD specified for output data base
90015	continue
	erro=15
	goto 99000			!display error and return properly
c	end-of-line expected here
90016	continue
	mark=p1
	erro=16
	goto 99000			!display error and return properly
c	# if <fields list>
90017	continue
	erro=17
	goto 99000			!display error and return properly
c	memory (get_vm_) failure
90018	continue
	erro=18
	goto 99000			!display error and return properly
c	no records joined
90019	continue
	erro=19
	goto 99000			!display error and return properly
c	no more i/o channels
90020	continue
	erro=20
	goto 99000			!display error and return properly
c	problems reading temporary file
90021	continue
	erro=21
	goto 99000			!display error and return properly
c	?internal error: read/write error
90022	continue
	erro=22
	goto 99000			!display error and return properly
c	No record selected
90023	continue
	if (baserr.gt.0) then
	   d$rinf(1:5)='base '
	   d$rinf(6:)=d$unam(baserr)
	endif
	erro=23
	goto 99000			!display error and return properly
c	No memory space for new base
90024	continue
	erro=24
	goto 99000			!display error and return properly
c	TOP/BOTTOM adjustment
90025	continue
	erro=25
	goto 99000			!display error and return properly
c
c	Display error message (?...), deallocate space and return
c	=========================================================
99000	continue
c
c	Free temporary memory space
c
	call free_vm_(4*bmsz1,bm1,noerr)
	call free_vm_(4*fmsz1,fm1,noerr)
	call free_vm_(4*pmsz1,pm1,noerr)
	call free_vm_(4*smsz1,sm1,noerr)
	call free_vm_(4*mmsz1,mm1,noerr)
	call free_vm_(4*fwtsz1,fwht1,noerr)
	call free_vm_(4*fwosz1,fwho1,noerr)
c
	call free_vm_(4*bmsz2,bm2,noerr)
	call free_vm_(4*fmsz2,fm2,noerr)
	call free_vm_(4*pmsz2,pm2,noerr)
	call free_vm_(4*smsz2,sm2,noerr)
	call free_vm_(4*mmsz2,mm2,noerr)
	call free_vm_(4*fwtsz2,fwht2,noerr)
	call free_vm_(4*fwosz2,fwho2,noerr)
c
	call free_vm_(4*ibsz,ib,noerr)
	call free_vm_(4*ifsz,if,noerr)
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('J$OIN',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('J$OIN',erro)		!set global error
	endif
c
c	If no output base, free base context
c
	if (.not.outok) call frebas_(base3)
c
	if (tmpfil) then
	   open (tmpchn,file=fname,status='old',err=99001)
	   close (tmpchn,dispose='delete')
	   tmpchn=0
	endif
99001	continue
c
	return
c
c	Display others error message (?...), deallocate space and return
c	================================================================
c	CAUTION: error always refers to BASERR!!!
c
95001	continue
c
c	Free temporary memory space
c
	call free_vm_(4*bmsz1,bm1,noerr)
	call free_vm_(4*fmsz1,fm1,noerr)
	call free_vm_(4*pmsz1,pm1,noerr)
	call free_vm_(4*smsz1,sm1,noerr)
	call free_vm_(4*mmsz1,mm1,noerr)
	call free_vm_(4*fwtsz1,fwht1,noerr)
	call free_vm_(4*fwosz1,fwho1,noerr)
c
	call free_vm_(4*bmsz2,bm2,noerr)
	call free_vm_(4*fmsz2,fm2,noerr)
	call free_vm_(4*pmsz2,pm2,noerr)
	call free_vm_(4*smsz2,sm2,noerr)
	call free_vm_(4*mmsz2,mm2,noerr)
	call free_vm_(4*fwtsz2,fwht2,noerr)
	call free_vm_(4*fwosz2,fwho2,noerr)
c
	call free_vm_(4*ibsz,ib,noerr)
	call free_vm_(4*ifsz,if,noerr)
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   if (baserr.gt.0) then
	      mssg(1:)=' '			!and base name...
	      mssg(2:)='[ base '
	      mssg(istrip_(mssg)+2:)=d$unam(baserr)
	      mssg(istrip_(mssg)+1:)=' ]'
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   endif
	   d$edit=1				!set edit mode
	endif
c
c	If no output base and error, free base context
c
	if (.not.outok) call frebas_(base3)
c
	if (tmpfil) then
	   open (tmpchn,file=fname,status='old',err=95002)
	   close (tmpchn,dispose='delete')
	   tmpchn=0
	endif
95002	continue
c
	return
c
c	Formats
c	=======
c
	include 'fmt:join.fmt'
c
	end
c
c
c
c
	subroutine L$IST_ (buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements LIST command, by calling common procedure I$DL (DISPLAY
c	command uses same procedure).
c
c	var
c	===
c
	integer who, erro
c
c	begin
c	=====
c
	call errclr_('L$IST')		!error init
c
	who=2				!LIST calling you...
	call I$DL_ (buf,mark,who)	!execute LIST command
c
	return				!return to main loop
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine H$OST_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Calls host computer whenever possible.
c	Implemented for VAX/VMS.
c
c	var
c	===
c
c	begin
c	=====
c
	call v$ms_(buf,mark)	!... VAX/VMS
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine M$ODIF_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements MODIFY command:
c
c	****** MODIFY STRUCTURE [TO <database>]
c
c	Modify structure of data base <database> or data base in use if none
c	specified.
c
c	If data base is empty, anything may be modified; if not, only a
c	few characteristics  may be modified  (mainly  descriptions and
c	field  mnemonics).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer update,mode,type,val,dec,lim,p1,p2,erro,noerr,lim1
	integer okrec,klrec,size,bmsize,base,b,prop,k,kkk,berr,ferr
	integer irace,idim,isize,ideci,nfld,answr
	character*40 race
	real rval
	integer nstruc,nto,nprop
	character*12 bname,aliename,mybuf,strname,ownam
	logical opn,edit,new,full,edt,refer,
	1	propseen,serseen,memoseen,pp,ss,mm
c
c	begin
c	=====
c
	call errclr_('M$ODIF')		!error init
	edt=.false.
c
	nstruc=0			!#STRUCTURE
	nto=0				!#[TO]
	nprop=0				!#[PROPERTY]
c
	bname(1:)=' '			!output database name
	base=0				!output database channel
	prop=0				!property
	opn=.false.
	propseen=.false.
	serseen=.false.
	memoseen=.false.
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error: neither identifier or eol
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute MODIFY com.
	endif
c
c	Check keyword
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!unknown keyword
	elseif (keypos.eq.-1) then
	   goto 90004			!ambiguous keyword
	elseif (keypos.eq.-2) then
	   goto 90005			!too few characters
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 100			!"eat" [TO] phrase
	elseif (keypos.eq.struky) then
	   nstruc=nstruc+1		!count it
	   goto 1			!loop for more
	else
	   goto 90008			!unexpected keyword
	endif
c
c	Here to "eat" TO <database>
c	---------------------------
c
100	continue
c
c	get <database> or PROPERTY/SERIES/MEMO <aliename>
c	-------------------------------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90009			!database name expected
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if (creatures.and.
	1   (keypos.eq.propky.or.
	1    keypos.eq.seriky.or.
	1    keypos.eq.memoky    ) ) then
	   nprop=nprop+1
c
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if     (erro.ne.0) then
	      goto 90000		!syntax error (illegal character or
					!too many total digits)
	   elseif (type.ne.1.and.
     1             type.ne.24    ) then
	      goto 90009		!database name expected
	   endif
c
	   size=p2-p1+1
	   if (size.gt.9) then
	      size=9
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg,10003) buf(p1:p1+size-1)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!truncated to ...
	         if (erro.ne.0) return		!error, carry
	      endif
	   endif
	   aliename(1:)=' '
	   aliename(1:)=buf(p1:p1+size-1)
c
	   if (keypos.eq.propky) propseen=.true.
	   if (keypos.eq.seriky) serseen=.true.
	   if (keypos.eq.memoky) memoseen=.true.
c
	   goto 1				!loop back for more
c
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10003) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!truncated to ...
	      if (erro.ne.0) return			!error, carry
	   endif
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)
c
	goto 1						!loop for more
c
c	>>>>>> Here to check/complete/execute MODIFY command
c	====================================================
c
500	continue
c
c	Check command
c	-------------
c
	if (nto   .gt.1.or.
     1      nprop.gt.1.or.
     1      nstruc.gt.1   ) then
	   goto 90010				!duplicate requests on command
	endif
c
	if (nstruc.le.0) then
	   goto 90006				!command is incomplete
	endif
c
c	open base or ask for current base if none specified
c	---------------------------------------------------
c
	if (nto.gt.0) then		!TO <database>/property/series/memo
	   update=1					!open/update
	   mode=0					!usual mode
	   if (propseen.or.
	1      serseen.or.
	1      memoseen    ) then
	      call open_(b,aliename,update,mode,opn,erro)!open database
	   else
	      call open_(b,bname,update,mode,opn,erro)	!open database
	   endif
	   if (erro.ne.0) then
	      goto 95000			!show error
	   endif
c
	   call zrace_(b,race,irace,idim,isize,ideci,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
	   if (propseen.or.
	1      serseen.or.
	1      memoseen    ) then
	      if (propseen.and.irace.ne.r$pp) goto 90013	!not property
	      if (serseen.and.irace.ne.r$pp) goto 90015		!not series
	      if (memoseen.and.irace.ne.r$pp) goto 90016	!not memo
	      prop=b
	   else
	      if (irace.ne.r$b) then
	         if     (irace.eq.r$pp) then
	            propseen=.true.			!a property after all
	         elseif (irace.eq.r$mm) then
	            memoseen=.true.			!a memo after all
	         else
	            serseen=.true.			!a series after all
	         endif
	         prop=b
	         aliename(1:)=' '
	         aliename=bname
	      else
	         base=b
	      endif
	   endif
c
	else
c
	   update=1					!for update
	   mode=0					!usual mode
	   call i$buse_(b,update,mode,mybuf,erro)	!ask for current base
	   if (erro.ne.0) goto 900			!fatal error, carry
	   if (b.eq.0) goto 900				!no current base, return
c
	   call zrace_(b,race,irace,idim,isize,ideci,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
	   if (irace.ne.r$b) then
	      if     (irace.eq.r$pp) then
	         propseen=.true.			!a property after all
	      elseif (irace.eq.r$mm) then
	         memoseen=.true.			!a memo after all
	      else
	         serseen=.true.			!a series after all
	      endif
	      aliename(1:)=' '
	      aliename=mybuf
	      prop=b
	   else
	      bname(1:)=' '
	      bname(1:)=mybuf(1:)		!store bname
	      base=b
	   endif
c
	endif
c
	if (d$prt(b).ne.0) then			!protection ON
	   do k = 1, d$nfld(b)			!see if protected fields
	      if (d$prfl(k,b).ne.prtrw) then
	         goto 90011			!sorry, can't modify structure
	      endif
	   enddo
	endif
c
c	>>>>>> Execute MODIFY command
c	=============================
c
c	Inform user
c
	if (opn) then
	   call i$sopn_(b,erro)				!be nice...
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
c	Used by someone ?
c
	call i$odb_(b,berr,ferr,refer,erro)	!is base used as o.d.b ?
	if (erro.ne.0) return			!error, carry
	if (refer) goto 90012			!can't close base
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) then
	   update=-1
	   mode=0				!usual mode
	   ownam(1:)=' '
	   ownam=d$ownb(prop)
	   call open_(base,ownam,update,mode,opn,erro)!open database
	   if (erro.ne.0) then
	      goto 90014			!can't open owner base
	   endif
c
	endif
c
c	If regular base, get creature names
c
	if (.not.creatures) goto 790		!no creatures allowed
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen    ) goto 790		!no creatures if property
c
790	continue
c
c	Modify structure
c
	call zrec2_(b,okrec,klrec,erro)		!#rec's
	if (erro.ne.0) goto 900			!error, carry
c
	if (okrec.gt.0.or.
	1   klrec.gt.0    ) goto 600		!non-empty base
c
c	Empty base, modify everything
c	-----------------------------
c
ctemp	if (.not.s$set(s$scre)) then	!line mode
c
ctemp	   write (mssg,10002) 			!not implemented
ctemp	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
ctemp	   if (erro.ne.0) return		!error, carry
ctemp	   goto 900				!return
c
ctemp	else				!screen mode
	   edit=.true.				!edit structure
	   new=.false.				!old data base str.
	   full=.true.				!allow full edition
	   if (propseen.or.
	1      serseen.or.
	1      memoseen    ) then
	      strname(1:)=' '
	      strname=aliename
	   else
	      strname(1:)=' '
	      strname=bname
	   endif
	   call stredt_(base,prop,edit,
     1                  strname,new,full,erro)	!screen mode
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.true.
	   if (erro.ne.0) then
	      if (propseen.or.
	1         serseen.or.
	1         memoseen     ) then
	         goto 95000			!show error
	      else
	         if (d$rsub.eq.'STREDT'.and.
	1            erro.eq.8              ) then	!no field specified
c	            ok, maybe only creatures
	         else
	            goto 95000			!show error
	         endif
	      endif
	   endif
c
ctemp	endif
c
	goto 700				!creatures now
c
c	Non-empty base, modify only "textual" characteristics
c	-----------------------------------------------------
c
600	continue
c
ctemp	if (.not.s$set(s$scre)) then	!line mode
ctemp	   write (mssg,10002) 			!not implemented
ctemp	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
ctemp	   if (erro.ne.0) return		!error, carry
ctemp	   goto 900				!just return (for the moment...)
ctemp	else				!screen mode
	   edit=.true.				!edit structure
	   new=.false.				!old data base str.
	   full=.false.				!don't allow full edition
	   if (propseen.or.
	1      serseen.or.
	1      memoseen     ) then
	      strname(1:)=' '
	      strname=aliename
	   else
	      strname(1:)=' '
	      strname=bname
	   endif
	   call stredt_(base,prop,edit,
     1                  strname,new,full,erro)	!screen mode
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.true.
	   if (erro.ne.0) goto 95000		!show error
c
ctemp	endif
c
	goto 700				!creatures now
c
c	Modify names of creatures
c
700	continue
c
	if (.not.creatures) goto 800		!no creatures allowed
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen   ) goto 800		!no creatures if property
c
	write (mssg,10004)			!extensions to basic structure
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) return			!error, carry
c
10	continue
	if (full) then	
	   write (mssg,10005)			!define/change creature names ?
	else
	   write (mssg,10006)
	   pp=.false.				!no property names
	   ss=.false.				!series
	   mm=.false.				!memos
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.p$) pp=.true.
	      if (d$type(k,base).eq.s$) ss=.true.
	      if (d$type(k,base).eq.mm$) mm=.true.
	   enddo
	   if (.not.pp.and.
	1      .not.ss.and.
	1      .not.mm     ) goto 800		!nothing to change
	   if (pp) then
	      mssg(istrip_(mssg)+2:)='properties,'
	   endif
	   if (ss) then
	      mssg(istrip_(mssg)+2:)='series,'
	   endif
	   if (mm) then
	      mssg(istrip_(mssg)+2:)='"memos",'
	   endif
	   lim1=istrip_(mssg)
	   mssg(lim1:lim1)=' '
	   write (mssg(lim1+1:),10007)
	endif
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
	call i$yn_(answr,erro)			!accept y/n
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   call errclr_('M$ODIF')		!clear error
	   erro=0
	   goto 10				!loop back
	endif
c
	if (answr.eq.3.or.answr.eq.4) goto 10	!^Z, comment line
c
	if (answr.eq.1) then
c	    "Y"
c
c	   properties
	   call credt_(base,p$,edit,strname,new,full,erro)
	   if (erro.ne.0) goto 95000		!show error
c
	endif
c
c	   series
	   call credt_(base,s$,edit,strname,new,full,erro)
	   if (erro.ne.0) goto 95000		!show error
c
c	   memos
	   call credt_(base,mm$,edit,strname,new,full,erro)
	   if (erro.ne.0) goto 95000		!show error
c
	goto 800				!output structure
c
c	Output structure
c
800	continue
c
	if (propseen.or.
	1   serseen.or.
	1   memoseen     ) then
	   call strout_(prop,strname,new,full,erro)	!create data base
	else
	   call strout_(base,strname,new,full,erro)	!create data base
	endif
	if (erro.ne.0) goto 95000		!show error
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then				!interactive
	   write (mssg,10001) strname(1:istrip_(strname))	!be nice
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	endif
c
	goto 900						!return
c
c	Return to caller
c
900	continue
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	STRUCTURE not specified in MODIFY command
90006	continue
	mark=0
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	Database name expected after TO
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	Duplicate requests on command
90010	continue
	mark=0
	erro=10
	goto 99000			!display error and return properly
c	Protected fields, can't modify str.
90011	continue
	mark=0
	erro=11
	goto 99000			!display error and return properly
c	field used as o.d.b. by someone, can't modify struture
90012	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(berr)			!tell him witch base
	erro=12
	goto 99000				!display error
c	not a property
90013	continue
	erro=13
	goto 99000				!display error
c	can't open owner base
90014	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=ownam			!tell him witch base
	erro=14
	goto 99000				!display error
c	not a series
90015	continue
	erro=15
	goto 99000				!display error
c	not a memo
90016	continue
	erro=16
	goto 99000				!display error
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('M$ODIF',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('M$ODIF',erro)		!set global error
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
c
95000	continue
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:modify.fmt'
c
	end
c
c
c
c
	subroutine P$ACK_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine R$EAD_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine R$ENAM_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine R$EPLA_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements REPLACE command:
c
c	REPLACE		FROM <file.ext>	[SDF/DBAG]
c				[FIELDS ...]
c			[NOCHECK]
c			[TO  <database>]
c
c	If indexes in use, the index files are automatically updated.
c
c	Default FIELDS is all fields.
c
c	Default <file.ext> format is DBAG (file DBAGF.FOR for details).
c
c	N.B.: If replacing to current data base, last replaced record becomes
c	      current.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external istrip_
	integer istrip_
	integer update,mode,type,val,dec,lim,p1,p2,erro,what,recsiz,
     1   	ichan,obase,irec,recnum,noerr
	integer nfiel,nto,nfrom,nnocheck,nisdf,nidbf,nimpi,line,bmsize,cnt
	integer interr,k,f,l,alive,fm,fmsz,dnfld,all,allsiz
	integer pm,pmsz,sm,smsz,mm,mmsz
	real rval
	character*60 ifnam,ofnam
	character*12 ifext
	character*10 www,cmmd,basenm,when,usrnam,where
	logical twice,eof,eobm,always,found,blnk,trunc,chkinp
	logical idbf,tobase,tobuse,opn,prefix,hisext,fwrite,protfail,reset
c
c	begin
c	=====
c
	call errclr_('R$EPLA')		!error init
c
	fmsz=0			!temporary field map (fm) space size
	pmsz=0			!same for properties
	smsz=0			!same for series
	mmsz=0			!same for memos
	all=d$f+2			!.....size
	idbf=.true.			!.true. se FROM DBAG file
c
	nfiel=0				!#[FIELD ...]
	nfrom=0				!#[FROM]
	nnocheck=0			!#[NOCHECK]
	nto=0				!#[TO]
	nisdf=0				!#[FROM] [SDF]
	nimpi=0				!# implicit [FROM] <file.ext>
	nidbf=0				!#[FROM] [DBAG]
c
	ifnam(1:)=' '			!input databse name/file name
	ifext(1:)=' '			!and extension
	ichan=0				!input file.ext i/o channel
	ofnam(1:)=' '			!output databse name
	obase=0				!output base channel
	reset=.true.			!reset field map
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1.and.
     1   	type.ne.2    ) then
	   goto 90002			!syntax error (neither identifier,
					!              integer, or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, go complete/execute REPLACE comm.
	endif
c
c	Loop here if token is a keyword
c	-------------------------------
c
2	continue
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.fielky) then
	   nfiel=nfiel+1		!count it
	   goto 300			!"eat" [FIELDS <field list>]
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 400			!"eat" [TO] phrase
	elseif (keypos.eq.nochky) then
	   nnocheck=nnocheck+1		!count it
	   goto 1			!go back for more
	elseif (keypos.eq.fromky) then
	   nfrom=nfrom+1		!count it
	   goto 500			!"eat" [FROM] phrase
	else
	   goto 90008			!unexpected keyword
	endif
c
c	Here to "eat" [SCOPE ...]
c	-------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
c	Here to "eat" [FIELDS ...]
c	--------------------------
c
300	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	erro=0				!only my own error messages
	call fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
	reset=.false.			!don't reset anymore
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
	if (erro.ne.0) goto 95000	!display others error, return any
					!memory space, set edit mode and return
c
c	come from FIELDS expression with next token
c	-------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, complete/execute REPLACE command
	else
	   goto 2			!go back for more
	endif
c
c	Here to "eat" [TO] <database>
c	-----------------------------
c
400	continue
c
c	get <database>
c	--------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1          type.ne.24.and.
     1   	type.ne.1    )then
	   goto 90002			!syntax error (neither identifier,
					!              or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, go complete/execute REPLACE comm.
	endif
c
	ofnam(1:)=' '			!store data base name
	ofnam(1:)=buf(p1:p2)
c
	goto 1				!go back for more
c
c	Here to "eat" [FROM] <file.ext> [SDF/DBAG]
c	-----------------------------------------------
c
500	continue
c
c	get <database/file.ext>
c	-----------------------
c
c	Look for filespec
c
	ifnam(1:)=' '
	ifext(1:)=' '
	call infspc_(type,what,ifnam,ifext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90011		!database/file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	nimpi=nimpi+1			!implicit FROM file.ext anyway
c
c	get keyword SDF or DBAG
c	----------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
	if (type.ne.0.and.
     1      type.ne.1    ) goto 90002	!syntax error (not identifier or integ.)
c
	if (type.eq.0) goto 600		!eol, go complete/execute REPLACE comm.
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.sdfky) then
	   nisdf=nisdf+1		!count it
	   goto 1			!next keyword
	elseif (keypos.eq.dbagky) then
	   nidbf=nidbf+1		!count it
	   goto 1			!next keyword
	else
	   goto 2			!keyword found
	endif
c
c	>>>>>> Here to check/complete/inform/execute REPLACE command
c	============================================================
c
600	continue
c
c	Check command
c	-------------
c
c	Indicators:
c
c	nfiel			#[FIELD ...]
c	nfrom			#[FROM]
c	nnocheck		#[NOCHECK]
c	nto			#[TO]
c	nisdf			#[FROM] [SDF]
c	nimpi			# implicit [FROM] <file.ext>
c	nidbf			#[FROM] [DBAG]
c
c	Implicit FROM/TO "file.ext" defaults to DBAG format
c	--------------------------------------------------------
c
	if (nimpi.gt.0.and.		!implicit FROM file.ext
     1      nisdf.eq.0.and.			!and no SDF found
     1      nidbf.eq.0     ) then		!and no DBAG found
	   nidbf=1				!"fake" DBAG found
	endif
c
	tobase=.false.			!TO base
	tobuse=.false.			!TO database in use
c
	if (nto.le.0) then
	   tobuse=.true.
	else
	   tobase=.true.
	endif
c
	call uc_(ifnam)			!upper case all names
	call uc_(ifext)			!...
	call uc_(ofnam)			!...
c
c	Do checking now
c	---------------
c
	if (nfiel .gt.1.or.
     1      nfrom.gt.1.or.
     1      nnocheck.gt.1.or.
     1      nto  .gt.1.or.
     1      nisdf.gt.1.or.
     1      nimpi.gt.1.or.
     1      nidbf.gt.1   ) then
	   goto 90009				!duplicate requests on command
	endif
c
c	Complete command
c	----------------
c
c	Once completed:	obase  - output base channel (ofnam - out. base name)
c			ifnam - input base name or
c				 input file.ext with	nisdf > 0 if SDF format
c							nidbf > 0 if DBAG
c							ichan - i/o channel
c			ofnam - output base name or
c
c
c	TO <database in use>
c	--------------------
c
	if (tobuse) then
c
	   update=1					!open/update
	   mode=0					!usual mode
	   call i$buse_(obase,update,mode,ofnam,erro)	!ask for cur. out. base
	   if (erro.ne.0) goto 900			!fatal error, carry
	   if (obase.le.0) goto 900			!no base, do nothing
	   call uc_(ofnam)				!upper case name
c
	endif
c
c	Open <database>
c
	update=1
	mode=0						!usual mode
	call open_(obase,ofnam,update,mode,opn,erro)!open database
	if (erro.ne.0) then
	   if ((d$rsub.eq.'OPNBAS').and.
     1          erro.eq.3              ) then		!no such base
	      erro=16					!my own error
	      call errset_('R$EPLA',erro)	     	!set it
	      goto 90012
	   elseif ((d$rsub.eq.'OPNBAS').and.
     1              erro.eq.9              ) then	!base locked
	      erro=17					!my own error
	      call errset_('R$EPLA',erro)	     	!set it
	      goto 90013
	   else
	      goto 95000				!show error
	   endif
	endif
c
c	FROM file.ext
c	-------------
c
	hisext=.false.
	if (istrip_(ifext).le.0) then		!no extension
	   if (nisdf.gt.0) then			!and SDF format
	      ifext(1:)='.SDF'			!extension = .SDF
	   else					!DBAG format
	      ifext(1:)='.DBA'			!extension = .DBA
	   endif
	else
	   hisext=.true.
	endif
	call givext_(ifnam,ifext)		!add extension
	call uc_(ifnam)
c
c	Default Fields ..., SCOPE ...
c
c	Fields
c
	if (nfiel.lt.1) then		!no FIELDS,
	   dnfld=d$nfld(obase)
	   fwrite=.true.		!fields are to be updated
	   call i$fakf_(obase,'ALL',dnfld,fwrite,
	1               protfail,erro)	!"fake" FLDSYN (ALL field)
	   if (erro.ne.0) goto 900	!error, carry
	endif
c
c	Inform user
c	-----------
c
	if (d$itrv.eq.1) then			!interactive
c
c	   Base just open
c
	   if (opn) then
	      call i$sopn_(obase,erro)		!be nice...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
c	   FROM ...
c
	   if (nisdf.gt.0) then
	      write (mssg,10001)			!FROM SDF file
     1               ifnam(1:istrip_(ifnam))
	   else
	      write (mssg,10006) 			!FROM DBAG file
     1               ifnam(1:istrip_(ifnam))
	   endif
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   write (mssg,10004) d$unam(obase)	!TO <database>
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
c	   SCOPE ..., FOR ..., FIELDS ...
c
	   if (nfiel.le.0) then
	      write (mssg,10002)		!all fields
	   else
	      write (mssg,10003)		!select. fields
	   endif
c
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
c
c	   show selected records or just display <waiting...> message
c
	   call i$wlin_(24,erro)		!<waiting ...> at line 24
	   if (erro.lt.0) then			!command has been aborted
	      erro=0				!clear error
	      goto 900				!return properly
	   endif
	   if (erro.ne.0) goto 900		!error, carry
c
	endif
c
c	Execute comand
c	--------------
c
	goto 710				!from file.ext to database
c
c
c	>>>>>> 1) REPLACE FROM <file.ext> TO <database> command
c	=======================================================
c
710	continue
c
c	complete FIELDS
c
	fmsz=all					!field map size
	call get_vm_(4*fmsz,fm,erro)			!ask for room
	if (erro.ne.0) goto 90016			!no memory!
c
	pmsz=all				!properties
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90016
c
	smsz=all				!series
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90016
c
	mmsz=all				!memos
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90016
c
	fwrite=.true.				!fields are to be updated
	call fldsem_(obase,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
	if (twice) goto 90014		!same field twice ???
	if (prefix) goto 90017		!# ?
c
c	Open input <file.ext>
c
	call newc_(ichan)
	if (ichan.le.0) goto 90010			!no more i/o channels
c
	if (nidbf.gt.0) then
	   www(1:)=' '
	   www='DBAG'
	   call f$ihdr_(ichan,ifnam,www,cmmd,basenm,when,usrnam,where,
	1               erro)
	   if (erro.ne.0) goto 95000			!go display error
	   if (www(1:4).ne.'DBAG'.and.			!bad format
	1      www(1:9).ne.'DELIMITED') goto 90015	!make it COMPATIBLE!!!
	else
	   www(1:)=' '
	   www='SDF'
	   call f$ihdr_(ichan,ifnam,www,cmmd,basenm,when,usrnam,where,
	1               erro)
	   if (erro.ne.0) goto 95000			!go display error
	   if (www(1:3).ne.'   ') goto 90015		!bad format
	endif
c
c	Replace records
c
	if (nidbf.le.0) then
	   idbf=.false.
	else
	   idbf=.true.
	endif
c
	if (nnocheck.gt.0) then
	   chkinp=.false.			!don't validate input
	else
	   chkinp=.true.			!validate input
	endif
c
c	Replace records
c
	call i$repl_(ichan,idbf,obase,chkinp,
     1               %val(bitpnt(obase)),%val(fm),erro)
	if (erro.eq.1.and.d$rsub.eq.'VLIMIT') goto 95000	!field too big
	if (erro.eq.2.and.d$rsub.eq.'VLIMIT') goto 95000	!set wid 132
	if (erro.eq.5.and.d$rsub.eq.'OPX') goto 95000		!can't open
								!index file
	if (erro.ne.0.and.
     1      (d$rsub.eq.'F$IDBF'.or.
     1       d$rsub.eq.'F$ISDF'.or.
     1       d$rsub.eq.'I$REPL'    )) then
	   mark=0
	   goto 95000					!display error
	endif
c
	if (erro.ne.0) goto 900				!error, carry
c
	goto 880					!all done
c
c	All done here
c	-------------
c
880	continue
c
	goto 900
c
c	           R   E   T   U   R   N
c	=======================================================
c	Deallocate any memory space, free any allocated channel
c	and return to main loop
c	=======================================================
c
900	continue
c
c	Free temporary memory space
c
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
c
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier,integer, or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword, integer or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	Duplicate requests on command
90009	continue
	mark=0
	erro=9
	goto 99000			!display error and return properly
c	no more i/o channels
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	Database or file.ext expected after FROM/TO
90011	continue
	mark=p1
	erro=11
	goto 99000			!display error and return properly
c	Output database doesn't exist
90012	continue
	mark=0
	erro=12
	goto 99000			!display error and return properly
c	Output database locked by another user
90013	continue
	mark=0
	erro=13
	goto 99000			!display error and return properly
c	Found repeated reference to same field in FIELDS <list>
90014	continue
	mark=0
	erro=14
	goto 99000			!display error and return properly
c	Input file format isn't the standard (DBAG or SDF)
90015	continue
	mark=0
	erro=15
	goto 99000			!display error and return properly
c	mamory (get_vm_) failure
90016	continue
	erro=16
	goto 99000			!display error and return properly
c	"#" if <fields list>
90017	continue
	erro=17
	goto 99000			!display error and return properly
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('R$EPLA',erro,mssg,'?')		!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1					!set edit mode
	else
	   call errset_('R$EPLA',erro)
	endif
c
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
c
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')		!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   call free_vm_(4*fmsz,fm,noerr)
	   call free_vm_(4*pmsz,pm,noerr)
	   call free_vm_(4*smsz,sm,noerr)
	   call free_vm_(4*mmsz,mm,noerr)
	endif
c
	if (ichan.gt.0) then
	   close (ichan)
	   call freec_(ichan)				!release channel
	   ichan=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:replac.fmt'
c
	end
c
c
c
c
	subroutine R$EPOR_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine S$EARC_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements SEARCH command:
c
c	*****	SEARCH	[DATABASE <database> ]
c
c			[SCOPE] [<scope list>]
c
c			[FOR <for exp> ]
c
c	No-op if no SCOPE and no FOR specified.
c
c	Search records within SCOPE, that satisfy FOR condition, from
c	DATABASE.
c
c	If no database specified, current database will be used.
c
c	If no SCOPE specified, current SEARCH is used.
c
c	After SEARCH execution, used database becomes current database,
c	and SEARCH selection becomes new database selection.
c
c	CAUTION: As (for the moment...) this procedure is called also from
c	         U$SEAR, it SHOULD make used base the current one...!!!!!!
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagd.own'
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
	integer base,type,val,dec,lim,p1,p2,erro,size,noerr
	integer interr
	real rval
	integer count,nbase,nfor,nscope
	integer what,who
	character*12 mybuf, bname
	integer k,l,scpinf,scpsup,topr,rec,all,allsiz,mode,update,bmsize
	logical always,answer,cursrc,opn,fake,topbot
	integer fwhosz,fwho,fwhtsz,fwht,alive,zf,cnt,dig
c
c	begin
c	=====
c
	call errclr_('S$EARC')		!error init
c
	fwhosz=0		!temporary WHOWHO (fwho) space size
	fwhtsz=0		!temporary WHAT (fwht) space size
c
	nbase=0			!#[DATABASE...]
	nfor=0			!#[FOR ...]
	nscope=0		!#[SCOPE ...]
	bname(1:)=' '		!<database> name
	cursrc=.false.		!assume current search not used
c
c	Loop here to get next keyword or implicit scope
c	-----------------------------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1.and.
     1   	type.ne.2    ) then
	   goto 90002			!syntax error (neither identifier,
					!              integer, or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute SEARCH com.
	elseif (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer or, "eat" SCOPE
	endif
c
c	Loop here if token is a keyword (from SCOPE or FOR)
c	---------------------------------------------------
c
2	continue
c
	if (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer, "eat" SCOPE
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.scopky)  then
	   nscope=nscope+1		!count it
	   goto 100			!"eat" [SCOPE...]
	elseif (keypos.eq.forky)  then
	   nfor=nfor+1			!count it
	   goto 200			!"eat" [FOR <exp list>]
	elseif (keypos.eq.dataky) then
	   nbase=nbase+1		!count it
	   goto 300			!"eat" [DATABASE <database> ]
	else
	   nscope=nscope+1		!count it
	   goto 101			!other keyword, try SCOPE
	endif
c
c	Here to "eat" [SCOPE ...]
c	-------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
101	continue
c
c	Avoid loops due to implicit call to SCPSYN with non-scope keyword
c	-----------------------------------------------------------------
c
	if    (nscope.gt.1) goto 90010	!unexpected keyword
c
c	submit SCOPE syntactical analysis
c	---------------------------------
c
	erro=0				!only my own error messages
	call scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from SCOPE expression with next token
c	------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute SEARCH command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [FOR ...]
c	-----------------------
c
200	continue
c
c	submit FOR syntactical analysis
c	-------------------------------
c
	erro=0				!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from FOR expression with next token
c	----------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute SEARCH command
	else
	   goto 2			!integer or keyword found
	endif
c
c	Here to "eat" [DATABASE...]
c	---------------------------
c
300	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90009			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10005) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!loop back for more
c
c	>>>>>> Here to check/complete/execute SEARCH command
c	----------------------------------------------------
c
500	continue
c
c	Check SEARCH command
c	--------------------
c
c	check duplicate requests in command
c
	if     (nscope.gt.1.or.
     1          nfor  .gt.1.or.
     1          nbase .gt.1   ) then
	   goto 90008				!duplicate requests
	endif
c
c	Check "empty" SEARCH command
c	----------------------------
c
	if (nfor  .le.0       .and.		!no <for>
     1      nscope.le.0            ) then	!and no <scope>
	   goto 90011				!???
	endif
c
c	Complete SEARCH command
c	-----------------------
c
c	Ask for current base if none supplied
c	-------------------------------------
c
	opn=.false.				!first open ?
	if (nbase.gt.0) then			!user supplied database name
	   mode=0
	   update=-1				!don't change update
	   call open_(base,bname,update,mode,opn,erro)!open database
	   if (erro.ne.0) then
	      goto 95000				!show error
	   endif
	else
	   update=-1					!don't change update
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	   if (erro.ne.0) return			!error, carry
	   if (base.eq.0) goto 900			!no base, return
	endif
c
c	Ask for temporary space if FOR used
c	-----------------------------------
c
	if (nfor.gt.0) then
	   all=d$f+2
	   fwhosz=all
	   call get_vm_(4*fwhosz,fwho,erro)		!ask for room
	   if (erro.ne.0) goto 90012			!no memory!
	   fwhtsz=all
	   call get_vm_(4*fwhtsz,fwht,erro)		!............
	   if (erro.ne.0) goto 90012			!no memory!
	endif
c
c	Apply defaults, if any
c	----------------------
c
c	Default SCOPE
c	-------------
c
c	If CURRENT SEARCH = 'none' and no <scope> specified, default is ALL
c	records, otherwise use CURRENT SEARCH
c
	if (nscope.le.0) cursrc=.true.		!use current search if any
c
	if (nscope.le.0.and.
     1      bitcan(base).eq.1) then
	   call i$faks_('ALL',0,erro)		!"fake" SCPSYN (all records)
	   if (erro.ne.0) goto 900
	   cursrc=.false.			!not anymore
	   fake=.true.
	else
	   fake=.false.
	endif
c
c	See if current search and not empty
c
	if (cursrc) then
	   rec=0					!don't forget anybody...
	   call bitcnt_(%val(bitpnt(base)),rec,count,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (count.le.0) goto 90013			!empty!
	endif
c
c	If <scope> specified or "faked", clear SEARCH bitmap if any.
c	Allocate bitmap if no bitmap.
c	------------------------------------------------------------
c
	if (nscope.gt.0.or.
     1      fake           ) then
	   if (bitsiz(base).gt.0) then
	      call bitclr_(%val(bitpnt(base)),erro)		!clear bitmap
	      if (erro.ne.0) goto 900				!error, carry
	   else
	      bmsize=0						!default size
	      call i$bini_(base,bmsize,erro)			!init bitmap
	      if (erro.ne.0) goto 900				!error, carry
	   endif
	endif
c
c	Clear permanent sort, if any
c	----------------------------
c
	if (bitsiz(base).gt.0) then
	   call ordclr_(%val(bitpnt(base)),erro)	!clear structure
	   if (erro.ne.0) goto 900			!error,carry
	endif
c
c	Complete new SCOPE and validate it if no FOR specified (FORSEM not used)
c	------------------------------------------------------------------------
c
	if (nscope.gt.0.or.
     1      fake           ) then
	   call scpchk_(base,%val(bitpnt(base)),scpinf,scpsup,alive,
	1               topbot,erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000			!display other error
	   endif
	   if (topbot) goto 90015		!TOP/BOTTOM adjustment
	endif
c
c	Complete FOR
c	------------
c
	if (nfor.gt.0) then
c
c	   Check FOR list validity against data base
c
	   call forchk_(base,all,%val(fwho),%val(fwht),allsiz,erro)
c
c	   if errors in fields, types, etc be nice and give full report
c
	   if (erro.ne.0) then
	      if (d$itrv.eq.1) then			!interactive
	         mark=0
	         if (erro.eq.1) then			!type conflict errors
	            call i$fker_(base,allsiz,%val(fwho),%val(fwht),erro)
	            if (erro.ne.0) goto 900		!error, carry
	            erro=1				!recover error paternity
	            call errset_('FORCHK',erro)		!...
	         endif
	      endif
	      goto 95000				!everybody goes
	   endif
	endif
c
c	Inform user if first open of database
c	-------------------------------------
c
c	Opn=.true. if first open of base
c
	if (opn) then
	   call i$sopn_(base,erro)			!be nice...
	   if (erro.ne.0) return			!error, carry
	endif
c
c	Validate SCOPE if no FOR specified (FORSEM not used)
c	----------------------------------------------------
c
	if (nscope.gt.0.or.
     1      fake           ) then
	   call scpsem_(%val(bitpnt(base)),erro)	!impose SCOPE
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!display other error
	   endif
	   if (nfor.le.0) then
c
c	      This migth be long...
c
	      if (d$itrv.eq.1) then			!interactive
	         mssg(1:)=' '
	         if (cursrc) then
	            write (mssg(1:),10003)		!Searching (cur.search)
	         else
	            write (mssg(1:),10002)		!Searching...
	         endif
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      endif
c
	      call forall_(base,alive,%val(bitpnt(base)),erro)!validate bit map
	      if (erro.ne.0) return			!error, carry
	   endif
	endif
c
c	FOR semantic execution
c	----------------------
c
	if (nfor.gt.0) then
c
c	   This migth be long...
c
	   if (d$itrv.eq.1) then			!interactive
	      mssg(1:)=' '
	      write (mssg(1:),10002)			!Searching...
	      call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
	   call forsem_(base,alive,%val(bitpnt(base)),bitsiz(base),
     1                 page,%val(fwho),erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!others error
	   endif
	endif
c
c	Inform user about result of search
c	----------------------------------
c
	if (d$itrv.eq.1) then			!interactive
	   rec=0				!start at the beginning...
	   call bitcnt_(%val(bitpnt(base)),rec,cnt,erro)!count selected rec.
	   if (erro.ne.0) goto 900		!error, carry
	   mssg(1:1)=' '
	   lim=2
c
	   dig=ndigi_(cnt)
	   call wrivar_(mssg(lim:),cnt,dig,erro)
	   if (erro.ne.0) goto 90014		!write error
	   write (mssg(lim+dig:),10001)
c
	   call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
c	Set SEARCH as current and show it
c
	bitcan(base)=0
c
	if (opn) then
	   call zfirst_(base,alive,zf,erro)	!TOP record the current rec.
	   if (erro.ne.0) goto 900		!error, carry
	   c$rec=zf
	   c$fld=0
	endif
c
	call i$scur_(base,0,0)			!make base the current one, show
						!current search
c
c	Deallocate temporary spaces and return
c
900	continue
c
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier,integer, or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword, integer or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	database name expected
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	unexpected keyword or SCOPE called twice
90010	continue
	mark=p1
	erro=10
	goto 99000			!display error and return properly
c	SEARCH with no FOR and no SCOPE
90011	continue
	erro=11
	goto 99000			!display error and return properly
c	memory (get_vm_) failure
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	current search is empty
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	internal error: read/write error
90014	continue
	erro=14
	goto 99000			!display error and return properly
c	TOP/BOTTOM adjustment
90015	continue
	erro=15
	goto 99000			!display error and return properly
c	Display my error message (?...) and return, if interactive
c	==========================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('S$EARC',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('S$EARC',erro)		!non-interactive, set global err
	endif
c
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
c
	return
c
c	Display others error message (?...) and return
c	==============================================
95000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
c
	return
c
c	Formats
c	=======
c
	include 'fmt:search.fmt'
c
	end
c
c
c
c
	subroutine S$ELEC_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine S$ET_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements SET command:
c
c	SET PARAMETER ON/OFF		= implemented =
c	set desired parameter on/off.
c
c	SET PARAMETER [TO] <option>	= implemented =
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:vedit.own'
c
	external istrip_,tty_echo_,tty_putc_
	integer istrip_,tty_echo_,tty_putc_
	character*60 fname
	character*12 fext
	character*20 param
	character*3 txt1
	integer errpos, parpos, what
	integer base,update,mode,type,val,dec,lim,p1,pp1,p2,erro,size
	real rval
	logical onoff,to,broad
c
c	begin
c	=====
c
	call errclr_('S$ET')		!error init
c
c	get next parameter
c	------------------
c
10	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.eq.0) then
	   return			!eol, return
	elseif (type.ne.1) then
	   goto 90002			!syntax error (no identifier)
	endif
	param(1:)=' '
	param(1:p2-p1+1)=buf(p1:p2)	!save parameter for later
	parpos=p1			!and start pos for errors
c
c	get ON/OFF/[TO]/VALUE
c	---------------------
c
	pp1=p2+1			!save next p1 for later
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	endif
c
	size=p2-p1+1
c
	if (size.gt.3) then
	   to=.true.			!assume implicit TO
	   call rstok_(buf,pp1,erro)	!reset buffer to proper position
	   if (erro.ne.0) return	!error, carry
	else
c
	   txt1(1:)=' '
	   txt1=buf(p1:p2)
	   call uc_(txt1)		!upper case
	   if     (txt1.eq.'ON'.and.
     1             size.eq.2        ) then
	      to=.false.
	      onoff=.true.		!ON seen
	      goto 100
	   elseif ((txt1.eq.'OF'.and.
     1              size.eq.2        ).or.
     1             txt1.eq.'OFF'          )   then
	      to=.false.
	      onoff=.false.		!OFF seen
	      goto 100
	   elseif ((txt1.eq.'TO'.and.
     1              size.eq.2).or.
     1             (txt1.eq.'='.and.
     1              size.eq.1)       ) then
	      to=.true.			!TO or = seen
	   else
	      to=.true.			!assume implicit TO
	      call rstok_(buf,pp1,erro)	!reset buffer to proper position
	      if (erro.ne.0) return	!error, carry
	   endif
	endif
c
c	check on/off/to parameter (table s$tok)
c	---------------------------------------
c
100	continue
c
	call seetab_(s$tok,s$top,s$pos,param,minchr)
c
	if     (s$pos.eq.0) then
	   errpos=parpos		!parameter start pos
	   goto 90003			!syntax error (unknown keyword)
	elseif (s$pos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (s$pos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	endif
c
c
c	>>>>>>>> Execute command SET PARAMETER ON/OFF/TO
c	================================================
c
	if (to) then
	   goto 200			!SET ... TO
	endif
c
c	SET <parameter> ON/OFF
c	----------------------
c
c	Exceptions:
c		   - check keywords in s$set table that only have TO phrase
c		   - SET ALT ON/OFF (open/close alternate file and inform user)
c		   - SET COLON/BELL/PADDING/INTENSITY ON/OFF (call i$sscr:
c							      reset DBAG editor)
c		   - SET HEADER ON/OFF (reset/clear header line)
c	           - SET TALK OFF (supersede terminal echo as well)
c
c	Keywords with TO phrase only
c	----------------------------
c
c	SET WIDTH to <value>
c	--------------------
c
	if (s$pos.eq.s$widt) then	!SET WIDTH ON/OFF ???
	   goto 90009			!unexpected keyword
	endif
c
c	SET TALK ON/OFF
c	---------------
c
	if (s$pos.eq.s$talk) then	!SET TALK ON/OFF
	   if (onoff) then
	      call tty_echo_(.true.)
	   else
	      call tty_echo_(.false.)
	   endif
	endif
c
c	SET ALTERNATE ON/OFF
c	--------------------
c
	if (s$pos.eq.s$alte) then
	   if (onoff) then			!SET ALT ON
	      if (d$alte.eq.0) then
	         call newc_(d$alte)		!ask for i/o channel
	         if (d$alte.le.0) goto 90008	!no more i/o channels
	      endif
	      open (unit=d$alte,file=altefl,access='append',recl=alteln,
     1              organization='sequential',status='unknown',
     1              carriagecontrol='list',
     1              err=90007)		!open file
	   else					!SET ALT OFF
	      if (d$alte.gt.0) then
	         close(unit=d$alte)			!close channel if open
	      endif
	   endif
	endif
c
c	Set <parameter> ON/OFF
c	----------------------
c
	s$set(s$pos)=onoff
c
c	SET HEADER ON/OFF
c	-----------------
c
	if (s$pos.eq.s$head) then	!SET HEADER ON/OF
	   if (onoff) then
	      call i$scur_(c$base,c$rec,c$fld)	!set current
	   else
	      call erase_line_(1,1)		!clear current
	      call i$scur_(c$base,c$rec,c$fld)	!do other settings...!
	   endif
	endif
c
c	SET COLON/BELL/PADDING/INTENSITY ON/OFF (the VERRRRY LAST code)
c	---------------------------------------------------------------
c
	if (s$pos.eq.s$colo.or.
     1      s$pos.eq.s$bell.or.
     1      s$pos.eq.s$padd.or.
     1      s$pos.eq.s$inte   ) then
	   call i$sscr_(erro)				!(re)set editor
	   if (erro.ne.0) return			!error, carry
	endif
c
	goto 10						!get next parameter
c
c	TO
c	--
c
200	continue
c
c	Here with token after TO
c
	if (s$pos.ne.s$alte) goto 201		!not ALTERNATE, skip this
c
c	SET ALTERNATE TO <file.ext> (default extension = altext (.ALT))
c
c	Look for filespec
c
	fname(1:)=' '
	call infspc_(type,what,fname,fext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90006		!file spec expected
c
	call uc_(fname)
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	if     (what.eq.3) then
	   call givext_(fname,altext)		!default extension
	else
	   call givext_(fname,fext)		!add extension
	   call uc_(fext)
	   if (fext.ne.altext) then
	      call chkext_(fname,erro)		!check extension if not default
	      if (erro.ne.0) then
	         if (d$itrv.eq.1) then		!interactive
	            call errmsg_('CHKEXT',erro,mssg,'%')
	            call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) return	!error, carry
	            call errclr_('S$ET')	!clear error
	            d$edit=1			!set edit mode
	         endif
	         mark=0				!...
	         return				!and return
	      endif
	   endif
	endif
c
	if (d$alte.gt.0) then
	   close(unit=d$alte)			!close channel if open
	else
	   call newc_(d$alte)			!ask for i/o channel
	   if (d$alte.le.0) goto 90008		!no more i/o channels
	endif
c
	open (unit=d$alte,file=fname,access='append',recl=alteln,
     1        organization='sequential',status='unknown',
     1        carriagecontrol='list',
     1        err=90007)			!open file
c
	altefl(1:)=' '				!store alternate file
	altefl(1:)=fname(1:)			!...
c
	if (.not.s$set(s$alte)) then
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10003)		!warn ALTERNATE was OFF...
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   s$set(s$alte)=.true.			!set it ON
	endif
c
	goto 10					!get next parameter
c
201	continue
c
	if (s$pos.ne.s$widt) goto 202	!not WIDTH, skip this
c
c	SET WIDTH TO <value>
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.ne.2) then
	   goto 90010			!value expected
	elseif (val.le.0) then
	   goto 90010			!   "     "
	endif
c
c	Set width = 80 or 132
c
	if (val.gt.80) then
	   val=132				!...
	else
	   val=80
	endif
c
	if (val.ne.widthv) then
c
	   broad=.false.		!no broadcast
	   call i$tset_(val,broad,erro)	!set terminal width (spawn...)
	   if (erro.ne.0) goto 95000	!display error
	   widthv=val			!store current width value
c
	endif
c
	call i$scur_(c$base,c$rec,c$fld)	!show current (new look!)
c
	goto 10					!get next parameter
c
202	continue
c
	if (s$pos.ne.s$colo) goto 203	!not COLON, skip this
c
c	SET COLON TO <'c'>
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90001	!syntax error (illegal character)
c
	if (p1.ne.p2) goto 90013	!only one character between ' '
c
	ending=buf(p1:p2)		!store ending character
	if (.not.s$set(s$colo)) then
	   if (d$itrv.eq.1) then	!interactive
	      write (mssg,10005)		!warn COLON was OFF...
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) return	!error, carry
	   endif
	   s$set(s$colo)=.true.		!set it ON
	endif
	call i$sscr_(erro)		!set editor
	if (erro.ne.0) return		!error, carry
c
	goto 10				!get next parameter
c
203	continue
c
	if (s$pos.ne.s$padd) goto 204	!not PADDING, skip this
c
c	SET PADDING TO <'c'>
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90001	!syntax error (illegal character)
c
	if (p1.ne.p2) goto 90013	!only one character between ' '
c
	paddin=buf(p1:p2)		!store padding character
	if (.not.s$set(s$padd)) then
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10006)		!warn PADDING was OFF...
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   s$set(s$padd)=.true.		!set it ON
	endif
	call i$sscr_(erro)		!set editor
	if (erro.ne.0) return		!error, carry
c
	goto 10				!get next parameter
c
204	continue
c
	if (s$pos.ne.s$prmt) goto 205	!not PROMPT, skip this
c
c	SET PROMPT TO <'string'>
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.ne.5.and.
     1          type.ne.1.and.
     1          type.ne.24   ) then
	   goto 90011			!string or identifier expected
	endif
c
	size=len(d$prmt)-1		!max. prompt size
	if (p2-p1+1.gt.size) then
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10007) buf(p1:p1+size-1)	!truncated
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) return	!error, carry
	   endif
	else
	   size=p2-p1+1
	endif
c
	d$prmt(1:)=' '
	d$prmt=buf(p1:p1+size-1)	!store prompt
	d$prsz=istrip_(d$prmt)+1	!size
c
	goto 10				!get next parameter
c
205	continue
c
	goto 90009			!other [TO] options here!
c
c	Error
c	=====
c
c	Warnings
c	--------
c
90001	continue			!illegal character
	mark=p1
	erro=1
	goto 99000			!display error
90002	continue			!neither identifier nor eol
	mark=p1
	erro=2
	goto 99000			!display error
90003	continue			!unexpected/unknown keyword
	mark=errpos
	erro=3
	goto 99000			!display error
90004	continue			!ambiguous keyword
	mark=p1
	erro=4
	goto 99000			!display error
90005	continue			!too few characters in keyword
	mark=p1
	erro=5
	goto 99000			!display error
90006	continue			!file name expected
	mark=p1
	erro=6
	goto 99000			!display error
90007	continue			!Can't open ALTERNATE file
	erro=7
	goto 99000			!display error
90008	continue			!No more i/o channels available
	erro=8
	goto 99000			!display error
90009	continue			!Unexpected SET ... [TO] phrase
	mark=0
	erro=9
	goto 99000			!display error
90010	continue			!Value expected
	mark=p1
	erro=10
	goto 99000			!display error
90011	continue			!string expected
	mark=p1
	erro=11
	goto 99000			!display error
90012	continue			!keyword or value expected
	mark=p1
	erro=12
	goto 99000			!display error
90013	continue			!string (one character) expected
	mark=p1
	erro=13
	goto 99000			!display error
c	Display error message (?...) and return
c	=======================================
99000	continue
c
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('S$ET',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1			!set edit mode
	else
	   call errset_('S$ET',erro)	!set global error
	endif
c
	return
c
c	Display others error message (?...) and return
c	==============================================
95000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:set.fmt'
c
	end
c
c
c
c
	subroutine S$UM_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine R$ELOA_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c
c	Implements RELOAD command:
c
c	RELOAD	[ TO DATABASE <database>]
c
c		[ NOCHECK ]
c	        [ FROM <file.ext> ]  [ SDF ]
c
c	<file.ext> format is SDF
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,what,recsiz,
     1		size,irec,recnum,noerr,nfrom,nsdf,nto,ndata,nbase,chn,
	1	nnocheck
	integer lim1,nalive,nkill,nbad,nlost,rec,k,f,l,bmsize,cnt,
	1       okrec,klrec
	real rval
	character*60 bname,fname,owname
	character*12 fext
	character*10  www,cmmd,basenm,when,usrnam,where
	logical opn,eof,always,chkinp,hisext,answer
	integer irace,idim,isize,ideci,racesz,bb
	character*30 race
	integer crcount(d$f),dtype
c
c	begin
c	=====
c
	call errclr_('R$ELOA')		!error init
c
	nfrom=0				!#[FROM]
	ndata=0				!#[DATABASE]
	nto=0				!#[TO]
	nsdf=0				!#[SDF]
	nbase=0				!# data base names
	nnocheck=0			!#[NOCHECK]
c
	base=0				!output base channel
	fname(1:)=' '			!input file name
	fext(1:)=' '			!and extension
c
	opn=.false.
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error (neither identifier
					!              or eol)
	elseif (type.eq.0) then
	   goto 600			!eol, go complete/execute RELOAD command
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   nbase=nbase+1		!try data base name
	   goto 310			!get it
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.dataky) then
	   ndata=ndata+1		!count it
	   nbase=nbase+1		!and base also
	   goto 300			!"eat" [DATABASE] phrase
	elseif (keypos.eq.fromky) then
	   nfrom=nfrom+1		!count it
	   goto 400			!"eat" [FROM] phrase
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 200			!"eat" [TO] phrase
	elseif (keypos.eq.sdfky) then
	   nsdf=nsdf+1			!count it
	   goto 1			!go back
	elseif (keypos.eq.nochky) then
	   nnocheck=nnocheck+1		!count it
	   goto 1			!go back
	else
	   goto 90007			!unexpected keyword
	endif
c
c	Here to "eat" [TO DATABASE ...]
c	-------------------------------
c
200	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
	1       type.ne.24    ) then
	   goto 90013			![DATABASE] or database name expected
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   nbase=nbase+1		!try data base name
	   goto 310			!get it
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.dataky) then
	   ndata=ndata+1		!count it
	   nbase=nbase+1		!and base also
	   goto 300			!"eat" [DATABASE] phrase
	else
	   goto 90007			!unexpected keyword
	endif
c
c	Here to "eat" [DATABASE ...]
c	----------------------------
c
300	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
	1       type.ne.24    ) then
	   goto 90013			!database name expected
	endif
c
310	continue
c
	bname(1:)=' '
	bname(1:)=buf(p1:p2)		!store database name
	call uc_(bname)			!upper case it
	goto 1				!loop back for more (???)
c
c	Here to "eat" [ FROM <file.ext> [SDF]
c	-------------------------------------
c
400	continue
c
c	get <file.ext>
c	--------------
c
c	Look for filespec
c
	fname(1:)=' '
	fext(1:)=' '
	call infspc_(type,what,fname,fext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90009	!file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	goto 1				!go back for more
c
c	>>>>>> Here to check/complete/inform/execute RELOAD command
c	===========================================================
c
600	continue
c
c	Check command
c	-------------
c
c	Indicators:
c
c	nfrom			#[FROM]
c	nnocheck		#[NOCHECK]
c	nsdf			#[SDF]
c	ndata			#[DATABASE]
c	nbase			# data base names
c
	call uc_(fname)		!...
	call uc_(fext)		!...
c
c	Do checking now
c	---------------
c
	if (nfrom.gt.1.or.
	1   nnocheck.gt.1.or.
	1   ndata.gt.1.or.
	1   nbase.gt.1.or.
	1   nsdf.gt.1  ) goto 90010		!duplicate requests
c
c	Complete command
c	----------------
c
c	Once completed:	base  - output base name
c			fname -  input file.ext
c							chn - i/o channel
c
c	Open <database> if specified
c
	if (nbase.le.0) then
	   update=1					!for update
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	   if (erro.ne.0) goto 900			!error, carry
	   if (base.eq.0) goto 900			!no base, return
	else
	   size=istrip_(bname)
	   if (size.gt.9) then
	      size=9
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg,10004) bname(1:size)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!truncated to ...
	         if (erro.ne.0) goto 900		!error, carry
	      endif
	   endif
c
	   mode=0					!usual mode
	   update=1					!update
	   call open_(base,bname,update,mode,opn,erro)!open database
	   if (erro.ne.0) then
	      if ((d$rsub.eq.'OPNBAS').and.
     1                    erro.eq.3              ) then	!no such base
	         goto 90011
	      elseif ((d$rsub.eq.'OPNBAS').and.
     1                 erro.eq.9              ) then	!base locked
	         goto 90012
	      else
	         goto 95000				!show error
	      endif
	   endif
c
	endif
c
	call zrec2_(base,okrec,klrec,erro)
	cnt=okrec+klrec
	if (cnt.gt.0) goto 90003			!base is not empty
c
c	Input file
c
	if (nfrom.le.0) then
	   fname(1:)=' '
	   fname=d$unam(base)				!default is base name
	endif
c
	hisext=.false.
	if (istrip_(fext).le.0) then			!no extension
	   fext(1:)='.SDF'				!extension = .SDF
	else
	   hisext=.true.
	endif
	call givext_(fname,fext)			!add extension
	call uc_(fname)
c
	if (fext.ne.'.SDF'.and.
     1      hisext             ) then
	   call chkext_(fname,erro)			!check extension
	   if (erro.ne.0) then
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_('CHKEXT',erro,mssg,'%')
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!fatal error, carry
	         call errclr_('R$ELOA')			!clear error
	         d$edit=1				!set edit mode
	         mark=0					!...
	      endif
	      goto 900					!and return properly
	   endif
	endif
c
c	See protection
c
	if (d$prt(base).ne.0) then		!protection ON
	   do k = 1, d$nfld(base)		!see if protected fields
	      if (d$prfl(k,base).ne.prtrw) then
	         goto 90016			!sorry, can't reload
	      endif
	   enddo
	endif
c
	call zrace_(base,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
	racesz=istrip_(race)
	if (racesz.le.0) racesz=1
c
	if (d$itrv.eq.1) then				!interactive
c
	   if (opn) then				!base just opened
	      call i$sopn_(base,erro)			!be nice...
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   From ... to ...
c
	   write (mssg,10002) race(1:racesz),d$unam(base)!FROM <database>
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   lim1=istrip_(fname)
	   if (lim1.le.0) lim1=1
	   write (mssg,10003) fname(1:lim1)		!TO SDF file
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   if (irace.eq.r$b) then
	      write (mssg,10001)			!all records, all fields
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   Confirm
c
	   call i$wlin_(24,erro)			!wait at line 24
	   if (erro.lt.0) goto 900			!aborted by user
	   if (erro.ne.0) return			!error, carry
c
	endif
c
c	>>>>>> Execute RELOAD command
c	=============================
c
c	Open input <file.ext>
c
	call newc_(chn)
	if (chn.le.0) goto 90008		!no more i/o channels
c
	www(1:)=' '
	www='SDF'
	call f$ihdr_(chn,fname,www,cmmd,basenm,when,usrnam,where,
	1            erro)
	if (erro.ne.0) then
	   mark=0
	   goto 95000				!display error
	endif
	if (www(1:3).ne.'   ') goto 90015	!bad format
c
	if (nnocheck.gt.0) then
	   chkinp=.false.			!don't validate input
	else
	   chkinp=.true.			!validate input
	endif
c
c	Reload records/creatures
c
	call i$relo_(base,irace,chn,chkinp,nalive,nkill,crcount,erro)
	if (erro.ne.0) then				!display error
	   if (d$itrv.eq.1) then			!interactive
	      call errmsg_(d$rsub,erro,mssg,'?')	!get message
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	endif
c
	if (d$itrv.eq.1) then			!interactive
c
	   if (nalive + nkill + nbad.gt.0) then
	      write (mssg,10006) d$unam(base),
	1                        nalive +	!total base records reloaded
	1                        nkill + nbad
	      call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	      write (mssg,10007) nalive		!alive
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	      write (mssg,10008) nkill		!killed
	      call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   if (irace.eq.r$b) then
	      bb=base
	   else
	      owname(1:)=' '
	      owname=d$ownb(base)			!open owner base
	      update=-1					!don't change
	      mode=0					!usual mode
	      call open_(bb,owname,update,mode,opn,erro)!open database
	      if (erro.ne.0) goto 900			!can't ???
	   endif
c
	   do k = 1, d$nfld(bb)
	      dtype=d$type(k,bb)
	      if (crcount(k).gt.0) then		!unloaded
	         if     (dtype.eq.p$) then	!property
	            write (mssg,10009) d$fnam(k,bb),crcount(k)
	         elseif (dtype.eq.s$) then	!series
	            write (mssg,10010) d$fnam(k,bb),crcount(k)
	         elseif (dtype.eq.mm$) then	!memo
	            write (mssg,10011) d$fnam(k,bb),crcount(k)
	         endif
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   enddo
c
	endif
c
	goto 900				!return
c
c
c	           R   E   T   U   R   N
c	=======================================================
c	Deallocate any memory space, free any allocated channel
c	and return to main loop
c	=======================================================
c
900	continue
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)				!release channel
	   chn=0
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90006
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	Data base is not empty
90003	continue
	mark=0
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	too many digits
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	unexpected keyword
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	no more i/o channels
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	File.ext expected
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c	Duplicate requests on command
90010	continue
	mark=0
	erro=10
	goto 99000			!display error and return properly
c	Database doesn't exist
90011	continue
	mark=0
	erro=11
	goto 99000			!display error and return properly
c	Database locked by another user
90012	continue
	mark=0
	erro=12
	goto 99000			!display error and return properly
c	Data base name expected
90013	continue
	mark=p1
	erro=13
	goto 99000			!display error and return properly
c	?Write error
90014	continue
	mark=0
	erro=14
	goto 99000			!display error and return properly
c	Bad SDF file format
90015	continue
	mark=0
	erro=15
	goto 99000			!display error and return properly
c	Protected fields, can't reload
90016	continue
	mark=0
	erro=16
	goto 99000			!display error and return properly
c	Display error message (?...), deallocate any spaces and return
c	==============================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('R$ELOA',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('R$ELOA',erro)		!set global error
	endif
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)				!release channel
	   chn=0
	endif
c
	return
c
c	Display others error message (?...), deallocate any spaces and return
c	=====================================================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)				!release channel
	   chn=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:reload.fmt'
c
	end
c
c
c
c
	subroutine S$ORT_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements SORT [DATABASE <database>] ON <sort list>
c
c	SORT database (current database if not specified) on <sort list>.
c
c		ex:	SORT DATAB XPTO ON NUM A, %3 D, %4 A
c
c		where A: ascending order (default)
c		      B: descending order
c
c			SORT DATABASE XPTO ON NUM, %3 D, %4
c
c	To avoid unwanted sorting and conflicts with DISPLAY command, SORT
c	will work only within current search.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,noerr
	real rval
	integer alive,zf,bmsize,count,rec
	integer k,kcount,size,ndatab,non,fnumb,interr,all,
	1	swm,swmsz,shm,shmsz
	character*12 mybuf,myfnam,bname,fname
	logical always,answer,opn,twice
	integer irace,idim,isize,ideci
	character*30 race
c
c	begin
c	=====
c
	call errclr_('S$ORT')		!error init
c
	swmsz=0			!temporary sort map (swm) space size
	shmsz=0			!temporary how to sort map (shm) space size
	all=d$f+2
	kcount=0		!# of killed records found
c
	ndatab=0
	non=0
	fnumb=0
	fname(1:)=' '
	opn=.false.
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error (neither identifier
					!              or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute command
	endif
c
c	Got a keyword, check it
c	-----------------------
c
2	continue
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.onky)  then
	   non=non+1			!count it
	   goto 100			!"eat" ON <sort list>
	elseif (keypos.eq.dataky)  then
	   ndatab=ndatab+1		!count it
	   goto 200			!"eat" DATABASE <database>
	else
	   non=non+1			!fake ON
	   goto 110			!and try <sort list>
	endif
c
c	Here to "eat" ON <sort list>
c	----------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
c	Here to "eat" <sort list>
c
110	continue
c
	erro=0				!only my own error messages
	call srlsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from SORT ON expression with next token
c	--------------------------------------------
c
	if (type.ne.0.and.
     1   	type.ne.1 ) then
	   goto 90002			!syntax error (neither identifier
					!              or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute command
	else
	   goto 2			!keyword
	endif
c
c	Here to "eat" [DATABASE...]
c	---------------------------
c
200	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90009			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10002) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!loop back for more (???)
c
c	Here to check/complete/execute SORT command
c	-------------------------------------------
c
500	continue
c
c	Check command
c	-------------
c
c	check duplicate requests in command
c
	if (non   .gt.1.or.
     1      ndatab.gt.1   ) then
	   goto 90008				!duplicate requests
	endif
c
c	ON phrase ?
c
	if (non.le.0) goto 90006		!no ON <sort list> phrase
c
c	Ask for current base if none current or none specified
c	------------------------------------------------------
c
	if     (ndatab.gt.0) then
	   mode=0
	   update=-1
	   call open_(base,bname,update,mode,opn,erro)!open database
	   if (erro.ne.0) then
	      goto 95000				!show error
	   endif
	elseif (c$base.le.0) then
	   update=-1
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,mybuf,erro)!ask for current base
	   if (erro.ne.0) goto 900			!error, carry
	   if (base.eq.0) goto 900			!no current base, return
	else
	   base=c$base					!use current base
	endif
c
	call zrace_(base,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (irace.ne.r$b) goto 90015		!not a regular base
c
c	allocate temporary space
c
	swmsz=all
	shmsz=all
	call get_vm_(4*swmsz,swm,erro)			!ask for room
	if (erro.ne.0) goto 90012			!no memory!
	call get_vm_(4*shmsz,shm,erro)			!ask for room
	if (erro.ne.0) goto 90012			!no memory!
c
c	check SORT ON list validity against data base
c
	call srlchk_(base,%val(swm),%val(shm),erro)
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
c
c	See if any current search or empty
c
	if (bitcan(base).eq.1) goto 90011	!no current search
c
	rec=0					!don't forget anybody...
	call bitcnt_(%val(bitpnt(base)),rec,count,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (count.le.0) goto 90013		!empty!
c
c	Inform user
c	-----------
c
	always=.true.				!inform always
	answer=.false.				!no answer
	call i$rsel_(%val(bitpnt(base)),always,answer,count,
     1               erro)			!inform user
	if (erro.lt.0) then
	   erro=0				!abort command
	   goto 900				!return
	endif
c
	if (count.le.0) goto 900		!no record to sort, return
c
c	Execute SORT command
c	--------------------
c
	if (d$itrv.eq.1) then		!interactive
	   write (mssg,10001)			!'sorting...'
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
	call srlsem_(base,%val(bitpnt(base)),%val(swm),%val(shm),
     1               twice,kcount,erro)
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
c
	if (twice) goto 90014		!twice the same field
c
	if (base.eq.c$base) then
	   call i$scur_(c$base,c$rec,c$fld)	!show sorted now
	endif
c
c	Inform user if first open
c
c	opn=.true. if first open of base
c
	if (opn) then
	   call i$sopn_(base,erro)
	   if (erro.ne.0) goto 900	!error, carry
	endif
c
c	Killed records found ?
c
	if (kcount.gt.0) then
	   if (d$itrv.eq.1) then	!interactive
	      write (mssg(1:),10003) kcount
	      call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      if (base.eq.c$base) then
	         call i$scur_(c$base,c$rec,c$fld)	!show current
	      endif
	   endif
	endif
c
c	R E T U R N
c
900	continue
c
	call free_vm_(4*swmsz,swm,noerr)
	call free_vm_(4*shmsz,shm,noerr)
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	no ON <sort list> phrase specified
90006	continue
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	database name expected
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	unexpected keyword
90010	continue
	mark=p1
	erro=10
	goto 99000			!display error and return properly
c	no current search
90011	continue
	erro=11
	goto 99000			!display error and return properly
c	memory (get_vm_) failure
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	current search is empty
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	same field twice in <sort list>
90014	continue
	erro=14
	goto 99000			!display error and return properly
c	can't sort, not a regular base
90015	continue
	erro=15
	goto 99000			!display error and return properly
c	Display error message (?...), return memory and return
c	======================================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('S$ORT',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('S$ORT',erro)
	endif
c
	call free_vm_(4*swmsz,swm,noerr)
	call free_vm_(4*shmsz,shm,noerr)
c
	return
c
c	Display others error message (?...), return memory and return
c	=============================================================
95000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
	call free_vm_(4*swmsz,swm,noerr)
	call free_vm_(4*shmsz,shm,noerr)
	return
c
c	Formats
c	=======
c
	include 'fmt:sort.fmt'
c
	end
c
c
c
c
	subroutine T$OTAL_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine U$P_(buf,mark,up)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
	logical up
c
c	Description
c	===========
c
c	Implements RECALL/UP command.
c
c	UP <number> or UP <whatever> or UP.
c
c	If UP <number>, this command sets the nth command command from the
c	command buffer reday to be processed by the DBAG command editor.
c
c	If UP, same as if number=last command from buffer.
c
c	If UP whatever, search command buffer and get command with 'whatever'.
c
c	No-op if @level.
c
c	CAUTION: This is the only command not saved in the buffer!
c
c	var
c	===
c
	include 'own:DBAG0.OWN'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*40 mybuf
	integer k,p,type,p1,p2,val,dec,lim,erro,number,mode,mytop,minc
	real rval
	logical frw
c
c	begin
c	=====
c
	call errclr_('U$P')			!clear errors
c
	if (at$lvl.gt.0.or.
     1      us$bat         ) return		!@level or batch, no-op
c
c	Command buffer size
c	-------------------
c
	do k = d$cmmd, 1, -1			!look for last command
	   if (istrip_(cmdbuf(k)).gt.0) then
	      mytop=k
	      goto 50
	   endif	
	enddo
	goto 90007				!the command buffer is empty
c
50	continue
c
c	get 1rst token
c	--------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many digits)
	elseif (type.eq.0) then
	   number=mytop		!eol, number=last command
	   goto 500			!execute UP number command if line
					!is clean
	elseif (type.eq.2) then
	   goto 200			!<number>
	else
	   goto 600			!execute UP whatever command
	endif
c
c	Here if <number>
c	----------------
c
200	continue
c
	number=val
c
	if (number.le.0) goto 90002		!positive number
c
	goto 500				!go execute UP command
c
c	>>>>>>> Execute command UP <number> if line is clean
c	====================================================
c
500	continue
c
c	See if line is clean
c
	if (type.ne.0) then
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if (type.ne.0) goto 90004		!eol expected
	endif
c
cx	p=d$cmdp-number				!command pointer
	p=number				!command pointer
c
	goto 650				!get the pth command from buffer
c
c	>>>>>> Execute command UP whatever
c	==================================
c
600	continue
c
c	lookup command buffer
c
	minc=1				!1 character enough
	mybuf(1:)=' '			!use a local copy
	mybuf=buf(p1:)
c
cxcx	call seetab_(cmdbuf,mytop,p,mybuf,minc)
cxcx	if (p.lt.0) goto 90006		!ambiguous (or too few ...)
cxcx	if (p.eq.0) goto 90005		!not found
c
	frw=.false.			!search backwards
	call seetab2_(cmdbuf,mytop,p,mybuf,minc,frw,erro)
c
	if     (p.gt.0.and.
	1       (erro.eq.0.or.
	1        erro.eq.1   ) ) then
	   goto 650			!found, get the pth command from buffer
	elseif (p.eq.0.and.
	1       erro.eq.0 ) then
	   goto 90005			!not found
	else	
	   goto 90006			!problems ...
	endif
c
c
c	Get the pth command from command buffer
c	=======================================
c
650	continue
c
	if     (p.lt.1) then
	   p=1					!between first...
	elseif (p.gt.mytop) then
	   p=mytop				!...and last
	endif
c
	buf(1:)=' '				!get command
	buf=cmdbuf(p)				!...
	d$cmde=p				!tell editor where command is
	d$edit=1				!set edit mode
	d$updo=1				!and remember me
c
	goto 900				!return
c
c	Return
c
900	continue
c
	return					!return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Syntax errors ...
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90003
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!give error message and return
c	positive number expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!give error message and return
c	too many digits in number
90003	continue
	mark=p1
	erro=3
	goto 99000			!give error message and return
c	eol expected
90004	continue
	mark=p1
	erro=4
	goto 99000			!give error message and return
c	command string not found in command buffer
90005	continue
	erro=5
	goto 99000			!give error message and return
c	problems searching command buffer
90006	continue
	erro=6
	goto 99000			!give error message and return
c	the command buffer is empty
90007	continue
	erro=7
	goto 99000			!give error message and return
c	Give error message (?...) and return
c	====================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('U$P',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=0				!can't edit this command!!!
	else
	   call errset_('U$P',erro)
	endif
	return					!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine U$PDAT_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements UPDATE command.
c
c
	return					!return
c
	end
c
c
c
c
	subroutine U$SE_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements USE/OPEN command:
c
c	USE/OPEN <database> [INDEX <file list>]	= not implemented =
c	opens a database, initializes SEARCH selection to ALL records,
c	makes the database current and  (optionally)  engages desired
c	index files.
c
c	USE/OPEN [DATABASE] <database> [UPDATE/NOUPDATE] = implemented =
c	opens a database for update/noupdate. If base is opened for the
c	first time, bitcan flag is set (SEARCH = 'none').
c
c	Note that NOUPDATE is the default value if base not yet open,
c	otherwise current update/noupdate will not be changed if none
c	specified.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*12 bname, rmname
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,noerr
	real rval
	integer alive,zf,size,bmsize
	logical opn
c
c	begin
c	=====
c
	call errclr_('U$SE')		!error init
c
	opn=.false.
c
c	get [DATABASE] <database>
c	-------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.ne.0.and.
     1          type.ne.1.and.
     1         type.ne.24      ) then
	   goto 90002			!syntax error (neither identifier
					!              nor eol)
	elseif (type.eq.0) then
	   goto 90007			!eol (data base name expected)
	endif
c
c	see if keyword DATABASE
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if (keypos.le.0) goto 100	!not a keyword, forget it
c
	if (keypos.ne.dataky) goto 100	!not DATABASE keyword, forget it
c
c	Get <database>
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.ne.1.and.
     1         type.ne.24      ) then
	   goto 90007			!syntax error (data base name exp.)
	else
	   goto 100			!store <database>
	endif
c
c	Store data base name
c	--------------------
c
100	continue
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10001) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) return		!error, carry
	   endif
	endif
	bname(1:)=' '				!just in case...
	bname(1:)=buf(p1:p1+size-1)		!store <database>
c
c	get [UPDATE/NOUPDATE]
c	---------------------
c
	update=-1			!default for update mode
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.ne.0.and.type.ne.1) then
	   goto 90002			!syntax error (neither identifier
					!              nor eol)
	elseif (type.eq.0) then
	   goto 200			!eol, go execute USE/OPEN command
	endif
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.noupky) then
	   update=0			!NOUPDATE seen
	   goto 200			!NOUPDATE, proceed
	elseif (keypos.eq.updaky) then
	   update=1			!UPDATE seen
	   goto 200			!proceed
	else
	   goto 90006			!syntax error (unexpected keyword)
	endif
c
c	>>>>>>>> Execute command USE/OPEN <database>
c	============================================
c
200	continue
c
c	open database
c	-------------
c
c	update= 0:	open/read or re-open/read if already open;
c	      = 1:	open/write or re-open/write if already open;
c	      =-1:	if not open, open/read; if already open, keep
c			previous update mode;
c
	mode=0
	call open_(base,bname,update,mode,opn,erro)!open database
	if (erro.ne.0) then
	   if (d$rsub.eq.'OPNBAS'.and.
     1         erro.eq.1              ) then		!make sure...
	      base=0					!no current base
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_(d$rsub,erro,mssg,'?')	!display message
	         mark=0
	         call i$mess_(mark,d$cmdo,1,mssg,1,erro)
	         if (erro.ne.0) return			!error, carry
	         call errclr_('U$SE')			!clear error
	         call i$bfre_(base,rmname,erro)		!free some base slot
	         if (erro.eq.0) then
	            if (base.ne.0) then
	               call open_(base,bname,update,mode,opn,erro)!open base
	               if (erro.ne.0) goto 95000	!show error
	            endif
	         else
	            goto 95000				!show error
	         endif
	      else					!non-interactive
	         return
	      endif
	   else
	      goto 95000				!show error
	   endif
	endif
c
c	Base=0 means no base channel available and user typed <ret>
c	-----------------------------------------------------------
c
	if (base.le.0) return				!return now, ...
c
c	Inform user if first open
c
c	Opn=.true. if first open of base
c
	if (opn) then
	   call i$sopn_(base,erro)			!be nice
	   if (erro.ne.0) return			!error, carry
	endif
c
c	Set new current's
c
	if (opn       .or.				!first opening
     1      base.ne.c$base) then			!or none, or new
	   call zfirst_(base,alive,zf,erro)		!TOP record
	   if (erro.ne.0) return			!error, carry
	   call i$scur_(base,zf,0)
	endif
c
	return
c
c	Errors
c	------
c
c	Warnings
c	--------
c
90001	continue			!illegal character
	mark=p1
	erro=1
	goto 99000			!display error
90002	continue			!neither identifier nor eol
	mark=p1
	erro=2
	goto 99000			!display error
90003	continue			!unknown keyword
	mark=p1
	erro=3
	goto 99000			!display error
90004	continue			!ambiguous keyword
	mark=p1
	erro=4
	goto 99000			!display error
90005	continue			!too few characters in keyword
	mark=p1
	erro=5
	goto 99000			!display error
90006	continue			!unexpected keyword
	mark=p1
	erro=6
	goto 99000			!display error
90007	continue			!data base name expected
	mark=p1
	erro=7
	goto 99000			!display error
c	Display my error message (?...) and return
c	==========================================
99000	continue
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('U$SE',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1			!set edit mode
	else
	   call errset_('U$SE',erro)	!set global error
	endif
c
	return
c
c	Display other's error
c	=====================
c
95000	continue
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!display it
	   if (erro.eq.0) then
	      call errclr_('U$SE')		!clear error if ok
	      d$edit=1				!and set edit mode
	   endif
	endif
c
	base=0					!no current base
c
	return					!return anyway
c
c	Formats
c	=======
c
	include 'fmt:use.fmt'
c
	end
c
c
c
c
	subroutine V$MS_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements VMS command:
c
c	VMS [<Vax/vms command line>]
c	Executes <Vax/vms command line> if specified, loops for Vax/vms
c	commands if none.
c
	include 'own:dbag0.own'
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2,erro,width
	real rval
	logical fast,loop,trunc
c
c	begin
c	=====
c
	call errclr_('V$MS')		!error init
c
	loop=.false.			!assume user already typed command
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)	!skip VMS
c
	if     (erro.ne.0) then
	   goto 90001			!syntax error (illegal character)
	elseif (type.eq.0) then
	   loop=.true.			!eol, loop
	   goto 100
	else
	   fast=.false.
	   call spawn_(buf(p1:),fast,erro)	!spwan whatever user typed,
						!wait until executed
	   if (erro.ne.0) goto 90002	!can't
	   goto 900			!and return to main DBAG loop
	endif
c
c	Loop until <CR>
c
100	continue
c
c	prompt for Vax/vms command if interactive
c	-----------------------------------------
c
	if (d$itrv.ne.1) goto 900		!non-interactive, return
c
	write (mssg,10001)			!do prompting
	call i$mess_(0,d$cmdo,1,mssg,0,erro)	!....
	if (erro.ne.0) return			!error, carry
c
c	Get command line
c	----------------
c
	erro=0					!only local messages, please...
	call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)!get command line
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, return
	   call errclr_('V$MS')			!clear error
	   goto 100				!loop back
	endif
	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return			!error, carry
c
	if (trunc) then				!line too long, truncated
	   write (mssg,10002)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0) then
	   goto 900				!eol, return
	elseif (lim.eq.-1) then
	   goto 100				!^Z, loop back for more
	endif
c
	fast=.false.
	call spawn_(buf,fast,erro)		!spwan whatever user typed,
						!wait until executed
	if (erro.ne.0) goto 90002		!can't
	goto 100				!and go back for more
c
c	(Re)inform about current base/rec (VMS command may have destroyed
c	that information e.g. VMS edit xpto.xpt), reset terminal and return
c	to main loop.
c
900	continue
c
	call ttwdth_(width)			!current width
	call i$scur_(c$base,c$rec,c$fld)	!new current's
c
	return
c
c	Warnings
c	--------
c
90001	continue			!illegal character
	mark=p1
	erro=1
	goto 99000			!display error
90002	continue			!can't spawn command
	erro=2
	goto 99000			!display error
c	Display my error message (?...) and return
c	==========================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('V$MS',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('V$MS',erro)
	endif
	return
c
c	Formats
c	=======
c
	include 'fmt:vms.fmt'
c
	end
c
c
c
c
	subroutine E$DT_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements EDT command:
c
c	EDT <file spec>
c	Fast call to Vax/vms EDT editor.
c
	include 'own:dbag0.own'
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2,erro,width,chn
	real rval
c
c	begin
c	=====
c
	call errclr_('E$DT')		!error init
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)	!skip EDT
	if (erro.ne.0) goto 90001	!syntax error (illegal character)
c
	if (type.eq.0) goto 90004	!eol (missing file spec)
c
c	Avoid EDT errors!
c
	call newc_(chn)
	if (chn.le.0) goto 90003	!no more i/o channels
	open (unit=chn,file=buf(p1:),status='unknown',
     1        carriagecontrol='list',err=90002)
	close (unit=chn)
	call freec_(chn)
	chn=0
c
	call edt$edit(buf(p1:))		!call EDT
c
c	(Re)inform about current base/rec (EDT has just destroyed it),
c	reset terminal and return to main loop.
c
	call ttwdth_(width)			!current width
	call i$scur_(c$base,c$rec,c$fld)	!new current's
c
	return
c
c	Warnings
c	--------
c
90001	continue			!illegal character
	mark=p1
	erro=1
	goto 99000			!display error
90002	continue			!expected file.ext
	mark=p1
	erro=2
	goto 99000			!display error
90003	continue			!NEWC ?
	erro=3
	goto 99000			!display error
90004	continue			!missing file spec
	erro=4
	goto 99000			!display error
c	Display my error message (?...) and return
c	==========================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('E$DT',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('E$DT',erro)
	endif
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine T$PU_(buf,mark)
c	**************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements TPU command:
c
c	TPU <file spec>
c	Fast call to Vax/vms TPU editor.
c
	include 'own:dbag0.own'
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2,erro,width,blabla,chn
	real rval
c
c	begin
c	=====
c
	call errclr_('T$PU')		!error init
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)	!skip TPU
	if (erro.ne.0) goto 90001	!syntax error (illegal character)
c
	if (type.eq.0) goto 90004	!eol (missing file spec)
c
c	Avoid TPU errors!
c
	call newc_(chn)
	if (chn.le.0) goto 90003	!no more i/o channels
	open (unit=chn,file=buf(p1:),status='unknown',
     1        carriagecontrol='list',err=90002)
	close (unit=chn)
	call freec_(chn)
	chn=0
c
	call tpu$edit(buf(p1:),blabla)	!call TPU
c
c	(Re)inform about current base/rec (TPU has just destroyed it),
c	reset terminal and return to main loop.
c
	call ttwdth_(width)			!current width
	call i$scur_(c$base,c$rec,c$fld)	!new current's
c
	return
c
c	Warnings
c	--------
c
90001	continue			!illegal character
	mark=p1
	erro=1
	goto 99000			!display error
90002	continue			!expected file.ext
	mark=p1
	erro=2
	goto 99000			!display error
90003	continue			!NEWC ?
	erro=3
	goto 99000			!display error
90004	continue			!missing file spec
	erro=4
	goto 99000			!display error
c	Display my error message (?...) and return
c	==========================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('T$PU',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('T$PU',erro)
	endif
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine N$EWS_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Calls I$HELP to execute "HELP-LIKE" command.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	character*10 who
	character*60 fname
c
c	begin
c	=====
c
c	Init error
c
	call errclr_('N$EWS')
c
	who(1:)=' '
	who='NEWS'		!caller
	fname(1:)=' '
	fname=nwsfil		!file to use
	call i$help_(buf,who,fname,mark)
c
	return
c
	end
c
c
c
c
	subroutine M$ENU_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	logical full
	integer type,val,dec,lim,p1,p2,erro
	real rval
c
c	begin
c	=====
c
	call errclr_('M$ENU')		!error init
	erro=0
c
c	try to get keyword (FULL)
c	--------------------------
c
	full=.false.
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.ne.0.and.type.ne.1) then
	   goto 90002			!syntax error (neither id nor eol)
	elseif (type.eq.0) then
	   full=.false.
	   goto 60			!eol, execute command
	endif
c
c	got a keyword, check it
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.ne.fullky) then
	   goto 90006			!syntax error (bad keyword)
	else
	   full=.true.			!found FULL !
	endif
c
c	execute command
c
60	continue
	if (full) then
cx	   d$itrv=3			!full menu
	else
cx	   d$itrv=2			!cheap menu
	endif
c
	return
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!give error message and return
c	syntax error-illegal type of "token" (not identifier or eol)
90002	continue
	mark=p1
	erro=2
	goto 99000			!give error message and return
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!give error message and return
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!give error message and return
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!give error message and return
c	unexpected keyword
90006	continue
	mark=p1
	erro=6
	goto 99000			!give error message and return
c	Display my error message (?...) and return
c	==========================================
99000	continue
	call errmsg_('M$ENU',erro,mssg,'?')
	call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	d$edit=1					!set edit mode
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine C$LOSE_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements CLOSE command:
c
c	CLOSE [ [DATABASE] <database>]
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer erro,base,size,type,val,dec,lim,p1,p2,pos,update,mode,l,
	1       ferr,berr,b2
	real rval
	character*12 bname
	logical trunc,refer
c
c	begin
c	=====
c
	call errclr_('C$LOSE')			!error init
c
	erro=0
c
c	Get [DATABASE] <database>
c	-------------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001				!illegal character
	elseif (type.ne.0.and.
     1          type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90002				!neither identifier nor eol
	elseif (type.eq.0) then
	   if (c$base.gt.0) then		!eol, ask for database if none
	      base=c$base			!current
	      bname(1:)=' '
	      bname=d$unam(base)
	      goto 400				!close current data base
	   else
	      goto 200				!ask for data base to close
	   endif
	else
c
c	   see if keyword DATABASE
c	   -----------------------
c
	   call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	   if (keypos.le.0) goto 100		!not a keyword, forget it
	   if (keypos.ne.dataky) goto 100	!not DATABASE keyword, forget it
c
c	   Get <database>
c
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	   if     (erro.ne.0) then
	      goto 90001			!syntax error (illegal charact.)
	   elseif (type.ne.1.and.
     1            type.ne.24      ) then
	      goto 90005			!syntax error (database name)
	   else
	      goto 100				!store data base name
	   endif
	endif
c
c	Store data base name and proceed
c
100	continue
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10001) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) return		!error, carry
	   endif
	endif
	bname(1:)=' '
	bname(1:size)=buf(p1:p1+size-1)
	goto 300				!check/close data base
c
c	Ask for database to close
c	-------------------------
c
200	continue
c
	update=0					!no-update mode
	mode=0						!usual mode
	call i$buse_(base,update,mode,bname,erro)	!ask for current base
	if (erro.ne.0) return				!error, carry
	if (base.eq.0) return				!no current base, return
c
	goto 300					!check/exec. command
c
c	Check data base in BNAME
c	------------------------
c
300	continue
c
	call uc_(bname)				!upper case
	call zbnum_(base,bname,erro)		!get base channel
	if (base.le.0) goto 90003		!base not open
	if (erro.ne.0) return			!error, carry
c
c	Used by someone ?
c
	call i$odb_(base,berr,ferr,refer,erro)	!is base used as o.d.b ?
	if (erro.ne.0) return			!error, carry
	if (refer) goto 90007			!can't close base
c
	goto 400				!close data base
c
c	>>>>>> Execute command
c	======================
c
400	continue
c
c	See if line is clean
c
	if (type.ne.0) then
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if (type.ne.0) goto 90006		!eol expected
	endif
c
	call close_(base,erro)			!close data base
	if (erro.ne.0) return			!error, carry
c
c	Inform user
c	-----------
c
	if (d$itrv.eq.1) then		!interactive
	   mssg(1:)=' '
	   mssg(1:11)=' Data base '		!data base closed
	   pos=12
	   mssg(pos:)=bname
	   pos=pos+istrip_(bname)
	   mssg(pos:pos+8)=' closed'
c
	   call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	endif
c
	return
c
c	^Z or end-of-@file
c
500	continue
	if (at$lvl.le.0) then
	   goto 90004				!^Z found
	else
	   call i$atup_(erro)			!end of @file, go up
	   if (erro.ne.0) return		!error, carry
	endif
c
	return
c
c	Warnings
c	--------
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000				!display error
c	neither identifier nor eol
90002	continue
	mark=p1
	erro=2
	goto 99000				!display error
c	Data base not open
90003	continue
	erro=3
	mark=0
	goto 99000				!display error
c	^Z found
90004	continue
	erro=4
	mark=0
	goto 99000				!display error
c	Data base name expected
90005	continue
	erro=5
	mark=p1
	goto 99000				!display error
c	eol expected
90006	continue
	erro=6
	mark=p1
	goto 99000				!display error
c	field used as o.d.b. by someone, can't close base
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(berr)			!tell him witch base
	erro=7
	goto 99000				!display error
c	Display my error message (?...) and return
c	==========================================
99000	continue
c
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('C$LOSE',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1			!set edit mode
	else
	   call errset_('C$LOSE',erro)	!set global error
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:close.fmt'
c
	end
c
c
c
c
	subroutine C$ANCE_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements CANCEL command:
c
c	*****	CANCEL SEARCH/SORT [DATABASE <database> ]
c
c	This command clears current SEARCH/SORT for <database> (current
c	database if not specified).
c	If CANCEL SEARCH, sets BITCAN flag in base context and cancels
c	SORT as well.
c	After execution, <database> becomes the current database.
c
c	The following rules apply to current SEARCH:
c
c	1. At first opening of any data base (explicit or implicit), as well
c	   as after CANCEL SEARCH command,  no current search will exist for
c	   that base (SEARCH: none).
c
c	2. Current search is only set/modified by means of SEARCH/CANCEL
c	    commands;
c
c	3. Current search is used by any command that doesn't specify an
c	   explicit <scope>.
c
c	Current SEARCH is implemented by use of a bitmap - bitpnt(base) -
c	allocated by any command that needs it.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_, ndigi_
	integer istrip_, ndigi_
	integer nsear,nsort,ndatab,update,mode,base,pos,irec,rec,cnt,dig,zf,zl
	integer bmsize,type,val,dec,rval,lim,p1,p2,erro,noerr,size
	character*12 bname
	logical inuse,outopn
c
c	begin
c	=====
c
	call errclr_('C$ANCE')		!error init
c
	nsear=0				!#SEARCH
	nsort=0				!#SORT
	ndatab=0			!#[DATABASE...]
	bname(1:)=' '			!<database> name
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error (not identifier or eol)
	elseif (type.eq.0) then
	   goto 200			!eol, go complete/execute CANCEL com.
	endif
c
c	Got a keyword, check it
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.searky) then
	   nsear=nsear+1		!count it
	   goto 1			!loop back for more
	elseif (keypos.eq.sortky) then
	   nsort=nsort+1		!count it
	   goto 1			!loop back for more
	elseif (keypos.eq.dataky) then
	   ndatab=ndatab+1		!count it
	   goto 100			!"eat" [DATABASE <database> ]
	else
	   goto 90006			!keyword or eol expected
	endif
c
c	Here to "eat" [DATABASE...]
c	---------------------------
c
100	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1    ) then
	   goto 90009			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10001) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) return		!error, carry
	   endif
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!loop back for more
c
c	>>>>>> Here to check/complete/execute CANCEL command
c	----------------------------------------------------
c
200	continue
c
c	Check CANCEL command
c	--------------------
c
	if (nsear.le.0.and.
	1   nsort.le.0) goto 90012		!SEARCH/SORT keyword not found
c
c	check duplicate requests in command
c
	if     (nsear.gt.1.or.
     1          nsort.gt.1.or.
     1          ndatab.gt.1   ) then
	   goto 90008					!duplicate requests
	endif
c
	if (nsear.eq.1.and.
	1   nsort.eq.1     ) goto 90008			!duplicate requests
c
c	Complete CANCEL command
c	-----------------------
c
c	Ask for current base if needed and user didn't supply one
c	---------------------------------------------------------
c
	if (ndatab.gt.0) then		!user supplied database name
	   mode=0
	   update=-1
	   call open_(base,bname,update,mode,outopn,erro)!open database
	   if (erro.ne.0) then
	      goto 95000			!show error
	   endif
	else
	   update=-1					!don't change update
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	   if (erro.ne.0) return			!error, carry
	   if (base.eq.0) return			!no base, return
	endif
c
	if (base.le.0) return				!no data base supplied
c
c	Cancel SEARCH, if any
c	---------------------
c
	if (bitcan(base).eq.1.or.
     1      bitsiz(base).le.0   ) then			!no current SEARCH
c	   say it later
	else
	   if (nsear.gt.0) then			!cancel search
	      rec=0					!count selected (from
	      irec=0
	      call bitcnt_(%val(bitpnt(base)),irec,cnt,erro)!first...)
	      if (erro.ne.0) return			!error, carry
	      call bitclr_(%val(bitpnt(base)),erro)	!clear SEARCH
	      if (erro.ne.0) return			!error, carry
	   endif
	endif
c
c	Clear permanent SORT, if any
c	----------------------------
c
	if (bitsiz(base).gt.0) then
	   call ordclr_(%val(bitpnt(base)),erro)	!clear structure
	   if (erro.ne.0) return			!error, carry
	endif
c
c	Inform user
c	-----------
c
	if (d$itrv.eq.1) then				!interactive
c
	   mssg(1:)=' '
	   if (bitcan(base).eq.1.or.
     1         bitsiz(base).le.0   ) then		!no current SEARCH
	      if (nsear.gt.0) then
	         mssg(1:43)=' %There is no current SEARCH for data base '
	         pos=44
	      else
	         mssg(1:41)=' %There is no current SORT for data base '
	         pos=42
	      endif
	      mssg(pos:)=bname
	   else
	      if (nsear.gt.0) then			!cancel search
	         mssg(1:30)=' Current SEARCH for data base '
	         pos=32
	      else
	         mssg(1:28)=' Current SORT for data base '
	         pos=30
	      endif
	      mssg(pos:)=bname
	      pos=pos+istrip_(bname)
	      if (nsear.gt.0) then
	         mssg(pos:pos+1)=' ('
	         pos=pos+2
	         dig=ndigi_(cnt)
	         call wrivar_(mssg(pos:pos+dig-1),cnt,dig,erro)!write it
	         if (erro.ne.0) goto 90013		!write error
	         pos=pos+dig
	         mssg(pos:pos+9)=') canceled'
	      else
	         mssg(pos:)=' canceled'
	      endif
	   endif
c
	   call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) return				!error, carry
c
	endif
c
	if (nsear.gt.0) bitcan(base)=1			!flag CANCEL SEARCH
c
	if (base.eq.c$base) then
	   call i$scur_(c$base,c$rec,c$fld)		!make/show current base
	endif
c
	return						!return to main loop
c
c	Error
c	=====
c
c	Warnings
c	--------
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	unexpected keyword
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	database name expected
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	*** obsolete *** database not opened
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	*** obsolete *** no current base
90011	continue
	erro=11
	goto 99000			!display error and return properly
c	SEARCH or SORT keyword not found
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	internal error (read/write error)
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	Display error message (?...) and return
c	=======================================
99000	continue
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('C$ANCE',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('C$ANCE',erro)
	endif
	return
c	Display others error message (?...) and return
c	==============================================
95000	continue
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
	return
c
c	Formats
c	=======
c
	include 'fmt:cancel.fmt'
c
	end
c
c
c
c
	subroutine D$EFIN_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	DEFINE	DISPLAY  STANDARD
c	DEFINE	DISPLAY
c		system driven dialogue
c
c	Defines the display in terms of which fields to show, size,
c	position,   justification,   how ( text  or  number),  etc.
c	If STANDARD all fields and the sizes declared for the data
c	base are used. If NON-STANDARD, user display format will be
c	and user or standard fields and sizes used.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbaga2.own'
c
	integer istrip,ndigi
	integer type,val,dec,l,lim,p1,p2,erro
	real rval
	logical stand,good,stky,reky,trunc
	integer k,lf,li,ls,fld,knd,quit,kind
	integer what,npos1,chn,sz,pos,siz,count,dl,b,f,b2,see
	character*60 fname,ext*4
	character*80 answr
c
c
c	begin
c	=====
c
	call errclr_('D$EFIN')		!error init
c
	erro=0
c
c	try to get keyword (DISPLAY)
c	----------------------------
c
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.eq.0) then
	   goto 90002			!syntax error (abrupt eol)
	elseif (type.ne.1) then
	   goto 90003			!syntax error (illegal token)
	endif
	npos1=p2+1
c
c	got a keyword, check if DISPLAY
c	-------------------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90004			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90005			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90006			!syntax error (too few char.)
	elseif (keypos.ne.dispky) then
	   goto 90007			!syntax error (bad keyword)
	else
c	   ok				!found DISPLAY !
	endif
c
c	see if STANDARD keyword or eol
c	------------------------------
c
	npos1=p2
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.ne.0) then		!must be STANDARD
	   call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
	   if     (keypos.eq.0) then
	      goto 90004		!syntax error (unknown keyword)
	   elseif (keypos.eq.-1) then
	      goto 90005		!syntax error (ambiguous keyword)
	   elseif (keypos.eq.-2) then
	      goto 90006		!syntax error (too few char.)
	   elseif (keypos.ne.stanky) then
	      goto 90007		!syntax error (bad keyword)
	   else
	      stand=.true.		!found STANDARD!
	   endif
	else
	   stand=.false.		!found eol
	endif
c
c	>>>>>> Execute command DEFINE DISPLAY [STANDARD]
c	------------------------------------------------
c
c	See if line is clean
c
	if (type.ne.0) then
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if (type.ne.0) goto 90008	!eol expected
	endif
c
c	see current base
c
	if (c$base.le.0) goto 90009	!no current base, give up
c
	if (stand) then			!DEFINE  DISPLAY STANDARD
c	---------------------------------------------------------
c
	ds$fmt(c$base)=0		!force standard format
	call i$defd_(c$base,erro)	!define display
	if (erro.ne.0) goto 95000
c
	else				!user defined DISPLAY
c	---------------------------------------------------------
c
	dl=1				!display lines, temp. = 1
c
c	tell him what to do for display format
c
	count=1
c
	write(mssg(1:),2001)
	call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) goto 95000
	write(mssg(1:),2002)
	call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) goto 95000
c
c	loop here to ask for display format
c
200	continue
	mark=0					!clear mark
	write (mssg,1004)			!do prompting
	call i$mess_(0,d$cmdo,0,mssg,0,erro)	!....
	if (erro.ne.0) goto 95000		!fatal error
c
	erro=0					!only local messages, please...
	call inline_(d$cmdi,answr,lim,cmcont,trunc,erro)!get command line
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   call errclr_('D$EFIN')		!clear error
	   goto 200				!loop back
	endif
	call i$mess_(0,0,-1,answr,-1,erro)
	if (erro.ne.0) goto 95000		!fatal error
c
	if (trunc) then				!line too long...
	   write (mssg,1003)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	endif
c
	if     (lim.eq.0) then
	   goto 101				!eol, finished
	elseif (lim.eq.-1) then
	   goto 400				!^Z or end-of-@file
	elseif (lim.eq.-2) then
	   goto 200				!comment line
	endif
c
	call rstok_(answr,1,erro)
	if (erro.ne.0) goto 95000
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0) then			!illegal character
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)!....
	   if (erro.ne.0) goto 95000		!fatal error
	   goto 200
	endif
c
	if (type.eq.0) goto 101			!eol, finished...
c
	if (type.eq.2) then			!number
	   if (val.lt.1.or.val.gt.2) then
	      write(mssg,80010)			!wrong number
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)!....
	      if (erro.ne.0) goto 95000		!fatal error
	      goto 200
	   endif
	else
	   write(mssg,80010)			!wrong syntax
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)!....
	   if (erro.ne.0) goto 95000		!fatal error
	   goto 200
	endif
c
c	See if line is clean
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if     (erro.ne.0) then			!illegal character
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   goto 200
	elseif (type.ne.0) then
	   write(mssg,80010)			!wrong syntax
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)!....
	   if (erro.ne.0) goto 95000		!fatal error
	   goto 200
	endif
c
	ds$fmt(c$base)=val			!format
c
c	tell him what to do for each field
c
	write(mssg(1:),1001)
	call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) goto 95000
	write(mssg(1:),1002)
	call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) goto 95000
	write(mssg(1:),10021)
	call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) goto 95000
c
c	gather some information
c
	call znfld_(c$base,lf,erro)
	if (erro.ne.0) goto 95000
c
c	loop forever, accepting one line per field
c	..........................................
c
	count=1
	pos=1					!start at 1st column
100	continue
c
	good=.true.				!be trustful
	mark=0					!clear mark
	write (mssg,1004)			!do prompting
	call i$mess_(0,d$cmdo,0,mssg,0,erro)	!....
	if (erro.ne.0) goto 95000		!fatal error
c
	erro=0					!only local messages, please...
	call inline_(d$cmdi,answr,lim,cmcont,trunc,erro)!get command line
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   call errclr_('D$EFIN')		!clear error
	   goto 100				!loop back
	endif
	call i$mess_(0,0,-1,answr,-1,erro)
	if (erro.ne.0) goto 95000		!fatal error
c
	if (trunc) then				!line too long...
	   write (mssg,1003)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	endif
c
	if     (lim.eq.0) then
	   goto 101				!eol, finished
	elseif (lim.eq.-1) then
	   goto 400				!^Z or end-of-@file
	elseif (lim.eq.-2) then
	   good=.false.
	   goto 103				!comment line
	endif
c
c	here submit or re-submit of line
c
102	continue
	stky=.false.
	reky=.false.
	call uc_(answr)
	call rstok_(answr,1,erro)
	if (erro.ne.0) goto 95000
c
c	field reference (mnemonic, n or %n) OR end of dialogue;
c	could also be # (record #) or STATUS (marked/not marked del)
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0) then			!illegal character
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
	if (type.eq.0) goto 101			!eol, finished...
c
	if     (type.eq.40) then			!#
	   reky=.true.
	elseif (type.eq.1.or.
     1          type.eq.24   ) then			!mnemonic (eg a_b)
	   call znum_(c$base,val,answr(p1:p2),erro)
	   if (erro.ne.0) goto 95000
	   if (val.eq.-1) then				!doesn't exist
	      call seetab_(keytok,keytop,keypos,answr(p1:p2),1)
	      if     (keypos.eq.markky) then		!found keyword
	         stky=.true.
	      else
	         write(mssg,80002)
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	         if (erro.ne.0) goto 95000		!fatal error
	         good=.false.
	         goto 103
	      endif
	   endif
	elseif (type.eq.33)then				!"%number"
	   call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	   if (erro.ne.0) then			!illegal character
	      write (mssg,80001)
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	      if (erro.ne.0) goto 95000		!fatal error
	      good=.false.
	      goto 103
	   endif
	   if (type.eq.2) then				!number
	      if (val.le.0.or.val.gt.lf) then
	         write(mssg,80003)			!wrong number or protec.
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	         if (erro.ne.0) goto 95000		!fatal error
	         good=.false.
	         goto 103
	      else					!see protection
	         if (d$prt(c$base).ne.0) then		!protection ON
	            if (d$prfl(val,c$base).eq.prtno) then
	               write(mssg,80003)		!wrong number or protec.
	               call i$mess_(0,d$cmdo,1,mssg,-1,erro)!....
	               if (erro.ne.0) goto 95000	!fatal error
	               good=.false.
	               goto 103
	            endif
	         endif
	      endif
	   else
	      write(mssg,80004)				!wrong syntax
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	      if (erro.ne.0) goto 95000		!fatal error
	      good=.false.
	      goto 103
	   endif
	elseif (type.eq.2) then				!number
	   if (val.le.0.or.val.gt.lf) then
	      write(mssg,80003)				!wrong number
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	      if (erro.ne.0) goto 95000			!fatal error
	      good=.false.
	      goto 103
	   else						!see protection
	      if (d$prt(c$base).ne.0) then		!protection ON
	         if (d$prfl(val,c$base).eq.prtno) then
	            write(mssg,80003)			!wrong number or protec.
	            call i$mess_(0,d$cmdo,1,mssg,-1,erro)!....
	            if (erro.ne.0) goto 95000		!fatal error
	            good=.false.
	            goto 103
	         endif
	      endif
	   endif
	else
	   write(mssg,80004)				!wrong syntax
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
	if     (stky) then
	   ds$fld(dl,count,c$base)=-1		!status (marked/not marked del)
	   fld=-1
	elseif (reky) then
	   ds$fld(dl,count,c$base)=0		!record number
	   fld=0
	else
	   ds$fld(dl,count,c$base)=val		!"normal" field
	   fld=val
	endif
c
c	Here, "," or eol, ie, use standard definition for field
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
c
	if     (erro.eq.0.and.type.eq.0) then	!eol
c
	if (fld.gt.0) then
c
c	   CAUTION: the code below is repeated in module I$DEFD
c	   =======
c
	   b2=d$dbio(fld,c$base)
	   see=d$see(fld,c$base)
	   b=c$base
	   f=fld
	   if (b2.gt.0.and.see.gt.0) then
	      b=b2
	      f=see
	   endif
	   ds$fld(dl,count,c$base)=fld
	   ds$pos(dl,count,c$base)=pos
	   call zsize_(b,f,siz,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   ds$siz(dl,count,c$base)=siz
	   call zkind_(b,f,kind,erro)
	   if (erro.ne.0) goto 95000		!fatal error
	   goto (11,12,13,14,15,16,17,18) kind
c
	   goto 10			!non-user fields become integer, r-j
c
10	      continue			!non-user
11	      continue			!integer
13	      continue			!other D.B.
	      ds$how(dl,count,c$base)=2	!all become number like,
	      ds$jus(dl,count,c$base)=2	!right justified
	      goto 99
c
12	      continue			!string
14	      continue			!decimal
15	      continue			!date
16	      continue			!logical
17	      continue			!real
18	      continue			!double precision
	      ds$how(dl,count,c$base)=1	!all become text like,
	      ds$jus(dl,count,c$base)=1	!left justified
	      if (kind.eq.x$.or.	!except for decimals
     1            kind.eq.r$.or.	!or reals
     1            kind.eq.r8$.or.	!or double precision
     1            kind.eq.l$   ) then	!or booleans
	         ds$jus(dl,count,c$base)=2
	      endif
	      if (kind.eq.c$) then		!and strings (do nothing)
	         ds$jus(dl,count,c$base)=0	!do nothing
	      endif
	      goto 99
c
99	      continue
c
	      if     (kind.eq.d$) then
	         siz=11			!"fix" DATE type size (text like)
	         ds$siz(dl,count,c$base)=siz
	      elseif (kind.eq.x$) then	!decimals need extra room for "."
	         siz=siz+1
	         ds$siz(dl,count,c$base)=siz
	      elseif (kind.eq.r$) then	!reals have fixed format
	         siz=15
	         ds$siz(dl,count,c$base)=siz
	      elseif (kind.eq.r8$) then	!double precision too
	         siz=24
	         ds$siz(dl,count,c$base)=siz
	      endif
c
	      pos=pos+siz
c
	   endif
c
c	   =======
c
	   goto 103			!next field
c
	elseif (erro.ne.0.or.type.ne.8) then	!should be ","
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
c	position (calculated)
c
	ds$pos(dl,count,c$base)=pos
c
c	size (number)
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0) then			!illegal character
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
	if (type.eq.2) then
	   ds$siz(dl,count,c$base)=val
	   pos=pos+val
	else
	   write(mssg,80006)				!wrong syntax
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0.or.type.ne.8) then		!should be ","
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
c	type of display ( (t)ext, (n)umber)
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0) then			!illegal character
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
	if (type.eq.1) then
	   if     (answr(p1:p2).eq.'T') then
	      val=1
	   elseif (answr(p1:p2).eq.'N') then
	      val=2
	   else
	      write(mssg,80007)				!wrong syntax
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	      if (erro.ne.0) goto 95000		!fatal error
	      good=.false.
	   goto 103
	   endif
	   fld=ds$fld(dl,count,c$base)
	   if     (fld.eq.-1) then		!'*' mark
	      val=1				!is always text
	   elseif (fld.eq.0) then		!rec#
	      val=2				!is alwyas number
	   else
	      call zkind_(c$base,fld,knd,erro)
	      if (erro.ne.0) goto 95000
	      if (knd.eq.c$.and.val.ne.1) then
	         val=1				!if string force text
	         write(mssg,80009)
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 95000
	      elseif (knd.eq.x$.and.val.ne.1) then
	         val=1				!if decimal force text
	      endif
	   endif
	   ds$how(dl,count,c$base)=val
	else
	   write(mssg,80007)				!wrong syntax
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0.or.type.ne.8) then		!should be ","
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
c	justification ( (l)eft, (r)ight)
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0) then			!illegal character
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
	if (type.eq.1) then
	   if     (answr(p1:p2).eq.'N') then
	      val=0
	   elseif (answr(p1:p2).eq.'L') then
	      val=1
	   elseif (answr(p1:p2).eq.'R') then
	      val=2
	   elseif (answr(p1:p2).eq.'C') then
	      val=3
	   else
	      write(mssg,80008)				!wrong syntax
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	      if (erro.ne.0) goto 95000		!fatal error
	      good=.false.
	      goto 103
	   endif
	   ds$jus(dl,count,c$base)=val
	else
	   write(mssg,80008)				!wrong syntax
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
	call intok_(type,val,dec,rval,answr,lim,p1,p2,mssg,erro)
	if (erro.ne.0.or.type.ne.0) then	!should be eol
	   write (mssg,80001)
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!....
	   if (erro.ne.0) goto 95000		!fatal error
	   good=.false.
	   goto 103
	endif
c
c
103	continue
	if (good) then
	   count=count+1
	else
cx	   call vgener_(answr,mark,quit,erro)	!edit line
cx	   if (erro.ne.0) goto 95000
cx	   if (quit.eq.1) then
cx	      goto 100				!give up this line
cx	   else
cx	      good=.true.
cx	      goto 102				!re-submit
cx	   endif
	endif
	goto 100
c
c	end-of-line-dialogue
c
101	continue
c
c	one line/record or one line/field ?
c
	if (count.gt.1) then		!if anything defined...
	   ds$def(c$base)=2		!user defined display
	   if (count.le.d$f+2) then
	      ds$fld(dl,count,c$base)=-2		!mark end
	   endif
	endif
c
c	E  N  D
c
	endif
c
	return
c
c	^Z or end-of-@file
c	------------------
c
400	continue				!^Z or end-of-@file
	if (at$lvl.le.0) then
	   goto 90010				!^Z found
	else
	   call i$atup_(erro)			!end of @file, go up
	   return				!return anyway
	endif
c
c	Warnings
c	--------
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	d$edit=1
	goto 99000			!give error message and return
c	syntax error-unexpected eol
90002	continue
	mark=p1
	erro=2
	d$edit=1
	goto 99000			!give error message and return
c	syntax error-illegal word
90003	continue
	mark=p1
	erro=3
	d$edit=1
	goto 99000			!give error message and return
c	unknown keyword
90004	continue
	mark=p1
	erro=4
	d$edit=1
	goto 99000			!give error message and return
c	ambiguous keyword
90005	continue
	mark=p1
	erro=5
	d$edit=1
	goto 99000			!give error message and return
c	too few characters in keyword
90006	continue
	mark=p1
	erro=6
	d$edit=1
	goto 99000			!give error message and return
c	unexpected keyword
90007	continue
	mark=p1
	erro=7
	d$edit=1
	goto 99000			!give error message and return
c	eol expected
90008	continue
	mark=p1
	erro=8
	goto 99000			!give error message and return
c	no current data base
90009	continue
	mark=0
	erro=9
	goto 99000			!give error message and return
c	^Z found
90010	continue
	mark=0
	erro=10
	goto 99000			!give error message and return
c
c	Display my error message (?...) and return
c	==========================================
99000	continue
	if (d$itrv.eq.1) then			!interactive usage
	   call errmsg_('D$EFIN',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	else
	   call errset_('D$EFIN',erro)		!set error
	endif
c
	return
c
c	inherited errors
c
95000	continue
	return
c
c	Formats
c	=======
c
	include 'fmt:DEFINE.FMT'
c
c
	end
c
c
c
c
	subroutine R$ESTO_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements RESTORE command:
c
c	*****	RESTORE SEARCH/SORT/DISPLAY/COMMANDS FROM <file.ext>
c
c	This command restore current search/sort/display of current data base
c	(or the DBAG command buffer) from disk file FILE.EXT.
c
c	Note that, as a current sort is ALWAYS an ordered way of accesing a
c	current search, the commands restore search and restore sort have the
c	same result when the disk file contains both search and sort.
c
c	If the disk file contains a sort, it is checked against the
c	corresponding sort: the same record numbers and only them should be
c	referenced.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbaga2.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,l,lim,lim1,lim2,p1,p2,erro,last,noerr
	real rval
	logical sear,sor,displ,comma,trunc,outok,bitok
	integer sortio,base,what,npos1,chn,k,sz,dl
	character*60 fname,him
	character*1 cmmd,when,who,where
	character*12 ext,basnam,me,day*10,now*9,dir*40
	integer tmpbit,tmpsiz,irec,tmpwht,count,izf,zf,izl,zl,topr
c
c
c	begin
c	=====
c
	call errclr_('R$ESTO')		!error init
c
	erro=0
c
c	try to get keyword (SEARCH, SORT, DISPLAY or COMMANDS)
c	------------------------------------------------------
c
	sear=.false.
	sor=.false.
	displ=.false.
	comma=.false.
c
	chn=0
	tmpsiz=0
c
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.eq.0) then
	   goto 90002			!syntax error (abrupt eol)
	elseif (type.ne.1) then
	   goto 90003			!syntax error (illegal token)
	endif
c
	npos1=p2+1
c
c	got a keyword, check if SEARCH, SORT, DISPLAY or COMMANDS
c	---------------------------------------------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90004			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90005			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90006			!syntax error (too few char.)
	elseif (keypos.eq.searky) then
	   sear=.true.			!found SEARCH
	elseif (keypos.eq.sortky) then
	   sor=.true.			!found SORT
	elseif (keypos.eq.dispky) then
	   displ=.true.			!found DISPLAY
	elseif (keypos.eq.commky) then
	   comma=.true.			!found COMMANDS
	else
	   goto 90007			!syntax error (bad keyword)
	endif
c
c	try to get keyword (FROM)
c	-------------------------
c
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.eq.0) then
	   if (d$itrv.eq.1) then	!interactive
	      buf(npos1:)=' FROM '
	      npos1=npos1+6
234	      continue
	      write(mssg,10000)			!be nice, ask for filespec
	      call i$mess_(0,d$cmdo,0,mssg,0,erro)
	      if (erro.ne.0) goto 95000		!fatal error
	      erro=0
	      call inline_(d$cmdi,buf(npos1:),lim,cmcont,
     1                     trunc,erro)		!get filespec
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 95000	!fatal error
	         call errclr_('R$ESTO')		!clear error
	         goto 234			!loop back
	      endif
	      if (trunc) then			!line too long, truncated
	         write (mssg,10002)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 95000	!fatal error
	      endif
	      call rstok_(buf,npos1,erro)
	      if (erro.ne.0) goto 95000		!fatal error
	      goto 5
	   else				!non-interactive
	      goto 90002			!unexpected eol
	   endif
c
	elseif (type.ne.1) then
	   goto 90003			!syntax error (illegal token)
	endif
c
c	got a keyword, check if FROM
c	----------------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90004			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90005			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90006			!syntax error (too few char.)
	elseif (keypos.ne.fromky) then
	   goto 90007			!syntax error (bad keyword)
	else
c	   ok				!found TO !
	endif
c
c	try to get <filespec>
c	---------------------
c
5	continue
	call infspc_(type,what,fname,ext,
     1              val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.eq.0) then
	   if (d$itrv.eq.1) then	!interactive
345	      continue
	      write(mssg,10001)			!be nice, ask for filespec
	      call i$mess_(0,d$cmdo,0,mssg,0,erro)
	      if (erro.ne.0) goto 95000		!fatal error
	      erro=0
	      call inline_(d$cmdi,buf(npos1:),lim,cmcont,
     1                     trunc,erro)		!get filespec
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 95000	!fatal error
	         call errclr_('R$ESTO')		!clear error
	         goto 345			!loop back
	      endif
	      if (trunc) then			!line too long, truncated
	         write (mssg,10002)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 95000	!fatal error
	      endif
	      call rstok_(buf,npos1,erro)
	      if (erro.ne.0) goto 95000		!fatal error
	      goto 5				!re-submit
	   else				!non-interactive
	      goto 90002			!unexpected eol
	   endif
c
	elseif (type.ne.36) then
	   goto 90003			!syntax error (illegal token)
	endif
c
c	see if line is clean
c	--------------------
c
	npos1=p2
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90008	!syntax error (eol expected)
c
c	Complete command (if DISPLAY ! SEARCH ! SORT)
c	---------------------------------------------
c
	if (displ.or.sear.or.sor) then
c
	   if (c$base.le.0) goto 90009	!no current base, give up
	   base=c$base
c
	endif
c
c	execute command
c	---------------
c
c	check file.ext
c
	call givext_(fname,ext)		!add extension
c
c	Open input file and read header. If error, don't care if
c	RESTORE COMMANDS; instead, try to restore everything from
c	file.
c
	call newc_(chn)
	if (chn.le.0) goto 90013	!no more i/o channels
	call f$ihdr_(chn,fname,him,cmmd,basnam,when,who,where,erro)
	if (erro.ne.0) then
	   if (comma) then
	      rewind(chn)		!back to beginning
	   else
	      if (d$itrv.eq.1) then	!interactive
	         call errmsg_('F$IHDR',erro,mssg,'%')
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 95000	!fatal error
	         call errclr_('S$AVE')		!clear error
	         d$edit=1			!set edit mode
	         mark=0				!...
	         goto 900			!and return
	      else			!non-interactive
	         goto 900				!just return
	      endif
	   endif
	endif
c
	if (sear.or.sor) then
c	=====================
c
	if (him(1:6).ne.'SEARCH'.and.		!old version
	1   him(1:).ne.'SEARCH/SORT') goto 90010!not SEARCH file
c
	lim1=index(basnam,'(')-1
	if (lim1.le.0) lim1=istrip_(basnam)
	if (lim1.le.0) goto 90010		!no base ?
	lim2=istrip_(d$unam(base))
	if (d$unam(base)(1:lim2).ne.basnam(2:lim1)) goto 90011
c
c	Clear sort, if any
c
	if (bitsiz(base).gt.0) then
	   call ordclr_(%val(bitpnt(base)),erro)	!clear structure
	   if (erro.ne.0) return			!error, carry
	endif
c
c	Restore current search
c
	read(chn,'(i12)',end=90014,err=90014) sz!1rst word = bitmap size
c
	if (bitsiz(base).le.0) goto 90012	!lost the bmap ?!
c
	if (bitsiz(base).lt.sz) then		!doesn't fit
	   call i$bclr_(base,erro)		!so get rid of bit map first
c	   if (erro.ne.0) noerror
	   call i$bini_(base,sz,erro)		!and allocate another big enough
	   if (erro.ne.0) goto 95000		!fatal error
	else
	   call bitclr_(%val(bitpnt(base)),erro)!bitmap fits, just clear it
	   if (erro.ne.0) goto 95000
	endif
c
	bitcan(base)=0
c
	k=1					!first word is size
	call ink_(%val(bitpnt(base)),k,sz)	!xity procedure
	do k = 2, sz
	   read(chn,'(i12)',end=90014,err=90014)val	!next words
	   call ink_(%val(bitpnt(base)),k,val)	!xity procedure
	enddo
c
	k=3					!forget old channel (word 3)
	val=0
	call ink_(%val(bitpnt(base)),k,val)	!xity procedure
c
	call i$scur_(c$base,c$rec,c$fld)	!show it (current search)
c
c	Init temporary bit map to check sort against search
c
	call bitlim_(%val(bitpnt(base)),izf,izl,erro)	!fake zf,zl
	if (erro.ne.0) goto 900				!error, carry
	call in3ex_(base,izf,zf,erro)
	if (erro.ne.0) goto 900				!error, carry
	call in3ex_(base,izl,zl,erro)
	if (erro.ne.0) goto 900				!error, carry
	call bitmax_(%val(bitpnt(base)),tmpsiz,erro)	!bitmap size
	if (erro.ne.0) goto 900				!error, carry
	call get_vm_(4*tmpsiz,tmpbit,erro)		!ask for room
	if (erro.ne.0) goto 90016			!no memory!
	call bitini_(%val(tmpbit),tmpsiz,izf,topr,erro)
	if (erro.ne.0) goto 900				!error, carry
	call bitor_(%val(tmpbit),%val(bitpnt(base)),erro)
	if (erro.ne.0) return				!error, carry
c
c	Restore sort, if any
c
	call ordini_(base,%val(bitpnt(base)),erro)	!init structure
	if (erro.ne.0) goto 95000		!can't init structure
	call outk_(%val(bitpnt(base)),3,sortio)!hard to read, the bitmap
c
	outok=.true.
	bitok=.true.
c
	read (chn,'(i9)',end=10018,err=10018) val!first record #'s
	outok=.false.
	write (sortio,'(i9)',err=10018) val
	outok=.true.
c
10017	   continue
c							!check bit map(s)
	   call ex3in_(base,val,irec,erro)
	   if (erro.ne.0) goto 95000
	   call bitget_ (%val(tmpbit),irec,tmpwht,erro)
	   if (erro.ne.0) return
	   if (tmpwht.ne.1) then			!should be set!!!
	      bitok=.false.
	      goto 10018				!problems
	   endif
	   call bitzer_ (%val(tmpbit),irec,erro)	!clear it
	   if (erro.ne.0) return
c
	   read (chn,'(i9)',end=10019,err=10018) val!next record #'s
	   outok=.false.
	   write (sortio,'(i9)',err=10018) val
	   outok=.true.
	   goto 10017
c
10019	   continue
c
	   val=0				!count them all
	   call bitcnt_ (%val(tmpbit),val,count,erro)
	   if (erro.ne.0) return
	   if (count.ne.0) then
	      bitok=.false.
	      goto 10018			!problems
	   endif
c
	   goto 10020				!everything ok
c
c	   problems here, no sort at all
10018	   continue
	      call ordclr_(%val(bitpnt(base)),erro)!clear structure
	      if (erro.ne.0) goto 900		!error, carry
c
	      if (sor) then
	         if (.not.outok) goto 90015	!can't write sort file
	      endif
	      if (.not.bitok) goto 90017	!bit maps don't match
c
	      goto 900				!all done, return
c
c	everything ok
c
10020	continue
c
	call i$scur_(c$base,c$rec,c$fld)	!show it (sorted)
c
	goto 900				!return
c
	elseif (displ) then
c	===================
c
	if (him(1:7).ne.'DISPLAY') goto 90010	!not DISPLAY file
c
	lim1=index(basnam,'(')-1
	if (lim1.le.0) lim1=istrip_(basnam)
	if (lim1.le.0) goto 90010		!no base ?
	lim2=istrip_(d$unam(base))
	if (d$unam(base)(1:lim2).ne.basnam(2:lim1)) goto 90011
c
	read(chn,'(i9)',end=90010,err=90014) ds$fmt(base)
	if (ds$fmt(base).lt.1.or.
     1      ds$fmt(base).gt.2    ) ds$fmt(base)=1	!no chance ...
c
	k=1					!start at field 1
	dl=1					!display line (temp. = 1)
200	continue
	read(chn,'(i9,'':'',i9,i9,i3,i3)',end=201,err=90014)
     1        ds$fld(dl,k,base),
     1        ds$pos(dl,k,base),
     1        ds$siz(dl,k,base),
     1        ds$how(dl,k,base),
     1        ds$jus(dl,k,base)
	k=k+1
	goto 200
201	continue
	ds$fld(dl,k,base)=-2
202	continue
	ds$def(base)=2			!use defined display
c
	goto 900			!return
c
	elseif (comma) then
c	===================
c
300	continue
c
	   lim1=1
c
302	      continue
c
	      read (chn,'(a)',end=301,err=90014) mssg(lim1:)
	      lim2=istrip_(mssg(lim1:))
	      if (lim2.le.0) then
c	         ok, proceed
	      else
	         last=lim1+lim2-1
	         if (mssg(last:last).eq.cmcont) then	!cont. character
	            mssg(last:last)=' '
	            lim1=last+1
	            goto 302			!carry on
	         endif
	      endif
c
	   call i$stcm_(mssg,erro)	!store command into buffer
	   if (erro.ne.0) goto 95000	!fatal error
	   goto 300			!loop for more
c
301	continue
c
	goto 900			!return
c
	endif
c	=====
c
	goto 900			!return
c
c	Return
c	======
c
900	continue
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)
	   chn=0
	endif
c
	if (tmpsiz.gt.0) then
	   call free_vm_(tmpsiz,tmpbit,noerr)
	endif
c
	return
c
c	Warnings
c	--------
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	d$edit=1
	goto 99000			!give error message and return
c	syntax error-unexpected eol
90002	continue
	mark=p1
	erro=2
	d$edit=1
	goto 99000			!give error message and return
c	syntax error-illegal word
90003	continue
	mark=p1
	erro=3
	d$edit=1
	goto 99000			!give error message and return
c	unknown keyword
90004	continue
	mark=p1
	erro=4
	d$edit=1
	goto 99000			!give error message and return
c	ambiguous keyword
90005	continue
	mark=p1
	erro=5
	d$edit=1
	goto 99000			!give error message and return
c	too few characters in keyword
90006	continue
	mark=p1
	erro=6
	d$edit=1
	goto 99000			!give error message and return
c	unexpected keyword
90007	continue
	mark=p1
	erro=7
	d$edit=1
	goto 99000			!give error message and return
c	eol expected
90008	continue
	mark=p1
	erro=8
	d$edit=1
	goto 99000			!give error message and return
c	no current data base
90009	continue
	mark=0
	erro=9
	goto 99000			!give error message and return
c	not a SAVE file
90010	continue
	mark=0
	erro=10
	goto 99000			!give error message and return
c	SAVE file for a diferent base
90011	continue
	mark=0
	erro=11
	goto 99000			!give error message and return
c	never happens, lost the bit map
90012	continue
	mark=0
	erro=13
	goto 99000			!give error message and return
c	no more i/o channels
90013	continue
	mark=0
	erro=13
	goto 99000			!give error message and return
c	problems reading input file
90014	continue
	d$rinf=fname			!tell him which file
	mark=0
	erro=14
	goto 99000			!give error message and return
c	problems writing temporary sort file
90015	continue
	mark=0
	erro=15
	goto 99000			!give error message and return
c	memory allocation failure
90016	continue
	mark=0
	erro=16
	goto 99000			!give error message and return
c	can't restore sort, search and sort don't match!
90017	continue
	mark=0
	erro=17
	goto 99000			!give error message and return
c
c	Display my error message (?...) and return
c	==========================================
99000	continue
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('R$ESTO',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	else
	   call errset_('R$ESTO',erro)
	endif
c
	if (chn.gt.0) then
	   close(chn)
	   call freec_(chn)
	   chn=0
	endif
c
	if (tmpsiz.gt.0) then
	   call free_vm_(tmpsiz,tmpbit,noerr)
	endif
c
	return
c
c	inherited errors
c
95000	continue
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)
	   chn=0
	endif
c
	if (tmpsiz.gt.0) then
	   call free_vm_(tmpsiz,tmpbit,noerr)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:restor.fmt'
c
	end
c
c
c
c
	subroutine S$AVE_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements SAVE command:
c
c	*****	SAVE SEARCH/SORT/DISPLAY/COMMANDS FROM <file.ext>
c
c	This command saves current search/sort/display of current data base
c	(or the DBAG command buffer) to disk file FILE.EXT.
c
c	Note that, as a current sort is ALWAYS an ordered way of accesing a
c	current search, the commands restore search and restore sort have the
c	same result when the the current search is sorted.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbaga2.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,l,lim,p1,p2,erro
	real rval
	logical sear,sor,displ,comma,trunc
	integer base,what,npos1,k
	character*60 fname
	character*12 ext
c
c	begin
c	=====
c
	call errclr_('S$AVE')		!error init
c
	erro=0
c
	sear=.false.
	sor=.false.
	displ=.false.
	comma=.false.
c
c	try to get keyword (SEARCH, SORT, DISPLAY or COMMANDS)
c	------------------------------------------------------
c
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.eq.0) then
	   goto 90002			!syntax error (abrupt eol)
	elseif (type.ne.1) then
	   goto 90003			!syntax error (illegal token)
	endif
	npos1=p2+1
c
c	got a keyword, check if SEARCH, SORT or DISPLAY
c	-----------------------------------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90004			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90005			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90006			!syntax error (too few char.)
	elseif (keypos.eq.searky) then
	   sear=.true.			!found SEARCH
	elseif (keypos.eq.sortky) then
	   sor=.true.			!found SORT
	elseif (keypos.eq.dispky) then
	   displ=.true.			!found DISPLAY
	elseif (keypos.eq.commky) then
	   comma=.true.			!found COMMANDS
	else
	   goto 90007			!syntax error (bad keyword)
	endif
c
c	try to get keyword (TO)
c	-----------------------
c
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001			!illegal character
	elseif (type.eq.0) then
c
	   if (d$itrv.eq.1) then	!interactive, proceed
	      buf(npos1:)=' TO '
	      npos1=npos1+4
234	      continue
	      write(mssg,10000)			!be nice, ask for filespec
	      call i$mess_(0,d$cmdo,0,mssg,0,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      erro=0
	      call inline_(d$cmdi,buf(npos1:),lim,cmcont,
     1                     trunc,erro)		!get filespec
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!fatal error
	         call errclr_('S$AVE')		!clear error
	         goto 234			!loop back
	      endif
	      if (trunc) then
	         write (mssg,10002)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!fatal error
	      endif
	      call rstok_(buf,npos1,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      goto 5
	   else					!non-interactive
	      goto 90002			!unexpected eol
	   endif
c
	elseif (type.ne.1) then
	   goto 90003				!syntax error (illegal token)
	endif
c
c	got a keyword, check if TO
c	--------------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90004			!syntax error (unknown keyword)
	elseif (keypos.eq.-1) then
	   goto 90005			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90006			!syntax error (too few char.)
	elseif (keypos.ne.toky) then
	   goto 90007			!syntax error (bad keyword)
	else
c	   ok				!found TO !
	endif
c
c	try to get <filespec>
c	---------------------
c
5	continue
	call infspc_(type,what,fname,ext,
     1              val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90001				!illegal character
	elseif (type.eq.0) then
c
	   if (d$itrv.eq.1) then		!interactive, proceed
345	      continue
	      write(mssg,10001)			!be nice, ask for filespec
	      call i$mess_(0,d$cmdo,0,mssg,0,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      erro=0
	      call inline_(d$cmdi,buf(npos1:),lim,cmcont,
     1                     trunc,erro)		!get filespec
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!fatal error
	         call errclr_('S$AVE')		!clear error
	         goto 345			!loop back
	      endif
	      if (trunc) then
	         write (mssg,10002)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!fatal error
	      endif
	      call rstok_(buf,npos1,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      goto 5				!re-submit
	   else					!non-interactive
	      goto 90002			!unexpected eol
	   endif
c
	elseif (type.ne.36) then
	   goto 90003				!syntax error (illegal token)
	endif
c
c	see if line is clean
c	--------------------
c
	npos1=p2
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.ne.0) goto 90008		!syntax error (eol expected)
c
c	Complete command (if SAVE DISPLAY ! SEARCH ! SORT)
c	--------------------------------------------------
c
	if (displ.or.sear.or.sor) then
	   if (c$base.le.0) goto 90009		!no current base, give up
	   base=c$base
	endif
c
c	Execute command
c	---------------
c
c	check file.ext
c
	call givext_(fname,ext)			!add extension
	call chkext_(fname,erro)		!check extension
	if (erro.ne.0) then
	   if (d$itrv.eq.1) then		!interactive
	      call errmsg_('CHKEXT',erro,mssg,'%')
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      call errclr_('S$AVE')		!clear error
	      d$edit=1				!set edit mode
	      mark=0				!...
	      goto 900				!and return
	   else					!non-interactive
	      goto 900				!just return
	   endif
	endif
c
	call i$save_(base,sear,sor,displ,comma,fname,buf(1:npos1),erro)
	if (erro.ne.0) goto 95000		!show error
c
	goto 900				!and return
c
c	Return
c	======
c
900	continue
c
	return
c
c	Warnings
c	--------
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	d$edit=1
	goto 99000			!give error message and return
c	syntax error-unexpected eol
90002	continue
	mark=p1
	erro=2
	d$edit=1
	goto 99000			!give error message and return
c	syntax error-illegal word
90003	continue
	mark=p1
	erro=3
	d$edit=1
	goto 99000			!give error message and return
c	unknown keyword
90004	continue
	mark=p1
	erro=4
	d$edit=1
	goto 99000			!give error message and return
c	ambiguous keyword
90005	continue
	mark=p1
	erro=5
	d$edit=1
	goto 99000			!give error message and return
c	too few characters in keyword
90006	continue
	mark=p1
	erro=6
	d$edit=1
	goto 99000			!give error message and return
c	unexpected keyword
90007	continue
	mark=p1
	erro=7
	d$edit=1
	goto 99000			!give error message and return
c	eol expected
90008	continue
	mark=p1
	erro=8
	d$edit=1
	goto 99000			!give error message and return
c	no current data base
90009	continue
	mark=0
	erro=9
	goto 99000			!give error message and return
c
c	Display my error message (?...) and return
c	==========================================
99000	continue
c
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('S$AVE',erro,mssg,'?')
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	else
	   call errset_('S$AVE',erro)
	endif
c
	return
c
c	Display others error message (?...) and return
c	==============================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   mark=0
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:save.fmt'
c
	end
c
c
c
c
	subroutine Z$ERO_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements ZERO command:
c
c	*****	ZERO DATABASE <database> or ZERO FILES <database>
c
c	Database with logical name <database> is zeroed (all records will be
c	ignored after command execution) and closed if open.
c
c	!!! Disk space isn't returned to the monitor !!!.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagsr.own'
c
	external istrip_,trim_
	integer istrip_,trim_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,size
	real rval
	integer count,answr
	character*12 bname
	integer k,l,okrec,klrec,io,dbflen,ndata,nfiles,berr,ferr,
	1	father,prop
	logical delete,refer,defprop,defseries,defmemo,aliens,empty,opn
	character*30 race
	integer	irace,idim,isize,ideci
c
c	begin
c	=====
c
	call errclr_('Z$ERO')		!error init
c
	ndata=0				!# of [DATABASE ...]
	nfiles=0			!# of [FILES ...]
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
	if (type.eq.0) goto 200		!eol, check/execute ZERO command
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.fileky)  then
	   nfiles=nfiles+1		!count it
	   goto 100			!"eat" FILES <database>
	elseif (keypos.eq.dataky)  then
	   ndata=ndata+1		!count it
	   goto 100			!"eat" DATABASE <database>
	else
	   goto 90008			!unexpected keyword
	endif
c
c	Here to "eat" [DATABASE/FILES ...]
c	----------------------------------
c
100	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90006			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10006) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!next keyword
c
c	>>>>>> ZERO DATABASE <database>
c	===============================
c
200	continue
c
c	Check ZERO command
c	------------------
c
c	check duplicate requests in command
c
	if (nfiles.gt.1) goto 90010	!duplicate requests
	if (ndata.gt.1) goto 90010	!duplicate requests
	if (nfiles.gt.0.and.
	1   ndata.gt.0      ) goto 90010!duplicate requests
	if (nfiles.le.0.and.
	1   ndata .le.0     ) goto 90011!keyword FILES/DATABASE not seen
c
	mode=0
	update=1
	call open_(base,bname,update,mode,opn,erro)	!try to open it
	if (erro.ne.0) then
	   if (d$rsub.eq.'OPNBAS'.and.			!OPNBAS errors
     1         erro.eq.18          ) then		!version 0 and update
c	      ok, let him zero the base
	   else
	      goto 95000				!show error
	   endif
	endif
c
	if (d$prt(base).ne.0) then		!protection ON
	   do k = 1, d$nfld(base)		!see if protected fields
	      if (d$prfl(k,base).ne.prtrw) then
	         goto 90012			!sorry, can't zero
	      endif
	   enddo
	endif
c
c	Used by someone ?
c
	call i$odb_(base,berr,ferr,refer,erro)	!is base used as o.d.b ?
	if (erro.ne.0) return			!error, carry
	if (refer) goto 90013			!can't close base
c
c	Non-empty creatures ?
c
	update=-1				!don't change
	call opncrt_(base,update,defprop,defseries,defmemo,erro)
	if (erro.ne.0) goto 95000		!show error
c
	aliens=.false.				!ass. no aliens or empty aliens
	if (defprop) then
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.p$) then	!property
	         prop=d$dbio(k,base)		!prop channel
	         if (prop.gt.0) then
	            father=pp$fat(prop)		!link to owner
	            call inqx_(prop,father,empty,erro)
	            if (erro.ne.0) goto 95000	!show error
	            if (empty) then
c	               ok, no entry on index file
	            else
	               if (d$itrv.eq.1) then	!interactive
	                  write (mssg,10008) d$fnam(k,base)
	                  call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	                  if (erro.ne.0) goto 900!error, carry
	               endif
	               aliens=.true.		!remember that
	            endif
	         endif
	      endif
	   enddo
	endif
	if (defseries) then

	endif
	if (defmemo) then

	endif
c
	if (aliens) then
	   goto 90014		!can't zero base
	endif
c
c	Confirm it, just in case...
c
	if (s$set(s$conf)) then
c
	   call zrec2_(base,okrec,klrec,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   count=okrec+klrec
c
	   if (count.le.0) goto 90009			!already empty
c
	   call zrace_(base,race,irace,idim,isize,ideci,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   write (mssg(1:),10001)
     1                    race(1:istrip_(race)),
     1                    d$unam(base)(1:istrip_(d$unam(base))),
     1                    d$bfil(base)(1:istrip_(d$bfil(base)))
	   call i$mess_(0,d$cmdo,1,mssg,1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   lim=istrip_(d$bdes(base))
	   if (lim.le.0) then
	      lim=1
	      d$bdes(base)=' '
	   endif
	   write (mssg(1:),10002) d$bdes(base)(1:lim)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
c
	   if (irace.eq.r$b) then			!regular base
	      if (erro.ne.0) goto 900			!error, carry
	      write (mssg(1:),10005) okrec		!alive records
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      write (mssg(1:),10007) klrec		!alive records
	      call i$mess_(0,d$cmdo,-1,mssg,1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
710	   continue
c
	   write (mssg(1:),10003)			!ok(y/n)
	   call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
	   call i$yn_(answr,erro)			!accept y/n
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')	!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, return
	      call errclr_('Z$ERO')			!clear error
	      goto 710					!loop back
	   endif
c
	else						!blind guy
c
	   answr=1					!proceed ...
c
	endif
c
	if (answr.eq.5) goto 710	!'??????', loop back
	if (answr.eq.4) goto 710	!comment line
	if (answr.eq.2.or.answr.eq.3) then!'N' or ^Z, close base and return
	   call close_(base,erro)		!close base
	   if (erro.ne.0) then
	      call errclr_('Z$ERO')	!clear error
	   endif
	   goto 900
	endif
c
c	1 = 'Y', zero database
c
c	   First, forget all records
c	   -------------------------
c
	   io=d$bio(base)				!.DBF i/o channel
	   dbflen=d$recl(base)				!and record lenght
c
	   d$last(base)=d$unus				!update memory context
	   d$froz(base)=0
	   d$head(base)=0
	   d$tail(base)=0
	   d$kill(base)=0
	   d$opr(base)=0
	   d$opw(base)=0
c
	   d$xbuf(1:)=' '				!and .dbf file
c
	   write(d$xbuf(1:),'(i10)')d$last(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=3,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$tail(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=4,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$kill(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=6,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$opr(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=8,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$opw(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=9,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$head(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=34,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$froz(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (io,rec=35,fmt='(a)',err=90003) d$xbuf(1:dbflen)
c
c	   Delete all files related to data base now
c	   -----------------------------------------
c
	   delete=.false.			!data base will not be deleted
	   call i$delf_(base,delete,erro)
	   if (erro.ne.0) goto 900			!error, carry
c
c	   Inform user
c	   -----------
c
	   if (d$itrv.eq.1) then			!interactive
	      write (mssg(1:),10004) d$unam(base)(1:istrip_(d$unam(base))),
     1                       d$bfil(base)(1:istrip_(d$bfil(base)))
	      call i$mess_(0,d$cmdo,1,mssg,1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
	   call close_(base,erro)			!close base
	   if (erro.ne.0) goto 900			!error, carry
c
	goto 900					!return in any case
c
c
c	           R   E   T   U   R   N
c	======================================================
c
900	continue
c
	return
c
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	keyword DATABASE expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	problems writing .DBF file
90003	continue
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	data base name expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	unexpected keyword
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	data base already empty
90009	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=9
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	FILES/DATABASE keyword not seen
90011	continue
	erro=11
	goto 99000			!display error and return properly
c	Protected fields, can't zero
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	field used as o.d.b. by someone, can't zero base
90013	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(berr)			!tell him witch base
	erro=13
	goto 99000				!display error
c	At least one non-empty creature, can't zero base
90014	continue
	erro=14
	goto 99000			!display error and return properly
c
c	Display error message (?...), deallocate any memory and return
c	==============================================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('Z$ERO',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('Z$ERO',erro)
	endif
c
	return
c
c	Display others error message (?...), deallocate any memory and return
c	=====================================================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:zero.fmt'
c
	end
c
c
c
c
	subroutine N$OIND_(buf,mark)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements NOINDEX command, by calling common procedure I$XNOX
c	(RE)INDEX command uses same procedure).
c
c	var
c	===
c
	integer who, erro
c
c	begin
c	=====
c
	call errclr_('N$OIND')		!error init
c
	who=3				!NOINDEX calling you...
	call I$XNOX_ (buf,mark,who)	!execute (RE)INDEX/NOINDEX command
c
	return				!return to main loop
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine P$AUSE_(buf,mark)
c	****************************
c
	implicit none
c
	character*(*) buf
	integer mark
c
c	Description
c	===========
c
c	Implements PAUSE command:
c
c	This command pauses DBAG command execution and waits for any key
c	stroke to resume (abort if ESC), if executing @file and TALKing
c	ON. No-op if not.
c
c	var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagB.OWN'
c
	external tty_getc_
	integer tty_getc_
	integer char,erro
c
c	begin
c	=====
c
	call errclr_('P$AUSE')			!clear errors
c
c
	if (at$lvl.le.0.or.
     1      .not.s$set(s$talk).or.		!care @ activity, batch
     1      us$bat                ) return	!and TALK status
c
	mssg(1:)=' '
	write (mssg(35:80),10001)			!PAUSE... message
	call vtext_(mssg(1:80),24,1,0)
c
	char=tty_getc_()				!wait for key stroke
c
	call erase_line_(24,1)			!clean line
c
	if (char.eq.ttabor1.or.
	1   char.eq.ttabor2    ) then
cwhile	   do while (at$lvl.gt.0)			!for all active @files
1098	   continue
	      if (at$lvl.le.0) goto 1099
c
	      call i$atup_(erro)			!"go up"
	      if (erro.ne.0) return			!error, carry
c
	      goto 1098
1099	   continue
cwhile	   enddo
	endif
c
	return						!return in any case
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Give error message (?...) and return
c	====================================
99000	continue
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('P$AUSE',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('P$AUSE',erro)
	endif
	return					!return
c
c	Formats
c	=======
c
	include 'fmt:pause.fmt'
c
	end
c
c
c
c
