	subroutine opnaln_(prop,alname,update,error)
c	********************************************
c	Written by Paulo Alexandre Gonalves,18/12/1987
c
	implicit none
c
c	Input
c	=====
	character*(*) alname			!Name of the creature
	integer update			
c
c	Output
c	======
	integer prop				!channel to seq
	integer error
c
c	Description
c	===========
c
c	Performs the open of the "alien" ALNAME.
c	Open the owner base and fill the base channel.
c
c			= se serie de reais, tamanho global pelo menos = 4
c
c			= se serie de dd's, tamanho global pelo menos = 8
c
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	external istrip_
	integer istrip_
	integer mode,bb,fidx,ir,myupd,alndim,alf1,alnf,k
	character*60 owname
	logical newopn
c
	integer father,next,last	!father, next, last position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('OPNALN')
	error=0				!clear error
c
	mode=0
	call open_(prop,alname,update,mode,newopn,error)
	if (error.ne.0) goto 95000	!error, carry
c
c	Check alien structure
c
	ir=d$race(prop)			!race of it
	if (ir.eq.r$b0.or.		!base "old style"
	1   ir.eq.r$b     ) goto 90004
c
	pp$fat(prop)=d$nfld(prop)-2	!father position
	pp$nxt(prop)=d$nfld(prop)-1	!next position
	pp$lst(prop)=d$nfld(prop)	!last position
	father=pp$fat(prop)
	next=pp$nxt(prop)
	last=pp$lst(prop)
c
	d$u1st(prop)=1			!first data field
	alf1=d$u1st(prop)		!same
	d$udnf(prop)=d$nfld(prop)-3	!number of data fields
	alnf=d$udnf(prop)		!same
	alndim=d$pdim(prop)		!dimension of creature
c
	if (alnf.le.0) goto 90005	!no data field
c
	if (ir.ne.r$pp.and.
	1   alndim.le.0) goto 90005	!bad dimension
	if (ir.eq.r$sr.and.
	1   alndim.lt.4) goto 90005	!not big enough
	if (ir.eq.r$sr8.and.
	1   alndim.lt.8) goto 90005	!not big enough
	if (alndim.eq.2.and.
	1   alnf.lt.2       ) goto 90005!wrong structure	
	if (alndim.eq.3.and.
	1   alnf.lt.3       ) goto 90005!wrong structure	
c
	if (alndim.gt.1) then
	   if (alndim.eq.2) then
	      if (d$siz(alf1,prop).lt.10) goto 90005
	   endif
	   if (alndim.eq.3) then
	      if (d$siz(alf1,prop).lt.10.or.
	1         d$siz(alf1+1,prop).lt.10) goto 90005
	   endif
	endif
c
	if (d$siz(father,prop).lt.10.or.!size=10
	1   d$siz(next,prop).lt.10.or.
	1   d$siz(last,prop).lt.10.or.
	1   d$type(father,prop).ne.lk$.or.!type=lk$ (link)
	1   d$type(next,prop).ne.lk$.or.
	1   d$type(next,prop).ne.lk$    ) then
	   goto 90005			!wrong structure
	endif
c
	do k = alf1,alf1+alnf-1
	   if (d$siz(k,prop).lt.d$pdim(prop)) goto 90005
	enddo
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)	!(Re)open index
	   if (error.ne.0) then
	      if (d$itrv.eq.1) then		!interactive
	         goto 90001
	      else
                 goto 95000
	      endif
	   endif
	endif
c
c	Open owner base and fill in base channel
c
	if (update.eq.0) then
	   myupd=-1				!don't change owner base mode
	else
	   myupd=update				!same mode
	endif
c
	owname(1:)=' '
	owname=d$ownb(prop)			!open owner base
	mode=0					!usual mode
	call open_(bb,owname,myupd,mode,newopn,error)
	if (error.ne.0) goto 90002		!can't
	call znum_(bb,fidx,alname,error)	!field number
	if (error.ne.0) goto 90003		!??? not there ???
	d$dbio(fidx,bb)=prop			!base channel
c
	goto 100
c
c	Return
c
100	return
c
c	errors
c	======
c
c	Can't open "father" indexes
90001	continue
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=1
	goto 99000
c	Can't open owner base
90002	continue
	d$rinf(1:10)='owner base'
	d$rinf(12:)=owname
	d$rinf(istrip_(d$rinf)+1:)=','
	d$rinf(istrip_(d$rinf)+2:)=alname
	error=2
	goto 99000
c	???No such creature in owner base???
90003	continue
	d$rinf(1:10)='owner base'
	d$rinf(12:)=owname
	d$rinf(istrip_(d$rinf)+1:)=','
	d$rinf(istrip_(d$rinf)+2:)=alname
	error=3
	goto 99000
c	It's a regular base
90004	continue
	d$rinf=alname
	error=4
	goto 99000
c	Wrong dimension or field(s) size or links size/type
90005	continue
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=5
	goto 99000
c
99000	continue
	call errset_('OPNALN',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine clsaln_(prop,error)
c	******************************
c	Written by Paulo Alexandre Gonalves,20/11/1987
c
	implicit none
c
c	Input
c	=====
	integer prop				!channel of associated base
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c	Closes the database associated to the sequence.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	character*12 tmpint		!temp
	integer lim1
c
	integer father		!father position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('CLSALN')
	error=0					!clear error
c
	father=pp$fat(prop)		!father position
c
	if (d$ixio(father,prop).gt.0) then
	   call clsx_(prop,father,error)	!Close index if not yet
	   if (error.ne.0) then
	      call errclr_('CLSALN')		!ignore error
	      error=0
	   endif
	endif
c
	call clsbas_(prop,error)
	if (error.ne.0) then
	   call errclr_('CLSALN')		!ignore error
	   error=0
	endif
c
c	Other's error
c	=============
c
95000	continue
c
	return
c
	end
c
c
c
c
