c	DBAGB.FOR
c	*********
c
c	Internal procedures used by DBAG interactive commands (module
c	DBAGA). Procedures names are I$????:
c
c	I$ATDW  (atfile, erro)				increase @ level
c	I$ATUP  (erro)					decrease @ level
c	I$BCUR						display current bases
c	I$BFRE  (base,   buf,     erro)			ask base slot to free
c	I$BINI	(base,...)				init SEARCH bitmap
c	I$BUSE	(base,   update,  mode,   buf,  erro)	ask base to set "inuse"
c	I$CNVD	(text,ind,width,outd,rval,error)	convert "text" to decim
c	I$DL	(mark,buf,who)				implement DISPLAY/LIST
c	I$DREC	(base,for,wait, off, mode,first,erro)	display/list records
c	I$DSTA  (wait     ,erro)			display/list status
c	I$DSTR  (buf,     full,   wait,    erro)	display/list structure
c	I$GOTO  (recnum)				GOTO <recnum>
c	I$MESS	(mark,io,before,text,after,error)	output mark/mess to io
c	I$RUSE  (recnum,  buf,    erro)			ask rec. to set current
c	I$SAVE						execute SAVE command
c	I$SCUR	(base,record,field,error)		set current indicators
c	I$SPRV  (record,field)				set previous indicators
c	I$WAIT	(line,    erro)				<waiting...> message
c	I$WLIN
c
c
	subroutine I$ATDW_(atfile,erro)
c	*******************************
c
	implicit none
c
	character*(*) atfile
	integer erro
c
c	Description
c	===========
c
c	This procedure increases @ level by opening @ file, repositioning
c	d$cmdi to the new channel, and updating @ stack and @ level.
c	ERRO not =0 if @ file not found or no i/o channel available or
c	@ stack overflow.
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer long, io
	logical ok
c
	call errclr_('I$ATDW')
	erro=0				!clear error
c
	if (at$lvl.ge.at$max) then
	   goto 90002			!@ stack exhausted
	else
	   call newc_(io)
	   if (io.le.0) then
	      goto 90003		!no more i/o channels
	   else
	      inquire (file=atfile, recl=long, exist=ok)
	      if (.not.ok) then
	         goto 90001		!no such file
	      endif
	   endif
	endif
c
	open (unit=io, file=atfile, status='old', recl=long,
     1        readonly, err=90004)
c
	d$cmdi=io			!assign i/o channel
	at$lvl=at$lvl+1			!increase level
	at$stk(at$lvl)=io		!store i/o
c
	return				!return
c
c	Errors
c	======
c
90001	continue			!@ file not found
	d$rinf=atfile
	erro=1
	goto 99000
90002	continue			!@ stack overflow
	erro=2
	goto 99000
90003	continue			!no i/o channel available
	erro=3
	goto 99000
90004	continue			!error opening @file
	d$rinf=atfile
	erro=4
	goto 99000
99000	continue
	call errset_('I$ATDW',erro)	!set error
	return				!and return
c
c	Formats
c	-------
c
	end
c
c
c
c
	subroutine I$ATUP_(erro)
c	***********************
c
	implicit none
c
	integer erro
c
c	Description
c	===========
c
c	This procedure decreases @ level by closing current @ i/o channel and
c	repositioning d$cmdi to previous channel, if any, or to 5 (tt:) if
c	none.
c	ERRO not =0 if no previous channel or zero/tt channel or inconsistency.
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer io
c
	call errclr_('I$ATUP')
	erro=0				!clear error
c
	if (at$lvl.lt.1) then
	   goto 90001			!no active @ channel
	else
	   if (d$cmdi.eq.0.or.
     1         d$cmdi.eq.tti.or.
     1         d$cmdi.ne.at$stk(at$lvl)) then
	      goto 90002			!active @ channel = 0 or tt: or
						!inconsistent
	   endif
	endif
c
	close (unit=d$cmdi)			!close current @ file
	call freec_(d$cmdi)
	at$lvl=at$lvl-1				!decrease level
c
	if (at$lvl.le.0) then
	   d$cmdi=tti				!back to tt:
	   open (unit=d$cmdi, file=ttinam, recl=d$cmds,
     1           status='unknown', err=90003)
	else
	   d$cmdi=at$stk(at$lvl)		!previous @ file channel
	endif
c
	return					!return
c
c	Errors
c	======
c
90001	continue			!no active @ channel
	erro=1
	goto 99000
90002	continue			!? @ channel = 0 or tt: or inconsistency
	erro=2
	goto 99000
90003	continue			!error opening tt:
	erro=3
	goto 99000
99000	continue
	call errset_('I$ATUP',erro)	!set error
	return				!and return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$BFRE_(base,bname,erro)
c	**********************************
c
	implicit none
c
	character*(*) bname
	integer base, erro
c
c	Description
c	===========
c
c	This procedure asks user base name to be removed from memory context,
c	so space can be used later. Removed base is returned in BASE.
c	!!! It should be called only when all base slots are already in use,
c	    otherwise makes no sense !!!
c
c	erro	= 0 ok
c		> 0 error occured
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer type,val,dec,lim,p1,p2,line,fchan
	real rval
	logical wait,trunc
c
	call errclr_('I$BFRE')
	erro=0				!clear error
c
c	display current bases
c	---------------------
c
	line=0
	write (mssg,10001)
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) return		!fatal error, carry
	line=line+2
	wait=.false.			!don't wait
	fchan=0				!output to terminal
	call i$bcur_(fchan,wait,line,erro)
	if (erro.ne.0) return		!abort/error, return/carry
c
c	ask for database to close
c	-------------------------
c
100	continue				!loop here to get file name
c
	call errclr_('I$BFRE')			!clear error (loop here...)
	erro=0
	base=0					!clear base
	write (mssg,10002)			!prompt for database name
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!fatal error, carry
c
	erro=0
	call inline_(d$cmdi,bname,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$BFRE')		!clear error
	   erro=0
	   goto 100				!loop back
	endif
	call i$mess_(0,0,-1,bname,-1,erro)
	if (erro.ne.0) return			!error, carry
c
	if (trunc) then				!line too long, truncated
	   write (mssg,10003)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0) then
	   return					!return (eol)
	elseif (lim.eq.-1) then
	   goto 400					!^Z or eo@f
	elseif (lim.eq.-2) then
	   goto 100					!comment line, go back
	endif
c
	erro=0
	call rstok_(bname,1,erro)
	call intok_(type,val,dec,rval,bname,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=1					!illegal character
	   call errmsg_('I$BFRE',erro,mssg,'%')		!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!fatal error, carry
	   goto 100					!loop back
	elseif (type.ne.1) then
	   erro=2					!no identifier
	   call errmsg_('I$BFRE',erro,mssg,'%')		!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!fatal error, carry
	   goto 100					!loop back
	endif
c
c	see if in memory
c	----------------
c
	call uc_(bname(p1:p2))				!upper case
	call zbnum_(base,bname(p1:p2),erro)		!get base channel
	if (erro.ne.0) return				!fatal error, return
	if (base.eq.0) then
	   erro=3					!not found in memory
	   call errmsg_('I$BFRE',erro,mssg,'%')		!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!fatal error, return
	   goto 100					!loop back
	endif
c
c	close database and return always
c	--------------------------------
c
200	continue
c
	call close_(base,erro)			!close base
	if (erro.ne.0) then
	   call errclr_('I$BFRE')		!clear error
	   erro=0
	endif
c
	return
c
400	continue				!^Z or end-of-@file
	if (at$lvl.le.0) then
	   erro=4				!^Z found
	   goto 99000				!go display message (be nice)
	else
	   call i$atup_(erro)			!end of @file, go up
	   return				!return anyway
	endif
c
c	Errors
c	======
99000	continue
	call errmsg_('I$BFRE',erro,mssg,'%')	!get message
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	return					!and return
c
c	Formats
c	=======
c
	include 'fmt:ibfre.fmt'
c
	end
c
c
c
c
	subroutine I$BUSE_(base,update,mode,bname,erro)
c	**********************************************
c
	implicit none
c
	character*(*) bname
	integer base, update, mode, erro
c
c	Description
c	===========
c
c	This procedure returns BASE as current database, with specified UPDATE,
c	if some already current or if user supplied a valid one; returns 0 if
c	none current and user didn't specify any.
c	Remember that if UPDATE=-1,update mode of existent base is not changed.
c	The base returned as current will be open with both UPDATE and MODE as
c	specified when entering this procedure.
c
c	Erro:	= 0	ok
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer type,val,dec,lim,p1,p2
	real rval
	integer l,alive,zf,okrec,bmsize,noerr
	logical opn,trunc
	character*1 space/' '/
c
c	begin
c	=====
c
	call errclr_('I$BUSE')
	erro=0				!clear error
c
	if (c$base.le.0.and.		!no base current
     1      d$itrv.eq.0    ) then	!and non-interactive
	   erro=4
	   goto 99000			!go set error
	endif
c
	opn=.false.
	bname(1:)=' '			!clear database name
	call i$sprv_(c$base,c$rec,c$fld)!save current as previous
c
	if (c$base.ne.0) then
	   base=c$base				!some base already current
	   bname(1:)=d$unam(base)(1:)		!return name
	   call open_(base,bname,update,mode,opn,erro)
	   goto 200				!check "open"
	endif
c
c	ask for database to make current
c	--------------------------------
c
100	continue				!loop here to get file name
c
	call errclr_('I$BUSE')			!clear error (loop here...)
	erro=0
	base=0					!clear base
	bname(1:)=' '				!and base name
	write (mssg,10001)			!prompt for file name
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
c
	erro=0
	call inline_(d$cmdi,bname,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$BUSE')		!clear error
	   erro=0
	   goto 100				!loop back
	endif
	call i$mess_(0,0,-1,bname,-1,erro)
	if (erro.ne.0) return			!fatal error, carry
c
	if (trunc) then				!line too long, truncated
	   write (mssg,10003)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0) then
	   return					!return (eol)
	elseif (lim.eq.-1) then
	   goto 400
	elseif (lim.eq.-2) then
	   goto 100					!comment line, go back
	endif
c
	erro=0
	call rstok_(bname,1,erro)
	call intok_(type,val,dec,rval,bname,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=1					!illegal character
	   call errmsg_('I$BUSE',erro,mssg,'%')		!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!fatal error, carry
	   goto 100					!loop back
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   erro=2					!no identifier
	   call errmsg_('I$BUSE',erro,mssg,'%')		!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!fatal error, carry
	   goto 100					!loop back
	endif
c
	l=p2-p1+1
	if (l.gt.9) then
	   l=9
	   write (mssg,10002) space,bname(p1:p1+8)	!truncated to ...
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!fatal error, carry
	endif
c
c	Open database (no current base)
c	-------------------------------
c
	call open_(base,bname(p1:p1+8),update,mode,opn,erro)
	goto 200				!check open
c
c	Complete and check database opening
c	-----------------------------------
c
200	continue
c
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!display it
	   if (erro.eq.0) then
	      call errclr_('I$BUSE')		!clear error if ok
	      erro=0
	      goto 100				!loop back (file name)
	   else
	      return				!error, carry
	   endif
	else
	   if (base.ne.c$base) then
	      call i$scur_(base,0,0)		!set base as the current one
	   endif
	endif
c
c	Inform user
c
	if (opn) then
	   call i$sopn_(base,erro)		!be nice...
	   if (erro.ne.0) return		!error, carry
	endif
c
c	Set new current's
c
	if (opn       .or.				!first open
     1      base.ne.c$base) then			!or none, or new one
	   call zfirst_(base,alive,zf,erro)		!TOP record
	   if (erro.ne.0) return
	   call i$scur_(base,zf,0)
	endif
c
	return						!and return
c
400	continue				!^Z or end-of-@file
	if (at$lvl.le.0) then
	   erro=3				!^Z found
	   goto 99000				!go display message (be nice)
	else
	   call i$atup_(erro)			!end of @file, go up
	   if (erro.ne.0) return		!error, carry
	endif
c
	return
c
c	Errors
c	======
99000	continue
c
	if (d$itrv.eq.1) then		!interactive
	   call errmsg_('I$BUSE',erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	else				!non-interactive
	   call errset_('I$BUSE',erro)
	endif
	return					!and return
c
c	Formats
c	=======
c
	include 'fmt:ibuse.fmt'
c
	end
c
c
c
c
	subroutine I$CNVD_(text,ind,width,outd,rval,intval,error)
c	*********************************************************
c
	implicit none
c
	character*(*) text
	integer ind, width, outd, intval, error
	real rval
c
c	Description
c	===========
c
c	Given  in  TEXT  a  decimal  number , eg "934.58" with IND decimal
c	places ( in  the  example  2), this  procedure  converts  it  into
c	a  normalized  form  with  WIDTH  total  digits  and  OUTD decimal
c	places. Also  a  real  representation   of  the  number  is  given
c	back in RVAL and an integerized version is given in INTVAL (uf...).
c
c	Ex: ('1.283',3,3,2,_,_,error) returns ('128',3,3,2,1.28,128,error)
c	    ('1.283',3,7,2,_,_,error) returns ('    128',3,7,2,1.28,128,error)
c	    ('1.283',3,4,0,_,_,error) returns ('   1',3,4,0,1.0,1,error)
c	    ('1.2',1,6,3,_,_,error)   returns ('  1.200',1,6,3,1.2,1200,error)
c
c	error < 0: truncation occurred
c	      = 0: ok
c	      > 0: unnacceptable value
c			1: (width too small to contain value)
c			2: (total digits > digmax)
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer i, k, l, value, dignbr, myerr
c
c	begin
c	=====
c
	call errclr_('I$CNVD')
	error=0					!clear error
c
	myerr=error
c
c	Get rid of '.' (1.2 -> 12) and count digits
c
	l=istrip_(text)				!read length
	k=0
	dignbr=0
	do 1001 i=1,l
	   if (text(i:i).ne.'.') then
	      dignbr=dignbr+1			!count digits before '.'
	      k=k+1
	      text(k:k)=text(i:i)
	   endif
1001	continue
c
	if ((dignbr).gt.digmax) then		!too many digits
	   myerr=1
	   value=0
	   i=1
	   goto 100				!return
	endif
c
	i=k					!save length
cwhile	do while (k.lt.l)
1098	continue
	if (k.ge.l) goto 1099
c
	   k=k+1
	   text(k:k)=' '
c
	   goto 1098
1099	continue
cwhile	enddo
c
	call rdivar_(text,value,i,error)	!read value as integer
	if (error.ne.0) goto 90001		!read error
c
	if     (ind.gt.outd) then		!truncate
	   value=value/(10.0**(ind-outd))
	   i=i-(ind-outd)
	   myerr=-1
	elseif (outd.gt.ind) then		!try to expand
c
	   if (i+(outd-ind).gt.digmax) then	!can't, too many digits
	      myerr=1
	      value=0
	      i=1
	      goto 100				!return
	   endif
c
	   value=value*(10.0**(outd-ind))		!expand
	   i=i+(outd-ind)
	endif
c
c	check width against #digits (i)
c
	if     (width.lt.i) then		!unnacceptable value (width
						!too small)
	   myerr=1
	   value=0
	   width=1
	endif
c
	call wrivar2_(text,value,width,width,error)	!store result
	if (error.ne.0) goto 90001			!write error
	intval=value
	rval=float(value)/(10.**outd)		!and rval
c
100	continue
c
	error=myerr				!return error
	return
c
c	Errors
c	======
c
c	internal error: read/write error
90001	continue
	error=1
	goto 99000
99000	continue
	call errset_('I$CNVD',error)
	return
c
	end
c
c
c
c
	subroutine I$GOTO_(recnum,erro)
c	*******************************
c
	implicit none
c
	integer recnum, erro
c
c	Description
c	===========
c
c	This procedure sets RECNUM as current record for current base. No-op
c	if no current base. Called from JUNK$R and G$OTO procedures in module
c	DBAGA.
c
c	ERRO NOT=0 if empty base or RECNUM out of TOP-BOTTOM
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
 
c
	integer alive, mytop, mybot
c
	call errclr_('I$GOTO')
	erro=0						!clear error
c
	if (c$base.eq.0) goto 90001			!no current base
c
c	try to find record recnum
c
	call find_(c$base,recnum,alive,d$xbuf,erro)
	if (erro.ne.0) then
	   if (erro.gt.1.and.erro.le.5) then		!"acceptable" errors
     1   
	      call errmsg_(d$rsub,erro,mssg,'%')	!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	      if (erro.ne.0) return			!error, carry
	      call errclr_('I$GOTO')			!clear error
	      erro=0
	      d$edit=1					!set edit mode
	      return					!return
	   else
	      return					!error, carry
	   endif
	endif
c
	if (c$rec.ne.recnum) then
	   call i$sprv_(c$base,c$rec,c$fld)	!save current record/field
	   call i$scur_(c$base,recnum,0)	!set new currents
	endif
c
	return					!return
c
c	Errors
c	------
c
c	No current data base
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$GOTO',erro)
	return
c
	end
c
c
c
c
	subroutine I$MESS_(mark,io,before,text,after,error)
c	***************************************************
c
	implicit none
c
	character*(*) text
	integer mark, io, before, after, error
c
c	Description
c	===========
c
c	This procedure, according to DBAG status, outputs TEXT , in format (a),
c	to channel d$cmdo (users terminal); if the alternate file is on, TEXT
c	is to channel d$alte.
c
c	BEFORE and AFTER blank lines will be output before and after TEXT line.
c
c	IO is usually > 0.
c
c	If AFTER = 0, a prompting is required. Then, the prompt is
c	kept until a call with IO = 0 is performed, to show the entire line if
c	not reading from the terminal.
c
c	If MARK greater than zero, an "^" will be displayed at position MARK+1
c	(tt:) just before TEXT output.
c
c	No output to the terminal will be done if talk is off, or if reading
c	from @file and echo is off.
c
c	ERROR not = 0 if write error occured.
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*1 ttline*(d$cmds+10), kkline*(d$cmds+10)
	logical atfile,echo,alte,talk,showpr
	integer width,ttidx/1/,k,ttsize,lstpos,ttecho,kkidx,ttmax,pos1,pos2
c
	call errclr_('I$MESS')
	error=0						!clear error
c
	call ttwdth_(width)				!current terminal width
	ttmax=len(ttline)				!...
c
	ttsize=istrip_(text)				!text size
	if (ttsize.le.0) ttsize=1
c
	if (after.eq.0) then				!prompting
c
	   ttline(1:)=' '				!forget line
	   ttidx=1
c
	   if (ttsize.gt.1.and.
     1         text(ttsize:ttsize).ne.' '.and.
     1         ttsize.lt.len(text)           ) then
	      ttsize=ttsize+1				!extra space
	   endif
	endif
c
c	Check DBAG status here
c
	if (d$alte.ne.0.and.s$set(s$alte)) then
	   alte=.true.
	else
	   alte=.false.
	endif
c
	if (at$lvl.gt.0) then
	   atfile=.true.
	else
	   atfile=.false.
	endif
c
	if (atfile.and.s$set(s$echo)) then
	   echo=.true.
	else
	   echo=.false.
	endif
c
	if (s$set(s$talk)) then
	   talk=.true.
	else
	   talk=.false.
	endif
c
	if (atfile.and..not.s$set(s$echo)) then
	   talk=.false.		!no talk to the terminal if @level and no echo
	endif
c
	if (.not.talk) then
	   echo=.false.			!TALK OFF supersedes ECHO ON
	endif
c
	if (io.eq.0.and.atfile) then
	   showpr=.true.		!show prompt if any
	else
	   showpr=.false.
	endif
c
	if (mark.gt.0) then
	   kkline(1:)=' '
	   kkidx=mark+d$prsz			!tt:1, + prompt
	   if (kkidx.gt.width) then
	      do 1001 k = d$prsz+1, kkidx - 1	!"     __________^"
	         kkline(k:k)='_'
1001	      continue
	   endif
	   kkline(kkidx:kkidx)='^'
	endif
c
c	save text
c
	if (alte.or.echo) then			!store text
	   lstpos=ttidx+ttsize-1
	   if (lstpos.gt.d$cmds) lstpos=d$cmds	!max line size
	   if (lstpos.gt.ttmax) lstpos=ttmax	!...
	   if (ttidx.gt.lstpos) ttidx=lstpos	!just in case ...
	   ttline(ttidx:lstpos)=text(1:)
	   ttidx=lstpos+1
	endif
c
c	output before lines
c
	do 1002 k = 1, before
	   if (talk) write (d$cmdo,'(1x)',err=90001)
	   if (alte) write (d$alte,'(1x)',err=90002)
1002	continue
c
c	output text
c
	if (kkidx.gt.d$cmds+10) kkidx=d$cmds+10
c
	ttecho=istrip_(ttline)
	if (ttecho.gt.width+1) ttecho=width+1
	if (ttecho.le.1) ttecho=2
c
	if (talk) then
	   if (after.eq.0) then			!prompting
	      if (.not.atfile) write (d$cmdo,'(a,$)',err=90001)
	1                             text(1:ttsize)
	   else					!non-prompting
	      if (showpr)    write (d$cmdo,'(1x,a)',err=90001) ttline(2:ttecho)
	      if (mark.gt.0) then
	         pos1=1
123	         continue
	         pos2=pos1+width-1
	         if (pos2.gt.kkidx) pos2=kkidx
	         write (d$cmdo,'(1x,a)',err=90001) kkline(pos1:pos2)
	         pos1=pos2+1
	         if (pos2.lt.kkidx) goto 123
	      endif
	      if (io.gt.0)   write (d$cmdo,'(a)',err=90001) text(1:ttsize)
	   endif
	endif
c
	if (alte) then
	   if (after.ne.0) then			!non-prompting
	      if (mark.gt.0) then
	         pos1=1
234	         continue
	         pos2=pos1+width-1
	         if (pos2.gt.kkidx) pos2=kkidx
	         write (d$alte,'(a)',err=90002) kkline(pos1:pos2)
	         pos1=pos2+1
	         if (pos2.lt.kkidx) goto 234
	      endif
	      write (d$alte,'(a)',err=90002) ttline(2:ttecho)
	   endif
	endif
c
c	output after lines
c
	do 1003 k = 1, after
	   if (talk) write (d$cmdo,'(1x)',err=90001)
	   if (alte) write (d$alte,'(1x)',err=90002)
1003	continue
c
	if (after.ne.0) then			!non-prompting just done
	   ttline(1:)=' '
	   ttidx=1
	endif
c
	return
c
c	write error on tt:
90001	continue
	error=1
	goto 99000
c	write error on Alternate file
90002	continue
	error=2
	goto 99000
99000	continue
	call errset_('I$MESS',error)
	return
c
	end
c
c
c
c
	subroutine I$RUSE_(recnum,bname,erro)
c	************************************
c
	implicit none
c
	character*(*) bname
	integer recnum, erro
c
c	Description
c	===========
c
c	This procedure returns RECNUM as current record for current base. IF no
c	current base or record and user didn't supply any, returns RECNUM=0.
c
c	Erro:	= 0	ok
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer irec,type,val,dec,lim,p1,p2
	real rval
	logical trunc
c
	call errclr_('I$RUSE')
	erro=0				!clear error
c
	recnum=0			!and current record
c
	if (c$base.eq.0) then
	   return			!return (no current base)
	endif
c
	if (c$rec.ne.0) then
	   recnum=c$rec			!some record already current, return it
	   return
	endif
c
c	ask for "current" record
c	------------------------
c
100	continue				!loop here to get record#
c
	call errclr_('I$RUSE')			!clear error (lopp here...)
	erro=0
	write (mssg,10001)			!prompt for record #
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!fatal error, carry
c
	erro=0
	call inline_(d$cmdi,bname,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$RUSE')		!clear error
	   erro=0
	   goto 100				!loop back
	endif
	call i$mess_(0,0,-1,bname,-1,erro)
	if (erro.ne.0) return			!fatal error, carry
c
	if (trunc) then				!line too long, truncated
	   write (mssg,10003)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0) then
	   return					!return
	elseif (lim.eq.-1) then
	   goto 400					!^Z or eo@f
	elseif (lim.eq.-2) then
	   goto 100					!comment line, go back
	endif
c
	erro=0
	call rstok_(bname,1,erro)
	call intok_(type,recnum,dec,rval,bname,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=1			!illegal character or too many digits
	   call errmsg_('I$RUSE',erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   goto 100				!loop back
	elseif (type.ne.2) then
	   erro=2				!no integer
	   call errmsg_('I$RUSE',erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   goto 100				!loop back
	endif
c
	call ex3in_(c$base,recnum,irec,erro)	!just check recnum
	if (erro.ne.0) then
	   erro=3				!wrong check digit
	   call errmsg_('I$RUSE',erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   goto 100				!loop back
	endif
c
	return					!return
c
c	^Z or end-of-@file
c	------------------
c
400	continue				!^Z or end-of-@file
	if (at$lvl.le.0) then
	   erro=4				!^Z found
	   goto 99000				!go display message (be nice)
	else
	   call i$atup_(erro)			!end of @file, go up
	   return				!return anyway
	endif
c
c	Errors
c	======
99000	continue
	call errmsg_('I$RUSE',erro,mssg,'%')	!get message
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	return					!and return
c
c	Formats
c	=======
c
	include 'fmt:iruse.fmt'
c
	end
c
c
c
c
	subroutine I$SCUR_(base,record,field)
c	*************************************
c
	implicit none
c
	integer base,record,field
c
c	Description
c	===========
c
c	This procedure sets current indicators, informs user about them,
c	and resets cursor to end of screen.
c
c	If HEADER is SET OFF, only resets cursor.
c
c	N.B.:	This procedure SHOULD  be the very last thing to do when
c		executing  an interactive command,  due to  final cursor
c		positionning. However, to allow caller to issue error
c		message even after that, this procedure doesn't change
c		global error flags, just stops if an internal error occurs!!!!!.
c
	include 'own:dbag0.OWN'
	include 'own:dbagB.OWN'
c
	external istrip_, ndigi_
	integer istrip_, ndigi_
	character*132 topmsg
	character*20 fspec
	integer kval,mycrec,width,l,pos,dig,rec,cnt,error
c
	integer
     1   	derro			!error code (warning)
c
	character
     1   	drsub*6,		!procedure that found the error
     1   	drinf*60		!extra info about error
				!(eg "base a23456789, rec#1234567890, fld#123")
c
c	begin
c	=====
c
c	Save global error flags
c
	derro=d$erro			!error code (warning)
c
	drsub(1:)=' '
	drsub=d$rsub			!procedure that found the error
	drinf(1:)=' '
	drinf=d$rinf			!extra info about error
c
	call ttwdth_(width)				!current terminal width
c
	if (base.le.0) then
	   c$base=0					!current base
	   c$rec=0					!   "    record
	   c$fld=0					!   "    field
	else
	   c$base=base					!current base
	   c$rec=record					!   "    record
	   c$fld=field					!   "    field
	endif
c
	if (.not.s$set(s$talk)) goto 900		!if no talk to the
							!terminal, return now
c
	if (at$lvl.gt.0.and..not.s$set(s$echo))
     1   	goto 900				!same if @level and no
							!echo
c
	if (d$itrv.eq.0) goto 900			!non-interactive
c
	if (s$set(s$head)) then
c
	   topmsg(1:)=' '
	   topmsg(2:21)='Current   DATABASE: '
c
	   pos=22
c
	   if (c$base.gt.0) then
	      l=istrip_(d$unam(c$base))			!current database
	      if (l.le.0) then				!empty name
	         c$base=0				!??
	         topmsg(pos:pos+3)='none'		!no current database
	         pos=pos+4
	      else
	         topmsg(pos:pos+l-1)=d$unam(c$base)(1:)
	         pos=pos+l
	      endif
	   else
	      topmsg(pos:pos+3)='none'			!no current database
	      pos=pos+4
	   endif
c
	   topmsg(pos:pos+10)='   RECORD: '
	   pos=pos+11
c
	   if (c$rec.gt.0) then
	      mycrec=c$rec				!current record
	      dig=ndigi_(mycrec)
	      call wrivar_(topmsg(pos:pos+dig-1),mycrec,dig,error)
	      if (error.ne.0) goto 90001		!write error
	      pos=pos+dig
	   else
	      topmsg(pos:pos+3)='none'			!no current record
	      pos=pos+4
	   endif
c
	   topmsg(pos:pos+10)='   SEARCH: '
	   pos=pos+11
c
	   if (c$base.gt.0) then
c
	      if (bitcan(c$base).eq.1) then
	         topmsg(pos:pos+3)='none'		!zeroed by CANCEL or
							!APPEND...
	         pos=pos+4
	      else
	         if (bitsiz(c$base).le.0) then
	            cnt=0
	            dig=1
	         else
	            rec=0				!from first...
	            call bitcnt_(%val(bitpnt(c$base)),rec,cnt,error)!count sel.
	            if (error.ne.0) then
	               call errmsg_(d$rsub,d$erro,mssg,'?')!get message
	               call errdpl_(mssg,d$cmdo)	!system error
	               if (d$alte.ne.0.and.
     1                     s$set(s$alte)   ) then
	                  call errdpl_(mssg,d$alte)	!alt file also
	               endif
	               call exit			!exit from DBAG
	            endif
	            dig=ndigi_(cnt)
	         endif
	         call wrivar_(topmsg(pos:pos+dig-1),cnt,dig,error)
	         if (error.ne.0) goto 90001		!write error
	         pos=pos+dig
	         if (cnt.gt.0) then
	            call outk_(%val(bitpnt(c$base)),3,kval)!sort file i/o ch.
	            inquire (unit=kval,name=fspec)	!file name
	            if (istrip_(fspec).le.0) then
	               kval=0
	               call ink_(%val(bitpnt(c$base)),3,kval)!??? Forget
	            endif
	            if (kval.gt.0) then
	               topmsg(pos:)=', sorted'
	            else
	               topmsg(pos:)=', unsorted'
	            endif
	         endif
	      endif
	   endif
c
	   call vtext_(topmsg(1:width),1,1,2)		!message
c
	endif
c
	call vset1_(24,1)				!set cursor
c
	goto 900					!return anyway
c
c	Return
c
900	continue
c
c	Restore global error flags
c
	d$erro=derro			!error code (warning)
c
	d$rsub(1:)=' '
	d$rsub=drsub			!procedure that found the error
	d$rinf(1:)=' '
	d$rinf=drinf			!extra info about error
c
	return						!return anyway
c
c	Errors
c	------
c
c	internal error: write error
90001	continue
	error=1
	goto 99000
99000	continue
	call errset_('I$SCUR',error)
	return
c
c	Formats
c	-------
c
	end
c
c
c
c
	subroutine I$SPRV_(base,record,field)
c	*************************************
c
	implicit none
c
	integer base,record,field
c
c	Description
c	===========
c
c	This procedure sets previous current indicators.
c
	include 'own:dbag0.OWN'
c
c	begin
c	=====
c
	integer i
c
	call errclr_('I$SPRV')	!error init
c
	c$pbas=base
	c$prec=record		!previous current record
	c$pfld=field		!and field
c
	return
c
	end
c
c
c
c
	subroutine I$WAIT_(line,erro)
c	*****************************
c
	implicit none
c
	integer line, erro
c
c	Description
c	===========
c
c	If LINE .ge. LINMAX, this procedure resets line to zero, issues
c	nice <waiting...> message and waits for tt activity.
c	If abort key is stroken, returns ERRO = -1. If not, cleans <waiting...>
c	message.
c	No-op if LINE.lt.LINMAX.
c
c	ERRO	< 0	Abort key stroked (usually ESCape)
c		= 0	Ok
c		> 0	Fatal error
c
c	var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagB.OWN'
c
	external tty_getc_
	character*80 waitms
	integer tty_getc_, char, waitln
c
c	begin
c	=====
c
	call errclr_('I$WAIT')
	erro=0
c
	if (line.lt.linmax) return			!nothing to do
c
	if (at$lvl.gt.0.or.				!care @ activity, batch
	1   .not.s$set(s$talk) ) return			!and TALK status
c
	line=0						!reset line#
c
	waitln=linmax+6					!<waiting...> line
	waitms(1:)=' '
	write (waitms(35:80),10001)			!<waiting...> message
	call vtext_(waitms,waitln,1,0)			!display message
c
	char=tty_getc_()				!wait for key stroke
c
	if (char.eq.ttabor1.or.
	1   char.eq.ttabor2    ) then
	   erro=-1					!abort command
	else
	   waitms(1:)=' '				!clean <waiting...> line
	   call vtext_(waitms(1:80),waitln,1,0)		!...
	   waitln=waitln-1				!reenter scrolling zone
	   call vset1_(waitln,1)			!......................
	endif
c
	return						!return in any case
c
c	Errors
c	======
c
c	Formats
c	=======
c
	include 'fmt:iwait.fmt'
c
	end
c
c
c
c
	subroutine I$WLIN_(line,erro)
c	****************************
c
	implicit none
c
	integer line, erro
c
c	Description
c	===========
c
c	This procedure issues nice <waiting...> message at line LINE and waits
c	for tt activity.
c	If abort key is stroken, returns ERRO = -1. If not, cleans <waiting...>
c	message.
c
c	ERRO	< 0	Abort key stroked (usually ESCape)
c		= 0	Ok
c		> 0	Fatal error
c
c	var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagB.OWN'
c
	external tty_getc_
	character*80 waitms
	integer tty_getc_, char
c
c	begin
c	=====
c
	call errclr_('I$WLIN')
	erro=0
c
	if (at$lvl.gt.0.or.				!care @ activity, batch
	1   .not.s$set(s$talk) ) return			!and TALK status
c
	waitms(1:)=' '
	call i$mess_(0,d$cmdo,1,waitms(1:1),-1,erro)	!one line up, please
	write (waitms(35:80),10001)			!<waiting...> message
	call vtext_(waitms,line,1,0)			!display message
c
	char=tty_getc_()				!wait for key stroke
c
	if (char.eq.ttabor1.or.
	1   char.eq.ttabor2)   then
	   erro=-1					!abort command
	else
	   waitms(1:)=' '				!clean <waiting...> line
	   call vtext_(waitms(1:80),line,1,0)		!...
	endif
c
	return						!return in any case
c
c	Errors
c	======
c
c	Formats
c	=======
c
	include 'fmt:iwlin.fmt'
c
	end
c
c
c
c
	subroutine I$WCRT_(alien,aliename,erro)
c	***************************************
c
	implicit none
c
	integer alien,erro
	character*(*) aliename
c
c	Description
c	===========
c
c	This procedure issues, for ALIEN named ALIENAME, nice <waiting...>
c	message at line 24 and waits for tt activity.
c	If abort key is stroken, returns ERRO = -1. If not, cleans <waiting...>
c	message.
c
c	ERRO	< 0	Abort key stroked (usually ESCape)
c		= 0	Ok
c		> 0	Fatal error
c
c	var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagB.OWN'
	include 'own:dbagSR.OWN'
c
	external istrip_,tty_getc_
	integer istrip_,tty_getc_
	character*80 waitms
	integer char,lim1,pos
	character*30 myname
c
c	begin
c	=====
c
	call errclr_('I$WCRT')
	erro=0
c
	if (at$lvl.gt.0.or.				!care @ activity, batch
	1   .not.s$set(s$talk) ) return			!and TALK status
c
	waitms(1:)=' '
	myname(1:)=' '
	if     (alien.eq.p$) then
	   myname(1:9)='PROPERTY '
	   pos=9
	elseif (alien.eq.s$) then
	   myname(1:7)='SERIES '
	   pos=7
	else
	   myname(1:5)='MEMO '
	   pos=5
	endif
	waitms(1:pos)=myname
	pos=pos+1
c
	lim1=istrip_(aliename)
	if (lim1.gt.0) then
	   waitms(pos:pos+lim1-1)=aliename(1:lim1)
	   pos=pos+lim1+2
	endif
	call i$mess_(0,d$cmdo,1,waitms(1:1),-1,erro)	!one line up, please
	write (waitms(pos:80),10001)			!<waiting...> message
	call vtext_(waitms,24,1,0)			!display message
c
	char=tty_getc_()				!wait for key stroke
c
	if (char.eq.ttabor1.or.
	1   char.eq.ttabor2)   then
	   erro=-1					!abort command
	else
	   waitms(1:)=' '				!clean <waiting...> line
	   call vtext_(waitms(1:80),24,1,0)		!...
	endif
c
	return						!return in any case
c
c	Errors
c	======
c
c	Formats
c	=======
c
	include 'fmt:iwcrt.fmt'
c
	end
c
c
c
c
	subroutine I$BCLR_(base,erro)
c	*****************************
c
	implicit none
c
	integer base,erro,noerr
c
c	Description
c	===========
c
c	Frees BASE bitmap and permanent sort file, if any. No-op if none.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer chan
c
c	begin
c	=====
c
	call errclr_('I$BCLR')				!error init
	erro=0
c
	if (bitsiz(base).le.0) return			!no bitmap, return
c
c	Clear permanent SORT
c
	if (bitsiz(base).gt.0) then
	   call ordclr_(%val(bitpnt(base)),erro)	!clear structure
	   if (erro.ne.0) return			!error, carry
	endif
c
	call free_vm_(4*bitsiz(base),bitpnt(base),noerr)!free memory space
	bitsiz(base)=0					!signal no bitmap
c
	return						!return now
c
c	Error
c	=====
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$BCUR_(fchan,wait,line,erro)
c	****************************************
c
	implicit none
c
	integer fchan,line, erro
	logical wait
c
c	Description
c	===========
c
c	This procedure displays current databases on the terminal, if FCHAN
c	= 0, on channel FCHAN otherwise.
c
c	ERRO < 0	abort display
c	     = 0	ok
c	     > 0	fatal error
c
c	var
c	===
c
c	begin
c	=====
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer k,kval,lim,rec,cnt,pos,remlin/26/
	logical opn,done,eostr
	character dbnam*10, dbuse*16, dbsea*10, dbsor*3, dbfil*60
	character*20 fspec
c
	call errclr_('I$BCUR')
	erro=0
c
	opn=.false.
c
	write (mssg,10001)	!database, usage, curr. search, sorted
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg(1:),-1,erro)
	   if (erro.ne.0) return			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)		!wait
	      if (erro.ne.0) return		!abort/error, return/carry
	   endif
c
	   call i$blnk_(wait,line,erro)		!blank line
	   if (erro.ne.0) return			!error, carry
	else
	   write (fchan,fmt='(a,/)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	mssg(1:)=' '
	do 1001 k = d$b, 1, -1			!allocation order is "reverse"
	   if (d$base(k).gt.0) then
c
	      dbnam(1:)=' '
	      dbuse(1:)=' '
	      dbsea(1:)=' '
	      dbsor(1:)=' '
c
	      dbnam(1:)=d$unam(k)		!base name
c
	      if (d$pid(k).eq.0) then		!usage
	         dbuse(1:8)='noupdate'
	      else
	         dbuse(1:8)='  update'
	      endif
	      if (k.eq.c$base) then
	         dbuse(9:)=' ,IN USE'
	      else
	         dbuse(9:)='        '
	      endif
c
	      if (bitcan(k).eq.1) then
	         dbsea(1:10)='      none'
	      else
	         if (bitsiz(k).le.0) then		!just in case...
	            cnt=0
	         else
	            rec=0				!from the beginning...
	            call bitcnt_(%val(bitpnt(k)),rec,cnt,erro)
	            if (erro.ne.0) return		!error, carry
	         endif
	         write (dbsea(1:10),fmt='(i10)')cnt
	      endif
c
	      if (bitsiz(k).le.0) then		!sort
	         kval=0
	      else
	         call outk_(%val(bitpnt(k)),3,kval)	!sort file i/o channel
	         inquire (unit=kval,name=fspec)		!file name
	         if (istrip_(fspec).le.0) then
	            kval=0
	            call ink_(%val(bitpnt(k)),3,kval)	!??? Forget
	         endif
	      endif
c
	      if (kval.gt.0) then
	         dbsor(1:3)='yes'
	      else
	         dbsor(1:3)='no '
	      endif
c
	      pos=-1
	      done=.false.
	      eostr=.false.
c
cwhile	      do while (.not.eostr)
1098	      continue
	      if (eostr) goto 1099
c
	         dbfil(1:)=' '
	         call strsec_(d$bfil(k),dbfil(1:remlin),pos,eostr)
	         if (.not.done) then
	            done=.true.
	            write (mssg,10002) dbnam,dbuse,dbsea,dbsor,
     1                                 dbfil(1:remlin)
	         else
	            write (mssg,10003) dbfil(1:remlin)
	         endif
c
	         if (fchan.le.0) then
	            call i$mess_(0,d$cmdo,-1,mssg(1:),-1,erro)
	            if (erro.ne.0) return		!error, carry
	            line=line+1
	            if (wait) then
	               call i$wait_(line,erro)	!wait
	               if (erro.ne.0) return	!abort/error, return/carry
	            endif
	         else
	            write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	         endif
c
	         goto 1098
1099	      continue
cwhile	      enddo
c
	   endif
1001	continue
c
	return
c
c	Error
c	=====
c
c	Problems writing to display file
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$BCUR',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:ibcur.fmt'
c
	end
c
c
c
c
	subroutine I$BINI_(base,bmsize,erro)
c	************************************
c
	implicit none
c
	integer base,bmsize,erro
c
c	Description
c	===========
c
c	Initializes a SEARCH bitmap for base BASE, empty if BMSIZE .le.0,
c	size = BMSIZE otherwise. BMSIZE = minimum # of WORDS wanted.
c
c	ACHTUNG!: This procedure should not be called if bitmap space
c		  already allocated!!!!!!!
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer zf,zl,izf,izl,sz,topr
c
c	begin
c	=====
c
	call errclr_('I$BINI')				!error init
	erro=0
c
	if (bitsiz(base).gt.0) goto 90001		!already allocated ?
c
c	Allocate it with minimum size anyway...
c
	zf=d$unus-d$offs(base)+1			!first record
	izf=zf
	call zend_(base,zl,erro)			!last record
	if (erro.ne.0) return
	call ex3in_(base,zl,izl,erro)
	if (erro.ne.0) return
	if (izl.le.0) then
	   bitsiz(base)=8
	else
	   bitsiz(base)=(izl-izf+1)/32 + 8		!size
	endif
	if (bitsiz(base).lt.40) bitsiz(base)=40		!at least 40 words
	sz=(izl-izf+1)+20				!and 20 free words
	if (bitsiz(base).lt.sz) bitsiz(base)=sz
c
	if (bmsize.gt.0.and.
     1      bmsize.gt.bitsiz(base)) then
	   bitsiz(base)=bmsize+40			!callers's size + 20
	endif
c
	call get_vm_(4*bitsiz(base),bitpnt(base),erro)	!ask for room
	if (erro.ne.0) goto 90002			!no memory!
	call bitini_(%val(bitpnt(base)),bitsiz(base),izf,topr,erro)	!init bm
	if (erro.ne.0) return				!fatal error, carry
c
	return						!return now
c
c	Error
c	=====
c
c	attempt to allocated bitmap twice
90001	continue
	erro=1
	goto 99000				!set error, return
c	memory (get_vm_) failure
90002	continue
	erro=2
	goto 99000				!set error, return
99000	continue
	call errset_('I$BINI,erro')
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$BLNK_(wait,line,erro)
c	*********************************
c
	implicit none
c
	integer line,erro
	logical wait
c
c	Description
c	===========
c
c	Display a blank line to the terminal and eventually waits.
c	ERRO < 0	abort command
c	     = 0	ok
c	     > 0	fatal error
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	character*1 space/' '/
c
c	begin
c	=====
c
	call errclr_('I$BLNK')				!error init
	erro=0
c
	call i$mess_(0,d$cmdo,-1,space,-1,erro)		!blank line
	if (erro.ne.0) return				!error, carry
	line=line+1
	if (wait) then
	   call i$wait_(line,erro)			!wait
	   if (erro.ne.0) return			!abort/error
	endif
c
	return
c
c	Error
c	=====
c
c	Formats
c	=======
c
	end
c
c
	subroutine I$CREA_(base,prop,newfil,buf,erro)
c	*********************************************
c
	implicit none
c
	integer base,prop,erro
	character*(*) newfil,buf
c
c	Description
c	===========
c
c	Implements the CREATE <newfil> dialog in line mode, saving data base
c	structure in BASE memory context.
c
c	(called by module C$REAT)
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_, lstrip_
	integer istrip_, lstrip_
	character*1   sign,minus/'-'/,space/' '/,tmplt
	character*10	tmpf
	character*10 fmnem
c
	integer width,xwid,decim,ilower,iupper,idef,k,start,xst,fidx,answr
	integer l,type,p1,top,p2,val,dec,lim,f,offs,size,w,form
	integer b2,f2,upd2,mod2,rec,id,b,nfmax,myxusr
	real rval,rvalue1,rvalue2,rlower,rupper,rdef
	integer irv,irv1,irv2
	character*4 rtxt,r1txt,r2txt
	equivalence (rval,irv)
	equivalence (rvalue1,irv1)
	equivalence (rvalue2,irv2)
	equivalence (rval,rtxt)
c
	double precision dval
	logical trunc,ok,opn
	integer irace,idim,isize,ideci
	character*30 race
	character*10 odbname
c
c	begin
c	=====
c
	call errclr_('I$CREA')			!clear errors
	erro=0
c
	call uc_(newfil)			!upper case base name
c
	if (prop.gt.0) then
	   b=prop
	   nfmax=d$b-3				!reserve room for links
	   myxusr=x$usr-3*10			!same
	else
	   b=base
	   nfmax=d$b
	   myxusr=x$usr
	endif
c
c	Ask for field definition
c	========================
c
c	<name>, <type>, [width], [decimal places], [dbname]
c
c	<width>   not present for type logical, date or other data base
c	<decimal> places only present for type "real"
c	<dbname>  only present for type other data base
c
	d$dflt(b)(1:)=' '		!clean for God's sake...
c
	f=1				!field #
	start=2				!start position for fields
					!1st position for nothing at all
	xst=1				!same, external format (properties)
c
	if (prop.gt.0) then
	   write (mssg,11002)		!ask for property structure
	else
	   write (mssg,10002)		!ask for base structure
	endif
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) return		!return
	write (mssg,10007)		!be nice, remember types
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	if (reals) then
	   write (mssg,11007)		!all them if reals
	else
	   write (mssg,12007)
	endif
	call i$mess_(0,d$cmdo,-1,mssg,1,erro)
	if (erro.ne.0) return		!return
	write (mssg,10003)
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) return
c
70	continue
c
	write(mssg,10004) f			!prompt for field
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return
c
701	call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$CREA')		!clear error
	   erro=0
	   goto 70				!loop back
	endif
	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	if (trunc) then				!line too long...
	   write (mssg,10014)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0.and.f.lt.2) then
	   goto 90				!no field specified (yet)
	elseif (lim.eq.0) then
	   goto 90				!eol, done with fields
	elseif (lim.eq.-1) then			!^Z or end-of-@file
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 701
	   else
	      if (f.lt.2) then
	         goto 90			!no field specified (yet)
	      else
	         goto 90			!^Z
	      endif
	   endif
	elseif (lim.eq.-2) then
	   goto 70				!comment line, loop back
	endif
c
	if (f.ge.nfmax) then
	   write (mssg,10023)			!the very last field
	   call i$mess_(0,d$cmdo,1,mssg,1,erro)
	endif
c
c	get <name>
c	----------
c
	erro=0
	call rstok_(buf,1,erro)		!init scanning of buf
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17			!illegal character (syntax error)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return	!error, carry
	   goto 70			!loop
	elseif (type.ne.1.and.type.ne.24) then
	   erro=18			!syntax error (not identifier)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return	!error, carry
	   goto 70			!loop
	elseif (type.eq.0) then
	      goto 90			!eol, all done ...
	endif
c
	l=p2-p1+1
	if (l.gt.cm$l1) then
	   l=cm$l1
	   do 1001 k=cm$l1+1,l
	      buf(k:k)=' '
1001	   continue
	   write (mssg,10013) space,buf(p1:p1+l-1)	!truncation
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	endif
c
c	check field name (uniqueness)
c	-----------------------------
c
	fmnem(1:)=' '
	fmnem=buf(p1:p1+l-1)
	call chkmne_(fmnem,b,f-1,fidx,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')		!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	   goto 70
	endif
c
	if (fidx.gt.0) then
	   erro=5					!field already exists
	   call errmsg_('I$CREA',erro,mssg,'%')		!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return			!error, carry
	   goto 70
	endif
c
	d$fmne(f,b)(1:)=' '
	d$fmne(f,b)(1:l)=buf(p1:p1+l-1)			!store mnemonic
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17			!illegal character (syntax error)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return	!error, carry
	   goto 70			!loop
	elseif (type.ne.8) then
	   erro=18			!syntax error (no comma)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return	!error, carry
	   goto 70			!loop
	endif
c
c	get <type>
c	----------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17			!illegal character (syntax error)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return	!error, carry
	   goto 70			!loop
	endif
c
c	check field type
c	----------------
c
	tmpf(1:)=' '
	tmpf=buf(p1:p2)
	call chktyp_(tmpf,ftype)		!check field type
	if (ftype.gt.ftusr$.or.			!no creatures here
	1   ftype.le.0   ) then			!??
	   if (reals) then
	      erro=3				!bad type, syntax error (reals)
	   else
	      erro=28				!bad type, syntax error
	   endif
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
78	continue
c
	goto (81,81,83,82,80,80,80,80) ftype	!dispatch on ftype
c
c	logical, date, real and double precision (end of line)
c	------------------------------------------------------
c
80	continue
c
	if (ftype.eq.l$) then
	   width=1				!logical width
	   xwid=1				!external
	elseif (ftype.eq.d$) then
	   width=8				!date width
	   xwid=11
	elseif (ftype.eq.r$) then
	   width=4				!real width
	   xwid=15
	elseif (ftype.eq.r8$) then
	   width=8				!double precision width
	   xwid=24
	endif
c
	d$pos(f,b) = start
	d$siz(f,b) = width
	start=start+width
	if ((start-2).gt.myxusr) then
	   erro=2				!record too big
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!propmpt for field
	endif
	if (prop.gt.0) then
	   xst=xst+xwid
	   if ((xst-1).gt.myxusr) then
	      erro=2				!record too big
	      call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 70				!propmpt for field
	   endif
	endif
	goto 85
c
c	integer or string (width)
c	-------------------------
c
81	continue
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=18				!syntax error (no comma)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <width>
c	-----------
c
	erro=0
	call intok_(type,width,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.2) then
	   erro=18				!not integer or eol
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (width.eq.0) then
	      erro=6				!width 0 illegal
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	if (ftype.eq.n$.and.width.gt.digmax) then
	   erro=9				!exceeds maximum digits
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (ftype.eq.c$.and.width.gt.x$fld) then
	   erro=13				!exceeds max field size
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	xwid=width
	if (ftype.ne.c$) then
	   width=width+1			!room for sign
	   xwid=width+1
	endif
c
c	If character, confirm if width > 132 - 10 - 2 (the editor won't work)
c
	if (ftype.eq.c$) then
c
	   if (width.gt.120) then
c
	      write (mssg,10017)		!exceeds editor max.
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	      if (erro.ne.0) return		!error, carry
	      write (mssg,10018)		!ok ?
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	      if (erro.ne.0) return		!error, carry
c
	      call i$yn_(answr,erro)		!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, carry
	         call errclr_('I$CREA')		!clear error
	         erro=0
	         goto 70			!loop back
	      endif
c
	      if (answr.eq.1) then
c	         ok				!"Y", proceed
	      else
	         goto 70			!loop back
	      endif
c
	   endif
c
	endif
c
	d$pos(f,b) = start
	d$siz(f,b) = width
	start=start+width
	if ((start-2).gt.myxusr) then
	   erro=2				!record too big
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!propmpt for field
	endif
	if (prop.gt.0) then
	   xst=xst+xwid
	   if ((xst-1).gt.myxusr) then
	      erro=2				!record too big
	      call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 70				!propmpt for field
	   endif
	endif
c
	goto 85
c
c	decimal (width, decimal places)
82	continue
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=18				!syntax error (no comma)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <width>
c	-----------
c
	erro=0
	call intok_(type,width,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.2) then
	   erro=18				!not integer or eol
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (width.gt.digmax) then
	   erro=9				!exceeds maximum digits
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (width.eq.0) then
	   erro=6				!width 0 illegal
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=18				!syntax error (no comma)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <decimal places>
c	--------------------
c
	erro=0
	call intok_(type,decim,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.2) then
	   erro=18				!not integer or eol
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (decim.eq.0.or.decim.gt.(width-1)) then
	   erro=7				!dec pl. 0 or too many
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	width=width+1				!room for sign
	xwid=width+2				!and for "." (external)
c
	d$pos(f,b) = start
	d$siz(f,b) = width
	d$deci(f,b) = decim
	start=start+width
	if ((start-2).gt.myxusr) then
	   erro=2				!record too big
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!propmpt for field
	endif
	if (prop.gt.0) then
	   xst=xst+xwid
	   if ((xst-1).gt.myxusr) then
	      erro=2				!record too big
	      call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 70				!propmpt for field
	   endif
	endif
	goto 85
c
c	other data base (dbname)
83	continue
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=18				!syntax error (no comma)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <dbname>
c	------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	elseif (type.ne.1.and.
     1          type.ne.24     ) then
	   erro=18				!syntax error (no identifier)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	l=p2-p1+1
	if (l.gt.9)then
	   l=9
	   write (mssg,10013) space,buf(p1:p1+l-1)!truncation
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	odbname(1:)=' '
	odbname=buf(p1:p1+l-1)
c
	call uc_ (odbname)
c
	lim=istrip_(newfil)
	if (l.eq.lim.and.
     1      odbname.eq.newfil(1:lim)) then
	   erro=20				!data base can't point to itself
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	See if base exists
c	------------------
c
	upd2=-1					!try to open base/read limits
	mod2=0
	call open_(b2,odbname,upd2,mod2,opn,erro)
	if (erro.ne.0) then
	   erro=22				!can't open o.d.b
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	call zrace_(b2,race,irace,idim,isize,ideci,erro)
c	if (erro.ne.0) noerror
	if (irace.ne.r$b) then
	   call i$sopn_(b2,erro)		!be nice
	   if (erro.ne.0) return		!error, carry
	   erro=27				!not a regular base
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	d$fnam(f,b)(1:)=' '
	d$fnam(f,b)(1:l)=odbname		!store other data base name
	width=10
	xwid=10
	d$pos(f,b) = start
	d$siz(f,b) = width
	start=start+width
	if ((start-2).gt.myxusr) then
	   erro=2				!record too big
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!propmpt for field
	endif
	if (prop.gt.0) then
	   xst=xst+xwid
	   if ((xst-1).gt.myxusr) then
	      erro=2				!record too big
	      call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 70				!propmpt for field
	   endif
	endif
	goto 85
c
85	continue
c
c	Store field type
c	----------------
c
	d$type(f,b) = ftype
c
c	Ask for field definiton extensions
c	==================================
c
c	Field description
c	-----------------
c
	write (mssg,10009)			!field description
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
855	d$cbuf(1:)=' '
	d$fdes(f,b)(1:)=' '			!clear field description
	read (d$cmdi,fmt='(a)',end=8551) d$cbuf
	goto 8552
8551	continue
	if (at$lvl.gt.0) then
	   call i$atup_(erro)			!@ file active, go up
	   goto 855
	endif
8552	call i$mess_(0,0,-1,d$cbuf,-1,erro)
	if (erro.ne.0) return
	goto 2
1	d$cbuf(1:)=' '
2	l=lstrip_(d$cbuf)
	if (l.gt.cm$l2) then
	   l=cm$l2
	   write (mssg,10013) space,d$cbuf(1:l)	!truncation
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
	d$fdes(f,b)(1:l)=d$cbuf(1:)
c
c	Upper, lower and default values
c	===============================
c
c	for type = integer, decimal, real or date, ask for limits and defaults
c	for type = string or logical, ask for default value only
c	for type = real, free format is used to get limits and default
c	for type = double precision, no limits and no default
c
	if     (ftype.eq.l$.or.ftype.eq.c$.or.
	1       ftype.eq.db$) then
	   goto 88				!log,car,db: only default value,
						!            and field# if db
	elseif (ftype.eq.r8$) then
	   d$min(f,b)=0
	   d$max(f,b)=0
	   goto 98				!r8	   : nothing
	endif
c
c	Upper and lower values (int, dec, real and date)
c	------------------------------------------------
c
86	continue
c
	write (mssg,10010)
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	if     (ftype.eq.d$) then
c date
866	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=8661) k,buf	!read line
	   goto 8662
8661	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 866
	   endif
8662	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      erro=15				!upper/lower, please...
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
	   l=index(buf,',')			!search ','
	   if (l.eq.0) then
	      erro=18				!no comma
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c lower
	   call numdat_(ilower,buf(1:l-1),top,form,erro)!check/convert date
 	   if (erro.ne.0) then
	      erro=4				!bad date
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c upper
	   call numdat_(iupper,buf(l+1:),top,form,erro)	!again
	   if (erro.ne.0) then
	      erro=4				!bad date
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c
	   if (iupper.lt.ilower) then
	      erro=11				!lower > upper
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   d$min(f,b) =  ilower
	   d$max(f,b) =  iupper
c
	   goto 88				!go ask default
c
	elseif (ftype.eq.r$) then
c real
366	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=3661) k,buf	!read line
	   goto 3662
3661	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 366
	   endif
3662	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      erro=15				!upper/lower, please...
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
	   l=index(buf,',')			!search ','
	   if (l.eq.0) then
	      erro=18				!no comma
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c
	   read (buf,*,err=3663,end=3663) rvalue1,rvalue2
	   goto 3664
3663	   continue
	      erro=8				!illegal value
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop
3664	   continue
c
	   d$min(f,b) =  irv1
	   d$max(f,b) =  irv2
c
	   goto 88				!go ask default
c
	endif
c
c	---------
c
707	call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$CREA')		!clear error
	   erro=0
	   goto 86				!loop back
	endif
	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	if (trunc) then				!line too long...
	   write (mssg,10014)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0.or.			!<ret>
	1       (lim.eq.-1.and.			!or ^Z
	1        at$lvl.le.0  ) ) then
	   erro=15				!upper/lower, please...
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86
	elseif (lim.eq.-1.and.
	1       at$lvl.gt.0) then
	   call i$atup_(erro)			!@ file active, go up
	   goto 707
	elseif (lim.eq.-2) then
	   goto 86				!comment line, loop back
	endif
c
c	get [sign] <lower limit> (if int or dec)
c	get <lower limit> (if date)
c	get everything (free format) if real
c	----------------------------------------------------------
c
	erro=0
	call rstok_(buf,1,erro)			!init buf
	call intok_(type,ilower,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	sign=' '				!clean sign character
c
	if (type.eq.12.or.type.eq.13) then      !'+' or '-'
	   if ((ftype.eq.n$.or.ftype.eq.x$).and.
     1         (erro.eq.0) ) then
	      if (type.eq.13) then		!'-'
	         sign=minus
	      endif
	      erro=0
	      call intok_(type,ilower,dec,rval,buf,lim,p1,p2,mssg,erro)
	   else
	      erro=19				!syntax error
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop
	   endif
	endif
c
	if     (erro.ne.0) then
	   erro=17				!syntax error
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.ne.2.and.type.ne.3.and.type.ne.4     ) then
	   erro=19				!syntax error
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.eq.2.and.ftype.ne.n$.or.
     1   	type.eq.3.and.ftype.ne.x$) then
	   erro=8				!illegal value
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	endif
c
c integer
	if     (ftype.eq.n$) then
	   if (sign.eq.minus) then
	      ilower=-ilower
	   endif
	   l=istrip_(buf(p1:p2))
	   if (l.gt.(width-1)) then
	      write (mssg,10013) sign,buf(p1:p1+width-2)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      ilower=ilower/(10.0**(l-width+1))
	   endif
	   d$min(f,b) = ilower
c decimal
	elseif (ftype.eq.x$) then
	   d$cbuf(1:)=' '
	   d$cbuf(1:p2-p1+1)=buf(p1:p2)
	   w=width-1				!forget room for sign
	   call i$cnvd_(d$cbuf,dec,w,decim,rlower,ilower,erro)
	   if (sign.eq.minus) then
	      rlower=-rlower
	      ilower=-ilower
	   endif
	   if (erro.gt.0) then
	      erro=9				!size error
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   if (erro.lt.0) then
	      dval=rlower			!...
	      write (mssg,10006)		!truncation on decimal value
	      lim=istrip_(mssg)+2
	      call wrfvar_(mssg(lim:),dval,width+1,decim,erro)
	      if (erro.ne.0) goto 90024		!write error
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   d$min(f,b) = ilower
	endif
c
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.ne.8) then
	   erro=18				!syntax error (no comma)
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	endif
c
c	get [sign] <upper limit>
c	------------------------
c
	sign=' '				!clear sign
	erro=0
	call intok_(type,iupper,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (type.eq.12.or.type.eq.13) then	!'+' or '-'
	   if ((ftype.eq.n$.or.ftype.eq.x$).and.
     1          (erro.eq.0) ) then
	      if (type.eq.13) then		!'-'
	         sign=minus
	      endif
	      erro=0
	      call intok_(type,iupper,dec,rval,buf,lim,p1,p2,mssg,erro)
	   else
	      erro=1				!illegal character
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop
	   endif
	endif
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.ne.2.and.type.ne.3.and.type.ne.4) then
	   erro=18				!not int., dec. or real
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.eq.2.and.ftype.ne.n$.or.
     1   	type.eq.3.and.ftype.ne.x$) then
	   erro=8				!illegal value
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	endif
c integer
	if     (ftype.eq.n$) then
	   if (sign.eq.minus) then
	      iupper=-iupper
	   endif
	   l=istrip_(buf(p1:p2))
	   if (l.gt.width-1) then
	      write (mssg,10013) sign,buf(p1:p1+width-2)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      iupper=iupper/(10.0**(l-width+1))
	   endif
	   if (iupper.lt.ilower) then
	      erro=11				!lower > upper
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   d$max(f,b) =  iupper
c decimal
	elseif (ftype.eq.x$) then
	   d$cbuf(1:)=' '
	   d$cbuf(1:p2-p1+1)=buf(p1:p2)
	   w=width-1				!forget room for sign
	   call i$cnvd_(d$cbuf,dec,w,decim,rupper,iupper,erro)
	   if (sign.eq.minus) then
	      rupper=-rupper
	      iupper=-iupper
	   endif
	   if (erro.gt.0) then
	      erro=9				!size error
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   if (iupper.lt.ilower) then
	      erro=11				!lower > upper
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   if (erro.lt.0) then
	      dval=rupper			!...
	      write (mssg,10006)		!truncation on decimal value
	      lim=istrip_(mssg)+2
	      call wrfvar_(mssg(lim:),dval,width+1,decim,erro)
	      if (erro.ne.0) goto 90024		!write error
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   d$max(f,b) =  iupper
	endif
c
c	[sign] (if int, dec or real)
c	<default value> 
c	if db$, master field + field to show
c	key/mandatory ?
c	------------------------------------
c
88	continue
c
	if (ftype.eq.db$) then
	   goto 98				!key/mandatory ?
	endif
c
	write (mssg,10012)
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	if     (ftype.eq.c$) then
c string
888	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=8881) k,buf	!read line
	   goto 8882
8881	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 888
	   endif
8882	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      goto 98				!key/mandatory ?
	   endif
	   if (k.gt.width) then
	      write (mssg,10013) buf(1:width)	!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   d$dflt(b)(start-width:start-1)=buf(1:width)
	   goto 98				!key/mandatory ?
c
	elseif (ftype.eq.d$) then
c date
889	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=8891) k,buf	!read line
	   goto 8892
8891	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 889
	   endif
8892	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      goto 98				!key/mandatory ?
	   endif
c
	   call numdat_(idef,buf(1:k),top,form,erro)!check/convert date
	   if (erro.ne.0) then
	      erro=4				!bad date
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88
	   endif
	   if (idef.lt.ilower.or.
     1         idef.gt.iupper    ) then
	      erro=10				!out of range
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop
	   endif
	   call wrivar_(d$dflt(b)(start-width:start-1),idef,!write def
     1                  width,erro)
	   if (erro.ne.0) goto 90024		!write error
	   goto 98				!key/mandatory ?
c
	elseif (ftype.eq.r$) then
c real
489	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=4891) k,buf	!read line
	   goto 4892
4891	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 489
	   endif
4892	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      rtxt=rnulltxt			!no default
	   else
	      read (buf,*,err=4883,end=4883) rval
	      goto 4884
4883	      continue
	         erro=8				!illegal value
	         call errmsg_('I$CREA',erro,mssg,'%')!get error message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, carry
	         goto 88				!loop
4884	      continue
	      if (rval.lt.rvalue1.or.
     1            rval.gt.rvalue2    ) then
	         erro=10				!out of range
	         call errmsg_('I$CREA',erro,mssg,'%')!get error message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, carry
	         goto 88				!loop
	      endif
	   endif
c
	   d$dflt(b)(start-width:start-1)=rtxt	!write default
c
	   goto 98				!key/mandatory ?
c
	endif
c
c	---------
c
808	call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$CREA')		!clear error
	   erro=0
	   goto 88				!loop back
	endif
	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	if (trunc) then				!line too long...
	   write (mssg,10014)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0.or.			!<ret>
	1       (lim.eq.-1.and.
	1        at$lvl.gt.0  )  ) then		!or ^Z
	   d$dflt(b)(start-width:start-1)=' '
	   goto 98				!key/mandatory ?
	elseif (lim.eq.-1.and.
	1       at$lvl.gt.0   ) then
	   call i$atup_(erro)			!@ file active, go up
	   goto 808
	elseif (lim.eq.-2) then
	   goto 88				!comment line, loop back
	endif
c
	sign=' '				!clean sign
	erro=0
	call rstok_(buf,1,erro)
	call intok_(type,idef,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (type.eq.0) goto 98			!key/mandatory ?
c
	if (type.eq.12.or.type.eq.13) then	!'+' or '-'
	   if ((ftype.eq.n$.or.ftype.eq.x$).and.
     1         (erro.eq.0) ) then
	      if (type.eq.13) then		!'-'
	         sign=minus
	      endif
	      erro=0
	      call intok_(type,idef,dec,rval,buf,lim,p1,p2,mssg,erro)
           else
	      erro=1				!syntax error
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop
	   endif
	endif
c
	if     (erro.ne.0) then
	   erro=17				!illegal character
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 88				!loop
	elseif (
     1   	(type.eq.1.and.ftype.eq.l$).or.	!logical
     1   	(type.eq.2.and.ftype.eq.n$).or.	!integer
     1   	(type.eq.2.and.ftype.eq.l$).or.	!logical
     1   	(type.eq.3.and.ftype.eq.x$).or.	!decimal
     1   	(              ftype.eq.c$)    ) then
						!ok, nops
	else
	   erro=8				!illegal value
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 88				!loop
	endif
c
c integer
	if     (ftype.eq.n$) then
	   if (sign.eq.minus) then
	      idef=-idef
	   endif
	   l=istrip_(buf(p1:p2))
	   if (l.gt.width-1) then
	      write (mssg,10013) sign,buf(p1:p1+width-2)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      idef=idef/(10.0**(l-width+1))
	   endif
	   if (idef.lt.ilower.or.
     1         idef.gt.iupper    ) then
	      erro=10				!out of range
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop
	   endif
	   call wrivar_(d$dflt(b)(start-width:start-1),idef,
     1                  width,erro)
	   if (erro.ne.0) goto 90024		!write error
c decimal
	elseif (ftype.eq.x$) then
	   d$cbuf(1:)=' '
	   d$cbuf(1:p2-p1+1)=buf(p1:p2)
	   w=width-1				!forget room for sign
	   call i$cnvd_(d$cbuf,dec,w,decim,rdef,idef,erro)
	   if (sign.eq.minus) then
	      rdef=-rdef
	      idef=-idef
	   endif
	   if (erro.gt.0) then
	      erro=9				!size error
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop back
	   endif
	   if (erro.lt.0) then
	      dval=rdef				!...
	      write (mssg,10006)		!truncation on decimal value
	      lim=istrip_(mssg)+2
	      call wrfvar_(mssg(lim:),dval,width+1,decim,erro)
	      if (erro.ne.0) goto 90024		!write error
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   if (rdef.lt.rlower.or.
     1         rdef.gt.rupper    ) then
	      erro=10				!out of range
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop
	   endif
	   id=d$deci(f,b)
	   call wrivar_(d$dflt(b)(start-width:start-1),idef,
     1                  width,erro)
	   if (erro.ne.0) goto 90024		!write error
c logical
	elseif (ftype.eq.l$) then
	   if     (p1.ne.p2) then
	      erro=8				!illegal value
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop
	   elseif (buf(p1:p2).eq.'0') then
	      buf(p1:p2)='f'
	   elseif (buf(p1:p2).eq.'1') then
	      buf(p1:p2)='t'
	   elseif (buf(p1:p2).eq.'T'.or.buf(p1:p2).eq.'t') then
	      buf(p1:p2)='t'
	   elseif (buf(p1:p2).eq.'F'.or.buf(p1:p2).eq.'f') then
	      buf(p1:p2)='f'
	   else
	      erro=8				!illegal value
	      call errmsg_('I$CREA',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 88				!loop
	   endif
	   d$dflt(b)(start-width:start-1)=buf(p1:p2)
	endif
c
	goto 98					!key/mandatory ?
c
c	Key/mandatory field ? (if regular base only)
c	--------------------------------------------
c
98	continue
c
	if (prop.gt.0) then
c
	   answr=2				!not key
c
	else
c
	   write (mssg,10022)			!KEY ?
	   call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	   if (erro.ne.0) return			!error, carry
c
	   call i$yn_(answr,erro)			!accept y/n
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')	!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      call errclr_('I$CREA')		!clear error
	      erro=0
	      goto 98				!loop back
	   endif
c
	   if (answr.eq.3.or.answr.eq.4) goto 98	!^Z, comment line
c
	endif
c
	if (answr.eq.1) then
	   d$idx(f,b)=2				!"Y", KEY
	else
	   d$idx(f,b)=0				!no or ????
	endif
c
	if (d$idx(f,b).eq.2) then
	   d$oblg(f,b)=1			!KEY field => mandatory
	   goto 97				!skip mandatory stuff
	endif
c
c	Mandatory ?
c	-----------
c
89	continue
c
	write (mssg,10015)			!mandatory ?
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	call i$yn_(answr,erro)			!accept y/n
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   call errclr_('I$CREA')		!clear error
	   erro=0
	   goto 89				!loop back
	endif
c
	if (answr.eq.3.or.answr.eq.4) goto 89	!^Z, comment line
c
	if (answr.eq.1) then
	   d$oblg(f,b)=1			!"Y", mandatory
	else
	   d$oblg(f,b)=0			!no or ????
	endif
c
97	continue
c
	if (ftype.ne.db$) goto 890		!all done if not db$
c
	goto 891				!master field
c
c	Master field (db$)
c	------------------
c
891	continue
c
	d$mast(f,b)=0				!assume no master field
c
	write (mssg,10020)			!master field
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
8911	buf(1:)=' '
	read (d$cmdi,'(a)',end=89111) buf	!read line
	   goto 89112
89111	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 8911
	   endif
89112	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	l=istrip_(buf)
	if (l.le.0) goto 890			!all done
c
	ok=.false.
	upd2=-1					!open base
	mod2=0
	call open_(b2,odbname,upd2,mod2,opn,erro)
	if (erro.eq.0) then
	   call rstok_(buf,1,erro)		!start at beginning
	   erro=0				!silence intok
	   type=0
	   call intok_(type,val,dec,rval,buf(1:l),
	1              lim,p1,p2,mssg,erro)
	   if (type.eq.0) goto 890		!<ret>, complete fields
	   if (erro.eq.0.and.
	1      type.eq.33) then			!"%"
	      erro=0				!silence intok
	      call intok_(type,val,dec,rval,buf(1:l),
	1                 lim,p1,p2,mssg,erro)
	   endif
	   if (erro.eq.0) then
	      if (type.eq.2) then		!n or %n
	         f2=val
	         if (f2.gt.0.and.
     1               f2.le.d$nfld(b2)) then
	            ok=.true.
	         else
c	            bad number, proceed
	         endif
	      else
	         call znum_(b2,f2,buf(p1:p2),erro)!get field#
	         if (erro.eq.0.and.
	1            f2.gt.0      ) then	!error, carry
	            ok=.true.
	         endif
	      endif	
	   endif
	endif
c
	if (.not.ok) then
	   erro=25				!bad or no such field
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 891				!loop
	endif
c
	if (d$type(f2,b2).eq.db$) then		!sorry, non-recursive
	   erro=26				!...
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 891				!loop
	endif
c
	d$mast(f,b)=f2				!master field
c
	goto 892				!field to show
c
c	Field to show (db$)
c	-------------------
c
892	continue
c
	d$see(f,b)=0				!assume no field to show
c
	write (mssg,10021)			!field to show
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
8921	buf(1:)=' '
	read (d$cmdi,'(a)',end=89211) buf	!read line
	   goto 89212
89211	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 8921
	   endif
89212	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	l=istrip_(buf)
	if (l.le.0) goto 890			!all done
c
	ok=.false.
	upd2=-1					!open base
	mod2=0
	call open_(b2,odbname,upd2,mod2,opn,erro)
	if (erro.eq.0) then
	   call rstok_(buf,1,erro)		!start at beginning
	   erro=0				!silence intok
	   type=0
	   call intok_(type,val,dec,rval,buf(1:l),
	1              lim,p1,p2,mssg,erro)
	   if (type.eq.0) goto 890		!<ret>, complete fields
	   if (erro.eq.0.and.
	1      type.eq.33) then			!"%"
	      erro=0				!silence intok
	      call intok_(type,val,dec,rval,buf(1:l),
	1                 lim,p1,p2,mssg,erro)
	   endif
	   if (erro.eq.0) then
	      if (type.eq.2) then		!n or %n
	         f2=val
	         if (f2.gt.0.and.
     1               f2.le.d$nfld(b2)) then
	            ok=.true.
	         else
c	            bad number, proceed
	         endif
	      else
	         call znum_(b2,f2,buf(p1:p2),erro)!get field#
	         if (erro.eq.0.and.
	1            f2.gt.0      ) then	!error, carry
	            ok=.true.
	         endif
	      endif	
	   endif
	endif
c
	if (.not.ok) then
	   erro=25				!bad or no such field
	   call errmsg_('I$CREA',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 892				!loop
	endif
c
	d$see(f,b)=f2				!field to show
c
	goto 890				!complete fields
c
c	Complete and output root file (field definition)
c	================================================
c
890	continue	
c
	f=f+1					!next field
c
	if (f.gt.nfmax) then
	   goto 90				!no more available
	else
	   goto 70				!go back for more
	endif
c
c	Done with field definition
c	--------------------------
c
90	continue
c
	d$nfld(b)=f-1				!# fields
c
	if (prop.gt.0) then
	   write (mssg,11011)			!property designation
	else
	   write (mssg,10011)			!base designation
	endif
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
909	d$cbuf(1:)=' '
	read (d$cmdi,fmt='(a)',end=9091) d$cbuf
	   goto 9092
9091	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 909
	   endif
9092	call i$mess_(0,0,-1,d$cbuf,-1,erro)
	if (erro.ne.0) return
	l=lstrip_(d$cbuf)
	if (l.gt.ro$l3) then
	   l=ro$l3
	   write  (mssg,10013) d$cbuf(1:l)	!truncation
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
	d$bdes(b)(1:)=' '
	d$bdes(b)(1:l)=d$cbuf(1:l)
c
4	continue
cxcx	write (mssg,10008)			!check digit ?
cxcx	call i$mess_(0,d$cmdo,1,mssg,0,erro)
cxcx	if (erro.ne.0) return			!error, carry
c
cxcx	call i$yn_(answr,erro)			!accept y/n
cxcx	if (erro.ne.0) then
cxcx	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
cxcx	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
cxcx	   if (erro.ne.0) return		!error, carry
cxcx	   call errclr_('I$CREA')		!clear error
cxcx	   erro=0
cxcx	   goto 4				!loop back
cxcx	endif
c
cxcx	if (answr.eq.3.or.answr.eq.4) goto 4	!^Z, comment line
c
c
	if (prop.gt.0) then
	   k=1					!property, 1st rec# = 1
	else
c
5	   continue
	   k=1					!assume first=1
	   write (mssg,10001)			!first rec#
	   call i$mess_(0,d$cmdo,1,mssg,0,erro)
	   if (erro.ne.0) return		!error, carry
55	   buf(1:)=' '
	   l=0
	   read (d$cmdi,fmt='(q,a)',end=551) l,buf
	   goto 552
551	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 55
	   endif
552	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if     (l.gt.10) then
	      erro=14				!exceeds maximum
	      call errmsg_('I$CREA',erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 5				!loop back
	   elseif (l.ne.0) then
	      call rdivar_(buf,k,l,erro)
	      if (erro.ne.0) then
	         erro=21			!bad number
	         call errmsg_('I$CREA',erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, carry
	         goto 5				!loop back
	      endif
	      if (k.le.0) then
	         erro=12			!< 1
	         call errmsg_('I$CREA',erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, carry on
	        goto 5				!loop back
	      endif
	   endif
c
	endif
c
	d$offs(b) = d$unus - k + 1		!compute offset
c
	goto 6					!re-use killed records ?
c
c	Re-use killed record numbers ?
c	------------------------------
c
6	   continue
c
	   if (prop.gt.0) then
	      d$froz(b)=1			!killed records frozen
	   else
c
	   write (mssg,10019)			!re-use killed records ?
	   call i$mess_(0,d$cmdo,1,mssg,0,erro)
	   if (erro.ne.0) return		!error, carry
c
	   call i$yn_(answr,erro)		!accept y/n
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      call errclr_('I$CREA')		!clear error
	      erro=0
	      goto 6				!loop back
	   endif
c
	   if (answr.eq.3.or.answr.eq.4) goto 6	!^Z, comment line
c
	   if (answr.eq.2) then
	      d$froz(b)=1			!"N", don't re-use
	   else
	      d$froz(b)=0			!no or ????
	   endif
c
	endif
c
	goto 66					!base cripted ?
c
c	Base cripted ?
c	--------------
c
66	continue
c
	if (prop.gt.0) then
	   write (mssg,11016)			!property cripted ?
	else
	   write (mssg,10016)			!base cripted ?
	endif
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	call i$yn_(answr,erro)			!accept y/n
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   call errclr_('I$CREA')		!clear error
	   erro=0
	   goto 66				!loop back
	endif
c
	if (answr.eq.3.or.answr.eq.4) goto 66	!^Z, comment line
c
	if (answr.eq.1) then
	   d$crpt(b)=0				!"Y", cripted
	else
	   d$crpt(b)=1				!no or ????
	endif
c
c	Add links if creature
c
	if (prop.gt.0) then
	   call i$lnks_(b)			!add links
	endif
c
c	Back to main loop
c	=================
c
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c	*** obsolete *** no field specified
90001	continue
	erro=1
	goto 99000
c
c	90002 thru 90015 used via "direct" error messages!
c
c	*** obsolete ***
90016	continue
	erro=16
	goto 99000				!set error and return
c
c	90017 thru 90023 used via "direct" error messages!
c
c	internal error (read/write error)
90024	continue
	erro=24
	goto 99000				!set error and return
c
c	90025 thru 90028 used via "direct" error messages!
c
c	Set error and return
c	====================
99000	continue
	call errset_('I$CREA',erro)
	return					!return
c
c	Formats
c	=======
c
	include 'fmt:icrea.fmt'
c
	end
c
c
c
c
	subroutine I$CRSS_(base,ser,newfil,buf,erro)
c	********************************************
c
	implicit none
c
	integer base,ser,erro
	character*(*) newfil,buf
c
c	Description
c	===========
c
c	Implements the CREATE SERIES <newfil> dialog in line mode, saving data
c	structure in SER memory context.
c
c	Owner base is BASE (unused...).
c
c	(called by module C$REAT)
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_, lstrip_, ndigi_
	integer istrip_, lstrip_, ndigi_
	character*1   sign,minus/'-'/,tmplt
	character*10	tmpf
c
	integer dig,width,xwid,decim,ilower,iupper,k,xst,fidx,answr
	integer l,type,p1,top,p2,val,dec,lim,f,offs,size,w,form
	real rval,rvalue1,rvalue2,rlower,rupper
	integer irv,irv1,irv2
	character*4 rtxt,r1txt,r2txt
	equivalence (rval,irv)
	equivalence (rvalue1,irv1)
	equivalence (rvalue2,irv2)
	equivalence (rval,rtxt)
c
	double precision dval
	logical trunc,ok,opn
c
c	begin
c	=====
c
	call errclr_('I$CRSS')			!clear errors
	erro=0
c
	call uc_(newfil)			!upper case series name
c
c	Ask for series type
c	===================
c
	d$dflt(ser)(1:)=' '			!clean for God's sake...
c
	write (mssg,10001)
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) return			!fatal error, carry
c
70	continue
c
	write (mssg,10002)			!show types
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) return
c
	write (mssg,10003)
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) return
c
	if (reals) then
	   write (mssg,10004)			!all them if reals
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) return
	endif
c
	write (mssg,10005)
	call i$mess_(0,d$cmdo,1,mssg,0,erro)	!prompt for type
	if (erro.ne.0) return
c
701	call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$CRSS')		!clear error
	   erro=0
	   goto 70				!loop back
	endif
	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	if (trunc) then				!line too long...
	   write (mssg,10014)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0) then
	   goto 70				!eol, loop back
	elseif (lim.eq.-1) then			!^Z or end-of-@file
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 701
	   else
	      goto 70				!loop back
	   endif
	elseif (lim.eq.-2) then
	   goto 70				!comment line, loop back
	endif
c
c	get <type>
c	----------
c
	erro=0
	call rstok_(buf,1,erro)
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12			!illegal character (syntax error)
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return	!error, carry
	   goto 70			!loop
	endif
c
c	check field type
c	----------------
c
	tmpf(1:)=' '
	tmpf=buf(p1:p2)
	call chktyp_(tmpf,ftype)		!check field type
	if (ftype.gt.ftusr$.or.			!no creatures here
	1   ftype.eq.db$.or.			!nor db$...
	1   ftype.le.0   ) then			!??
	   if (reals) then
	      erro=3				!bad type, syntax error (reals)
	   else
	      erro=2				!bad type, syntax error
	   endif
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
78	continue
c
	goto (81,81,83,82,80,80,80,80) ftype	!dispatch on ftype
c
83	continue				!db$...?
c
c	logical, date, real and double precision (end of line)
c	------------------------------------------------------
c
80	continue
c
	if (ftype.eq.l$) then
	   width=1				!logical width
	   xwid=1				!external
	elseif (ftype.eq.d$) then
	   width=8				!date width
	   xwid=11
	elseif (ftype.eq.r$) then
	   width=4				!real width
	   xwid=15
	elseif (ftype.eq.r8$) then
	   width=8				!double precision width
	   xwid=24
	endif
c
	d$siz(1,ser) = width
	goto 88
c
c	integer or string (width)
c	-------------------------
c
81	continue
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=10				!syntax error (no comma)
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <width>
c	-----------
c
	erro=0
	call intok_(type,width,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.2) then
	   erro=10				!not integer or eol
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (width.eq.0) then
	      erro=6				!width 0 illegal
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	if (ftype.eq.n$.and.width.gt.digmax) then
	   erro=9				!exceeds maximum digits
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (ftype.eq.c$.and.width.gt.x$fld) then
	   erro=13				!exceeds max field size
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	xwid=width
	if (ftype.ne.c$) then
	   width=width+1			!room for sign
	   xwid=width+1
	endif
c
c	If character, confirm if width > 132 - 10 - 2 (the editor won't work)
c
	if (ftype.eq.c$) then
c
	   if (width.gt.120) then
c
	      write (mssg,10017)		!exceeds editor max.
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	      if (erro.ne.0) return		!error, carry
	      write (mssg,10018)		!ok ?
	      call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	      if (erro.ne.0) return		!error, carry
c
	      call i$yn_(answr,erro)		!accept y/n
	      if (erro.ne.0) then
	         call errmsg_(d$rsub,erro,mssg,'%')!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) return		!error, carry
	         call errclr_('I$CRSS')		!clear error
	         erro=0
	         goto 70			!loop back
	      endif
c
	      if (answr.eq.1) then
c	         ok				!"Y", proceed
	      else
	         goto 70			!loop back
	      endif
c
	   endif
c
	endif
c
	d$siz(1,ser) = width
c
	goto 88
c
c	decimal (width, decimal places)
82	continue
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=10				!syntax error (no comma)
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <width>
c	-----------
c
	erro=0
	call intok_(type,width,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.2) then
	   erro=10				!not integer or eol
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (width.gt.digmax) then
	   erro=9				!exceeds maximum digits
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (width.eq.0) then
	   erro=6				!width 0 illegal
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.8) then
	   erro=10				!syntax error (no comma)
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
c	get <decimal places>
c	--------------------
c
	erro=0
	call intok_(type,decim,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	elseif (type.ne.2) then
	   erro=10				!not integer or eol
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70				!loop
	endif
c
	if (decim.eq.0.or.decim.gt.(width-1)) then
	   erro=7				!dec pl. 0 or too many
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 70
	endif
c
	width=width+1				!room for sign
	xwid=width+2				!and for "." (external)
c
	d$siz(1,ser) = width
	d$deci(1,ser) = decim
c
	d$fnam(1,ser)(1:)=' '
	d$fdes(1,ser)(1:l)=' '
c
c	Upper and lower values
c	======================
c
c	for type = integer, decimal, real or date, ask for limits
c	for type = real, free format is used to get limits
c	for type = double precision, no limits
c
	if     (ftype.eq.l$.or.ftype.eq.c$) then
	   goto 88				!log,car,db: all done
	elseif (ftype.eq.r8$) then
	   d$min(1,ser)=0
	   d$max(1,ser)=0
	   goto 88				!r8	   : nothing
	endif
c
c	Upper and lower values (int, dec, real and date)
c	------------------------------------------------
c
86	continue
c
	write (mssg,10010)
	call i$mess_(0,d$cmdo,-1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	if     (ftype.eq.d$) then
c date
866	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=8661) k,buf	!read line
	   goto 8662
8661	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 866
	   endif
8662	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      erro=14				!upper/lower, please...
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
	   l=index(buf,',')			!search ','
	   if (l.eq.0) then
	      erro=10				!no comma
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c lower
	   call numdat_(ilower,buf(1:l-1),top,form,erro)!check/convert date
 	   if (erro.ne.0) then
	      erro=4				!bad date
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c upper
	   call numdat_(iupper,buf(l+1:),top,form,erro)	!again
	   if (erro.ne.0) then
	      erro=4				!bad date
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c
	   if (iupper.lt.ilower) then
	      erro=11				!lower > upper
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   d$min(1,ser) =  ilower
	   d$max(1,ser) =  iupper
c
	   goto 88				!all done
c
	elseif (ftype.eq.r$) then
c real
366	   buf(1:)=' '
	   k=0
	   read (d$cmdi,'(q,a)',end=3661) k,buf	!read line
	   goto 3662
3661	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 366
	   endif
3662	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
	   if (k.eq.0) then
	      erro=14				!upper/lower, please...
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
	   l=index(buf,',')			!search ','
	   if (l.eq.0) then
	      erro=10				!no comma
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86
	   endif
c
	   read (buf,*,err=3663,end=3663) rvalue1,rvalue2
	   goto 3664
3663	   continue
	      erro=8				!illegal value
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop
3664	   continue
c
	   d$min(1,ser) =  irv1
	   d$max(1,ser) =  irv2
c
	   goto 88				!all done
c
	endif
c
c	---------
c
707	call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!fatal error, carry
	   call errclr_('I$CRSS')		!clear error
	   erro=0
	   goto 86				!loop back
	endif
	call i$mess_(0,0,-1,buf,-1,erro)
	if (erro.ne.0) return
c
	if (trunc) then				!line too long...
	   write (mssg,10014)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if     (lim.eq.0.or.			!<ret>
	1       (lim.eq.-1.and.			!or ^Z
	1        at$lvl.le.0  ) ) then
	   erro=14				!upper/lower, please...
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86
	elseif (lim.eq.-1.and.
	1       at$lvl.gt.0) then
	   call i$atup_(erro)			!@ file active, go up
	   goto 707
	elseif (lim.eq.-2) then
	   goto 86				!comment line, loop back
	endif
c
c	get [sign] <lower limit> (if int or dec)
c	get <lower limit> (if date)
c	get everything (free format) if real
c	----------------------------------------------------------
c
	erro=0
	call rstok_(buf,1,erro)			!init buf
	call intok_(type,ilower,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	sign=' '				!clean sign character
c
	if (type.eq.12.or.type.eq.13) then      !'+' or '-'
	   if ((ftype.eq.n$.or.ftype.eq.x$).and.
     1         (erro.eq.0) ) then
	      if (type.eq.13) then		!'-'
	         sign=minus
	      endif
	      erro=0
	      call intok_(type,ilower,dec,rval,buf,lim,p1,p2,mssg,erro)
	   else
	      erro=5				!syntax error
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop
	   endif
	endif
c
	if     (erro.ne.0) then
	   erro=12				!syntax error
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.ne.2.and.type.ne.3.and.type.ne.4     ) then
	   erro=5				!syntax error
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.eq.2.and.ftype.ne.n$.or.
     1   	type.eq.3.and.ftype.ne.x$) then
	   erro=8				!illegal value
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	endif
c
c integer
	if     (ftype.eq.n$) then
	   if (sign.eq.minus) then
	      ilower=-ilower
	   endif
	   l=istrip_(buf(p1:p2))
	   if (l.gt.(width-1)) then
	      write (mssg,10013) sign,buf(p1:p1+width-2)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      ilower=ilower/(10.0**(l-width+1))
	   endif
	   d$min(1,ser) = ilower
c decimal
	elseif (ftype.eq.x$) then
	   d$cbuf(1:)=' '
	   d$cbuf(1:p2-p1+1)=buf(p1:p2)
	   w=width-1				!forget room for sign
	   call i$cnvd_(d$cbuf,dec,w,decim,rlower,ilower,erro)
	   if (sign.eq.minus) then
	      rlower=-rlower
	      ilower=-ilower
	   endif
	   if (erro.gt.0) then
	      erro=9				!size error
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   if (erro.lt.0) then
	      dval=rlower			!...
	      write (mssg,10006)		!truncation on decimal value
	      lim=istrip_(mssg)+2
	      call wrfvar_(mssg(lim:),dval,width+1,decim,erro)
	      if (erro.ne.0) goto 90015		!write error
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   d$min(1,ser) = ilower
	endif
c
c
c	get <,>
c	-------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.ne.8) then
	   erro=10				!syntax error (no comma)
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	endif
c
c	get [sign] <upper limit>
c	------------------------
c
	sign=' '				!clear sign
	erro=0
	call intok_(type,iupper,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (type.eq.12.or.type.eq.13) then	!'+' or '-'
	   if ((ftype.eq.n$.or.ftype.eq.x$).and.
     1          (erro.eq.0) ) then
	      if (type.eq.13) then		!'-'
	         sign=minus
	      endif
	      erro=0
	      call intok_(type,iupper,dec,rval,buf,lim,p1,p2,mssg,erro)
	   else
	      erro=1				!illegal character
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop
	   endif
	endif
c
	if     (erro.ne.0) then
	   erro=12				!illegal character
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.ne.2.and.type.ne.3.and.type.ne.4) then
	   erro=10				!not int., dec. or real
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	elseif (type.eq.2.and.ftype.ne.n$.or.
     1   	type.eq.3.and.ftype.ne.x$) then
	   erro=8				!illegal value
	   call errmsg_('I$CRSS',erro,mssg,'%')	!get error message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   goto 86				!loop
	endif
c integer
	if     (ftype.eq.n$) then
	   if (sign.eq.minus) then
	      iupper=-iupper
	   endif
	   l=istrip_(buf(p1:p2))
	   if (l.gt.width-1) then
	      write (mssg,10013) sign,buf(p1:p1+width-2)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      iupper=iupper/(10.0**(l-width+1))
	   endif
	   if (iupper.lt.ilower) then
	      erro=11				!lower > upper
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   d$max(1,ser) =  iupper
c decimal
	elseif (ftype.eq.x$) then
	   d$cbuf(1:)=' '
	   d$cbuf(1:p2-p1+1)=buf(p1:p2)
	   w=width-1				!forget room for sign
	   call i$cnvd_(d$cbuf,dec,w,decim,rupper,iupper,erro)
	   if (sign.eq.minus) then
	      rupper=-rupper
	      iupper=-iupper
	   endif
	   if (erro.gt.0) then
	      erro=9				!size error
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   if (iupper.lt.ilower) then
	      erro=11				!lower > upper
	      call errmsg_('I$CRSS',erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 86				!loop back
	   endif
	   if (erro.lt.0) then
	      dval=rupper			!...
	      write (mssg,10006)		!truncation on decimal value
	      lim=istrip_(mssg)+2
	      call wrfvar_(mssg(lim:),dval,width+1,decim,erro)
	      if (erro.ne.0) goto 90015		!write error
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	   d$max(1,ser) =  iupper
	endif
c
88	continue
c
	d$idx(1,ser)=0				!not KEY
	d$oblg(1,ser)=0				!not MANDATORY
	d$mast(1,ser)=0				!master field
	d$see(1,ser)=0				!field to show
c
	goto 890				!complete fields
c
c	Complete (copy) field definition
c	================================
c
890	continue	
c
	if     (ftype.eq.n$) then
	   d$race(ser)=r$si			!serie of integers
	   d$fmne(1,ser)='$si_1'
	elseif (ftype.eq.x$) then
	   d$race(ser)=r$sx			!serie of decimals
	   d$fmne(1,ser)='$sx_1'
	elseif (ftype.eq.r$) then
	   d$race(ser)=r$sr			!serie of reals
	   d$fmne(1,ser)='$sr_1'
	elseif (ftype.eq.r8$) then
	   d$race(ser)=r$sr8			!serie of double precision's
	   d$fmne(1,ser)='$sr8_1'
	elseif (ftype.eq.d$) then
	   d$race(ser)=r$sd			!serie of dates
	   d$fmne(1,ser)='$sd_1'
	elseif (ftype.eq.l$) then
	   d$race(ser)=r$sl			!serie of logicals
	   d$fmne(1,ser)='$sl_1'
	else
	   d$race(ser)=r$sc			!serie of characters
	   d$fmne(1,ser)='$sc_1'
	endif
c
	d$pdim(ser)=1				!dimension
c
	d$psiz(ser)=d$siz(1,ser)		!global size
c
	d$pdec(ser)=d$deci(1,ser)		!decimal places or zero
c
	d$type(1,ser)=ftype			!store field type
	d$pos(1,ser)=2				!1st fields starts always at 2
	f=5					!# of fields
	d$nfld(ser)=f				!# fields
	do k = 2,f
	   d$fmne(k,ser)=d$fmne(1,ser)
	   dig=ndigi_(k)
	   write (d$fmne(k,ser)(istrip_(d$fmne(k,ser)):),'(i<dig>)') k
	   d$type(k,ser)=ftype
	   d$siz(k,ser)=d$siz(1,ser)
	   d$pos(k,ser)=d$pos(k-1,ser)+d$siz(k,ser)	!temporary ...
	   d$deci(k,ser)=d$deci(1,ser)
	   d$min(k,ser)=d$min(1,ser)
	   d$max(k,ser)=d$max(1,ser)
	   d$idx(k,ser)=d$idx(1,ser)
	   d$oblg(k,ser)=d$oblg(1,ser)
	   d$mast(k,ser)=d$mast(1,ser)
	   d$see(k,ser)=d$see(1,ser)
	enddo
c
	write (mssg,11011)			!series designation
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
909	d$cbuf(1:)=' '
	read (d$cmdi,fmt='(a)',end=9091) d$cbuf
	   goto 9092
9091	   continue
	   if (at$lvl.gt.0) then
	      call i$atup_(erro)		!@ file active, go up
	      goto 909
	   endif
9092	call i$mess_(0,0,-1,d$cbuf,-1,erro)
	if (erro.ne.0) return
	l=lstrip_(d$cbuf)
	if (l.gt.ro$l3) then
	   l=ro$l3
	   write  (mssg,10013) d$cbuf(1:l)	!truncation
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
	d$bdes(ser)(1:)=' '
	d$bdes(ser)(1:l)=d$cbuf(1:l)
c
	k=1					!series, 1st rec# = 1
	d$offs(ser) = d$unus - k + 1		!compute offset
c
	d$froz(ser)=1				!series, killed records frozen
c
c	Cripted ?
c	---------
c
66	continue
c
	write (mssg,11016)			!series cripted ?
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	call i$yn_(answr,erro)			!accept y/n
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   call errclr_('I$CRSS')		!clear error
	   erro=0
	   goto 66				!loop back
	endif
c
	if (answr.eq.3.or.answr.eq.4) goto 66	!^Z, comment line
c
	if (answr.eq.1) then
	   d$crpt(ser)=0				!"Y", cripted
	else
	   d$crpt(ser)=1				!no or ????
	endif
c
c	Add links
c
	call i$lnks_(ser)				!add links
c
c	Back to main loop
c	=================
c
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c	*** obsolete *** no field specified
90001	continue
	erro=1
	goto 99000
c
c	90002 thru 90014 used via "direct" error messages!
c
c	internal error (read/write error)
90015	continue
	erro=15
	goto 99000				!set error and return
c
c	Set error and return
c	====================
99000	continue
	call errset_('I$CRSS',erro)
	return					!return
c
c	Formats
c	=======
c
	include 'fmt:icrss.fmt'
c
	end
c
c
c
c
	subroutine I$LNKS_(base)
c	************************
c
	implicit none
c
	integer base
c
c	Description
c	===========
c
c	This procedure adds links field to BASE structure.
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer f,pos1,pos2,width,k
c
cdon't!!!!!	call errclr_('I$LNKS')
c
	f=d$nfld(base)
	if (f+3.gt.d$f) goto 9999		!no room !!!
c
	d$fmne(f+1,base)(1:)=' '		!field mnemonic - father
	d$fmne(f+1,base)='$father'
	d$fdes(f+1,base)=' '			!description
	d$fdes(f+1,base)='Owner record#'
	d$type(f+1,base)=lk$
	d$min(f+1,base)=0
	d$max(f+1,base)=999999999
	d$siz(f+1,base)=10
	d$idx(f+1,base)=1			!father is indexed
c
	d$fmne(f+2,base)(1:)=' '		!field mnemonic - link to next
	d$fmne(f+2,base)='$next'
	d$fdes(f+2,base)=' '			!description
	d$fdes(f+2,base)='Link to next'
	d$type(f+2,base)=lk$
	d$min(f+2,base)=0
	d$max(f+2,base)=999999999
	d$siz(f+2,base)=10
	d$idx(f+2,base)=0
c
	d$fmne(f+3,base)(1:)=' '		!field mnemonic - link to last
	d$fmne(f+3,base)='$last'
	d$fdes(f+3,base)=' '			!description
	d$fdes(f+3,base)='Link to last'
	d$type(f+3,base)=lk$
	d$min(f+3,base)=0
	d$max(f+3,base)=999999999
	d$siz(f+3,base)=10
	d$idx(f+3,base)=0
c
	if (f.le.0) then
	   pos2=1				!first field
	else
	   pos2=d$pos(f,base)+d$siz(f,base)-1	!next field
	endif
c
	do k = f+1, f+3
	   d$deci(k,base)=0
	   d$fnam(k,base)(1:)=' '
	   d$mast(k,base)=0
	   d$see(k,base)=0
	   width=d$siz(k,base)
	   pos1=pos2+1				!start pos
	   pos2=pos1+width-1			!end pos
	   d$dflt(base)(pos1:pos2)=' '
	   d$pos(k,base)=pos1			!dont' forget !
	enddo
c
	d$nfld(base)=d$nfld(base)+3
c
	goto 900				!return
c
c	Return
c
900	continue
c
	return					!return
c
c	no room
9999	continue
c
	call errmsg_('I$LNKS',1,mssg,'?')		!get message
	call errdpl_(mssg,d$cmdo)			!system message
	if (d$alte.ne.0.and.s$set(s$alte)) then
	   call errdpl_(mssg,d$alte)			!alt file also
	endif
	call exit					!just exit from DBAG
c
c	Formats
c	-------
c
	end
c
c
c
c
	subroutine I$DCOM_(fchan,wait,erro)
c	***********************************
c
	implicit none
c
	integer fchan,erro
	logical wait
c
c	Description
c	===========
c
c	Executes commands DISPLAY/LIST COMMANDS, called from D$ISPL or
c	L$IST (WAIT .true. or .false.) in module DBAGA.
c	ERRO < 0	abort command
c	     = 0	ok
c	     > 0	fatal error
c
c	DISPLAY usually waits all linmax lines, LIST doesn't.
c
c	If FCHAN > 0, output is directed to channel FCHAN; otherwise, it goes
c	to terminal.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer k, line, width, lg, l1, l2, cmdl
	logical first
c
c	begin
c	=====
c
	call errclr_('I$DCOM')			!error init
	erro=0
c
	if (d$cmdp.le.0) goto 90001		!the command buffer is empty
c
 	call ttwdth_(width)			!current WIDTH
	lg=width-4				!width - " nn:"
c
c	Pretty output
c
	write (mssg,10001)
c
	if (fchan.le.0) then
	   call vset2_(2)			!clean screen from line 2
	   call vset1_(2,1)			!cursor
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	else
	   write (fchan,fmt='(/,a)',err=90002) mssg(2:istrip_(mssg))
	endif
c
	mssg(1:)=' '
	write (mssg(2:),'(<width>(''-''))')
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   call vset3_(6,20)			!set scroll
	   call vset1_(6,1)			!set cursor
	else
	   write (fchan,fmt='(a,/)',err=90002) mssg(2:istrip_(mssg))
	endif
c
c	Display commands now
c
	line=0					!line#
c
c	Command buffer
c
	do 1001 k = 1, d$cmmd
	   if (istrip_(cmdbuf(k)).le.0) goto 100	!end of command buffer
c
	   first=.true.
	   cmdl=len(cmdbuf(k))
	   l1=1
c
50	   continue
c
	      mssg(1:)=' '
	      if (first) then
	         write (mssg(2:3),'(i2.0)') k
	         mssg(4:5)=  ': '
	         first=.false.
	      else
c	         ok, spaces
	      endif
c
	      l2=istrip_(cmdbuf(k)(l1:))
	      if (l2.le.0) goto 80			!end of command
	      if (l2.gt.lg) l2=lg
	      l2=l1+l2-1
	      mssg(6:)=cmdbuf(k)(l1:l2)
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90002) mssg(2:istrip_(mssg))
	      endif
c
	      l1=l2+1
	      if (l1.gt.cmdl) goto 80			!end of command
	      goto 50
c
80	   continue
c
1001	continue
c
100	continue
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!all done, blank line
	   if (erro.ne.0) goto 900			!abort/error
	else
	   write (fchan,fmt='(1x)',err=90002)
	endif
c
900	continue
c
	return
c
c	Error
c	=====
c
c	the command buffer is empty
90001	continue
	erro=1
	goto 99000			!set error and return
c	error writing to output file
90002	continue
	erro=2
	goto 99000			!set error and return
99000	continue
c
	call errset_('I$DCOM',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:idcom.fmt'
c
c
	end
c
c
c
c
	subroutine I$DDAT_(fchan,wildn,wait,erro)
c	*****************************************
c
	implicit none
c
	character*(*) wildn
	integer fchan,erro
	logical wait
c
c	Description
c	===========
c
c	Executes commands DISPLAY/LIST DATABASE, called from D$ISPL or
c	L$IST (WAIT .true. or .false.) in module DBAGA.
c	WILDN contains wild database name to be searched, defaulted to
c	'*' if spaces.
c	First, ?????????.INI files are searched and displayed; then, usual
c	?????????.ROO files are also searc. and displ.
c	ERRO < 0	abort command
c	     = 0	ok
c	     > 0	fatal error
c
c	DISPLAY usually waits all linmax lines, LIST doesn't.
c
c	If FCHAN = 0, output goes to the terminal; otherwise, it goes to
c	channel FCHAN.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
	integer line,lim1,lim2,lim3,width,base,mode,update,size
	character*120 respec
	character*60 fspec
	character*10 bname
	integer k,kkk,nnn,dig,tmpidx,contxt,status,nlock,nv0vers,nonaces
	logical eos,ok,ini,lock,v0vers,found,opn,empty,inuse
	character*10 tmpbas(50)
c
c	begin
c	=====
c
	call errclr_('I$DDAT')			!error init
	erro=0
c
	if (istrip_(wildn).le.0) then
	   wildn(1:)='*'			!default is '*'
	   empty=.true.				!don't forget that
	else
	   empty=.false.
	endif
c
 	call ttwdth_(width)			!current WIDTH
c
c	Pretty output
c
	write (mssg,10001)
c
	if (fchan.le.0) then
	   call vset2_(2)			!clean screen from line 2
	   call vset1_(2,1)			!cursor
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(/,a)',err=90003) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,'(<width+1>(''-''))')
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call vset3_(6,20)			!set scroll
	   call vset1_(6,1)			!set cursor
	else
	   write (fchan,fmt='(a,/)',err=90003) mssg(2:istrip_(mssg))
	endif
c
c	Find/display databases now
c
	line=1
	nnn=0
	tmpidx=0
	nonaces=0
	nlock=0			!# of bases locked by another user
	nv0vers=0		!# of bases with killed records and old version
				!0 (can't be updated without unload/zero/reload)
c
c	.INI .................................
c
	eos=.false.
	found=.false.
	lock=.false.
	v0vers=.false.
	k=0
	fspec(1:)=' '
	fspec(1:)=wildn(1:)
	call givext_(fspec,'.INI')		!add extension
c
c	Find databases
c
	contxt=0
	respec(1:)=' '
	call find_file_(fspec,respec,contxt,eos)
c
cwhile	do while (.not.eos)
1098	continue
	   if (eos) goto 1099
c
	   lock=.false.
	   v0vers=.false.
	      k=k+1				!count possible base name
	      if (k.gt.100) goto 90001		!LOOOOOOP
c
	      lim1=index(respec,']')+1
	      if (lim1.le.1) lim1=index(respec,':')+1
	      lim2=index(respec(lim1:),'.')-1
	      lim3=index(respec,';')-1
	      if (lim1.eq.lim2.or.
     1            lim1.eq.0.or.
     1            lim2.eq.0.or.
     1            lim3.eq.0       ) goto 90001	!????
c
	      if (lim3.gt.0) respec(lim3:)=' '	!get rid of version#
c
	      if (lim2.le.9) then		!max data base name size
c
	         bname(1:)=' '
	         bname(1:)=respec(lim1:lim1+lim2-1)
	         opn=.false.
	         call newbas_(base,bname,inuse)		!see if already open
	         if (inuse) then
	            found=.true.
	         else
	            call frebas_(base)			!it was just to check...
	            mode=0				!usual mode
	            update=1				!try to open for update
	            call opnbas_(base, bname, update, mode, erro)
	            if (erro.eq.0) then
	               found=.true.
	               if (bitsiz(base).le.0) opn=.true.
	            else
	               if     ((d$rsub.eq.'OPNBAS').and.
     1                     (erro.eq.1.or.		!no room
     1                      erro.eq.2    ) ) then	!no i/o channel
	                  call errmsg_(d$rsub,erro,mssg,'?')!get message
	                  call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!display it
	                  if (erro.eq.0) then
	                     call errclr_('I$DDAT')	!clear error if ok
	                     erro=0
	                  endif
	                  goto 900			!return anyway
	               elseif ((d$rsub.eq.'OPNBAS'.and.
     1                          erro.eq.9) .or.	!base locked
     1                         (d$rsub.eq.'OPNBAS'.and.
     1                          erro.eq.18)          ) then !old version 0
	                  found=.true.
	                  if (erro.eq.9) then
	                     lock=.true.
	                     nlock=nlock+1
	                  else
	                     v0vers=.true.
	                     nv0vers=nv0vers+1
	                  endif
	                  call errclr_('I$DDAT')	!clear error
	                  erro=0
	               else
	                  call errclr_('I$DDAT')	!clear error
	                  erro=0
	                  found=.false.
	               endif
	            endif
c
c	            If interactive usage, (re)open all fields !!!
c	            ---------------------------------------------
c
	            if (d$itrv.eq.1) then
	               call opnfls_(base,erro)		!open all d.b. fields
	               if (erro.ne.0) then
	                  call errclr_('I$DDAT')	!ignore errors
	                  erro=0
	               endif
	            endif
c
	         endif
	      endif
c
	      if (found) then				!got one base!
c
	         tmpidx=tmpidx+1			!remember that
	         if (tmpidx.gt.50) goto 90002		!too much .INI
	         tmpbas(tmpidx)(1:)=' '
	         if (lock.or.
	1            v0vers  ) then
	            tmpbas(tmpidx)(1:)=bname		!base name
	         else
	            tmpbas(tmpidx)(1:)=d$unam(base)	!base name
	         endif
c
c	         Display info
c
	         ini=.true.				!via .INI
	         ok=.true.				!accessible...
	         call i$datl_(fchan,base,bname,ok,lock,v0vers,ini,wait,
	1                     line,erro)
	         if (erro.ne.0) goto 900		!error/abort, carry
	         nnn=nnn+1				!count data base
	      endif
c
	      if (opn) then
	         call close_(base,erro)			!close base just opened
	         if (erro.ne.0) then
	            call errclr_('I$DDAT')		!ignore errors
	            erro=0
	         endif
	      endif
c
	      respec(1:)=' '
	      call find_file_(fspec,respec,contxt,eos)
c
	   goto 1098
1099	continue
cwhile	enddo
c
c	.ROO ..................................................
c
	eos=.false.
	found=.false.
	lock=.false.
	v0vers=.false.
	k=0
	fspec(1:)=' '
	fspec(1:)=wildn(1:)
	call givext_(fspec,'.ROO')		!add extension
c
c	Find databases
c
	contxt=0
	respec(1:)=' '
	call find_file_(fspec,respec,contxt,eos)
c
cwhile	do while (.not.eos)
1096	continue
	   if (eos) goto 1097
c
	   lock=.false.
	   v0vers=.false.
	      k=k+1				!count possible base name
	      if (k.gt.100) goto 90001		!LOOOOOOP
c
	      lim1=index(respec,']')+1
	      if (lim1.le.1) lim1=index(respec,':')+1
	      lim2=index(respec(lim1:),'.')-1
	      if (lim1.eq.lim2.or.
     1            lim1.eq.0.or.
     1            lim2.eq.0       ) goto 90001	!????
c
	      if (lim2.le.9) then			!max data base name size
	         bname(1:)=' '
	         bname(1:)=respec(lim1:lim1+lim2-1)
	         opn=.false.
	         call newbas_(base,bname,inuse)		!see if already open
	         if (inuse) then
	            found=.true.
	         else
	            call frebas_(base)			!it was just to check...
	            mode=0					!usual mode
	            update=1				!try to open for update
	            call opnbas_(base, bname, update, mode, erro)
	            if (erro.eq.0) then
	               found=.true.
	               if (bitsiz(base).le.0) opn=.true.
	            else
	               if     ((d$rsub.eq.'OPNBAS').and.
     1                     (erro.eq.1.or.		!no room
     1                      erro.eq.2    ) ) then	!no i/o channel
	                  call errmsg_(d$rsub,erro,mssg,'?')!get message
	                  call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!display it
	                  if (erro.eq.0) then
	                     call errclr_('I$DDAT')	!clear error if ok
	                     erro=0
	                  endif
	                  goto 900			!return anyway

	               elseif ((d$rsub.eq.'OPNBAS'.and.
     1                          erro.eq.9) .or.	!base locked
     1                         (d$rsub.eq.'OPNBAS'.and.
     1                          erro.eq.18)          ) then !old version 0
	                  found=.true.
	                  if (erro.eq.9) then
	                     lock=.true.
	                     nlock=nlock+1
	                  else
	                     v0vers=.true.
	                     nv0vers=nv0vers+1
	                  endif
	                  call errclr_('I$DDAT')	!clear error
	                  erro=0
	               else
	                  call errclr_('I$DDAT')		!clear error
	                  erro=0
	                  found=.false.
	               endif
	            endif
c
c	            If interactive usage, (re)open all fields !!!
c	            ---------------------------------------------
c
	            if (d$itrv.eq.1) then
	               call opnfls_(base,erro)		!open all d.b. fields
	               if (erro.ne.0) then
	                  call errclr_('I$DDAT')	!ignore errors
	                  erro=0
	               endif
	            endif
c
	         endif
	      endif
c
	      if (found) then				!got one base!
c
c	         See if really a new one (i.e., accessible)
c
	         ok=.true.
	         do 1001 kkk = 1, tmpidx
	            if (lock.or.
	1               v0vers  ) then
	               lim1=istrip_(bname)
	               lim2=istrip_(tmpbas(kkk))
	               if (bname(1:lim1).eq.tmpbas(kkk)(1:lim2)) then
	                  ok=.false.			!non-accessible
	                  nonaces=nonaces+1
	               endif
	            else
	               lim1=istrip_(d$unam(base))
	               lim2=istrip_(tmpbas(kkk))
	               if (d$unam(base)(1:lim1).eq.tmpbas(kkk)(1:lim2)) then
	                  ok=.false.			!non-accessible
	                  nonaces=nonaces+1
	               endif
	            endif
1001	         continue
c
c	         Display info
c
	         ini=.false.				!not via .INI
	         call i$datl_(fchan,base,bname,ok,lock,v0vers,ini,wait,
	1                     line,erro)
	         if (erro.ne.0) goto 900		!error/abort, carry
	         nnn=nnn+1				!count data base
	      endif
c
100	      continue
c
	      if (opn) then
	         call close_(base,erro)			!close base just opened
	         if (erro.ne.0) then
	            call errclr_('I$DDAT')		!ignore errors
	            erro=0
	         endif
	      endif
c
	      respec(1:)=' '
	      call find_file_(fspec,respec,contxt,eos)
c
	   goto 1096
1097	continue
cwhile	enddo
c
c	Inform user
c
	mssg(1:)=' '
	if (nnn.le.0) then
	   if (empty) then
	      write (mssg(1:),10005)			!no data base found
	   else
	      write (mssg(1:),10003) wildn(1:istrip_(wildn))!no match
	   endif
	else
	   dig=ndigi_(nnn)
	   call wrivar_(mssg(2:dig+1),nnn,dig,erro)
	   if (erro.ne.0) goto 90004			!write error
	   write (mssg(istrip_(mssg)+1:),10002)
	endif
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)		!write line
	   if (erro.ne.0) goto 900				!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	else
	   write (fchan,fmt='(/,a)',err=90003) mssg(2:istrip_(mssg))
	endif
c
	if (nonaces+nlock+nv0vers .gt. 0) then
	   if (fchan.le.0) then
	      if (wait) then
	         call i$wait_(line,erro)			!wait
	         if (erro.ne.0) goto 900			!error, carry
	      endif
	   endif
	endif
c
	if (nonaces.gt.0) then		!non-accessible bases
	   write (mssg,10004)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	endif
c
	if (nlock.gt.0) then		!locked bases
	   write (mssg,10006)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	   write (mssg,10007)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	endif
c
	if (nv0vers.gt.0) then		!version 0 bases
	   write (mssg,10008)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	   write (mssg,10009)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	   write (mssg,10010)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	   write (mssg,10011)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	   write (mssg,10012)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	   write (mssg,10013)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!write line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(a)',err=90003) mssg(2:istrip_(mssg))
	   endif
	endif
c
	goto 900					!return
c
900	continue
c
	return
c
c	Error
c	=====
c	possible loop or error detected calling RMS
90001	continue
	erro=1
	goto 99000
c	too much .INI files
90002	continue
	erro=2
	goto 99000
c	Problems writing to display file
90003	continue
	erro=3
	goto 99000
c	internal error (read/write error)
90004	continue
	erro=4
	goto 99000
99000	continue
	call errset_('I$DDAT',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:iddat.fmt'
c
c
	end
c
c
c
c
	subroutine I$DATL_(fchan,base,bname,ok,lock,v0vers,ini,wait,line,
	1                  erro)
c	****************************************************************
c
	implicit none
c
	integer fchan,base,line,erro
	logical ok,lock,v0vers,ini,wait
	character*(*) bname
c
c	Description
c	===========
c
c	Displays information about data base BASE on the terminal.
c	(called by I$DDAT module, executing "Display database" command)
c	OK = .false. if base isn't accessible (due to .INI file), LOCK
c	= .true. if base BNAME locked by another user, V0VERS = .true. if
c	base BNAME in old version 0 and can't be updated without
c	unloading/zeroing/reloading it (old killed records list),
c	INI = .true. if base name from .INI file, WAIT =.true. if display
c	should stop every LINMAX lines.
c
c	If FCHAN = 0, output goes to the terminal, otherwise it goes to channel
c	FCHAN.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	character*20 fext
	character*120 fspec,myname
	integer k,ix,io,pos1,pos2,okrec,klrec,lim1
	logical eostr1,eostr2,done
	integer irace,pdim,psize,pdeci
	character*30 race
c
c	begin
c	=====
c
	call errclr_('I$DATL')			!error init
	erro=0
c
c	First, the data base itself
c	===========================
c
	mssg(1:)=' '
c
	if (.not.ok) then
	   mssg(2:2)='*'			!ambiguous
	endif
c
	if (lock.or.v0vers) then
	   mssg(3:11)=bname
	else
	   mssg(3:11)=d$unam(base)
	endif
c
	if     (lock) then
	   mssg(14:19)='locked'
	elseif (v0vers) then
	   mssg(14:19)='v0vers'
	else
	   mssg(14:19)='  ok  '
	endif
c
	if (ini) mssg(29:32)=' y '		!.INI
c
	if (lock.or.v0vers) then		!show only that
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!write line
	      if (erro.ne.0) goto 900		!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)	!wait
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	   goto 900				!all done
	endif
c
	call zrace_(base,race,irace,pdim,psize,pdeci,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (irace.eq.r$b) then			!regular base
	   call zrec2_(base,okrec,klrec,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   write (mssg(21:26),fmt='(i6)') okrec	!alive records
	else
	   mssg(21:26)='   ---'
	endif
c
c	Display line(s)
c
	done=.false.
	pos1=-1
	eostr1=.false.
	pos2=-1
	eostr2=.false.
cwhile	do while ( (.not.eostr2).or.(.not.eostr1) )
1098	continue
	   if (.not. ( (.not.eostr2).or.(.not.eostr1) ) ) goto 1099
c
	   if (.not.eostr1) then
	      call strsec_(d$bfil(base),mssg(33:51),pos1,eostr1)
	   else
	      mssg(33:51)=' '
	   endif
c
	   if (.not.eostr2) then
	      call strsec_(d$bdes(base),mssg(53:81),pos2,eostr2)
	   else
	      mssg(53:81)=' '
	   endif
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!write line
	      if (erro.ne.0) goto 900		!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!error, carry
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   mssg(1:34)=' '
	   if (irace.ne.r$b) then
	      mssg(2:2)='('
	      mssg(3:)=race			!creature
	      mssg(istrip_(mssg)+1:)=')'
	   endif
c
	   goto 1098
1099	continue
cwhile	enddo
c
	if (lock) goto 900			!base is locked, all done
c
c	Now, index and sort files, if any
c	=================================
c
c	Index files
c	-----------
c
	do 1001 k = 1, d$nfld(base)
	   ix=d$idx(k,base)				!indexed ?
	   if (ix.gt.0) then				!field INDEX/KEY/KWIC
	      fspec(1:)=' '
	      fspec=d$bfil(base)			!file spec
	      write(fext,'(''.'',i3.3)') k		!make ext as ".026"
	      call givext_(fspec,fext)
	      io=d$ixio(k,base)				!recover idx channel
	      if (io.le.0) then				!not open, make sure
	         call newc_(io)				!ask for i/o channel
	         if (io.le.0) goto 90002		!no more i/o channels
	         open(unit=io,file=fspec,status='old',	!see if it exists
     1                organization='indexed',
     1                access='keyed',form='unformatted',err=100)
	         goto 120
100	         continue
	         close (unit=io)			!close it
	         call freec_(io)			!get rid of i/o channel
	         io=0
	         goto 150				!forget it
120	         continue
	         close (unit=io)			!close it
	         call freec_(io)			!get rid of i/o channel
	         io=0					!proceed
	      endif
c
	      if     (ix.eq.1) then
	         mssg(53:81)='***** index file *****'
	      elseif (ix.eq.4) then
	         mssg(53:81)='** KWIC index file ** '
	      elseif (ix.eq.2) then
	         mssg(53:81)='*** KEY index file ***'
	      endif
c
	      pos1=-1
	      eostr1=.false.
cwhile	      do while (.not.eostr1)
1096	      continue
	         if (eostr1) goto 1097
c
	         call strsec_(fspec,mssg(33:51),pos1,eostr1)
c
	         if (fchan.le.0) then
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!write line
	            if (erro.ne.0) goto 900		!error, carry
	            mssg(1:34)=' '
	            line=line+1
	            if (wait) then
	               call i$wait_(line,erro)		!wait
	               if (erro.ne.0) goto 900		!error, carry
	            endif
	         else
	            write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	         endif
	         done=.true.
c
	         mssg(53:81)=' '
c
	         goto 1096
1097	      continue
cwhile	      enddo
c
	   endif
150	   continue
1001	continue
c
c	permanent sort file
c	-------------------
c
	if (bitsiz(base).gt.0) then
	   call outk_(%val(bitpnt(base)),3,io)	!hard to read, bitmap...
	   if (io.gt.0) then				!active
	      inquire (unit=io,name=fspec)		!file name
	      if (istrip_(fspec).le.0) then
	         io=0
	         call ink_(%val(bitpnt(base)),3,io)	!??? Forget it
	      else
	         myname(1:)=' '
	         lim1=index(fspec,']')			!no directory, sort file
	         if (lim1.le.0) lim1=index(fspec,':')	!is always [ ] ...
	         myname(1:3)='[ ]'
	         myname(4:)=fspec(lim1+1:)
	         lim1=index(myname,';')
	         if (lim1.gt.0) myname(lim1:)=' '		!no version #
	         mssg(1:)=' '
	         mssg(33:51)=myname(1:)
	         mssg(53:81)='***** sort  file *****'
	         if (fchan.le.0) then
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!write line
	            if (erro.ne.0) goto 900		!error, carry
	            mssg(1:41)=' '
	            line=line+1
	            if (wait) then
	               call i$wait_(line,erro)		!wait
	               if (erro.ne.0) goto 900		!error, carry
	            endif
	         else
	            write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	         endif
	         done=.true.
	      endif
	   endif
	endif
c
	if (.not.done) then
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg(1:34),-1,erro)!write line
	      if (erro.ne.0) goto 900		!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!error, carry
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:34)
	   endif
	endif
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) return			!error/abort comm.
	else
	   write (fchan,'(1x)',err=90001)
	endif
c
c	Return
c
900	continue
c
	return					!return to caller
c
c
c	Error
c	=====
c
c	error writing to display file
90001	continue
	erro=1
	goto 99000
c	no more i/o channels
90002	continue
	erro=2
	goto 99000
99000	continue
	call errset_('I$DATL',erro)
	return
c
	end
c
c
c
c
	subroutine I$DEFD_(base,erro)
c	*****************************
c
	implicit none
c
	integer base,erro
c
c	Description
c	===========
c
c	Sets, in context for BASE, the STANDARD display for base fields.
c
c	If display format (one line/record or /field) isn't defined (.le.0),
c	sets it to 1 (standard format).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbaga2.own'
c
	external ndigi_
	integer  ndigi_
	integer k,kkk,pos,siz,fld,kind,count,dl,bmsize,b2,update,mode,
	1       top,see,f,b
c
c	begin
c	=====
c
	call errclr_('I$DEFD')		!error init
	erro=0
c
	ds$def(base)=1			!standard display
	ds$fmt(base)=1			!format 1
	ds$dl(base)=1			!1 line only
	dl=ds$dl(base)
c
	ds$fld(dl,1,base)=-1		!"false" field for '*' status
	ds$pos(dl,1,base)=1
	ds$siz(dl,1,base)=1
	ds$how(dl,1,base)=1		!text like,
	ds$jus(dl,1,base)=1		!left justified
c
	ds$fld(dl,2,base)=0		!"false" field for rec#
	ds$pos(dl,2,base)=2
c
c	caution: as last record# size may change (eg append command...),
c	the follwoing code should be redone when displaying records.
c
	call zend_(base,k,erro)		!last record#
	if (erro.ne.0) goto 95000
	siz=ndigi_(k)			!record# size
	ds$siz(dl,2,base)=siz
c
	ds$how(dl,2,base)=2		!number like,
	ds$jus(dl,2,base)=2		!right justified
	pos=siz+2
c
c	CAUTION: the code below is repeated in module D$EFIN
c	=======
c
	top=d$nfld(base)+2
	k=2
	kkk=k
c
1001	continue
	   k=k+1
	   if (k.gt.top) goto 1002
c
	   fld=k-2
	   b=base
	   f=fld
	   b2=d$dbio(fld,base)
	   see=d$see(fld,base)
	   if (b2.gt.0.and.see.gt.0) then
	      b=b2
	      f=see
	   endif
	   call zsize_(b,f,siz,erro)
           if (erro.ne.0) goto 1001	!ignore (protection failure?)	
	   call zkind_(b,f,kind,erro)
           if (erro.ne.0) goto 1001	!ignore (protection failure?)	
c
	   kkk=kkk+1
c
	   ds$fld(dl,kkk,base)=fld
	   ds$pos(dl,kkk,base)=pos
	   ds$siz(dl,kkk,base)=siz
c
	   goto (11,12,13,14,15,16,17,18) kind
c
	   goto 10			!non-user become integer r-j
c
10	   continue			!non-user
11	   continue			!integer
13	   continue			!other D.B.
	   ds$how(dl,kkk,base)=2		!all become number like,
	   ds$jus(dl,kkk,base)=2		!right justified
	   goto 99
c
12	   continue			!string
14	   continue			!decimal
15	   continue			!date
16	   continue			!logical
17	   continue			!real
18	   continue			!other D.B. check digit
	   ds$how(dl,kkk,base)=1		!all become text like,
	   ds$jus(dl,kkk,base)=1		!left justified
	   if (kind.eq.x$.or.		!except for decimals
     1         kind.eq.r$.or.		!or reals
     1         kind.eq.r8$.or.		!or double precision
     1         kind.eq.l$   ) then	!or booleans (right just.)
	      ds$jus(dl,kkk,base)=2
	   endif
	   if (kind.eq.c$) then		!and strings (do nothing)
	      ds$jus(dl,kkk,base)=0	!do nothing
	   endif
	   goto 99
c
99	   continue
c
	   if     (kind.eq.d$) then
	      siz=11			!"fix" DATE type size (text like)
	      ds$siz(dl,kkk,base)=siz
	   elseif (kind.eq.x$) then	!decimals need extra room for "."
	      siz=siz+1
	      ds$siz(dl,kkk,base)=siz
	   elseif (kind.eq.r$) then	!reals have fixed format
	      siz=15
	      ds$siz(dl,kkk,base)=siz
	   elseif (kind.eq.r8$) then	!reals too
	      siz=24
	      ds$siz(dl,kkk,base)=siz
	   endif
c
	   pos=pos+siz
c
	   goto 1001
c
1002	continue
c
c	=======
c
	count=kkk+1
	if (count.le.d$f+2) then
	   ds$fld(dl,count,base)=-2	!mark end
	endif
c
	if (ds$fmt(base).le.0) ds$fmt(base)=1	!standard format is 1
c
	return
c
c
c	Errors
c	======
c
c	inherited errors
c
95000	continue
	return
c
c
	end
c
c
c
c
	subroutine I$KILR_ (base,bmap,mode,erro)
c	***************************************
c
	implicit none
c
	integer base, bmap(*), mode, erro
	logical for
c
c	Description
c	===========
c
c	Executes command KILL <scope>..., called from D$ELET
c
c	This procedure kills all selected records, in bit map BMAP,
c	from database BASE (usually database in use).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
	integer code, icode, k, count, kilrec, line, width
	logical curr, eobm
c
c	begin
c	=====
c
	call errclr_('I$KILR')		!error init
	erro=0
c
	curr=.false.				!current record not killed
	kilrec=0
	count=0
 	call ttwdth_(width)			!current WIDTH
c
c	Pretty output
c
	call vset2_(2)		!clean screen from line 2
	call vset1_(2,1)	!cursor
	write (mssg,10003)
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	if (erro.ne.0) goto 800	!error, carry
	write (mssg,'(<width+1>(''-''))')
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) goto 800	!error, carry
	call vset3_(6,20)	!set scroll
c
c	Loop on bit map
c	---------------
c
	line=0
	code=0						!reset bitnxt
	icode=0
	eobm=.false.					!...
	call bitnxt_(bmap,icode,eobm,erro)		!first selected rec.
	if (erro.ne.0) goto 800				!error
	call in3ex_(base,icode,code,erro)
	if (erro.ne.0) goto 800				!error
c
cwhile	do while (.not.eobm)
1098	continue
	   if (eobm) goto 1099
c
	   call kill_(base,code,erro)
	   if     (erro.eq.0) then
	      write (mssg,10001) code		!inform user
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 800			!error, carry
	      if (code.eq.c$rec) curr=.true.	!flag current rec. killed
	      count=count+1
	      line=line+1
	      call i$wait_(line,erro)
	      if (erro.ne.0) goto 800			!abort or error, return
	   elseif (d$rsub.ne.'KILL'.or.			!"record already kil."
	1          erro.ne.4          ) then
	      goto 800					!fatal error, return
	   else
	      call errclr_('I$KILR')			!clear error
	      erro=0
	      kilrec=kilrec+1				!count already killed
	   endif
c
	   call bitnxt_(bmap,icode,eobm,erro)		!first selected rec.
	   if (erro.ne.0) goto 800			!error
	   call in3ex_(base,icode,code,erro)
	   if (erro.ne.0) goto 800			!error
c
	   goto 1098
1099	continue
cwhile	enddo
c
	line=line+3
	call i$wait_(line,erro)			!wait
	if (erro.ne.0) goto 800			!abort or error, return
	if (count.gt.0) then			!be nice
	   write (mssg,10002) count
	else
	   write (mssg,10004)
	endif
	call i$mess_(0,d$cmdo,1,mssg,1,erro)
	if (erro.ne.0) goto 800			!error, carry
	goto 800				!return anyway...
c
c	Return
c
800	continue
c
	if (curr) then			!current record has been killed!
	   call i$sprv_(0,0,0)		!set no current
	   call i$scur_(base,0,0)	!and show user
	endif
c
	return				!return now
c
c	Error
c	=====
c
c	Formats
c	=======
c
	include 'fmt:ikilr.fmt'
c
	end
c
c
c
c
	subroutine I$DELF_(base,delete,erro)
c	************************************
c
	implicit none
c
	integer base,erro
	logical delete
c
c	Description
c	===========
c
c	Deletes/"rebuilts" (DELETE = .true./.false.) all files related
c	to base BASE.
c	Used by D$ELET and Z$ERO modules (DELETE and ZERO commands).
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	integer k,ix,akey
	character*12 fext
	character*64 fspec
c
c	begin
c	=====
c
	call errclr_('I$DELF')		!error init
	erro=0
c
c	Delete or rebuilt index files, if any
c	-------------------------------------
c
	do 1001 k = 1, d$nfld(base)
	   ix=d$idx(k,base)
	   if (ix.gt.0) then			!field indexed/keyed/key part
c
	      if     (ix.eq.4) then
	         akey=2					!KWIC field
	      elseif (ix.eq.2) then
	         akey=1					!field is keyed
	      else
	         akey=0					!normal indexed field
	      endif
c
	      call noindx_(base,k,akey,erro)		!de-index field
	      if (erro.ne.0) return			!error, carry
c
	      if (.not.delete) then
	         call indx_(base,k,akey,erro)		!re-index field
	         if (erro.ne.0) return			!error, carry
	      endif
c
	   endif
1001	continue
c
c	Delete permanent sort file, if any
c	----------------------------------
c
	if (bitsiz(base).gt.0) then
	   call ordclr_(%val(bitpnt(base)),erro)	!clear structure
	   if (erro.ne.0) return			!error, carry
	endif
c
	return
c
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	no i/o channel available
90001	continue
	erro=1
	goto 99000			!set error and return
99000	continue
	call errset_('I$DELF',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$DL_(buf,mark,who)
c	******************************
c
	implicit none
c
	character*(*) buf
	integer mark, who
c
c	Description
c	===========
c
c	This procedure is called from D$ISPL (WHO=1) and L$IST (WHO=2) modules,
c	implementing DISPLAY/LIST commands:
c
c	*****	DISPLAY/LIST COMMANDS		   	   = Implemented =
c			     [TO <file.ext>]
c
c		displays DBAG command buffer
c
c	*****	DISPLAY/LIST STRUCTURE		   	   = Implemented =
c			     [TO <file.ext>]
c
c		displays field names, types, lengths, and decimals (structure)
c		of file in use.
c
c	*****	DISPLAY/LIST FILES <"wild"database>
c			     [TO <file.ext>]
c
c		displays databases (and related files) whose name matches
c		the wild database name.
c
c	*****	DISPLAY/LIST STATUS		   	   = Implemented =
c
c		displays global DBAG info, such as status of opened data bases
c		and current parameters SET and SET TO values
c
c	*****	DISPLAY/LIST	[[SCOPE] <scope list>]
c				[FOR 	 <for   list>]
c				[FIELDS	 <field list>]
c				[ON/OFF]
c				[SORT ON <sort  list>]
c				[WAIT/NOWAIT]
c				[TO <file.ext>]
c
c		displays records of file in use
c
c		DISPLAY next 10 FOR phone = '415'
c		DISP    next 10 FOR phone = '415' SORT ON country A, age D
c
c	The only differences between DISPLAY and LIST commands are:
c
c	1. DISPLAY: after displaying a certain number of lines, wait for any
c		    keystroke to continue, ESCape character aborting display;
c	   LIST:    doesn't wait;
c
c	2. DISPLAY: if [SCOPE] and [FOR] were not specified in the command,
c		    and there is no current SEARCH selection, [SCOPE] =
c	            current record of data base, or first record if none
c		    current;
c	   LIST:    if [SCOPE] and [FOR] were not specified in the command,
c		    and there is no current SEARCH selection, [SCOPE] = all
c	            records.
c
c	Common characteristics:
c
c		- if [SCOPE] wasn't specified, [FOR] wasn't specified but
c	          there is a current SEARCH selection, <scope> = current
c		  SEARCH selection;
c
c		- if [FOR] was specified but not <scope>,  <scope> = all
c		  records;
c
c		- the [FOR] exp list is always evaluated within <scope>;
c
c		- the [OFF/ON] option suppresses/resets the display of the
c		  record# prefix in each displayed record;
c
c		- the [WAIT/NOWAIT] option sets/suppresses waiting for any
c		  keystroke to continue the display of records (the ESCape
c		  character terminating the display;
c
c	<scope list>  procedure scpsyn:	analyse scope list
c				scpchk: check/complete scope list against base
c				scpsem:	complete scope list
c	<for   list>		forsyn:	analyse for list
c				forchk:	check for list against database
c				forsem:	for list semantic execution
c	<field list>		fldsyn:	analyse field list
c				fldsem:	complete field list
c	<sort  list>		srlsyn:	analyse sort list
c				srlchk:	check sort list against database
c				srlsem:	sort list semantic execution
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagd.own'
c
	external istrip_
	integer istrip_
	integer base,update,mode,type,val,dec,lim,p1,p1pos,p1nxt,p2,erro,
	1	prop,irace,pdim,psize,pdeci,bb
	character*40 race
	integer interr,alive,rcount,kcount1,kcount2,badcount,dig,rec,size,
	1	noerr
	real rval
	integer nonoff,nwait,nfiles,nfor,nscope,nsort,nfield,nstruc,nstatu,nto
	integer ndatab,ncomma,bmsize,dnfld,wldpos,wldend,line,nlinks,dtype
	integer nproperty,nseries,nmemo,nnorec
	character*60 fname,owname
	character*12 fext,bname,propname,wildn
	integer k,what,l,ncmmd,zf,zl,izf,izl,topr,scpinf,scpsup,fchan
	logical wait,onoff,cursrc,twice,always,notdone,list,full,edt,prefix
	logical mnem,spacin,answer,edit,new,fwrite,protfail,topbot,defprop,
	1	defseries,defmemo,norec,property,series,memo,newopn
	logical links,basic,reset
	integer bmsz,bm,fmsz,fm,fwhtsz,fwht,fwhosz,fwho,all,allsiz,whoho
	integer pmsz,pm,smsz,sm,mmsz,mm
	integer swmsz,swm,shmsz,shm,long
c
c	begin
c	=====
c
	call errclr_('I$DL')		!error init
	erro=0
c
	edt=.false.
c
	bmsz=0			!temporary bit map (bm) space size
	fmsz=0			!temporary field map (fm) space size
	pmsz=0			!same for properties
	smsz=0			!same for series
	mmsz=0			!same for memos
	fwhtsz=0		!temporary WHAT (fwht) space size
	fwhosz=0		!temporary WHOWHO (fwho) space size
	swmsz=0			!temporary sort map (swm) space size
	shmsz=0			!temporary how to sort (shm) space size
	all=d$f+2		!max possible # fields + 2 for
				!"fields" -1, 0 (mark, rec#)
c
	nonoff=0		!#ON/OFF
	nwait=0			!#WAIT/NOWAIT
	nfiles=0		!#FILES
	nfor=0			!#[FOR ...]
	nscope=0		!#[SCOPE ...]
	nfield=0		!#[FIELD ...]
	nsort=0			!#[SORT ON ...]
	nstruc=0		!#[STRUCTURE ...]
	nstatu=0		!#[STATUS]
	ncomma=0		!#[COMMANDS]
	nto=0			!#[TO]...
	ndatab=0		!#[DATABASE]...
	nlinks=0		!#LINKS
	nnorec=0		!#NORECORDS
	nproperty=0		!#PROPERTY
	nseries=0		!#SERIES
	nmemo=0			!#MEMO
c
	onoff=.true.		!assume ON
	wait  =.true.		!assume WAIT
	reset=.true.		!reset field map
c
	base=0			!no base (yet)
	prop=0			!no property (yet)
c
	if (who.eq.2) then
	   list=.true.		!LIST calling...
	else
	   list=.false.		!DISPLAY calling...
	endif
c
	fchan=0			!i/o channel ([TO] file.ext)
	wildn(1:)=' '		!wild database name
c
c	Loop here to get next keyword or implicit scope
c	-----------------------------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1.and.
     1   	type.ne.2    ) then
	   goto 90002			!syntax error (neither identifier,
					!              integer, or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute command
	elseif (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer or, "eat" SCOPE
	endif
c
c	Loop here if token is a keyword (from SCOPE, FOR or FIELDS)
c	or an implicit SCOPE
c	-----------------------------------------------------------
c
2	continue
c
	if (type.eq.2) then
	   nscope=nscope+1		!count it
	   goto 101			!integer "eat" SCOPE
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.struky) then
	   nstruc=nstruc+1		!count it
	   goto 1			!DISPLAY/LIST STRUCTURE, loop back
	elseif (keypos.eq.statky) then
	   nstatu=nstatu+1		!count it
	   goto 1			!DISPLAY/LIST STATUS, loop back
	elseif (keypos.eq.commky) then
	   ncomma=ncomma+1		!count it
	   goto 1			!DISPLAY/LIST COMMANDS, loop back
	elseif (keypos.eq.scopky)  then
	   nscope=nscope+1		!count it
	   goto 100			!"eat" [SCOPE...]
	elseif (keypos.eq.forky)  then
	   nfor=nfor+1			!count it
	   goto 200			!"eat" [FOR <exp list>]
	elseif (keypos.eq.fielky) then
	   nfield=nfield+1		!count it
	   goto 300			!"eat" [FIELDS <field list>]
	elseif (keypos.eq.sortky) then
	   nsort=nsort+1		!count it
	   goto 350			!"eat" [SORT ON <sort list>]
	elseif (keypos.eq.onky) then
	   nonoff=nonoff+1		!count it
	   onoff=.true.			!set it on
	   goto 1			!and loop back for more
	elseif (keypos.eq.offky) then
	   nonoff=nonoff+1		!count it
	   onoff=.false.		!set it off
	   goto 1			!and loop back for more
	elseif (keypos.eq.waitky) then
	   nwait=nwait+1		!count it
	   wait=.true.			!set it on
	   goto 1			!and loop back for more
	elseif (keypos.eq.nowaky) then
	   nwait=nwait+1		!count it
	   wait=.false.			!set it off
	   goto 1			!and loop back for more
	elseif (keypos.eq.toky) then
	   nto=nto+1			!count it
	   goto 400			!"eat" [TO] phrase
	elseif (keypos.eq.fileky) then
	   nfiles=nfiles+1		!count it
	   goto 450			!"eat" FILES phrase
	elseif (keypos.eq.dataky) then
	   ndatab=ndatab+1		!count it
	   goto 470			!"eat" [DATABASE <database> ]
	elseif (keypos.eq.linkky) then
	   nlinks=nlinks+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.noreky) then
	   nnorec=nnorec+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.propky) then
	   nproperty=nproperty+1	!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.seriky) then
	   nseries=nseries+1		!count it
	   goto 1			!and loop back for more
	elseif (keypos.eq.memoky) then
	   nmemo=nmemo+1		!count it
	   goto 1			!and loop back for more
	else
	   nscope=nscope+1		!count it
	   goto 101			!other keyword, try SCOPE
	endif
c
c	Here to "eat" [SCOPE ...]
c	-------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
101	continue
c
c	Avoid loops due to implicit call to SCPSYN with non-scope keyword
c	-----------------------------------------------------------------
c
	if    (nscope.gt.1) goto 90010	!unexpected keyword
c
c	submit SCOPE syntactical analysis
c	---------------------------------
c
	erro=0				!only my own error messages
	call scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from SCOPE expression with next token
c	------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute command
	else
	   goto 2			!integer or keyword
	endif
c
c	Here to "eat" [FOR ...]
c	-----------------------
c
200	continue
c
c
c	submit FOR syntactical analysis
c	-------------------------------
c
	erro=0				!only my own error messages
	call forsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from FOR expression with next token
c	----------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute command
	else
	   goto 2			!integer or keyword
	endif
c
c	Here to "eat" [FIELDS ...]
c	--------------------------
c
300	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	erro=0				!only my own error messages
	call fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
	reset=.false.			!don't reset anymore
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from FIELDS expression with next token
c	-------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute command
	else
	   goto 2			!integer or keyword
	endif
c
c	Here to "eat" [SORT ON ...]
c	---------------------------
c
350	continue
c
c	Look for ON keyword
c	-------------------
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1) then
	   goto 90014			!syntax error (not ON)
	endif
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.ne.onky) then
	   goto 90014			!ON expected
	endif
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	erro=0				!only my own error messages
	call srlsyn_(type,val,dec,rval,buf,lim,p1,p2,mssg,
     1   	    mark,interr,erro)
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
					!return any allocated memory and return
c
c	come from SORT ON expression with next token
c	--------------------------------------------
c
	if     (type.ne.0.and.
     1          type.ne.2.and.
     1   	type.ne.1    ) then
	   goto 90006			!syntax error (not identifier,
					!integer or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, complete/execute command
	else
	   goto 2			!integer or keyword
	endif
c
c	Here to "eat" [TO] <file.ext>
c	-----------------------------
c
400	continue
c
c	get <database/file.ext>
c	-----------------------
c
c	Look for filespec
c
	fname(1:)=' '
	fext(1:)=' '
	call infspc_(type,what,fname,fext,val,dec,rval,
     1              buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90011		!file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	goto 1					!loop back for more
c
c	Here to "eat" FILES <wildname>
c	------------------------------
c
450	continue
c
	wldpos=1
	notdone=.true.
c
c	Loop here to get more
c
451	continue
c
	erro=0				!next token
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if (type.eq.0) goto 500		!eol, go complete/execute command
c
	if (erro.ne.0) goto 90000	!syntax error (illegal character or
					!too many total digits)
c
	if (notdone) then
	   p1pos=p1
	   p1nxt=p2+1			!next p1
	   notdone=.false.
	else
	   if (p1nxt.ne.p1) then	!end of wildname
	      call rstok_(buf,p1nxt,erro)!restore buffer
	      if (erro.ne.0) goto 900	!error, carry
	      goto 1			!loop back for more
	   else
	      p1nxt=p2+1		!next p1
	   endif
	endif
c
	size=p2-p1+1
	if     (type.ne.1.and.		!identifier
     1          type.ne.24.and.		!identifier with underlines
     1   	type.ne.2.and.		!integer
     1   	type.ne.10.and.		!*
     1   	type.ne.33.and.		!%
     1   	(type.ne.20.or.		!**
     1           size.ne.2    )	) then
	   mark=p1pos
	   goto 90013			!wild database name expect.
	endif
c
	wldend=wldpos+size-1
	if (wldend.gt.12) then
	   mark=p1pos
	   goto 90013			!wild name expected
	endif
c
	wildn(wldpos:wldend)=buf(p1:p2)	!store
	wldpos=wldend+1			!next position
c
	goto 451			!loop back for more
c
c	Here to "eat" [DATABASE...]
c	---------------------------
c
470	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90015			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   write (mssg,10005) buf(p1:p1+size-1)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	   if (erro.ne.0) return		!error, carry
	endif
	bname(1:)=' '
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!loop back for more
c
c	Here to check/complete/execute DISPLAY/LIST command
c	---------------------------------------------------
c
500	continue
c
c	Check command
c	-------------
c
c	check duplicate/incompatible requests in command
c
	ncmmd=0				!# of different command types found
c
	if (nscope.gt.0.or.
     1      nfor  .gt.0.or.
     1      nfield.gt.0)   then
	   ncmmd=ncmmd+1		!one of this type
	endif
c
	if (nstruc.gt.0) ncmmd=ncmmd+1	!and another
c
	if (nstatu.gt.0) ncmmd=ncmmd+1	!...........
c
	if (ncomma.gt.0) ncmmd=ncmmd+1	!...........
c
	if (nfiles.gt.0) ncmmd=ncmmd+1	!...........
c
	if     (nscope.gt.1.or.
     1          nto   .gt.1.or.
     1          nstruc.gt.1.or.
     1          nstatu.gt.1.or.
     1          ncomma.gt.1.or.
     1   	ndatab.gt.1.or.
     1   	nfiles.gt.1.or.
     1          nfor  .gt.1.or.
     1          nfield.gt.1.or.
     1          nwait .gt.1.or.
     1          nlinks.gt.1.or.
     1          nproperty.gt.1.or.
     1          nseries.gt.1.or.
     1          nmemo.gt.1.or.
     1          nnorec.gt.1.or.
     1          nonoff.gt.1   ) then
	   goto 90008				!duplicate requests
	elseif (ncmmd.gt.1) then
	   goto 90009				!incompatible requests
	elseif((nwait .gt.0.or.nonoff.gt.0).and.
     1         (nstruc.gt.0.or.
     1          nstatu.gt.0.or.
     1          ncomma.gt.0)  ) then
	   goto 90009				!incompatible requests
	endif
c
c	Check [TO] file.ext
c	-------------------
c
	if (nto.gt.0) then
	   call givext_(fname,fext)	!add extension
	   call chkext_(fname,erro)	!check extension
	   if (erro.ne.0) then
	      if (d$itrv.eq.1) then	!interactive
	         call errmsg_('CHKEXT',erro,mssg,'%')
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900!error, carry
	         call errclr_('I$DL')	!clear error
	         erro=0
	         d$edit=1		!set edit mode
	         mark=0			!...
	      endif
	      goto 900			!return properly
	   endif
	endif
c
c	Complete command
c	----------------
c
c	Ask for current base if needed and user didn't supply one
c	---------------------------------------------------------
c
	if (nstruc.gt.0.or.		!DISPLAY STRUCTURE
     1      (nstatu.le.0.and.		!or DISPLAY <ret> (implicit scope)
     1       ncomma.le.0.and.		!...
     1       nstruc.le.0.and.		!...
     1       nfiles.le.0     ) ) then	!...
c
	   if (ndatab.gt.0) then		!user supplied database name
	      mode=0
	      update=-1
	      call open_(base,bname,update,mode,newopn,erro)
	      if (erro.ne.0) then
	         if (d$itrv.eq.1) then		!interactive
	            call errmsg_(d$rsub,erro,mssg,'?')!get message
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!display it
	         endif
	         goto 900				!return
	      endif
	   else
	      update=-1					!don't change update
	      mode=0					!usual mode
	      call i$buse_(base,update,mode,bname,erro)	!ask for base in use
	      if (erro.ne.0) return			!error, carry
	      if (base.eq.0) goto 900			!no base, return
	   endif
c
c	   display creatures as well, so (re)open them all
c
	   call opncrt_(base,update,defprop,defseries,defmemo,erro)
	   if (erro.ne.0) then
	      call errclr_('I$DL')			!ignore errors
	      erro=0
	   endif
c
	endif
c
c	Set WAIT/NOWAIT if not supplied
c	-------------------------------
c
	if (nwait.le.0) then
	   if (list) then
	      wait=.false.		!LIST command (don't wait)
	   else
	      wait=.true.		!DISPLAY command (wait)
	   endif
	endif
c
c	User wants to see links if any ?
c	--------------------------------
c
	if (nlinks.gt.0) then
	   links=.true.
	else
	   links=.false.
	endif
c
	norec=.false.
	property=.false.
	series=.false.
	memo=.false.
	if (nnorec.gt.0) norec=.true.
	if (nproperty.gt.0) property=.true.
	if (nseries.gt.0) series=.true.
	if (nmemo.gt.0) memo=.true.
c
	if (norec) then
	   if (.not.property.and.
	1      .not.series.and.
	1      .not.memo         ) goto 90020
	endif
c
c	Race of creature if any
c	-----------------------
c
	if (base.gt.0) then
	   call zrace_(base,race,irace,pdim,psize,pdeci,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (irace.eq.r$b) then
c
	      prop=0					!regular base
c
	   else
c
	      prop=base
c
c	      try to open owner base
c
	      owname(1:)=' '
	      owname=d$ownb(prop)			!open owner base
	      update=-1					!don't change
	      mode=0					!usual mode
	      call open_(bb,owname,update,mode,newopn,erro)
	      if (erro.ne.0) then
	         call errclr_('I$DL')			!can't, ignore
	         erro=0
	      else
c
	         norec=.true.				!no owner records
	         base=bb				!switch to owner base
c
	         if     (irace.eq.r$pp) then
	            property=.true.
	            series=.false.
	            memo=.false.
	         elseif (irace.eq.r$mm) then
	            property=.false.
	            series=.false.
	            memo=.true.
	         else
	            property=.false.
	            series=.true.
	            memo=.false.
	         endif
	      endif
	   endif
	endif
c
c	Set defaults if appliable
c	-------------------------
c
	if     (nstruc.gt.0) then	!DISPLAY/LIST STRUCTURE
	   goto 600				!(no defaults)
	elseif (nstatu.gt.0) then	!DISPLAY/LIST STATUS
	   goto 700				!(no defaults)
	elseif (ncomma.gt.0) then	!DISPLAY/LIST COMMANDS
	   goto 720				!(no defaults)
	elseif (nfiles.gt.0) then	!DISPLAY/LIST FILES
	   goto 750				!(no defaults)
	endif
c
c	DISPLAY/LIST [SCOPE... [FOR... FIELDS...
c	----------------------------------------
c
	if (norec) goto 1122		!skip owner base stuff
c
c	Default scope
c	-------------
c
c	IF DISPLAY:	CURRENT SEARCH if any; if no curr. search, ALL records
c			if FOR specified; if no FOR specified, CURRENT RECORD
c			if any; if no curr. record, TOP record.
c
c	IF LIST:	CURRENT SEARCH if any; if no curr. search, ALL RECORDS.
c
	if (nscope.le.0) then		!no SCOPE
	   if (bitcan(base).eq.1) then	!and no CURRENT SEARCH, set defaults
	      cursrc=.false.		!remember CURR. SEARCH not used
	      if (list) then		!LIST command, default to all records
	         call i$faks_('ALL',0,erro)	!"fake" SCPSYN (ALL records)
	         if (erro.ne.0) goto 900	!error, carry
	      else			!DISPLAY command
	         if (nfor.gt.0) then		!FOR seen
	            call i$faks_('ALL',0,erro)		!"fake" SCPSYN (ALL rec)
	            if (erro.ne.0) goto 900		!error, carry
	         else				!no FOR
	            if (c$base.eq.base.and.
     1                  c$rec.gt.0         ) then
	               call i$faks_('CUR',0,erro)!"fake" SCPSYN (CURRENT record)
	               if (erro.ne.0) goto 900	!error, carry
	            else
	               call i$faks_('TOP',0,erro)!"fake" SCPSYN (TOP record)
	               if (erro.ne.0) goto 900	!error, carry
	            endif
	         endif
	      endif
c
	   else				!use current search
	      cursrc=.true.		!remember CURRENT SEARCH used
	   endif
c
	else				!use SCOPE
	   cursrc=.false.		!remember CURR. SEARCH not used
	endif
c
c	See if current search and not empty
c
	if (cursrc) then
	   rec=0					!don't forget anybody...
	   call bitcnt_(%val(bitpnt(base)),rec,rcount,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (rcount.le.0) goto 90017			!empty!
	endif
c
c	Use always temporary BIT MAP; if CURRENT SEARCH used, both
c	bits maps should have the same definition.
c
	if (cursrc) then
	   call bitlim_(%val(bitpnt(base)),izf,izl,erro)!fake zf,zl
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(base,izf,zf,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call in3ex_(base,izl,zl,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call bitmax_(%val(bitpnt(base)),bmsz,erro)	!bitmap size
	   if (erro.ne.0) goto 900			!error, carry
	   call get_vm_(4*bmsz,bm,erro)			!ask for room
	   if (erro.ne.0) goto 90016			!no memory!
	   call bitini_(%val(bm),bmsz,izf,topr,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call bitcpy_(%val(bitpnt(base)),%val(bm),erro)
	   if (erro.ne.0) return			!error, carry
	else
	   zf=d$unus-d$offs(base)+1			!first record
	   izf=zf
	   call zend_(base,zl,erro)			!and last
	   if (erro.ne.0) goto 900			!error, carry
	   call ex3in_(base,zl,izl,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (izl.le.0) then
	      bmsz=8
	   else
	      bmsz=(izl-izf+1)/32+8			!bit map size
	   endif
	   call get_vm_(4*bmsz,bm,erro)			!ask for room
	   if (erro.ne.0) goto 90016			!no memory!
	   call bitini_(%val(bm),bmsz,izf,topr,erro)
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
c	default FOR (no specific defaults)
c
c	default FIELDS
c
	if (nfield.lt.1) then			!no FIELDS,
	   dnfld=d$nfld(base)
	   fwrite=.false.			!fields are not to be updated
	   call i$fakf_(base,'NON',dnfld,
	1               fwrite,protfail,erro)	!"fake" FLDSYN (all fields)
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
c	complete SCOPE if not CURRENT SEARCH
c
	if (.not.cursrc) then
	   call scpchk_(base,%val(bm),
     1                 scpinf,scpsup,alive,topbot,erro)!check it
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	   if (topbot) then		!TOP/BOTTOM adjustment
	      if (d$itrv.eq.1) then	!interactive
	         write (mssg,10009)
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      endif
	   endif
	   call scpsem_(%val(bm),erro)!complete scope
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	endif
c
c	complete FIELDS if supplied
c
	fmsz=all
	call get_vm_(4*fmsz,fm,erro)		!ask for room anyway
	if (erro.ne.0) goto 90016		!no memory!
c
	pmsz=all
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90016
c
	smsz=all
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90016
c
	mmsz=all
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90016
c
	if (nfield.gt.0) then
c
	   fwrite=.false.			!fields are not to be updated
	   call fldsem_(base,%val(fm),%val(pm),%val(sm),%val(mm),
	1               prefix,twice,fwrite,protfail,erro)!check/complete fields
c
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
c
	endif
c
c	check/complete FOR
c
	if (nfor.gt.0) then
c
c	   allocate temporary space
c
	   fwhtsz=all
	   fwhosz=all
	   call get_vm_(4*fwhtsz,fwht,erro)
	   if (erro.ne.0) goto 90016			!no memory!
	   call get_vm_(4*fwhosz,fwho,erro)
	   if (erro.ne.0) goto 90016			!no memory!
c
c	   check FOR list validity against data base
c
	   call forchk_(base,all,%val(fwho),%val(fwht),allsiz,erro)
c
c	   if errors in fields, types, etc be nice and give full report
c
	   if (erro.ne.0) then
	      mark=0
	      if (erro.eq.1) then			!type conflicts
	         call i$fker_(base,allsiz,%val(fwho),%val(fwht),erro)
	         if (erro.ne.0) goto 900		!error, carry
	         erro=1					!recover error paternity
	         call errset_('FORCHK',erro)		!...
	      endif
	      goto 95000				!everybody goes
	   endif
	endif
c
c	check SORT ON
c
	if (nsort.gt.0) then
c
c	   allocate temporary space
c
	   swmsz=all
	   shmsz=all
	   call get_vm_(4*swmsz,swm,erro)	!ask for room
	   if (erro.ne.0) goto 90016		!no memory!
	   call get_vm_(4*shmsz,shm,erro)	!ask for room
	   if (erro.ne.0) goto 90016		!no memory!
c
c	   check SORT ON list validity against data base
c
	   call srlchk_(base,%val(swm),%val(shm),erro)
c
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!others error
	   endif
c
	endif
c
c	validate SCOPE if FOR not specified and CURRENT SEARCH not used
c
cxcx	if (norec) goto 1122		!skip owner base stuff
c
	if (nfor.le.0.and.
     1      .not.cursrc  ) then
	   call forall_(base,alive,%val(bm),erro)!validate bit map
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
	endif
c
c	FOR semantic execution
c
	if (nfor.gt.0) then
	   call forsem_(base,alive,%val(bm),bmsz,
     1                 page,%val(fwht),erro)
	   if (erro.ne.0) then
	      mark=0
	      goto 95000				!others error
	   endif
	endif
c
c	SORT ON semantic execution
c
	if (nsort.gt.0) then
c
	   if (d$itrv.eq.1) then			!interactive
	      write (mssg,10004)			!'sorting...'
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
	   call srlsem_(base,%val(bm),%val(swm),%val(shm),twice,kcount2,
	1               erro)
c
	   if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	   endif
c
	   if (twice) goto 90018	!twice the same field
c
	endif
c
1122	continue
c
	goto 800			!DISPLAY/LIST [SCOPE.. [FOR.. [FIELDS..
c
c	>>>>>> Execute command DISPLAY/LIST STRUCTURE
c	=============================================
c
600	continue
c
c	open output file and call display routine
c	-----------------------------------------
c
	if (nto.gt.0) then
	   call newc_(fchan)
	   if (fchan.eq.0) goto 90012
	   open(unit=fchan,file=fname,status='new',recl=250,
     1          carriagecontrol='list',err=90012)
	endif
c
c	N.B. FULL not used anymore in line mode
c
	if (.not.s$set(s$scre).or.		!line mode
     1      nto.gt.0              ) then	!or TO file.ext
c
c	   basic structure
c
	   basic=.true.
	   line=1
	   call i$dstr_(fchan,base,prop,basic,links,full,wait,
	1               line,erro)		!display/list basic structure
	   if (erro.ne.0) goto 900		!abort/error
c
	   if (irace.ne.r$b) goto 120		!creature, skip this
c
c	   creatures now
c
cx	   if (.not.defprop.and.
cx	1      .not.defmemo.and.
cx	1      .not.defseries   ) goto 120	!no creatures, skip this
c
	   do k = 1, d$nfld(base)
	      dtype=d$type(k,base)
	      if (dtype.gt.ftusr$) then	!creature ?
	         if (dtype.eq.p$.or.		!property or
	1            dtype.eq.s$.or.		!series or
	1            dtype.eq.mm$   ) then	!memo
	            lim=istrip_(d$fmne(k,base))
	            if     (dtype.eq.p$) then
	               write (mssg,10010) d$fmne(k,base)(1:lim)
	            elseif (dtype.eq.mm$) then
	               write (mssg,10011) d$fmne(k,base)(1:lim)
	            else
	               write (mssg,10012) d$fmne(k,base)(1:lim)
	            endif
	            if (fchan.le.0) then
	               call i$blnk_(wait,line,erro)!blank line
	               if (erro.ne.0) goto 900	!error, carry
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	               if (erro.ne.0) goto 900	!error,carry
	               line=line+1
	               if (wait) then
	                  call i$wait_(line,erro)	!wait
	                  if (erro.ne.0) goto 900	!abort/error
	               endif
	            else
	               lim=istrip_(mssg)
	               if (lim.le.1) lim=2
	               write (fchan,'(/,a)',err=90019) mssg(2:lim)
	            endif
	            prop=d$dbio(k,base)
	            if (prop.gt.0) then
	               basic=.false.			!carry on
	               call i$dstr_(fchan,base,prop,basic,links,full,wait,
	1                           line,erro)		!display/list structure
	               if (erro.ne.0) goto 900		!abort/error
	            else				!creature not found
c	               ...
	            endif
	         endif
	      endif
	   enddo
c
120	   continue
c
	else					!screen mode
	   edit=.false.				!show structure
	   new=.false.				!old data base str.
	   full=.true.
c
	   call stredt_(base,prop,edit,
     1                  bname,new,full,erro)	!show structure (screen mode)
	   edt=.true.
	   if (erro.ne.0) goto 900		!error, carry
c
	   if (irace.ne.r$b) goto 220		!creature, skip this
c
c	   creatures now
c
	   if (.not.defprop.and.
	1      .not.defmemo.and.
	1      .not.defseries   ) goto 220	!no creatures, skip this
c
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.p$) then	!property
	         propname(1:)=' '
	         propname=d$fnam(k,base)	!usually = mnemonic ...
	         mode=0
	         update=-1
	         call open_(prop,propname,update,mode,newopn,erro)
	         if (erro.eq.0) then
	            call stredt_(base,prop,edit,
     1                           propname,new,full,erro)!show structure
	            edt=.true.
	            if (erro.ne.0) goto 900	!error, carry
	         else
	            call errclr_('I$DL')	!ignore error
	            erro=0
	         endif
c
	      endif
	   enddo
c
220	   continue
c
	endif
c
	if (erro.lt.0) erro=0			!command has been aborted
c
	if (erro.ne.0) then
c
c	   carry on ...
c
	else
	   if (nto.gt.0) then
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg(1:),10003)		!done...
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   endif
	endif
c
	goto 900				!return properly
c
c	>>>>>> Execute command DISPLAY/LIST STATUS
c	==========================================
c
700	continue
c
c	open output file and call display routine
c	-----------------------------------------
c
	if (nto.gt.0) then
	   call newc_(fchan)
	   if (fchan.eq.0) goto 90012
	   open(unit=fchan,file=fname,status='new',recl=250,
     1          carriagecontrol='list',err=90012)
	endif
c
	call i$dsta_(fchan,wait,erro)	!display/list status
	if (erro.lt.0) erro=0		!command has been aborted
c
	if (erro.ne.0) then
c
c	   carry on ...
c
	else
	   if (nto.gt.0) then
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg(1:),10003)		!done...
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   endif
	endif
c
	goto 900			!return properly
c
c	>>>>>> Execute command DISPLAY/LIST COMMANDS
c	============================================
c
720	continue
c
c	open output file and call display routine
c	-----------------------------------------
c
	if (nto.gt.0) then
	   call newc_(fchan)
	   if (fchan.eq.0) goto 90012
	   open(unit=fchan,file=fname,status='new',recl=250,
     1          carriagecontrol='list',err=90012)
	endif
c
	call i$dcom_(fchan,wait,erro)	!display/list commands
	if (erro.lt.0) erro=0		!command has been aborted
c
	if (erro.ne.0) then
c
c	   carry on ...
c
	else
	   if (nto.gt.0) then
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg(1:),10003)		!done...
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   endif
	endif
c
	goto 900			!return properly
c
c	>>>>>> Execute command DISPLAY/LIST FILES
c	=========================================
c
750	continue
c
c	open output file and call display routine
c	-----------------------------------------
c
	if (nto.gt.0) then
	   call newc_(fchan)
	   if (fchan.eq.0) goto 90012
	   open(unit=fchan,file=fname,status='new',recl=250,
     1          carriagecontrol='list',err=90012)
	endif
c
	call i$ddat_(fchan,wildn,wait,erro)	!display/list files
	if (erro.lt.0) erro=0			!command has been aborted
c
	if (erro.ne.0) then
c
c	   carry on ...
c
	else
	   if (nto.gt.0) then
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg(1:),10003)		!done...
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   endif
	endif
c
	goto 900				!return properly
c
c	>>>>>> Execute command DISPLAY/LIST [SCOPE] [FOR] [FIELDS] ...
c	--------------------------------------------------------------
c
c	wait  =.true.	wait when displaying
c	onoff =.true.	display rec# prefix
c	rcount = return # of really displayed records
c
800	continue
c
c	inform user, open output file and call display routine
c	-------------------------------------------------------
c
	if (nto.gt.0) then
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg(1:),10002)		!output to file
	      mssg(istrip_(mssg)+2:)=fname(1:)
	      call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	   call newc_(fchan)
	   if (fchan.eq.0) goto 90012
	   long=x$rec+d$f+50		!max record size + max # of fields + ...
	   if (long.lt.132) long=132	!...
	   open(unit=fchan,file=fname,status='new',recl=long,
     1          carriagecontrol='list',err=90012)
	endif
c
c	Mnemonics and spacing
c	---------------------
c
	if (s$set(s$name)) then
	   mnem=.true.			!show mnemonics
	else
	   mnem=.false.
	endif
c
	if (s$set(s$raw)) then
	   spacin=.false.
	else
	   spacin=.true.		!spacing on
	endif
c
c	Inform user
c	-----------
c
	if (irace.ne.r$b) then			!not a regular base, just wait
	   call i$wlin_(24,erro)		!wait at line 24
	   rcount=1				!make it work ...
	else
	   if (nto.gt.0) then
	      always=.true.			!always if TO file
	   else
	      always=.false.			!only if it doesn't fit in tt
	   endif
	   answer=.true.				!wait for answer
	   call i$rsel_(%val(bm),always,answer,rcount,erro)
	endif
c
	if (erro.lt.0) then
	   erro=0				!abort command
	   goto 900				!return properly
	endif
c
c	Creatures
c
	if (.not.defprop) property=.false.
	if (.not.defseries) series=.false.
	if (.not.defmemo) memo=.false.
c
c	nsort > 0 if SORT ON <sort list> specified in command
c	-----------------------------------------------------
c
	if (rcount.gt.0) then
	      call i$drec_(fchan,base,prop,links,%val(bm),%val(fm),nsort,
     1                     wait,onoff,mnem,spacin,rcount,
     1                     norec,property,series,memo,
     1                     kcount1,badcount,erro)
	endif
c
	if (erro.lt.0) then
	   erro=0				!abort command
	   goto 900				!return properly
	endif
c
	if (erro.ne.0) then
	      mark=0
	      goto 95000		!display others error, return any
					!memory space, set edit mode and return
	endif
c
	if (d$itrv.eq.1) then			!interactive
c
	   if (nto.gt.0) then			!TO file.ext
	      write (mssg(1:),10003)		!done...
	      call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   if (kcount1.gt.0.or.badcount.gt.0) then
c
	      if (nto.le.0) then			!to terminal,
	         call i$wlin_(20,erro)		!wait
	         if (erro.lt.0) goto 900	!command has been aborted
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
	      if (kcount1.gt.0.and.
	1         cursrc          ) then	!current search changed
	         if (base.eq.c$base) then	!of current base
	            call i$scur_(c$base,c$rec,0)!show user
	         endif
	      endif	
c
	      if (kcount1.gt.0) then		!#of ignored (killed) records
	         write (mssg(1:),10006) kcount1
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	      endif
c
	      if (badcount.gt.0) then		!#of records with problems
	         write (mssg(1:),10007) badcount
	         call i$mess_(mark,d$cmdo,1,mssg,-1,erro)
	         write (mssg(1:),10008)
	         call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	      endif
c
	      if (kcount1.gt.0.and.
	1         cursrc          ) then	!current search changed
	         if (base.eq.c$base) then	!of current base
	            call i$scur_(c$base,c$rec,c$fld)!show user
	         endif
	      endif	
c
	   endif
c
	endif
c
	goto 900				!return properly
c
c
c	           R   E   T   U   R   N
c	======================================================
c	Deallocate any memory space
c	Return to main loop
c	======================================================
c
900	continue
c
c	Free temporary memory space
c
	call free_vm_(4*bmsz,bm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*swmsz,swm,noerr)
	call free_vm_(4*shmsz,shm,noerr)
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (fchan.gt.0) then
	   close (unit=fchan)
	   call freec_(fchan)
	   fchan=0
	endif
c
	if (nsort.gt.0.and.bmsz.gt.0) then	!temporary sort
	   call ordclr_(%val(bm),noerr)		!clear structure
	   if (noerr.ne.0) then
	      call errclr_('I$DL')
	      erro=0
	   endif
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier,integer, or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	keyword, integer or eol expected
90006	continue
	mark=p1
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	incompatible requests on command (syntax error)
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	unexpected keyword or SCOPE called twice
90010	continue
	mark=p1
	erro=10
	goto 99000			!display error and return properly
c	file.ext expected after TO
90011	continue
	mark=p2
	erro=11
	goto 99000			!display error and return properly
c	can't open output file (no more i/o channels ?)
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	wild database name expected
90013	continue
	erro=13
	goto 99000			!display error and return properly
c	ON expected after SORT keyword
90014	continue
	mark=p2
	erro=14
	goto 99000			!display error and return properly
c	data base name expected
90015	continue
	mark=p2
	erro=15
	goto 99000			!display error and return properly
c	memory (get_vm_) failure
90016	continue
	erro=16
	goto 99000			!display error and return properly
c	current search is empty
90017	continue
	erro=17
	goto 99000			!display error and return properly
c	same field twice in <sort list>
90018	continue
	erro=18
	goto 99000			!display error and return properly
c	error writing to output file
90019	continue
	erro=19
	goto 99000			!display error and return properly
c	NORECORDS, specify PROPERTY
90020	continue
	erro=20
	goto 99000			!display error and return properly
c
c	Display error message (?...), deallocate space and return
c	=========================================================
99000	continue
c
	call free_vm_(4*bmsz,bm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*swmsz,swm,noerr)
	call free_vm_(4*shmsz,shm,noerr)
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('I$DL',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('I$DL',erro)		!set global error
	endif
c
	if (fchan.gt.0) then
	   close (unit=fchan)
	   call freec_(fchan)
	   fchan=0
	endif
c
	if (nsort.gt.0.and.bmsz.gt.0) then	!temporary sort
	   call ordclr_(%val(bm),noerr)		!clear structure
	   if (noerr.ne.0) then
	      call errclr_('I$DL')
	      erro=0
	   endif
	endif
c
	return
c
c	Display others error message (?...), deallocate space and return
c	================================================================
95000	continue
c
	call free_vm_(4*bmsz,bm,noerr)
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
	call free_vm_(4*fwhtsz,fwht,noerr)
	call free_vm_(4*fwhosz,fwho,noerr)
	call free_vm_(4*swmsz,swm,noerr)
	call free_vm_(4*shmsz,shm,noerr)
c
	if (edt) then
	   call vset2_(2)			!clean screen from line 2
	   call vset3_(2,24)			!normal scrolling
	   call i$scur_(c$base,c$rec,c$fld)	!re-inform user about current
	   edt=.false.
	endif
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	if (fchan.gt.0) then
	   close (unit=fchan)
	   call freec_(fchan)
	   fchan=0
	endif
c
	if (nsort.gt.0.and.bmsz.gt.0) then	!temporary sort
	   call ordclr_(%val(bm),noerr)		!clear structure
	   if (noerr.ne.0) then
	      call errclr_('I$DL')
	      erro=0
	   endif
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:idl.fmt'
c
	end
c
c
c
c
	subroutine i$help_(buf,who,ifname,mark)
c	***************************************
c
	implicit none
c
	character*(*) buf,who,ifname
	integer mark
c
c	Description
c	===========
c
c	Implements "HELP-LIKE" commands, request by WHO, using file IFNAME:
c
c	XPTO [<keyword>]    [TO <file.ext>]
c
c	If <keyword> = '*', display all texts available
c	If <keyword> isn't present, displays a list of all possible
c	keywords.
c
c	Otherwise, searches text for <keyword>.
c
c	[TO <file.ext>] option directs output to a file, instead of the
c	terminal.
c
c	Formats:	- xpto
c			- xpto <keyword>!*
c			- xpto <keyword>!* TO <file.ext>
c			- xpto TO <file.ext>
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer index
	external istrip_
	integer istrip_
c
	integer ichn/0/,ochn,lim,erro,line,width,what,ktxtsz
	integer type,val,dec,l,k,p1,p2,rval
	logical alltxt,onekey,allkey,tofile,found,notdone
	character*60 ktxt,ofname
	character*12 ofext
c
c	begin
c	=====
c
c	Init error
c
	call errclr_('I$HELP')
	erro=0
c
c	see which type
c
	alltxt=.false.
	allkey=.false.
	onekey=.false.
	found=.false.
	tofile=.false.
	notdone=.true.
	ochn=0
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 90000		!illegal character/too many dig.
c
	if     (type.eq.0) then			!eol, all available keywords
	   allkey=.true.
	   goto 70				!execute command
	elseif (type.eq.1) then			!keyword
	   ktxt(1:)=' '
	   ktxt=buf(p1:p2)			!save keyword
	   ktxtsz=p2-p1+1
	   call uc_(ktxt(1:ktxtsz))
	   if (ktxtsz.eq.2.and.
     1         ktxt(1:ktxtsz).eq.'TO') then
	      tofile=.true.			!TO <file.ext>
	      allkey=.true.
	   else
	      onekey=.true.
	   endif
	elseif (type.eq.14) then		! "?"
	   onekey=.true.
	   ktxt(1:1)='?'
	   ktxtsz=1
	elseif (type.eq.19) then		! "@"
	   onekey=.true.
	   ktxt(1:1)='@'
	   ktxtsz=1
	elseif (type.eq.2) then			!number
	   onekey=.true.
	   ktxt(1:9)='<record#>'
	   ktxtsz=9
	elseif (type.eq.10) then		! "*"
	   alltxt=.true.
	else
	   allkey=.true.
	endif
c
	if (.not.tofile) then
c
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if (erro.ne.0) goto 90000		!syntax error
c
	   if (type.eq.0) goto 70		!eol, execute command
c
	   if (type.eq.1) then			!keyword
	      call uc_(buf(p1:p2))
	      if (p2-p1+1.eq.2.and.
     1            buf(p1:p2).eq.'TO') then
	         tofile=.true.			!TO <file.ext>
	      else
	         goto 90007			!???
	      endif
	   else
	      goto 90007			!???
	   endif
c
	endif
c
c	look for filespec
c
	ofname(1:)=' '
	ofext(1:)=' '
	call infspc_(type,what,ofname,ofext,val,dec,rval,
     1                  buf,lim,p1,p2,mssg,erro)
c
	if (type.ne.36) goto 90006		!file.ext expected
c
c	name.ext (what=1), name. (what=2) or name (waht=3)
c
	call givext_(ofname,ofext)
c
	call newc_(ochn)
	if (ochn.le.0) goto 90004		!no more i/o channels
	open (unit=ochn,file=ofname,status='new',recl=132,
     1           carriagecontrol='list',err=90005)
c
c	See if line is clean
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 90000		!syntax error
c
	if (type.ne.0) goto 90003		!eol expected
c
c	Execute command
c
70	continue
c
	call newc_(ichn)
	if (ichn.le.0) goto 90004		!no more i/o channels
	open(unit=ichn,file=ifname,status='old',
     1       readonly,carriagecontrol='list',err=90001)
c
 	call ttwdth_(width)			!current WIDTH
c
c	Pretty output
c
1	continue
	line=0
	call vset3_(2,24)			!magic...
	call vset2_(2)				!clean screen from line 2
	call vset1_(3,1)			!cursor
c
c	Anounce work
c	------------
c
	if     (onekey) then
	      write (mssg,10002) who
	      write (mssg(istrip_(mssg)+2:),'(a)')ktxt(1:ktxtsz)
c
	elseif (allkey) then
	      write (mssg,10001) who
c
	elseif (alltxt) then
	      write (mssg,10005) who
c
	else
	      goto 90002
	endif
c
	if (tofile) then
	   lim=istrip_(mssg)
	   if (lim.le.1) lim=2
	   write (ochn,fmt='(a)',err=90005) mssg(2:lim)
	   write (mssg(lim+2:),10004) ofname(1:istrip_(ofname))
	endif
	lim=istrip_(mssg)
	call i$mess_(0,d$cmdo,-1,mssg(1:lim),-1,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	write (mssg,'(<width+1>(''-''))')
	lim=width+1
	if (tofile) then
	   write (ochn,fmt='(a,/)',err=90005) mssg(2:lim)
	endif
	call i$mess_(0,d$cmdo,-1,mssg(1:width),-1,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	call vset3_(6,20)			!set scroll
	call vset1_(5,1)			!set cursor
c
c	Do work
c	-------
c
10	continue
c
	read (ichn,'(a)',end=100,err=90001) mssg
c
	lim=istrip_(mssg)
	if (lim.eq.0) then
	   lim=2
	   mssg(1:1)='  '
	endif
	if (.not.tofile) then
	   call i$wait_(line,erro)		!wait
	   if (erro.lt.0) goto 200		!command has been aborted
	   if (erro.ne.0) goto 900		!error, return
	endif
c
	if     (alltxt) then			!everything
	   if     (mssg(1:1).eq.'-') then	!break
	      if (tofile) then
	         write (ochn,'(/)',err=90005)
	      endif
	      if (notdone) then
	         notdone=.false.
	      else
	         if (.not.tofile) then
	            line=999999			!force break
	            call i$wait_(line,erro)	!wait
	            if (erro.lt.0) goto 200	!command aborted
	            if (erro.ne.0) goto 900	!error, return
	            call vset2_(5)		!clean screen from line 5
	            call vset1_(6,1)		!set cursor
	         endif
	      endif
	      line=line+1
	      if (tofile) then
	         write (ochn,fmt='(a)',err=90005) mssg(2:lim)
	         l=index(mssg(3:),' ')-1
	         l=3+l-1
	         if (l.lt.3) l=3
	         do 1001 k = 3,l
	            mssg(k:k)='='
1001	         continue
	         write (ochn,fmt='(a)',err=90005) mssg(2:l)
	      else
	         call i$mess_(0,d$cmdo,-1,mssg(2:lim),-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   elseif (mssg(1:1).eq.'+') then
	      line=line+2
	      if (tofile) then
	         write (ochn,fmt='(/,a)',err=90005) mssg(2:lim)
	      else
	         call i$mess_(0,d$cmdo,1,mssg(2:lim),-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   else
	      line=line+1
	      if (tofile) then
	         write (ochn,fmt='(a)',err=90005) mssg(2:lim)
	      else
	         call i$mess_(0,d$cmdo,-1,mssg(2:lim),-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   endif
c
	elseif (allkey) then			!abstracts
	   if (mssg(1:1).eq.'-') then
	      line=line+1
	      if (tofile) then
	         write (ochn,fmt='(a)',err=90005) mssg(2:lim)
	      else
	         call i$mess_(0,d$cmdo,-1,mssg(2:lim),-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
	   endif
c
	elseif (onekey) then			!keyword
	   l=index(mssg(3:),ktxt(1:ktxtsz))
	   if (mssg(1:1).eq.'-'.and.l.eq.1) then
	      found=.true.
	      line=line+1
	      if (tofile) then
	         write (ochn,fmt='(a)',err=90005) mssg(2:lim)
	      else
	         call i$mess_(0,d$cmdo,-1,mssg(2:lim),-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
15	      continue
c
	      read (ichn,'(a)',end=100,err=90001) mssg
	      if     (mssg(1:1).eq.'-') then	!end-of-work
	         goto 100
	      else
	         if (mssg(1:1).eq.'+') then	!break
	            if (tofile) then
	               write (ochn,'(/)',err=90005)
	            else
	               line=999999		!force break
	               call i$wait_(line,erro)	!wait
	               if (erro.lt.0) goto 200	!command has been aborted
	               if (erro.ne.0) goto 900	!error, return
	               call vset2_(5)		!clean screen from line 5
	               call vset1_(6,1)		!set cursor
	            endif
	         endif
c
	         lim=istrip_(mssg)
	         if (lim.eq.0) then
	            lim=2
	            mssg(1:1)='  '
	         endif
	         line=line+1
	         if (tofile) then
	            write (ochn,fmt='(a)',err=90005) mssg(2:lim)
	         else
	            call i$mess_(0,d$cmdo,-1,mssg(2:lim),-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	            call i$wait_(line,erro)	!wait
	            if (erro.lt.0) goto 200	!command has been aborted
	            if (erro.ne.0) goto 900	!error, return
	         endif
	         goto 15			!loop for more on keyword
	      endif
	   endif
	else
	   goto 90002
	endif
c
	if (erro.ne.0) goto 900			!error, return
	goto 10
c
c	end-of-file or end-of-work
c
100	continue
	if (onekey.and.(.not.found)) then
	   mssg(1:)=' '
	   write (mssg,10003) who, ktxt(1:ktxtsz)
	   if (tofile) then
	      line=0
	      tofile=.false.			!terminal only
	      write (ochn,10006,err=90005) who, ktxt(1:ktxtsz)
	   endif
	   call i$mess_(0,d$cmdo,-1,mssg,1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   line=line+2
	   allkey=.true.
	   onekey=.false.
	   alltxt=.false.
	   rewind(unit=ichn)			!back to the beginning
	   goto 10				!all keywords, please
	endif
c
c	<ESC>
c
200	continue				!end of file or <ESC>
c
	erro=0
	goto 900
c
c	Return
c	------
c
900	continue
c
	if (ochn.gt.0) then
	   close (unit=ochn)
	   call freec_(ochn)
	   ochn=0
	endif
c
	if (ichn.gt.0) then
	   close (unit=ichn)
	   call freec_(ichn)
	   ichn=0
	endif
c
	return
c
c	Errors
c	======
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90008
	else
	   goto 90009
	endif
c	error opening/reading file
90001	continue
	d$rinf=ifname
	erro=1
	goto 99000
c	internal error
90002	continue
	erro=2
	goto 99000
c	eol expected
90003	continue
	mark=p1
	erro=3
	goto 99000
c	no more i/o channels
90004	continue
	erro=4
	goto 99000
c	error opening/writing output file
90005	continue
	d$rinf=ofname
	erro=5
	goto 99000
c	<file.ext> expected
90006	continue
	mark=p2
	erro=6
	goto 99000
c	eol or TO <file.ext> expected
90007	continue
	mark=p1
	erro=7
	goto 99000
c	illegal character
90008	continue
	mark=p1
	erro=8
	goto 99000			!display error and return properly
c	too many digits
90009	continue
	mark=p1
	erro=9
	goto 99000			!display error and return properly
c
c	Give error message (?...) and return
c	====================================
99000	continue
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('I$HELP',erro,mssg,'?')	!get error message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('I$HELP',erro)		!set global error
	endif
c
	return					!return
c
c	Formats
c	=======
c
	include 'fmt:ihelp.fmt'
c
	end
c
c
c
c
	subroutine I$DREC_(fchan,base,prop,links,bmap,fmap,sorted,
     1                     wait,onoff,mnem,spacin,rcount,
     1                     norec,property,series,memo,
     1                     kcount,badcount,erro)
c	***********************************************************
c
	implicit none
c
	integer fchan,base,prop,bmap(*),fmap(*)
	integer mode, rcount
	integer sorted,kcount,badcount,erro
	logical links,wait,onoff,mnem,spacin,norec,property,series,memo
c
c	Description
c	===========
c
c	Executes  commands  DISPLAY/LIST <scope>..., called from D$ISPL or
c	L$IST in module DBAGA.
c
c	ERRO < 0	abort command
c	     = 0	ok
c	     > 0	fatal error
c
c	This  procedure  displays  all selected records from database BASE
c	(usually  database  in  use) in a one record/line basis, according
c	to  the  current  display. The  user  has also perhaps given field
c	references  in  field  array FMAP and  ON/OFF directive (OFF means
c	don't  show  record  number). These  indications  are "anded" with
c	the current display.
c	FMAP  contains  field#'s  to  be  displayed, ending with  0 or max
c	number of fields for BASE.
c	If ONOFF=.false., the record# prefix is not displayed.
c	If record# already exists in field map, the record# prefix is not
c	displayed.
c
c	The display format depends on current format used.
c
c	If WAIT=.true., the display will be suspended every certain number
c	of records have been displayed, and resume when any key is stroken,
c	except  abort  ( usually  ESCape )  key  that  suspends displaying.
c
c	In addition, if SPACIN = .false., fields are displayed with no spacing
c	between them; if MNEM = .true., field mnemonics will be shown.
c
c	FCHAN,  if > 0, is  the  i/o channel to direct output; if 0, output
c	will be to the terminal as usual.
c
c	SORTED  argument, if  > zero, tells that display is locally  sorted.
c	If zero its either not sorted at all or "permanently" sorted.
c
c	3rd  position of bitmap is non zero if "sorted" bitmap.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbaga2.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
c
	integer long,long2
	parameter ( long=x$rec+20, long2=x$fld+20)
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
c
	character*10 fnam1*60,fnam2*60
	character*(long) linsub,mymssg
	character*(long2) mymss2
	integer recnum,function,line1,irec,line,hisliv,width,pp
	integer type,ttend,datnum,fmtsav
	integer fld,how,jus,knd,lim,value,pos,kpos,siz,ksiz,mnesiz,dl,xtype
	integer k,kkk,j,p,p1,p2,ls,top,dtop,lstrec,format,form,skip,ncol
	logical sort,empty,eobm,there,myonof,tty,badrec,stdform,odbk
	integer filpos(d$f+2),filsiz(d$f+2),b,f,b2,see
	integer field(d$f+2),dsidx(d$f+2),didx,lstsiz
	logical oldprop,pexist
c
c	begin
c	=====
c
	call errclr_('I$DREC')				!error init
	erro=0
c
	if (norec) goto 123				!skip records stuff
c
	call zend_(base,lstrec,erro)			!last record#
	if (erro.ne.0) goto 95000
	lstsiz=ndigi_(lstrec)				!size for "#"
c
	if (fchan.le.0) then
	   call ttwdth_(width)				!tt current width
	   width=width+1				!+1 for tt output
	   tty=.true.					!write to tty
	else
	   width=long
	   tty=.false.					!write to channel fchan
	endif
c
c	get first record
c	================
c
c
c	Any display defined ?
c	---------------------
c
	if (ds$def(base).eq.0) then			!no, do it
	   fmtsav=ds$fmt(base)				!but save format first
	   call i$defd_(base,erro)
	   if (erro.ne.0) goto 90002
	   if (fmtsav.le.0) fmtsav=1
	   ds$fmt(base)=fmtsav				!restore format
	endif
c
c	Get format from context
c	-----------------------
c
	format=ds$fmt(base)
c
	dl=ds$dl(base)			!format line
	dl=1				!temporary only one line
c
c	Standard format ?
c	-----------------
c
	if (ds$def(base).le.1) then
	   stdform=.true.
	else
	   stdform=.false.
	endif
c
c	Local sort, permanent sort or no sort at all
c	--------------------------------------------
c
	if (sorted.gt.0) then
	   sort=.true.			!local sort
	else
	   if (bmap(3).gt.0) then
	      sort=.true.		!permanent sort
	   else
	      sort=.false.		!no sort at all
	   endif
	endif
c
c	Where is last used position ( top ) in FMAP ? ( = c$fn anyway ...)
c	------------------------------------------------------------------
c
	ls=d$f
c
	top=c$fn
	do 1001 k = 1, top
	   if (fmap(k).eq.0) then	!0 means record#
	      myonof=.false.		!no need to display prefix ...
	      goto 10
	   endif
1001	continue
10	continue
c
c	Record# size
c	------------
c
	call zend_(base,lstrec,erro)			!last record#
	if (erro.ne.0) goto 95000
	lstsiz=ndigi_(lstrec)				!size for "#"
c
c	Where is last used position ( dtop ) in DS$FLD ?
c	------------------------------------------------
c
	dtop=ls+2
	do 1002 j=1,ls+2
	   if (ds$fld(dl,j,base).eq.0) ds$siz(dl,j,base)=lstsiz
	   if (ds$fld(dl,j,base).eq.-2) then
	      dtop=j-1
	      goto 11
	   endif
1002	continue
11	continue
c
c	If user mentioned fields add rec# if not there and wanted
c	---------------------------------------------------------
c
	if (top.ne.0) then
c
	   do k = 1, top
	      if (fmap(k).eq.0) goto 1033
	   enddo
c
	   if (onoff) then
	      do 1003 k=top,1,-1
	         fmap(k+1)=fmap(k)
1003	      continue
	      fmap(1)=0			!rec #
	      top=top+1
	   endif
c
	endif
c
1033	continue
c
c	In general, did the user mention any fields at all ?
c	----------------------------------------------------
c
	if (top.eq.0) then		!he/she didn't,
c
	   do 1004 j=1,dtop
	      fmap(j)=ds$fld(dl,j,base)	!so consider all from current display
	      if     (fmap(j).lt.0) then
	         dsidx(j)=0		!forget old "*" mark
	      elseif (fmap(j).eq.0.and.	!rec#
	1             stdform.and.	!from standard display
	1             .not.onoff      ) then	!but not wanted
	         dsidx(j)=0		!don't show prefix
	      else
	         dsidx(j)=j		!index into current display
	      endif
1004	   continue
	   top=dtop
c
	else				!he/she did mention, silly twit
c
	   do 1005 k=1,top
	      dsidx(k)=0		!assume not there
	      do 1006 j=1,dtop
	         if (ds$fld(dl,j,base).eq.fmap(k)) then
	            dsidx(k)=j
	         endif
1006	      continue
1005	   continue
c
	endif
c
c	Get mnemonics for header line, set position /size for each field
c	----------------------------------------------------------------
c
	mymssg(1:)=' '					!clean mymssg
	linsub(1:1)=' '
	do 1009 k=2,width
	   linsub(k:k)='-'
1009	continue
c
	ncol=0						!# of columns/rows
	pos=2						!start at col. TWO!
	do 1010 k=1,top					!loop in fields
	   didx=dsidx(k)				!index
	   if (didx.le.0) goto 1010			!nops
	   p=fmap(k)					!field
	   if (p.lt.0) goto 1010			!-1=old "*" mark, ignore
c
	   fld=ds$fld(dl,didx,base)			!field to show
	   siz=ds$siz(dl,didx,base)
	   jus=ds$jus(dl,didx,base)
c
	   if (fld.eq.0) then				!rec#
	      mymssg(pos:)='#'
	      siz=lstsiz
	      lim=pos+siz-1
	      if (lim.gt.width.and.
     1            format.eq.1      ) goto 1010	!no room (only format 1)
	   else
c
	      xtype=d$type(fld,base)
	      if (xtype.gt.ftusr$) then		!non-user fields
	         if (xtype.eq.lk$.and.		!link
	1            links) then
c	            ok, show him
	         else
	            goto 1010			!not wanted, skip it
	         endif
	      endif
c
	      lim=pos+siz-1
	      if (lim.gt.width.and.
     1            format.eq.1      ) goto 1010	!no room (only format 1)
	      b=base
	      f=fld
	      b2=d$dbio(fld,base)
	      see=d$see(fld,base)
	      if (b2.gt.0.and.see.gt.0) then		!show the good one
	         b=b2
	         f=see
	      endif
	      call zmne_(b,f,mymssg(pos:lim),erro)
	      if (erro.ne.0) goto 1010			!protected field, ignore
	   endif
c
	   ncol=ncol+1
c
	   if (lim.gt.width.and.
     1            format.eq.1      ) goto 100		!no more room
	   if     (jus.eq.1) then			!left justified
	      call ljust_(mymssg(pos:lim))
	   elseif (jus.eq.2) then			!right just.
	      call rjust_(mymssg(pos:lim))
	   elseif (jus.eq.3) then			!center
	      call center_(mymssg(pos:lim))
	   else					!0=do nothing
c	      ok
	   endif
c
c	   keep track of start, size (field size)
c
	   filpos(ncol)=pos
	   filsiz(ncol)=siz
	   field(ncol)=fld
c
	   pos=pos+siz
	   if (spacin) then
	      pos=pos+1				!spacing on
	      lim=lim+1
	      if (lim.gt.width.and.
     1                format.eq.1      ) goto 100	!no more room
	      linsub(lim:lim)=' '			!so pretty...
	   endif
c
1010	continue
100	continue
c
	mnesiz=pos-1
c
c	Write mnemonics
c
	if (tty) then
	   if (format.eq.1) then		!formato 1
	      call vset2_(2)				!clean screen
	      if (mnem) then
	         call vset1_(2,1)			!cursor
	         lim=mnesiz
	         if (lim.gt.width) lim=width		!truncate it to width
	         call i$mess_(0,d$cmdo,1,mymssg(1:lim),-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         call i$mess_(0,d$cmdo,-1,linsub(1:lim),-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	      else
	         call vset1_(5,1)			!cursor
	      endif
	   else					!formato 2
	      call vset2_(2)				!clean screen
	      call vset1_(4,1)				!cursor
	      linsub(1:1)=' '
	      do k = 1, 132
	         linsub(k:k)='-'
	      enddo
	      call i$mess_(0,d$cmdo,-1,linsub(1:132),-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	   endif
	else
	   if (format.eq.1) then		!formato 1
	      lim=mnesiz
	      write (fchan,'(a)',err=90001) mymssg(2:lim)
	      write (fchan,'(a)',err=90001) linsub(2:lim)
	   endif
	   call vset2_(2)				!clean screen
	   call vset1_(4,1)				!cursor
	   linsub(1:1)=' '
	   do k = 1, 132
	      linsub(k:k)='-'
	   enddo
	   call i$mess_(0,d$cmdo,-1,linsub(1:132),-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	endif
	call vset3_(6,20)				!set scroll
c
	line=0						!line #
	rcount=0					!clear # accept. rec.
	kcount=0					!and killed (this d.b.)
	badcount=0					!with problems
c
c	Loop in bit map or sorted bit map
c	---------------------------------
c
	recnum=0				!reset map
	irec=0
	eobm=.false.				!...
	if (sort) then
	   call ordnxt_(bmap,irec,eobm,erro)	!first selected rec.
	   if (erro.ne.0) then
	      sort=.false.			!try sequential (no sort file ?)
	      call errclr_('I$DREC')		!clear error
	      erro=0
	   endif
	endif
	if (.not.sort) then
	   call bitnxt_(bmap,irec,eobm,erro)	!first selected rec.
	   if (erro.ne.0) goto 95000
	endif
	call in3ex_(base,irec,recnum,erro)
	if (erro.ne.0) goto 95000
c
123	continue
c
	if (norec) eobm=.false.			!make it work ...
c
cwhile	do while (.not.eobm)
1098	continue
	   if (eobm) goto 1099
c
	   if (norec) goto 50			!skip records stuff
c
	   badrec=.false.			!record (hopefully) ok
	   mymssg(1:)=' '			!clean mymssg
	   hisliv=2				!ask for all
	   odbk=.false.			!not o.d.b. killed record
	   call find_(base,recnum,hisliv,d$xbuf,erro)
	   if (erro.ne.0) then
	      if (d$rsub.eq.'FIND'.and.
	1         erro.eq.5          ) then
	         kcount=kcount+1
	         goto 50				!ignore
	      else
	         badrec=.true.				!don't forget
	         d$xbuf(1:)='*'				!fill with '*'
	      endif
	   endif
c
c	   Loop in fields
c	   --------------
c
	   pos=2					!start at column TWO!!!
c
	   do 1013 k=1,top
c
	      didx=dsidx(k)				!index
	      if (didx.le.0) goto 1013			!nops
	      p=fmap(k)					!field
	      if (p.lt.0) goto 1013			!-1=old "*" mark, ignore
c
	      fld=ds$fld(dl,didx,base)			!field to show
	      siz=ds$siz(dl,didx,base)
	      how=ds$how(dl,didx,base)
	      jus=ds$jus(dl,didx,base)
c
	      if (fld.eq.0) then				!rec#
	         siz=lstsiz
	         lim=pos+siz-1
	         if (lim.gt.width.and.
     1               format.eq.1      ) goto 110	!no room (only format 1)
	         call wrivar_(mymssg(pos:lim),recnum,siz,erro)
	         if (erro.ne.0) goto 52			!write error
52               continue
	      else
c
	         xtype=d$type(fld,base)
	         if (xtype.gt.ftusr$) then		!non-user fields
	            if (xtype.eq.lk$.and.		!link
	1               links) then
c	               ok, show him
	            else
	               goto 110				!not wanted, skip it
	            endif
	         endif
c
	         lim=pos+siz-1
	         if (lim.gt.width.and.
     1               format.eq.1      ) goto 110	!no room (only format 1)
c
	         if (how.eq.1) then			!text like
	            hisliv=2
	            erro=0
	            call fldtxt_ (base,recnum,hisliv,fld,d$cbuf,empty,erro)
	            if (erro.eq.0) then
	               if (empty) then
c	                  empty field, do nothing
	               else
	                  mymssg(pos:lim)=d$cbuf(1:)
	               endif
	            endif
	         else					!number like
	            hisliv=2
	            if (fld.eq.0) then
	               value=recnum
	               empty=.false.			!non-empty field
	            else
	               call fldnum_ (base,recnum,hisliv,fld,value,empty,erro)
	            endif
	            if (erro.eq.0) then
	               if (empty) then
c	                  empty field, do nothing
	               else
	                  call wrivar_(mymssg(pos:lim),value,siz,erro)
	                  if (erro.ne.0) goto 51	!write error
51	                  continue
	               endif
	            endif
c
	         endif
c
	         if (erro.ne.0) then			!FLD??? error
c
	            badrec=.true.			!remember
	            do kkk = pos, lim			!fill with '*'
	               mymssg(kkk:kkk)='*'
	            enddo
	            if (d$rsub.eq.'DBTXT'.and.
	1               erro.eq.2) then			!killed record in o.d.b.
	               odbk=.true.			!remember
                       call flddb_ (base,recnum,hisliv,	!add o.d.b rec#
	1                        fld,value,empty,erro)
	               ksiz=lstsiz
	               kpos=lim-ksiz+1
	               if (kpos.ge.pos) then		!play safe
	                  call wrivar_(mymssg(kpos:lim),value,ksiz,erro)
	                  if (erro.ne.0) goto 51	!write error
	               else
	                  do kkk = pos, lim		!fill with '*'
	                     mymssg(kkk:kkk)='*'
	                  enddo
	               endif
	            endif
	            call errclr_('I$DREC')
	            erro=0
c
	         else					!everything ok
c
c	            Left just., right just. or center
c
	            if (how.eq.1) then			!text like
	               if     (jus.eq.1) then	!left just. if not o.d.b killed
	                  if (.not.odbk) then
	                     call ljust_(mymssg(pos:lim))!play safe
	                  endif
	               elseif (jus.eq.2) then		!rjust
	                  call rjust_(mymssg(pos:lim))
	               elseif (jus.eq.3) then		!center
	                  call center_(mymssg(pos:lim))
	               else				!0=do nothing
c	                  ok
	               endif
	            else				!number like
	               if     (jus.eq.1) then		!left justify the number
	                  call ljust_(mymssg(pos:lim))
	               elseif (jus.eq.2) then		!right justify already
c	                  ok
	               elseif (jus.eq.3) then		!center
	                  call center_(mymssg(pos:lim))
	               else				!0=do nothing
c	                  ok
	               endif
	            endif
	         endif
	      endif
c
	      pos=pos+siz
	      if (spacin) pos=pos+1			!spacing on
c
110	   continue
1013	   continue				!loop in fields
c	   ----------------------------
c
	   if (badrec) then
	      badcount=badcount+1			!account bad record
	   endif
c
c	   Message is ready, handle it with care
c	   -------------------------------------
c
	   if (format.eq.1) then			!format 1
c
	      lim=istrip_(mymssg)
	      if (lim.le.1) then
	         lim=2
	         mymssg(1:2)='  '
	      endif
c
	      if (tty) then
c
	         if (lim.gt.width) lim=width		!truncate it to width
	         call i$mess_(0,d$cmdo,-1,mymssg(1:lim),-1,erro)
	         if (erro.ne.0) goto 95000
	         line=line+1				!"
	         if (wait) then
	            call i$wait_(line,erro)		!wait...
	            if (erro.lt.0) goto 900		!abort display
	            if (erro.ne.0) goto 95000
	         endif
c
	      else
c
	         lim=istrip_(mymssg(1:mnesiz))
	         if (lim.le.1) lim=2
	         write (fchan,'(a)',err=90001) mymssg(2:lim)
c
	      endif
c
	   else					!format 2
c
	      if (spacin) then			!blank line
	         if (tty) then
	            call i$blnk_(wait,line,erro)
	            if (erro.lt.0) goto 900		!abort display
	            if (erro.ne.0) goto 95000
	         else
	            write (fchan,'(1x)',err=90001)
	         endif
	      endif
c
	      do 1014 k = 1, ncol
	         mymss2(1:)=' '
	         if (mnem) then			!show (complete) mnemon.
	            if (field(k).gt.0) then
	               b=base
	               f=field(k)
	               b2=d$dbio(f,base)
	               see=d$see(f,base)
	               if (b2.gt.0.and.see.gt.0) then!show the good one
	                  b=b2
	                  f=see
	               endif
	               call zmne_(b,f,mymss2(2:11),erro)
	               if (erro.ne.0) goto 95000
	            else
	               mymss2(2:2)='#'
	            endif
	            mymss2(12:12)=':'
	            pos=13
	         else				!don't show mnemonics
	            pos=2
	         endif
c
	         p1=filpos(k)
	         p2=p1+filsiz(k)-1
	         mymss2(pos:)=mymssg(p1:p2)
	         lim=istrip_(mymss2)
	         if (lim.le.1) lim=2
c
	         if (tty) then
c
	            if (lim.gt.width) lim=width		!truncate it to width
	            call i$mess_(0,d$cmdo,-1,mymss2(1:lim),-1,erro)
	            if (erro.ne.0) goto 95000
	            line=line+1				!"
	            if (wait) then
	               call i$wait_(line,erro)		!wait...
	               if (erro.lt.0) goto 900		!abort display
	               if (erro.ne.0) goto 95000
	            endif
c
	         else
c
	            lim=istrip_(mymss2)
	            if (lim.le.1) lim=2
	            write (fchan,'(a)',err=90001) mymss2(2:lim)
c
	         endif
c
1014	      continue
c
c
	   endif
c
	   rcount=rcount+1			!account record
c
c	   next record
c
50	   continue
c
c	   Display creatures if there and wanted
c
	   if (property) then
	      function=3				!display prop
	      line1=8					!use screen from line 8
c
	      if (prop.gt.0) then
c
	         if (wait) then
	            if (.not.norec) then
	               call i$wcrt_(p$,d$unam(prop),erro)!wait...
	               if (erro.lt.0) goto 900		!abort display
	               if (erro.ne.0) goto 95000
	            endif
	         endif
	         line=0					!reset line counter
c
	         call vset2_(6)				!clean screen
	         recnum=-1				!let I$EDPP ask for rec#
	         oldprop=.true.				!prop exists
	         call I$EDPP_(base,prop,recnum,oldprop,
	1                     function,line1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         call vset2_(6)				!clean screen
	         call vset1_(5,1)  			!cursor
	         call vset3_(6,20)			!set scroll
c
	      else
c
	         do k = 1, d$nfld(base)
	            if (d$type(k,base).eq.p$) then
	               pp=d$dbio(k,base)
	               if (pp.gt.0) then
	                  if (norec) then
	                     pexist=.true.		!doesn't matter...
	                  else

	                     call inqsw_(pp,recnum,pexist,erro)!prop exists ?
	                     if (erro.ne.0) goto 900	!error, carry
	                  endif
	                  if (pexist) then
c
	                     if (wait) then
	                        if (.not.norec) then
	                           call i$wcrt_(p$,d$unam(pp),erro)!wait...
	                           if (erro.lt.0) goto 900	!abort display
	                           if (erro.ne.0) goto 95000
	                        endif
	                     endif
	                     line=0			!reset line counter
c
	                     call vset2_(6)		!clean screen
	                     if (norec) then
	                        recnum=-1		!let I$EDPP ask for it
	                     endif
	                     oldprop=.true.		!prop exists
	                     call I$EDPP_(base,pp,recnum,oldprop,
	1                    function,line1,erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                     call vset2_(6)		!clean screen
	                     call vset1_(5,1)		!cursor
	                     call vset3_(6,20)		!set scroll
	                  endif
	               endif
	            endif
	         enddo
c
	      endif
c
	   endif
c
	   if (series) then

	   endif
c
	   if (memo) then

	   endif
c
	   if (norec) then				!skip records stuff
	      eobm=.true.				!all done
	   else
	      if (sort) then
	         call ordnxt_(bmap,irec,eobm,erro)	!next selected rec.
	         if (erro.ne.0) goto 95000
	      else
	         call bitnxt_(bmap,irec,eobm,erro)	!next selected rec.
	         if (erro.ne.0) goto 95000
	      endif
	      call in3ex_(base,irec,recnum,erro)
	      if (erro.ne.0) goto 95000
	   endif
c
	   goto 1098
1099	continue
cwhile	enddo		!loop in bitmap
c	-------------------------------
c
c	Go away NOW !
c	-------------
c
900	continue
c
	return
c
c	Error
c	=====
c
c	error opening or writing to display/sort files
90001	continue
	erro=1
	goto 99000
c	error setting standard display
90002	continue
	erro=2
	goto 99000
99000	continue
	call errset_('I$DREC',erro)
	return
c	inherited errors
95000	continue
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$DSTA_(fchan,wait,erro)
c	***********************************
c
	implicit none
c
	integer fchan,erro
	logical wait
c
c	Description
c	===========
c
c	Executes commands DISPLAY/LIST STATUS, called from D$ISPL or
c	L$IST (WAIT .true. or .false.) in module DBAGA.
c	ERRO < 0	abort command
c	     = 0	ok
c	     > 0	fatal error
c
c	DISPLAY usually waits all linmax lines, LIST doesn't.
c
c	If FCHAN > 0, output is directed to channel FCHAN; otherwise, output
c	goes to terminal.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
	external istrip_,trim_
	integer istrip_,trim_
	integer i, k, line, width, lim, lim1, lim2
	character*30 txt1,txt2
c
c	begin
c	=====
c
	call errclr_('I$DSTA')				!error init
	erro=0
c
 	call ttwdth_(width)				!current WIDTH
c
c	Pretty output
c
	write (mssg,10015)
c
	if (fchan.le.0) then
	   call vset2_(2)				!clean screen
	   call vset1_(2,1)				!cursor
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,'(<width+1>(''-''))')
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call vset3_(6,20)				!set scroll
	   call vset1_(5,1)				!set cursor
	else
	   write (fchan,fmt='(a,/)',err=90001) mssg(2:istrip_(mssg))
	endif
c
c	Display status now
c
	line=1						!line#
c
c	"Current" bases
c
	write (mssg,10008)				!"current" bases
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(a,/)',err=90001) mssg(2:istrip_(mssg))
	endif
	call i$bcur_(fchan,wait,line,erro)		!display "cur." bases
	if (erro.ne.0) goto 900				!abort/error
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(1x)',err=90001)
	endif
c
c	Global info
c
	write (mssg,10001)
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10002) d$b
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10003) d$f
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10004) x$fld
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10005) x$usr
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10006) digmax
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10007) digmax
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10016) d$cmds
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10017) d$cmmd
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
c	Minimum, maximum for real and double precision if there
c
	if (reals) then
c
	   write (txt1,*,err=90002) rlowest
	   lim1=trim_(txt1)
	   if (lim1.gt.1) txt1(1:)=txt1(lim1:)
	   lim1=istrip_(txt1)
	   if (lim1.le.0) lim1=1
c
	   write (txt2,*,err=90002) rhigher
	   lim2=trim_(txt2)
	   if (lim2.gt.1) txt2(1:)=txt2(lim2:)
	   lim2=istrip_(txt2)
	   if (lim2.le.0) lim2=1
c
	   write (mssg,10019) txt1(1:lim1),txt2(1:lim2)
c
	   if (fchan.le.0) then
	      call i$blnk_(wait,line,erro)		!blank line
	      if (erro.ne.0) goto 900			!error, carry
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(/,a,/)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   write (txt1,*,err=90002) ddlowest
	   lim1=trim_(txt1)
	   if (lim1.gt.1) txt1(1:)=txt1(lim1:)
	   lim1=istrip_(txt1)
	   if (lim1.le.0) lim1=1
c
	   write (txt2,*,err=90002) ddhigher
	   lim2=trim_(txt2)
	   if (lim2.gt.1) txt2(1:)=txt2(lim2:)
	   lim2=istrip_(txt2)
	   if (lim2.le.0) lim2=1
c
	   write (mssg,10020) txt1(1:lim1),txt2(1:lim2)
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(/,a,/)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	endif
c
c	ON/OFF parameters
c
	write (mssg,10009)				!ON/OFF parameters
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(/,a,/)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	mssg(1:)=' '
	i=2
	do 1001 k = 1, s$top
	   if (k.ne.s$widt.and.
     1         k.ne.s$trac.and.
     1         k.ne.s$prmt    ) then	!exceptions (WIDTH,PROMPT,TRACE)
	      if (s$tok(k).ne.' ') then
	         mssg(i+5:i+19)=s$tok(k)
	         if (s$set(k)) then
	            mssg(i:i+2)=' on'
	         else
	            mssg(i:i+2)='off'
	         endif
	         i=i+20
	         if (i.gt.62) then
	            if (fchan.le.0) then
	               call i$mess_(0,d$cmdo,-1,mssg(1:81),-1,erro)
	               if (erro.ne.0) goto 900		!error, carry
	               line=line+1
	               if (wait) then
	                  call i$wait_(line,erro)	!wait
	                  if (erro.ne.0) goto 900	!abort/error
	               endif
	            else
	               write (fchan,fmt='(a)',err=90001) mssg(2:81)
	            endif
	            mssg(1:)=' '
	            i=2
	         endif
	      endif
	   endif
1001	continue
	if (i.ne.2) then
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg(1:81),-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:81)
	   endif
	endif
c
c	TO values
c
	write (mssg,10012)				!TO values
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(/,a,/)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	lim=istrip_(altefl)
	if (lim.le.0) then
	   lim=1
	   altefl(1:1)=' '
	endif
	if (erro.ne.0) goto 900				!error, carry
	write (mssg,10010) altefl			!ALTERNATE file
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10011) width			!WIDTH
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10013) paddin			!PADDING character
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,10014) ending			!ENDING character
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900
	   line=line+1
	   if (wait) then
	      call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
900	continue
	return
c
c	Error
c	=====
c
c	problems writing to output file
90001	continue
	erro=1
	goto 99000
c	internal error (read/write)
90002	continue
	erro=2
	goto 99000
99000	continue
	call errset_('I$DSTA',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:idsta.fmt'
c
c
	end
c
c
c
c
 	subroutine I$DSTR_(fchan,base,prop,basic,links,full,wait,line,
	1                  erro)
c	*************************************************************
c
	implicit none
c
	integer fchan,base,prop,line,erro
	logical basic,links,full,wait
c
c	Description
c	===========
c
c	Executes commands DISPLAY/LIST STRUCTURE, called from D$ISPL or
c	L$IST (WAIT .true. or .false.) in module DBAGA.
c	FULL argument isn't used anymore.
c	ERRO	< 0	abort command
c		= 0	ok
c		> 0	fatal error
c
c	Displays field names, types, lengths, and decimals (structure) of
c	file in use.
c
c	If FCHAN = 0, output goes to the terminal, otherwise it goes to channel
c	FCHAN.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	character*(cm$l1+2) myname
	character*2 mytype,mdt
	character*12 mybuf
	character*20 mydate
	character*30 race
	character*50 mytext
	integer irace,pdim,psize,pdeci,ix,val,dec,lim1,recno1,
	1       lim2,mark,mndt,nf,np,ns,nm,xtype
	double precision dval
	integer b2
	integer okrec, klrec,i,j,k,l,size,totsiz,pos1,pos2,width,pos,mast,
	1	see,b
	logical indexed,kwiced,keyed,eostr,done,ok
	integer remlin/28/
	character fmnem*10,b2nam*9
	character*1 nothing/' '/
c
	integer imin,imax
	real rmin,rmax
	equivalence (imin,rmin)
	equivalence (imax,rmax)
	character*4 rtxt
	real rv
	equivalence (rtxt,rv)
c
c	begin
c	=====
c
	call errclr_('I$DSTR')		!error init
	erro=0
c
	call ttwdth_(width)		!current width
	indexed=.false.			!assume no field indexed
	kwiced=.false.			!assume no field "kwiced"
	keyed=.false.			!assume no field "keyed"
c
	if (prop.gt.0) then
	   b=prop
	else
	   b=base
	endif
c
c	Display structure
c	-----------------
c
	call zrace_(b,race,irace,pdim,psize,pdeci,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	if (.not.basic) goto 100		!not basic structure, skip
c
c	Pretty output
c
	lim1=istrip_(d$unam(b))
	if (lim1.le.0) lim1=1
	lim2=istrip_(d$bfil(b))
	if (lim2.le.0) lim2=1
	write (mssg,10006) race
	write (mssg(istrip_(mssg)+1:),11006)
	1      d$unam(b)(1:lim1),d$bfil(b)(1:lim2)
c
	if (fchan.le.0) then
	   call vset2_(2)				!clean screen
	   call vset1_(2,1)				!cursor
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(/,a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	write (mssg,'(<width+1>(''-''))')
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   call vset3_(6,20)				!set scroll
	   call vset1_(5,1)				!set cursor
	else
	   write (fchan,fmt='(a,/)',err=90001) mssg(2:istrip_(mssg))
	endif
c
c	Display structure now
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(1x)',err=90001)
	endif
c
	if (irace.ne.r$b) then
c
	   write (mssg,10036) d$ownb(b)			!owner base
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
	write (mssg,10017) d$bdes(b)			!designation
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	   write (mssg,10011) d$date(b)			!creation date
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	call zrec2_(b,okrec,klrec,erro)
	if (erro.ne.0) goto 900				!error, carry
c
	if (irace.eq.r$b) then				!regular base
c
	   write (mssg,10007) okrec			!alive records
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   if (d$froz(b).eq.0) then
	      write (mssg,10028) klrec		!killed records(available)
	   else
	      write (mssg,10008) klrec		!killed records(frozen)
	   endif
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   recno1= d$unus - d$offs(b) + 1		!first record#
	   write (mssg,10009) recno1			!first record#
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	endif
c
	write (mssg,10010) d$upd(b)		!last upd. date
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	if (d$crpt(b).eq.0) then			!cripted ?
	   write (mssg,10004)				!yes
	else
	   write (mssg,10005)				!no
	endif
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   line=line+1
	else
	   write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
100	continue
c
	nf=0				!# of regular fields
	np=0				!properties
	ns=0				!series
	nm=0				!memos
c
	do k = 1, d$nfld(b)
	   xtype=d$type(k,b)
	   if     (xtype.le.ftusr$.or.
	1          (xtype.eq.lk$.and.
	1           links            ) ) then
	      nf=nf+1
	   elseif (xtype.eq.p$) then
	      np=np+1
	   elseif (xtype.eq.s$) then
	      ns=ns+1
	   elseif (xtype.eq.mm$) then
	      nm=nm+1
	   endif
	enddo
c
	write (mssg,10037) nf		!fields
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900	!error, carry
	   line=line+1
	else
	   write (fchan,fmt='(/,a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	if (np.gt.0) then
	   write (mssg,10038) np	!properties
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900	!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
	if (ns.gt.0) then
	   write (mssg,10039) ns	!series
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900	!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
	if (nm.gt.0) then
	   write (mssg,10040) nm	!memos
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900	!error, carry
	      line=line+1
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
c fields
c
	write (mssg,10026)
c
	if (fchan.le.0) then
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   line=line+2
	else
	   write (fchan,fmt='(/,a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	totsiz=0				!clear total rec. size
c
c	***********************************************************************
c
	do 1001 k=1,d$nfld(b)			!loop on field#
c
c	see protection
c
	if (d$prt(b).ne.0.and.			!protection ON
	1   d$prfl(k,b).eq.prtno) then		!and no access
	   write (mssg,10014) k				!tell him (her)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	   goto 1001					!skip to next field
	endif
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	else
	   write (fchan,fmt='(1x)',err=90001)
	endif
c
	mssg(1:)=' '
c
	ix=d$idx(k,b)
	myname(1:)=' '				!give a nice name
	if (ix.gt.0) then
	   xtype=d$type(k,b)
	   if (xtype.le.ftusr$.or.
	1      (xtype.eq.lk$.and.
	1       links            ) ) then
	      if     (ix.eq.1) then
	         myname(1:1)='*'			!field is INDEXed
	         indexed=.true.				!remember that
	      elseif (ix.eq.2) then
	         myname(1:1)='k'			!field is KEY
	         keyed=.true.				!remember that
	      elseif (ix.eq.4) then
	         myname(1:1)='w'			!field is KWIC...
	         kwiced=.true.				!remember that
	      endif
	   endif
	endif
	call zmndt_(b,k,mndt,erro)
	if (erro.ne.0) goto 900
	if (mndt.eq.1) then
	   mdt(1:2)=' y'				!field is mandatory
	else
	   mdt(1:2)='no'
	endif
	myname(3:)=d$fmne(k,b)
	l=istrip_(myname(3:))
	mytype(1:)=' '					!and type
	l=istrip_(ft$(d$type(k,b)))
	mytype(1:l)=ft$(d$type(k,b))(1:l)
	pos1=d$pos(k,b)
	pos2=pos1+d$siz(k,b)-1
	l=istrip_(d$dflt(b)(pos1:pos2))		!default size
c
c	display fields
c
	if (d$type(k,b).eq.db$) then			!o.d.b
	   size=d$siz(k,b)
	   totsiz=totsiz+size
	   b2=d$dbio(k,b)
	   b2nam(1:)=' '
	   b2nam=d$fnam(k,b)(1:9)
	   if (b2.gt.0) then				!o.d.b.
	      mast=d$mast(k,b)
	      see=d$see(k,b)
	      if (mast.gt.0) then
	         pos1=d$pos(mast,b2)
	         pos2=pos1+d$siz(mast,b2)-1
	         l=istrip_(d$dflt(b2)(pos1:pos2))		!default size
	      else
	         l=0
	      endif
	   endif
c
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1092	   continue
	   if (eostr) goto 1093
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10031) nothing,k,myname,
     1                              mytype,size,
     1                              b2nam,
     1                              mdt(1:2),
     1                              mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1092
1093	   continue
cwhile	   enddo
c
	   if (b2.gt.0.and.
	1      mast.gt.0  ) then		!master field, default & see
c
	      ok=.false.
	      call zmne_(b2,mast,fmnem,erro)		!and mnemonic
	      if (erro.eq.0) then
	         ok=.true.
	      endif
	      if (ok) then
	         write (mssg,10012) fmnem
	      else
	         call errmsg_(d$rsub,erro,mssg,'?')	!get error message
	         mark=0
	         call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	         call errclr_('I$DSTR')			!clean error
	         erro=0
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      if (l.ne.0) then				!default
	         write (mssg,10027) d$dflt(b2) (pos1:pos2)
c
	         if (fchan.le.0) then
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900		!error, carry
	            line=line+1
	            if (wait) then
	               call i$wait_(line,erro)		!wait
	               if (erro.ne.0) goto 900		!abort/error
	            endif
	         else
	            write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	         endif
	      endif
c
	   endif
c
	   if (b2.gt.0.and.
	1      see.gt.0) then				!see field
	      ok=.false.
	      call zmne_(b2,see,fmnem,erro)		!and mnemonic
	      if (erro.eq.0) then
	         ok=.true.
	      endif
	      if (ok) then
	         write (mssg,10025) fmnem
	      else
	         call errmsg_(d$rsub,erro,mssg,'?')	!get error message
	         mark=0
	         call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	         call errclr_('I$DSTR')			!clean error
	         erro=0
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	   endif
c
	elseif (d$type(k,b).eq.n$.or.			!integer
	1       (d$type(k,b).eq.lk$.and.		!or links and wanted
	1        links                 ) ) then
	   size=d$siz(k,b)-1
	   totsiz=totsiz+size
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1098	   continue
	      if (eostr) goto 1099
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10033) nothing,k,myname,
     1   		         mytype,size,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1098
1099	   continue
cwhile	   enddo
c	   						!lower, upper
	   val=d$min (k,b)
	   write (mssg,10029)
	   lim1=istrip_(mssg)+2
	   call wrivar_(mssg(lim1:),val,size+1,erro)
	   if (erro.ne.0) goto 90002			!write error
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   val=d$max (k,b)
	   write (mssg,10030)
	   lim1=istrip_(mssg)+2
	   call wrivar_(mssg(lim1:),val,size+1,erro)
	   if (erro.ne.0) goto 90002			!write error
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   if (l.ne.0) then				!default
	      write (mssg,10021) d$dflt(b) (pos1:pos2)
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
	   endif
	elseif (d$type(k,b).eq.c$) then		!string
	   size=d$siz(k,b)
	   totsiz=totsiz+size
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1096	   continue
	      if (eostr) goto 1097
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10033) nothing,k,myname,
     1   		         mytype,size,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1096
1097	   continue
cwhile	   enddo
c
	   if (l.ne.0) then				!default
	      pos=-1
	      done=.false.
	      eostr=.false.
c
cwhile	      do while (.not.eostr)
1094	         continue
	         if (eostr) goto 1095
c
	         mytext(1:)=' '
	         call strsec_(d$dflt(b)(pos1:pos2),mytext(1:19),pos,eostr)
	         if (.not.done) then
	            done=.true.
	            write (mssg,10021) mytext(1:19)
	         else
	            write (mssg,10018) mytext(1:19)
	         endif
c
	         if (fchan.le.0) then
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900		!error, carry
	            line=line+1
	            if (wait) then
	               call i$wait_(line,erro)		!wait
	               if (erro.ne.0) goto 900		!abort/error
	            endif
	         else
	            write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	         endif
c
	         goto 1094
1095	      continue
cwhile	      enddo
c
	   endif
c
	elseif (d$type(k,b).eq.x$) then		!decimal
	   size=d$siz(k,b)-1
	   totsiz=totsiz+size
	   dec=d$deci(k,b)
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1090	   continue
	      if (eostr) goto 1091
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10032) nothing,k,myname,
     1   		         mytype,size,dec,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1090
1091	   continue
cwhile	   enddo
c
	   size=size+1
c	   						!lower, upper
	   dval=dfloat(d$min(k,b))/(10.0**dec)
	   write (mssg,10022)
	   lim1=istrip_(mssg)+2
	   call wrfvar_(mssg(lim1:),dval,size+1,dec,erro)
	   if (erro.ne.0) goto 90002			!write error
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   dval=dfloat(d$max(k,b))/(10.0**dec)
	   write (mssg,10023)
	   lim1=istrip_(mssg)+2
	   call wrfvar_(mssg(lim1:),dval,size+1,dec,erro)
	   if (erro.ne.0) goto 90002			!write error
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   if (l.ne.0) then				!default
	      call rdfvar_(d$dflt(b)(pos1:pos2),dval,size,dec,erro)!read it
	      if (erro.ne.0) goto 90002			!read error
	      write (mssg,10024)
	      lim1=istrip_(mssg)+2
	      call wrfvar_(mssg(lim1:),dval,size+1,dec,erro)
	      if (erro.ne.0) goto 90002			!write error
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	          line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	          write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
	   endif
	   size=size-1
	elseif (d$type(k,b).eq.r$) then		!real
	   size=d$siz(k,b)
	   totsiz=totsiz+size
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1081	   continue
	      if (eostr) goto 1082
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10033) nothing,k,myname,
     1   		         mytype,size,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1081
1082	   continue
cwhile	   enddo
c	   						!lower, upper
	   imin=d$min (k,b)
	   write (mssg,10022)
	   write (mssg(istrip_(mssg)+2:),*) rmin
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   imax=d$max (k,b)
	   write (mssg,10023)
	   write (mssg(istrip_(mssg)+2:),*) rmax
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   rtxt=d$dflt(b)(pos1:pos2)
	   if (rtxt.ne.rnulltxt) then
	      write (mssg,10024) 
	      write (mssg(istrip_(mssg)+2:),*) rv
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
	   endif
	elseif (d$type(k,b).eq.r8$) then		!double precision
	   size=d$siz(k,b)
	   totsiz=totsiz+size
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1071	   continue
	      if (eostr) goto 1072
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10033) nothing,k,myname,
     1   		         mytype,size,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1071
1072	   continue
cwhile	   enddo
	elseif (d$type(k,b).eq.d$) then		!date
	   size=8
	   totsiz=totsiz+size
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1088	   continue
	      if (eostr) goto 1089
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10033) nothing,k,myname,
     1   		         mytype,size,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1088
1089	   continue
cwhile	   enddo
c	   						!lower, upper
	   call txtdat_(d$min(k,b),mydate,erro)
	   write (mssg,10019) mydate
c
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   call txtdat_(d$max(k,b),mydate,erro)
	   write (mssg,10020) mydate
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
c
	   if (l.ne.0) then				!default
	      call rdivar_(d$dflt(b)(pos1:pos2),val,size,erro)
	      if (erro.ne.0) goto 90002			!read error
	      call txtdat_(val,mydate,erro)
	      write (mssg,10021) mydate
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
	   endif
	elseif (d$type(k,b).eq.l$) then		!logical
	   size=1
	   totsiz=totsiz+size
	   pos=-1
	   done=.false.
	   eostr=.false.
c
cwhile	   do while (.not.eostr)
1086	   continue
	      if (eostr) goto 1087
c
	      mytext(1:)=' '
	      call strsec_(d$fdes(k,b),mytext(1:remlin),pos,eostr)
	      if (.not.done) then
	         done=.true.
	         write (mssg,10033) nothing,k,myname,
     1   		         mytype,size,mdt(1:2),mytext(1:remlin)
	      else
	         write (mssg,10034) mytext(1:remlin)
	      endif
c
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
c
	      goto 1086
1087	   continue
cwhile	   enddo
c
	   if (l.ne.0) then				!default
	      write (mssg,10021) d$dflt(b)(pos1:pos2)
	      if (fchan.le.0) then
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         line=line+1
	         if (wait) then
	            call i$wait_(line,erro)		!wait
	            if (erro.ne.0) goto 900		!abort/error
	         endif
	      else
	         write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	      endif
	   endif
	endif
c
	if (d$prt(b).ne.0.and.			!protection ON
	1   d$prfl(k,b).eq.prtro) then		!and read only
	   write (mssg,10016)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
1001	continue					!end of loop on fields
c	***********************************************************************
c
	write (mssg,10015) totsiz
c
	if (fchan.le.0) then
	   call i$blnk_(wait,line,erro)			!blank line
	   if (erro.ne.0) goto 900			!error, carry
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900			!error,carry
	   line=line+1
	   if (wait) then
	       call i$wait_(line,erro)			!wait
	      if (erro.ne.0) goto 900			!abort/error
	   endif
	else
	   write (fchan,fmt='(/,a)',err=90001) mssg(2:istrip_(mssg))
	endif
c
	if (indexed.or.
	1   keyed.or.
	1   kwiced    ) then
	   if (fchan.le.0) then
	      call i$blnk_(wait,line,erro)		!blank line
	      if (erro.ne.0) goto 900			!error, carry
	   else
	      write (fchan,fmt='(1x)',err=90001)
	   endif
	endif
c
	if (indexed) then				!field(s) indexed
	   write (mssg,10001)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error,carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
	if (keyed) then				!field(s) "keyed"
	   write (mssg,10035)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error,carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
	if (kwiced) then				!field(s) KWIC
	   write (mssg,10013)
	   if (fchan.le.0) then
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error,carry
	      line=line+1
	      if (wait) then
	         call i$wait_(line,erro)		!wait
	         if (erro.ne.0) goto 900		!abort/error
	      endif
	   else
	      write (fchan,fmt='(a)',err=90001) mssg(2:istrip_(mssg))
	   endif
	endif
c
900	continue
	return
c
c	Error
c	=====
c	problems writing to display file
90001	continue
	erro=1
	goto 99000
c	Internal error (read/write error)
90002	continue
	erro=2
	goto 99000
99000	continue
	call errset_('I$DSTR',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:idstr.fmt'
c
	end
c
c
c
c
	subroutine I$UNLO_(ibase,ochan,nalive,nkill,nbad,erro)
c	******************************************************
c
	implicit none
c
	integer ibase,ochan,nalive,nkill,nbad,erro
c
c	Description
c	===========
c
c	Try to unload ALL database BASE records to channel OCHAN.
c	File format is SDF (system file data format).
c
c	NALIVE	total alive records, unloaded.
c	NKILL	total killed records unloaded.
c	NBAD	total wrong records, unloaded.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer usrsiz,recnum
	logical eos
	integer irace,pdim,psize,pdeci
	character*30 race
	character*10 owname,aliename
	integer totelem,linelem
c
c	begin
c	=====
c
	call errclr_('I$UNLO')				!error init
	erro=0
c
	nalive=0
	nkill=0
	nbad=0
c
	recnum=0
	eos=.false.
c
	call zrace_(ibase,race,irace,pdim,psize,pdeci,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	if (irace.ne.r$b) goto 90001		!can't unload creatures
c
	call fastnx_(ibase,recnum,xbuf1,eos,erro)	!first record
c
	do while (.not.eos)
c
	   if (erro.ne.0) goto 900			!error, carry
c
	   if     (xbuf1(1:1).eq.'\') then
	      nbad=nbad+1				!bad record (??)
	      if (d$itrv.eq.1) then			!interactive
	         write (mssg,10003) recnum
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
c	         if (erro.ne.0) ignore error
	      endif
	   elseif (xbuf1(1:1).eq.' ') then
	      nalive=nalive+1				!account alive record
	      if (d$itrv.eq.1) then			!interactive
	         write (mssg,10001) recnum
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
c	         if (erro.ne.0) ignore error
	      endif
	   elseif (xbuf1(1:1).eq.'?') then
	      nkill=nkill+1				!account killed record
	      if (d$itrv.eq.1) then			!interactive
	         write (mssg,10002) recnum
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
c	         if (erro.ne.0) ignore error
	      endif
	   endif
c
	   call i$usz_(ibase,usrsiz)	!record size
	   owname(1:)=' '		!no owner base
	   aliename(1:)=' '		!no creature
	   totelem=0			!no elem.
	   linelem=0			!...
	   call f$osdf_(ochan,recnum,xbuf1,usrsiz,
	1               irace,owname,aliename,
	1               totelem,linelem,erro)
c
110	   continue
c
c	   get next record
c
	   call fastnx_(ibase,recnum,xbuf1,eos,erro)
c
	enddo
c
	goto 900					!return
c
c	Return
c	======
c
900	continue
c
	return						!return to caller
c
c	Errors
c	======
c
90001	continue			!can't unload creatures
	erro=1
	goto 99000
99000	continue
	call errset_('I$UNLO',erro)	!set error
	return				!and return
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	include 'fmt:iunlo.fmt'
c
	end
c
c
c
c
	subroutine I$UNCR_(base,prop,ochan,ncreat,erro)
c	***********************************************
c
	implicit none
c
	integer base,prop,ochan,ncreat,erro
c
c	Description
c	===========
c
c	Try to unload PROP creature, owner base BASE, to channel OCHAN.
c	Creature will be "physically" unloaded, i.e., common access primitives
c	will not be used!!!!.
c	File format is SDF (system file data format).
c
c	NCREAT	total unloaded.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagd.own'
	include 'own:dbagsr.own'
c
	external istrip_
	integer istrip_
	integer recnum,racesz
	logical eos
	integer ppirace,ppdim,ppsize,ppdeci
	character*30 pprace
	character*10 owname,aliename
	integer totelem,linelem,elem,npos,k,lim1
	character*60 fname
c
	integer father,next,last,linksz,data1st,datanf,datalast
c
	integer pai,usrsiz,nxtrec,lstrec,currec,alive,posi,posf,
	1	p1nxt,p2nxt,p1lst,p2lst,p1fat,p2fat
c
c	begin
c	=====
c
	call errclr_('I$UNCR')			!error init
	erro=0
c
	ncreat=0
c
	call zrace_(prop,pprace,ppirace,ppdim,ppsize,ppdeci,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	if (ppirace.eq.r$b) goto 90001		!can't unload regular bases
c
	racesz=istrip_(pprace)
	if (racesz.le.0) racesz=1
c
	aliename=d$unam(prop)
	call uc_(aliename)
	owname=d$ownb(prop)
	call uc_(owname)
	call i$usz_(base,usrsiz)		!record size
c
	recnum=0				!start at first record
	alive=0					!not used anymore
c
	father=pp$fat(prop)			!father position
	next=pp$nxt(prop)			!next position
	last=pp$lst(prop)			!last position
	linksz=d$siz(father,prop)		!father/next/last size
c
	p1fat=d$pos(father,prop)
	p2fat=p1fat+linksz-1
c
	p1lst=d$pos(last,prop)
	p2lst=p1lst+linksz-1
c
	p1nxt=d$pos(next,prop)
	p2nxt=p1nxt+linksz-1
c
	data1st=d$u1st(prop)			!first data field
	datanf=d$udnf(prop)			!number of data fields
	datalast=data1st+datanf-1		!last field data
c
	posi=d$pos(data1st,prop)
	posf=d$pos(datalast,prop)+d$siz(datalast,prop)-1
	npos=posf-posi+1
c
c	Loop until first creature "header" comes in
c
100	continue
c
	   call fastnx_(prop,recnum,xbuf1,eos,erro)
	   if (eos) goto 200			!all done
	   read (xbuf1(p1lst:p2lst),'(i<linksz>)',
	1        err=90002) lstrec		!Read pointer to last rec
	   if (lstrec.le.0) goto 100		!old (deleted), loop back
c
	   currec=recnum			!current record
c
c	   Get creature
c	   ------------
c
120	   continue
c
	   read (xbuf1(p1nxt:p2nxt),'(i<linksz>)',
	1        err=90002) nxtrec		!Read pointer to next rec
c
	   read (xbuf1(p1fat:p2fat),'(i<linksz>)',
	1        err=90002) pai			!Owner record#
c
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10001) owname,pai,pprace(1:racesz),aliename
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
c
	   elem=0				!start at 1st elem.
c
	   if     (ppirace.eq.r$pp) then	!property
c
c	      read next property
c
130	      continue
c
	      elem=elem+1
	      prparray(elem)=xbuf1(posi:posf)
c
	      if (currec.ne.lstrec) then	!read rest of it
c
	         currec=nxtrec			!next record
	         call find_(prop,currec,alive,xbuf1,erro)
	         if (erro.ne.0) goto 900	!error, carry
c
	         read (xbuf1(p1nxt:p2nxt),'(i<linksz>)',
	1        err=90002) nxtrec		!Read pointer to next rec
c
	         goto 130			!loop back for more
c
	      endif
c
	   elseif (ppirace.eq.r$mm) then	!memo
c
c	      read next memo
c

c
	   else					!series
c
c	      read next series
c

c
	   endif
c
c	   Send creature to file
c	   ---------------------
c
	   if     (ppirace.eq.r$pp) then	!property
c
	      linelem=1				!1 elem./line
c
	      if (d$itrv.eq.1) then		!interactive
	         write (mssg,10002) elem
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         if (erro.ne.0) goto 900	!error, carry
	      endif
c
	      call f$osdf_(ochan,pai,d$xbuf,usrsiz,ppirace,owname,aliename,
	1                  elem,linelem,erro)
c
	      do k = 1, elem
	         lim1=istrip_(prparray(k)(1:npos))
	         if (lim1.le.0) lim1=1
	         write (ochan,'(a)',err=90003) prparray(k)(1:lim1)
	      enddo
c
	   elseif (ppirace.eq.r$mm) then	!memo
c

c
	   else					!series
c

c
	   endif
c

c
c	   Loop until next creature "header" comes in
c
180	   continue
c
	   call fastnx_(prop,recnum,xbuf1,eos,erro)
	   if (eos) goto 200			!all done
	   read (xbuf1(p1lst:p2lst),'(i<linksz>)',
	1        err=90002) lstrec		!Read pointer to last rec
	   if (lstrec.le.0) goto 180		!old (deleted), loop back
c
	   currec=recnum			!current record
c
	   goto 120				!process it
c
c	All done here
c
200	continue
c
	goto 900				!return
c
c	Return
c	======
c
900	continue
c
	return					!return to caller
c
c	Errors
c	======
c
90001	continue				!can't unload regular bases
	erro=1
	goto 99000
90002	continue				!error reading pointer to last
	erro=2
	goto 99000
90003	continue				!error writing output file
	inquire (unit=ochan,name=fname)
	d$rinf=fname				!tell him which file
	erro=3
	goto 99000
99000	continue
	call errset_('I$UNCR',erro)		!set error
	return					!and return
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	include 'fmt:iuncr.fmt'
c
	end
c
c
c
c
	subroutine I$EDIT_(frtt,ichan,idbform,ibase,ochan,odbform,obase,
     1                     prop,norec,property,series,memo,
     1                     bmap,fmap,nedit,erro)
c	**********************************************************
c
	implicit none
c
	integer ichan,ibase,ochan,obase,prop,bmap(*),fmap(*),
     1          nedit,erro
	logical frtt,idbform,odbform,norec,property,series,memo
c
c	Description
c	===========
c
c	Edits records from database/terminal/file to database/file.
c	Called by procedure E$DIT (EDIT command).
c
c	Input can be from terminal/file/database; output can be to
c	file/database.
c
c	Input/output:	- from/to file if     ICHAN/OCHAN > 0;
c			- from/to database if IBASE/OBASE > 0;
c
c			- from terminalif     FRTT = .true.;
c
c	OCHAN and OBASE can't be both = 0.
c
c	File format is DBAG if idbform/odbform = .true., SDF (system file
c	data format) if idbform/odbform = .false.
c
c	BMAP and FMAP are bit and field maps of IBASE/OBASE/ICHAN if appliable.
c
c	NEDIT return the number of edited records.
c
c	Editing goes on until user types ^Zquit, suspending editing of current
c	record. Then, user must decide on quiting EDIT command or proceeding
c	to next record.
c
c	DBAG editor or a file output procedure will be called here using PAGE.
c	LCPAGE is a local page used to setup PAGE according to the fields
c	wanted by the user or found in the input file.
c
c	If NOREC = .true., only creatures of base will be edited.
c
c	If PROP > 0, is the only property channel to edit.
c
c	If editing current data base, last edited record is set into c$rec.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external istrip_,ndigi_,spfchl_,tty_putc_,tty_getc_,tty_echo_
	integer istrip_,ndigi_,tty_putc_,tty_getc_,tty_echo_
	integer mode,start,size,sizmax,endscr,topscr,margin,edtlin,ttychr,
     1   ttypad,lx,cx,term,used,myused,status,irec,recnum,lstrec,filcnt
	integer k,kval,kkk,f,l,quit,alive,dnfld,mnd,upd2
	character*10  www,cmmd,basenm,when,usrnam,where
	character*(vlong) lcpage(psiz),lcvmsg(psiz)
	integer vfield(psiz),vftype(psiz)
	character*1 hlpmsg(psiz)
	logical dohlp,killed,garbage,dokill,doinsert,defprop,defseries,
	1	defmemo,oldprop
	logical doedit,trunc,frbase,frfile,tobase,tofile
	logical eoedit,eoinp,eobm,eof,vnext,vold,vhelp,vskip
	integer tmpf(d$f),recpos,recsiz,lim1,lim2,ftrans,usrsiz,pp
	character*60 fnam
	character*80 topmsg
	character*1 bell
	real wuser
	integer irace,idim,isize,ideci,hisrace,function,line1
	integer totelem,linelem
	character*10 owname,aliename
	character*30 race
c
c	begin
c	=====
c
	call errclr_('I$EDIT')			!error init
	erro=0
c
	if (ochan.le.0.and.
     1      obase.le.0     ) goto 90003		!edit to nowhere ???
c
	if (us$bat) goto 90005			!batch user
c
	bell=char(7)
c
	dohlp=.true.			!tell editor to do HELP
	wuser=4.0			!and EDTMSG to wait 4 seconds
c
c	FROM/TO
c	=======
c
	frbase=.false.
	frfile=.false.
	tobase=.false.
	tofile=.false.
c
	if (.not.frtt) then
	   if (ichan.gt.0) then
	      frfile=.true.
	   else
	      frbase=.true.
	   endif
	endif
c
	if (ochan.gt.0) then
	   tofile=.true.
	else
	   tobase=.true.
	endif
c
c	From base to base ?
c	===================
c
	if (frbase.and.tobase) return
c
	if (frbase) then
	   call zrace_(ibase,race,irace,idim,isize,ideci,erro)
	else
	   call zrace_(obase,race,irace,idim,isize,ideci,erro)
	endif
	if (erro.ne.0) goto 900			!error, carry
c
	if (irace.ne.r$b) then			!not a regular base
	    if (frtt.and.
	1       tobase     ) then
c	   ok, proceed
	   else
	      goto 90006
	   endif
	endif
c
c	Edit records until end-of-input:	end of bitmap	 (from/to base)
c						end of file      (from file)
c						^Zquit + confirm (all cases)
c
c	Init editing
c	============
c
c	Set fields wanted by user (if not from file) and load limits and
c	mnemonics
c	----------------------------------------------------------------
c
	if (norec) then		!if no records, skip owner base stuff
c	   don't
	else
c
	   if (.not.frfile) then
c
c	      setup wanted fields in array VFIELD
c
	      myused=0				!# of fields
	      do 1001 k = 1, c$fn
	         call outk_(fmap,k,f)		!read the field map...
	         if (f.gt.0) then			!ignore 0 (record#)
	            myused=myused+1		!# of fields
	            vfield(myused)=f		!this field
	         endif
1001	      continue
c
	   endif
c
c	   If not from file, load limits and mnemonics for bases just once
c
	   if (.not.frfile) then
	      used=myused
	      if (tobase) then
	         call vlimit_(obase,used,vfield,lcvmsg,msiz,psiz,
     1                        kind,mini,maxi,pics,erro)
	      else
	         call vlimit_(ibase,used,vfield,lcvmsg,msiz,psiz,
     1                        kind,mini,maxi,pics,erro)
	      endif
	      if (erro.eq.3.and.d$rsub.eq.'VLIMIT') then!protection failure
c	         ignore it, field isn't in field map!!
	      else
	         if (erro.ne.0 ) goto 900	!error, carry
	      endif
	      myused=used
	   endif
c
c	   Initialize editor
c	   -----------------
c
	   mode=4				!(re)display screen
	   lx=1					!start at line 1
	   cx=1					!col. 1
	   topscr=-1				!first line is 1
	   start=3				!first screen line
	   endscr=22				!and last
	   margin=-1				!...
	   edtlin=24				!messages/help at the bottom
c
	   nedit=0				!# of records edited
	   lstrec=0				!last edited record#
c
	   vnext=.true.				!assume next record
	   vold=vnext				!save it away
c
c	   Top screen message
c	   ==================
c
	   topmsg(1:)=' '
c
	   if (frtt) then
c
	      write (topmsg,10001)			!editing to base
	      topmsg(istrip_(topmsg)+2:)=d$unam(obase)
	      write (topmsg(istrip_(topmsg)+1:),10007)	!record#
c
	   else
c
	      if (frbase) then				!from base to file
	         inquire (unit=ochan,name=fnam)
	         lim1=index(fnam,']')			!no directory
	         if (lim1.le.0) lim1=index(fnam,':')
	         if (lim1.gt.0) fnam(1:)=fnam(lim1+1:)	!...
	         lim1=index(fnam,';')			!no version number
	         if (lim1.gt.0) fnam(lim1:)=' '		!...
	         write (topmsg,10003)
	         topmsg(istrip_(topmsg)+2:)=d$unam(ibase)
	         write (topmsg(istrip_(topmsg)+2:),10004)
	         topmsg(istrip_(topmsg)+2:)=fnam
	         write (topmsg(istrip_(topmsg)+1:),10007)!record#
c
	      else					!from file to base
	         inquire (unit=ichan,name=fnam)
	         lim1=index(fnam,']')			!no directory
	         if (lim1.le.0) lim1=index(fnam,':')
	         if (lim1.gt.0) fnam(1:)=fnam(lim1+1:)	!...
	         lim1=index(fnam,';')			!no version number
	         if (lim1.gt.0) fnam(lim1:)=' '		!...
	         write (topmsg,10005)
	         topmsg(istrip_(topmsg)+2:)=fnam
	         write (topmsg(istrip_(topmsg)+2:),10006)
	         topmsg(istrip_(topmsg)+2:)=d$unam(obase)
	         write (topmsg(istrip_(topmsg)+1:),10007)!record#
	      endif
c
	   endif
c
	   recpos=istrip_(topmsg)+2			!record# position
c
	endif
c
c	Edit to creatures
c
	defprop=.false.
	defseries=.false.
	defmemo=.false.
c
	if (frtt.and.
	1   tobase   ) then
c
	   do k = 1, d$nfld(obase)
	      if (d$type(k,obase).eq.p$) then
	         pp=d$dbio(k,obase)
	         if (pp.gt.0) then
	            defprop=.true.
	         endif
	      endif
	      if (d$type(k,obase).eq.s$) then
	         pp=d$dbio(k,obase)
	         if (pp.gt.0) then
	            defseries=.true.
	         endif
	      endif
	      if (d$type(k,obase).eq.mm$) then
	         pp=d$dbio(k,obase)
	         if (pp.gt.0) then
	            defmemo=.true.
	         endif
	      endif
	   enddo
	endif
c
c	get first record
c	================
c
	if (.not.frfile) then
c
	   if (norec) then		!if no records, skip owner base stuff
c	      don't
	   else
c
c	      get first record from base
c
	      recnum=0					!reset bitnxt/bitprv
	      irec=0
	      eobm=.false.				!...
c
100	      continue
c
	      call bitnxt_(bmap,irec,eobm,erro)		!first selected rec.
	      if (erro.ne.0) goto 900			!error, carry
	      if (eobm) goto 90002			!empty bit map ????
	      if (frbase) then
	         call in3ex_(ibase,irec,recnum,erro)
	      else
	         call in3ex_(obase,irec,recnum,erro)
	      endif
	      if (erro.ne.0) goto 900			!error, carry
c
	      if (frbase) then
	         call lookup_(ibase,recnum,alive,lcpage,erro)
	      else
	         call lookup_(obase,recnum,alive,lcpage,erro)
	      endif
	      if (erro.ne.0) then
	         if (d$rsub.eq.'FIND'.and.
	1            erro.eq.5          ) then
	            goto 100				!killed record, ignore
	         else
c	            record with problems, proceed
	         endif
	      endif
c
	   endif
c
	else
c
c	   get first record from file
c
101	   continue
c
	   eof=.false.
	   filcnt=0					!# of records read
	   filcnt=filcnt+1				!account first record
	   ftrans=1				!field transfer always by field#
c
	   trunc=.false.
	   if (idbform) then
	      call f$idbf_(ichan,ftrans,obase,recnum,myused,vfield,vmssg,
     1                     lcpage,eof,trunc,erro)
	   else
	      call i$usz_(obase,usrsiz)			!record size
	      call f$isdf_(ichan,recnum,xbuf1,usrsiz,killed,garbage,eof,
	1                  hisrace,owname,aliename,totelem,linelem,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      if (killed) goto 101			!killed, ignore
	      if (garbage) goto 101			!unrecoverable, ignore
	      call unflat_(obase,lcpage,xbuf1,erro)
	      myused=d$nfld(obase)
	      do k = 1, myused
	         vfield(k)=k
	      enddo
	   endif
	   if (erro.ne.0) goto 900			!error, carry
c
	   if (eof) goto 90001				!file is empty
c
	endif
c
	eoinp=.false.					!end of input
c
c	============================================
c
cwhile	do while (.not.eoinp)
1098	continue
	   if (eoinp) goto 1099
c
	   eoedit=.false.
	   vhelp=.false.
	   vskip=.false.
c
c	   Set PAGE correctly before calling editor
c	   ----------------------------------------
c
c	   See if record exists in data base
c
	   if (norec) then		!if no records, skip owner base stuff
	      erro=0
	   else
	      if (tobase) then
	         call find_(obase,recnum,alive,d$xbuf,erro)
	      else
	         call find_(ibase,recnum,alive,d$xbuf,erro)
	      endif
	   endif
c
	   if (erro.ne.0) then
c
	      if (frfile) then
	         write (mssg,10012)			!can't find record
	         recsiz=ndigi_(recnum)			!add record#
	         call wrivar_(mssg(istrip_(mssg)+2:),recnum,recsiz,erro)
	         if (erro.ne.0) goto 90004		!write error
	         write (mssg(istrip_(mssg)+2:),10013)	!ignored...
	         call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	      endif
	      call errclr_('I$EDIT')			!clear error
	      erro=0
c
	      eoedit=.true.				!don't edit
	      vskip=.true.				!skip to next record
c
	   else
c
	      if (norec) then		!if no records, skip owner base stuff
	         myused=1				!make it work...
	      else
c
	         if (frfile) then		!FROM file
c
	            do 1002 k = 1, myused
	               tmpf(k)=vfield(k)		!save VFIELD aside
1002	            continue
c
	            kkk=0				!index/counter
	            do 1003 l = 1, c$fn			!wanted fields
	               call outk_(fmap,l,kval)		!hard to read, field map
	               if (kval.gt.0) then		!ignore 0 (record#)
	                  do 1004 k = 1, myused		!see if read from file
	                     f=tmpf(k)
	                     if (f.eq.kval) then
	                        kkk=kkk+1
	                        vfield(kkk)=f
	                        page(kkk)=lcpage(k)	!copy used/wanted fields
	                        blink(kkk)=vedbli
	                        call zmndt_(obase,f,mnd,erro)
	                        if (erro.ne.0) goto 900	!error, carry
	                        if (mnd.eq.0) then
	                           vftype(kkk)=vfrw$	!read/write
	                        else
	                           vftype(kkk)=vfrwm$	!read/write/mandatory
	                        endif
	                     endif
1004	                  continue
	               endif
1003	            continue
	            myused=kkk
c
c	            Load mnemonics, limits, etc for each record read from file
c
	            call vlimit_(obase,myused,vfield,vmssg,msiz,psiz,
     1                           kind,mini,maxi,pics,erro)
	            if (erro.eq.3.and.
	1               d$rsub.eq.'VLIMIT') then	!protection failure
c	               ignore it, field isn't in field map !!
	            else
	               if (erro.ne.0 ) goto 900		!error, carry
	            endif
c
	         else				!FROM/TO base
c
	            do 1005 l = 1, myused		!copy wanted fields
	               f=vfield(l)
	               page(l)=lcpage(f)
	               vmssg(l)=lcvmsg(l)
	               blink(l)=vedbli
	               if (frbase) then
	                  call zmndt_(ibase,f,mnd,erro)
	                  if (erro.ne.0) goto 900	!error, carry
	                  if (mnd.eq.0) then
	                     vftype(l)=vfrw$		!read/write
	                  else
	                     vftype(l)=vfrwm$		!read/write/mandatory
	                  endif
	               else
	                  call zmndt_(obase,f,mnd,erro)
	                  if (erro.ne.0) goto 900	!error, carry
	                  if (mnd.eq.0) then
	                     vftype(l)=vfrw$		!read/write
	                  else
	                     vftype(l)=vfrwm$		!read/write/mandatory
	                  endif
	               endif
1005	            continue
c
	         endif
c
	      endif
c
	   endif
c
c	   call editor and get next record to edit if that's the case
c	   ----------------------------------------------------------
c
cwhile	   do while (.not.eoedit)
1096	   continue
	      if (eoedit) goto 1097
c
	      if (norec) then		!if no records, skip owner base stuff
c	         don't
	      else
c
c	         tell him (or her) what's going on..., unless HELP
c
	         if (.not.vhelp) then
c
	         recsiz=ndigi_(recnum)			!add record#
	         call wrivar_(topmsg(recpos:),recnum,recsiz,erro)
	         if (erro.ne.0) goto 90004		!write error
c
	         call vtext_(topmsg(1:80),1,1,vedbli)	!top message
	         call vset2_(2)				!clean screen
c
	         endif
c
	      endif
c
	      if (myused.le.0) then			!no field to edit
c
	         if (norec) then	!if no records, skip owner base stuff
c	            don't
	         else
c
	            write (mssg,10009)			!no field to edit, warn
	            recsiz=ndigi_(recnum)		!add record#
	            call wrivar_(mssg(istrip_(mssg)+2:),recnum,recsiz,erro)
	            if (erro.ne.0) goto 90004		!write error
	            write (mssg(istrip_(mssg)+2:),10013)!ignored...
	            call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	            vskip=.true.
	            eoedit=.true.
c
	         endif
c
	      else
c
c	         edit record now (uf!)
c
	         if (norec) then	!if no records, skip owner base stuff
c	            don't
	         else
c
	            used=myused				!"refresh" used lines
	            size=start+used-1			!screen size
	            if (size.gt.endscr) size=endscr	!truncate to max
	            sizmax=size
	            db$rec=recnum			!allow duplicate rec#
	            dokill=.false.			!no ^Z KILL
	            doinsert=.false.			!no ^Z INSERT
	            call vedits_(spfchl_,mode,start,size,topscr,margin,
     1                           lx,cx,vmssg,msiz,page,psiz,used,mini,
     1                           maxi,pics,kind,term,xpos,ypos,blink,
     1                           edtlin,dohlp,hlpmsg,sizmax,status,
     1                           vftype,dokill,doinsert,erro)
	            if (erro.ne.0) goto 900		!error, carry
	            if (.not.s$set(s$talk)) then
	               call tty_echo_(.false.)		!as before
	            endif
	            nedit=nedit+1			!account it
	            vnext=.true.			!assume next record
	            vhelp=.false.			!no HELP/GOLD HELP
	            vskip=.false.			!dont' skip record
c
c	          status = -1	return
c			   -2	up-arrow
c			   -3	down-arrow
c			   -4	GOLD/up-arrow
c			   -5	GOLD/down-arrow
c			   -6	HELP, GOLD/HELP
c			   =0	^Z QUIT
c			   >0	^Z EXIT
c
	            if     (status.eq.0) then	!^Z QUIT
c
	               call tty_putc_(bell)		!ring
	               write (mssg(1:),10008)		!leave EDIT comm. (y/n)?
	               call vtext_(mssg(1:istrip_(mssg)+2),edtlin,1,vedbli)
c
123	               continue
	               call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	               if (erro.ne.0) noerror
	               if     (ttypad.le.0.and.
	1                      (ttychr.eq.121.or.	!'y'
	1                       ttychr.eq.89     ) ) then!'Y'
	                  vskip=.true.			!'Y', leave
	                  eoedit=.true.
	                  eoinp=.true.
	                  call erase_line_(edtlin,1)	!clean line
	                  nedit=nedit-1			!de-account it
	               elseif (ttypad.le.0.and.
	1                      (ttychr.eq.110.or.	!'n'
     1                          ttychr.eq.78     ) ) then!'N'
	                  vskip=.true.			!'N', edit next record
	                  eoedit=.true.
	                  call erase_line_(edtlin,1)	!clean line
	                  nedit=nedit-1			!de-account it
	               else
	                  goto 123			!try again
	               endif
c
	            elseif (status.eq.-6) then	!HELP
c
	               nedit=nedit-1			!de-account it
c
	               write (mssg,10011)		!help message
	               call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
c
	               vhelp=.true.
	               vskip=.false.
	               mode=5				!dont't re(display)scr.
c
	            else
c
	               eoedit=.true.
c
	               lx=1				!line 1
	               cx=1				!col. 1
	               topscr=-1			!first line is 1
	               mode=4				!re(display) screen
c
	            endif
c
	            if (.not.vhelp.and.
     1                  .not.vskip.and.
     1                  .not.eoinp     ) then
c
c	               --------------------------------------------------
c
	               if (tofile) then
c
	                  if (odbform) then
	                     call f$odbf_(ochan,ibase,recnum,myused,vfield,
     1                                    vmssg,page,erro)
	                  else
	                     call flat_(ibase,page,xbuf1,erro)
	                     if (erro.ne.0) goto 900	!error, carry
	                     call i$usz_(ibase,usrsiz)	!record size
	                     owname(1:)=' '		!no owner base
	                     aliename(1:)=' '		!no creature
	                     totelem=0			!no elem.
	                     linelem=0			!...
	                     call f$osdf_(ochan,recnum,xbuf1,usrsiz,
	1                                 irace,owname,aliename,
	1                                 totelem,linelem,erro)
	                  endif
	                  if (erro.ne.0) goto 900	!error, carry
c
	               else
c
	                  lstrec=recnum			!last edited record
c
	                  call lookup_(obase,recnum,alive,lcpage,erro)
	                  if (erro.ne.0) then
	                     if (.not.frfile.and.
	1                        d$rsub.eq.'FIND'.and.
	1                        erro.eq.5          ) then
	                        vskip=.true.		!skip to next record
	                        vhelp=.false.		!no help
	                        eoinp=.false.
	                        goto 200		!killed record, ignore
	                     else
c	                        record with problems, proceed
	                     endif
	                  endif
c
	                  doedit=.false.		!assume no need to edit
	                  do 1006 k = 1, myused
	                     f=vfield(k)
	                     lim1=istrip_(page(k))	!VEDITS adds nulls...
	                     lim2=istrip_(lcpage(f))	!so do complete check
	                     if     (lim1.ne.lim2) then
	                        doedit=.true.		!don't forget it
	                        lcpage(f)=page(k)	!copy edited lines
	                     else
	                        if (lim1.gt.0) then
	                           if (page(k)(1:lim1).ne.
	1                              lcpage(f)(1:lim1)) then
	                              doedit=.true.	!don't forget it
	                              lcpage(f)=page(k)	!copy edited lines
	                           endif
	                        endif
	                     endif
1006	                  continue
c
	                  if (doedit) then		!edit record
c
	                     erro=-16381744		!edit NOT to validate
	                     call edit_(obase,recnum,lcpage,erro)
	                     if (erro.ne.0) goto 900	!error, carry
c
	                  endif
c
	               endif
c
c	               what happens now ?
c
	               if     (status.eq.-1.or.		!<ret> or
     1                         status.eq.-3.or.		!down-arrow or
     1                         status.eq.-5    ) then	!GOLD/down-arrow
c
	                  vnext=.true.			!next record
	                  vskip=.true.
	                  eoedit=.true.
c
	               elseif (status.eq.-2.or.		!up-arrow or
     1                         status.eq.-4    ) then	!GOLD/up-arrow
c
	                  vnext=.false.			!previous record
	                  vskip=.true.
	                  eoedit=.true.
c
	                  if (frfile) then		!no-op if FRFILE, warn
	                     write (mssg,10010)
	                     call edtmsg_(mssg(1:istrip_(mssg)+1),
     1                                    edtlin,1,wuser)
	                     vskip=.false.		!don't skip to next rec.
                          endif
c
	               else				!^Z EXIT
c
	                  vskip=.true.
	                  eoedit=.true.
	                  vnext=vold			!keep previous motion
c
	               endif
c
	            endif
c
	         endif
c
	         if (.not.eoinp) then			!if not all done
c
	            if (frtt.and.
	1               tobase     ) then
c
c	               Edit to properties
c
	               if (defprop.and.property) then
	                  do k = 1, d$nfld(obase)
	                     if (d$type(k,obase).eq.p$) then
	                        pp=d$dbio(k,obase)
	                        if (pp.gt.0) then
	                           if (prop.le.0.or.
	1                              (prop.gt.0.and.
	1                               pp.eq.prop    ) ) then
	                              call erase_page_(2,1)	!clean screen
	                              oldprop=.true.		!an old property
	                              function=1		!editing
	                              if (norec) then
	                                 recnum=-1	!let I$EDPP ask for it
	                              endif
	                              line1=2		!use screen from line 2
	                              call i$edpp_(obase,pp,recnum,oldprop,
	1                                          function,line1,erro)
	                              if (erro.ne.0) goto 900	!error, carry
	                           endif
	                        endif
	                     endif
	                  enddo
	               endif
c
c	               Series
c
	               if (defseries.and.series) then

	               endif
c
c	               Memos
c
	               if (defmemo.and.memo) then

	               endif

c
c	               Reload mnemonics and minimums if gone
c
	               if (norec) then	!if no records, skip owner base stuff
c	                  don't
	               else
c
	                  if (defprop.or.
	1                     defseries.or.
	1                     defmemo      ) then
	                     call vlimit_(obase,used,vfield,lcvmsg,msiz,psiz,
     1                                    kind,mini,maxi,pics,erro)
	                     if (erro.eq.3.and.d$rsub.eq.'VLIMIT') then
c ignore it, field isn't in field map (protection failure)
	                     else
	                        if (erro.ne.0 ) goto 900	!error, carry
	                     endif
	                  endif
	                endif
	            endif
	         endif
	      endif
c
	      if (norec) eoedit=.true.
c
	      goto 1096
1097	   continue
cwhile	   enddo
c
	   if (norec) then	!if no records, skip owner base stuff
c	      don't
	   else
c
c	      get next/previous record if not VHELP and not EOINP and VSKIP
c	      -------------------------------------------------------------
c
200	      continue
c
	      if (.not.vhelp.and.
     1            .not.eoinp.and.
     1            vskip          ) then
c
	         if (.not.frfile) then		!FROM base
c
c	            get next/previous record from base
c
	            if (vnext) then
	               call bitnxt_(bmap,irec,eobm,erro)!next selected rec.
	            else
	               call bitprv_(bmap,irec,eobm,erro)!prev. selected rec.
	            endif
	            if (erro.ne.0) goto 900		!error, carry
c
	            vold=vnext				!remember current motion
c
	            if (eobm) then
	               eoinp=.true.			!flag all done
	            else
	               if (frbase) then
	                  call in3ex_(ibase,irec,recnum,erro)
	               else
	                  call in3ex_(obase,irec,recnum,erro)
	               endif
	               if (erro.ne.0) goto 900		!error, carry
	               if (frbase) then
	                  call lookup_(ibase,recnum,alive,lcpage,erro)
	              else
	                  call lookup_(obase,recnum,alive,lcpage,erro)
	               endif
	               if (erro.ne.0) then
	                  if (.not.frfile.and.
	1                     d$rsub.eq.'FIND'.and.
	1                     erro.eq.5          ) then
	                     vskip=.true.		!skip to next record
	   		     vhelp=.false.		!no help
	                     eoinp=.false.
	                     goto 200			!killed record, ignore
	                  else
c	                     record with problems, proceed
	                  endif
	               endif
	            endif
c
	         else				!FROM file
c
c	            get next record from file
c
	            trunc=.false.
	            if (idbform) then
	               ftrans=1			!field transfer always by field#
	               call f$idbf_(ichan,ftrans,obase,recnum,myused,vfield,
     1                              vmssg,lcpage,eof,trunc,erro)
	            else
	               call i$usz_(obase,usrsiz)	!record size
	               call f$isdf_(
	1                  ichan,recnum,xbuf1,usrsiz,killed,garbage,eof,
	1                  hisrace,owname,aliename,totelem,linelem,erro)
	               if (erro.ne.0) goto 900		!error, carry
	               if (killed) goto 200		!killed, ignore
	               if (garbage) goto 200		!unrecov.,ignore
	               call unflat_(obase,lcpage,xbuf1,erro)
	               myused=d$nfld(obase)
	               do k = 1, myused
	                  vfield(k)=k
	               enddo
	            endif
	            if (erro.ne.0) goto 900		!error, carry
c
	            if (.not.eof) then
	               filcnt=filcnt+1			!account record
	            else
	               eoinp=.true.			!flag all done
	            endif
c
	         endif
c
	      endif
c
	   endif
c
	   if (norec) eoinp=.true.			!all done
c
	   goto 1098
1099	continue
cwhile	enddo
c
	goto 900					!return
c
c	Return
c	======
c
900	continue
c
	if (tobase) then
	   if (obase.eq.c$base) then
	      if (lstrec.gt.0) then
	         c$rec=lstrec				!current record
	         c$fld=0
	      endif
	   endif
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c	input file is empty
90001	continue
	erro=1
	d$edit=1
	goto 99000
c	no record to edit
90002	continue
	erro=2
	goto 99000
c	internal error: edit TO nowhere
90003	continue
	erro=3
	goto 99000
c	internal error: read/write error
90004	continue
	erro=4
	goto 99000
c	batch user, can't use editor
90005	continue
	erro=5
	goto 99000
c	Can't edit, not a regular base
90006	continue
	erro=6
	goto 99000
c
c	Set error
c	---------
99000	continue
c
	call errset_('I$EDIT',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:iedit.fmt'
c
	end
c
c
c
c
	subroutine I$FAKS_(WHAT,record,erro)
c	************************************
c
	implicit none
c
	integer record, erro
	character*(*) what
c
c	Description
c	===========
c
c	This procedure "fakes" SCPSYN call to set some frequently used default
c	scopes, allowing subsequent standard calls to SCPCHK and SCPSEM.
c	WHAT may contain 'ALL' (all records), 'TOP' (top record), 'CUR' (current
c	record), 'REC' (record number RECORD) or 'NON' (none).
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
c	begin
c	=====
c
	call errclr_('I$FAKS')			!error init
	erro=0
c
	if     (what(1:3).eq.'ALL') then
	   c$scpx=1				!1 expression
	   c$scpl(1)=-2				!from -2 (TOP record)
	   c$scpu(1)=-3				!to   -3 (BOTTOM record)
	elseif (what(1:3).eq.'TOP') then
	   c$scpx=1				!1 expression
	   c$scpl(1)=-2				!from -2 (TOP record)
	   c$scpu(1)=-2				!to   -2 (TOP record)
	elseif (what(1:3).eq.'CUR') then
	   c$scpx=1				!1 expression
	   c$scpl(1)=-1				!from -1 (CURRENT record)
	   c$scpu(1)=-1				!to   -1 (CURRENT record)
	elseif (what(1:3).eq.'REC') then
	   c$scpx=1				!1 expression
	   c$scpl(1)=record			!from record
	   c$scpu(1)=record			!to   record
	elseif (what(1:3).eq.'NON') then
	   c$scpx=0				!no expression
	else
	   goto 90001				!???
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Unknown SCOPE to be "faked"
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$FAKS',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$FAKF_(base,WHAT,NF,fwrite,protfail,erro)
c	*****************************************************
c
	implicit none
c
	integer base,nf,erro
	logical fwrite,protfail
	character*(*) what
c
c	Description
c	===========
c
c	This procedure "fakes" FLDSYN call to set some frequently used default
c	fields, allowing subsequent standard call to FLDSEM.
c	WHAT may contain 'ALL' (all fields). NF = #fields or
c	'NON' for no fields at all
c	If FWRITE = .true., caller wants to use fields in update mode.
c	If protected fields, they are ignored and PROTFAIL = .true.
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
	integer k,kkk
c
c	begin
c	=====
c
	call errclr_('I$FAKF')			!error init
	erro=0
c
	protfail=.false.
c
	if     (what(1:3).eq.'ALL') then
	   kkk=0
	   do 1001 k = 1, nf
c
c	      see protection
c
	      if ((d$prt(base).ne.0).and.	!protection ON and
	1         ((d$prfl(k,base).eq.prtno).or.!no access
	1          (d$prfl(k,base).eq.prtro.and.!or read only and update, ignore
	1          fwrite)                     ) ) then
	         protfail=.true.
	      else
	         kkk=kkk+1
	         c$fldn(kkk)=k			!set field %<k> as wanted
	      endif
1001	   continue
	   c$fn=kkk				!# of wanted fields
	elseif (what(1:3).eq.'NON') then
	   do 1002 k = 1, nf
	      c$fldn(k)=0
1002	   continue
	   c$fn=0
	else
	   goto 90001				!???
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Unknown FIELDS to be "faked"
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$FAKF',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine i$fker_(base,all,who,what,erro)
c	******************************************
c
	implicit none
c
	integer base,all,who(all),what(all),erro
c
c	Description
c	===========
c
c	Gives  full report if FORCHK has detected any field type conflict for
c	base BASE. Ofending field(s) in WHO, diagnostic in WHAT, both used up
c	to ALL.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:stack.own'
c
	external istrip_,trim_
	integer istrip_,trim_
	character*12 petty
	integer k,l,wt,wo
c
c	begin
c	=====
c
	call errclr_('I$FKER')		!error init
	erro=0
c
	if (base.le.0.or.
     1      base.gt.d$b) goto 90001		!????????????
c
	mssg(1:)=' '
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) goto 900		!error, carry
c
	do 1001 k=1,all
c
	   wt=what(k)			!here error "what"
c
	   if (wt.gt.9) goto 90001			!????????????
c
	   if (wt.gt.0) then		!ignore if 0
c
	      wo=who(k)			!in field "who"
	      if     (wt.eq.1) then
	         write(petty(1:),'(i6)')wo
	         l=trim_(petty)
	         write(mssg(1:),10001)petty(l:),d$unam(base)
	      else
	         if     (wt.eq.2) then
	               write(mssg(1:),10002)huge$(wo),d$unam(base)
	         elseif (wt.eq.3) then
	            if (wo.lt.0.or.
     1                  wo.gt.d$nfld(base)) goto 90001	!????????????
	            if (wo.eq.0) then		!#
	               write(mssg(1:),10013)d$unam(base)
	            else
	               write(petty(1:),'(i6)')wo
	               l=trim_(petty)
	               write(mssg(1:),10003)petty(l:),d$unam(base)
	            endif
	         elseif (wt.eq.4) then
	            l=istrip_(hubl$(wo))
	            if (l.le.0) goto 90001		!?????????????
	            write(mssg(1:),10004)hubl$(wo)(1:l)
	         elseif (wt.eq.5) then
	            l=istrip_(hubr$(wo))
	            if (l.le.0) goto 90001		!?????????????
	            write(mssg(1:),10005)hubr$(wo)(1:l)
	         elseif (wt.eq.6) then
	            write(mssg(1:),10006)
	         elseif (wt.eq.7) then
	            write(mssg(1:),10007)
	         elseif (wt.eq.8) then
	            write(mssg(1:),10008)
	         elseif (wt.eq.9) then
	            write(mssg(1:),10009)
	         endif
	      endif
c
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	   endif
c
1001	continue
c
	mssg(1:)=' '
	call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	if (erro.ne.0) goto 900		!error, carry
c
c	Return
c
900	continue
c
	return					!return to caller
c
c	Error
c	=====
c
c	can't report error!!!
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$FKER',erro)
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	include 'fmt:ifker.fmt'
c
	end
c
c
c
c
	subroutine I$RELO_(obase,myrace,ichan,chkinp,nalive,nkill,crcount,
	1                  erro)
c	****************************************************************
c
	implicit none
c
	integer obase,myrace,ichan,nalive,nkill,crcount(*),erro
	logical chkinp
c
c	Description
c	===========
c
c	Try to reload ALL database BASE (race MYRACE) records from channel
c	ICHAN.
c	Check input data if CHKINP = .true.
c	File format is SDF (system file data format).
c
c	NALIVE	total alive records, reloaded.
c	NKILL	total killed records reloaded.
c	CRCOUNT	total creature unloaded.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagd.own'
c
	external istrip_
	integer istrip_
	integer usrsiz,oldrec,irec,prvrec,newrec,dfroz,k,kkk,pai
	logical eof,killed,garbage,lost,errstp,askerr,notdone,
	1	defprop,defseries,defmemo,creatok,newopn
	integer hisrace,totelem,linelem,fidx,prop,bb,bmsize,update,mode,b2
	integer aliensz,ownsz,alive
	character*10 owname,aliename,tmpnam
	character*60 fname,bown
c
c	begin
c	=====
c
	call errclr_('I$RELO')				!error init
	erro=0
c
	nalive=0
	nkill=0
	do k = 1, d$nfld(obase)
	   crcount(k)=0
	enddo
c
	errstp=s$set(s$erro)			!ERRORSTOP
	askerr=.true.				!ask about anyway
c
	oldrec=0
	eof=.false.
c
	dfroz=d$froz(obase)			!save base status
c
	d$froz(obase)=1				!don't re-use killed rec#'s
c
	update=1				!for update
	if (myrace.eq.r$b) then
	   call i$usz_(obase,usrsiz)		!my record size
	   b2=obase				!remember base
	else
	   bown(1:)=' '
	   bown=d$ownb(obase)			!open owner base
	   mode=0				!usual mode
	   call open_(bb,bown,update,mode,newopn,erro)
	   if (erro.ne.0) then
	      goto 90004			!can't open owner base
	   endif
	   call i$usz_(bb,usrsiz)		!owner base record size
	   b2=bb				!remember base
	endif
c
c	(Re)open creatures as well
c
	call opncrt_(b2,update,defprop,defseries,defmemo,erro)
	if (erro.ne.0) then
	   call errclr_('I$RELO')		!ignore errors
	   erro=0
	endif
c
	call f$isdf_(ichan,oldrec,xbuf1,usrsiz,killed,garbage,eof,
	1            hisrace,owname,aliename,totelem,linelem,erro)
	if (erro.ne.0) goto 900			!error, carry
	if (eof) goto 90001			!file is empty
	if (oldrec.le.0) goto 90002		!???
	if (hisrace.eq.r$b) then		!regular base
	   call ex3in_(obase,oldrec,irec,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   prvrec=irec-1			!previous rec#
	endif
c
	do while (.not.eof)
c
	   if (hisrace.eq.r$b) then		!regular base
c
	      if (irec.ne.prvrec+1) goto 90002	!???
	      prvrec=irec			!previous rec#
c
c	      reload record
c
	      lost=.false.
c
	      if (chkinp.and..not.killed) then
	         erro=0				!VALIDATE input
	      else
	         erro=-16381744			!don't validate
	      endif
	      xbuf1(1:1)=' '			!still alive
	      call more_(obase,newrec,xbuf1,erro)
	      if (erro.ne.0) then
                 if     (d$rsub.eq.'MORE'.or.	!KEY field errors
	1                d$rsub.eq.'CHKLIN'.or.	!CHKLIN errors
	1                d$rsub.eq.'VALIDA'.or.	!VALIDA errors
	1                d$rsub.eq.'CUNFLT'.or.
	1                d$rsub.eq.'CUNF'      ) then!CUNFLT errors
	            lost=.true.			!don't forget
	            garbage=.false.		!and don't get confused
	            killed=.false.		!...
	            call errmsg_(d$rsub,erro,mssg,'%')!get error message
	            call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, return
c
	            if (errstp.and.askerr) then
	               askerr=.false.		!confirm only once
	               call i$ster_(errstp,erro)!really ?
	            endif
	            if (errstp) goto 900	!stop on errors
	            if (erro.ne.0) goto 900	!error, carry
c
	            xbuf1(1:1)=' '		!still alive
	            erro=-16381744		!don't validate
	            call more_(obase,newrec,xbuf1,erro)!last try
	            if (erro.ne.0) goto 900	!should work ...
c
	         else
	            goto 900			!error, carry
	         endif
	      endif
c
	      if     (lost) then
	         nkill=nkill+1			!account killed record
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10005) oldrec,newrec
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      elseif (garbage) then
	         nkill=nkill+1			!account killed record
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10003) oldrec,newrec
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      elseif (killed) then
	         nkill=nkill+1			!account killed record
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10002) oldrec,newrec
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      else
	         nalive=nalive+1		!account alive record
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10001) oldrec,newrec
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
c
	      if (garbage.or.lost.or.killed) then
 	         call kill_(obase,newrec,erro)	!so young...
	         if (erro.ne.0) goto 900	!error, carry
	         if (d$itrv.eq.1) then		!interactive
	            write (mssg,10004)
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900	!error, carry
	         endif
	      endif
c
	   else					!creatures
c
	      creatok=.false.
c
	      aliensz=istrip_(aliename)
	      if (aliensz.le.0) aliensz=1
	      ownsz=istrip_(owname)
	      if (ownsz.le.0) ownsz=1
	      if     (hisrace.eq.r$pp) then	!property
	         write (mssg,10006) aliename(1:aliensz),
	1                           owname(1:ownsz),oldrec
	      elseif (hisrace.eq.r$mm) then	!memo
	         write (mssg,10007) aliename(1:aliensz),
	1                           owname(1:ownsz),oldrec
	      else				!series
	         write (mssg,10006) aliename(1:aliensz),
	1                           owname(1:ownsz),oldrec
	      endif
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900			!error, carry
c
	      if     (myrace.eq.r$b) then		!me base, you ?
	         call uc_(owname)			!mine ?
	         tmpnam=d$unam(obase)
	         call uc_(tmpnam)
	         if (tmpnam.ne.owname) then
	            write (mssg,10010)			!not mine
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900		!error, carry
	            fidx=0				!ignore
	         else
	            call znum_(obase,fidx,aliename,erro)!see if really mine
	            if (erro.ne.0) goto 900		!error, carry
	         endif
	         bb=obase				!owner base
	      else					!me alien, you ?
	         if (myrace.eq.r$pp.and.
	1            hisrace.eq.r$pp    .or.
	1            myrace.eq.r$mm.and.
	1            hisrace.eq.r$mm    .or.
	1            myrace.ne.r$pp.and.
	1            myrace.ne.r$mm.and.
	1            hisrace.eq.r$si        ) then
	            call uc_(owname)			!mine ?
	            tmpnam=d$ownb(obase)
	            call uc_(tmpnam)
	            if (tmpnam.ne.owname) then
	               write (mssg,10010)		!not mine
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	               if (erro.ne.0) goto 900		!error, carry
	               fidx=0				!ignore
	            else
	               call uc_(aliename)
	               tmpnam=d$unam(obase)
	               call uc_(tmpnam)
	               if (tmpnam.ne.aliename) then
	                  write (mssg,10010)		!not mine
	                  call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	                  if (erro.ne.0) goto 900	!error, carry
	                  fidx=0
	               else
	                  call znum_(bb,fidx,aliename,erro)!see if really mine
	                  if (erro.ne.0) goto 900	!error, carry
	               endif
	            endif
	         else
	            write (mssg,10010)			!not mine
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900		!error, carry
	            fidx=0				!ignore
	         endif
	      endif
	      if (fidx.gt.0) then			!last check:rec# exists?
	         alive=0				!not used anymore
	         call find_(bb,oldrec,alive,d$xbuf,erro)
	         if (erro.ne.0) then
	            write (mssg,10011)			!no such record
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900		!error, carry
	            fidx=0
	         endif
	      endif
	      if (fidx.le.0) then			!not mine, ignore rest
	         do kkk = 1, totelem			!get rest of it
	            read (ichan,'(a)',err=90003) xbuf1
	         enddo
	         if (errstp.and.askerr) then
	            askerr=.false.			!confirm only once
	            call i$ster_(errstp,erro)		!really ?
	         endif
	         if (errstp) goto 900			!stop on errors
	         if (erro.ne.0) goto 900		!error, carry
	         goto 200				!next record/creature
	      endif
c
	      notdone=.true.
	      if     (hisrace.eq.r$pp) then			!property
c
	         if (myrace.eq.r$b) then
	            prop=d$dbio(fidx,obase)
	         else
	            prop=obase
	         endif
	         pai=oldrec					!owner rec#
	         do k = 1, totelem				!get all elem.
	            xbuf1(1:1)=' '
	            read (ichan,'(a)',err=90003) xbuf1(2:)
	            if (chkinp) then				!check input
	               call valida_(prop,xbuf1,erro)
	            endif
	            if (erro.eq.0) then
	               call unflat_(prop,page,xbuf1,erro)
	               if (erro.eq.0) then
	                  if (notdone) then
	                     call putsw_(prop,pai,page,erro)	!put 1st elem.
	                     notdone=.false.
	                  else
	                     call appsw_(prop,pai,page,erro)	!append others
	                  endif
	               endif
	            endif
	            if (erro.eq.0) then
	               creatok=.true.				!remember ok
	            else
	               call errmsg_(d$rsub,erro,mssg,'%')	!get message
	               call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	               do kkk = k+1, totelem			!get rest of it
	                  read (ichan,'(a)',err=90003) xbuf1
	               enddo
	               if (errstp.and.askerr) then
	                  askerr=.false.			!conf. only once
	                  call i$ster_(errstp,erro)		!really ?
	               endif
	               if (errstp) goto 900			!stop on errors
	               if (erro.ne.0) goto 900			!error, carry
	               goto 200					!next rec./cr.
	            endif
c
	         enddo
c
	         if (creatok) then
	            write (mssg,10009) totelem			!tell user
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	            if (erro.ne.0) goto 900			!error, carry
	            crcount(fidx)=crcount(fidx)+1		!account it
	         endif
c
	      elseif (hisrace.eq.r$mm) then			!memo
c

c
	      else						!series
c

c
	      endif
c
	   endif
c
c	   get next record/creature
c
200	   continue
c
	   call f$isdf_(ichan,oldrec,xbuf1,usrsiz,killed,garbage,eof,
	1               hisrace,owname,aliename,totelem,linelem,erro)
 	   if (erro.ne.0) goto 900				!error, carry
	   if (hisrace.eq.r$b) then				!regular base
	      call ex3in_(obase,oldrec,irec,erro)
	      if (erro.ne.0) goto 900				!error, carry
	   endif
c
	enddo
c
	goto 900						!return
c
c	Return
c	======
c
900	continue
c
	d$froz(obase)=dfroz			!restore base status
c
	return					!return to caller
c
c	Errors
c	======
c
c	Input file is empty
90001	continue
	erro=1
	goto 99000				!set error
c	Bad record#
90002	continue
	erro=2
	goto 99000				!set error
c	Error reading input file
90003	continue
	inquire (unit=ichan,name=fname)
	d$rinf=fname				!tell him which file
	erro=3
	goto 99000				!set error
c	Can't open owner base
90004	continue
	d$rinf=bown				!tell him which base
	erro=4
	goto 99000				!set error
c
c	Set error
c
99000	continue
c
	d$froz(obase)=dfroz			!restore base status
c
	call errset_('I$RELO',erro)
c
	return
c
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	include 'fmt:irelo.fmt'
c
	end
c
c
c
c
	subroutine I$REPL_(ichan,idbform,obase,chkinp,bmap,fmap,erro)
c	*************************************************************
c
	implicit none
c
	integer ichan,obase,bmap(*),fmap(*),erro
	logical idbform,chkinp
c
c	Description
c	===========
c
c	Replaces records from file to database.
c	Called by procedure R$EPLA (REPLACE command).
c
c	Input/output:	- from file;          (ICHAN > 0)
c			- to database         (OBASE > 0)
c
c	ICHAN and OBASE can't be = 0.
c
c	File format is DBAG if idbform/odbform = .true., SDF (system file
c	data format) if idbform/odbform = .false.
c
c	BMAP and FMAP are bit and field maps of OBASE/OCHAN.
c
c	If replacing current data base, last replaced record is set into c$rec.
c
c	If CHKINP = .false., input data will not be validated (!!!).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external istrip_,tty_putc_
	integer istrip_,tty_putc_
	integer myused,recnum,lstrec,filcnt,k,kval,kkk,f,l,alive,usrsiz
	character*10  www,cmmd,basenm,when,usrnam,where
	character*(vlong) lcpage(psiz),lcvmsg(psiz)
	integer vfield(psiz),vftype(psiz)
	logical dorepl,trunc,frbase,killed,garbage
	logical eoinp,eobm,eof,badrec,askerr,errstp,errfnd
	integer ftrans,tmpf(d$f),recpos,lim1,lim2,nrepl,ntrunc,nbad
	character*60 fnam
	character*80 topmsg
	character*1 bell
	integer hisrace,totelem,linelem
	character*10 owname,aliename
c
c	begin
c	=====
c
	call errclr_('I$REPL')			!error init
	erro=0
c
	bell=char(7)
c
	if (obase.le.0) goto 90003		!replace to nowhere ???
	if (ichan.le.0) goto 90004		!replace from nowhere ???
c
c	Replace records until end-of-input:	end of file      (from file)
c
c	Initialize replacing
c	====================
c
	nrepl=0					!# of records replaced
	ntrunc=0				!truncated/rounded
	nbad=0					!rejected
c
	lstrec=0				!last replaced record#
c
	errstp=s$set(s$erro)			!ERRORSTOP
	askerr=.true.				!ask him about ERRORSTOP
c
c	get first record
c	================
c
	filcnt=0					!# of records read
	filcnt=filcnt+1					!account first record
c
100	continue
c
	trunc=.false.
	if (idbform) then
	   ftrans=1				!field transfer always by field#
	   call f$idbf_(ichan,ftrans,obase,recnum,myused,vfield,vmssg,lcpage,
     1                  eof,trunc,erro)
	else
	   call i$usz_(obase,usrsiz)			!record size
	   call f$isdf_(ichan,recnum,xbuf1,usrsiz,killed,garbage,eof,
	1               hisrace,owname,aliename,totelem,linelem,erro)
	   if (erro.ne.0) goto 900			!error, carry
	   if (killed) goto 100				!killed, ignore
	   if (garbage) goto 100			!unrecoverable, ignore
	   call unflat_(obase,lcpage,xbuf1,erro)
	   myused=d$nfld(obase)
	   do k = 1, myused
	      vfield(k)=k
	   enddo
	endif
c
	if (eof) goto 90001				!file is empty
c
	eoinp=.false.					!end of input
c
c	============================================
c
cwhile	do while (.not.eoinp)
1098	continue
	   if (eoinp) goto 1099
c
	   errfnd=.false.				!no error found (yet)
c
	   if (erro.ne.0) then
	      if (chkinp) then				!care about errors ?
	         call tty_putc_(bell)			!ring
	         write (mssg,10010) recnum		!record
	         call errmsg_(d$rsub,erro,mssg,'?')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	         errfnd=.true.				!remember error found
	      else
c	         don't care, proceed
	      endif
	   endif
c
	   if (.not.errfnd) then
c
c	      See if record exists in data base
c
	      call find_(obase,recnum,alive,d$xbuf,erro)
	      if (erro.ne.0) then
	         call errclr_('I$REPL')			!clear error
	         erro=0
	         call tty_putc_(bell)			!ring
	         write (mssg,10008) recnum		!record not found
	         call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!display it
	         if (erro.ne.0) goto 900		!error, carry
	         nbad=nbad+1				!account
	         errfnd=.true.				!remember error found
	      else
	         do 1002 k = 1, myused
	            tmpf(k)=vfield(k)			!save VFIELD aside
1002	         continue
c
	         kkk=0					!index/counter
	         do 1003 l = 1, c$fn			!wanted fields
	            call outk_(fmap,l,kval)		!hard to read, field map
	            if (kval.gt.0) then			!ignore 0 (record#)
	               do 1004 k = 1, myused		!see if read from file
	                  f=tmpf(k)
	                  if (f.eq.kval) then
	                     kkk=kkk+1
	                     vfield(kkk)=f
	                     page(kkk)=lcpage(k)	!copy used/wanted fields
	                     blink(kkk)=vedbli
 	               endif
1004	            continue
	            endif
1003	         continue
	         myused=kkk
c
	         if (myused.le.0) then			!no field, warn
	            call tty_putc_(bell)		!ring
	            write (mssg,10004) recnum		!record not found
	            call i$mess_(0,d$cmdo,1,mssg,-1,erro)!display it
	            if (erro.ne.0) goto 900		!error, carry
	            errfnd=.true.			!remember error found
	         else
c
c	         load mnemonics, limits, etc for each record read from file
c
	            call vlimit_(obase,myused,vfield,vmssg,msiz,psiz,
     1                           kind,mini,maxi,pics,erro)
	            if (erro.eq.3.and.d$rsub.eq.'VLIMIT') then!prot. failure
c	               ignore it, field isn't in field map !!
	            else
	               if (erro.ne.0 ) goto 900		!error, carry
	            endif
c
c	            replace record
c
	            lstrec=recnum			!last replaced record
c
	            call lookup_(obase,recnum,alive,lcpage,erro)
	            if (erro.ne.0) then
	               call errclr_('I$REPL')		!clear error
	               erro=0
	               call tty_putc_(bell)		!ring
	               write (mssg,10009) recnum	!record with problems
	               call i$mess_(0,d$cmdo,1,mssg,-1,erro)!display it
	               if (erro.ne.0) goto 900		!error, carry
	               nbad=nbad+1			!account
	               errfnd=.true.			!remember error found
	            else
	               dorepl=.false.			!assume no need to edit
	               do 1005 k = 1, myused
	                  f=vfield(k)
	                  lim1=istrip_(page(k))
	                  lim2=istrip_(lcpage(f))
	                  if (lim1.ne.lim2) then
	                     dorepl=.true.		!don't forget it
	                     lcpage(f)=page(k)		!copy edited lines
	                  else
	                     if (lim1.gt.0) then
	                        if (page(k)(1:lim1).ne.lcpage(f)(1:lim1)) then
	                           dorepl=.true.	!don't forget it
	                           lcpage(f)=page(k)	!copy edited lines
	                        endif
	                     endif
	                  endif
1005	               continue
	            endif
	            badrec=.false.			!assume ok
	            if (dorepl) then			!edit record
	               if (chkinp) then
	                  erro=0			!VALIDATE input
	               else
	                  erro=-16381744		!don't validate
	               endif
	               call edit_(obase,recnum,lcpage,erro)
	               if (erro.ne.0.and.
     1                  (d$rsub.eq.'MODIFY'.or.		!KEY field errors
     1                   d$rsub.eq.'CHKLIN'.or.
     1                   d$rsub.eq.'CFLT'.or.
     1                   d$rsub.eq.'CF'        ) ) then	!CHKLIN/CFLT error
	                  call errmsg_(d$rsub,erro,mssg,'%')!get error message
	                  call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	                  if (erro.ne.0) goto 900	!error, return
	                  call tty_putc_(bell)		!ring
	                  write (mssg,10003) recnum	!tell replace not done
	                  call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	                  if (erro.ne.0) goto 900	!error, return
	                  call errclr_('I$REPL')	!clear error
	                  erro=0
	                  nbad=nbad+1			!account
	                  trunc=.false.			!ignore previous trunc
	                  badrec=.true.			!don't confuse him
	                  errfnd=.true.			!remember error found
	               else
	                  if (erro.ne.0) goto 900	!error, carry
	               endif
	            else
c	               ok, nothing to edit
	            endif
c
	            if (.not.badrec) then		!record ok
	               nrepl=nrepl+1
	               write (mssg,10001) recnum	!record replaced
	               call i$mess_(0,d$cmdo,0,mssg,-1,erro)!display it
	               if (erro.ne.0) goto 900		!error, carry
	            endif
c
	            if (trunc) then			!truncated
	               ntrunc=ntrunc+1
	               call tty_putc_(bell)		!ring
	               write (mssg,10002)		!trunc/round ...
	               call i$mess_(0,d$cmdo,0,mssg,-1,erro)!display it
	               if (erro.ne.0) goto 900		!error, carry
	            endif
c
	         endif
c
	      endif
c
	   endif
c
c	   If any error found, ask him if not yet
c
	   if (errfnd) then
	      if (errstp.and.askerr) then
	         askerr=.false.				!confirm only once
	         call i$ster_(errstp,erro)		!really ?
	      endif
	      if (errstp) goto 800			!stop on errors, inform
	      if (erro.ne.0) goto 900			!error, carry
	   endif
c
c	   get next record from file
c
101	   continue
c
	   trunc=.false.
	   if (idbform) then
	      ftrans=1				!field transfer always by field#
	      call f$idbf_(ichan,ftrans,obase,recnum,myused,vfield,
     1                     vmssg,lcpage,eof,trunc,erro)
	   else
	      call i$usz_(obase,usrsiz)			!record size
	      call f$isdf_(ichan,recnum,xbuf1,usrsiz,killed,garbage,eof,
	1                  hisrace,owname,aliename,totelem,linelem,erro)
	      if (erro.ne.0) goto 900			!error, carry
	      if (killed) goto 101			!killed, ignore
	      if (garbage) goto 101			!unrecoverable, ignore
	      call unflat_(obase,lcpage,xbuf1,erro)
	      myused=d$nfld(obase)
	      do k = 1, myused
	            vfield(k)=k
	      enddo
	   endif
c
	   if (.not.eof) then
	      filcnt=filcnt+1				!account record
	   else
	      eoinp=.true.				!flag all done
	   endif
c
	   goto 1098
c
1099	continue
cwhile	enddo
c
c	Inform
c	======
c
800	continue
c
	write (mssg,10005) nrepl			!records replaced
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)		!display it
	if (erro.ne.0) return				!error, return
c
	write (mssg,10006) ntrunc			!truncated/rounded
	call i$mess_(0,d$cmdo,0,mssg,-1,erro)		!display it
	if (erro.ne.0) return				!error, return
c
	write (mssg,10007) nbad				!rejected
	call i$mess_(0,d$cmdo,0,mssg,-1,erro)		!display it
	if (erro.ne.0) return				!error, return
c
	goto 900					!return
c
c	Return
c	======
c
900	continue
c
	if (obase.eq.c$base) then
	   if (lstrec.gt.0) then
	      c$rec=lstrec				!current record
	      c$fld=0
	      call i$scur_(c$base,c$rec,c$fld)		!set current
	   endif
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c
c	input file is empty
90001	continue
	erro=1
	d$edit=1
	goto 99000
c	internal error: bitmap empty
90002	continue
	erro=2
	goto 99000
c	internal error: replace TO nowhere
90003	continue
	erro=3
	goto 99000
c	internal error: replace FROM nowhere
90004	continue
	erro=4
	goto 99000
99000	continue
c
	call errset_('I$REPL',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:irepl.fmt'
c
	end
c
c
c
c
	subroutine I$RSEL_(bmap,always,wait,count,erro)
c	***********************************************
c
	implicit none
c
	integer bmap(*), count, erro
	logical always,wait
c
c	Description
c	===========
c
c	This procedure counts records selected in bitmap BMAP and informs
c	user.
c
c	If count = 0, just returns; otherwise, if count > LINMAX or
c	ALWAYS = .true.,  informs user and <waiting> message is
c	displayed at line 24, unless WAIT = .FALSE. .
c
c	ALWAYS is set to .true. if <waiting> message issued, .false. if
c	not.
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external ndigi_,istrip_
	integer ndigi_,istrip_,dig,rec,lim1
c
c	begin
c	=====
c
	call errclr_('I$RSEL')			!error init
	erro=0
c
	rec=0					!don't forget anybody...
	call bitcnt_(bmap,rec,count,erro)	!count records to display/list
	if (erro.ne.0) return			!error, carry
c
	mssg(1:)=' '
	if (count.le.0) then
	   write (mssg(2:),10001)		!no record selected
	   call i$mess_(0,d$cmdo,1,mssg,-1,erro)!inform user
	   if (erro.ne.0) return		!error, carry
	   always=.false.
	else
	   if ((count.gt.linmax.or.
     1          always).and.
     1         wait                ) then
	      lim1=2
c
	      dig=ndigi_(count)
	      call wrivar_(mssg(lim1:),count,dig,erro)
	      if (erro.ne.0) goto 90001		!write error
	      write (mssg(lim1+dig:),10002)
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)!inform user
	      if (erro.ne.0) return		!error, carry
	      call i$wlin_(24,erro)		!wait at line 24
	      if (erro.ne.0) return		!error, carry
	      always=.true.
	   else
	      always=.false.
	   endif
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	internal error: read/write error
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$RSEL',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:irsel.fmt'
c
	end
c
c
c
c
	subroutine i$save_(base,sear,sor,displ,comma,fname,cmmd,erro)
c	*************************************************************
c
	implicit none
c
	integer base,erro
	logical sear,sor,displ,comma
	character*(*) fname,cmmd
c
c	Description
c	===========
c
c	Save a context of base BASE in file FNAME:
c
c	Current search if		SEAR =  .true.
c	   "    sort if			SORT  = .true.
c	   "    display if		DISPL = .true.
c	The DBAG command buffer if	COMMA = .true.
c
c	CMMD is the DBAG command typed by the user.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbaga2.own'
c
	external istrip_
	integer istrip_
	integer sortio,recsiz,chn,sz,dl,k,val,lim,fmtsav
	character*3 newold
c
c	begin
c	=====
c
	call errclr_('I$SAVE')		!error init
	erro=0
c
	if (sear.or.sor) then
c	=====================
c
	if (bitsiz(base).lt.0.or.
     1      bitcan(base).eq.1    ) then
	   if (sear) then
	      goto 90001			!no current SEARCH, give up
	   else
	      goto 90007			!no current SORT, give up
	   endif
	endif
c
	call outk_(%val(bitpnt(base)),3,sortio)!sort file i/o ch.
	if (sortio.gt.0) then
c	  ok
	else
	   if (sor) then
	      goto 90005		!not sorted
	   else
c	      ok
	   endif
	endif
c
c	open output file and write header
c
	recsiz=132
	newold='NEW'
	call newc_(chn)
	if (chn.le.0) goto 90004
	call f$ohdr_(chn,base,fname,newold,recsiz,'SEARCH/SORT',
     1               cmmd,erro)
	if (erro.ne.0) then
	   if (d$itrv.eq.1) then	!interactive
	      call errmsg_('F$OHDR',erro,mssg,'%')
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      call errclr_('I$SAVE')		!clear error
	      erro=0
	      d$edit=1				!set edit mode
	      goto 900				!and return
	   else				!non-interactive
	      goto 900				!just return
	   endif
	endif
c
c	Save current search
c
	call bitmax_(%val(bitpnt(base)),sz,erro)
	if (erro.ne.0) goto 900
	do 1001 k=1,sz
	   call outk_(%val(bitpnt(base)),k,val)	!hard to read, bitmap
	   write(chn,'(i12)',err=90008)val
1001	continue
c
c	Save sort, if any
c
	if (sortio.gt.0) then
	   rewind(sortio)
10018	   continue
	      read (sortio,'(i9)',end=10019,err=90006) val
	      write (chn,'(i9)',err=90008) val
	      goto 10018
10019	   continue
	endif
c
	goto 900			!and return
c
	elseif (displ) then
c	===================
c
c	see if any display
c
	if (ds$def(base).eq.0) then
	   fmtsav=ds$fmt(base)		!save format first
	   call i$defd_(base,erro)
	   if (erro.ne.0) goto 90002
	   if (fmtsav.le.0) fmtsav=1
	   ds$fmt(base)=fmtsav		!restore format
	endif
c
c	open output file and write header
c
	recsiz=132
	newold='NEW'
	call newc_(chn)
	if (chn.le.0) goto 90004
	call f$ohdr_(chn,base,fname,newold,recsiz,'DISPLAY',
     1               cmmd,erro)
	if (erro.ne.0) then
	   if (d$itrv.eq.1) then	!interactive
	      call errmsg_('F$OHDR',erro,mssg,'%')
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      call errclr_('I$SAVE')		!clear error
	      erro=0
	      d$edit=1				!set edit mode
	      goto 900				!and return
	   else
	      goto 900				!just return
	   endif
	endif
c
	write(chn,10002,err=90008)ds$fmt(base)
c
	k=1					!field
	dl=1					!display line (temp = 1)
200	continue
	if (k.gt.d$nfld(base)+2.or.ds$fld(dl,k,base).eq.-2) goto 201
	write(chn,10001,err=90008)
     1        ds$fld(dl,k,base),
     1        ds$pos(dl,k,base),
     1        ds$siz(dl,k,base),
     1        ds$how(dl,k,base),
     1        ds$jus(dl,k,base)
	k=k+1
	goto 200
201	continue
c
	goto 900			!and return
c
	elseif (comma) then
c	===================
c
c	see if command buffer is empty
c
	if (d$cmdp.le.0) goto 90003
c
c	open output file and write header
c
	recsiz=d$cmds+20		!max command size + ...
	newold='NEW'
	call newc_(chn)
	if (chn.le.0) goto 90004
	call f$ohdr_(chn,base,fname,newold,recsiz,'COMMANDS',
     1               cmmd,erro)
	if (erro.ne.0) then
	   if (d$itrv.eq.1) then	!interactive
	      call errmsg_('F$OHDR',erro,mssg,'%')
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!fatal error
	      call errclr_('I$SAVE')		!clear error
	      erro=0
	      d$edit=1				!set edit mode
	      goto 900				!and return
	   else				!non-interactive
	      goto 900				!just return
	   endif
	endif
c
	do 1002 k = 1, d$cmmd
	   lim=istrip_(cmdbuf(k))
	   if (lim.le.0) goto 202		!end of command buffer
	   write (chn,'(a)',err=90008) cmdbuf(k)(1:lim)
1002	continue
202	continue
c
	goto 900			!and return
c
	endif
c	=====
c
	goto 900			!and return
c
c	Return
c	======
c
900	continue
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)
	   chn=0
	endif
c
	return
c
c	Warnings
c	--------
c
c	no current SEARCH
90001	continue
	erro=1
	goto 99000
c	problems setting current DISPLAY
90002	continue
	erro=2
	goto 99000
c	the command buffer is empty
90003	continue
	erro=3
	goto 99000
c	no more i/o channels
90004	continue
	erro=4
	goto 99000
c	current search isn't sorted
90005	continue
	erro=5
	goto 99000
c	problems reading temporary sort file
90006	continue
	erro=6
	goto 99000
c	no current sort
90007	continue
	erro=7
	goto 99000
c	problems writing output file
90008	continue
	d$rinf=fname			!tell him which file
	erro=8
	goto 99000
c
c	Set error and return
99000	continue
c
	call errset_('I$SAVE',erro)
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)
	   chn=0
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:isave.fmt'
c
	end
c
c
c
c
	subroutine I$SFTR_(input,obase,ifmap,ifsiz,dstmap,ftrans,erro)
c	**************************************************************
c
	implicit none
c
	integer input,obase,ifmap(*),ifsiz,dstmap(*),ftrans,erro
c
c	Description
c	===========
c
c	This procedure sets field transfer between databases (input > 0) or
c	between input file and output database (input <= 0).
c
c	FTRANS = 1	field transfer by field number
c	         2	field transfer by field name
c		 3	field transfer by user supplied field list
c
c	No-op if input is file and field transfer is by field name (name
c	matching will be done for each input file record...)
c
c	(called by A$PPEN when field transfer NOT by number)
c
c	begin
c	=====
c
	include 'own:dbag0.own'
c
	integer k,kk,l,idx
	logical eow,eos
	character*10 imne,omne
c
	call errclr_('I$SFTR')			!error init
	erro=0
c
	if (input.le.0.and.
     1      ftrans.eq.2   ) return		!no-op
c
	k=1
	eow=.false.				!init
c
	if     (ftrans.eq.1) then	!*** BY FIELD NUMBER
c
	   do 1001 kk = 1, ifsiz
	      if (ifmap(kk).gt.0) then
c
c	      CHECK input field k against output field l here !!!!!!!!!!!!!!!
c			(if input > 0 ...)
c
	         dstmap(k)=ifmap(kk)		!just copy field numbers...
	         k=k+1				!next field
	      endif
1001	   continue
c
	elseif (ftrans.eq.2) then	!*** BY FIELD NAME
c
	   ifsiz=0				!field map size
	   idx=1
	   do 1002 k = 1, d$nfld(input)		!input base fields
	      call zmne_(input,k,imne,erro)
	      if (erro.ne.0) return		!error, carry
	      call uc8to7_(imne)		!upper case it
	      eow=.false.
	      eos=.false.
	      l=1
cwhile	      do while (.not.eow.and..not.eos)
1098	      continue
	         if (eow.or.eos) goto 1099
c
	         if (l.gt.d$nfld(obase)) then
	            eow=.true.
	         else
	            call zmne_(obase,k,omne,erro)
	            if (erro.ne.0) return	!error, carry
	            call uc8to7_(omne)
	            if (imne.eq.omne) then
c
c	CHECK input field k against output field l here !!!!!!!!!!!!!!!
c
	               eos=.true.
	            else
	               l=l+1
	            endif
	         endif
c
	         goto 1098
1099	      continue
cwhile	      enddo
	      if (eos) then
	         ifmap(idx)=k			!input field
	         dstmap(idx)=l			!output field
	         ifsiz=idx			!field map size
	         idx=idx+1			!next one
	      endif
c
1002	   continue
c
	else				!*** BY FIELD LIST
c
c
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	type conflict detected in field transfer
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$SFTR',erro)
	return
c
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$MNDT_(base,fmap,fsiz,erro)
c	***************************************
c
	implicit none
c
	integer base,fmap(*),fsiz,erro
c
c	Description
c	===========
c
c	This procedure verifies that all mandatory fields of BASE without a
c	default value are referred to in field map FMAP.
c	(called by A$PPEN, whenever procedure append_ doesn't validate itself)
c
c	begin
c	=====
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	integer k,kk,pos1,pos2,ferr,b2,mast,mnd,kind
c
	call errclr_('I$MNDT')			!error init
	erro=0
c
	do 1002 k = 1, d$nfld(base)
	   ferr=k
	   call zmndt_(base,k,mnd,erro)
	   if (erro.ne.0) return		!error, carry
	   if (mnd.ne.0) then			!mandatory field
	      do 1001 kk = 1, fsiz
	         if (fmap(kk).eq.k) goto 1002	!in field map, check next field
1001	      continue
c
	      pos1=d$pos(k,base)
	      pos2=pos1+d$siz(k,base)-1
	      kind=d$type(k,base)
	      if (kind.eq.r$) then
	         if (d$dflt(base)(pos1:pos2).eq.rnulltxt) goto 90001	!no def.
	      else
	         if (istrip_(d$dflt(base)(pos1:pos2)).le.0) goto 90001	!no def.
	      endif
	   endif
c
1002	continue
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	mandatory field without default value and not in the field map
90001	continue
	d$rinf(1:4)='fld#'
	write (d$rinf(6:),fmt='(i3)',err=90031) ferr
90031	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$MNDT',erro)
	return
c
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$SOPN_(base,erro)
c	*****************************
c
	implicit none
c
	integer base,erro
c
c	Description
c	===========
c
c	This procedure displays 'base opened ...' message for base
c	(usually called after first base opening).
c	No-op in non-interactive program calling.
c
	external istrip_,ndigi_
	integer istrip_,ndigi_
	integer irace,pdim,psize,pdeci,okrec,klrec,pos,dig,l
	character*30 race
c
c	begin
c	=====
c
c	VAR
c	===
c
	include 'own:dbag0.own'
c
	if (d$itrv.eq.0) return			!no-op
c
	call errclr_('I$SOPN')			!error init
	erro=0
c
	call zrace_(base,race,irace,pdim,psize,pdeci,erro)
	if (erro.ne.0) return			!error, carry
c
	mssg(1:)=' '
c
	mssg(2:)=race				!creature
	pos=istrip_(mssg)+3
c
	mssg(pos:)=d$unam(base)			!user name
	pos=istrip_(mssg)+1
c
	mssg(pos:pos+2)=' ( '
	pos=pos+3
c
	l=istrip_(d$bfil(base))			!disk file
	if (l.le.0) l=1				!??..??
	mssg(pos:)=d$bfil(base)(1:l)
	pos=pos+l
c
	mssg(pos:pos+2)=' ) '
	pos=pos+2
c
	mssg(pos:pos+11)=', opened for '
	pos=pos+13
c
	if     (d$pid(base).eq.0) then		!usage
	   mssg(pos:pos+7)='NOUPDATE'
	   pos=pos+7
	else
	   mssg(pos:pos+5)='UPDATE'
	   pos=pos+5
	endif
c
	if (irace.ne.r$b) then			!not a regular base
	   pos=pos+1
	   mssg(pos:pos+15)=', owner base is '
	   mssg(pos+16:)=d$ownb(base)
c
	endif
c
	call i$mess_(0,d$cmdo,1,mssg,-1,erro)	!inform user
	if (erro.ne.0) return			!error, carry
c
	if (irace.eq.r$b) then			!if regular base
c
	   mssg(1:)=' '
c
	   call zrec2_(base,okrec,klrec,erro)	!alive, killed records
	   if (erro.ne.0) return		!error, carry
	   dig=ndigi_(okrec)			!alive
	   if (erro.ne.0) goto 90001		!write error
	   call wrivar_(mssg(2:2+dig),okrec,dig,erro)
	   if (erro.ne.0) goto 90001		!write error
	   pos=2+dig
	   mssg(pos:pos+17)=' alive record(s), '
	   pos=pos+18
c
	   dig=ndigi_(klrec)			!killed
	   if (erro.ne.0) goto 90001		!write error
	   call wrivar_(mssg(pos:pos+dig),klrec,dig,erro)
	   if (erro.ne.0) goto 90001		!write error
	   pos=pos+dig
	   mssg(pos:pos+17)=' killed record(s)'
	   pos=pos+18
c
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!inform user
	   if (erro.ne.0) return			!error, carry
c
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	internal error: read/write error
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$SOPN',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$SSCR_(erro)
c	***********************
c
	implicit none
c
	integer erro
c
c	Description
c	===========
c
c	This procedure (re)sets DBAG editor characteristics, according
c	to DBAG internal status.
c
c	begin
c	=====
c
c	VAR
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:vedit.own'
c
	call errclr_('I$SSCR')			!error init
	erro=0
c
	if (s$set(s$colo)) then			!ending character
	   vedend=ending
	else
	   vedend=' '
	endif
c
	if (s$set(s$padd)) then			!padding character
	   vedpad=paddin
	else
	   vedpad=' '
	endif
c
	if (s$set(s$bell)) then			!ringging
	   vedrng=char(7)
	else
	   vedrng=char(32)
	endif
c
	if (s$set(s$inte)) then			!reverse video
	   vedbli=2
	else
	   vedbli=0
	endif
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$STCM_(buf,erro)
c	***************************
c
	implicit none
c
	character*(*) buf
	integer erro
c
c	Description
c	===========
c
c	This procedure stores BUF into command buffer at next free position,
c	except if command = previous command.
c	If the command buffer is already full, stores it at the bottom.
c	No-op if attempting to store empty command or same command twice or
c	@level.
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer k
c
c	begin
c	=====
c
	call errclr_('I$STCM')			!error init
	erro=0
c
	if (istrip_(buf).le.0) return		!empty line, no-op
	if (at$lvl.gt.0) return			!@level, no-op
c
	if     (d$cmdp.lt.1) then
	   d$cmdp=1				!empty, save/replace at the top
	else
	   if (d$cmdp.gt.1) then
	      if (cmdbuf(d$cmdp-1).eq.buf) return	!same command, no-op
	   endif
	   if (d$cmdp.gt.d$cmmd) then
	      do 1001 k = 1, d$cmmd-1		!everybody up!
	         cmdbuf(k)(1:)=' '
	         cmdbuf(k)=cmdbuf(k+1)
1001	      continue
	      d$cmdp=d$cmmd			!save/replace it at the bottom
	   endif
	endif
	cmdbuf(d$cmdp)(1:)=' '			!save/replace command
	cmdbuf(d$cmdp)=buf			!...
	d$cmde=d$cmdp				!tell editor where is command
	d$cmdp=d$cmdp+1				!next command here
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
c
	subroutine i$tset_(width,broad,erro)
c	************************************
c
	implicit none
c
	integer width,erro
	logical broad
c
c	Description
c	===========
c
c	Sets terminal width to WIDTH (forced to 80 or 132) if not <0, echo,
c	nowrap, ansi, broadcast/nobroadcast and crt.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer lim1,mywid
	character*60 vmscmd
	logical fast
c
c	begin
c	=====
c
	call errclr_('I$TSET')
	erro=0
c
	if     (width.lt.0) then
	   mywid=-1
	elseif (width.gt.80) then
	   mywid=132
	else
	   mywid=80
	endif
c
	vmscmd(1:)=' '
	vmscmd='set term/nobroad/echo/nowrap/ansi_crt/dec_crt'
	if (broad) then
	   vmscmd(10:16)='broadca'
	endif
	if (mywid.gt.0) then
	   lim1=istrip_(vmscmd)+1
	   vmscmd(lim1:lim1+6)='/width='
	   write (vmscmd(lim1+7:),'(i3)') mywid
	   lim1=lim1+9
	endif
c
	fast=.true.
	call spawn_(vmscmd(1:lim1),fast,erro)	!set term, please
	if (erro.ne.0) goto 90001		!can't
c
	return
c
c	Error
c	=====
c
c	can't spawn command
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('I$TSET',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine I$XNOX_(buf,mark,who)
c	********************************
c
	implicit none
c
	character*(*) buf
	integer mark,who
c
c	Description
c	===========
c
c	Implements (RE)INDEX/NOINDEX commands:
c
c	*****	(RE)INDEX/NOINDEX  [DATABASE <database> ON FIELD <field>]
c
c	If INDEX, KWIC option allowed.
c
c	Specified database (current database if not specified) is indexed on
c	field if who = 1 (caller INDEX) or 2 (caller REINDEX) and de-indexed
c	if who = 3 (caller NOINDEX).
c
c	(called from I$NDEX and N$OIND modules).
c
c	If interactive usage and no field specified, indexing will be done,
c	upon confirmation, over ALL indexed fields.
c
c	Erro if INDEXES are SET OFF.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
	external istrip_
	integer istrip_
	integer base,update,mode,type,val,dec,lim,p1,p2,erro,interr,noerr
	real rval
	integer zf,zl,z,alive,k,size,bmsize,ndatab,nkwic,non,nfield,
	1	oldidx,akey,kind,ix
	integer irace,idim,isize,ideci,nnn,answr,f,kkk,kval,all,nfld,fmsz,fm,
	1	fmnesz,unamsz
	integer pmsz,pm,smsz,sm,mmsz,mm
	character*12 mybuf,myfnam,bname,fname
	character*30 race
	logical opn,fieldok,twice,prefix,fwrite,protfail,reset
	character*10 mymnem
c
c	begin
c	=====
c
	call errclr_('I$XNOX')			!error init
	erro=0
c
	if (.not.s$set(s$inde)) goto 90016	!sorry, no indexes now
c
	fmsz=0
	pmsz=0			!same for properties
	smsz=0			!same for series
	mmsz=0			!same for memos
c
	all=d$f+2		!max possible # fields + 2
c
	ndatab=0
	nkwic=0
	non=0
	nfield=0
	fname(1:)=' '
	opn=.false.
	reset=.true.		!reset field map
	nnn=0			!# of indexed/reindexed/de-indexed fields
c
c	Loop here to get next keyword
c	-----------------------------
c
1	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.0.and.
     1   	type.ne.1    ) then
	   goto 90002			!syntax error (neither identifier
					!              or eol)
	elseif (type.eq.0) then
	   goto 500			!eol, go complete/execute command
	endif
c
c	Got a keyword, check it
c	-----------------------
c
2	continue
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if     (keypos.eq.0) then
	   goto 90003			!syntax error
	elseif (keypos.eq.-1) then
	   goto 90004			!syntax error (ambiguous keyword)
	elseif (keypos.eq.-2) then
	   goto 90005			!syntax error (too few char.)
	elseif (keypos.eq.onky)  then
	   non=non+1			!count it
	   goto 50			!"eat" ON [FIELD] <field>
	elseif (keypos.eq.fielky)  then
	   nfield=nfield+1		!count it
	   goto 100			!"eat" FIELD <field>
	elseif (keypos.eq.dataky)  then
	   ndatab=ndatab+1		!count it
	   goto 200			!"eat" DATABASE <database>
	elseif (keypos.eq.kwicky) then
	   if (who.eq.1        )  then
	      nkwic=nkwic+1		!count it
	      goto 1			!go back for more
	   else
	      goto 90014		!unexpected keyword
	   endif
	else
	   goto 90014			!unexpected keyword
	endif
c
c	Here to "eat" ON FIELD <field>
c	------------------------------
c
50	continue
c
c	get [FIELD]/field name or %num
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
	if (type.ne.1) goto 101		!ON ...
c
c	Got a keyword, see if FIELDS
c	----------------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
c
	if (keypos.eq.fielky)  then
	   nfield=nfield+1		!count it
	   goto 100			!"eat" FIELD <field>
	else
	   goto 101			!ON ... = ON FIELD ...
	endif
c
c	Here to "eat" [FIELD ...]
c	-------------------------
c
100	continue
c
c	an extra token, please ...
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	endif
c
101	continue
c
	erro=0				!only my own error messages
	call fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mssg,
     1               mark,interr,erro)
	reset=.false.			!don't reset anymore
c
	if (erro.lt.0) then		!error=-1 means interr holds inwht err.
	   erro=interr
	   goto 90000
	endif
c
	if (erro.ne.0) goto 95000	!display others error, set edit mode,
c
	if (type.eq.0) then
	   goto 500			!eol, go complete/execute command
	else
	   if (type.eq.1) then
	      goto 2			!keyword, check it
	   else
	      goto 90002		!identifier or eol expected
	   endif
	endif
c
c	Here to "eat" [DATABASE...]
c	---------------------------
c
200	continue
c
	erro=0
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	if     (erro.ne.0) then
	   goto 90000			!syntax error (illegal character or
					!too many total digits)
	elseif (type.ne.1.and.
     1          type.ne.24    ) then
	   goto 90009			!syntax error (database name expected)
	endif
c
	size=p2-p1+1
	if (size.gt.9) then
	   size=9
	   if (d$itrv.eq.1) then		!interactive
	      write (mssg,10004) buf(p1:p1+size-1)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!truncated to ...
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
	bname(1:)=buf(p1:p1+size-1)		!store database name
	call uc_(bname)				!upper case it
c
	goto 1					!loop back for more (???)
c
c	Here to check/complete/execute (RE)INDEX/NOINDEX command
c	--------------------------------------------------------
c
500	continue
c
c	Check command
c	-------------
c
c	check duplicate requests in command
c
	if (non   .gt.1.or.
     1      nfield.gt.1.or.
     1      nkwic. gt.1.or.
     1      ndatab.gt.1   ) then
	   goto 90008				!duplicate requests
	endif
c
	if (non.eq.1) nfield=1
c
c	Ask for current base if none specified;
c	(re)open base for UPDATE if needed.
c	---------------------------------------
c
	if     (ndatab.gt.0) then
	   update=1					!update
	   mode=0					!usual mode
	   call open_(base,bname,update,mode,opn,erro)
	   if (erro.ne.0) then
	      if (d$itrv.eq.1) then			!interactive
	         call errmsg_(d$rsub,erro,mssg,'?')	!get message
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)	!display it
	         if (erro.eq.0) then
	            call errclr_('I$XNOX')		!clear error if ok
	            erro=0
	            d$edit=1				!and set edit mode
	         endif
	         goto 900				!return
	      else
	        goto 900				!return
	      endif
	   endif
	else
	   update=1					!update mode
	   mode=0					!usual mode
	   call i$buse_(base,update,mode,mybuf,erro)	!ask for current base
	   if (erro.ne.0) goto 900			!error, carry
	   if (base.eq.0) goto 900			!no current base, return
	endif
c
c	See if really a "base"
c
	call zrace_(base,race,irace,idim,isize,ideci,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	if (irace.ne.r$b) goto 90018		!only bases allowed
c
c	If REINDEX <ret> or NOINDEX <ret>, see if at least one index field
c
	if (nfield.le.0) then			!no FIELDS,
	   if (who.eq.2.or.			!and REINDEX
	1      who.eq.3    ) then		!or NOINDEX
	      do kkk = 1, d$nfld(base)
	         ix=d$idx(kkk,base)
	         if (ix.gt.0) goto 300		!got one ...
	      enddo
	      goto 90012			!no index field
300	      continue
	   endif
	endif
c
c	Complete FIELDS ...
c
c	default FIELDS if interactive
c
	if (nfield.le.0) then			!no FIELDS,
	   if (d$itrv.eq.1) then		!and interactive
	      nfld=d$nfld(base)
	      fwrite=.true.			!fields are to be updated
	      call i$fakf_(base,'ALL',nfld,
	1                  fwrite,protfail,erro)!"fake" FLDSYN (ALL fields)
	      if (erro.ne.0) goto 900		!error, carry
	   else
	      goto 90011			!non-interactive, sorry
	   endif
	endif
c
	fmsz=all
	call get_vm_(4*fmsz,fm,erro)		!ask for room
	if (erro.ne.0) goto 90016		!no memory!
c
	pmsz=all
	call get_vm_(4*pmsz,pm,erro)
	if (erro.ne.0) goto 90016
c
	smsz=all
	call get_vm_(4*smsz,sm,erro)
	if (erro.ne.0) goto 90016
c
	mmsz=all
	call get_vm_(4*mmsz,mm,erro)
	if (erro.ne.0) goto 90016
c
	fwrite=.true.				!fields are to be updated
	call fldsem_(base,%val(fm),%val(pm),%val(sm),%val(mm),
	1            prefix,twice,fwrite,protfail,erro)	!check/complete fields
c
	if (erro.ne.0) then
	   mark=0
	   goto 95000			!display others error, return any
					!memory space, set edit mode and return
	endif
c
	if (twice) goto 90006		!same field twice
c
	if (prefix) goto 90010		!"#" not allowed here
c
c	If fields specified:
c
c	- if KWIC seen, only character and non-KEY fields
c	- if NOINDEX, only non-KEY fields
c
c	(KWIC seen only if INDEX calling)
c
	if (nkwic.gt.0.or.			!KWIC seen
	1   who.eq.3      ) then		!NOINDEX calling
	   if (nfield.gt.0) then
	      do kkk = 1, c$fn
	         call outk_(%val(fm),kkk,f)	!hard to read, the field map...
	         kind=d$type(f,base)
	         if (nkwic.gt.0) then
	            if (kind.ne.c$) goto 90017	!KWIC a non-character field
	            ix=d$idx(f,base)
	            if (ix.eq.2) goto 90020	!KWIC a KEY field
	         endif
	         if (who.eq.3) then
	            ix=d$idx(f,base)
	            if (ix.le.0) goto 90013	!not indexed
	            if (ix.eq.2) goto 90019	!NOINDEX a KEY field
	         endif
	      enddo
	   endif
	endif
c
c	If REINDEX with a field list, check if all fields are index
c
	if (who.eq.2) then
	   if (nfield.gt.0) then
	      do kkk = 1, c$fn
	         call outk_(%val(fm),kkk,f)	!hard to read, the field map...
	         ix=d$idx(f,base)
	         if (ix.le.0) goto 90013	!not indexed
	      enddo
	   endif
	endif
c
c	>>>>>> Check/execute INDEX/REINDEX/NOINDEX command
c	--------------------------------------------------
c
600	continue
c
c	Inform user if first open
c
c	opn=.true. if first open of base
c
	if (opn) then
	   call i$sopn_(base,erro)
	   if (erro.ne.0) goto 900			!error, carry
	endif
c
c	Do work
c
	call zstart_(base,zf,erro)	!first record#
	if (erro.ne.0) goto 900		!error, carry
	call zend_(base,zl,erro)	!and last
	if (erro.ne.0) goto 900		!error, carry
	if (zf.gt.0) then		!non-empty base
	   z=zl-zf+1			!# of records
	else
	   z=0
	endif
c
	unamsz=istrip_(d$unam(base))	
	if (unamsz.le.0) unamsz=1
c
	do 1001 kkk = 1, c$fn
	   call outk_(%val(fm),kkk,f)		!hard to read, the field map...
	   if (f.le.0) goto 1001		!ignore if 0 (record#)
	   mymnem=d$fmne(f,base)
	   fmnesz=istrip_(mymnem)		!mnemonic size
	   if (fmnesz.le.0) fmnesz=1		!...
c
	   oldidx=d$idx(f,base)
	   if (erro.ne.0) goto 900		!error, carry
c
	   fieldok=.true.
c
	   if (nkwic.gt.0) then			!KWIC seen
	      kind=d$type(f,base)
	      if (kind.ne.c$) fieldok=.false.
	      ix=d$idx(f,base)
	      if (ix.eq.2) fieldok=.false.
	   endif
c
	   if (fieldok) then
c
	      if (who.eq.1) then			!INDEX calling
	         if (nfield.gt.0) then			!and a specified field
c	            ok, index that field
	         else					!all fields
c	            ok, index them all
	         endif
	      else					!REINDEX or NOINDEX
	         if (nfield.gt.0) then			!and a specified field
c	            ok,
	         else					!all fields
	            ix=d$idx(f,base)
	            if (ix.le.0) fieldok=.false.	!don't,not indexed
	            if (who.eq.3.and.
	1               ix.eq.2      ) fieldok=.false.	!don't,NOINDEX/KEY FIELD
	         endif
	      endif
c
	   endif
c
	   if (d$itrv.eq.1) then			!interactive
c
	      if (fieldok) then
c
700	         continue
c
	         if (nfield.le.0) then			!all fields, confirm !
	            if     (who.eq.1) then
	               if (nkwic.le.0) then
	                  if (oldidx.eq.2) then
	                     write (mssg,12007)		!INDEX KEY ?
	                  else
	                     write (mssg,10007)		!INDEX ?
	                  endif
	               else
	                  write (mssg,11007)		!INDEX (KWIC) ?
	               endif
	            elseif (who.eq.2) then
	               if (oldidx.ne.4) then
	                  if (oldidx.eq.2) then
	                     write (mssg,12008)		!REINDEX KEY ?
	                  else
	                     write (mssg,10008)		!REINDEX ?
	                  endif
	               else
	                  write (mssg,11008)		!REINDEX (KWIC) ?
	               endif
	            else
	               write (mssg,10009)		!NOINDEX ?
	            endif
	            write (mssg(istrip_(mssg)+1:),'(i3)') f!field #
	            write (mssg(istrip_(mssg)+1:),10010)mymnem(1:fmnesz)
	            write (mssg(istrip_(mssg)+1:),10011)!ok ?
	            call i$mess_(0,d$cmdo,1,mssg,0,erro)
	            if (erro.ne.0) goto 900		!error, carry
c
	            call i$yn_(answr,erro)		!accept y/n
	            if (erro.ne.0) then
	               call errmsg_(d$rsub,erro,mssg,'%')!get message
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	               if (erro.ne.0) goto 900		!error, carry
	               call errclr_('I$XNOX')		!clear error
	               erro=0
	               goto 700				!loop back
	            endif
c
	            if (answr.eq.1) then		!"Y", do it
	               fieldok=.true.
	            else
	               if (answr.eq.3) goto 900		!^Z, return
	               fieldok=.false.
	            endif
c
	         endif
c
	      endif
c
	      if (fieldok) then
c
	         if (nkwic.gt.0.or.		!INDEX KWIC or
	1            (who.eq.2.and.		!REINDEX old kwic indexed field
	1             oldidx.eq.4 ) ) then
	            akey=2			!KWIC index
	         else
	            akey=0			!normal ?
	            if (oldidx.eq.2) then
	               akey=1			!no, field is keyed
	            endif
	         endif
c
	         if (who.eq.1.or.who.eq.2) then		!INDEX/REINDEX calling
c
	            if (d$itrv.eq.1) then		!interactive
	               if (z.gt.100.or.			!lots of records
	1                  nkwic.gt.0.or.		!INDEX KWIC
	1                  (who.eq.2.and.	!REINDEX old kwic indexed field
	1                   oldidx.eq.4 ) ) then	!it might take long...
	                  if (who.eq.1) then
	                     if (nkwic.le.0) then	!INDEX
	                        if (oldidx.eq.2) then	!KEY
	                           write (mssg,12001) 
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        else
	                           write (mssg,10001) 
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        endif
	                     else			!INDEX KWIC
	                        write (mssg,11001) 
     1                          d$unam(base)(1:unamsz),
     1                          mymnem(1:fmnesz)
	                     endif
	                  else
	                     if (oldidx.ne.4) then
	                        if (oldidx.eq.2) then
                                   write (mssg,12005) 	!REINDEX KEY
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        else
                                   write (mssg,10005) 	!REINDEX
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        endif
	                     else
                                write (mssg,11005) 	!REINDEX (KWIC)
     1                          d$unam(base)(1:unamsz),
     1                          mymnem(1:fmnesz)
	                     endif
	                  endif
	               else				!not that long...
	                  if (who.eq.1) then
	                     if (nkwic.le.0) then	!INDEX
	                        if (oldidx.eq.2) then	!KEY
	                           write (mssg,12003)
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        else
	                           write (mssg,10003)
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        endif
	                     else			!INDEX (KWIC)
	                        write (mssg,11003)
     1                          d$unam(base)(1:unamsz),
     1                          mymnem(1:fmnesz)
	                     endif
	                  else
	                     if (oldidx.ne.4) then
	                        if (oldidx.eq.2) then
	                           write (mssg,12006)	!REINDEX KEY
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        else
	                           write (mssg,10006)	!REINDEX
     1                             d$unam(base)(1:unamsz),
     1                             mymnem(1:fmnesz)
	                        endif
	                     else
	                        write (mssg,11006)	!REINDEX (KWIC)
     1                          d$unam(base)(1:unamsz),
     1                          mymnem(1:fmnesz)
	                     endif
	                  endif
	               endif
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!be nice...
	               if (erro.ne.0) goto 900		!error, carry
	            endif
c
	            call noindx_(base,f,akey,erro)	!de-index first
	            if (erro.ne.0) then
	               call errclr_('I$XNOX')		!clear error
	               erro=0
	            endif
c
	            call indx_(base,f,akey,erro)	!index now
	            if (erro.ne.0) goto 900		!error, carry
c
	            nnn=nnn+1				!account
c
	         else					!NOINDEX calling
c
	            if (d$itrv.eq.1) then		!interactive
c
	               write (mssg,10002) mymnem(1:fmnesz),
     1                                    d$unam(base)(1:unamsz)
	               call i$mess_(0,d$cmdo,-1,mssg,-1,erro)!be nice...
	               if (erro.ne.0) goto 900		!error, carry
	            endif
c
	            call noindx_(base,f,akey,erro)	!call de-index routine
	            if (erro.ne.0) then
	               call errclr_('I$XNOX')		!clear error
	               erro=0				!ignore error
	            endif
	            nnn=nnn+1				!account
	         endif
	      endif
c
780	   continue
	   endif
c
1001	continue
c
c	Inform user
c	-----------
c
	if (d$itrv.eq.1) then			!interactive
	   if     (nnn.gt.1) then		!tell him how many
	      if     (who.eq.1) then
	         if (nkwic.le.0) then
	            write (mssg,10012) nnn
	         else
	            write (mssg,11012) nnn
	         endif
	      elseif (who.eq.2) then
	         write (mssg,10013) nnn
	      else
	         write (mssg,10014) nnn
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   elseif (nnn.le.0) then		!no field
	      if     (who.eq.1) then
	         if (nkwic.le.0) then
	            write (mssg,10015)
	         else
	            write (mssg,11015)
	         endif
	      elseif (who.eq.2) then
	         write (mssg,10016)
	      else
	         write (mssg,10017)
	      endif
	      call i$mess_(0,d$cmdo,1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!error, carry
	   endif
	endif
c
c	Return
c	======
c
900	continue
c
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90007
	endif
c	illegal character
90001	continue
	mark=p1
	erro=1
	goto 99000			!display error and return properly
c	identifier or eol expected
90002	continue
	mark=p1
	erro=2
	goto 99000			!display error and return properly
c	unknown keyword
90003	continue
	mark=p1
	erro=3
	goto 99000			!display error and return properly
c	ambiguous keyword
90004	continue
	mark=p1
	erro=4
	goto 99000			!display error and return properly
c	too few characters in keyword
90005	continue
	mark=p1
	erro=5
	goto 99000			!display error and return properly
c	same field twice if field list
90006	continue
	erro=6
	goto 99000			!display error and return properly
c	too many digits
90007	continue
	mark=p1
	erro=7
	goto 99000			!display error and return properly
c	duplicate requests on command (syntax error)
90008	continue
	erro=8
	goto 99000			!display error and return properly
c	database name expected
90009	continue
	erro=9
	goto 99000			!display error and return properly
c	# in field list
90010	continue
	erro=10
	goto 99000			!display error and return properly
c	non-interactive usage, specify "ON FIELDS ..." phrase
90011	continue
	erro=11
	goto 99000			!display error and return properly
c	Data base has no index field
90012	continue
	erro=12
	goto 99000			!display error and return properly
c	field isn't indexed
90013	continue
	d$rinf(1:5)='base '		!tel him base and field
	d$rinf(6:)=d$unam(base)
	lim=istrip_(d$rinf)+1
	d$rinf(lim:lim+6)=', fld# '
	write (d$rinf(lim+7:),fmt='(i3)',err=90033) f
90033	continue
	mark=0
	erro=13
	goto 99000			!display error and return properly
c	unuexpected keyword
90014	continue
	mark=p1
	erro=14
	goto 99000			!display error and return properly
c	*** obsolete *** FIELD keyword expected after ON
90015	continue
	mark=p1
	erro=15
	goto 99000			!display error and return properly
c	INDEXES are SET OFF
90016	continue
	erro=16
	goto 99000			!display error and return properly
c	KWIC a non-character field
90017	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'	!and field
	write (d$rinf(lim+7:),fmt='(i3)',err=90077) f
90077	continue
	erro=17
	goto 99000			!display error and return properly
c	Not a common "base"
90018	continue
	d$rinf(1:)=race
	lim=istrip_(d$rinf)+2
	d$rinf(lim:)=d$unam(base)	!tell him witch "thing"
	erro=18
	goto 99000			!display error and return properly
c	NOINDEX a KEY field
90019	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'	!and field
	write (d$rinf(lim+7:),fmt='(i3)',err=90099) f
90099	continue
	erro=19
	goto 99000			!display error and return properly
c	KWIC a KEY field
90020	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'	!and field
	write (d$rinf(lim+7:),fmt='(i3)',err=90022) f
90022	continue
	erro=20
	goto 99000			!display error and return properly
c
c	Display error message (?...) and return
c	=======================================
99000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_('I$XNOX',erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	   d$edit=1				!set edit mode
	else
	   call errset_('I$XNOX',erro)		!set global error
	endif
c
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
c
	return
c
c	Display others error message (?...) and return
c	==============================================
95000	continue
c
	if (d$itrv.eq.1) then			!interactive
	   call errmsg_(d$rsub,erro,mssg,'?')	!get message
	   call i$mess_(mark,d$cmdo,-1,mssg,-1,erro)
	endif
c
	call free_vm_(4*fmsz,fm,noerr)
	call free_vm_(4*pmsz,pm,noerr)
	call free_vm_(4*smsz,sm,noerr)
	call free_vm_(4*mmsz,mm,noerr)
c
	return
c
c	Formats
c	=======
c
	include 'fmt:ixnox.fmt'
c
	end
c
c
c
c
	subroutine I$YN_(yn,erro)
c	*************************
c
	implicit none
c
	integer yn,erro
c
c	Description
c	===========
c
c	Accepts answer from terminal and returns YN = 1 (if 'y' or 'Y'),
c	2 (if 'n' or 'N') 3 (^Z), 4 (comment line ...), 5 (all other answers).
c	Error message is displayed if truncation occured.
c
c	This procedure should only be called after a promting.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	character*4 ans
	integer lim
	logical trunc
c
c	begin
c	=====
c
	call errclr_('I$YN')			!error init
	erro=0
c
234	continue
	erro=0					!only local messages...
	ans(1:)=' '				!...
	call inline_(d$cmdi,ans,lim,cmcont,trunc,erro)	!get answer
	if (erro.ne.0) return			!error, carry
	if (istrip_(ans).gt.0) then
	   call i$mess_(0,0,-1,ans,-1,erro)
	   if (erro.ne.0) return		!error, carry
	endif
c
	if (trunc) then				!line too long...
	   if (d$itrv.eq.1) then
	      write (mssg,10001)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
	endif
c
	if (lim.lt.0) then			!^Z or comment line
	   if (lim.eq.-1) then
	      goto 103				!^Z
	   else
	      goto 104				!comment line
	   endif
	endif
c
	if (ans.eq.'y'.or.
     1      ans.eq.'Y'   ) goto 101		!answer = Y
c
	if (ans.eq.'n'.or.
     1      ans.eq.'N'   ) goto 102		!answer = N
c
	goto 105				!'???'
c
101	continue
	yn=1					!'y' or 'Y'
	return
c
102	continue
	yn=2
	return					!'n' or 'N'
c
103	continue
	yn=3					!^Z
	return
c
104	continue
	yn=4					!comment line
	return
c
105	continue
	yn=5					!all other cases
	return
c
c	Formats
c	=======
c
	include 'fmt:iyn.fmt'
c
	end
c
c
c
c
	subroutine i$ster_(errstp,erro)
c	*******************************
c
	implicit none
c
	logical errstp
	integer erro
c
c	Description
c	===========
c
c	Asks user if really want to stop on error. If yes, returns ERRSTP
c	= .true.
c	No-op if non-interactive usage.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer answr
c
c	begin
c	=====
c
	call errclr_('I$STER')			!error init
	erro=0
c
	errstp=.false.				!assume "n"
c
	if (d$itrv.ne.1) return			!non-interactive, return
c
100	continue
c
	write (mssg(1:),10001)			!stop on errors ? (y/n)
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
c
	call i$yn_(answr,erro)			!accept y/n
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, return
	   call errclr_('I$STER')		!clear error
	   erro=0
	   goto 100				!loop back
	endif
c
	if (answr.ne.1.and.
	1   answr.ne.2     ) goto 100		!"y" or "n"
c
	if (answr.eq.1) then			!"y"
	   errstp=.true.
	endif
c
	return
c
	include 'fmt:ister.fmt'
c
	end
c
c
c
c
	subroutine i$odb_(base,berr,ferr,refer,erro)
c	********************************************
c
	implicit none
c
	integer base,berr,ferr,erro
	logical refer
c
c	Description
c	===========
c
c	If BASE is used as o.d.b. by another base, return REFER = .true. and
c	BERR/FERR = "offending" base and field.
c
c	No-op if non-interactive usage.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	integer b2
c
c	begin
c	=====
c
	call errclr_('I$ODB')			!error init
	erro=0
c
	refer=.false.
c
	if (d$itrv.ne.1) return
c
	do berr = 1, d$b
	   if (d$base(berr).gt.0) then		!base is open
	      if (berr.ne.base) then
	         do ferr = 1, d$nfld(berr)	!see if my base is used as o.d.b
	            b2=d$dbio(ferr,berr)	!base channel
	            if (b2.gt.0) then
	               if (b2.eq.base) then
	                  refer=.true.
	                  return		!got one
	               endif	   
	            endif
	         enddo
	      endif
	   endif
	enddo
c
	return
c
	end
c
c
c
c
	subroutine I$ALIE_(base,aliename,alientype)
c	*******************************************
c
	implicit none
c
	integer base,alientype
	character*(*) aliename
c
c	Description
c	===========
c
c	This procedure adds alien ALIENAME, type ALIENTYPE to BASE structure.
c	Stops if alien doesn't fit.
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer f,pos1,pos2
c
cdon't!!!!!	call errclr_('I$ALIE')
c
c
	   f=d$nfld(base)			!current # of fields
	   if (f.le.0) then
	      pos1=2				!first position
	   else
	      pos1=d$pos(f,base)+d$siz(f,base)	!current position
	   endif
c
	   f=f+1				!next "field"
	   if (f.gt.d$f) goto 9999		!no room !!!
c
	   d$fmne(f,base)(1:)=' '
	   d$fmne(f,base)=aliename		!store mnemonic
	   d$fnam(f,base)(1:)=' '
	   d$fnam(f,base)=aliename		!file name for field
c
	   d$type(f,base)=alientype		!field type
	   d$siz(f,base)=10			!size
	   d$pos(f,base)=pos1			!position
c
	   d$mast(f,base)=0			!master field
	   d$see(f,base)=0			!see field
	   d$idx(f,base)=0			!field is NOT indexed, NOR key
	   d$deci(f,base)=0			!# of decimal places
	   d$oblg(f,base)=0			!field is not mandatory
	   d$dbio(f,base)=0			!other base channel
c
	   pos1=d$pos(f,base)+d$siz(f,base)	!next position
c
	   d$nfld(base)=f
c
	goto 900				!return
c
c	Return
c
900	continue
c
	return					!return
c
c	no room
9999	continue
c
	call errmsg_('I$ALIE',1,mssg,'?')		!get message
	call errdpl_(mssg,d$cmdo)			!system message
	if (d$alte.ne.0.and.s$set(s$alte)) then
	   call errdpl_(mssg,d$alte)			!alt file also
	endif
	call exit					!just exit from DBAG
c
c	Formats
c	-------
c
	end
c
c
c
c
	subroutine I$CRCR_(base,alien,bname,buf,erro)
c	*********************************************
c
	implicit none
c
	integer base,alien,erro
	character*(*) bname,buf
c
c	Description
c	===========
c
c	Implements the CREATE command for ALIEN creature (properties, ...)
c	in line mode, adding them to the BASE memory context.
c
c	(called by module C$REAT)
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	integer type,p1,p2,val,dec,lim
	real rval
	integer fidx,kkk,al,f,l,k,pos1,pos2,ppnum,update,mode,answr,bmsize
	character*10 alnam,fmnem,mymnem
	logical trunc,newopn
c
	character*30 curralien
	integer aliensz
c
c	begin
c	=====
c
	call errclr_('I$CRCR')			!clear errors
	erro=0
c
	curralien(1:)=' '
	if     (alien.eq.p$) then
	   curralien='property'
	elseif (alien.eq.s$) then
	   curralien='series'
	elseif (alien.eq.mm$) then
	   curralien='"memo"'
	else
	   goto 90001			!????
	endif
	aliensz=istrip_(curralien)
c
	d$pdim(base)=1				!dimension = 1
	d$psiz(base)=0				!size of elements
	d$pdec(base)=0				!decimal places
c
10	continue
	write (mssg,10002) curralien(1:aliensz)	!alien ?
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) return			!error, carry
	call i$yn_(answr,erro)			!accept y/n
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) return		!error, carry
	   call errclr_('I$CRCR')		!clear error
	   erro=0
	   goto 10				!loop back
	endif
c
	if (answr.eq.3.or.answr.eq.4) goto 10	!^Z, comment line
c
	if (answr.eq.1) then
c	   "Y"
c
20	   continue
c
	   write (mssg,10003)			!how many aliens ?
	   call i$mess_(0,d$cmdo,1,mssg,0,erro)
	   if (erro.ne.0) return		!error, carry
c
	   call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!fatal error, carry
	      call errclr_('I$CRCR')		!clear error
	      erro=0
	      goto 20				!loop back
	   endif
	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
c
	   read (buf,*,err=20) ppnum
	   if (ppnum.lt.0) goto 20
c
	else
	   ppnum=0				!no alien
	endif
c
	do k = 1, ppnum
c
30	   continue
	   write (mssg,10004) curralien(1:aliensz),k!alien name
	   call i$mess_(0,d$cmdo,1,mssg,0,erro)
	   if (erro.ne.0) return		!error, carry
c
	   call inline_(d$cmdi,buf,lim,cmcont,trunc,erro)
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')!get message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!fatal error, carry
	      call errclr_('I$CRCR')		!clear error
	      erro=0
	      goto 30				!loop back
	   endif
	   call i$mess_(0,0,-1,buf,-1,erro)
	   if (erro.ne.0) return
c
c	   get alien name
c
	   erro=0
	   call rstok_(buf,1,erro)		!init scanning of buf
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
c
	   if     (erro.ne.0) then
	      write (mssg,10005)		!syntax error
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30				!loop
	   elseif (type.ne.1.and.type.ne.24) then
	      write (mssg,10006)		!bad name
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30				!loop
	   endif
c
	   l=p2-p1+1
	   if (l.gt.cm$l1) then
	      l=cm$l1
	      do 1001 kkk=cm$l1+1,l
	            buf(kkk:kkk)=' '
1001	      continue
	      write (mssg,10007) buf(p1:p1+l-1)!truncation
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	   endif
c
	   fmnem(1:)=' '
	   fmnem=buf(p1:p1+l-1)
c
	   mymnem(1:)=' '
	   mymnem=fmnem
	   call uc_(mymnem)
	   if (mymnem.eq.bname) then
	      write (mssg,10011)		!can't be the same
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30
	   endif
c
c	   see if line is clean
c
	   erro=0
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if (type.ne.0) then
	      write (mssg,10012) curralien(1:aliensz)!eol expected
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30
	   endif
c
c	   check name (uniqueness)
c
	   f=-1
	   call chkmne_(fmnem,base,f,fidx,erro)
	   if (erro.ne.0) then
	      call errmsg_(d$rsub,erro,mssg,'%')!get error message
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30
	   endif
c
	   if (fidx.gt.0) then
	      write (mssg,10008)		!already exists
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30
	   endif
c
	   update=-1				!open/read...
	   mode=0				!usual mode
	   alnam(1:)=' '
	   alnam=fmnem
	   call open_(al,alnam,update,mode,newopn,erro)
	   if (erro.eq.0) then
	      write (mssg,10010)		!already exists
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) return		!error, carry
	      goto 30
	   else
	      if ((d$rsub.eq.'OPNBAS').and.
     1             erro.eq.3              ) then!ok, no such base
	         call errclr_('I$CRCR')		!clear error
	         erro=0
	      else
	         goto 900			!error, carry
	      endif
	   endif
c
	   call i$alie_(base,fmnem,alien)	!add alien to base structure
c
	enddo
c
100	continue
c
c
c	Return
c	------
c
900	continue
c
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c	??? unknown creature
90001	continue
	erro=1
	goto 99000
c
c	Set error and return
c	====================
99000	continue
	call errset_('I$CRCR',erro)
	return					!return
c
c	Formats
c	=======
c
	include 'fmt:icrcr.fmt'
c
	end
c
c
c
c
	subroutine I$EDPP_(base,prop,recnum,oldprop,function,
	1                  line1,erro)
c	**********************************************************
c
	implicit none
c
	integer base,prop,recnum,line1,erro
	logical oldprop
	integer function
c
c	Description
c	===========
c
c	Edit, append or display (FUNCTION = 1, 2 or 3) property PROP owned by
c	record# RECNUM. If OLDPROP = .true., the property may
c	exist already, if .false. it can't.
c
c	Use screen from LINE1.
c
c	If BASE   .le. 0, ask user for owner base.
c	If RECNUM .le. 0, ask user for owner base record#.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external istrip_,ndigi_,spfchl_,tty_putc_,tty_getc_,tty_echo_
	integer istrip_,ndigi_,tty_putc_,tty_getc_,tty_echo_
c
	integer mode,start,size,sizmax,topscr,margin,edtlin,ttychr,
     1		ttypad,lx,cx,term,used,status,dig,from,propsz,psz
	integer k,f,l,quit,alive,mnd,lim,elem,b2,mast,tmp,first,last,irec
	character*(vlong) lcpage(psiz),lcvmsg(psiz)
	integer vfield(psiz),vftype(psiz)
	character*1 hlpmsg(psiz)
	logical dohlp,doupdate,killelem,eoedit,eoinp,vnext,vnoth,vskip,more
	character*1 bell
	real wuser
	logical pexist,defdon(mxprp),dokill,doinsert,inselem,askrec,trunc
	logical numok
	integer type,dec,p1,p2,linpag,myused,pgslice/10/
	real rval
	character*30 mybuf
	logical edit,append,display,shrest
c
c	begin
c	=====
c
	call errclr_('I$EDPP')			!error init
	erro=0
c
	if (us$bat) goto 90001			!batch user
c
	bell=char(7)
c
	first=d$u1st(prop)			!first data field
	last=first+d$udnf(prop)-1		!last data field
c
	edit=.false.
	append=.false.
	display=.false.
	if     (function.eq.1) then
	   edit=.true.
	elseif (function.eq.2) then
	   append=.true.
	else
	   display=.true.
	endif
c
	askrec=.false.
c
	if (base.le.0) then
cxxx
	endif
c
	if (recnum.le.0) then
	   askrec=.true.			!ask for record#
	   call i$scur_(c$base,c$rec,0)		!show current
	   call erase_page_(line1,1)		!clean screen
	endif
c
	psz=istrip_(d$unam(prop))
c
c	Init editing
c	------------
c
	if (.not.display) then
	   do k = 1, mxprp
	      defdon(k)=.false.			!no defaults done (yet)
	   enddo
	endif
c
c	Set user fields and load limits and mnemonics
c	---------------------------------------------
c
	used=0					!# of fields
	do 1001 k = first,last
	   if (d$type(k,prop).le.ftusr$) then
	      used=used+1			!# of fields
	      vfield(used)=k			!this field
	   endif
1001	continue
c
	call vlimit_(prop,used,vfield,lcvmsg,msiz,psiz,
     1               kind,mini,maxi,pics,erro)
c
	if (.not.askrec) goto 2			!don't ...
c
c	Loop here if asking for record#
c	-------------------------------
c
1	continue
c
	if (display) then
	    call vset3_(line1,edtlin)		!scroll
	endif
c
	write (mssg,10010) d$unam(prop)(1:psz)	!prompt for record #
	call i$mess_(0,d$cmdo,1,mssg,0,erro)
	if (erro.ne.0) goto 900			!fatal error, carry
c
	erro=0
	call inline_(d$cmdi,mybuf,lim,cmcont,trunc,erro)
	if (erro.ne.0) then
	   call errmsg_(d$rsub,erro,mssg,'%')	!get message
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!fatal error, carry
	   goto 1				!loop back
	endif
	call i$mess_(0,0,-1,mybuf,-1,erro)
	if (erro.ne.0) goto 900			!fatal error, carry
c
	if (trunc) then				!line too long, truncated
	   write (mssg,10013)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!error, carry
	endif
c
	if     (lim.eq.0) then
	   goto 900				!return
	elseif (lim.eq.-1) then
	   goto 1				!^Z
	elseif (lim.eq.-2) then
	   goto 1				!comment line, go back
	endif
c
	erro=0
	call rstok_(mybuf,1,erro)
	call intok_(type,recnum,dec,rval,mybuf,lim,p1,p2,mssg,erro)
c
	numok=.true.
c
	if (erro.ne.0.or.
	1   type.ne.2    ) then
	   numok=.false.
	else
	   call ex3in_(base,recnum,irec,erro)	!just check recnum
	   if (erro.ne.0) then
	      numok=.false.
	   endif
	endif
c
	if (.not.numok) then			!wrong rec#
	   write (mssg,10012)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!fatal error, carry
	   goto 1				!loop back
	endif
c
c	See if record exists
c
	alive=0
	call find_(base,recnum,alive,d$xbuf,erro)
	if (erro.ne.0) then			!not found
	   call errclr_('I$EDPP')		!clear error
	   erro=0
	   write (mssg,10011)
	   call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	   if (erro.ne.0) goto 900		!fatal error, carry
	   goto 1				!loop back
	endif
c
2	continue
c
c	See if property exists
c
	call inqsw_(prop,recnum,pexist,erro)
	if (erro.ne.0) goto 900			!error, carry
c
	if (.not.pexist) then
	   if (askrec.and.
	1      display    ) then
	      write (mssg,10016)
	      call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      if (erro.ne.0) goto 900		!fatal error, carry
	      goto 1				!loop back
	   endif
	endif
c
c	Set new current base/record
c
	if (recnum.ne.c$rec.or.
     1      base.ne.c$base    ) then
	   call i$sprv_(c$base,c$rec,c$fld)	!save current
	   call i$scur_(base,recnum,0)		!set new current
	endif
c
	call erase_page_(line1,1)		!clean screen
c
	vnext=.true.				!assume next elem
	doupdate=.true.				!assume put/replace property if
						!editing/appending
c
	propsz=0				!property size
c
c	Get property if it exists
c
	if (pexist) then
	   more=.false.
111	   continue
	   call getsw_(prop,recnum,lcpage,more,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   if (more) then
	      propsz=propsz+1
	      if (propsz.gt.mxprp) goto 90003	!doesn't fit
	      call xflat_(prop,lcpage,prparray(propsz),erro)
	      if (erro.ne.0) goto 900		!error, carry
	      defdon(propsz)=.true.		!no defaults here
	      goto 111				!loop for more
	   endif
	endif
c
	do k = propsz+1, mxprp
	   prparray(k)(1:)=' '			!clean rest of it
	enddo
c
	if (edit.or.display) then
	   elem=1				!1st elem to start
	else
	   elem=propsz+1			!append, start at next new elem
	endif
	if (elem.gt.mxprp) elem=mxprp		!make sure inside range
c
	killelem=.false.			!not to kill
	inselem=.false.				!...
c
	eoinp=.false.				!end of input
c
c	Set field characteristics
c
	do l = 1, used				!copy wanted fields
	   f=vfield(l)
	   vmssg(l)=lcvmsg(l)
	   blink(l)=vedbli
	   call zmndt_(prop,f,mnd,erro)
	   if (erro.ne.0) goto 900		!error, carry
	   if (mnd.eq.0) then
	      vftype(l)=vfrw$		!read/write
	   else
	      vftype(l)=vfrwm$		!read/write/mandatory
	   endif
	enddo
c
	lx=1					!start at line 1
	cx=1					!col. 1
c
c	============================================
c
cwhile	do while (.not.eoinp)
1098	continue
	   if (eoinp) goto 1099
c
	   eoedit=.false.
	   vnoth=.false.
	   vskip=.false.
c
c	   Set PAGE correctly before calling editor
c	   ----------------------------------------
c
	   if (elem.le.propsz) then		!data from base/editor
c
	      if     (killelem) then
	         do k = elem, propsz - 1
	            prparray(k)=prparray(k+1)	!pop them up
	         enddo
	         prparray(propsz)(1:)=' '	!clean last one
	         propsz=propsz-1		!forget it
	         elem=elem-1			!go back
	         if (elem.le.0) elem=1
	         lx=1				!first line
	         cx=1				!and col.
	      elseif (inselem) then
	         do k = elem, propsz + 1
	            prparray(k+1)=prparray(k)	!push them down
	         enddo
	         prparray(elem)(1:)=' '		!clean elem.
	         propsz=propsz+1		!don't forget last one
	         lx=1				!first line
	         cx=1				!and col.
	      endif
c
	   endif
c
	   if (elem.le.propsz) then		!data from base/editor
c
	      call xunfla_(prop,lcpage,prparray(elem),erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	      do 1005 l = 1, used		!copy wanted fields
	         f=vfield(l)
	         page(l)=lcpage(f)
1005	      continue
c
	   else					!default values if not yet
c
	      if (.not.defdon(elem)) then
	         defdon(elem)=.true.
	         do k = first,last
	            b2=d$dbio(k,prop)
	            mast=d$mast(k,prop)
	            if (b2.gt.0.and.mast.gt.0) then
	               if (d$type(mast,b2).eq.r8$) then	!no def. for double pr.
	                  page(k)(1:)=' '
	               else
	                  call cunflt_(b2,page(k),tmp,mast,d$dflt(b2),
	1                              erro)
	                  if (erro.ne.0) goto 900	!error, carry
	               endif
	            else
	               if (d$type(k,prop).eq.r8$) then	!no def. for double pr.
	                  page(k)(1:)=' '
	               else
	                  call cunflt_(prop,page(k),tmp,k,d$dflt(prop),
	1                              erro)
	                  if (erro.ne.0) goto 900	!error, carry
	               endif
	            endif
	         enddo
	      endif
c
	   endif
c
c	   call editor and get next elem to edit if that's the case
c	   --------------------------------------------------------
c
cwhile	   do while (.not.eoedit)
1096	   continue
	      if (eoedit) goto 1097
c
	         call vset2_(line1+1)		!clean screen
c
c	         tell him (her) all about
c
	         write (mssg(1:),10003)			!elem.#
	         dig=ndigi_(elem)
	         lim=istrip_(mssg)+2
	         call wrivar_(mssg(lim:),elem,dig,erro)
	         if (erro.ne.0) goto 90002		!write error
	         write (mssg(istrip_(mssg)+2:),10004)	!of property
	1               d$unam(prop)(1:psz)
	         dig=ndigi_(propsz)
	         lim=istrip_(mssg)+2
	         call wrivar_(mssg(lim:),propsz,dig,erro)
	         if (erro.ne.0) goto 90002		!write error
	         call vtext_(mssg(1:istrip_(mssg)+1),line1+1,10,vedbli)
c
c	         edit or display elem
c
	         linpag=1				!page starts at 1
	         if (display) then
	            mode=6				!display only mode
	            myused=pgslice			!show only a few lines
	            if (linpag+myused-1.gt.used) myused=used-linpag+1
	         else
	            mode=4
	            linpag=1				!edit, start at 1
	            myused=used				!use all fields
	         endif
c
	         topscr=-1				!first line is 1
	         start=line1+3				!first screen line
	         margin=-1				!...
	         edtlin=24			!messages/help at the bottom
	         dohlp=.true.				!tell editor to do help
	         size=start+myused-1			!screen size
	         sizmax=size
	         db$rec=recnum				!allow duplicate rec#
	         dokill=.true.				!allow ^Z KILL
	         doinsert=.true.			!allow ^Z INSERT
c
456	         continue
c
	         call vedits_(spfchl_,mode,start,size,topscr,margin,
     1   	              lx,cx,vmssg(linpag),msiz(linpag),
     1                        page(linpag),psiz,myused,mini(linpag),
     1   	              maxi(linpag),pics(linpag),kind(linpag),
     1                        term,xpos,ypos,blink(linpag),
     1                        edtlin,dohlp,hlpmsg(linpag),sizmax,status,
     1                        vftype(linpag),dokill,doinsert,erro)
	         if (erro.ne.0) goto 900		!error, carry
	         if (.not.s$set(s$talk)) then
	            call tty_echo_(.false.)		!as before
	         endif
	         vnext=.true.				!assume next elem
	         vnoth=.false.
c
c	         status  = -1	return
c			   -2	up-arrow
c			   -3	down-arrow
c			   -4	GOLD/up-arrow
c			   -5	GOLD/down-arrow
c			   -7	^Z KILL
c			   -8	^Z INSERT
c			   =0	^Z QUIT
c			   >0	^Z EXIT
c
c	         If display mode, skip edit/append stuff
c
	         if (display) then
c
c	            If page completly shown, next elem, otherwise
c	            show rest of page
c
	            linpag=linpag+myused
	            if (linpag.gt.used) then
	               shrest=.false.
	            else
	               shrest=.true.
	            endif
c
	            if (.not.shrest.and.
	1               elem+1.gt.propsz) then		!all done
	               write (mssg,10015)	!all fields shown,<ret> to exit
	               call vtext_(mssg(1:istrip_(mssg)),edtlin,1,2)
	               call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	               if (erro.ne.0) noerror
 	               call erase_line_(edtlin,1)	!clean line
	               eoinp=.true.			!go away
	            else				!next elem. or rest
	               if (shrest) then
	                  write (mssg,10017)		!<ret> to proceed
	               else
	                  write (mssg,10014)		!<ret> to proceed
	               endif
	               call vtext_(mssg(1:istrip_(mssg)),edtlin,1,2)
	               call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	               if (erro.ne.0) noerror
	               call erase_line_(edtlin,1)	!clean line
	               if (ttypad.ne.0.or.ttychr.ne.13) then	!.not. <ret>
	                  eoinp=.true.			!go away
	               else
	                  if (shrest) then
	                     myused=pgslice		!show only a few lines
	                     if (linpag+myused-1.gt.used) then
	                        myused=used-linpag+1
	                     endif
	                     size=start+myused-1	!screen size
	                     sizmax=size
	                     call erase_page_(start,1)	!clean screen
	                     goto 456			!show them
	                  else
	                     elem=elem+1		!next elem.
	                  endif
	               endif
	            endif
	            goto 1098
	         endif
c
	         killelem=.false.
	         inselem=.false.
c
	         if     (status.eq.0) then	!^Z QUIT
c
	            call tty_putc_(bell)		!ring
	            write (mssg(1:),10001)		!leave ? (y/n)?
	            call vtext_(mssg(1:istrip_(mssg)+2),edtlin,1,vedbli)
c
123	            continue
	            call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	            if (erro.ne.0) noerror
	            if     (ttypad.le.0.and.
	1                   (ttychr.eq.121.or.		!'y'
	1                    ttychr.eq.89     ) ) then	!'Y'
	               eoedit=.true.
	               eoinp=.true.
	               doupdate=.false.			!don't update property
	            elseif (ttypad.le.0.and.
	1                   (ttychr.eq.110.or.		!'n'
 	1                    ttychr.eq.78     ) ) then	!'N'
	               vskip=.true.			!'N', edit next elem
	               eoedit=.true.
	            else
	               goto 123				!try again
	            endif
c
	            call erase_line_(edtlin,1)		!clean line
	            vnoth=.true.			!do nothing
	            goto 1122
c
	         elseif (status.eq.-7) then	!^Z KILL
c
	            if (elem.gt.propsz ) then		!...
c
	               eoedit=.true.
	               vnoth=.true.			!do nothing
	               goto 1122
c
	            else
c
	               call tty_putc_(bell)		!ring
	               write (mssg(1:),10008)		!are you sure ? (y/n)
	               dig=ndigi_(elem)
	               lim=istrip_(mssg)+2
	               call wrivar_(mssg(lim:),elem,dig,erro)
	               if (erro.ne.0) goto 90002	!write error
	               call vtext_(mssg(1:istrip_(mssg)+2),edtlin,1,vedbli)
c
345	               continue
	               call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	               if (erro.ne.0) noerror
	               if     (ttypad.le.0.and.
	1                      (ttychr.eq.121.or.	!'y'
	1                       ttychr.eq.89     ) ) then!'Y'
c
	                  vskip=.false.
	                  killelem=.true.		!kill him
c
	               elseif (ttypad.le.0.and.
	1                      (ttychr.eq.110.or.	!'n'
 	1                       ttychr.eq.78     ) ) then!'N'
	               else
	                  goto 345			!try again
	               endif
c
	               call erase_line_(edtlin,1)	!clean line
	               eoedit=.true.
	               vnoth=.true.			!do nothing
	               goto 1122
c
	            endif
c
	         elseif (status.eq.-8) then	!^Z INSERT
c
	            if     (elem.gt.propsz ) then	!...
c
	               call erase_line_(edtlin,1)	!clean line
	               vskip=.false.
	               eoedit=.true.
	               vnoth=.true.			!do nothing
	               goto 1122
c
	            elseif (propsz.ge.mxprp) then	!no room
c
	               write (mssg,10009)		!no room
	               wuser=2
	               call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	               vskip=.false.
	               eoedit=.true.
	               vnoth=.true.			!do nothing
	               goto 1122
c
	            else
c
	               call erase_line_(edtlin,1)	!clean line
	               vskip=.false.
	               inselem=.true.			!insert elem
c
	               eoedit=.true.
	               vnoth=.true.			!do nothing
	               goto 1122
c
	            endif
c
	         else
c
	            eoedit=.true.
c
	            lx=1				!line 1
	            cx=1				!col. 1
	            topscr=-1				!first line is 1
c
	         endif
c
	         if     (status.eq.-1.or.		!<ret> or
     1                   status.eq.-3.or.		!down-arrow or
     1                   status.eq.-5    ) then		!GOLD/down-arrow
c
	            vnext=.true.			!next record
	            vskip=.true.
	            eoedit=.true.
c
	         elseif (status.eq.-2.or.		!up-arrow or
     1                   status.eq.-4    ) then		!GOLD/up-arrow
c
	            vnext=.false.			!previous record
	            vskip=.true.
	            eoedit=.true.
c
	         else				!^Z EXIT
c
	            call tty_putc_(bell)		!ring
	            if (propsz.gt.0) then
	               write (mssg,10005)		!done with? (y/n,ret=y)?
	               dig=ndigi_(propsz)
	               lim=istrip_(mssg)+2
	               call wrivar_(mssg(lim:),propsz,dig,erro)
	               if (erro.ne.0) goto 90002	!write error
	               write (mssg(istrip_(mssg)+2:),10006)
	            else
	               write (mssg,10007)		!empty
	            endif
	            call vtext_(mssg(1:istrip_(mssg)+2),edtlin,1,vedbli)
c
234	            continue
	            call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	            if (erro.ne.0) noerror
	            if     (ttypad.le.0.and.
	1                   (ttychr.eq.121.or.		!'y'
	1                    ttychr.eq.89.or.
	1                    ttychr.eq.13     ) ) then	!'Y' or <ret>
	               eoedit=.true.
	               eoinp=.true.
	            elseif (ttypad.le.0.and.
	1                   (ttychr.eq.110.or.		!'n'
 	1                    ttychr.eq.78     ) ) then	!'N'
	               eoedit=.true.
	            else
	               goto 234				!try again
	            endif
c
	            call erase_line_(edtlin,1)		!clean line
	            eoedit=.true.
	            vnoth=.true.			!do nothing
	            goto 1122
c
	         endif
c
1122	      continue
c
	      goto 1096
1097	   continue
cwhile	   enddo
c
c	   save current element if not spaces if not VNOTH and not EOINP
c	   get next/previous record if VSKIP
c	   -------------------------------------------------------------
c
	   if (.not.vnoth.and.
     1         .not.eoinp     ) then
c
	      call xflat_(prop,page,prparray(elem),erro)
	      if (erro.ne.0) goto 900		!error, carry
c
	      if (elem.gt.propsz) propsz=elem	!retain prop size
c
c	      get next/previous element if VSKIP
c
	      if (vskip) then
	         if (vnext) then
	            elem=elem+1
	            if (elem.gt.mxprp) elem=mxprp
	         else
	            elem=elem-1
	            if (elem.le.0) elem=1
	         endif
	      endif
c
	   endif
c
	   goto 1098
1099	continue
cwhile	enddo
c
	goto 800				!all done
c
c	All done here
c
800	continue
c
	if (display) goto 850			!display only, skip this
c
c	Put property if not ^Z QUIT
c
	if (doupdate) then
	   if (propsz.gt.0) then
	      call xunfla_(prop,lcpage,prparray(1),erro)	!get 1st elem
	      if (erro.ne.0) goto 900				!error, carry
	      call putsw_(prop,recnum,lcpage,erro)		!put 1st elem.
	      do k = 2,propsz
	         call xunfla_(prop,lcpage,prparray(k),erro)	!get the others
	         if (erro.ne.0) goto 900			!error, carry
	         call appsw_(prop,recnum,lcpage,erro)		!append others
	         if (erro.ne.0) goto 900			!error, carry
	      enddo
	   else
	      if (pexist) then					!suppress it
	         from=1						!completely
	         call delsw_(prop,recnum,from,erro)
	         if (erro.ne.0) goto 900			!error, carry
	      endif
	   endif
	endif
c
850	continue
c
	if (askrec) then
cxcx	   call i$scur_(base,recnum,0)		!set new current
	   call erase_page_(line1,1)		!clean screen
	   goto 1				!ask for more
	else
	   goto 900				!return
	endif
c
c	Return
c	======
c
900	continue
c
	if (askrec) then
	   call i$scur_(base,recnum,0)		!set new current
	   call erase_page_(line1,1)		!clean screen
	endif
c
	return						!return to caller
c
c	Errors
c	======
c
c	Warnings
c	--------
c	batch user, can't use editor
90001	continue
	erro=1
	goto 99000
c	read/write error
90002	continue
	erro=2
	goto 99000
c	property doesn't fit (parameter mxprp)
90003	continue
	erro=3
	goto 99000
c
c	Set error
c	---------
99000	continue
c
	call errset_('I$EDPP',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:iedpp.fmt'
c
	end
c
c
c
c
	subroutine I$USZ_(base,usrsiz)
c	******************************
c
	implicit none
c
	integer base, usrsiz
c
c	Description
c	===========
c
c	For base BASE, returns USRSIZ as user base record size, including the
c	first character (alive/killed).
c
c	ERRO	< 0	Abort key stroked (usually ESCape)
c		= 0	Ok
c		> 0	Fatal error
c
c	var
c	===
c
	include 'own:dbag0.OWN'
c
	integer k
c
c	begin
c	=====
c
	call errclr_('I$USZ')
c
	usrsiz=1
	do k = 1, d$nfld(base)
	   if (d$type(k,base).le.ftusr$) usrsiz=usrsiz+d$siz(k,base)
	enddo
c
	return
c
	end
c
c
c
c
