c	DBAGD.FOR
c	*********
c
c
c	DBAG system screen editor basic procedures. Main ancilliaries
c	will be found in DBAGS.FOR.
c
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	Synopsis of procedures :
c
c	vset1	sets the cursor
c	vset2	cleans screen and sets cursor
c	vset3	sets scroll
c	vclean	cleans the screen starting at a line
c	verase	erases the screen between two lines
c	vtext	displays text at a given line
c	vlimit	loads from base type, minimum, maximum, etc
c	vdeflt	loads from base default values
c	vedini	inits editor (endc, pad, ring, blink)
c	vedit	main screen editor procedure (old version)
c	vedits	new version of VEDIT (dummy,mode,start,size,margin,lx,cx,vmssg,
c	vcmmd	allows editing of command lines
c
c
c
c	***********************************************************************
c
	subroutine vset1_(line,col)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer line,col
c
c	Description
c	===========
c
c	Sets the cursor to line LINE, col COL.
c
c	Var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagb.own'
c
c	begin
c	=====
c
	if (.not.s$set(s$talk)) return	!if no talk to the terminal, return
c
	if (at$lvl.gt.0.and..not.s$set(s$echo))
     1   	return			!same if @level and no echo
c
	call set_cursor_(line,col)
c
	return
c
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vset2_(line)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer line
c
c	Description
c	===========
c
c	Cleans the screen starting at line LINE and down from there.
c
c	Var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagb.own'
c
c	begin
c	=====
c
	if (.not.s$set(s$talk)) return	!if no talk to the terminal, return
c
	if (at$lvl.gt.0.and..not.s$set(s$echo))
     1   	return			!same if @level and no echo
c
	call erase_page_(line,1)
c
	return
c
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vset3_(scrol1,scrol2)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer scrol1,scrol2
c
c	Description
c	===========
c
c
c	Defines scroll from SCROL1 thru SCROL2.
c
c	Var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:dbagb.own'
c
c	begin
c	=====
c
	if (.not.s$set(s$talk)) return	!if no talk to the terminal, return
c
	if (at$lvl.gt.0.and..not.s$set(s$echo))
     1   	return			!same if @level and no echo
c
	call set_scroll_(scrol1,scrol2)
c
	return
c
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine verase_(line1,line2)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer line1,line2
c
c	Description
c	===========
c
c	Erases the screnn between line1 and line2.
c
c	Var
c	===
c
	integer k
c
c	begin
c	=====
c
	if (line1.lt.1) line1=1
	if (line2.gt.24) line2=24
	do 1001 k = line1,line2
	   call erase_line_(k,1)
1001	continue
c
	return
c
c
c
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vclean_(line)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer line
c
c	Description
c	===========
c
c	Cleans the screen starting at LINE and down from there.
c
c	OBSOLETE, one should call erase_page_ directly.
c	VCLEAN remains in the library because some "old" user
c	program may still use it ...
c
c	Var
c	===
c
c	begin
c	=====
c
	call erase_page_(line,1)
c
	return
c
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vtext_(text,line,coln,blink)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	character*(*) text
	integer line,coln,blink
c
c	Description
c	===========
c
c	Allows any outside user to write a message TEXT on the
c	screen  starting  at  LINE  COLumN,  with BLINK visual
c	attributes.
c
c	Var
c	===
c
c	begin
c	=====
c
c	tell user the message
c
	call erase_line_(line,coln)
	call put_screen_(text,line,coln,blink)
c
	return
c
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vlimit_(base,nfield,fields,vmssg,msiz,psiz,
     1                     kind,min,max,pic,error)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer base,nfield,fields(*),msiz(*),psiz
	integer kind(*),min(*),max(*),pic(*),error
	character*(*) vmssg(*)
c
c	Description
c	===========
c
c	From the context in  memory  of data BASE, the lefthand
c	message, the  type, minimum, maximum, and  size  values
c	for  each  field  are  collected into VMSSG, KIND,  MIN,
c	MAX,  PIC ( who  would  have  guessed  ?) to be used by
c	VEDIT procedure. The fields to be  considered  are user
c	given. If NFIELD is  -1  all fields  must be considered.
c	If  >0  they  will be in FIELDS  used up to NFIELD. The
c	buffer can  have  a maximum of PSIZ lines.
c
c	Var
c	===
c
	include 'own:dbag0.OWN'
	include 'own:vedit.own'
c
	external istrip_
	integer istrip_
	integer k,kk,dec,l,long,all,knd,mypic,maxpic,maxf,width,b2,mast
	logical pfail,protfail
c
c	begin
c	=====
c
	call errclr_('VLIMIT')
	error=0
c
	pfail=.false.		!assume no protected field
	maxpic=-1		!maximum field size
	maxf=1			!field #
	call ttwdth_(width)	!current tt width
c
c	cycle in fields
c
	if (nfield.eq.-1) then
	   all=d$nfld(base)
	else
	   all=nfield
	endif
c
	l=0
	long=0
	do 1001 kk=1,all
	   if (nfield.eq.-1) then
	      k=kk
	      fields(kk)=kk
	   else
	      k=fields(kk)
	   endif
	   call zmne_(base,k,vmssg(kk),error)
	   if (error.ne.0) goto 95000
	   l=istrip_(vmssg(kk))
	   if (l.gt.long) long=l
	   call zkind_(base,k,knd,error)
	   if (error.ne.0) goto 95000
	   b2=d$dbio(k,base)
	   mast=d$mast(k,base)
	   rechl(kk)=.false.			!no need to (re)check this line
	   if     (b2.gt.0.and.mast.gt.0.and.	!o.d.b. field
	1          d$idx(k,base).eq.2) then	!and KEY field
	      kind(kk)=80+knd			!editor special type
	      db$bas(kk)=base			!(CHKLIN...)
	      db$fld(kk)=k
	      rechl(kk)=.true.			!(re)check this line
	   elseif (b2.gt.0.and.mast.gt.0) then	!o.d.b. field only
	      kind(kk)=40+knd			!editor special type
	      db$bas(kk)=base			!(CHKLIN...)
	      db$fld(kk)=k
	      rechl(kk)=.true.			!(re)check this line
	   elseif (d$idx(k,base).eq.2) then	!KEY field only
	      kind(kk)=60+knd			!editor special type
	      db$bas(kk)=base			!(CHKLIN...)
	      db$fld(kk)=k
	      rechl(kk)=.true.			!(re)check this line
	   else
	      kind(kk)=knd			!editor usual type
	      db$bas(kk)=0
	      db$fld(kk)=0
	   endif
	   call zxlim2_(base,k,min(kk),max(kk),protfail,error)
	   call zxlim2_(base,k,min(kk),max(kk),protfail,error)
	   if (error.ne.0) goto 95000
	   if (protfail) then
	      pfail=.true.		!remember that
	      goto 1001			!next field
	   endif
	   call zsize_(base,k,pic(kk),error)
	   if (error.ne.0) goto 95000
	   mypic=pic(kk)
	   if (knd.eq.db$) then		!other D.B. have standard space
	      pic(kk) = 10
	      mypic=10
	   elseif (knd.eq.x$) then	!decimal, pic is very tricky !!!
	      call zdeci_(base,k,dec,error)
	      if (error.ne.0) goto 95000
	      pic(kk) = 1000*dec+pic(kk)+1!extra space for "."
	      mypic=dec+1
	   elseif (knd.eq.d$) then	!dates have standard size
	      pic(kk) = 11
	      mypic=11
	   elseif (knd.eq.r$) then	!reals "
	      pic(kk) = 15
	      mypic=15
	   elseif (knd.eq.r8$) then	!double precision "
	      pic(kk) = 24
	      mypic=24
	   endif
c
	   if (mypic.gt.maxpic) then
	      maxpic=mypic
	      maxf=k
	   endif
c
1001	continue
c
	long=long+1
	do 1002 kk=1,all
	   msiz(kk)=long
	   vmssg(kk)(long:long)=vedend	!ending character
1002	continue
c
	nfield=all
c
	if (maxpic+10+2.gt.132) then
	   goto 90001				!too big, can't edit
	else
	   if (maxpic+10+2.gt.width) goto 90002	!set width to 132 to edit
	endif
c
	if (pfail) goto 90003			!protected field somewhere
c
	return
c
c	errors
c	======
c
c	field too big
90001	continue
	d$rinf(1:4)='fld#'
	write (d$rinf(6:),fmt='(i3)',err=90011) maxf
90011	continue
	error=1
	goto 99000
c	set width to 132
90002	continue
	d$rinf(1:4)='fld#'
	write (d$rinf(6:),fmt='(i3)',err=90021) maxf
90021	continue
	error=2
	goto 99000
c	at least one protected field
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him witch base
	error=3
	goto 99000
c
99000	continue
	call errset_('VLIMIT',error)
	return
c
c	inherited errors
95000	continue
c
	return
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vdeflt_(base,nfield,fields,page,error) 
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	integer base,nfield,fields(*),error
	character*(*) page(*)
c
c	Description
c	===========
c
c	In  PAGE  the  default  values  for FIELDS up to
c	NFIELD are  loaded in PAGE.
c
c	Var
c	===
c
	include 'own:dbag0.OWN'
c
	external istrip_
	integer istrip_
	integer k,kk,dec,m,b2,mast,ty
c
c	begin
c	=====
c
	call errclr_('VDEFLT')
	error=0
c
c	cycle in fields for default values
c
	do 1001 kk=1,nfield
	   k=fields(kk)
	   b2=d$dbio(k,base)
	   mast=d$mast(k,base)
	   ty=d$type(k,base)
	   if (ty.eq.db$) then
	      if (b2.gt.0.and.mast.gt.0) then		!o.d.b field
	         call cunflt_(b2,page(kk),m,mast,d$dflt(b2),error)
	         if (error.ne.0) goto 95000
	      else
	         page(kk)(1:)=' '			!make compatible
	      endif
	   else
	      if (ty.ne.r8$) then			!r8 have no def. val.
	         call cunflt_(base,page(kk),m,k,d$dflt(base),error)
	         if (error.ne.0) goto 95000
	      else
	         page(kk)(1:)=' '
	      endif
	   endif
1001	continue
c
	return
c
c	errors
c	======
c
c	inherited errors
95000	continue
c
	return
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vedini_(action,endc,pad,ring,blink,io)
c
c	***********************************************************************
c
	implicit none
c
	character*1 endc,pad,ring
	integer action,blink,io
c
c	Description
c	===========
c
c	Depending on ACTION, the following items are initialized from
c	file, read or set:
c
c	ENDC :	character to mark the end of each line;
c	PAD  :	character to show the space that left up to the end
c	        of the line;
c	RING :	will warn if over the end of the line (tipically
c	        bell);
c	BLINK:	will tell display characteristics, see VAX Manual
c	        6-A, page 3-7.
c
c	These items are then stored into editor common area to be
c	used later when calling editing procedures.
c
c	ACTION = 1		Read values from file VEDIT.INI, set
c				and return them
c
c	         2		Read current values
c
c	         3		Set values
c
c	         < 1 or > 3	No action
c
c	If ACTION = 1 and no init file is available, local default values
c	will be forced.
c
c	IO (input i/o channel) should be given as argument, if reading from
c	file or setting.
c
c	var
c	===
c
	include 'own:dbagthin.own'
	include 'own:vedit.own'
c
c	Local "defaults"
c	----------------
c
	character*1
     1   		locend/':'/,		!local ending character
     1   		locpad/'_'/,		!      padding character
     1   		locrng			!      ringing character
c
	integer
     1   		locbli/2/,		!local display characteristics
     1                  locio /5/		!local i/o channel
c
	integer chn,ascii
	logical itdoes
c
c	begin
c	=====
c
	locrng=char(7)				!bell...
c
	if (io.le.0) io=locio			!just in case...
c
	goto (1,2,3) action
c
	return					!unknown action code, no-op
c
c	Read values from standard init file
c	-----------------------------------
c
1	continue
c
	inquire(file='VEDIT.INI',exist=itdoes)
	if (itdoes) then
	   call newc_(chn)
	   if (chn.le.0) goto 10
	   open(unit=chn,file='VEDIT.INI',status='old',readonly,
     1     carriagecontrol='list',err=10)
	   read(chn,'()',end=10,err=10)	!header for nothing
	   read(chn,*,end=10,err=10) endc
	   read(chn,*,end=10,err=10) pad
	   read(chn,*,end=10,err=10) ascii
	   read(chn,*,end=10,err=10) blink
	   ring=char(ascii)
	   close(chn)
	   call freec_(chn)
	   chn=0				!just in case...
	   goto 100				!common setting
	else
10	   continue
c
c	   local default values
c
	   endc =locend
	   pad  =locpad
	   ring =locrng
	   blink=locbli
	   goto 100				!common setting
	endif
c
c	read current values
c
2	continue
c
	endc=vedend
	pad=vedpad
	ring=vedrng
	blink=vedbli
	io=vedchn
c
	return
c
c	set values
c
3	continue
c
	goto 100				!common setting
c
c	Set values in common
c	--------------------
c
100	continue
c
	vedend=endc
	vedpad=pad
	vedrng=ring
	vedbli=blink
	vedchn=io
c
	return
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vedit_(dummy_,mode,lx,cx,vmssg,msiz,page,psiz,used,
     1                   mini,maxi,pics,kind,term,xpos,ypos,
     1                   blink,error)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984, 1985, 1986
c
	implicit none
c
	include 'own:dbagthin.own'
	include 'own:vedit.own'
c
	external dummy_
	integer mode,lx,cx,term,psiz,used,status,error
	character*(*) vmssg(*),page(*)
	integer msiz(*),mini(*),maxi(*),pics(*),kind(*)
	integer xpos(*),ypos(*),blink(*)
c
c	Description
c	===========
c
c	===>>> There is a new and (!) compatible version (VEDITS)
c	===>>> called now by VEDIT, after initializing the editor
c	===>>> by calling VEDINI.
c
c	var
c	===
c
	integer pmax
	parameter ( pmax = 100 )
c
	logical vedone/.false./,dokill,doinsert
	character*1 endc,pad,ring,hlpmsg(1)
	integer k,myblink,mytype(pmax),io
	logical dohlp
c
	integer start,size,sizmax,topscr,edtlin,margin
c
c	begin
c	=====
c
c	Clear errors
c
	call errclr_('VEDIT')
	error=0
c
c	Check my own limit
c
	if (psiz.gt.pmax) goto 90001		!too big
c
c	Initialize editor screen characteristics
c
	if (.not.vedone) then	!do it just once
	   io=5			!i/o channel
	   call vedini_(1,endc,pad,ring,myblink,io)
	   vedone=.true.
	endif
c
c	Set new parameters
c
	start=4			!screen editor begins here
	size=22			!and ENDS here
	sizmax=size		!...
	topscr=1		!first line of page shown
	margin=7		!try to rearrange the screen all the time!
	edtlin=24		!editor messages at bottom line
	dohlp=.true.		!tell editor to do HELP
	hlpmsg(1)='?'		!...
c
c	Don't forget blink and field type
c
	do 1001 k = 1, psiz
	   blink(k)=myblink
	   mytype(k)=vfrw$	!read/write
1001	continue
c
c	Try to do the same as some time ago ...
c
	dokill=.false.		!no ^Z KILL
	doinsert=.false.	!no ^Z insert
	call vedits_(dummy_,mode,start,size,topscr,margin,lx,cx,
     1               vmssg,msiz,page,psiz,used,mini,maxi,pics,
     1               kind,term,xpos,ypos,blink,edtlin,dohlp,
     1               hlpmsg,sizmax,status,mytype,dokill,doinsert,error)
	if (error.ne.0) return	!error, carry
c
	if (status.le.0) then
	   used=status		!make it compatible with previous version
	endif
c
	return			!and good luck
c
c	Errors
c	======
c
c	too much lines to edit (parameter PMAX)
90001	continue
	error=1
	goto 99000
c
99000	continue
	call errset_('VEDIT',error)
	return
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vedits_(dummy_,mode,start,size,topscr,margin,lx,cx,
     1                     vmssg,msiz,page,psiz,used,mini,maxi,
     1                     pics,kind,term,xpos,ypos,blink,edtlin,
     1                     dohlp,hlpmsg,sizmax,status,ftype,dokill,
     1                     doinsert,error)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1984
c
	implicit none
c
	external dummy_
	integer mode,start,size,sizmax,topscr,margin,lx,cx
	integer term,psiz,used,edtlin,status,ftype(*),error
	character*(*) vmssg(*),page(*),hlpmsg(*)
	integer msiz(*),mini(*),maxi(*),pics(*),kind(*)
	integer xpos(*),ypos(*),blink(*)
	logical dohlp,specia,refres,dokill,doinsert
c
c	Description
c	===========
c
c	=== Previous version (VEDIT) differences:
c		- new arguments START, SIZE, TOPSCR, MARGIN, EDTLIN instead
c		  of internal assigments:	START=4
c						SIZE=22
c						TOPSCR=1
c						MARGIN=7
c						FTYPE(*)
c						  vft$	!text
c						  vfr$	!read only
c						  vfrw$	!read/write
c						  vfrwm$!read/write/mandatory
c						  vfw$	!write only
c						  vfwm$	!write/mandatory
c						  (only vfrw$ and vfrwm$ used)
c
c		     imediat values		EDTLIN=24
c
c		- output status is now returned in STATUS instead of
c		  USED; USED itself can be changed by editor if mode
c		  allows NEW LINES to be open, and current size (last
c		  screen line) can be increased until SIZMAX.
c
c		- Help messages provided in HLPMSG, if DOHLP = .true.
c
c		- MODES = 4/5 fully implemented (see below).
c		          6 implemented (see below).
c	                = 7/8 implemented
c
c	This    procedure   implements   an  editor  'a-la-EDT
c	working   upon   the   PAGE.  This  one has up to PSIZ
c	lines.  Each  line  can  have  a   message  associated
c	with  it, contained  in VMSSG whose length is MSIZ. If
c	zero no message is wanted.
c	MODE grew horrid along the time and became as follows:
c
c	MODE = 0  is  the  normal   editing mode, ie, one ends
c	with ^Z followed by EX or QUIT.
c
c	MODE = 1 is a  lighter  alternative  where no  padding
c	characters are shown,  no  ringing is done,  and, note
c	well, one can get out with a  "last"  <ret>  after the
c	very last line; of course, in this latter case  ^Z etc
c	still work. New lines can also be  inserted with  OPEN
c	LINE command,or if LINE is typed before the very last
c	line (got it?!).
c
c	MODE = 2  is  like 0 but one can get out with a <ret>.
c
c	MODE = 3 is like 0 or 2 but new lines can actually be
c	inserted. Tidy, isn't it ?
c
c	MODE = 4 is like  0/2/3  but editor exits if UP ARROW,
c	DOWN arrow, <ret> or HELP has been entered and DOHLP=
c	TRUE.  This mode should allow any  number of calls to
c	VEDITS to perform "clean"(no [EOR] message, no screen
c	erasing on exit)and independant editing in any number
c	of different screen "slices",  each one from START to
c	SIZE lines,  between  absolute limits  1:23 (remember
c	that an extra line  (EDTLIN)  is  required for editor
c	messages, and it migth be forced to line 24). On exit,
c	only  EDTLIN line will  be erased and the cursor will
c	be positionned to  column 1 of  that line.  This mode
c	also allows caller to issue help messages if he wants
c	to (if DOHLP=FALSE).
c
c	MODE = 5 is IDENTICAL to mode 4, but the screen isn't
c	displayed when entering the procedure, so unnecessary
c	screen operations can be avoid if caller doesn't want
c	them (common use of mode 4/5: first call with mode=4,
c	next calls with mode=5). This is the only  mode using
c	previous value of TOPSCR argument.
c
c	MODE = 6 is a non-editing mode: screen  is  displayed
c	and editor exits.
c
c	MODE = 7/8 are identical to 4/5, but editor exits with
c	<ret>.
c	MODE = 9/10 are identical to 7/8, but new linescan  be
c	inserted anywhere, and editor  insert  new  line  with
c	DOWN-ARROW at the bottom instead of exiting.
c
c	In MINI, MAXI, PICS   the   minimum,   maximum values
c	and the  number of   alfa  places   for each line are
c	given with the appropriate meaning. In KIND  what  is
c	expected in  each  line  is  given, eg integers, text,
c	dates, ie the types supported by the application.  If
c	zero  no  meaning  is  assumed.  When  called, VEDITS
c	positions itself at LX, CX (line,column).
c	In ENDC a end character to end the line is given.  In
c	PAD  a  character  to  pad  each  line  till  its end.
c	In  RING  a warning character is given perhaps a bell.
c	STATUS tells  the actual way editor exited (see below).
c	TERM tells the type of VDU (not yet in use...).
c	DUMMY_ is an external procedure to be used by  CHKLIN
c	if  user  defined  checking is to be done. The system
c	has  a  dummy DUMMY that does nothing except be there.
c
c	More about MODE/STATUS:
c
c	If ^Z (or COMMAND) and  EXIT, STATUS has current value
c	(# of screen lines) of USED lines;
c	If ^Z (or COMMAND) and QUIT, status=0;
c	If mode = 1, 2, 4/5 or 7/8 and  user  enters CARRIAGE
c	RETURN at the bottom of the screen, editor exits with
c	status = -1;
c	If  mode =  1  and user enters UP_ARROW at the top of
c	the screen, editor exits with status = -2;
c	If mode  =  1  and user  enters   DOWN_ARROW  at  the
c	bottom of the screen, editor exits with status = -3;
c	If  mode = 4/5 and user enters
c	     UP_ARROW at the top of the screen,  editor exits
c	                                       with status = -2;
c	     DOWN_ARROW at the bottom of the screen:status = -3;
c	     GOLD/UP_ARROW anywhere:                status = -4;
c	     GOLD/DOWN_ARROW    "                   status = -5;
c	     HELP or GOLD/HELP  " and DOHLP=.false. status = -6.
c	If  mode = 7/8 and user enters
c	     UP_ARROW at the top of the screen,  editor exits
c	                                       with status = -2;
c	     DOWN_ARROW at the bottom of the screen:status = -3;
c	     GOLD/UP_ARROW anywhere:                status = -4;
c	     GOLD/DOWN_ARROW    "                   status = -5;
c	     HELP or GOLD/HELP  " and DOHLP=.false. status = -6.
c	     <RETURN>           "                   status = -1.
c	This is an  extension to the EDT commands,  we use to
c	jump  to a previous/next screen.
c	Because, oh yea  we  are  supporting various "windows"
c	at the same time.
c
c	Last feature: ^Z KILL and ^Z INSERT are now accepted if DOKILL
c	              and DOINSERT = .true., and editor returns
c	              status = -7 and -8.
c
c
c	var
c	===
c
	include 'own:dbagthin.own'
	include 'own:vedit.own'
c
	character*1 bell
	character*20 prompt
	character*1 endc,pad,ring
	real waits/4.0/
c
	integer ctrlz/26/,bkcps/8/,altmod,chr
	integer curlin,curpos,curlen,oldlin,oldpos,rpos,sz,sz2
	integer m1,m2,t1,t2,picpos,right
	integer ft,mykind,how,discmd,skip,lower
	integer istrip_,lstrip_,lim,lim1,lim2,max,cmd,l,k,m,n,step
	integer tty_putc_,tty_echo_
	integer cursor,oldcur,lsub,notok
	logical wrong,advance,betwn,over,delc,dell,mandat
	character*1 car,cfi
	character*80 substr,cmdstr,tell
	character*200 tmpchr,tmpone*1
c
c	begin
c	=====
c
99	continue
c
	call errclr_('VEDITS')
	error=0
c
	do k = 1, used				!use a local copy (dont' recheck
	   if (k.le.d$f) vedchl(k)=rechl(k)	!same line twice)
	enddo
c
	if (used.gt.psiz) goto 90001
	if (used.le.0) goto 90002
c
	status=used		!make it compatible with previous version
c
	bell=char(7)
c
	if (start.gt.0.and.size.gt.0) then
	   sz=size-start+1				!screen size user wants
	else
	   sz=0						!forget all about
	endif
c
	if (mode.eq.4.or.mode.eq.5.or.
     1      mode.eq.6.or.mode.eq.1.or.
     1      mode.eq.7.or.mode.eq.9.or.
     1      mode.eq.10.or.mode.eq.8    ) then
	   if (start.lt.1)  start=1
	   if (start.gt.edtlin-1) start=1
	   if (size.gt.edtlin-1)  size=edtlin-1
	   if (size.lt.1)   size=edtlin-1
	else
	   if (start.lt.4)  start=4			!(top messages)
	   if (start.gt.edtlin-2) start=4
	   if (size.gt.edtlin-2)  size=edtlin-2		!([EOR] message)
	   if (size.lt.4)   size=edtlin-2
	   if (sz.gt.0) then
	      sz2=size-start+1				!new size
	      if (sz2.lt.sz) then
	         size=size+sz-sz2			!fix last line
	         if (size.gt.edtlin-2)  size=edtlin-2	!([EOR] message)
	         if (size.lt.4)   size=edtlin-2
	      endif
	   endif
	endif
c
	if (margin.lt.0.or.
     1      margin.gt.(size-start) ) margin=0
c
	if (edtlin.ge.start.and.edtlin.le.size) edtlin=size+2
	if (edtlin.lt.1) edtlin=size+2
	if (mode.ne.4.and.mode.ne.5.and.
     1      mode.ne.6.and.mode.ne.1.and.
     1      mode.ne.7.and.mode.ne.9.and.
     1      mode.ne.10.and.mode.ne.8     ) then
	   if (edtlin.eq.size+1) edtlin=size+2		!([EOR]) mess.)
	endif
	if (edtlin.gt.24) edtlin=24
c
	if (sizmax.gt.start+psiz-1) sizmax=start+psiz-1
	if (sizmax.lt.1.or.
     1      sizmax.ge.edtlin) sizmax=edtlin-1
c
	if (mode.eq.1) then
	   endc=vedend			!current ending character
	   pad=' '			!no padding
	   ring=char(32)		!no ringing
	else
	   endc=vedend			!current ending character
	   pad=vedpad			!and padding
	   ring=vedrng			!and ringing
	endif
c
	notok=0
	delc=.false.
	dell=.false.
	if (lx.le.0) lx=1
	if (lx.gt.psiz) lx=psiz
	if (cx.le.0) cx=1
	curlin=lx
	curpos=cx
	cursor=start
	if (topscr.le.0.or.
     1      (mode.ne.5.and.
     1       mode.ne.6.and.
     1       mode.ne.8.and.
     1       mode.ne.10     )) then
	   topscr=1
	endif
	lsub=1
	substr(1:1)=' '
c
c	init screen
c	-----------
c
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('=')		!Alternate keypad
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('<')		!ANSI mode
	if (mode.ne.5.and.mode.ne.6.and.
     1      mode.ne.10.and.mode.ne.8) then
	   if (mode.eq.4) then
	      call verase_(start,size)
	   else
	      call erase_page_(start,1)
	   endif
	endif
cbug
	sz=size
	if (sz.le.start) sz=sz+1		!funny bug ...
	call set_scroll_(start,sz)
c
cccc	call set_scroll_(start,size)		!new scrolling
c
	call tty_echo_(.false.)
	advance=.true.
c
c	display text for first/only time or just set the cursor
c	-------------------------------------------------------
c
	if     (mode.eq.5.or.mode.eq.8.or.
     1          mode.eq.10               ) then	!just set the cursor
c
	   m1=size-start+1			!"slice" size
	   if (curlin.gt.m1) then
	      m2=mod(curlin,m1)+1		!relative line
	   else
	      m2=curlin				!...
	   endif
	   cursor=m2+start-1			!absolute cursor line
	   call set_cursor_(cursor,curpos+msiz(curlin))
c
	elseif (mode.eq.6) then			!display only mode
c
	   call xpage_(mode,topscr,start,topscr,start,
     1                 size,endc,pad,ring,vmssg,msiz,pics,
     1                 page,used,blink)
	   goto 995				!exit now
c
	else
c
	   call xpage_(mode,topscr,start,topscr,start,
     1                 size,endc,pad,ring,vmssg,msiz,pics,
     1                 page,used,blink)
	   call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                   page,used,topscr,start,size,cursor,
     1                   margin,blink)
c
	endif
c
c
c	(quasi) eternal loop waiting for the user
c	-----------------------------------------
c
1	continue
c
c
c	find what to be done
c	====================
c
	call padcmd_(vedchn,discmd,chr,error)
cnoerr	if (error.gt.0) noerror...
c
	call erase_line_(edtlin,1)		!clear editor line EDTLIN
c
	if (discmd.gt.0) then
c
c	Command
c	=======
c
c	clean up first
c
	if (discmd.ne.26) dell=.false.	!Not Del L
	if (discmd.ne.34) delc=.false.	!Not Del C
c
c	now dispatch for action
c
	specia=.false.			!not special OPEN LINE
c
	goto ( 10, 20, 30, 40, 50, 60, 70, 80, 90,100,
     1        110,120,130,140,150,160,170,180,190,200,
     1        210,220,700,240,250,260,270,280,290,300,
     1        310,320,330,340,350,360,370,380,390,400,
     1        410,420,430,440,450,460,470,
     1        480,490,500,510,520,530,                !extra keypad
     1        540,550,560,570,580,590,600,610,620,630,!F's
     1        640,650,660,670,                        !"
     1        671                                     !extra extra PAGE HOME
     1                                               ) discmd
c
c
c	F's ( F15 = HELP and F16 = DO ~ COMMAND are elsewhere)
c
540	continue	!F7
550	continue	!F8
560	continue
570	continue
580	continue
590	continue
600	continue
610	continue	!F14
640	continue	!F17
650	continue
660	continue
670	continue	!F20
671	continue	!PAGE HOME
c
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c	^  (up arrow)
c	--------------------------------
c
10	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	skip=-1
	call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	if (error.eq.1.and.
     1      (mode.eq.1.or.
     1       mode.eq.4.or.mode.eq.5.or.
     1       mode.eq.7.or.mode.eq.9.or.
     1       mode.eq.10.or.mode.eq.8   )) then
	   error=0
	   status=-2			!tell user up arrow
	   goto 995			!EXIT editor NOW!!!
	endif
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	\/ (down arrow)
c	--------------------------------
c
20	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	skip=1
	call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	if (error.eq.2.and.
     1      (mode.eq.1.or.mode.eq.4.or.mode.eq.5.or.
     1       mode.eq.7.or.mode.eq.8                )) then
	   error=0
	   status=-3			!tell user down arrow
	   goto 995			!EXIT editor NOW!!!
	endif
	if (error.eq.2.and.
     1      mode.eq.9.or.mode.eq.10) then
	   error=0
	   specia=.true.	!special ...
	   goto 390		!make it like OPEN LINE
	endif
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c	>  (right arrow)
c	--------------------------------
c
30	continue
	curlen=lstrip_(page(curlin))
	if (curpos.gt.curlen) then
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	      mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                    page(curlin),curlen,blink(curlin))	!cx
	   endif
	endif
	skip=1
	call xcjump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	<  (left arrow)
c	--------------------------------
c
40	continue
	curlen=lstrip_(page(curlin))
	if (curpos.le.1) then
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	      mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                    page(curlin),curlen,blink(curlin))	!cx
	   endif
	endif
	skip=-1
	call xcjump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Gold (uau !!) ! NEXT CHARACTER !
c	--------------------------------
c
50	continue
	call set_cursor_(cursor,curpos+msiz(curlin))	!cursor where it was
	goto 700
c
c
c
c	F15 (HELP)
c	----------
c
620	continue
c
c	Help (from my friends...)
c	--------------------------------
c
60	continue
240	continue
c
c	Give help message if wanted and set the cursor to right place
c
	if (dohlp) then				!help me, please
c
	   if (mode.eq.4.or.mode.eq.5.or.	!user provided help messages
     1         mode.eq.7.or.mode.eq.9.or.
     1         mode.eq.10.or.mode.eq.8.or.
     1         mode.eq.1.or.mode.eq.2    ) then
c
	      lim1=istrip_(hlpmsg(curlin))
	      if (lim1.gt.0) then		!user help message, please...
	         if (lim1.gt.80) lim1=80
	         tell(1:lim1)=hlpmsg(curlin)	!get user help message
	      else
	         mykind=kind(curlin)		!field type
	         call stdhlp_(mykind,tell)	!standard help message, if any
	      endif
	   else					!no user help messages
	      mykind=-999999			!force unknown field type
	      call stdhlp_(mykind,tell)		!standard help message, if any
	   endif
	else
	   if (mode.eq.4.or.mode.eq.5.or.
     1         mode.eq.7.or.mode.eq.9.or.
     1         mode.eq.10.or.mode.eq.8    ) then
	      error=0
	      status=-6				!tell user up help, gold/help
	      goto 995				!EXIT editor NOW!!!
	   else
	      mykind=kind(curlin)		!field type
	      call stdhlp_(mykind,tell)		!standard help message, if any
	   endif
	endif
c
c	Give help message
c
	lim1=istrip_(tell)
	if (lim1.gt.80) lim1=80
	if (lim1.le.0) lim1=1			!just in case ...
	call put_screen_(tell(1:lim1),edtlin,1,vedbli)
c
c	Set the cursor back to proper place
c
	m1=size-start+1				!"slice" size
	if (curlin.gt.m1) then
	   m2=mod(curlin,m1)+1			!relative line
	else
	   m2=curlin				!...
	endif
	cursor=m2+start-1			!absolute cursor line
	call set_cursor_(cursor,curpos+msiz(curlin))
c
	goto 700
c
c
c
c	Fndnxt
c	--------------------------------
c
70	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	call erase_line_(edtlin,1)
	call put_screen_('       Working                 ',edtlin,1,4)
c
c	look for substring
c
	m=0
	n=curlin
	if (advance) then
	   m=index( page(curlin)(curpos+1:),substr(1:lsub) )
	else
	   if (curpos.gt.1) then
	      m=index( page(curlin)(1:curpos-1),substr(1:lsub) )
	   endif
	endif
	if (m.gt.0) then
	   if (advance) m=m+curpos
	   goto 253
	endif
	if (advance) then
	   lim1=curlin+1
	   lim2=used
	   step=1
	else
	   lim1=curlin-1
	   lim2=1
	   step=-1
	endif
	if (advance) then
	   m=index( page(curlin)(curpos+1:),substr(1:lsub) )
	   lim1=curlin+1
	   lim2=used
	   step=1
	else
	   if (curpos.gt.1) then
	      m=index( page(curlin)(1:curpos-1),substr(1:lsub) )
	   endif
	   lim1=curlin-1
	   lim2=1
	   step=-1
	endif
	do 1001 k=lim1,lim2,step
	   n=k
	   m=index(page(k)(1:),substr(1:lsub))
	   if (m.gt.0) goto 253
1001	continue
253	continue
	call erase_line_(edtlin,1)
c
c	re-arrange screen
c
	if (m.gt.0) then
	   if (n.ne.curlin) then
	      curpos=m
	      skip=n-curlin
	      call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1                    page,used,blink,edtlin,error)
	   else
	      skip=m-curpos
	      call xcjump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1                    page,used,blink,edtlin,error)
	   endif
	else
	   skip=0
	   call tty_putc_(bell)
	   call put_screen_(' String was not found   ',edtlin,1,2)
	endif
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Del Line
c	--------------------------------
c
80	continue
c
	ft=ftype(curlin)
	if (ft.eq.vfrw$.or.ft.eq.vfrwm$) then
c	   ok, delete line (read/write or read/write/mandatory)
	else
	   tell(1:)=' '
	   tell='       This line can''t be edited'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	endif
c
	if (mode.ne.3) then
	   goto 360		!make it like DEL EOL (Antonio Mota's request)
	else
	   curlen=lstrip_(page(curlin))
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	      mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1      	          page(curlin),curlen,blink(curlin))	!cx
	   endif
	   curpos=1
	   do 1002 k=curlin,used-1
	      n=lstrip_(page(k))
	      m=lstrip_(page(k+1))+1
	      page(k)=page(k+1)
	      do 1003 l=m,n
	         page(k)(l:l)=' '
1003	      continue
1002	   continue
	   n=lstrip_(page(used))
	   do 1004 l=1,n
	      page(used)(l:l)=' '
1004	   continue
	   if (curlin.eq.used) used=used-1
	   if (used.lt.1) goto 995
	   call xpage_(mode,curlin,cursor,topscr,start,
     1                 size,endc,pad,ring,vmssg,msiz,pics,
     1                 page,used,blink)
	   rpos=1+msiz(curlin)
	   call set_cursor_(cursor,rpos)
	   call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                   page,used,topscr,start,size,cursor,
     1                   margin,blink)
	   goto 700
	endif
c
c
c
c	Page
c	--------------------------------
c
90	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	PREV SCREEN (extra keypad)
c	--------------------------
c
520	continue
c
	advance=.false.
	goto 100			!as Sect
c
c	NEXT SCREEN (extra keypad)
c	--------------------------
c
530	continue
c
	advance=.true.
	goto 100			!as Sect
c
c	Sect
c	--------------------------------
c
100	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	if (advance) then
	   skip=10
	else
	   skip=-10
	endif
	call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Append
c	--------------------------------
c
110	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Del Word
c	--------------------------------
c
120	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Advance
c	--------------------------------
c
130	continue
	call set_cursor_(cursor,curpos+msiz(curlin))	!cursor where it was
	advance=.true.
	goto 700
c
c
c
c	Backup
c	--------------------------------
c
140	continue
	call set_cursor_(cursor,curpos+msiz(curlin))	!cursor where it was
	advance=.false.
	goto 700
c
c
c
c	REMOVE (extra keypad)
c	---------------------
c
500	continue
c
c	Cut
c	--------------------------------
c
150	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Del Character
c	--------------------------------
c
160	continue
c
	ft=ftype(curlin)
	if (ft.eq.vfrw$.or.ft.eq.vfrwm$) then
c	   ok, delete char (read/write or read/write/mandatory)
	else
	   tell(1:)=' '
	   tell='       This line can''t be edited'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	endif
c
	oldpos=curpos
	oldlin=curlin
	oldcur=cursor
	curlen=lstrip_(page(curlin))
	tmpchr(1:curlen)=page(curlin)(1:curlen)
	n=curlen
	if (n.lt.curpos) goto 700	!Do nothing
	curlen=curlen-1
	do 1005 k=curpos,n
	   m=k+1
	   page(curlin)(k:k)=page(curlin)(m:m)
1005	continue
	page(curlin)(n+1:)=' '
	rpos=curpos+msiz(curlin)
	call put_screen_(page(curlin)(curpos:n),
     1                      cursor,rpos,blink(curlin))
	call put_screen_('  ',cursor,msiz(curlin)+curlen+1,0)
	right=msiz(curlin)+curlen+1
	picpos=pics(curlin)+1
	if (picpos.ge.1000)picpos=mod(picpos,1000)
	picpos=msiz(curlin)+picpos
	call xcolon_(endc,pad,ring,right,cursor,picpos,blink(curlin))
	call set_cursor_(cursor,rpos)
	delc=.true.
	goto 700
c
c
c
c	Word
c	--------------------------------
c
170	continue
	curlen=lstrip_(page(curlin))
	if ((advance.and.curpos.ge.curlen)
     1      .or.((.not.advance).and.curpos.le.1) ) then
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	      mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	          page(curlin),curlen,blink(curlin))	!cx
	   endif
	endif
	betwn=.false.
	over=.false.
	if (advance) then
	   skip=1
	else
	   skip=-1
	endif
	l=lstrip_(page(curlin))+1
171	continue
	   car=page(curlin)(curpos:curpos)
	   if (.not.betwn) then
	      if (car.eq.' ') betwn=.true.
	   else
	      if (advance) then
	         if (car.ne.' ') goto 172
	      else
	         if (.not.over.and.curpos.gt.1) then
	            if (car.ne.' ') over=.true.
	         else
	            if (car.eq.' '.or.curpos.eq.1) then
	               if (curpos.ne.1) curpos=curpos+1
	               goto 172
	            endif
	         endif
	      endif
	   endif
	   curpos=curpos+skip
	   if (curpos.lt.1.and..not.advance) goto 180	!EOL (previous)
	   if (curpos.eq.l.and.advance) then		!EOL (current)
	      curpos=curpos-1
	      goto 180
	   endif
	   if (curpos.gt.l.and.advance) goto 210	!LINE (next)
	goto 171
172	continue
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Eol
c	--------------------------------
c
180	continue
	l=lstrip_(page(curlin))+1
	if ((curpos.lt.1.and..not.advance).or.
     1      (curpos.gt.l.and.advance) ) then
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	      mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	          page(curlin),curlen,blink(curlin))	!cx
	   endif
	endif
	skip=l-curpos
	if (advance) then
	   if (skip.eq.0) then
	      skip=1
	      call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1                    page,used,blink,edtlin,error)
	      skip=lstrip_(page(curlin))+1-curpos
	   endif
	else
	   skip=-1
	   call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1                 page,used,blink,edtlin,error)
	   skip=lstrip_(page(curlin))+1-curpos
	endif
	call xcjump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Char
c	--------------------------------
c
190	continue
	curlen=lstrip_(page(curlin))
	if ((advance.and.curpos.ge.curlen)
     1      .or.((.not.advance).and.curpos.le.1) ) then
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	       mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	          page(curlin),curlen,blink(curlin))	!cx
	   endif
	endif
	if (advance) then
	   skip=1
	else
	   skip=-1
	endif
	call xcjump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Enter (but knock at door first)
c	--------------------------------
c
200	continue
	call set_cursor_(cursor,curpos+msiz(curlin))	!cursor where it was
	goto 700
c
c
c
c	Line
c	--------------------------------
c
210	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	       page(curlin),curlen,blink(curlin))	!cx
	endif
c
	if (advance) then
	   skip=1
	else
	   skip=-1
	endif
	curpos=1
	call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	if (error.eq.2) then
	   if (curlin.ge.used) then	!over the bottom
	      if (mode.eq.1) then
	         error=0		!don't confuse anybody
	         specia=.true.		!special ...
	         goto 390		!make it like OPEN LINE
	      elseif (mode.eq.3) then
	         error=0		!don't confuse anybody
	         specia=.true.		!special ...
	         goto 390		!make it like OPEN LINE
	      elseif (mode.eq.9.or.
     1                mode.eq.10   ) then
	         error=0		!don't confuse anybody
	         specia=.true.		!special ...
	         goto 390		!make it like OPEN LINE
	      endif
	   endif
	endif
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	SELECT (extra keypad)
c	---------------------
c
510	continue
c
c	Select
c	--------------------------------
c
220	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	FIND (extra keypad)
c	--------------------------------
c
480	continue
c
c	Find
c	--------------------------------
c
250	continue
	call tty_echo_(.true.)
	call erase_line_(edtlin,1)
	call put_screen_('Search for : ',edtlin,1,0)
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('>')		!Numeric keypad
	read(vedchn,'(a)',err=259,end=259)substr
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('=')		!Alternate keypad
259	continue
	call tty_echo_(.false.)
	lsub=lstrip_(substr)
c
c	ACHTUNG !!! Here we join FNDNXT code !!! Sorry for the spaguetti
	goto 70
c
c
c
c	Und Line
c	--------------------------------
c
260	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	F16 (DO)
c	--------
c
630	continue
c
c	Command
c	--------------------------------
c
270	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	prompt=' Command :'
	goto 900
c
c
c
c	Fill
c	--------------------------------
c
280	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Replace
c	--------------------------------
c
290	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Und Word
c	--------------------------------
c
300	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Bottom
c	--------------------------------
c
310	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	       page(curlin),curlen,blink(curlin))	!cx
	endif
	curpos=1
	skip=used-curlin
	call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	Top
c	--------------------------------
c
320	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	       page(curlin),curlen,blink(curlin))	!cx
	endif
	curpos=1
	skip=1-curlin
	call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	INSERT HERE (extra keypad)
c	--------------------------
c
490	continue
c
c	Paste
c	--------------------------------
c
330	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Und Character
c	--------------------------------
c
340	continue
	if (delc) then
	   curpos=oldpos
	   curlin=oldlin
	   cursor=oldcur
	   curlen=lstrip_(tmpchr)
	   page(curlin)(1:)=tmpchr(1:curlen)
	   rpos=1+msiz(curlin)
	   call put_screen_(page(curlin)(1:curlen),
     1                         cursor,rpos,blink(curlin))
	   rpos=curpos+msiz(curlin)
	   right=msiz(curlin)+curlen+1
	   if (curlen.eq.1.and.page(curlin)(1:1).eq.' ') right=right-1
	   picpos=pics(curlin)+1
	   if (picpos.ge.1000)picpos=mod(picpos,1000)
	   picpos=msiz(curlin)+picpos
	   call xcolon_(endc,pad,ring,right,cursor,picpos,blink(curlin))
	   call set_cursor_(cursor,rpos)
	   delc=.false.
	endif
	goto 700
c
c
c
c	Chngcase
c	--------------------------------
c
350	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Del Eol
c	--------------------------------
c
360	continue
	ft=ftype(curlin)
	if (ft.eq.vfrw$.or.ft.eq.vfrwm$) then
c	   ok, delete eol (read/write or read/write/mandatory)
	else
	   tell(1:)=' '
	   tell='       This line can''t be edited'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	endif
c
	curlen=lstrip_(page(curlin))
	n=curlen
	if (n.lt.curpos) goto 700		!Do nothing
	page(curlin)(curpos:)=' '
	curlen=curpos
	rpos=curpos+msiz(curlin)
	call put_screen_(page(curlin)(curpos:n),
     1                      cursor,rpos,blink(curlin))
	call put_screen_('  ',cursor,msiz(curlin)+curlen+1,0)
	right=msiz(curlin)+curlen+1
	picpos=pics(curlin)+1
	if (picpos.ge.1000)picpos=mod(picpos,1000)
	picpos=msiz(curlin)+picpos
	call xcolon_(endc,pad,ring,right,cursor,picpos,blink(curlin))
	call set_cursor_(cursor,rpos)
	goto 700
c
c
c
c	Specins
c	--------------------------------
c
370	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Subs
c	--------------------------------
c
380	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Open line
c	--------------------------------
c
390	continue
c
c	Only in modes 1/3/9/10, if next line can be edited
c
c	Editor can come here in one of 4 (four!) ways:
c
c	1. Real OPEN LINE COMMAND    (specia = .false.)
c	2. MODE = 9/10 (down-arrow)  (specia = .true. )
c	3. MODE = 1 (LINE)           (specia = .true. )
c	4. MODE = 3 (LINE)           (specia = .true. )
c
	ft=ftype(curlin)		!field type
c
	if     (mode.ne.3.and.
     1          mode.ne.1.and.
     1          mode.ne.9.and.
     1          mode.ne.10    ) then
	   tell(1:)=' '
	   tell=' Can''t open NEW LINE'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	elseif (curlin.ge.psiz) then
	   curlin=psiz
	   tell(1:)=' '
	   tell=' Can''t open NEW LINE, reached end-of-buffer'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	elseif (ft.ne.vfrw$.and.ft.ne.vfrwm$) then !read/write, r/w/mandatory
	   tell(1:)=' '
	   tell=' Can''t add any more NEW LINEs'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	endif
c
	curpos=1
	used=used+1
	if (used.gt.psiz) used=psiz
c
c	Push down page contents, only if real OPEN LINE command;
c
	if (.not.specia) then		!real OPEN LINE
	   do 1006 k=used,curlin+1,-1
	      m=lstrip_(page(k-1))+1
	      n=lstrip_(page(k))
	      page(k)=page(k-1)
	      do 1007 l=m,n
	         page(k)(l:l)=' '
1007	      continue
1006	   continue
	   m=lstrip_(page(curlin))
	   do 1008 l=1,m
	      page(curlin)(l:l)=' '
1008	   continue
	endif
c
	size=size+1
	if (size.gt.sizmax)  then
	   size=sizmax			!new line doesn't fit, refresh screen
	   refres=.true.
	else
	   refres=.false.
	endif
c
	if (specia) then
	   cursor=cursor+1
	   curlin=curlin+1
	endif
cbug
	sz=size
	if (sz.le.start) sz=sz+1	!funny bug ...
	call set_scroll_(start,sz)
c
cccc	call set_scroll_(start,size)	!new scrolling
c
	if (.not.specia.or.		!OPEN LINE or just show new line
     1      .not.refres.or.
     1      mode.eq.1.or.		!or special modes (<ret>)
     1      mode.eq.3      ) then
	   call xpage_(mode,curlin,cursor,topscr,start,
     1                 size,endc,pad,ring,vmssg,msiz,pics,page,
     1                 used,blink)
	endif
c
	if (refres)  then
	   cursor=start
	endif
c
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
c
	rpos=1+msiz(curlin)
	call set_cursor_(cursor,rpos)
c
	if (curlin.le.d$f) vedchl(curlin)=.false.!don't (re)check new lines
c
	goto 700
c
c
c
c	Reset
c	--------------------------------
c
400	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	CTRLZ ( ^Z )
c	--------------------------------
c
410	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	prompt=' *'
	goto 900
c
c
c
c	Backspace
c	--------------------------------
c
420	continue
	curlen=lstrip_(page(curlin))
	skip=1-curpos
	call xcjump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1              page,used,blink,edtlin,error)
	error=0				!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c	DELETE ( not the same as Del C!)
c	--------------------------------
c
430	continue
c
	ft=ftype(curlin)
	if (ft.eq.vfrw$.or.ft.eq.vfrwm$) then
c	   ok, delete (read/write or read/write/mandatory)
	else
	   tell(1:)=' '
	   tell='       This line can''t be edited'
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	endif
c
	if (curpos.lt.1) goto 700	!Do nothing
	curlen=lstrip_(page(curlin))
	if (curlen.lt.curpos) curlen=curpos
	tmpchr(1:curlen)=page(curlin)(1:curlen)
	if (curpos.gt.1) curpos=curpos-1
	do 1009 k=curpos,curlen+1
	   m=k+1
	   page(curlin)(k:k)=page(curlin)(m:m)
1009	continue
	if (curlen.gt.1) curlen=curlen-1
	rpos=curpos+msiz(curlin)
	call put_screen_(page(curlin)(curpos:curlen),
     1                      cursor,rpos,blink(curlin))
	call put_screen_('  ',cursor,msiz(curlin)+curlen+1,0)
	curlen=lstrip_(page(curlin))
	right=msiz(curlin)+curlen+1
	if (curlen.eq.1.and.page(curlin)(1:1).eq.' ') right=right-1
	picpos=pics(curlin)+1
	if (picpos.ge.1000)picpos=mod(picpos,1000)
	picpos=msiz(curlin)+picpos
	call xcolon_(endc,pad,ring,right,cursor,picpos,blink(curlin))
	call set_cursor_(cursor,rpos)
	goto 700
c
c
c
c	GOLD ^  (gold up arrow)
c	--------------------------------
c
440	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	if  (mode.eq.4.or.mode.eq.5.or.
     1       mode.eq.7.or.mode.eq.9.or.
     1       mode.eq.10.or.mode.eq.8    ) then
	   error=0
	   status=-4				!tell user gold up_arrow
	   goto 995				!EXIT editor NOW!!!
	endif
	error=0					!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c	GOLD \/  (gold down arrow)
c	--------------------------------
c
450	continue
	curlen=lstrip_(page(curlin))
	if (ftype(curlin).eq.vfrwm$.or.
     1      ftype(curlin).eq.vfwm$     ) then
	   mandat=.true.
	else
	   mandat=.false.
	endif
	call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1               kind(curlin),mini(curlin),maxi(curlin),
     1               pics(curlin),tell,notok)
	if (tell(1:1).eq.'?') goto 97000		!fatal error
	if (notok.ne.0) then
	   call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	   goto 700
	else	!cx
	   if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	   rpos=1+msiz(curlin)	!cx
	   call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1                 page(curlin),curlen,blink(curlin))	!cx
	endif
	if   (mode.eq.4.or.mode.eq.5.or.
     1        mode.eq.7.or.mode.eq.9.or.
     1        mode.eq.10.or.mode.eq.8    ) then
	   error=0
	   status=-5				!tell user gold down_arrow
	   goto 995				!EXIT editor NOW!!!
	endif
	error=0					!don't confuse anybody
	call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                page,used,topscr,start,size,cursor,
     1                margin,blink)
	goto 700
c
c
c
c	GOLD > (gold right arrow)
c	--------------------------------
c
460	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	GOLD < (gold left arrow)
c	--------------------------------
c
470	continue
	call notimp_(cursor,curpos+msiz(curlin),edtlin)
	goto 700
c
c
c
c	Everybody here joined together !
c	--------------------------------
c
700	continue
c
c
c
c
	else
c	****
c
c	Normal characters in insert mode
c	================================
c
c	filter rubbish first (exception: <ret>)
c
	if (chr.ne.13) then			!not <ret>
	   if (chr.lt.32.or.
     1         (chr.gt.126.and.chr.lt.161).or.
     1          chr.gt.253                    ) goto 1
	endif
c
	if (chr.eq.13)  then		!RETURN
	   if     (mode.eq.1.or.mode.eq.3.or.
     1             mode.eq.7.or.mode.eq.9.or.
     1             mode.eq.10.or.mode.eq.8) then
	      status=-1			!tell user CARRIAGE RETURN
	      goto 995			!EXIT editor NOW!!!
	   endif
c
	   curlen=lstrip_(page(curlin))
	   if (ftype(curlin).eq.vfrwm$.or.
     1         ftype(curlin).eq.vfwm$     ) then
	      mandat=.true.
	   else
	      mandat=.false.
	   endif
	   call chklin_(dummy_,page(curlin),curlin,mandat,m,
     1                  kind(curlin),mini(curlin),maxi(curlin),
     1                  pics(curlin),tell,notok)
	   if (tell(1:1).eq.'?') goto 97000		!fatal error
	   if (notok.ne.0) then
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 700
	   else	!cx
	      if (curlin.le.d$f) vedchl(curlin)=.false.	!don't recheck this line
	      rpos=1+msiz(curlin)	!cx
	      call pretty_(endc,pad,ring,pics(curlin),cursor,rpos,
     1   	          page(curlin),curlen,blink(curlin))	!cx
	   endif
	   skip=1
	   curpos=1
	   call xljump_(mode,curlin,curpos,skip,endc,pad,ring,vmssg,msiz,
     1                 page,used,blink,edtlin,error)
	   if (error.eq.2.and.
     1         (mode.eq.1.or.mode.eq.2.or.
     1          mode.eq.4.or.mode.eq.5.or.
     1          mode.eq.7.or.mode.eq.9.or.
     1          mode.eq.10.or.mode.eq.8   ) ) then
	      error=0
	      status=-1			!tell user CARRIAGE RETURN
	      goto 995			!EXIT editor NOW!!!
	   endif
	   error=0			!don't confuse anybody
	   call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,msiz,pics,
     1                   page,used,topscr,start,size,cursor,
     1                   margin,blink)
c
	   goto 1
c
	else				!not a RETURN
c
	   ft=ftype(curlin)
	   if (ft.eq.vfrw$.or.ft.eq.vfrwm$) then
c	      ok, insert char (read/write or read/write/mandatory)
	   else
	      tell(1:)=' '
	      tell='       This line can''t be edited'
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 1
	   endif
c
	endif
c
c	don't use lstrip, spurious nulls if "a       b"
c
cdon't	curlen=lstrip_(page(curlin))
cdon't	if (curlen.lt.curpos) curlen=curpos
c
	l=len(page(curlin))
	lim=istrip_(page(curlin))
	if (lim.lt.curpos) lim=curpos
	if (lim.ge.l-1) lim=l-2
	page(curlin)(lim+1:lim+1)=' '
	page(curlin)(lim+2:lim+2)=char(0)
	if (lim.eq.0) lim=1
	curlen=lim
c
cdon't - end
c
	tmpchr(1:curlen)=page(curlin)(1:curlen)
	curlen=curlen+1
	l=len(page(curlin))
	if (curlen.gt.l) curlen=l
	do 1010 k=curlen,curpos+1,-1
	   m=k-1
	   page(curlin)(k:k)=page(curlin)(m:m)
1010	continue
	page(curlin)(curpos:curpos)=char(chr)
	picpos=pics(curlin)+1
	if (picpos.ge.1000)picpos=mod(picpos,1000)
	if (curlen.ge.picpos) then
	   call tty_putc_(ring)
	endif
	right=msiz(curlin)+curlen+1
	if (curlen.eq.1.and.page(curlin)(1:1).eq.' ') right=right-1
	picpos=msiz(curlin)+picpos
	rpos=curpos+msiz(curlin)
	call put_screen_(page(curlin)(curpos:curlen),
     1                      cursor,rpos,blink(curlin))
	call xcolon_(endc,pad,ring,right,cursor,picpos,blink(curlin))
	if (curpos.lt.len(page(curlin))-2) then
	   curpos=curpos+1
	endif
	rpos=curpos+msiz(curlin)
	call set_cursor_(cursor,rpos)
c
	endif
c	*****
c
c
	goto 1
c
c	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c
c
c	normal commands (here with ^Z or COMMAND)
c	-----------------------------------------
c
c	(screen cursor is supposed to be at <cursor,curpos>)
c
900	continue
	call tty_echo_(.true.)
	call erase_line_(edtlin,1)
	lim=lstrip_(prompt)
	if (lim.lt.2) lim=2
	call put_screen_(prompt(2:lim),edtlin,1,0)
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('>')		!Numeric keypad
	read(vedchn,'(a)',err=900,end=900)tmpchr
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('=')		!Alternate keypad
	call tty_echo_(.false.)
	lim=istrip_(tmpchr)
	if (lim.gt.0) then
	   call uc8to7_ (tmpchr(1:lim))
	endif
c
	if (lim.eq.1.and.
	1   tmpchr(1:lim).eq.'C') then			!CHANGE
	   if (notok.ne.0) then				!error
	      call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	      goto 1					!back to main loop
	   else
	      call erase_line_(edtlin,1)
	      call set_cursor_(cursor,curpos+msiz(curlin))!re-set cursor
	      goto 1					!back to main loop
	   endif
c
	elseif (lim.eq.4.and.
	1       tmpchr(1:lim).eq.'QUIT') then		!QUIT
	   status=0					!clear off
	   goto 995					!and exit
c
	elseif (lim.eq.4.and.
	1       dokill.and.
	1       tmpchr(1:lim).eq.'KILL') then		!KILL
	   status=-7					!tell him (her)
	   goto 995					!and exit
c
	elseif (lim.eq.6.and.
	1       doinsert.and.
	1       tmpchr(1:lim).eq.'INSERT') then		!INSERT
	   status=-8					!tell him (her)
	   goto 995					!and exit

	else
	   if (lim.eq.2.and.tmpchr(1:lim).eq.'EX'.or.
	1      lim.eq.3.and.tmpchr(1:lim).eq.'EXI'.or.
	1      lim.eq.4.and.tmpchr(1:lim).eq.'EXIT'   ) then
	      if     (notok.ne.0) then			!no exit with errors
	         call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
	         goto 1					!back to main loop
	      else
	         goto 995				!EXIT
	      endif
	   else						!unknown command
	      call tty_putc_(ring)			!wake up!
	      tell(1:)=' '
	      tell(1:36)='Enter C (back to screen mode), EXIT,'
	      lim1=38
	      if (dokill) then
	         tell(lim1:lim1+4)='KILL,'
	         lim1=lim1+6
	      endif
	      if (doinsert) then
	         tell(lim1:lim1+6)='INSERT,'
	         lim1=lim1+8
	      endif
	      tell(lim1:)='QUIT (to quit the editor)'
	      call telhim_(edtlin,istrip_(tell)+1,tell,edtlin)
	      call wait_(waits)				!wait a while
	      goto 900					!prompt again
	   endif
	endif
c
c	normal return
c	-------------
c
995	continue
c
c	If not QUIT, check all lines of page before returning to caller ?
c
	if (status.ne.0) then
c
	   do k = 1, used
	      if (k.le.d$f) then
	         if (vedchl(k)) then		!(re)check this line
	            if (ftype(k).eq.vfrwm$.or.
     1                  ftype(k).eq.vfwm$     ) then
	               mandat=.true.
	            else
	               mandat=.false.
	            endif
	            call chklin_(dummy_,page(k),k,mandat,m,
     1                           kind(k),mini(k),maxi(k),
     1                           pics(k),tell,notok)
	            if (tell(1:1).eq.'?') goto 97000	!fatal error
	            if (notok.ne.0) then	!set the cursor, re-display
c
	               curlin=k
	               curpos=1
	               m1=size-start+1		!"slice" size
	               if (curlin.gt.m1) then
	                  m2=mod(curlin,m1)+1	!relative line
	               else
	                  m2=curlin		!...
	               endif
	               cursor=m2+start-1	!absolute cursor line
c
	               call xpage_(mode,topscr,start,topscr,start,
     1                             size,endc,pad,ring,vmssg,msiz,pics,
     1                             page,used,blink)
	               call xscreen_(mode,curlin,curpos,endc,pad,ring,vmssg,
     1                               msiz,pics,
     1                               page,used,topscr,start,size,cursor,
     1                               margin,blink)
c
	               call telhim_(cursor,curpos+msiz(curlin),tell,edtlin)
c
	               goto 1
	            endif
	         endif
	      endif
	   enddo
c
	endif
c
	call errclr_('VEDITS')
	error=0
c
	lx=curlin			!return current cursor pos
	cx=curpos			!.........................
	if (lx.le.0) lx=1
	if (lx.gt.psiz) lx=psiz
	if (cx.le.0) cx=1
c
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('>')		!Numeric keypad
	call set_scroll_(1,edtlin)
	if (mode.eq.4.or.
     1      mode.eq.5.or.mode.eq.6.or.
     1      mode.eq.7.or.mode.eq.9.or.
     1      mode.eq.10.or.mode.eq.8   ) then
	   call erase_line_(edtlin,1)
	else
	   call erase_page_(start,1)
	endif
	call tty_echo_(.true.)
c
	if (status.gt.0) then
	   status=used			!compatibility...
	endif
c
	return
c
c	user's error
c	------------
c
c	used > psiz
90001	continue
	error=1
	goto 99000		!set error , tt and return
c
c	used .le. 0
90002	continue
	error=2
	goto 99000		!set error , tt and return
c
c	Set error, restore terminal and return
c
99000	continue
	call errset_('VEDITS',error)
	call erase_page_(start,1)		!clean screen
	goto 99001				!the rest of it
c
c	Fatal (DBAG) error, just restore terminal and return
c
97000	continue
c
	error=d$erro				!recover error
	goto 99001
c
99001	continue
c
	call tty_putc_(char(27))		!Altmode
	call tty_putc_('>')			!Numeric keypad
	call set_scroll_(1,edtlin)
	call tty_echo_(.true.)
c
	return
c
	end
c
c
c
c
c	***********************************************************************
c
	subroutine vcmmd_(cmdlin,cont,edl,mark,quit,trunc,erro)
c
c	***********************************************************************
c
c	Written by Luis Arriaga da Cunha 1985
c
	implicit none
c
	character*(*) cmdlin,cont
	integer kk,edl,mark,quit,erro
	logical trunc
c
c	Description
c	===========
c
c	Allows for editing of a command line CMDLIN, at line EDL, 'a-la-EDT.
c	Continuation character is CONT; cursor starts at MARK.
c
c	If  QUIT >  0	user exited with ^Z EXIT;
c		 =  0			 ^Z QUIT;
c		 = -1			 <ret>;
c		 = -2			 UP_ARROW;
c		 = -3			 DOWN_ARROW.
c
c	Truncation may occur (TRUNC=.true.).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagd.own'
	include 'own:vedit.own'
c
	external tty_echo_,trim_,istrip_,lstrip_,dummy_
	integer tty_echo_,trim_,istrip_,lstrip_
c
	integer mode,lx,cx,used,status,term
	integer start,size,sizmax,ps,topscr,margin,edtlin
	character*80  hlpmsg(cmdlnx)
	logical inidon,dohlp,dokill,doinsert
	integer vfield(psiz),vftype(psiz)
c
	integer cmdlen,width,lim,tmp1,k,l,m,j,wide,l0,l1
c
c	begin
c	=====
c
	call errclr_('VCMMD')
	erro=0
c
	trunc=.false.
	cmdlen=len(cmdlin)		!max command line size on output
c
	call ttwdth_(width)		!current tt width
c
c	Init editor help messages and field type if not done
c
	if (.not.inidon) then
	   inidon=.true.
	   do 1001 k = 1, cmdlnx
	      write (hlpmsg(k),10001)	!HELP: use common edt comands ...
1001	   continue
	endif
c
c	break up command line if enormous
c
	lim=istrip_(cmdlin)
	l=0
	wide=width-d$prsz-1			!tt width - "BAG>" - ending char
	l0=1
	l1=l0+wide-1
c
	lx=1					!cursor line
	cx=mark					!and col.
c
1	continue
c
	   tmp1=trim_(cmdlin(l0:))
	   if (tmp1.gt.1) then
	      cmdlin(l0:)=cmdlin(l0+tmp1-1:)	!ignore spaces
	      if (mark.gt.0) mark=mark-tmp1+1
	      lim=lim-tmp1+1
	   endif
c
	   if (l0.gt.lim) goto 2		!end loop
c
	   if (l1.gt.cmdlen) then
	      l1=cmdlen				!stop at end of line
	      if (l0.gt.l1) l0=l1		!just in case...
	      goto 3				!break line
	   endif
	   do 1002 k = l1,l0,-1
	      if (cmdlin(k:k).eq.' ') then
	         l1=k-1				!last pos
	         goto 3				!ok, break line
	      endif
1002	   continue
3	   continue
c
	   l=l+1				!new line
	   if (mark.gt.0) then
	      if (mark.gt.l1) then
	         lx=l+1
	      else
	         if (mark.ge.l0) cx=mark-l0+1
	      endif
	   endif
	   if (l.gt.cmdlnx) then		!forget "extra" lines
	      l=l-1
	      goto 2				!end loop
	   endif
c
	   page(l)(1:)=' '
	   page(l)(1:)=cmdlin(l0:l1)
	   l0=l1+1				!new start pos
	   l1=l0+wide-1				!new end pos
	goto 1
2	continue
c
	used=l
c
c	set context for editing
c
	call erase_page_(2,1)		!clean screen from line 2
c
	do 1003 k=1,cmdlnx
	   if (k.eq.1) then
	      vmssg(k)=d$prmt(1:d$prsz)
	   else
	      do 1004 kk = 1, d$prsz
	         vmssg(k)(kk:kk)=' '
1004	      continue
	   endif
	   if (k.gt.used) page(k)(1:)=' '	!clean only extra lines!!!
	   msiz(k)=d$prsz
	   kind(k)=0
	   xpos(k)=0
	   ypos(k)=0
	   mini(k)=0
	   maxi(k)=0
	   blink(k)=0
	   pics(k)=wide
	   vftype(k)=vfrw$		!read/write
1003	continue
	ps=cmdlnx	!room for new lines
c
c	and here we go with vedit for the command line...
c
	mode=1		!command line editing
c
c	Set "new" parameters
c
	start=edl		!screen editor begins here
	size=start+used-1	!and ENDS here
	sizmax=start+cmdlnx-1	!room for new lines
	topscr=1		!first line of page shown
	margin=-1		!don't rearrange the screen all the time
	edtlin=sizmax+2		!messages at bottom of screen (1 blank line)
	dohlp=.true.		!tell editor to do help
c
c	Try to do the same as some time ago ...
c
	dokill=.false.		!no ^Z KILL
	doinsert=.false.	!no ^Z insert
	call vedits_(dummy_,mode,start,size,topscr,margin,lx,cx,
     1               vmssg,msiz,page,ps,used,mini,maxi,pics,
     1               kind,term,xpos,ypos,blink,edtlin,dohlp,
     1               hlpmsg,sizmax,status,vftype,dokill,doinsert,erro)
	if (erro.ne.0) return	!error, carry
c
	if (.not.s$set(s$talk)) then
	   call tty_echo_(.false.)	!as before
	endif
c
	quit=status
c
c	If command ok, UP or DOWN, tell user
c
	if (quit.ne.0) then		!EXIT, <ret>, UP_ARROW or DOWN_AAROW
	   l=0
	   l0=1
	   cmdlin(1:)=' '
	   do 1005 k=1,cmdlnx
c
	      lim=istrip_(page(k))			!suppress "trailing ;"
cwhile	      do while (lim.gt.0.and.
cwhile     1               page(k)(lim:lim).eq.cont)
1096	      continue
	         if (.not.(lim.gt.0.and.page(k)(lim:lim).eq.cont))
     1              goto 1097
c
	         page(k)(lim:lim)=' '
	         lim=istrip_(page(k)(1:lim))
	         goto 1096
c
1097	      continue
cwhile	      enddo
c
	      tmp1=trim_(page(k))
	      if (tmp1.gt.1) page(k)=page(k)(tmp1:)	!ignore spaces
c	      
	      m=istrip_(page(k))
	      if (m.gt.0) then
	         l1=l0+m
	         j=l1+1				!room for space
	         if (j.le.cmdlen) then
	            cmdlin(l0:l1)=page(k)(1:m)//' '
	         else
	            l1=cmdlen-1			!truncate!
	            trunc=.true.		!tell user
	            cmdlin(l0:l1)=page(k)(1:m)//' '
	            goto 4			!bye bye
	         endif
	         l0=l1+1
	      endif
1005	   continue
4	   continue
	endif
c
	return
c
c	Errors
c
c	batch user, can't use editor
90001	continue
	erro=1
	goto 99000
c
c	Set error and return
c
99000	continue
	call errset_('VCMMD',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:vcmmd.fmt'
c
 
c
	end
c
c
c
c
	subroutine vframe(lin,col,vlen,hlen)
c	************************************
c
	implicit none
c
	integer lin,col,vlen,hlen
c
c	Description
c	===========
c
c	A  "frame" is drawn, with left-upper corner in LIN, COL,
c	vertical size VLEN and horizontal size HLEN (counted in
c	screen characters).
c
c	var
c	===
c
	integer k,l9,c9
	character*1 so
c
c	begin
c	=====
c
c	make terminal graphic
c
	so=char(27)		!esc
	call tty_putc_(so)
	call tty_putc_('(')
	call tty_putc_('0')
c
	l9=lin+vlen-1
	c9=col+hlen-1
c
	call set_cursor_(lin,col)
	so=char(108)		!left,top
	call tty_putc_(so)
	do k=lin+1,l9-1
	   call set_cursor_(k,col)
	   so=char(120)
	   call tty_putc_(so)
	enddo
	call set_cursor_(l9,col)
	so=char(109)		!left,bot
	call tty_putc_(so)
	do k=col+1,c9-1
	   call set_cursor_(l9,k)
	   so=char(113)
	   call tty_putc_(so)
	enddo
	call set_cursor_(l9,c9)
	so=char(106)		!right,bot
	call tty_putc_(so)
	do k=l9-1,lin+1,-1
	   call set_cursor_(k,c9)
	   so=char(120)
	   call tty_putc_(so)
	enddo
	call set_cursor_(lin,c9)
	so=char(107)		!right,top
	call tty_putc_(so)
	do k=c9-1,col+1,-1
	   call set_cursor_(lin,k)
	   so=char(113)
	   call tty_putc_(so)
	enddo
c
c	make terminal non graphic
c
	so=char(27)		!esc
	call tty_putc_(so)
	call tty_putc_('(')
	call tty_putc_('B')
c
	return
c
c
	end
c
c
c
c
	subroutine spfchl_(buffer,field,mandat,
     1                     lgth,kind,min,max,pic,mymssg,error)
c	*****************************************************
c
	implicit none
c
	character*(*) buffer,mymssg
	integer field,lgth,kind,min,max,pic,error
	logical mandat,user
c
c	Description
c	===========
c
c	First of all, if MANDAT = .true. checks if buffer is empty.
c	Then, check two "special" field types:
c	40 + TYPE - verifies if BUFFER contains a valid entry into the other
c		    data base
c	60 + TYPE - verifies if BUFFER contains a valid (non-existant) value for
c	            a KEY field.
c	80 + TYPE - both 40 and 60 checking
c
c	Actual base and field should have been loaded in common locations
c	DB$BAS and DB$FLD.
c	BUFFER  is  used  up to  LGTH, of course.  In MYMSSG a possible
c	error message is given back.
c	If  all  OK the buffer is  perhaps re-arrenged for prettyness.
c
c       Remember that the only type of field is :
c
c	100	- o.d.b value
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:vedit.own'
c
	external istrip_,dummy_
	integer istrip_
c
	integer base,dbcode,lim,b2,mast,berr,ferr,bufsz,onenmb,kki
	integer val,xcode,mykind
	logical eox,odb,inipos,both01
c
c	Begin
c	=====
c
	call errclr_('SPFCHL')
	error=0
c
	berr=0					!base (error message)
	ferr=0					!and field
	mymssg(1:)=' '
c
c	Nocheck ?
c	---------
c
	if (kind.lt.40.or.
	1   kind.gt.99    ) return		!ignore abnormal types
c
c	Carry on
c	--------
c
	bufsz=istrip_(buffer)
c
c	See if empty and mandatory
c
	if (bufsz.le.0.and.
     1       mandat                  ) then
	   write(mymssg(1:),10002)
	   error=2
	   goto 400
	endif
c
	if (kind.ge.80) then
	   both01=.true.
	else
	   both01=.false.
	endif
c
	if     (kind.ge.80) then
	   mykind=3
	elseif (kind.gt.60) then
	   mykind=2
	else
	   mykind=1
	endif
c
	goto (100,101,102) mykind
	return					!...
c
c	both checks
c	-----------
c
102	continue
c
	goto 100				!start at 100
c
c	o.d.b field
c	-----------
c
100	continue
c
c	if buffer is empty do nothing
c
	if (bufsz.le.0) then
	   return
	endif
c
	base=db$bas(field)
	field=db$fld(field)
c
	b2=d$dbio(field,base)
	mast=d$mast(field,base)
	if (b2.gt.0.and.mast.gt.0) then		!o.d.b. field
c
c	   call CHKLIN to check field and make it pretty
c
	   call zkind_(base,field,kki,error)
	   if (error.ne.0) goto 97000		!fatal error
c
	   xbuf2(1:)=' '
	   xbuf2=buffer				!save buffer away
	   call chklin_(dummy_,buffer,field,mandat,lgth,kki,min,max,
	1               pic,mymssg,error)
	   if (error.ne.0) then
	      buffer(1:)=' '			!restore buffer
	      buffer=xbuf2
	      return				!error
	   endif
c
	   user=.true.				!external (user) format
	   call txtdb_(b2,buffer,dbcode,mast,user,eox,error)
	   if (error.ne.0) goto 97000		!fatal error
c
	   if (eox) then
	      buffer(1:)=' '			!restore buffer
	      buffer=xbuf2
	      lim=istrip_(d$unam(b2))
	      if (lim.le.0) lim=1
	      write(mymssg(1:),10001) d$unam(b2)(1:lim),mast
	      error=1
	      berr=b2
	      ferr=field
	      goto 400
	   endif
	else
	   lim=istrip_(d$unam(base))
	   if (lim.le.0) lim=1
	   write(mymssg(1:),10001) d$unam(base)(1:lim),field
	   error=1
	   berr=base
	   ferr=field
	   goto 400
	endif
c
	if (both01) then			!both, check key
c
	   call opnx_(base,field,error)
	   if (error.ne.0) goto 97000		!fatal error
c
	   xbuf1(1:)=' '
	   val=dbcode
	   call fix_ (base,field,val,xbuf1,xcode,eox,error)
	   if (error.ne.0) goto 97000		!fatal error
c
	   call clsx_(base,field,error)
	   if (error.ne.0) then
	      call errclr_('SPFCHL')		!ignore error
	      error=0
	   endif
c
	   if (eox.or.				!key doesn't exist
	1      (.not.eox.and.			!exists, but allowed
	1       db$rec.gt.0.and.
	1       xcode.eq.db$rec) ) then
	      goto 210				!ok, proceed
	   endif
c
	   buffer(1:)=' '			!error, restore buffer
	   buffer=xbuf2
	   write(mymssg(1:),10003)
	   error=3
	   berr=base
	   ferr=field
	   goto 400
c
	endif
c
210	continue
c
	goto 400
c
c	KEY field
c	---------
c
101	continue
c
	base=db$bas(field)
	field=db$fld(field)
c
	if (bufsz.le.0)  then			!KEY field, can't be left empty
	   lim=istrip_(d$unam(base))
	   if (lim.le.0) lim=1
	   write(mymssg(1:),10004)
	   error=4
	   berr=base
	   ferr=field
	   goto 400
	endif
c
c	call CHKLIN to check field and make it pretty
c
	call zkind_(base,field,kki,error)
	if (error.ne.0) goto 97000		!fatal error
c
	xbuf2(1:)=' '
	xbuf2=buffer				!save buffer away
	call chklin_(dummy_,buffer,field,mandat,lgth,kki,min,max,
	1            pic,mymssg,error)
	if (error.ne.0) then
	   buffer(1:)=' '			!restore buffer
	   buffer=xbuf2
	   return				!error
	endif
c
	call opnx_(base,field,error)
	if (error.ne.0) goto 97000		!fatal error
c
	val=0
	odb=.false.
	inipos=.true.				!at the beginning
	xbuf1(1:)=' '				!!!!!!!!!!!!!!!!!
	call cf_(base,buffer,onenmb,field,xbuf1,odb,inipos,error)
	if (error.ne.0) goto 97000		!fatal error
c
	val=0
	call fix_ (base,field,val,xbuf1,xcode,eox,error)
	if (error.ne.0) goto 97000		!fatal error
c
	call clsx_(base,field,error)
	if (error.ne.0) then
	   call errclr_('SPFCHL')		!ignore error
	   error=0
	endif
c
	if (eox.or.				!key doesn't exist
	1   (.not.eox.and.			!exists, but allowed
	1    db$rec.gt.0.and.
	1    xcode.eq.db$rec) ) then
	   goto 200				!ok, proceed
	endif
c
	buffer(1:)=' '				!error, restore buffer
	buffer=xbuf2
	write(mymssg(1:),10003)
	error=3
	berr=base
	ferr=field
	goto 400
c
200	continue
c
	goto 400
c
400	continue
c
	if (error.gt.0.and.berr.gt.0) then
	   d$rinf(1:5)='base '
	   d$rinf(6:)=d$unam(berr)		!tell him witch base and field
	   lim=istrip_(d$rinf)
	   d$rinf(lim+1:lim+6)=', fld#'
	   write (d$rinf(lim+7:),fmt='(i3)',err=90033) ferr
90033	   continue
	   call errset_('SPFCHL',error)		!set my errors
	endif
c
	return
c
c	External (DBAG) fatal error
c
97000	continue
c
	mymssg(1:1)='?'					!fatal error
	error=d$erro					!recover error code
	call errmsg_(d$rsub,error,mymssg(2:),' ')	!get error message
c
	return
c
c
c	formats
c	=======
c
	include 'fmt:spfchl.fmt'
c
c
	end
c
c
c
c
