c	DBAGF.FOR
c	*********
c
c	Basic primitives for handling DBAG files
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	Summary of procedure calls:
c
c	f$ohdr	(chn,base, fname,recsiz,what,cmmd,erro)		open/write hdr
c	f$ihdr	(chn,lgnam,phnam,recsiz,what,cmmd,erro)		open/read header
c	f$odbf	(chn,record,used,field,mnem,page,erro)		output DBAG rec.
c	f$idbf	(chn,record,used,field,page,erro)		input  DBAG rec.
c	f$osdf	(chn,record,image,imgsiz,erro)			output SDF rec.
c	f$import(form,...					import record
c
c	Suported formats:
c
c	1. DBAGF format (header + record data)
c
c	2. SDF format   (just data)
c
c	The same file may include any number of headers.
c
c	HEADER format:
c
c	!xpto	(file type, e.g. DBAG)
c	!COMM  :Command, e.g. Append to x.y
c	!BASE  :base.long.name (database full file path)
c	!WHEN  :[dd-mmm-yyyy:hh:mm:ss]
c	!WHO   :[full username]
c	!WHERE :[directory]
c	!(blank line or specific to application)
c
c	*****************   DBAG format  ************************************
c
c	!RECORD#xxxxxxxxxxx, nnn fields
c	 iii: mmmmmmmmmm: (field # iii, mnemonic mmmmmmmmmm) (nnn lines)
c	(blank line)
c
c
c	*****************   SDF format  ************************************
c
c
c	a. "basic" records (if owner base):
c
c	   one line per record:
c
c	   n char's:	field contents, dependind on base structure
c
c	   char n+1:	space	alive record
c			?	killed record
c			\	unrecoverable data from data base
c
c	   next  10:	base record#
c
c	   type    :	one space
c
c
c	b. "creatures":
c
c	   The first n char's are '=' filled.
c
c	   char n+1:	space
c
c	   next  10:	owner base record#
c
c	   type    :	'p' for property,
c			's' for series,
c			'm' for "memo"
c
c	   next 10:	owner base name
c
c	   next 10:	"creature" name
c
c	   next 10:	total # of "creature" elements that follow
c
c	   next 10:	max # of creature elements/line (=1 if property)
c
c
	subroutine f$ohdr_(chn,base,fname,newold,recsiz,what,cmmd,erro)
c	**************************************************************
c
	implicit none
c
	integer chn,base,recsiz,erro
	character*(*) fname,what,cmmd,newold
c
c	Description
c	===========
c
c	Opens FNAME in channel CHN. If not SDF file format writes the
c	header (first four (7) ? lines) that identify the file.   See
c	the code to believe what is done, don't take my word for it...
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	integer lim,l,lz,long
	character*12 me,day*10,now*9,dir*40,chkd
	integer irace,idim,isize,ideci
	character*30 race
c
c	begin
c	=====
c
	call errclr_('F$OHDR')				!error init
c
	erro=0
c
	long=recsiz
	if (long.lt.132) long=132			!at least 132
	if (newold(1:3).eq.'NEW') then
	   open(unit=chn,file=fname,status='new',carriagecontrol='list',
     1          recl=long,err=90001)
	else
	   open(unit=chn,file=fname,status='unknown',access='append',
     1          carriagecontrol='list',recl=long,err=90001)
	endif
	recsiz=long
c
	if (what.ne.'SDF') then
c
	   call date(day)
	   call time(now)
	   call myself_(me)
	   call mydir_(dir)
	   l=istrip_(what)
	   if (l.le.0) l=1
	   write(chn,2001,err=90002)what(1:l)		!WHAT
	   l=istrip_(cmmd)
	   if (l.le.0) l=1
	   write(chn,2002,err=90002)cmmd(1:l)		!COMMAND
c
	   if (base.gt.0) then
c
	      lim=istrip_(d$bfil(base))
	      if (lim.le.0) then
	         lim=1
	         d$bfil(base)(1:1)=' '
	      endif
	      l=istrip_(d$unam(base))
	      if (l.le.0) then
	         l=1
	         d$unam(base)(1:1)=' '
	      endif
c
	      call zrace_(base,race,irace,idim,isize,ideci,erro)
c	      if (erro.ne.0) noerror
	      lz=istrip_(race)
	      if (lz.le.0) lz=1
c
	      write(chn,2003,err=90002)race(1:lz),	!race of "creature"
     1                                 d$unam(base)(1:l),!LOGICAL NAME
     1                                 d$bfil(base)(1:lim),!FILE SPEC
     1                                 chkd		!CHECK DIGIT MARK
	   else
	      write(chn,20031,err=90002)		!No base
	   endif
	   write(chn,2004,err=90002)day,now		!WHEN
	   write(chn,2005,err=90002)me			!WHO
	   l=istrip_(dir)
	   if (l.le.0) l=1
	   write(chn,2006,err=90002)dir(1:l)		!WHERE
	   write(chn,2007,err=90002)			!EMPTY LINE
c
	endif
c
	return
c
c	Errors
c	======
c
c	problems opening output file
90001	continue
	d$rinf=fname		!tell him which file
	erro=1
	goto 99000
c
c	problems writing output file header
90002	continue
	d$rinf=fname		!tell him which file
	erro=2
	goto 99000
c
99000	continue
c
	call errset_('F$OHDR',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:fohdr.fmt'
c
c
	end
c
c
c
c
	subroutine f$ihdr_(chn,fname,what,cmmd,basenm,when,who,where,erro)
c	*****************************************************************
c
	implicit none
c
	integer chn,erro
	character*(*) fname,what,cmmd,basenm,when,who,where
c
c	Description
c	===========
c
c	Opens FNAME in channel CHN. If not SDF file format, reads  the
c	(next) header (first four (7) ? lines) that identify the file,
c	doing some
c	checking  on it. If  everything ok, returns a lot of information.
c	If  the  file  is in proper format ERROR=4 and the file is given
c	back  with a REWIND done so that the user can explore it its own
c	way !!!
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	external istrip_
	integer istrip_
	integer recsiz
	character*10 first
	logical ok
c
c	begin
c	=====
c
	call errclr_('F$IHDR')				!error init
c
	erro=0
c
	inquire (file=fname,exist=ok,recl=recsiz)
	if (.not.ok) goto 90003				!no such file
	open(unit=chn,file=fname,status='old',carriagecontrol='list',
     1       readonly,recl=recsiz,err=90001)
c
	if (what.ne.'SDF') then
c
	   read(chn,fmt='(a,a)',err=90002,end=90004)first(1:1),what	!what
	   if (first(1:1).ne.'!') goto 90004			!???
	   read(chn,fmt='(a,a)',err=90002,end=90004)first(1:8),cmmd	!command
	   if (first(1:8).ne.'!COMM  : ') goto 90004		!???
	   read(chn,fmt='(a,a)',err=90002,end=90004)first(1:8),basenm	!base
	   if (first(1:8).ne.'!BASE  : ') goto 90004		!???
	   read(chn,fmt='(a,a)',err=90002,end=90004)first(1:8),when	!when
	   if (first(1:8).ne.'!WHEN  : ') goto 90004		!???
	   read(chn,fmt='(a,a)',err=90002,end=90004)first(1:8),who	!who
	   if (first(1:8).ne.'!WHO   : ') goto 90004		!???
	   read(chn,fmt='(a,a)',err=90002,end=90004)first(1:8),where	!where
	   if (first(1:8).ne.'!WHERE : ') goto 90004		!???
	   read(chn,fmt='(a)',err=90002,end=90004)first			!empty
	   if (istrip_(first).gt.0) goto 90004			!???
c
	else
c
	   what(1:)=' '
c
	endif
c
	return
c
c	Errors
c	======
c
c	problems opening input file
90001	continue
	d$rinf=fname		!tell him which file
	erro=1
	goto 99000
c
c	problems reading file header
90002	continue
	d$rinf=fname		!tell him which file
	erro=2
	goto 99000
c
c	input file doesn't exist
90003	continue
	d$rinf=fname		!tell him which file
	erro=3
	goto 99000
c
c	bad format or empty file
90004	continue
	d$rinf=fname		!tell him which file
	erro=4
	rewind(unit=chn)
	goto 99000
c
99000	continue
c
	call errset_('F$IHDR',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine f$odbf_(chn,base,record,used,field,mnem,page,erro)
c	*************************************************************
c
	implicit none
c
	integer chn,base,record,used,field(*),erro
	character*(*) page(*),mnem(*)
c
c	Description
c	===========
c
c	Writes record number RECORD in standard DBAG format on
c	unit CHN, fields in FIELD, mnemonics in MNEM, contents in
c	PAGE, all up to USED fields.
c
c	The record contents refers to data base BASE, if > 0.
c
c	N.B.:	Last character of MNEM, if = ":", will be replaced by
c	====	space in output file, to recover real field mnemonic!
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	external lstrip_
	integer lstrip_
c
	character*60 fname
	character*10 lcmnem
	integer k,l
c
c	begin
c	=====
c
	call errclr_('F$ODBF')				!error init
c
	erro=0
c
	write(chn,2001,err=90001)record,used		!first line
	do 1001 k = 1, used
	   lcmnem(1:)=mnem(k)(1:)
	   l=index(lcmnem,':')				!look for ":"
	   if (l.gt.0) lcmnem(l:l)=' '			!get rid of it
	   write (chn,2002,err=90001)
     1                       field(k),			!field
     1                       lcmnem(1:10),		!mnemonic
     1                       page(k)(1:lstrip_(page(k)))!field contents
1001	continue
	write (chn,2003,err=90001)			!empty line
c
	return
c
c	Errors
c	======
c
c	problems writing record on DBAG file
90001	continue
	inquire (unit=chn,name=fname)
	d$rinf=fname		!tell him which file
	erro=1
	goto 99000
c
99000	continue
c
	call errset_('F$ODBF',erro)
	return
c
c	Formats
c	=======
c
	include 'fmt:fodbf.fmt'
c
	end
c
c
c
c
	subroutine f$idbf_(chn,ftrans,base,record,used,field,mnem,page,eof,
     1                     trunc,erro)
c	******************************************************************
c
	implicit none
c
	logical trunc
	integer chn,ftrans,base,record,used,field(*),erro
	character*(*) mnem(*),page(*)
c
c	Description
c	===========
c
c	Reads record in standard DBAG format file on unit CHN,
c	for base BASE, returning fields in FIELD, "mnemonics" in MNEM,
c	contents in PAGE, all up to USED fields.
c	FTRANS specify field transfer mode: 1 - by field#, 2 - by name,
c	3 - bylist, mode 3 not implemented yet.
c	If truncation may have occured, TRUNC will be returned = .true.
c
c	MNEM size should be at least = 10; unreferenced fields are
c	not cleanned!!!.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_,trim_
	integer istrip_,trim_
	character*60 fname
	character*10 what
	character*10 tmpnam,mnem1,mnem2,aaa
	character*25 line
	integer curlin,kkk,nfld,l1,l2,dec,p,p1,lim,lim2,size,mysize,type,f
	logical found,eof,done,empty
	real rval
	double precision dval
c
c
c	begin
c	=====
c
	call errclr_('F$IDBF')				!error init
c
	erro=0
c
	eof=.false.
	done=.false.
	empty=.false.
	trunc=.false.
	call znfld_(base,nfld,erro)
	if (erro.ne.0) return				!error, carry
c
cwhile	do while (.not.done)
1098	continue
	   if (done) goto 1099
c
	   read (chn,fmt='(a,i10,2x,i3)',err=90001,end=100) line
	   if (line(1:8).ne.'!RECORD#') then
	      empty=.false.
cwhile	      do while (.not.empty)
1096	      continue
	         if (empty) goto 1097
c
	         read (chn,fmt='(a)',err=90001,end=90002) line
	         if (istrip_(line).le.0) empty=.true.
c
	         goto 1096
1097	      continue
cwhile	      enddo
	   else
	      read (line(9:18),fmt='(i10)',err=90001) record	!record#
	      read (line(21:23),fmt='(i3)',err=90001) used	!#fields
	      done=.true.
	   endif
c
	   goto 1098
1099	continue
cwhile	enddo
c
	do 1001 curlin = 1, used
	   field(curlin)=0				!clean field#
	   page(curlin)(1:)=' '				!clean and field data
	   read (chn,fmt='(1x,i3,2x,a,2x,a)',err=90001,end=90001)
     1                       f,				!original field#
     1   		     tmpnam(1:10),		!mnemonic
     1                       d$cbuf			!field contents
c
	   found=.false.
c
	   if (ftrans.eq.1) then			!field transf. by field#
	      if (f.le.0.or.
     1            f.gt.nfld) then
	         goto 90003				!invalid nbr. of fields
	      endif
	      found=.true.
	   else						!by name, search field#
	      mnem1(1:)=' '
	      mnem1=tmpnam(1:10)
	      if (istrip_(mnem1).gt.0) then
	         call uc8to7_(mnem1)
	         do kkk = 1, nfld
	            mnem2(1:)=' '
	            call zmne_(base,kkk,mnem2,erro)
	            if (erro.ne.0) return		!error, carry
	            call uc8to7_(mnem2)
	            if (mnem1(1:10).eq.mnem2(1:10)) then
	               found=.true.
	               f=kkk
	               goto 50
	            endif
	         enddo
50	         continue
	      endif
	   endif
c
	   if (.not.found) goto 1001			!field doesn't exist
c
	   field(curlin)=f				!field#
	   mnem(f)(1:)=' '				!mnemonic
	   mnem(f)(1:10)=tmpnam(1:10)
	   page(curlin)(1:)=' '				!clean...
c
	   call zkind_(base,f,type,erro)
	   if (erro.ne.0) return			!error, carry
	   call zsize_(base,f,size,erro)
	   if (erro.ne.0) return			!error, carry
	   if     (type.eq.d$) then
	      size=11					!date, standard size
	   elseif (type.eq.r$) then
	      size=15					!real, standard size
	   elseif (type.eq.r8$) then
	      size=24					!dd's, standard size
	   endif
c
	   call zdeci_(base,f,dec,erro)
	   if (erro.ne.0) return			!error, carry
c
	   if     (type.eq.x$) then
	      lim=istrip_(d$cbuf)
	      if (lim.le.0) then
c	         ok, all done
	      else
	         p=index(d$cbuf,'.')
	         if (p.le.1) then
	            d$cbuf(lim+1:lim+3)='.0'		!try it as ?????.0
	            p=lim+1
	         else
	            if (lim.le.p) goto 90004		!bad decimal number
	         endif
	         lim2=trim_(d$cbuf)
	         if (lim2.ge.p) goto 90004		!bad decimal number
	         if (index(d$cbuf(lim2:lim),' ').gt.0) goto 90004!bad dec. num.
	         call rdfvar_(d$cbuf,dval,lim,lim-p,erro)!read field
	         if (erro.ne.0) goto 90004		!read error
	         size=size+1				!field size (+ room for
							!sign)
	         call wrfvar_(page(curlin),dval,size,dec,erro)!write field
	         if (erro.ne.0) goto 90004		!write error
	         mysize=lim-lim2+1
	         if (mysize.gt.size.or.
     1            lim-p.gt.dec      ) then
	            trunc=.true.
	         endif
c
	      endif
c
	   elseif (type.eq.r$) then			!real
	      lim=istrip_(d$cbuf)
	      if (lim.le.0) then
c	         ok, all done
	      else
	         read (d$cbuf(1:lim),*,err=90005) rval
	         write (page(curlin)(1:size),*,err=90004) rval
	      endif
c
	   elseif (type.eq.r8$) then			!double precision
	      lim=istrip_(d$cbuf)
	      if (lim.le.0) then
c	         ok, all done
	      else
	         read (d$cbuf(1:lim),*,err=90006) dval
	         write (page(curlin)(1:size),*,err=90004) dval
	      endif
c
	   else
c
	      lim=istrip_(d$cbuf)
	      if (lim.le.0) lim=1
c
	      if (type.eq.n$) then			!integer,
	         call nozero_(d$cbuf(1:lim))		!no left-trailing 0's
	         l1=trim_(d$cbuf)
	         if (l1.gt.1) then
	            d$cbuf(1:)=d$cbuf(l1:)
	            lim=istrip_(d$cbuf)
	            if (lim.le.0) lim=1			!at least = 1
	         endif
	      endif
c
	      if     (size.eq.lim) then
	            l1=1
	            l2=lim
	            p1=1
	      elseif (size.lt.lim) then			!truncate...
	         trunc=.true.				!say him
	         if (type.eq.c$) then
	            l1=1
	            l2=size
	            p1=1
	         else
	            l2=lim
	            l1=l2-size+1
	            p1=1
	         endif
	      else
	         if (type.eq.c$) then
	            l1=1
	            l2=lim
	            p1=1
	         else
	            l1=1
	            l2=lim
	            p1=size-lim+1
	         endif
	      endif
c
	      page(curlin)(p1:)=d$cbuf(l1:l2)		!store field
c
	   endif
c
1001	continue
	read (chn,fmt='(1x)',err=90001,end=90001)	!empty line
c
	return
c
c	End-of-file
c
100	continue
c
	eof=.true.
	return
c
c	Errors
c	======
c
c	problems reading record on DBAG file
90001	continue
	inquire (unit=chn,name=fname)
	d$rinf=fname		!tell him which file
	erro=1
	goto 99000
c	Unexpected end of input file or not a DBAG file format
90002	continue
	inquire (unit=chn,name=fname)
	d$rinf=fname		!tell him which file
	erro=2
	goto 99000
c	Invalid field#
90003	continue
c
	do kkk = curlin+1,used				!don't get lost...
	   read (chn,'(a)',err=90033,end=90033) aaa
	enddo
	read (chn,'(a)',err=90033,end=90033) aaa	!blank line
c
90033	inquire (unit=chn,name=fname)
	d$rinf(1:8)='in file '
	d$rinf=fname		!tell him which file
	erro=3
	goto 99000
c	Invalid decimal number
90004	continue
c
	do kkk = curlin+1,used				!don't get lost...
	   read (chn,'(a)',err=90044,end=90044) aaa
	enddo
	read (chn,'(a)',err=90044,end=90044) aaa	!blank line
c
90044	inquire (unit=chn,name=fname)
	d$rinf(1:8)='in file '
	d$rinf=fname		!tell him which file
	erro=4
	goto 99000
c	Invalid real number
90005	continue
c
	do kkk = curlin+1,used				!don't get lost...
	   read (chn,'(a)',err=90055,end=90055) aaa
	enddo
	read (chn,'(a)',err=90055,end=90055) aaa	!blank line
c
90055	inquire (unit=chn,name=fname)
	d$rinf(1:8)='in file '
	d$rinf=fname		!tell him which file
	erro=5
	goto 99000
c	Invalid double precision number
90006	continue
c
	do kkk = curlin+1,used				!don't get lost...
	   read (chn,'(a)',err=90066,end=90066) aaa
	enddo
	read (chn,'(a)',err=90066,end=90066) aaa	!blank line
c
90066	inquire (unit=chn,name=fname)
	d$rinf(1:8)='in file '
	d$rinf=fname		!tell him which file
	erro=6
	goto 99000
c
99000	continue
c
	call errset_('F$IDBF',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine f$osdf_(chn,record,image,imgsiz,alien,owname,aliename,
	1                  totelem,linelem,erro)
c	*****************************************************************
c
	implicit none
c
	integer chn,record,imgsiz,alien,totelem,linelem,erro
	character*(*) image,owname,aliename
c
c	Description
c	===========
c
c	If a regular base:
c
c	   Writes on unit CHN the contents of record number RECORD, suposed
c	   to be in IMAGE(2:IMGSIZ), if IMGSIZ > 1 (remember a data base may
c	   have no user data), followed by IMAGE(1:1) and record# 
c	   RECORD, if .ne. 0.
c
c	   Remeber first position should be " ", "?" or "\".
c
c	If a creature:
c
c	   The user data char's are '=' filled.
c
c	   char n+1:	space
c
c	   next  10:	owner base record#
c
c	   type    :	'p' for property,
c			's' for series,
c			'm' for "memo"
c
c	   next 10:	owner base name
c
c	   next 10:	"creature" name
c
c	   next 10:	total # of "creature" elements that follow
c
c	   next 10:	max # of creature elements/line (=1 if property)
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	character*60 fname
	character*1 myalien
c
c	begin
c	=====
c
	call errclr_('F$OSDF')					!error init
c
	erro=0
c
	if (alien.eq.r$b) then				!regular base
c
	   if (imgsiz.lt.1) goto 90002				!no jokes
c
	   if (image(1:1).ne.' '.and.
	1      image(1:1).ne.'?'.and.
	1      image(1:1).ne.'\'     ) goto 90002		!no jokes	
c
	   if (imgsiz.gt.1) then
	      if (record.ne.0) then
	         write(chn,'(a,a,i10)',err=90001) image(2:imgsiz),
	1                                         image(1:1),record!not hard
	      else
	         write(chn,'(a,a)',err=90001) image(2:imgsiz),	!not hard
	1                                     image(1:1)
	      endif
	   else
	      if (record.ne.0) then
	         write(chn,'(a,i10)',err=90001) image(1:1),record!not hard
	      else
	         write(chn,'(a)',err=90001) image(1:1)
	      endif
	   endif
c
	elseif (alien.eq.r$pp) then			!property
c
	   myalien='p'
	   if (imgsiz.gt.1) then
	      write (chn,10003) record,myalien,owname,aliename,
	1                       totelem,linelem
10003	      format(<imgsiz-1>('='),1x,i10,a1,a10,a10,i10,i10)
	   else
	      write (chn,10013) record,myalien,owname,aliename,
	1                       totelem,linelem
10013	      format(1x,i10,a1,a10,a10,i10,i10)
	   endif
c
	elseif (alien.eq.r$mm) then			!memo
c
	   myalien='m'
c
	else						!series
c
	   myalien='s'
c
	endif
c
	return
c
c	Errors
c	======
c
c	problems writing record on SDF file
90001	continue
	inquire (unit=chn,name=fname)
	d$rinf=fname		!tell him which file
	erro=1
	goto 99000
c	wrong base image
90002	continue
	erro=2
	goto 99000
c
99000	continue
c
	call errset_('F$OSDF',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine f$isdf_(chn,record,image,imgsiz,killed,garbage,eof,
	1                  alien,owname,aliename,totelem,linelem,erro)
c	*******************************************************************
c
	implicit none
c
	integer chn,record,imgsiz,alien,totelem,linelem,erro
	logical killed,garbage,eof
	character*(*) image,owname,aliename
c
c	Description
c	===========
c
c	Reads on unit CHN the contents of record number RECORD, returning
c	it in IMAGE(1:IMGSIZ).
c
c	Remeber first position will hold either a space or "?". If "?",
c	KILLED = .true. if killed record, GARBAGE =.true. if unrecoverable
c	record.
c
c	EOF = .true. if end-of-file.
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	character*60 fname
	integer flen
	character*1 myalien
c
c	begin
c	=====
c
	call errclr_('F$ISDF')					!error init
c
	erro=0
	eof=.false.
	killed=.false.
	garbage=.false.
c
	if (imgsiz.lt.1) goto 90002				!no jokes
c
	if (imgsiz.gt.1) then
	   read (chn,'(a<imgsiz-1>,a,i10,
	1              a1,a10,a10,i10,i10)',err=90001,end=100) image(2:),
	1                                                      image(1:1),
	1                                                      record,
	1                                                      myalien,
	1                                                      owname,
	1                                                      aliename,
	1                                                      totelem,
	1                                                      linelem
	else
	   image(2:)=' '
	   read (chn,'(a,i10,
	1              a1,a10,a10,i10,i10)',err=90001,end=100) image(1:1),
	1                                                      record,
	1                                                      myalien,
	1                                                      owname,
	1                                                      aliename,
	1                                                      totelem,
	1                                                      linelem
	endif
c
	call uc_(myalien)
c
	if     (myalien.eq.' ') then
	   alien=r$b					!regular base
	elseif (myalien.eq.'P') then
	   alien=r$pp					!property
	elseif (myalien.eq.'M') then
	   alien=r$mm					!memo
	else
	   alien=r$si					!series (any kind ok)
	endif
c
	if     (alien.eq.r$b) then		!regular base
	   if (image(1:1).eq.'?') then
	      killed=.true.
	   elseif (image(1:1).eq.'\') then
	      garbage=.true.
	   else
	      if (image(1:1).ne.' ') goto 90002			!no jokes	
	   endif
	elseif (alien.eq.r$pp) then		!property

	elseif (alien.eq.r$mm) then		!property

	else					!memo

	endif
c
	return
c
100	continue
	eof=.true.
	return
c
c	Errors
c	======
c
c	problems reding record on SDF file
90001	continue
	inquire (unit=chn,name=fname)
	d$rinf=fname		!tell him which file
	erro=1
	goto 99000
c	wrong base image
90002	continue
	inquire (unit=chn,name=fname)
	d$rinf=fname		!tell him which file
	erro=2
	goto 99000
c
99000	continue
c
	call errset_('F$ISDF',erro)
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine f$import_(form,fldsep,strsep,ichan,inline,inprec,
	1                    nl,srclin,inipos,endpos,page,field,inpf,
	1                    nfmax,fsizemax,erro)
c	*************************************************************
c
	implicit none
c
	integer nfmax,fsizemax,form,ichan,inprec,nl,srclin(nfmax),
	1	inipos(nfmax),endpos(nfmax),field(nfmax),inpf,erro
c
	character*(*)	page(nfmax)
	character*(*) 		fldsep,strsep,inline
c
c	Return record according to FORM:
c
c	FORM =	f$user		user-defined format
c		f$free		free format (fields separated by FLDSEP,
c				strings delimited by STRSEP)
c		f$unify		UNIFY-like format  (fields separated by FLDSEP,
c				strings included)
c
c	ICHAN        -	input file channel
c	INLINE       -	working space big enough to hold input file record
c	INPREC       -	no. of input lines
c	INPF         -	no. of input fields
c	PAGE(1:INPF) -	where input record is returned
c	FIELD(*)     -	field numbers, usually 1, 2, 3 ...
c
c	When the format is user-defined, NL = no. of lines/record, SRCLIN =
c	line no. where field is, INIPOS/ENDPOS = field start/end and INPF =
c	no. of input fields.
c
c	ERRO =	-1	end-of-file
c		 0	ok
c		 1	unknown format
c		 2	error reading or processing input record
c		 3	too many fields
c		 4	FSIZEMAX exceeded, at least one field truncated
c
	include 'own:dbagf.own'
c
	external istrip_
	integer istrip_
	integer krec,kkk,type,val,dec,lim,p1,p2,lim1,pos1,pos2
	character*40 mssg
	real rval
	logical trunc,user,dbag,free,unify,minus,dbagstr,nofldsep,emptystr
c
	erro=0
c
	user=.false.
	dbag=.false.
	free=.false.
	unify=.false.
	trunc=.false.
c
	if     (form.eq.f$user) then
	   user=.true.
	elseif (form.eq.f$dbag) then
	   dbag=.true.
	elseif (form.eq.f$free) then
	   free=.true.
c
	   if  (strsep.eq.'''') then
	      dbagstr=.true.
	   else
	      dbagstr=.false.
	   endif
	   if (fldsep.eq.' ') then
	      nofldsep=.true.
	   else
	      nofldsep=.false.
	   endif
	elseif (form.eq.f$unify) then
	   unify=.true.
	endif
c
c	Read and process record
c
	   if     (dbag) then
c
	      goto 801				!unknown format
c
	   elseif (free) then
c
	      read (ichan,'(a)',end=800) inline
	      inprec=inprec+1
	      inpf=0				!no. of fields
c
	      call rstok_(inline,1,erro)	!reset buffer
c
c	      get next field
c
100	      continue
c
	         emptystr=.false.
	         minus=.false.
	         erro=0				!only my own messages
	         call intok_(type,val,dec,rval,inline,lim,p1,p2,mssg,
	1                    erro)
cxcx	         if (erro.ne.0) 		!ignore error
c
	         if (type.eq.8.and.		!",", empty field
	1            .not.nofldsep) then
	            inpf=inpf+1	      
	            if (inpf.gt.nfmax) goto 803
	            page(inpf)(1:)=' '
	            field(inpf)=inpf
	            goto 100			!next field
	         else
	            if (type.eq.13) then	!"-"
	               minus=.true.
	               erro=0			!only my own messages
	               call intok_(type,val,dec,rval,inline,lim,p1,p2,mssg,
	1                          erro)
	               if (erro.ne.0) goto 802
	               if (type.ne.2.and.	!integer or decimal
	1                  type.ne.3   ) goto 802!error
	            endif
c
	            if (type.eq.0) goto 200	!eol
c
	            if (.not.dbagstr) then	!see if special string delimiter
c
	               if (type.eq.5.or.	!can't be usual "'" string
	1                  type.eq.39  ) goto 802	!error
c
	               if (p1.eq.p2.and.
	1                  inline(p1:p2).eq.strsep) then
	                  pos1=p1		!save start
c
101	                  continue
c
	                     erro=0		!only my own messages
	                     call intok_(type,val,dec,rval,inline,lim,
	1                                p1,p2,mssg,erro)
c
	                     if (erro.ne.0) then
	                        goto 101		!loop back for more
	                     else
	                        if (type.eq.0) goto 200!eol
	                        if (p1.eq.p2.and.
	1                           inline(p1:p2).eq.strsep) then
	                           p1=pos1		!restore start
	                           if (p1+1.ge.p2) then
	                              emptystr=.true.
	                           else
	                              p1=p1+1
	                              p2=p2-1
	                           endif
	                        else	
	                           goto 101		!loop back for more
	                        endif
	                     endif
	               endif
	            else
	               if (type.eq.39) emptystr=.true.
	            endif
c
	            lim1=p2-p1+1
	            if (lim1.le.0) lim1=1
	            inpf=inpf+1	      
	            if (inpf.gt.nfmax) goto 803
	            page(inpf)(1:)=' '
	            if (.not.emptystr) then
	               if (minus) then
	                  page(inpf)(1:1)='-'
	                  page(inpf)(2:)=inline(p1:p2)
	                  if (p2-p1+1 .gt. fsizemax) then
	                     p2=p1+fsizemax-1
	                     trunc=.true.
	                  endif
	               else
	                  page(inpf)=inline(p1:p2)
	                  if (p2-p1+1 .gt. fsizemax) then
	                     p2=p1+fsizemax-1
	                     trunc=.true.
	                  endif
	               endif
	            endif
	            field(inpf)=inpf
c
c	            get ',' or <eol> if separator not = ' '
c
	            if (nofldsep) then
c
	               goto 100			!next field
c
	            else
	               erro=0			!only my own messages
	               call intok_(type,val,dec,rval,inline,lim,p1,p2,mssg,
	1                          erro)
	               if (erro.ne.0) goto 802
c
	               if     (type.eq.0) then
	                  goto 200		!eol
	               elseif (type.eq.8) then
	                  goto 100		!',', next field
	               else
	                  goto 802		!error
	               endif
c
	            endif
c
200	            continue
c
	         endif
c
	   elseif (unify) then
c
	      read (ichan,'(a)',end=800) inline
	      inprec=inprec+1
	      lim1=istrip_(inline)
	      inpf=0				!no. of fields
c
	      p1=1
c
300	      continue
	         if (p1.le.lim1) then
	            p2=index(inline(p1:lim1),fldsep)
	            if (p2.le.0) then
	               p2=istrip_(inline(p1:lim1))
	               if (p2.gt.0) p2=p2+1
	            endif
	            if (p2.gt.0) then
	               p2=p2+p1-1
	               p2=p2-1
	               inpf=inpf+1
	               if (inpf.gt.nfmax) goto 803
	               page(inpf)(1:)=' '
	               if (p1.gt.p2) then
c	                 ok, "||"
	               else
	                  page(inpf)=inline(p1:p2)
	                  if (p2-p1+1 .gt. fsizemax) then
	                     p2=p1+fsizemax-1
	                     trunc=.true.
	                  endif
	               endif
	               field(inpf)=inpf
	               p1=p2+2
	               goto 300
	            endif
	         endif
c
	   elseif (user) then
c
	      do krec = 1, nl
c
	         read (ichan,'(a)',end=800) inline
	         inprec=inprec+1
	         do kkk = 1, inpf
	            if (srclin(kkk).eq.krec) then
	               pos1=inipos(kkk)
	               pos2=endpos(kkk)
	               page(kkk)(1:)=' '
	               page(kkk)=inline(pos1:pos2)
	               if (pos2-pos1+1 .gt. fsizemax) then
	                  pos2=pos1+fsizemax-1
	                  trunc=.true.
	               endif
	            endif
	         enddo
	      enddo
c
	   else
c
	      goto 801				!unknown format
c
	   endif
c
	   if (inpf.le.0) goto 802		!no field !	   
c
	   goto 900				!return
c
c	   unknown format
c
801	   continue
c
	   erro=1
	   goto 900				!return
c
c	   error processing input file
c
802	   continue
c
	   erro=2
	   goto 900				!return
c
c	   too many fields
c
803	   continue
c
	   erro=3
	   goto 900				!return
c
c	eof
c
800	continue
c
	erro=-1
	goto 900				!return
c
c	Return
c
900	continue
c
	if (trunc) erro=4			!truncation
c
	return
c
	end
c
c
c
c
