	subroutine fldsyn_(reset,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                     mark,interr,erro)
c	***************************************************************
c
	implicit none
c
	logical reset
	character*(*) buf, mymssg
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real	rval
c
c	Description
c	===========
c
c	This procedure analyses <field list > in BUF and returns result in
c	<field list> arrays (c$fldn, c$flda), with total # of items in c$fn.
c
c	<fields list> =	<item>, {",",<item>}
c
c	<item>	      =	FIELD#! FIELD NAME! #
c
c			with FIELD# = "%" <n>
c
c	c$fldn(i) :	<n> or 0
c	c$flda(i) :	field name to be checked later, by FLDSEM, or spaces
c
c	TYPE, VAL, DEC, RVAL, BUF, LIM, P1, P2 and INTERR are usual intok
c	procedure arguments.
c
c	ERRO is returned < 0 if intok found some error (in interr).
c
c	ERRO is returned > 0 if any invalid construction is seen, e.g.
c	%1,) or data,
c
c	If ERRO not = 0, MARK will contain beginning position of rejected
c	BUF portion.
c
c	Field list is reseted if RESET = .true.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
c	begin
c	=====
c
	call errclr_('FLDSYN')				!error init
	erro=0						!clear error
c
	if (reset) c$fn=0				!clear # of items
c
	call fldit$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	    mark,interr,erro)
	if (interr.ne.0) goto 95001			!flag inwht error
	if (erro.ne.0)   return				!error, carry
	if (type.eq.0)   goto 900			!or eol
c
cwhile	do while (type.eq.8)			!","
1098	continue
	   if (type.ne.8) goto 1099
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
c
	   call fldit$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                 mark,interr,erro)
	   if (interr.ne.0) goto 95001			!flag inwht error
	   if (erro.ne.0)   return			!error, carry
	   if (type.eq.0)   goto 900			!eol
c
	   goto 1098
1099	continue
cwhile	enddo
c
900	continue
c
	if (c$fn.le.0) goto 90002			!FIELDS <list> empty
c
	return
c
c	errors
c	======
c
c	item expected after ","
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c
c	FIELDS <list> empty
90002	continue
	mark=0
	erro=2
	goto 99000
c
99000	continue
	call errset_('FLDSYN',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	erro=-1				!flag inwht error
	mark=p1				!mark rejected portion
	return				!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine fldit$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
c	*********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <item> figure, see above in FLDSYN.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
c	begin
c	=====
c
	call errclr_('FLDIT$')				!error init
c
	erro=0
c
	if     (type.eq.35) then		!%n
	   c$fn=c$fn+1					!count it
	   if (c$fn.gt.c$fldg) goto 90002		!max# exceeded
	   if (val.le.0) goto 90004			!field# 0
	   c$fldn(c$fn)=val				!store <n>
	   c$flda(c$fn)(1:)=' '				!clear name
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
c
	elseif (type.eq.1.or.
     1          type.eq.24  ) then		!identifier (_)
	   c$fn=c$fn+1					!count it
	   if (c$fn.gt.c$fldg) goto 90002		!max# exceeded
	   c$flda(c$fn)(1:)=buf(p1:p2)			!store <field name>
	   c$fldn(c$fn)=0				!clear field number
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
c
	elseif (type.eq.33) then		!%
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (type.ne.2) goto 90003			!<n> expected!
	   c$fn=c$fn+1					!count it
	   if (c$fn.gt.c$fldg) goto 90002		!max# exceeded
	   if (val.le.0) goto 90004			!field# 0
	   c$fldn(c$fn)=val				!store <n>
	   c$flda(c$fn)(1:)=' '				!clear field name
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
c
	elseif (type.eq.40) then		!# (record number)
	   c$fn=c$fn+1					!count it
	   if (c$fn.gt.c$fldg) goto 90002		!max# exceeded
	   c$fldn(c$fn)=0				!0 stands for #
	   c$flda(c$fn)(1:)=' '				!clear name
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
c
	else
	   goto 90001					!non-fields item!
	endif
c
	return
c
c	errors
c	======
c
c	item expected
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c	max# of %<n> or <field name> reached
90002	continue
	mark=p1				!mark rejected portion
	erro=2
	goto 99000
c	<n> expected after %
90003	continue
	mark=p1				!mark rejected portion
	erro=3
	goto 99000
c	field# = 0
90004	continue
	mark=p1				!mark rejected portion
	erro=4
	goto 99000
c
99000	continue
	call errset_('FLDIT$',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	mark=p1				!mark rejected portion
	erro=-1				!flag inwht error
	return				!return
c
	end
c
c
c
c
	subroutine fldsem_(base,fmap,pmap,smap,mmap,
	1                  prefix,twice,fwrite,protfail,erro)
c	***************************************************************
c
	implicit none
c
	integer base,fmap(*),pmap(*),smap(*),mmap(*),erro
	logical prefix,twice,fwrite,protfail
c
c	Description
c	===========
c
c	This procedure should be fed with proper FIELDS expressions
c	already resolved into the FIELDS arrays. It then checks and
c	completes field list arrays, setting field maps FMAP, PMAP,
c	SMAP and MMAP (regular fields, properties, series amd memos).
c
c	If FWRITE = .true., field are to be updated.
c
c	If protection failure, ofending field is ignored and PROTFAIL=.true.
c
c	BASE is supposed to be in use (OPNBAS).
c
c	The result of field list analysis (FLDSYN) is given to FLDSEM
c	as follows:
c
c	c$tt     :	total # of field numbers and field names
c	c$fldn(i):	%n or 0 if record# prefix (#)
c	c$flda(i):	field names or spaces
c
c	ON OUTPUT, all field list expressions wil be returned in field
c	maps
c
c	fmap:	fmap(i), i=1,...	= k if regular field k wanted
c					= 0 if record# prefix wanted
c		up to c$fn
c
c	pmap:	pmap(i), i=1,...	= k if property k wanted
c		up to c$pn
c
c	smap:	smap(i), i=1,...	= k if series k wanted
c		up to c$sn
c
c	mmap:	mmap(i), i=1,...	= k if memo k wanted
c		up to c$mn
c
c	PREFIX will be set to .true. if record#prefix seen, .false. if not.
c
c
c	TWICE will be set to .true. if some field is refernced at least
c	twice, .false. otherwise.
c
c	ERRO is returned not = 0 if illegal field number or "blank" field name.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
	external istrip_
	integer istrip_
	integer xtype,fmax,fidx,k,kkk,f,fpos,ppos,spos,mpos,lim
	logical ff,pp,ss,mm
c
c	begin
c	=====
c
	call errclr_('FLDSEM')			!error init
	erro=0					!clear error
c
	protfail=.false.
	prefix=.false.				!prefix record #
c
	if (c$fn.le.0) goto 90004		!no field there
c
	fpos=0					!position in regular field map
	ppos=0					!properties
	spos=0					!series
	mpos=0					!memos
c
	do 1001 k = 1, c$fn
c
	   f=c$fldn(k)
	   ff=.false.
	   pp=.false.
	   ss=.false.
	   mm=.false.
c
	   xtype=d$type(f,base)			!field type
	   if     (xtype.le.ftusr$) then
	      ff=.true.				!regular field
	   elseif (xtype.eq.p$) then
	      pp=.true.				!property
	   elseif (xtype.eq.s$) then
	      ss=.true.				!series
	   elseif (xtype.eq.mm$) then
	      mm=.true.				!memo
	   else
	      goto 1001				!ignore (link ?)
	   endif
c
c	   see protection
c
	   if ((d$prt(base).ne.0).and.		!protection ON and
	1      ((d$prfl(f,base).eq.prtno).or.	!no access
	1       (d$prfl(f,base).eq.prtro.and.	!or read only and update, ignore
	1       fwrite)                     ) ) then
	      protfail=.true.
	   else
c
	         if (f.gt.0) then			!field number
	            if (f.gt.d$nfld(base)) goto 90001	!field doesn't exist
	            if (f.lt.0) goto 90003		!< 0 ?
	            if     (ff) then
	               fpos=fpos+1
	               fmap(fpos)=f			!set it
	            elseif (pp) then
	               ppos=ppos+1
	               pmap(ppos)=f			!set it
	            elseif (ss) then
	               spos=spos+1
	               smap(spos)=f			!set it
	            elseif (mm) then
	               mpos=mpos+1
	               mmap(mpos)=f			!set it
	            endif
	         else					!field name or prefix
	            lim=istrip_(c$flda(k))
	            if (lim.gt.0) then			!field name
	               fmax=d$nfld(base)		!mnemonic exists ?
	               call chkmne_(c$flda(k),base,fmax,fidx,erro)
	               if (erro.ne.0) return		!error, carry
	               if (fidx.gt.0) then
	                  if     (ff) then
	                     fpos=fpos+1
	                     fmap(fpos)=fidx		!set it
	                  elseif (pp) then
	                     ppos=ppos+1
	                     pmap(ppos)=fidx		!set it
	                  elseif (ss) then
	                     spos=spos+1
	                     smap(spos)=fidx		!set it
	                  elseif (mm) then
	                     mpos=mpos+1
	                     mmap(mpos)=fidx		!set it
	                  endif
	                  goto 100			!done with this one
	               else
	                  goto 90002			!bad field name
	               endif
	            else				!record# prefix
	               fpos=fpos+1
	               fmap(fpos)=0			!set it
	               prefix=.true.
	            endif
c
	      endif
100	      continue
c
	   endif
c
1001	continue
c
c	Check/flag repeated field reference
c
	twice=.false.
c
	do k = 1, fpos - 1			!regular fields
	   f=fmap(k)
	   do kkk = k + 1, fpos
	      if (f.eq.0) then
	         prefix=.true.
	      else
	         if (f.eq.fmap(kkk)) twice=.true.
	      endif
	   enddo
	enddo
c
	do k = 1, ppos - 1			!properties
	   f=pmap(k)
	   do kkk = k + 1, ppos
	      if (f.eq.0) then
	         prefix=.true.
	      else
	         if (f.eq.pmap(kkk)) twice=.true.
	      endif
	   enddo
	enddo
c
	do k = 1, spos - 1			!series
	   f=smap(k)
	   do kkk = k + 1, spos
	      if (f.eq.0) then
	         prefix=.true.
	      else
	         if (f.eq.smap(kkk)) twice=.true.
	      endif
	   enddo
	enddo
c
	do k = 1, mpos - 1			!memos
	   f=mmap(k)
	   do kkk = k + 1, mpos
	      if (f.eq.0) then
	         prefix=.true.
	      else
	         if (f.eq.mmap(kkk)) twice=.true.
	      endif
	   enddo
	enddo
c
c	Suppress duplicate referenes to creatures
c
	call fldup$_(pmap,ppos)
	call fldup$_(smap,spos)
	call fldup$_(mmap,mpos)
c
	c$fn=fpos
	c$pn=ppos
	c$sn=spos
	c$mn=mpos
c
	if (c$fn.le.0.and.
	1   c$pn.le.0.and.
	1   c$sn.le.0.and.
	1   c$mn.le.0     ) goto 90004		!no field there
c
	return
c
c	errors
c	======
c	Field # doesn't exist
90001	continue
	erro=1
	goto 99000			!set error and return
c	Field name doesn't exist
90002	continue
	erro=2
	goto 99000			!set error and return
c	Internal error??????????(field number < 0)
90003	continue
	erro=4
	goto 99000			!set error and return
c	No field selected (protection failure ?)
90004	continue
	erro=4
	goto 99000			!set error and return
c
c	Set error and return
c
99000	continue
	call errset_('FLDSEM',erro)
	return
c
	end
c
c
c
c
	subroutine fldup$_(map,size)
c
	integer map(*),size
c
	integer k,kkk,idx
c
	if (size.le.0) return
c
	if (map(1).eq.0) then
	   idx=0
	else
	   idx=1
	endif
	do k = 2, size
	   if (map(k).ne.0) then
	      do kkk = k, size
	         if (map(kkk).eq.map(k-1)) map(kkk)=0
	      enddo
	      if (map(k).ne.0) then
	         idx=idx+1
	         map(idx)=map(k)
	      endif
	   endif
	enddo
c
	size=idx
c
	return
c
	end
c
c
c
c
