c
c	DBAGH.FOR
c	*********
c
c	HELHEL and BYEBYE procedures for DBAG system........
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	helhel gives a nice welcome message
c	byebye gives a nice good-bye message
c
c
c
	subroutine helhel_(mymssg,erro)
c	*******************************
c
	implicit none
c
	integer erro
	character*(*) mymssg
c
c	Description
c	===========
c
c	Returns hello message to DBAG main program...
c
c	var
c	===
c
	include 'own:DBAG0.OWN'
c
	external istrip_
	integer istrip_
	real x
	integer tonto,d,wd,m,y,h,mn,s,k,l
	character*12 txt
c
	include 'fmt:helhel.fmt'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('HELLO')
c
	erro=0					!clear error
c
	mymssg(1:)=' '
	call idate(m,d,y)
	call iweek_(d,m,y+1900,wd,txt,1,erro)
	call time(txt)
	read(txt(1:),'(i2,1x,i2,1x,i2)')h,mn,s
	if (h.ge.6.and.h.lt.12) then
	   write(mymssg(1:),1000)
	elseif (h.ge.12.and.h.le.19) then
	   write(mymssg(1:),1001)
	else
	   write(mymssg(1:),1002)
	endif
	l=istrip_(mymssg)
	mymssg(l+1:)=', '
	l=l+3
	tonto=mod(s,11)
	if (d.eq.13.and.wd.eq.6) then			!Friday 13th
	   if (tonto.gt.5) tonto=12
	   mymssg(l:)=mhello(tonto)(1:)
	elseif (m.eq.12.and.(d.ge.10.and.d.le.31)) then	!Xmas
	   if (tonto.gt.5) tonto=11
	   mymssg(l:)=mhello(tonto)(1:)
	else
	   mymssg(l:)=mhello(tonto)(1:)
	endif
c
	return					!return
c
c	errors
c	======
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine byebye_(mymssg,erro)
c	*******************************
c
	implicit none
c
	integer erro
	character*(*) mymssg
c
c	Description
c	===========
c
c	Returns byebye message to DBAG main program...
c
c	var
c	===
c
	include 'own:DBAG0.OWN'
c
	external istrip_
	integer istrip_
	real x
	integer tonto,d,ds,m,y,h,mn,s,k,l
	character*12 txt
c
	include 'fmt:byebye.fmt'
c
c	begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('BYEBYE')
c
	erro=0					!clear error
c
	mymssg(1:)=' '
	call time(txt)
	read(txt(1:),'(i2,1x,i2,1x,i2)')h,mn,s
	if (h.ge.6.and.h.le.12) then
	   write(mymssg(1:),1000)
	elseif (h.gt.12.and.h.le.20) then
	   write(mymssg(1:),1001)
	else
	   write(mymssg(1:),1002)
	endif
	l=istrip_(mymssg)
	mymssg(l+1:)=', '
	l=l+3
	call idate(m,d,y)
	call iweek_(d,m,y+1900,ds,txt,1,erro)
	tonto=mod(s,10)
	if (h.ge.22.and.h.lt.6.and.
     1      (s.gt.30.and.s.lt.40)) tonto=12
	if (ds.eq.6) tonto=tonto+1
	mymssg(l:)=mbyeby(tonto)(1:)
c
	return					!return
c
c	errors
c	======
c
c	formats
c	=======
c
	end
c
c
c
c
