	SUBROUTINE UC_(STRING)
C	**********************
C
	IMPLICIT NONE
C
C	DESCRIPTION
C	===========
C
C	Given a STRING, lower case letters are changed
C	into upper case. Usable in file   or  data bag
C	names.
C
C	VAR
C	===
C
	external istrip_
	integer istrip_
C	INTEGER LIM,IC
	CHARACTER*(*) STRING
C	CHARACTER*1 VOCAB(0:25),UPC
C
C	DATA VOCAB/'A','B','C','D','E','F','G','H','I',
C     1            'J','K','L','M','N','O','P','Q','R',
C     1            'S','T','U','V','W','X','Y','Z'/
C
C	BEGIN
C	=====
C
C	LIM=ISTRIP_(STRING)
C	IF (LIM.LE.0) RETURN
C	DO 1001 K=1,LIM
C	  IC=ICHAR(STRING(K:K))-ICHAR('a')
C	  IF (IC.GE.0.AND.IC.LE.25) THEN
C	    UPC=VOCAB(IC)
C	    STRING(K:K)=UPC
C	  ENDIF
C1001	CONTINUE
C
C	------------------------------
C	THIS IS THE VAX IMPLEMENTATION
C
	CALL STR$UPCASE(STRING,STRING)
C
C	------------------------------
C
	RETURN
C
C
	END
C
C
C
C
	SUBROUTINE UC8TO7_(STRING)
C	**************************
C
	IMPLICIT NONE
C
C	DESCRIPTION
C	===========
C
C	Given a STRING, lower case letters are changed
C	into upper case, and 8 bit characters are changed
c	into 7 bits. Usable in text sorting, to allow use of
C	multinational character set.
C
C	VAR
C	===
C
	EXTERNAL ISTRIP_
	INTEGER ISTRIP_
	integer lim,k,ic,i
C	INTEGER LIM,IC
	CHARACTER*(*) STRING
C	CHARACTER*1 VOCAB(0:25),UPC
C
C	DATA VOCAB/'A','B','C','D','E','F','G','H','I',
C     1            'J','K','L','M','N','O','P','Q','R',
C     1            'S','T','U','V','W','X','Y','Z'/
C
c
	character*1 table(191:255)
	data
	1	 table(191)/'?'/
	1	(table(i),i=192,198)/7*'A'/
	1	 table(199)/'C'/
	1	(table(i),i=200,203)/4*'E'/
	1	(table(i),i=204,207)/4*'I'/
	1	 table(208)/' '/
	1	 table(209)/'N'/
	1	(table(i),i=210,216)/7*'O'/
	1	(table(i),i=217,220)/4*'U'/
	1	 table(221)/'Y'/
	1	 table(222)/' '/
	1	 table(223)/'s'/
	1	(table(i),i=224,230)/7*'a'/
	1	 table(231)/'c'/
	1	(table(i),i=232,235)/4*'e'/
	1	(table(i),i=236,239)/4*'i'/
	1	 table(240)/' '/
	1	 table(241)/'n'/
	1	(table(i),i=242,248)/7*'o'/
	1	(table(i),i=249,252)/4*'u'/
	1	 table(253)/'y'/
	1	 table(254)/' '/
	1	 table(255)/' '/
c
C	BEGIN
C	=====
C
	lim= istrip_(string)
	if (lim.le.0) return
c
C	DO 1001 K=1,LIM
C
C	  IC=ICHAR(STRING(K:K))-ICHAR('a')
C	  IF (IC.GE.0.AND.IC.LE.25) THEN
C	    UPC=VOCAB(IC)
C	    STRING(K:K)=UPC
C	  ENDIF
c
c	  if (ic .ge. 191) then
c	    string(k:k) = table(ic)
c	  else
c	    nothing to do
c	  endif
C
C1001	CONTINUE
C
C	------------------------------
C	THIS IS THE VAX IMPLEMENTATION
C
	CALL STR$UPCASE(STRING(1:LIM),STRING(1:LIM))
C
	do k=1 ,lim
	   ic = ichar (string(k:k))
	   if (ic .ge. 191) then
	      string(k:k) = table(ic)
	   else
c	      nothing to do
	   endif
	enddo
c
c
	return
c
	end
c
c
c
c
	subroutine lc_(string)
c	*********************
c
	implicit none
c
	character*(*) string
c
c	Given a STRING letters are changed into lower case.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	character*1 ch
	integer l,k
c
c	begin
c	=====
c
	l=istrip_(string)
	do 1001 k=1,l
	   ch=string(k:k)
	   if (ch.ge.'A'.and.ch.le.'Z') then
	      ch=char(ichar(ch)+(ichar('a')-ichar('A')))
	      string(k:k)=ch
	   endif
1001	continue
c
	return
c
c
	end
c
c
c
c
	
	subroutine newc_(chan)
c	**********************
c
	implicit none
c
	integer chan
c
c	Description
c	===========
c
c	A new  logical  unit  number,  ie, channel number
c	is given by the system in CHAN. See FREEC for the
c	opposite action. If no channels available CHAN is
c	-1.
 
c
c	var
c	===
c
	include 'own:iochn.own'
c
c	begin
c	=====
c
cxcx	call get_lun_(chan)	!intricate code ain't it ?
c
	do chan = curmxio$, 1, -1
	   if (chan.eq.5.or.
	1      chan.eq.6    ) then	!forbiden
c	   don't
	   else
	      if (iochn$(chan).le.0) then
	         iochn$(chan)=1		!got a free chennal
	         return
	      endif
	   endif
	enddo
c
	chan=0				!no free channel
c
	return
c
c
	end
c
c
c
c
	subroutine freec_(chan)
c	***********************
c
	implicit none
c
	integer chan
c
c	Description
c	===========
c
c	The  logical unit number CHAN, ie, channel number
c	is given to the system. See NEWC for the opposite
c	action.
 
c
c	var
c	===
c
	include 'own:iochn.own'
c
c	begin
c	=====
c
cxcx	call free_lun_(chan)	!intricate code ain't it ?
c
	if (chan.le.0.or.
	1   chan.gt.mxioch$ ) return	!no jokes
c
	iochn$(chan)=0			!free channel
	return
c
c
	end
c
c
c
c
	SUBROUTINE NDCTM1_(KEY,TABLE,LI,LS,WHERE,FOUND)
C	***********************************************
C
	IMPLICIT NONE
C
C	DESCRIPTION
C	-----------
 
C	Binary search of KEY in TABLE between indexes
C	LI and LS. If FOUND WHERE gives the index  in
C	TABLE. Otherwise KEY should be between  WHERE
C	and WHERE+1.Note that keys are supposed to be
C	different !!!
 
C	VAR
C	---
 
	INTEGER KEY,TABLE(1)
	INTEGER LI,LS,WHERE
	LOGICAL FOUND
 
	INTEGER BINF,BSUP,MEDI
 
C	BEGIN
C	-----
 
	FOUND=.FALSE.
	IF (KEY.LT.TABLE(LI)) THEN
	   WHERE=LI-1
	ELSE
	   IF (KEY.GT.TABLE(LS)) THEN
	      WHERE=LS
	   ELSE
	      BINF=LI
	      BSUP=LS
	      MEDI=(BINF+BSUP)/2
 
1	      CONTINUE
	      IF ( (BINF.GE.BSUP) .OR. (KEY.EQ.TABLE(MEDI)) ) GOTO 2
	         IF (KEY.LT.TABLE(MEDI)) THEN
	            BSUP=MEDI-1
	         ELSE
	            BINF=MEDI+1
	         ENDIF
	         MEDI=(BINF+BSUP)/2
	      GOTO 1
2	      CONTINUE
 
	      IF (KEY.EQ.TABLE(MEDI)) THEN
	         WHERE=MEDI
	         FOUND=.TRUE.
	      ELSE
	         IF (KEY.LT.TABLE(BINF)) THEN
	            WHERE=BINF-1
	         ELSE
	            WHERE=BINF
	         ENDIF
	      ENDIF
	   ENDIF
	ENDIF
 
	RETURN
 
	END
C
C
C
C
	SUBROUTINE NSORT0_(LI,LS,ARRAY)
C	*******************************
C
	IMPLICIT NONE
C
C	DESCRIPTION
C	-----------
 
C	NON-RECURSIVE QUICK SORT OF ARRAY BETWEEN
C	LI AND LS.
 
C	VAR
C	---
 
	INTEGER ARRAY(1),PIVOT,REFER
	INTEGER LI,LS
	INTEGER L,R,S,I,J
	INTEGER STKL(500),STKR(500)
 
C	BEGIN
C	-----
 
	S=1
	STKL(1)=LI
	STKR(1)=LS
 
1	CONTINUE		!REPEAT
	   L=STKL(S)
	   R=STKR(S)
	   S=S-1
 
2	   CONTINUE		!REPEAT
	      I=L
	      J=R
	      REFER=ARRAY((L+R)/2)
 
3	      CONTINUE		!REPEAT
C
cwhile	         DO WHILE (ARRAY(I).LT.REFER)
1098	         continue
	            if (ARRAY(I).GE.REFER) goto 1099
c
	            I=I+1
c
	            goto 1098
1099	         continue
cwhile	         ENDDO
C
cwhile	         DO WHILE (ARRAY(J).GT.REFER)
1096	         continue
	            if (ARRAY(J).LE.REFER) goto 1097
c
	            J=J-1
c
	            goto 1096
1097	         continue
cwhile	         ENDDO
C
	         IF (I.LE.J) THEN
	            PIVOT=ARRAY(I)
	            ARRAY(I)=ARRAY(J)
	            ARRAY(J)=PIVOT
	            I=I+1
	            J=J-1
	         ENDIF
	      IF(I.LE.J)GOTO 3	!UNTIL I > J
 
	      IF ( (J-L).LT.(R-I) ) THEN
	         IF (I.LT.R) THEN
	            S=S+1
	            STKL(S)=I
	            STKR(S)=R
	         ENDIF
	         R=J
	      ELSE
	         IF (L.LT.J) THEN
	            S=S+1
	            STKL(S)=L
	            STKR(S)=J
	         ENDIF
	         L=I
	      ENDIF
 
	   IF(L.LT.R)GOTO 2	!UNTIL L >= R
 
	IF(S.NE.0)GOTO 1	!UNTIL S=0
 
	RETURN
 
	END
C
C
C
C
