c	DBAGS.FOR
c	*********
c
c	Written by Luis Arriaga da Cunha 1984
c
c
c	Miscellaneous facillities for VEDIT screen record editor
c
c	Summary of the procedures:
c
c	padcmd(chn,what,nxt,erro)
c	xscreen(mode,curlin,curpos,endc,pad,ring,msg,msz,pics,
c	xljump(mode,lpos,cpos,jump,endc,pad,ring,
c	xcjump(mode,lpos,cpos,jump,endc,pad,ring,
c	xpage(mode,lin,begin,top,start,size,endc,pad,ring,
c	xcolon(endc,pad,ring,right,l,c,blink)
c	xinit(endc,pad,ring,blink)
c	telhim(l,c,msg,edtlin)
c	pretty(endc,pad,ring,pics,l,c,txt,ln,blink)
c	stdhlp(type,msg)
c	notimp(l,c,edtlin)
c
c
c
	subroutine xscreen_(mode,curlin,curpos,endc,pad,ring,msg,msz,pics,
     1                      page,used,top,start,size,cursor,
     1                      margin,blink)
c	****************************************************************
c
	implicit none
c
	integer mode,curlin,curpos,msz(*),pics(*)
	integer used,top,start,size,cursor,margin,blink(*)
	character*1 endc,pad,ring
	character*(*) msg(*),page(*)
c
c	Description
c	===========
c
c	Given PAGE used up  to USED  and e "new" current line position
c	CURLIN  the  screen  is  perhaps  re-arranged  with the cursor
c	moved or some scrolling done.CURSOR comes in as the old cursor
c	position and goes back as new.MARGIN tells he margin that asks
c	already  for  scrolling . In  START,SIZE  the dimension of the
c	screen  is given.  TOP  is the first line of PAGE shown on the
c	screen. It might go back changed.
c
c	const
c	=====
c
c	var
c	===
c
	external lstrip_
	integer lstrip_
	integer bottm,newcur,right
	integer safe
	integer k,l,m,lim,jump,mp
	character*132 tmp
c
c	begin
c	=====
c
	bottm=top+size-start
	if (bottm.gt.used) bottm=used
	safe=size-margin
c
	newcur=curlin-top+start
	jump=abs(newcur-cursor)
	if (jump.gt.0) then
c
	   if (newcur.gt.safe) then
	      if ((bottm+jump).gt.used) then
	         jump=used-bottm
	         if (jump.eq.0) goto 100
	      endif
	      if (jump.lt.size) then
	         call set_cursor_(size,1)
	         do 1001 k=1,jump
	            l=k+bottm
	            lim=lstrip_(page(l))
	            call up_scroll_
	            m=msz(l)
	            if (m.gt.0) then
	               tmp(1:)=msg(l)(1:m)
	               call put_screen_(tmp(1:m),size,1,0)
	            endif
	            tmp(1:)=page(l)(1:lim)
	            right=m+lim+1
	            if (lim.eq.1.and.tmp(1:1).eq.' ') right=right-1
	            m=m+1
	            mp=m+pics(l)
	            call put_screen_(tmp(1:lim),size,m,blink(l))
	            call xcolon_(endc,pad,ring,right,size,mp,blink(l))
1001	         continue
	         top=top+jump
	      else
	         top=top+jump
	         call xpage_(mode,top,start,top,start,size,endc,pad,ring,
     1                      msg,msz,pics,page,used,blink)
	      endif
	      bottm=bottm+jump
	   else
	      if (newcur.lt.(margin+start) ) then
	         if ((top-jump).lt.1) then
	            jump=top-1
	            if (jump.eq.0) goto 100
	         endif
	         if (jump.lt.size) then
	            call set_cursor_(start,1)
	            do 1002 k=1,jump
	               l=top-k
	               lim=lstrip_(page(l))
	               call down_scroll_
	               m=msz(l)
	               if (m.gt.0) then
	                  tmp(1:)=msg(l)(1:m)
	                  call put_screen_(tmp(1:m),start,1,0)
	               endif
	               tmp(1:)=page(l)(1:lim)
	               right=m+lim+1
	               if (lim.eq.1.and.tmp(1:1).eq.' ') right=right-1
	               m=m+1
	               mp=m+pics(l)
	               call put_screen_(tmp(1:lim),start,m,blink(l))
	               call xcolon_(endc,pad,ring,right,start,mp,blink(l))
1002	            continue
	            top=top-jump
	         else
	            top=top-jump
	            call xpage_(mode,top,start,top,start,size,endc,pad,ring,
     1                         msg,msz,pics,page,used,blink)
	         endif
	         bottm=bottm-jump
	      endif
	   endif
c
	endif
c
100	continue
c
	if (mode.ne.4.and.mode.ne.5.and.
     1      mode.ne.6.and.mode.ne.1.and.
     1      mode.ne.10.and.mode.ne.7.and.
     1      mode.ne.9.and.mode.ne.10.and.
     1      mode.ne.8) then
	   if (bottm.eq.used) then
 	      call put_screen_('[EOR]',bottm-top+start+1,1,0)
	   else
	      call put_screen_('     ',bottm-top+start+1,1,0)
	   endif
	endif
c
	cursor=curlin-top+start
	call set_cursor_(cursor,curpos+msz(curlin))
c
	return
c
c
	end
c
c
c
c
	subroutine xljump_(mode,lpos,cpos,jump,endc,pad,ring,
     1                    msg,msz,page,used,blink,edtlin,erro)
c	******************************************************
c
	implicit none
c
	external lstrip_,istrip_
	integer lstrip_,istrip_
	integer mode,lpos,cpos,jump,msz(*),used,blink(*),edtlin,erro
	character*1 endc,pad,ring
	character*(*) msg(*),page(*)
c
c	Description
c	===========
c
c	Given a old line position LPOS corresponding to a
c	column position CPOS, and a JUMP of lines in PAGE
c	that is used up to USED, a  new legitimate  value
c	for LPOS, CPOS  is found,  checked and given back.
c	If MODE =0 messages are displayed, if 1 they  are
c	not.
c
c	var
c	===
c
	integer n,m,right
	external tty_putc_
	character*1 bell
c
c	begin
c	=====
c
	bell=char(7)
	erro=0
	lpos=lpos+jump
	if (lpos.lt.1) then
	   lpos=1
	   if (mode.eq.0) then
	      call tty_putc_(bell)
	      call put_screen_('Backup past top of record',edtlin,1,2)
	   endif
	   erro=1
	else
	   if (lpos.gt.used) then
	      lpos=used
	      if (mode.eq.0) then
	         call tty_putc_(bell)
	         call put_screen_('Reached end of record',
     1                               edtlin,1,2)
	      endif
	      erro=2
	   else
	      call erase_line_(edtlin,1)
	   endif
	endif
	if     (cpos.le.1) then
	   cpos=+1
	elseif (lstrip_(page(lpos)).le.0) then	!empty line, pos=+1!!!
	   cpos=+1
	else
	   n=lstrip_(page(lpos))+1
	   if (cpos.gt.n) then
	      cpos=n
	   endif
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine xcjump_(mode,lpos,cpos,jump,endc,pad,ring,
     1                    msg,msz,page,used,blink,edtlin,erro)
c	******************************************************
c
	implicit none
c
	external lstrip_
	integer lstrip_
	integer mode,lpos,cpos,jump,msz(*),used,blink(*),edtlin,erro
	character*1 endc,pad,ring
	character*(*) msg(*),page(*)
c
c	Description
c	===========
c
c	Given a old column position CPOS corresponding to a
c	line  position  LPOS, and a JUMP of columns in PAGE
c	that is used up to USED,   a  new legitimate  value
c	for LPOS,  CPOS  is  found,  checked and given back.
c
c	var
c	===
c
	integer n,here,right
c
c	begin
c	=====
c
	erro=0
	if (cpos.gt.len(page(lpos))) then
	   jump=0
	else
	   cpos=cpos+jump
	endif
	if (cpos.lt.1) then
	   here=-1
	   call xljump_(mode,lpos,cpos,here,endc,pad,ring,
     1                 msg,msz,page,used,blink,edtlin,erro)
	   if (erro.eq.0) then
	      cpos=lstrip_(page(lpos))+1
	   endif
	else
	   if (cpos.gt.lstrip_(page(lpos))+1 ) then
	      here=1
	      call xljump_(mode,lpos,cpos,here,endc,pad,ring,
     1                    msg,msz,page,used,blink,edtlin,erro)
	      if (erro.eq.0) then
	         cpos=1
	      endif
	   else
	      here=0
	      call xljump_(mode,lpos,cpos,here,endc,pad,ring,
     1                    msg,msz,page,used,blink,edtlin,erro)
	   endif
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine xpage_(mode,lin,begin,top,start,size,endc,pad,ring,
     1                   msg,msz,pics,page,used,blink)
c	********************************************************
c
	implicit none
c
	integer mode,lin,begin,top,start,size,msz(*),pics(*),used,blink(*)
	character*1 endc,pad,ring
	character*(*) msg(*),page(*)
c
c	Description
c	***********
c
c	Given a PAGE with upper limit USED  it  is displayed
c	at  the screen  (which  is START: SIZE) from  LIN in
c	the PAGE and BEGIN in the screen.
c
c	var
c	===
c
	external lstrip_,istrip_
	integer lstrip_,istrip_
	integer max,lim,k,m,j,offset,mp,right
	character*132 tmp
c
c	begin
c	=====
c
	lim=size
	offset=lin-begin
	if ((lim+offset).gt.used) lim=used-offset
	do 1001 j=begin,lim
	      call set_cursor_(j,1)
	      k=j+offset
	      max=lstrip_(page(k))
	      call erase_line_(j,1)
	      m=msz(k)
	      if (m.gt.0) then
	         tmp(1:)=msg(k)(1:m)
	         call put_screen_(tmp(1:m),j,1,0)
	      endif
	      tmp(1:)=page(k)(1:max)
	      right=m+max+1
	      if (max.eq.1.and.tmp(1:1).eq.' ') right=right-1
	      m=m+1
	      mp=m+pics(k)
	      call put_screen_(tmp(1:max),j,m,blink(k))
	      call xcolon_(endc,pad,ring,right,j,mp,blink(k))
1001	continue
c
	return
c
c
	end
c
c
c
c
	integer function lstrip_(txt)
c	****************************
c
	implicit none
c
	character*(*) txt
c
c	Description
c	===========
c
c	Small variant of istrip_. When lim is zero a space
c	is  invented  in  TXT and LIM becomes one. Also a
c	space  is inserted  at  lim+1 and a null at lim+2.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer lim,l
c
c	begin
c	=====
c
	l=len(txt)
	lim=istrip_(txt)
	if (lim.ge.l-1) lim=l-2
	txt(lim+1:lim+1)=' '
	txt(lim+2:lim+2)=char(0)
	if (lim.eq.0) lim=1
	lstrip_=lim
c
	return
c
c
	end
c
c
c
c
	subroutine xcolon_(endc,pad,ring,right,l,c,blink)
c	************************************************
c
	implicit none
c
	character*1 endc,pad,ring
	integer l,c,blink,right
c
c	Description
c	===========
c
c	Tells the user, at position L, C of the screen
c	the  terminator  character ENDC . Also the PAD
c	character  pads  the line up to the terminator.
c	RIGHT is the maximum rightmost position of the
c	line, including a possible message.
c
c	var
c	===
c
	integer k,j
	character*400 tmp
c
c	begin
c	=====
c
	if (c.ge.1000) c=mod(c,1000)
	if (c.ge.right) then
	   k=1
	   do 1001 j=right,c-1
	      tmp(k:k)=pad
	      k=k+1
1001	   continue
	   tmp(k:k)=endc
	   call put_screen_(tmp(1:k),l,right,0)
	endif
	return
c
c
	end
c
c
c
c
	subroutine xinit_(endc,pad,ring,blink)
c	*************************************
c
	implicit none
c
	character*1 endc,pad,ring
	integer blink
c
c	Description
c	===========
c
c	Reads  from a file name BAG:VEDIT.INI the following items.
c	ENDC  the character to mark the end of each line. PAD the
c	character to  show  the  space that left up to the end of
c	the line. RING , tipically  bell ,  will warn if over the
c	end of line. Blink will tell display characteristics, see
c	VAX Manual 6-A, page 3-7.
c
c	====>> Not used anymore, call VEDINI instead_ (module DBAGD) <<====
c
c	var
c	===
c
	integer i,ascii
	logical itdoes
c
c	begin
c	=====
c
	inquire(file='VEDIT.INI',exist=itdoes)
	if (itdoes) then
	   call newc_(i)
	   if (i.le.0) goto 10
	   open(unit=i,file='VEDIT.INI',status='old',
     1     readonly,carriagecontrol='list',err=10)
	   read(i,'()')	!header for nothing
	   read(i,*,end=10)endc
	   read(i,*,end=10)pad
	   read(i,*,end=10)ascii
	   read(i,*,end=10)blink
	   ring=char(ascii)
	   close(i)
	   call freec_(i)
	   i=0					!just in case...
	else
10	   continue	!structured programming, hem ?!
	   endc =':'	!default values
	   pad  ='_'
	   ring =char(7)
	   blink=2
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine telhim_(l,c,msg,edtlin)
c	*********************************
c
	implicit none
c
	integer l,c,edtlin
	character*(*) msg
c
c	Description
c	===========
c
c	Tells  the  user, at  the bottom line of the silver screen
c	the text MSG. After that it returns to the cursor position
c	L, C !!!
c
c	var
c	===
c
	character*1 bell
	integer lim,istrip_
c
c	begin
c	=====
c
	bell=char(7)
	lim=istrip_(msg)
	if (lim.le.0) lim=1
	call tty_putc_(bell)
	call put_screen_(msg(1:lim),edtlin,1,2)
	call set_cursor_(l,c)
	return
c
c
	end
c
c
c
c
	subroutine pretty_(endc,pad,ring,pics,l,c,txt,ln,blink)
c	******************************************************
c
	implicit none
c
	integer pics,l,c,ln,blink
	character*1 endc,pad,ring
	character*(*) txt
c
c	Description
c	===========
c
c	Rewrites TXT at the screen position L,C. The up to
c	then  current length  LN  is possibly modified, so
c	it might be given back CHANGED !!!
c
c	var
c	===
c
	external lstrip_
	integer lstrip_
	integer lx,lim,right
c
c	begin
c	=====
c
	lx=lstrip_(txt)
	if (lx.lt.ln) then
	   txt(lx+1:ln)=' '
	   lim=ln
	else
	   lim=lx
	endif
	call erase_line_(l,c)
	call put_screen_(txt(1:lim),l,c,blink)
	right=lim+c
	if (lim.eq.1.and.txt(1:1).eq.' ') right=right-1
	lim=pics+c
	call xcolon_(endc,pad,ring,right,l,lim,blink)
	call set_cursor_(l,c)
	ln=lx
	return
c
c
	end
c
c
c
c
	subroutine stdhlp_(type,msg)
c	****************************
c
	implicit none
c
	integer type
	character*(*) msg
c
c	Description
c	===========
c
c	Returns in MSG standard help message for field type TYPE.
c	If type is unknown, it is returned = 0 and MSG = "No help ...".
c	Remember TYPE may be = 40 or 60 or 80 + type for "special"
c	fields...
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	character*80 hlpmsg(ftmax$)
	logical msgdon/.false./
	integer mytype,k,tmax/1/
c
c	begin
c	=====
c
	if (.not.msgdon) then		!do it just once
	   msgdon=.true.
c
	   do 1001 k = 1, ftmax$	!just in case ...
	      write (hlpmsg(k),10000)	!no help, sorry ...
1001	   continue
c
	   write (hlpmsg(n$),10001)	!help message for integer
	   write (hlpmsg(c$),10002)	!string
	   write (hlpmsg(db$),10003)	!other data base
	   write (hlpmsg(x$),10004)	!decimal
	   write (hlpmsg(d$),10005)	!date
	   write (hlpmsg(l$),10006)	!logical
	   write (hlpmsg(r$),10007)	!real
	   write (hlpmsg(r8$),10008)	!double precision
	endif
c
	if     (type.ge.80) then
	   mytype=type-80
	elseif (type.ge.60) then
	   mytype=type-60
	elseif (type.ge.40) then
	   mytype=type-40
	else
	   mytype=type
	endif
c
	if (mytype.lt.1.or.
     1      mytype.gt.ftusr$) then
	   type=0			!unknown type
	   write (msg,10000)		!no help, sorry ... (just in case...)
	   return
	else
	   msg(1:)=' '			!return help message
	   msg=hlpmsg(mytype)		!...
	   return
	endif
c
c	Formats
c	=======
c
	include 'fmt:stdhlp.fmt'
c
c
c
c
	end
c
c
c
c
	subroutine notimp_(l,c,edtlin)
c	*****************************
c
	implicit none
c
	integer l,c,edtlin
c
c	Description
c	===========
c
c	Tells the user, at position L, C of the screen
c	the  enlightening  message  "not  implemented".
c
c	var
c	===
c
	character*1 bell
c
c	begin
c	=====
c
	bell=char(7)
	call tty_putc_(bell)
	call put_screen_('Sorry, not implemented...',edtlin,1,6)
	call set_cursor_(l,c)
	return
c
c
	end
c
c
c
c
	subroutine padcmd_(chn,what,nxt,erro)
c	************************************
c
	implicit none
c
	integer chn,what,nxt,erro
c
c	Description
c	===========
c
c	"Keypad Editing Commands" are tentatively recognized.
c	These  commands  include  keypad  proper, ie  escape
c	sequences, and  other assorted commands as backspace,
c	delete, ^Z, etc.
c
c	If no commnad can be understood WHAT=0 !!
c
c	Scanning  goes  fron  channel CHN, result is in WHAT,
c	see below. In NXT the  lookahead  character is given
c	back  IF  THE COMMAND IS JUST GOLD, OR NO COMMAND IS
c	RECOGNIZED. Otherwise there is	NO LOOKAHEAD.
c
c	Keypad commands are recognized by scanning AFTER the
c	altmode, (  this latter has beeen swallowed already).
c
c	ACHTUNG!!!  Characters,  here, are their ascii codes.
c
c	Commands are numbered as follows:
c
c	NO COMMAND 0    AFTER ALL !!!
c	^	   1	up arrow
c	\/	   2	down arrow (what a horrible drawing!)
c	<	   3	right arrow
c	>	   4	left arrow
c	gold	   5    never happens
c	help	   6
c	fndnxt	   7
c	del l	   8
c	page	   9
c	sect	  10
c	append	  11
c	del w	  12
c	advance	  13
c	backup	  14
c	cut	  15
c	del c	  16
c	word	  17
c	eol	  18
c	char	  19
c	enter	  20
c	line	  21
c	select	  22
c	--	  23
c	help	  24
c	find	  25
c	und l	  26
c	command	  27
c	fill	  28
c	replace	  29
c	und w	  30
c	bottom	  31
c	top	  32
c	paste	  33
c	und c	  34
c	chngcas	  35
c	del eol	  36
c	specins	  37
c	open line 38
c	reset	  39
c	subs	  40
c	^Z	  41
c	backspace 42
c	delete    43
c
c	previous screen	44	!gold ^ ,  non EDT command
c	next screen	45	!gold \/,  non EDT command
c	move right	46	!gold > ,  non EDT command
c	move left	47	!gold < ,  non EDT command
c
c	Extra keypad
c
c	FIND		48
c	INSERT		49
c	REMOVE		50
c	SELECT		51
c	PREV SCREEN	52
c	NEXT SCREEN	53
c
c	F's
c
c	F7		54
c	F8		55
c	F9		56
c	F10		57
c	F11		58
c	F12		59
c	F13		60
c	F14		61
c	F15		62
c	F16		63
c	F17		64
c	F18		65
c	F19		66
c	F20		67
c
c	Extra extra extra
c
c	PAGE HOME	68
c
c	var
c	===
c
	integer arrset,offset,
     1   	altmod/27/,ctrlz/26/,bkspc/8/,dele/127/,
     1          ch0,chr,ch1,ch2,tty_getc_
	integer keycnv(77:121)
	data keycnv/
     1   	20,0,0,
     1   	5,6,7,8,0,0,0,0,
     1   	0,0,0,0,0,0,0,0,
     1   	0,0,0,0,0,0,0,0,
     1   	0,0,0,0,16,12,22,0,
     1   	21,17,18,19,13,14,15,9,10,11/
	integer f7thf8(56:57)
	data f7thf8/54,55/
	integer f9thf16(48:57)
	data f9thf16/56,57,0,58,59,60,61,0,62,63/
	integer f17thf20(49:52)
	data f17thf20/64,65,66,67/
c
c	begin
c	=====
c
	erro=0
	what=0
	arrset=0	!for GOLD/NON-GOLD arrow commands
	offset=0	!for GOLD/NON-GOLD commands
c
c	see first character
c
	ch0=tty_getc_()
cx	write (6,'('' ch:'',i4)') ch0
	nxt=ch0
c
	if (ch0.eq.altmod) then
c	************************
c
1	   continue	!reenter point if gold command
c
	   chr=tty_getc_()
cx	   write (6,'('' ch:'',i4)') chr
	   ch1=tty_getc_()
cx	   write (6,'('' ch:'',i4)') ch1
c
	   if ( chr.eq.ichar('[').or.chr.eq.ichar('?') ) then
c
cx	      if (ch1.lt.65.or.ch1.gt.68) goto 990	!error (< 'A' or > 'D' )
c
	      if     (ch1.ge.65.and.ch1.le.68) then
c
c	         arrow commands
c	         --------------
c
	         what=ch1-64	!should be (ichar('A')+1) !!!
	         what=what+arrset
c
	      elseif (ch1.eq.72) then			!extra "PAGE HOME"
	         what=68
c
	      elseif (ch1.ge.48.and.ch1.le.57) then	!extra keypad or F's
c
	         ch2=tty_getc_()
cx	         write (6,'('' ch:'',i4)') ch2
c
	         if (ch2.eq.ichar('~')) then		!e.k. ends with '~'
c
	            if (ch1.lt.49.or.ch1.gt.54) goto 990	!error
c
c	            extra keypad
c	            ------------
c
	            what=ch1-1
c
	         else
c
	            if ((ch2.ge.48.and.ch2.le.54).or.
     1                   ch2.eq.56.or.ch2.eq.57     ) then
c
	               ch0=tty_getc_()
cx	               write (6,'('' ch:'',i4)') ch0
c
	               if (ch0.eq.ichar('~')) then	!p.f. ends with '~'
c
	                  if (ch1.lt.49.or.ch1.gt.51) goto 990	!error
c
	                  if (ch1.eq.49) then
	                     if (ch2.lt.56.or.ch2.gt.57) goto 990
	                     what=f7thf8(ch2)
	                  endif
c
	                  if (ch1.eq.50) then
	                     if (ch2.lt.48.or.ch2.gt.57) goto 990
	                     if (ch2.eq.50) goto 990	!error
	                     if (ch2.eq.55) goto 990	!error
	                     what=f9thf16(ch2)
	                  endif
c
	                  if (ch1.eq.51) then
	                     if (ch2.lt.49.or.ch2.gt.52) goto 990
	                     what=f17thf20(ch2)
	                  endif
c
	               else
c
	                  goto 990			!error
c
	               endif
c
	            else
c
	               goto 990				!error
c
	            endif
c
	         endif
c
	      else
c
	         goto 990				!error
c
	      endif
c
	   else
c
c	      pad commands proper
c	      -------------------
c
	      if (chr.ne.ichar('O')) goto 990	!error
	      if (ch1.eq.ichar('P')) then
c
c	         GOLD
c	         ----
c
	         chr=tty_getc_()
cx	         write (6,'('' ch:'',i4)') chr
	         if (chr.eq.altmod) then
	            offset=18
	            arrset=43
	            goto 1
	         else
	            what=0
	            nxt=chr
	            return
	         endif
c
	      else
c
c	         NON-GOLD
c	         --------
c
	         if (ch1.lt.77.or.ch1.gt.121) goto 990	!error not (M...y)
c
	         what=keycnv(ch1)
	         if (what.eq.0) goto 990			!error
c
	         what=what+offset
c
	      endif
c
	   endif
c
	else
c	************************
c
	   if (ch0.eq.ctrlz) then
	      what=41
	   else
	      if (ch0.eq.bkspc) then
	         what=42
	      else
	         if (ch0.eq.dele) then
	            what=43
	         endif
	      endif
	   endif
c
	endif
c	************************
c
c	normal return
c
	return
c
c	error return
c
990	continue
	what=0
	return
c
c
	end
c
c
c
c
